<?php
set_time_limit(300); 
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");
require_once('/qtux/library/phplot-6.1.0/phplot.php');

$sDSN  = "/qtux/database/gps_producao/gps_01.gdb";

$hDb = fhDbConnect($sDSN);

$sSql    = "select cast (a.tIn0 as date)       as Data,
                   extract(year   from a.tIn0) as Ano,
                   extract(month  from a.tIn0) as Mes,
                   extract(day    from a.tIn0) as Dia,
                   extract(hour   from a.tIn0) as Hora,
                   extract(minute from a.tIn0) as Minuto,
                   count(*),
                   avg((a.nTopIni+a.nTopFin)/2)

              from SysJobs a
             where a.lExc    = 0
               and a.iVer  = a.iVAt
               and cast (a.tIn0 as date) =  '06/May/2014'

             group by
                   cast (a.tIn0 as date),
                   extract(year   from a.tIn0),
                   extract(month  from a.tIn0),
                   extract(day    from a.tIn0),
                   extract(hour   from a.tIn0),
                   extract(minute from a.tIn0)
             order by
                   extract(year   from a.tIn0) ,
                   extract(month  from a.tIn0) ,
                   extract(day    from a.tIn0) ,
                   extract(hour   from a.tIn0) ,
                   extract(minute from a.tIn0)";

$aDb    = faDbSelect($hDb,$sSql);

$aCount = array();
/*
foreach ($aDb as $aLin) {
   $aCount[] = array('',$aLin[6],$aLin[7]);
}

$plot = new PHPlot(800, 600);
//$plot->SetImageBorderType('plain');

$plot->SetPlotType('lines');
//$plot->SetDataType('data-data');
$plot->SetDataValues($aCount);

# Main plot title:
$plot->SetTitle('Grfico Count - AVG');

# Make a legend for the 2 functions:
$plot->SetLegend(array('Count', 'AVG'));

# Select a plot area and force ticks to nice values:
//$plot->SetPlotAreaWorld(0, 0, 6.8, 1);

# Even though the data labels are empty, with numeric formatting they
# will be output as zeros unless we turn them off:
$plot->SetXDataLabelPos('none');

# Draw both grids:
$plot->SetDrawXGrid(True);
$plot->SetDrawYGrid(True);

$plot->DrawGraph();
*/
$aAVG = array();
foreach ($aDb as $aLin) {
   $aCount[] = array($aLin[0],$aLin[6]);
   $aAVG[] = array('',$aLin[7]);
}

    $plot = new PHPlot(650, 450);
    $plot->SetTitle('Grfico AVG');
//    $plot->SetDataType('data-data');
    $plot->SetDataValues($aAVG);
    $plot->SetLegend(array('AVG'));
    $plot->SetLegendPixels(720, 30); // Move legend to upper left
//    $plot->SetYLabelType('data', 2);
//    $plot->SetDrawXGrid(True);
    $plot->SetPlotType('lines');
    $plot->DrawGraph();

?>
