<?php         
ini_set('memory_limit','1024M');
set_time_limit(3600);
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");	

require('/qtux/library/PHPExcel-1.8/Classes/PHPExcel.php');

$oPHPExcel = new PHPExcel();
$oWorksheet = $oPHPExcel->getActiveSheet();
$oWorksheet->fromArray(
 array(
	array('',	2010,	2011,	2012),
	array('Q1',   12,   15,		21),
	array('Q2',   56,   73,		86),
	array('Q3',   52,   61,		69),
	array('Q4',   30,   32,		0),
 )
);
//	Set the Labels for each data series we want to plot
//		Datatype
//		Cell reference for data
//		Format Code
//		Number of datapoints in series
//		Data values
//		Data Marker
$dataSeriesLabels = array(
 new PHPExcel_Chart_DataSeriesValues('String', 'Worksheet!$B$1', NULL, 1),	//	2010
 new PHPExcel_Chart_DataSeriesValues('String', 'Worksheet!$C$1', NULL, 1),	//	2011
 new PHPExcel_Chart_DataSeriesValues('String', 'Worksheet!$D$1', NULL, 1),	//	2012
);
//	Set the X-Axis Labels
//		Datatype
//		Cell reference for data
//		Format Code
//		Number of datapoints in series
//		Data values
//		Data Marker
$xAxisTickValues = array(
 new PHPExcel_Chart_DataSeriesValues('String', 'Worksheet!$A$2:$A$5', NULL, 4),	//	Q1 to Q4
);
//	Set the Data values for each data series we want to plot
//		Datatype
//		Cell reference for data
//		Format Code
//		Number of datapoints in series
//		Data values
//		Data Marker
$dataSeriesValues = array(
 new PHPExcel_Chart_DataSeriesValues('Number', 'Worksheet!$B$2:$B$5', NULL, 4),
 new PHPExcel_Chart_DataSeriesValues('Number', 'Worksheet!$C$2:$C$5', NULL, 4),
 new PHPExcel_Chart_DataSeriesValues('Number', 'Worksheet!$D$2:$D$5', NULL, 4),
);
//	Build the dataseries
$series = new PHPExcel_Chart_DataSeries(
                                         PHPExcel_Chart_DataSeries::TYPE_LINECHART,		// plotType
                                         PHPExcel_Chart_DataSeries::GROUPING_STANDARD,	// plotGrouping
                                         range(0, count($dataSeriesValues)-1),			// plotOrder
                                         $dataSeriesLabels,								// plotLabel
                                         $xAxisTickValues,								// plotCategory
                                         $dataSeriesValues								// plotValues
);
//	Set additional dataseries parameters
//		Make it a horizontal bar rather than a vertical column graph
$series->setPlotDirection(PHPExcel_Chart_DataSeries::DIRECTION_BAR);
//	Set the series in the plot area
$plotArea = new PHPExcel_Chart_PlotArea(NULL, array($series));
//	Set the chart legend
$legend = new PHPExcel_Chart_Legend(PHPExcel_Chart_Legend::POSITION_RIGHT, NULL, false);
$title = new PHPExcel_Chart_Title('Test Bar Chart');
$yAxisLabel = new PHPExcel_Chart_Title('Value ($k)');
//	Create the chart
$chart = new PHPExcel_Chart(
 'chart1',		// name
 $title,			// title
 $legend,		// legend
 $plotArea,		// plotArea
 true,			// plotVisibleOnly
 0,				// displayBlanksAs
 NULL,			// xAxisLabel
 $yAxisLabel		// yAxisLabel
);
//	Set the position where the chart should appear in the worksheet
$chart->setTopLeftPosition('A7');
$chart->setBottomRightPosition('H20');
//	Add the chart to the worksheet
$oWorksheet->addChart($chart);
// Save Excel 2007 file
$oWriter = PHPExcel_IOFactory::createWriter($oPHPExcel, 'Excel2007');
$oWriter->setIncludeCharts(TRUE);

$sNomeArquivo = '01_TesteGraficoExcel.xlsx';

header('Content-Type: application/vnd.ms-excel');
header("Content-Disposition: attachment; filename=\"{$sNomeArquivo}\"");
header('Cache-Control: max-age=0');
header('Cache-Control: max-age=1');

$oWriter->save('php://output');
         
