#!/bin/bash

sDate=$(date +%Y%m%d)
sDSAA=/qtux/www/FullPlat/processos/Sistema/crons

if [ "$1" != "" ]; then
   sVer=$1
else
   sVer="a"
fi

aCliPasta[0]="total"

for sCliPasta in "${aCliPasta[@]}"
do

   sDLog=/backupqtux/backupsdb/logs
   sDBKP=/backupqtux/backupsdb
   sDBFSys=/qtux/database/$sCliPasta/db_file_sys

   if [ -d "$sDBKP" ]; then

      sDGOV=192.168.1.109:/qtux/database/$sCliPasta
      sLGOV=$sDate-$sVer-log-bkp-$sCliPasta.log
      sAMFGDB=gps_01.gdb
      sAMF1GBK=$sDate-$sVer-gbk-$sCliPasta.gbk
      sATAR=$sDate-$sVer-gbk-TQ_$sCliPasta.tar

      echo "$(date +%d/%m/%Y" - "%H:%M:%S) | BACKUP $sCliPasta"
      #echo "$(date +%d/%m/%Y" - "%H:%M:%S) | Inicio gfix $sDGOV/$sAMFGDB"
      #gfix -sweep -USER sysdba -PASS 200360 $sDGOV/$sAMFGDB
      echo "$(date +%d/%m/%Y" - "%H:%M:%S) | Inicio gbak $sDGOV/$sAMFGDB | $sDBKP/$sAMF1GBK"
      gbak -B -G -V -Y $sDLog/$sLGOV -USER sysdba -PASS 200360 $sDGOV/$sAMFGDB $sDBKP/$sAMF1GBK

      #gunzip $sATAR
      echo "$(date +%d/%m/%Y" - "%H:%M:%S) | Inicio tar $sDBKP/$sATAR"
      #tar -rf $sATAR ./logs/$sLGOV $sAMF1GBK
      #tar cvfz $sDBKP/$sATAR $sDBKP/logs/$sLGOV $sDBKP/$sAMF1GBK
      tar -cf $sDBKP/$sATAR $sDBKP/logs/$sLGOV $sDBKP/$sAMF1GBK $sDBFSys
      echo "$(date +%d/%m/%Y" - "%H:%M:%S) | Inicio gzip $sDBKP/$sATAR"
      gzip $sDBKP/$sATAR
      echo "$(date +%d/%m/%Y" - "%H:%M:%S) | Inicio terminou, aguardando 60 secs para apagar $sDBKP/$sAMF1GBK"
      sleep 60
      rm $sDBKP/$sAMF1GBK

      iDias=3

      cd $sDSAA
      $sDSAA/Sys_ApagaAntigos.sh $sDBKP "" .tar.gz $iDias
      $sDSAA/Sys_ApagaAntigos.sh $sDLog "" .log $iDias

   fi

done