<?php
/**
  * TDateTime 
  * @Description Calcula a quantidade de dias teis entre duas datas 
  * @author Ademilson Nunes
  */
  
class TDateTime
{    
        /**
        * @param  [String $s = data inicial]
        * @param  [String $e = null ou data final]
        * @param  [array  $holidays = array de feriados]
        * @return [int    $nwd = Quantidade de dias uteis]
        */
        public function networkdays($s, $e, $holidays = array()) 
        {
             $s = strtotime($s);
             $e = strtotime($e);

            if ($s > $e)
                return networkdays($e, $s, $holidays);


            $sd = date("N", $s);
            $ed = date("N", $e);


            $w = floor(($e - $s)/(86400*7));    
            if ($ed >= $sd) { $w--; }       


            $nwd = max(6 - $sd, 0);   
            $nwd += min($ed, 5);    
            $nwd += $w * 5;       


            foreach ($holidays as $h) {
                $h = strtotime($h);
                if ($h > $s && $h < $e && date("N", $h) < 6)
                    $nwd--;
            }                  
            return $nwd;
        }
        
        
        /* mtodo 
         * daysToHours()
         */
        public function daysToHours($days)
        {    
            $date_default = new DateTime('now',
                            new DateTimeZone('America/Sao_Paulo'));
        
             $hours = (($days - 1) * 24) + ($date_default->format('H'));
             return $hours;
        }
       
}
/*Instancia de TDateTime*/
//$date         = new TDateTime();
//$date_default = new DateTime('now',
//                new DateTimeZone('America/Sao_Paulo'));     
//$date_default->getTimestamp();
//$today = $date_default->format('Y-m-d H:i:s');
//
//echo $date->networkdays('2013-02-19 08:23:00', $today) . "<br/>";
//echo $date->daysToHours($date->networkdays('2013-02-19 08:23:00', $today)).":".$date_default->format('i');
////retorna o dia;
////echo intval(((strtotime(date("Y-m-d H:i:s"))-strtotime('2013-02-18 08:00:03'))/3600)/24)."<br/>";
////echo intval((strtotime(date("Y-m-d H:i:s"))-strtotime('2013-02-18 08:00:03'))/3600).":".number_format((((strtotime(date("Y-m-d H:i:s"))-strtotime('2013-02-18 08:00:03'))/3600)-(intval((strtotime(date("Y-m-d H:i:s"))-strtotime('2013-02-18 08:00:03'))/3600)))*60,0)