<?php
set_time_limit(300);
require("/qtux/www/FullPlat/pFuncoes1.php");
require("/qtux/library/phplot-6.1.0/phplot.php");

$sHtml = '';
$aCias = array();

$aCias[] = 'anglopack';
//$aCias[] = 'dm';
$aCias[] = 'engajamento';
$aCias[] = 'hallos';
$aCias[] = 'hallos_esp';
$aCias[] = 'hallos_ing';
//$aCias[] = 'havik';
$aCias[] = 'iddeia';
$aCias[] = 'informatic';
$aCias[] = 'jbs';
$aCias[] = 'mianogames';
$aCias[] = 'montesano_novaV';
//$aCias[] = 'mvip';
$aCias[] = 'salutemed';
$aCias[] = 'security';
$aCias[] = 'sky';
$aCias[] = 'spassogames';
$aCias[] = 'spazio';
$aCias[] = 'sweda';
$aCias[] = 'vitoria';
$aCias[] = 'ziober';

$iAno = date('Y');

foreach ($aCias as $sCia) {
   $aTotais = array();
   $aLeg    = array();

   $sDir = "/qtux/www/logs/contador/$sCia/$iAno";
   if (is_dir($sDir)) {
      for ($i=1;$i<=12;$i++) {
         if ($i<10) {
            $sMes   = "0$i";
            $sPasta = "0$i-$iAno";
            $sDir   = "/qtux/www/logs/contador/$sCia/$iAno/$sPasta/";
         } else {
            $sMes   = "$i";
            $sPasta = "$i-$iAno";
            $sDir = "/qtux/www/logs/contador/$sCia/$iAno/$sPasta/";
         }
         if (is_dir($sDir)) {
             $sArquivo = "$sDir/total_$sPasta.txt";
             if (file_exists($sArquivo)) {
                $aAbrir = fopen($sArquivo, "r");
                $iTotal = fread($aAbrir, filesize($sArquivo));
                $aTotais[] = array($sMes,$iTotal);
                $aLeg[]    = fsNomeMes($sMes).' - '.$iTotal;
             }
         } //else {
           // echo "<b>$sDir</b> <br>";
           // break;
         //}
      }
      $sGrafBarrasAcessosMes = "sGrafBarrasAcessosMes_$sCia.png";
      if (file_exists("/qtux/www/FullPlat/processos/$sGrafBarrasAcessosMes")) {
         unlink("/qtux/www/FullPlat/processos/$sGrafBarrasAcessosMes");
      }

      $oPlot = new PHPlot(1200,500,$sGrafBarrasAcessosMes);

      $oPlot->SetIsInline(true);
      $oPlot->SetDefaultTTFont('/qtux/www/FullPlat/fontes/arial.ttf');
      $oPlot->SetPlotType('bars');
      $oPlot->SetDataType('text-data');
      $oPlot->SetDataValues($aTotais);
      $oPlot->SetTitle('Totais Mensais - '.strtoupper($sCia).' - '.$iAno);
      $oPlot->SetLegendPixels(1020, 0); // Move legend to upper left
      $oPlot->SetCallback('data_color','pickcolor',$aTotais);
      //$oPlot->SetDataColors($aCor);
      $oPlot->SetLegend($aLeg);
      $oPlot->SetYDataLabelPos('plotin');
      $oPlot->SetFontTTF('title', null, 13);
      $oPlot->SetXTickPos('none');
      //$oPlot->SetPlotAreaWorld(NULL, 0, NULL, 10); // Define os valores de 0 a 10
      $oPlot->SetFontTTF('legend', null, 12);

      $oPlot->DrawGraph();
      
      echo "<img src='$sGrafBarrasAcessosMes' />";

   }
}

$aTotais = array();
$aLeg    = array();

foreach ($aCias as $sCia) {
   $sDir = "/qtux/www/logs/contador/$sCia/$iAno";
   if (is_dir($sDir)) {
      $sArquivo = "$sDir/total_$iAno.txt";
      if (file_exists($sArquivo)) {
         $aAbrir = fopen($sArquivo, "r");
         $iTotal = fread($aAbrir, filesize($sArquivo));
         $aTotais[] = array(ucfirst($sCia),$iTotal);
         $aLeg[]    = ucfirst($sCia).' - '.$iTotal;
      }
   }
}

$sGrafBarrasAcessosTotais = "sGrafBarrasAcessosTotais.png";
if (file_exists("/qtux/www/FullPlat/processos/$sGrafBarrasAcessosTotais")) {
   unlink("/qtux/www/FullPlat/processos/$sGrafBarrasAcessosTotais");
}

$oPlot = new PHPlot(1200,500,$sGrafBarrasAcessosTotais);

$oPlot->SetIsInline(true);
$oPlot->SetDefaultTTFont('/qtux/www/FullPlat/fontes/arial.ttf');
$oPlot->SetPlotType('bars');
$oPlot->SetDataType('text-data');
$oPlot->SetDataValues($aTotais);
$oPlot->SetTitle('Totais Anual - '.$iAno);
$oPlot->SetLegendPixels(950, 0); // Move legend to upper left
$oPlot->SetCallback('data_color','pickcolor',$aTotais);
//$oPlot->SetDataColors($aCor);
$oPlot->SetLegend($aLeg);
$oPlot->SetYDataLabelPos('plotin');
$oPlot->SetFontTTF('title', null, 13);
$oPlot->SetXTickPos('none');
//$oPlot->SetPlotAreaWorld(NULL, 0, NULL, 10); // Define os valores de 0 a 10
$oPlot->SetFontTTF('legend', null, 12);

$oPlot->DrawGraph();

echo "<img src='$sGrafBarrasAcessosTotais' />";

function pickcolor($img, $data_array, $row, $col) {
   return $row;
}
?>