<?php


// Prototipo de Layout do relatorio
// Codigo - Item - Unidade - Consumo OP - Perda OP - Perda%
// OP1 - OP2 - Consumo - Perda - NFs

// OP_ConsPerdas   (pCapa)
// -------------
// pCapa
// pOP1
// pOP2
// pItem
// pLote
// pUni
// nCons   18,9
// nPerda  18,9

// OP_NFs  (pCapa,pItem)
// ------
// pCapa
// pOP
// pItem
// pCapa
// pLote
// sNFs


set_time_limit(300);
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");	

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoNome  = str_replace('.','_',$sProc).'-'.$tJobStart.'_'.$_POST["sId"].'.log';
$sEcoTxt = "/qtux/www/FullPlat/processos/logs/$sEcoNome";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);
fpc($sEcoTxt,'Incio em ' . date('d/m/Y G:i:s',$tJobStart));

$aUserLog  = array();

$psCliPasta   = $_POST["sCliPasta"];
$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";

if (file_exists($sFileConfig)) {

   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      if (strlen($sLin)>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         if (count($aLin)>1) $s2 = trim($aLin[1]);
         else                $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);   // criando uma var
         $sVarsTxt .= $s . chr(10);
      }
   }

   $lOk     = true;
   $pDoc    = $_POST["sId"];
   $psRoot  = $_POST["sRoot"];
   $sDSN    = "$sHost:$sPathDB/$sDB";
   $sPathFS = $sPathFileSys;
   $sLogin  = $_POST["sLogin"];
   $sRel='';

   $hDb        = fhDbConnect($sDSN);

   // PROCESSAMENTO RELATORIO
// Dados que alimenta o range via tabela  
   $WhrsSqlPai = "select tEmiDe,tEmiAte,pProp,sPathSaida,jFormato,pImp,iOPDe,iOPAte,sNrOP,tConfDe,tIniDe,tConcDe,tBaixDe,tInuDe,tConfAte,tIniAte,tConcAte,tBaixAte,tInuAte,pUNeg from  RAvancPerdas  where  pPId  = $pDoc and  iVer  = iVAt";
   $hWhrPai    = ibase_query($hDb,$WhrsSqlPai);
   $aLinWhrPai = ibase_fetch_assoc($hWhrPai);
   fpc_append($sEcoTxt,"WhrsSqlPai=$WhrsSqlPai");	

// Variaveis do Range 
   $jFormat     = $aLinWhrPai[strtoupper("jFormato")];	// 1-Visualizar (0)/2-Imprimir (1)/3-Arquivo (2)/4-Texto s/ Formatao (3)
   $dEmiDe      = $aLinWhrPai[strtoupper("tEmiDe")]  !=''  ? date('d-M-Y',strtotime($aLinWhrPai[strtoupper("tEmiDe")]))    : '';
   $dEmiAte     = $aLinWhrPai[strtoupper("tEmiAte")] !=''  ? date('d-M-Y',strtotime($aLinWhrPai[strtoupper("tEmiAte")]))   : '';

   $dConfDe      = $aLinWhrPai[strtoupper("tConfDe")]  !=''  ? date('d-M-Y',strtotime($aLinWhrPai[strtoupper("tConfDe")]))  : '';
   $dIniDe       = $aLinWhrPai[strtoupper("tIniDe")]  !=''  ? date('d-M-Y',strtotime($aLinWhrPai[strtoupper("tIniDe")]))    : '';
   $dConcDe      = $aLinWhrPai[strtoupper("tConcDe")]  !=''  ? date('d-M-Y',strtotime($aLinWhrPai[strtoupper("tConcDe")]))  : '';
   $dBaixDe      = $aLinWhrPai[strtoupper("tBaixDe")]  !=''  ? date('d-M-Y',strtotime($aLinWhrPai[strtoupper("tBaixDe")]))  : '';
   $dInuDe       = $aLinWhrPai[strtoupper("tInuDe")]  !=''  ? date('d-M-Y',strtotime($aLinWhrPai[strtoupper("tInuDe")]))    : '';
                                                                                                              
   $dConfAte     = $aLinWhrPai[strtoupper("tConfAte")]  !=''  ? date('d-M-Y',strtotime($aLinWhrPai[strtoupper("tConfAte")])): '';
   $dIniAte      = $aLinWhrPai[strtoupper("tIniAte")]  !=''  ? date('d-M-Y',strtotime($aLinWhrPai[strtoupper("tIniAte")]))  : '';
   $dConcAte     = $aLinWhrPai[strtoupper("tConcAte")]  !=''  ? date('d-M-Y',strtotime($aLinWhrPai[strtoupper("tConcAte")])): '';
   $dBaixAte     = $aLinWhrPai[strtoupper("tBaixAte")]  !=''  ? date('d-M-Y',strtotime($aLinWhrPai[strtoupper("tBaixAte")])): '';
   $dInuAte      = $aLinWhrPai[strtoupper("tInuAte")]  !=''  ? date('d-M-Y',strtotime($aLinWhrPai[strtoupper("tInuAte")]))  : '';

   $sPathSaida  = $aLinWhrPai[strtoupper("sPathSaida")];
   $pImp        = trim($aLinWhrPai[strtoupper("pImp")]);
   $pProp       = trim($aLinWhrPai[strtoupper("pProp")]);
   $pUNeg       = trim($aLinWhrPai[strtoupper("pUNeg")]);
   $iOPDe       = trim($aLinWhrPai[strtoupper("iOPDe")]);
   $iOPAte      = trim($aLinWhrPai[strtoupper("iOPAte")]);
   $sNrOP       = trim($aLinWhrPai[strtoupper("sNrOP")]);

   fpc_append($sEcoTxt,"jFormat=$jFormat");
   fpc_append($sEcoTxt,"dVencDe=$dVencDe");
   fpc_append($sEcoTxt,"dVencAte=$dVencAte");
   fpc_append($sEcoTxt,"sPathSaida=$sPathSaida");

// montagem do range para filtrar na query principal do relatrio
   $pImp        = trim($aLinWhrPai[strtoupper("pImp")]);
   $sSqlImp = "select sImp from Impressora where pPid=$pImp and iVer = iVAt and lExc=0";
   $aImp = faDbSelect($hDb,$sSqlImp);
   $sImp = '';
   if (strlen($aImp[0][0])>0) {
      $sImp = $aImp[0][0];
   }

   $sRange  = '';
   $sRange1 = '';
   $iRange  = 0;

   //--ITENS
   $sWhrItens  = '';
   $sSqlItens  = "select pItem from RAvancPerdas_Itens where pRAvancP=$pDoc and iVer = iVAt and lExc=0 and pItem<>0";
   $aWhrItens  = faDbSelect($hDb,$sSqlItens);
   foreach ($aWhrItens as $aLin) {
      $sWhrItens .= $aLin[0].',';
   }
   $sWhrItens = (strlen($sWhrItens)>0) ? (' and c.pPId in ('.substr($sWhrItens,0,strlen($sWhrItens)-1).')') : '';
                                            // colocar o alias em questo 
   //--   

   $sWhere = '';

   if ($dEmiDe!='') {
      $sWhere .= " and cast(e.tIn0 as date) >= '$dEmiDe' ";
      $sRange .= "Emisso Inicial a partir de <b>$dEmiDe</b><br>";
      $sRange1.= "Emisso Inicial a partir de $dEmiDe".chr(10);
      $iRange++;
      $dSdoIni = $dEmiDe;
   } else {
      $dSdoIni = '01/01/2010';
   }
   if ($dEmiAte!='') {
      $sWhere   .= " and cast(e.tIn0 as date) <= '$dEmiAte' ";
      $sRange   .= "Emisso Final at <b>$dEmiAte</b><br>";
      $sRange1  .= "Emisso Final at $dEmiAte".chr(10);
      $iRange++;
   }

   if ($dConfDe!='') {
      $sWhere .= " and cast(e.tConf as date) >= '$dConfDe' ";
      $sRange .= "Confirmao Inicial a partir de <b>$dConfDe</b><br>";
      $sRange1.= "Confirmao Inicial a partir de $dConfDe".chr(10);
      $iRange++;
   }

   if ($dConfAte!='') {
      $sWhere   .= " and cast(e.tConf as date) <= '$dConfAte' ";
      $sRange   .= "Confirmao Final at <b>$dConfAte</b><br>";
      $sRange1  .= "Confirmao Final at $dConfAte".chr(10);
      $iRange++;
   }

   if ($dIniDe!='') {
      $sWhere .= " and cast(e.tIni as date) >= '$dIniDe' ";
      $sRange .= "Inicializao Inicial a partir de <b>$dIniDe</b><br>";
      $sRange1.= "Inicializao Inicial a partir de $dIniDe".chr(10);
      $iRange++;
   }
   if ($dIniAte!='') {
      $sWhere   .= " and cast(e.tIni as date) <= '$dIniAte' ";
      $sRange   .= "Inicializao Final at <b>$dIniAte</b><br>";
      $sRange1  .= "Inicializao Final at $dIniAte".chr(10);
      $iRange++;
   }

   if ($dConcDe!='') {
      $sWhere .= " and cast(e.tConc as date) >= '$dConcDe' ";
      $sRange .= "Concluso Inicial a partir de <b>$dConcDe</b><br>";
      $sRange1.= "Concluso Inicial a partir de $dConcDe".chr(10);
      $iRange++;
   }
   if ($dIniAte!='') {
      $sWhere   .= " and cast(e.tConc as date) <= '$dConcAte' ";
      $sRange   .= "Concluso Final at <b>$dConcAte</b><br>";
      $sRange1  .= "Concluso Final at $dConcAte".chr(10);
      $iRange++;
   }

   if ($dBaixDe!='') {
      $sWhere .= " and cast(e.tBaixa as date) >= '$dBaixDe' ";
      $sRange .= "Baixa Inicial a partir de <b>$dBaixDe</b><br>";
      $sRange1.= "Baixa Inicial a partir de $dBaixDe".chr(10);
      $iRange++;
   }
   if ($dBaixAte!='') {
      $sWhere   .= " and cast(e.tBaixa as date) <= '$dBaixAte' ";
      $sRange   .= "Baixa Final at <b>$dBaixAte</b><br>";
      $sRange1  .= "Baixa Final at $dBaixAte".chr(10);
      $iRange++;
   }

   if ($dInuDe!='') {
      $sWhere .= " and cast(e.tInu as date) >= '$dInuDe' ";
      $sRange .= "Inutilizao Inicial a partir de <b>$dInuDe</b><br>";
      $sRange1.= "Inutilizao Inicial a partir de $dInuDe".chr(10);
      $iRange++;
   }
   if ($dInuAte!='') {
      $sWhere   .= " and cast(e.tInu as date) <= '$dInuAte' ";
      $sRange   .= "Inutilizao Final at <b>$dInuAte</b><br>";
      $sRange1  .= "Inutilizao Final at $dInuAte".chr(10);
      $iRange++;
   }
 
   if ($pProp>0) {
      $sSql     = "select sCoringa from CUP where pPId=$pProp and iVer=iVAt";
      $aTmp     = faDbSelect($hDb,$sSql);
      $sProp    = $aTmp[0][0];
         $sWhere  .= "and c.pProp  = $pProp".chr(10);
         $sRange .= "Proprietrio <b>$sProp</b><br>";
         $sRange1.= "Proprietrio $sProp".chr(10);
         $iRange++;
   }

   if ($pUNeg>0) {
      $sSql     = "select sCoringa from CUP where pPId=$pUNeg and iVer=iVAt";
      $aTmp     = faDbSelect($hDb,$sSql);
      $sUNeg    = $aTmp[0][0];
         $sWhere  .= "and c.pUNeg  = $pUNeg".chr(10);
         $sRange .= "Unidade de Negcio <b>$sUNeg</b><br>";
         $sRange1.= "Unidade de Negcio $sUNeg".chr(10);
         $iRange++;
   }

   if ($iOPDe>0) {
       $sWhere .= " and e.pPId >= $iOPDe";
       $sRange .= "nmero da OP a partir de <b>$iOPDe</b><br>";
       $iRange++;
   }
   if ($iOPAte>0) {
       $sWhere .= " and e.pPId <= $iOPAte";
       $sRange .= "nmero da OP at <b>$iOPAte</b><br>";
       $iRange++;
   }

   if ($sNrOP!='') {
       $sWhere .= " and e.pPId  in ($sNrOP)";
       $sRange .= "nmero da OP sequencial de <b>$sNrOP</b><br>";
       $iRange++;
   }

   $d = mktime(0,0,0,date("m")-2,date("d"),date("Y"));

   // Conversoes de Unidades
   //
   $sQry = "select pItem,pUni1,pUni2,nFator,pPId,iVAt from Conversao_UnidadeMedida where iVer=iVAt and lExc=0 order by pItem desc";
   fpc_append($sEcoTxt,"sQry=$sQry");
   $aCnv = faDbSelect($hDb,$sQry);

   //

   // Todas as OPs do Range
   // ---------------------
   $sSql = "select e.pPId

            from Itens_Reservas   a,
                 EST_RegDepositos b,
                 Itens            c,
                 UnidadeMedida    d,
                 OP               e
         
            where a.lExc    = 0  and a.iVer = a.iVAt
              $sWhere
              $sWhrItens
              and a.pRegDep = b.pPId and b.iVer = b.iVAt
              and b.pItem   = c.pPId and c.iVer = c.iVAt
              and a.pUniOri = d.pPId and d.iVer = d.iVAt
              and a.pOP     = e.pPId and e.iVer = e.iVAt


            group by 1
            order by 1";


   fpc_append($sEcoTxt,"sSql2=$sSql");
   $aDb = faDbSelect($hDb,$sSql);
   $iDb = count($aDb);
   fpc_append($sEcoTxt,"iDb=$iDb");
   $aTmp   = array();
   $aTmp[] = -1;    // para nao dar erro no select in
   foreach ($aDb as $aLin) {
      $aTmp[] = $aLin[0];
   }
   $sOPs = implode(',',$aTmp);

   fpc_append($sEcoTxt,"sOPs=$sOPs");

   // Todos os Itens SEM LOTE, reservados das OPs acima
   // -------------------------------------------------
   $sSql = "select b.pItem from Itens_Reservas a, EST_RegDepositos b where a.pOP in ($sOPs) and a.iVer=a.iVAt and a.lExc=0 and a.pRegDep=b.pPId and b.iVer=b.iVAt and a.pLote=0 group by b.pItem";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aDb  = faDbSelect($hDb,$sSql);
   $iDb  = count($aDb);
   fpc_append($sEcoTxt,"iDb=$iDb");
   $aTmp   = array();
   $aTmp[] = -1;    // para nao dar erro no select in
   foreach ($aDb as $aLin) {
      $aTmp[] = $aLin[0];
   }
   $sInItens = implode(',',$aTmp);
   fpc_append($sEcoTxt,"sInItens=$sInItens");


   // Todos os Itens COM LOTE, reservados das OPs acima
   // -------------------------------------------------
   $sSql = "select b.pItem from Itens_Reservas a, EST_RegDepositos b where a.pOP in ($sOPs) and a.iVer=a.iVAt and a.lExc=0 and a.pRegDep=b.pPId and b.iVer=b.iVAt and a.pLote>0 group by b.pItem";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aDb  = faDbSelect($hDb,$sSql);
   $iDb  = count($aDb);
   fpc_append($sEcoTxt,"iDb=$iDb");
   $aTmp   = array();
   $aTmp[] = -1;    // para nao dar erro no select in
   foreach ($aDb as $aLin) {
      $aTmp[] = $aLin[0];
   }
   $sInItensLt = implode(',',$aTmp);
   fpc_append($sEcoTxt,"sInItensLt=$sInItensLt");


   // Resetando Tabelas
   // -----------------
   if ($lOk==true) {
      //$sSql = "delete from OP_ConsPerdas where pCapa=$pDoc";
      $sSql = "delete from OP_ConsPerdas";
      fpc_append($sEcoTxt,"sSql=$sSql");
      $lOk  = flDbDelete($hDb,$sSql);
      fpc_append($sEcoTxt,"lOk=$lOk");
   }
   
   if ($lOk==true) {
      //$sSql = "delete from OP_NFs where pCapa=$pDoc";
      $sSql = "delete from OP_NFs";
      fpc_append($sEcoTxt,"sSql=$sSql");
      $lOk  = flDbDelete($hDb,$sSql);
      fpc_append($sEcoTxt,"lOk=$lOk");
   }


   if ($lOk==true) {
      // inicio fase 1 -  consumo de itens sem lotes nao manufaturados -> comprados
      // --------------------------------------------------------------------------
      //
      // Itens das OPs FIFO a.tIn0 desde o inicio
      //
      fpc_append($sEcoTxt,"inicio fase 1");

      $sSql = "select b.pItem,
                      a.pOP,
                      a.nConsumo+a.nPerda+a.nRefugo,
                      a.pUniSdo,
                      '',
                      a.nConsumo,
                      a.nPerda,
                      '',
                      ''
               from   Itens_Reservas   a,
                      EST_RegDepositos b,
                      OP               c
   
               where  a.pRegDep=b.pPId
                 and  a.pOP = c.pPId
                 and  b.pItem in ($sInItens)
               
                 and  a.lExc=0
      --           and  b.lExc=0
                 and  c.lExc=0
                 and  a.iVer=a.iVAt
                 and  b.iVer=b.iVAt
                 and  c.iVer=c.iVAt
                 and  (a.nConsumo+a.nPerda+a.nRefugo>0 or a.nConsumoOri+a.nPerdaOri+a.nRefugoOri>0)
                 and ((c.tInu is null) or (c.tInu is not null and c.jInu=0))    -- nao esta inutulizada ou esta inutilizada SEM volta para o estoque, de forma q consumiu
                 and c.tBaixa is not null
                 and a.pLote=0
               order by b.pItem,a.tIn0";
   
      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDbOP = faDbSelect($hDb,$sSql);
      $iCount_aDbOP = count($aDbOP);
      fpc_append($sEcoTxt,"iCount_aDbOP=$iCount_aDbOP");
      
      //
      // Entrada de Itens dos Recebimentos - FIFO b.tConsol - desde o inicio
      //
      $sSql = "select a.pItem,
                      sum(a.nQtRFis),
                      a.pUni,
                      b.pPId,
                      b.tConsol,
                      c.iIde_nNF,
                      a.nProd_vUnCom
               from PreNF_Itens a,
                    PreNF       b,
                    NFCapa      c
               where a.pPreNF = b.pPId
                 and b.pNF    = c.pPId
                 and b.jTipo  = 0
                 and b.tConsol is not null
                 and b.tCanc   is     null
                 and a.pItem in ($sInItens)
      
                 and a.lExc=0
                 and b.lExc=0
                 and a.iVer=a.iVAt
                 and b.iVer=b.iVAt
                 and c.iVer=c.iVAt
               group by a.pItem,
                        a.pUni,
                        b.pPId,
                        b.tConsol,
                        c.iIde_nNF,
                        a.nProd_vUnCom
               order by a.pItem,b.tConsol";
      
      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDbNF = faDbSelect($hDb,$sSql);
      $iCount_aDbNF = count($aDbNF);
      fpc_append($sEcoTxt,"iCount_aDbNF=$iCount_aDbNF");
      //
      // Calculo da Saldo desde o inicio
      //
      $aNAchou   = array();
      $aNAchou[] = '/';

      for ($iLoopOP=0; $iLoopOP<$iCount_aDbOP; $iLoopOP++) {
         fpc_append($sEcoTxt,"iLoopOP=$iLoopOP -----------------------------------------------");
         $pIOP=$aDbOP[$iLoopOP][0];   // item
         $pOP =$aDbOP[$iLoopOP][1];   // op
         $nQOP=$aDbOP[$iLoopOP][2];   // qtd
         $pUOP=$aDbOP[$iLoopOP][3];   // unidade
     
         if (in_array($pIOP,$aNAchou)==true) continue;
      
         while ($nQOP>0) {
            fpc_append($sEcoTxt,"pIOP=$pIOP, pOP=$pOP, nQOP=$nQOP, pUOP=$pUOP");
            $lAchou=false;
            for ($iLoopNF=0; $iLoopNF<$iCount_aDbNF; $iLoopNF++) {
               //fpc_append($sEcoTxt,"iLoopNF=$iLoopNF");
               $pINF=$aDbNF[$iLoopNF][0];   // item
               $nQNF=$aDbNF[$iLoopNF][1];   // qtd
               $pUNF=$aDbNF[$iLoopNF][2];   // unidade
               $pPNF=$aDbNF[$iLoopNF][3];   // pPreNF
               $iNNF=$aDbNF[$iLoopNF][5];   // nr nf
               $nCus=number_format($aDbNF[$iLoopNF][6],5);   // pru
               //fpc_append($sEcoTxt,"pINF=$pINF, nQNF=$nQNF, pUNF=$pUNF, pPNF=$pPNF, iNNF=$iNNF");
      
               if ($pIOP==$pINF) {
                  fpc_append($sEcoTxt,"pIOP=$pIOP, pINF=$pINF, nQNF=$nQNF");
                  fpc_append($sEcoTxt,"pINF=$pINF, nQNF=$nQNF, pUNF=$pUNF, pPNF=$pPNF, iNNF=$iNNF");
                  if ($nQNF>0) {
      
                     $pConv    = 0;
                     $fConv    = 0;
                     $nFator   = ($pUNF==$pUOP) ? 1 : fnConverterUnidades($pIOP,$pUNF,$pUOP,$sXLogItem,$pConv,$fConv);
                     fpc_append($sEcoTxt,"pConv=$pConv, fConv=$fConv, nFator=$nFator");    
                     if (($pConv>0) || ($nFator!=0)) {
                        $nQNFOP = round($nQNF*$nFator,5);
                        fpc_append($sEcoTxt,"nQNFOP=$nQNFOP");
                        fpc_append($sEcoTxt,"iLoopOP=$iLoopOP, iLoopNF=$iLoopNF");
                        $lAchou=true;
                        if ($nQOP>=$nQNFOP) {
                           $nQX = $nQNFOP;
                           fpc_append($sEcoTxt,"nQOP>=nQNFOP, $nQOP>=$nQNFOP, nQX=$nQX");
                        } else {
                           $nQX = $nQOP;
                           fpc_append($sEcoTxt,"nQOP< nQNFOP, $nQOP< $nQNFOP, nQX=$nQX");
                        } 
                        $nQOP               -= $nQX;
                        $nQOP = round($nQOP,5);  //fundamental para nao entrar em um loop fractal xxE-15 ...
                        $aDbNF[$iLoopNF][1] -= $nQX;
                        $aDbNF[$iLoopNF][1] = round($aDbNF[$iLoopNF][1],5);  //fundamental para nao entrar em um loop fractal xxE-15 ...
                        $aDbOP[$iLoopOP][4] .= $pPNF.'[nQOP='.$nQOP.']'.'[nQX='.$nQX.']'.'[aDbNF[.][1]='.$aDbNF[$iLoopNF][1].']'.',';
                        $aDbOP[$iLoopOP][7] .= '['.$pPNF.']-'.$iNNF.'/';
                        $aDbOP[$iLoopOP][8] .= '['.$pPNF.']-'.$iNNF.'('.$nCus.')/';
                        fpc_append($sEcoTxt,"nQOP=$nQOP == 0 ??");
                        if ($nQOP==0) {
                           fpc_append($sEcoTxt,"fim pOP=$pOP");
                           break;
                        }
                     } else {
                        $sSql = "select sCodigo from Itens where pPId=$pIOP and iVer=iVAt";
                        $aDb  = faDbSelect($hDb,$sSql);
                        $sCod = $aDb[0][0];
                        $sSql = "select sCodigo from UnidadeMedida where pPId=$pUNF and iVer=iVAt";
                        $aDb  = faDbSelect($hDb,$sSql);
                        $sUNF = $aDb[0][0];
                        $sSql = "select sCodigo from UnidadeMedida where pPId=$pUOP and iVer=iVAt";
                        $aDb  = faDbSelect($hDb,$sSql);
                        $sUOP = $aDb[0][0];
                        fpc_append($sEcoTxt,"Processando item $sCod, sem fator de converso entre as unidades de medida $sUNF e $sUOP");
                     }   // (($pConv>0) || ($nFator!=0))
                  }   // ($nQNF>0)
               }   // ($pIOP==$pINF)
            }   // for
            if ($lAchou==false) {
               fpc_append($sEcoTxt,"nao achou - pIOP=$pIOP, pOP=$pOP, nQOP=$nQOP, pUOP=$pUOP");
               $aNAchou[] = $pIOP.'/';
               break;
            }
         }   // while
      }   // foreach
      
      
      foreach ($aDbOP as $aLinOP) {
         $pIOP = $aLinOP[0];   // Item
         $pOP  = $aLinOP[1];   // pOP
         $nQOP = $aLinOP[2];   // qtd
         $pUOP = $aLinOP[3];   // unidade
         $sObs = $aLinOP[4];   // obs - sequencia de pPreNF + iIde_nNF
         $nCon = $aLinOP[5];   // consumo
         $nPer = $aLinOP[6];   // perda
         //$sNNF = $aLinOP[7];   // notas
         $sNNF = $aLinOP[8];   // notas
         fpc_append($sEcoTxt,"pIOP=$pIOP, pOP=$pOP, nQOP=$nQOP, pUOP=$pUOP, sObs=$sObs, nCon=$nCon, nPer=$nPer, sNNF=$sNNF");
         $pLote=0;   // sem lotes

         if (strlen($sNNF)>0) {
   
            if ($lOk==true) {
               $sSql = "insert into OP_NFs (pInc,pCapa,pOP,pItem,pLote,sNFs) values ($sLogin,$pDoc,$pOP,$pIOP,$pLote,'$sNNF')";
               fpc_append($sEcoTxt,"sSql=$sSql");
               $lOk  = flDbInsert($hDb,$sSql);
               fpc_append($sEcoTxt,"lOk=$lOk");
            }
         }
         if ($lOk==false) break;
   
      }   // for each
      
      // fim fase 1 - itens sem lotes nao manufaturados -> comprados
      // ---------------------------- ------------------------------
      fpc_append($sEcoTxt,"fim fase 1");
   }   // lOk==true	

   if ($lOk==true) {
      // inicio fase 2 - itens com lotes nao manufaturados -> comprados
      // --------------------------------------------------------------
      //
      // Itens das OPs FIFO a.tIn0 desde o inicio
      //
      fpc_append($sEcoTxt,"inicio fase 2");
      $sSql = "select d.pItem,b.pOP,b.pLote,b.pUniSdo,b.nConsumo,b.nPerda,d.pPreNF,g.iIde_nNF,d.nProd_vUnCom
               from PreNF_RFis_Itens_Lotes a,
                    Itens_Reservas         b,
                    LotesItens             c,
                    PreNF_Itens            d,
                    Itens                  e,
                    PreNF                  f,
                    NFCapa                 g,
                    OP                     h
   
      
               where a.lExc=0
                 and b.lExc=0
                 and a.iVer=a.iVAt
                 and b.iVer=b.iVAt
                 and c.iVer=c.iVAt
                 and d.iVer=d.iVAt
                 and e.iVer=e.iVAt
                 and f.iVer=f.iVAt
                 and g.iVer=g.iVAt
                 and h.iVer=h.iVAt
 
                 and ((a.pLote=0 and a.sDesLote=c.sDescricao) or (a.pLote  > 0 and a.pLote=b.pLote))
                 and c.pPId  = b.pLote
                 and a.pPreNFItem=d.pPId
                 and d.pItem  = e.pPId
                 and c.pItem  = d.pItem
                 and d.pPreNF = f.pPId
                 and f.pNF    = g.pPId
   
                 and  (b.nConsumo+b.nPerda+b.nRefugo>0 or b.nConsumoOri+b.nPerdaOri+b.nRefugoOri>0)
                 and  (b.nReserva>0 or b.nReservaOri>0)
                 and e.lManuf=0
               
                 and b.pOP in ($sOPs)
                 and b.pOP    > 0
                 and b.pLote  > 0
                 and h.pPId = b.pOP     

                 and ((h.tInu is null) or (h.tInu is not null and h.jInu=0))    -- nao esta inutulizada ou esta inutilizada SEM volta para o estoque, de forma q consumiu
                 and h.tBaixa is not null                                       -- baixada


               group by d.pItem,b.pOP,b.pLote,b.pUniSdo,b.nConsumo,b.nPerda,d.pPreNF,g.iIde_nNF,d.nProd_vUnCom";
      
      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDb = faDbSelect($hDb,$sSql);
   
      foreach ($aDb as $aLin) {
         $pItem   = $aLin[0];
         $pOP     = $aLin[1];
         $pLote   = $aLin[2];
         $pUniSdo = $aLin[3];
         $nCons   = $aLin[4];
         $nPerda  = $aLin[5];
         $pPreNF  = $aLin[6];
         $iIde_nNF= $aLin[7];
         $nCus    = number_format($aLin[8],5);   // pru
         $sNFs    = '['.$pPreNF.']-'.$iIde_nNF.'('.$nCus.')/';
         
         if ($lOk==true) {
            $sSql = "insert into OP_NFs (pInc,pCapa,pOP,pItem,pLote,sNFs) values ($sLogin,$pDoc,$pOP,$pItem,$pLote,'$sNFs')";
            fpc_append($sEcoTxt,"sSql=$sSql");
            $lOk  = flDbInsert($hDb,$sSql);
            fpc_append($sEcoTxt,"lOk=$lOk");
         }
         if ($lOk==false) break;
   
   
      }
      fpc_append($sEcoTxt,"fim fase 2");
      // fim fase 2 - itens  com lotes nao manufaturados -> comprados
      // ------------------------------------------------------------
   }   // lOk==true
   
   // --//--
   
   if ($lOk==true) {
      fpc_append($sEcoTxt,"inicio fase 3");
      // inicio fase 3 - itens manufaturados - todos so com lote - NAO COMPRADOS -> essa fase nao tem nota fiscal OP_ConsPerdas_NF, somente calculo das perdas
      // --------------------------------------------------------------------------------------------------------------------------------------------------
      $iNivel=0;  // so serve para identar a log
      $sSql = "select b.pOP,
                      c.pItem,
                      b.pLote,
                      b.nConsumo,
                      b.nPerda,
                      b.pUniSdo
                   
               from   OP               a,
                      Itens_Reservas   b,
                      EST_RegDepositos c
      
               where  a.pPId in ($sOPs)
                 and  a.pPId    = b.pOP
                 and  b.pRegDep = c.pPId
      
              --   and  b.nPerda>0
                 and  a.tBaixa is not null   --foi baixada
                 and  a.tInu   is     null   --nao esta inutilizada
      
                 and  a.lExc=0
                 and  b.lExc=0
                 and  a.iVer=a.iVAt
                 and  b.iVer=b.iVAt
                 and  c.iVer=c.iVAt 
               order by a.pPId,c.pItem,b.pLote";
      
      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDb  = faDbSelect($hDb,$sSql);
      foreach ($aDb as $aLin) {
         $pOP = $aLin[0];
         $pIt = $aLin[1];
         $pLt = $aLin[2];
         $nCn = $aLin[3];
         $nPd = $aLin[4];
         $pUn = $aLin[5];
      
         fpc_append($sEcoTxt,"pOP=$pOP, pIt=$pIt, pLt=$pLt, nCn=$nCn, nPd=$nPd, pUn=$pUn");   
      
         $sSql = "insert into OP_ConsPerdas (pInc,pCapa,pOP1,pOP2,pItem,pLote,pUni,nCons,nPerda) values ($sLogin,$pDoc,$pOP,$pOP,$pIt,$pLt,$pUn,$nCn,$nPd)";
         fpc_append($sEcoTxt,"sSql=$sSql");
         $lOk  = flDbInsert($hDb,$sSql);
         fpc_append($sEcoTxt,"lOK=$lOk");
         if ($lOk==true) {
            //$lOk = flCalcPerdasDosInsumos($pOP,$pIt,$pLt,$nCn,$nPd,$pUn);
            fpc_append($sEcoTxt,"lOK=$lOk");
         }
         if ($lOk==false) break;
      }   // foreach
      fpc_append($sEcoTxt,"fim fase 3");
      // fim fase 3 - itens manufaturados - todos so com lote
      // ----------------------------------------------------- 
   }   // lOk==true
  
         

   if ($lOk==true) {
      fpc_append($sEcoTxt,"commit");
      flUserLog($aUserLog,'1');
   } else {
      fpc_append($sEcoTxt,"rollback");
      flUserLog($aUserLog,'Erro ao rodar processo.');
   }
   flDbFimSessao($hDb,$lOk);
   fpc_append($sEcoTxt,"fim processo");



   // IMPRESSAO RELATORIO

   $sSql = "select c.sCodigo,     -- 0
                   c.sDescricao,  -- 1
                   d.sUnidade,    -- 2
                   a.pOP1,        -- 3
                   a.pOP2,        -- 4
                   a.nCons,       -- 5
                   a.nPerda,      -- 6
                   b.sNFs         -- 7

            from OP_ConsPerdas    a left join OP_NFs b on b.pCapa = $pDoc and a.pItem = b.pItem and b.pOP=a.pOP2 and a.pLote=b.pLote and b.iVer = b.iVAt,
                 Itens            c,
                 UnidadeMedida    d
         
            where a.pCapa   = $pDoc
          
              and a.pItem   = c.pPId  
              and a.pUni    = d.pPId  

              and a.lExc = 0
              and a.iVer = a.iVAt
              and c.iVer = c.iVAt
              and d.iVer = d.iVAt             

--            group by c.sCodigo,a.pOP1,a.pOP2
            order by c.sCodigo";



//   $hQry = ibase_query($hDb,$sSql);

   $aTmpRel = array();
   $aDb = faDbSelect($hDb,$sSql);
   $iInd     = 0;
   foreach ($aDb as $aLin) {
      $sCodItem = $aLin[0];
      $sItem    = $aLin[1];
      $sUndd    = $aLin[2];
      $nCons    = $aLin[5];
      $nPerd    = $aLin[6];
      $sNFs     = trim($aLin[7]);
      $sNFs     = substr($sNFs,0,strlen($sNFs)-1);
      $aTmp     = explode('/',$sNFs);
   fpc_append($sEcoTxt,"sCodItem=$sCodItem, nCons=$nCons, nPerd=$nPerd, sNFs=$sNFs");
      foreach ($aTmp as $sLinTmp) {
         if (strlen($sLinTmp)>0) {
            $aTm2 = explode('(',$sLinTmp);
            $sNF2 = $aTm2[0].'/';
            $nCus = str_replace(')','',$aTm2[1]);
         } else {
            $sNF2 = '';
            $nCus = '';
         }
         if (isset($aCodCus[$sCodItem.'['.$nCus.']'])==true) {
            $iPos = $aCodCus[$sCodItem.'['.$nCus.']'];
            $aTmpRel[$iPos][5] += $nCons;
            $aTmpRel[$iPos][6] += $nPerd;
            if (strlen($sNF2)>0) $aTmpRel[$iPos][7] .= $sNF2;
   fpc_append($sEcoTxt,"achou sCodItem=$sCodItem, nCus=$nCus, iPos=$iPos, nCons=$nCons, nPerd=$nPerd, sNF2=$sNF2");
         } else {
            $aTmpRel[] = array($sCodItem,$sItem,$sUndd,0,0,$nCons,$nPerd,$sNF2,$nCus);
            $aCodCus[$sCodItem.'['.$nCus.']'] = $iInd;
   fpc_append($sEcoTxt,"nachou sCodItem=$sCodItem, nCus=$nCus, iInd=$iInd, nCons=$nCons, nPerd=$nPerd, sNF2=$sNF2");
            $iInd++;
         }
      }
   }

   fpc_append($sEcoTxt,"inicio relatrio");
   fpc_append($sEcoTxt,"sSql=$sSql");

   // Cores
   $sCorFundo1 = "#c0c0c0";
   $sCorFundo2 = "#ffffff";

   $sEmpresa   = "<font face='Lucida Sans' size='5' color='#FFFFFF'>&nbsp;$sProprietario&nbsp;</font>";

   $sCabec     = "RELATORIO DE PERDAS"; // Titulo Central do Cabealho tem que manter esse padro
   $sTit       = "Relatrio Avancado - Perdas (*) s entra nos clculos itens que perdas>0"; // Titulo rodap do cabealho


// Descrio do cabealho 
   $aTit[0]  = "Cdigo";
   $aTit[1]  = "Item";
   $aTit[2]  = "Unidade";
   $aTit[3]  = "Pr.Unit";
   $aTit[4]  = "Consumo OP";
   $aTit[5]  = "Perda Qtd";
   $aTit[6]  = "Perda %";
   $aTit[7]  = "[PreNF] Notas";

// Tipo de campo da coluna = exemplo : string "s" , decimal com casas decimais (0,00) "n" , decimal inteiro (1234) "i" , timeste com DATA/hora/min/seg.. "t" , timestemp com apenas DATA "d"
   $aTyp[0]  = 's';
   $aTyp[1]  = 's';
   $aTyp[2]  = 's';
   $aTyp[3]  = 'n';
   $aTyp[4]  = 'n';
   $aTyp[5]  = 'n';
   $aTyp[6]  = 'n';
   $aTyp[7]  = 's';

// Conteudo de cada coluna
   $aExp[0]  = '$aLin[0]';
   $aExp[1]  = '$aLin[1]';
   $aExp[2]  = '$aLin[2]';
   $aExp[3]  = 'str_pad($aLin[8],10," ",STR_PAD_LEFT)';
   $aExp[4]  = 'str_pad(number_format($aLin[ 5],5,",","."),14," ",STR_PAD_LEFT)';   // Consumo
   $aExp[5]  = 'str_pad(number_format($aLin[ 6],5,",","."),14," ",STR_PAD_LEFT)';   // Perdas
   $aExp[6]  = 'str_pad(number_format($aLin[ 5]==0 ? 0 : ($aLin[ 6]*100/$aLin[ 5]),2,",","."),14," ",STR_PAD_LEFT)';   // Perdas
   $aExp[7]  = 'fsPoeReticencias($aLin[7],20)';

// $aContent[] = array($sCodig2,$sDescrica2,$sUnidad2,$nConsum2,$nPerd2);
// Tamanho das colunas 
   $aLen[0]  = '20';
   $aLen[1]  = '80';
   $aLen[2]  = '10';
   $aLen[3]  = '10';
   $aLen[4]  = '14';
   $aLen[5]  = '14';
   $aLen[6]  = '14';
   $aLen[7]  = '20';

// Totaliza colunas ?
//   $aSum[0]  = 0;
//   $aSum[1]  = 0;
//   $aSum[2]  = 0;
//   $aSum[3]  = 0;
//   $aSum[4]  = 0;
//   $aSum[5]  = 0;
//   $aSum[6]  = 1;
//   $aSum[7]  = 1;
//   $aSum[8]  = 1;
//   $aSum[9]  = 1;
//   $aSum[10] = 1;
//   $aSum[11] = 1;

//   str_pad(substr(strtoupper(fsTiraAcento($aRel[$i][$j])),0,20),20);

   $dData      = date("d/m/Y  H:i:s");

   $x='';
   $aRel = array();

   $nTotPorcs  =0;
   $nTotItens  =0;
   //while ($aLin = ibase_fetch_row($hQry)) {
   foreach ($aTmpRel as $aLin) {
      $aTmp = array();
      foreach ($aExp as $sCpo) {
         eval('$x=' . $sCpo .';');
         $aTmp[] = $x;
fpc_append($sEcoTxt,"x=$x");
      }
      $nTotItens++;
      $nTotPorcs += str_replace(',','.',str_replace('.','',$aTmp[5]));

      $aRel[]  = $aTmp;
   }
   $aTmp = array('','','','','','','');
   $aRel[]  = $aTmp;

   $aTmp = array('Totais PA','','','','',number_format($nTotPorcs,2,',','.'));
   $aRel[]  = $aTmp;

   if ($nTotItens>0) {
      $aTmp = array('Mdias PA','','','','',number_format($nTotPorcs/$nTotItens,2,',','.'));
      $aRel[]  = $aTmp;
   }

   $iCountaRel = count($aRel);

   if ($iCountaRel==0) {
      echo "Relatrio de Perdas, nada a relacionar.";
   } else {

// c.sCodigo                    sCodItem,
// c.sDescricao                 sItem,
// d.sUnidade                   sUniSdo,
// sum(a.nConsumo)              nConsumo,
// sum(a.nPerda)                nPerda,
// c.pPId                       pItem,
// c.lManuf                     lManuf
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CRIAO DO CABEALHO AUTOMATICO
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
         $iLinPag          = 59;
         $iTPag            = ceil($iCountaRel/$iLinPag);
         $iTPag            = $iTPag==0 ? 1 : $iTPag;
         $iPag             = 1;
         $iLin             = 0;
         $iColAtual        = 0;

         $sData            = date('d/m/Y  H:i:s');
         $sPag             = "Pag:".$iPag."  /  ".$iTPag;
         $iLenData         = strlen($sData);
         $iLenPag          = strlen($sPag);
         $iTotalLenCol     = 0;
         $sTotalLenColMais = '';
         $sTracoCentral    = '';

         foreach ($aLen as $iLenCol) {
            $iTotalLenCol     += $iLenCol;
            $sTracoCentral    .= str_repeat('-',$iLenCol).'+';
         }
         $iMais         = count($aLen);
         $sTracoUp      = str_repeat('-',$iTotalLenCol+$iMais);
         $sCabecUp      = $sData . str_repeat(' ',($iTotalLenCol+$iMais)-$iLenData-$iLenPag).$sPag;
         $sCabecCentral = str_pad($sCabec,$iTotalLenCol+$iMais,' ',STR_PAD_BOTH);
         $sCabecCentral = str_replace(' ',' ',$sCabecCentral);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Format = 0 -- Visualizar
// Format = 1 -- Imprimir 
// Format = 2 -- Arquivo
      
      if (($jFormat==2)||($jFormat==1)) {
         $lCabec=true;
         $iCorGrid = 1;
         $sRel .= "$gs12_COND";
         $schr12 = chr(12);

         for ($i = 0; $i < $iCountaRel; $i++) {
   
            if ($lCabec==true) {
               if ($i>0) {
                  $sRel .= "$schr12";
               } // if ($i>0) 

               $sRel .= $sTracoUp.chr(10);
               $sRel .= $sCabecUp.chr(10);
               $sRel .= $sCabecCentral.chr(10);
               $sRel .= $sTit.chr(10);
               $sRel .= $sTracoCentral.chr(10);

               for ($j = 0; $j <count($aRel[$i]); $j++) {
                  $sTmp = "".fsTiraAcento($aTit[$j]);
                  if      ($aTyp[$j]=='d') $sRel .= str_pad($sTmp,$aLen[$j],' ',STR_PAD_BOTH).chr(179);
                  else if ($aTyp[$j]=='n') $sRel .= str_pad($sTmp,$aLen[$j],' ',STR_PAD_LEFT).chr(179);
                  else                     $sRel .= str_pad($sTmp,$aLen[$j],' '             ).chr(179);
               } // for ($j = 0; $j <count($aRelABCRepr[$i]); $j++) 

               $sRel .= chr(10);
               $sRel .= $sTracoCentral.chr(10);
               $lCabec=false;
               $iLin++;
            } //if ($lCabec==true)

            for ($j = 0; $j <count($aRel[$i]); $j++) {
               $sTmp = "".fsTiraAcento($aRel[$i][$j]);
               if      ($aTyp[$j]=='d') $sRel .= str_pad($sTmp,$aLen[$j],' ',STR_PAD_BOTH).chr(179);
               else if ($aTyp[$j]=='n') $sRel .= str_pad($sTmp,$aLen[$j],' ',STR_PAD_LEFT).chr(179);
               else                     $sRel .= substr(str_pad($sTmp,$aLen[$j],' '),0,$aLen[$j]).chr(179);
               if (++$iColAtual>=count($aTit)) $iColAtual = 0;
             } // for ($j = 0; $j <count($aRel[$i]); $j++)

   

             $sRel .= chr(10);
             $iLin++;

             if ($iLin >= $iLinPag) {   // quebra de pagina
                $iPag++;
                $iLin=0;
                $lCabec=true;
             } // if ($iLin >= $iLinPag)
         } // for ($i = 0; $i < $iCountaRel; $i++) 

         $sRel .= $sRange1;
         $sRel .= "$schr12";
         $sRel = fsTiraAcento($sRel);
         if ($jFormat==1) {
            //$sPathSaida     = "/qtux/samba/reports/canal_maq2/".$sImp."~".$aLinWhrPai[strtoupper("sPathSaida")];
            $sPathSaida     = $sPathReports2.$sImp."~".$aLinWhrPai[strtoupper("sPathSaida")]; // CAMINHO ACIMA ESTA VINDO PELO BUSNESS.DDINI
            fpc_append($sPathSaida,$sRel);
            echo "Arquivo ".$aLinWhrPai[strtoupper("sPathSaida")]." enviado para impressora ".$sImp." com sucesso...";
         } // if ($jFormat==1) 
         if ($jFormat==2) {
            //$sPathSaida     = "/qtux/samba/reports/".$aLinWhrPai[strtoupper("sPathSaida")];
            $sPathSaida     = $sPathReports1.$aLinWhrPai[strtoupper("sPathSaida")]; // CAMINHO ACIMA ESTA VINDO PELO BUSNESS.DDINI
            fpc_append($sPathSaida,$sRel);
            echo "Arquivo ".$sPathSaida." gerado com sucesso...";
         } // if ($jFormat==2)
      }  // if (($jFormat==2)||($jFormat==1)) 

      if ($jFormat==0) {
         $lCabec=true;
         $iCorGrid = 1;
   
         echo "<html>";
         echo "   <head>";
         echo "      <title>".$iTamTot;
         echo "      </title>";
         echo "   </head>";
         echo "   <body style='padding: 0px; margin: 0px; background-color: #FFFFFF;'>";
         echo '<div style="width: 3000px; overflow:hidden; text-align: left; top: 0px; left: 0px; z-index: 0; font-family: Courier New; font-size: 10px;">';
         echo '<div style=" overflow:hidden;"><b>';

         for ($i = 0; $i < $iCountaRel; $i++) {
            if ($lCabec==true) {
               $sRel .= $sTracoUp."<br>";
               $sRel .= $sCabecUp."<br>";
               $sRel .= $sCabecCentral."<br>";
               $sRel .= $sTit."<br>";
               $sRel .= $sTracoCentral."<br>";
   
            for ($j = 0; $j <count($aRel[$i]); $j++) {
                  $sTmp = "".fsTiraAcento($aTit[$j]);
                  if      ($aTyp[$j]=='d') $sRel .= str_pad($sTmp,$aLen[$j],' ',STR_PAD_BOTH).chr(179);
                  else if ($aTyp[$j]=='n') $sRel .= str_pad($sTmp,$aLen[$j],' ',STR_PAD_LEFT).chr(179);
                  else                     $sRel .= str_pad($sTmp,$aLen[$j],' '             ).chr(179);
               } // for ($j = 0; $j <count($aRel[$i]); $j++)
               $sRel .= "<br>"; 
               $sRel .= $sTracoCentral."<br>";
               $lCabec=false;
            } // if ($lCabec==true)
   
            for ($j = 0; $j <count($aRel[$i]); $j++) {
               $sTmp = "".fsTiraAcento($aRel[$i][$j]);
               if      ($aTyp[$j]=='d') $sRel .= str_pad($sTmp,$aLen[$j],' ',STR_PAD_BOTH).chr(179);
               else if ($aTyp[$j]=='n') $sRel .= str_pad($sTmp,$aLen[$j],' ',STR_PAD_LEFT).chr(179);
               else                     $sRel .= substr(str_pad($sTmp,$aLen[$j],' '),0,$aLen[$j]).chr(179);
               if (++$iColAtual>=count($aTit)) $iColAtual = 0;
            } // for ($j = 0; $j <count($aRel[$i]); $j++)

            $sRel .="<br>";       

            $aVT            += str_replace(",",".",str_replace(".","",trim($aRel[$i][10])));
            $aTVCONSOP      += str_replace(",",".",str_replace(".","",trim($aRel[$i][11])));
            $aTVPERDA       += str_replace(",",".",str_replace(".","",trim($aRel[$i][12])));
            $aTVEST         += str_replace(",",".",str_replace(".","",trim($aRel[$i][13])));

            $aTTPERDA        = $aTVCONSOP+$aTVPERDA;
            $iLin++;
            if ($iLin >= $iLinPag) {   // quebra de pagina
               $iPag++;
               $iLin=0;
               $lCabec=true;
            } // if ($iLin >= $iLinPag)

         } // for ($i = 0; $i < $iCountaRel; $i++)
         $sRel = str_replace(" ","&nbsp;",$sRel)."<br>";
         $sRel .= $sRange;
         echo "$sRel";
         echo "</b></div>";
         echo "</div>";
         echo "</body>";
         echo "</html>";
         $sRel = fsTiraAcento($sRel);
      } // if ($jFormat==0)
   }

   flDbDisconnect($hDb);
   //} // } else {
}// if (file_exists($sFileConfig)) 


//////////////////////////////////////////////////////////////////////
function flCalcPerdasDosInsumos($ppOP,$ppIt,$ppLt,$pnCn,$pnPd,$ppUn) {
//////////////////////////////////////////////////////////////////////
   global $hDb;
   global $sLogin;
   global $sEcoTxt;
   global $iNivel;
   global $pDoc;

   $iNivelOriginal = $iNivel;

   $iNivel++;
   $sIdent = str_repeat(' ',$iNivel*3);
   $lOk=true;

   fpc_append($sEcoTxt,"$sIdent inicio flCalcPerdasDosInsumos");
   fpc_append($sEcoTxt,"$sIdent -----------------------------");

   fpc_append($sEcoTxt,"$sIdent ppOP=$ppOP, ppIt=$ppIt, ppLt=$ppLt, pnPd=$pnPd, ppUn=$ppUn");

   $sSql = "select a.pPId,
                   a.nQtReal,
                   d.pUnProd,
                   c.pItem,
                   b.pLote,
                   b.nConsumoOri,  -- ou b.nConsumoOri+b.nPerdaOri (??)
                   b.pUniOri,
                   e.sCodigo

            from OP               a,
                 Itens_Reservas   b,
                 EST_RegDepositos c,
                 Itens            d,
                 Itens            e   -- s para a log
   
            where a.pItem   = $ppIt
              and a.pLote   = $ppLt

              and a.pPId    = b.pOP
              and b.pRegDep = c.pPId
              and d.pPId    = $ppIt
              and e.pPId    = c.pItem

   
              and  b.lExc=0
              and  a.iVer=a.iVAt
              and  b.iVer=b.iVAt
              and  c.iVer=c.iVAt
              and  d.iVer=a.fItem   --d.iVAt   --assim pego a versao da ficha do item corretao e com isso pego [pUnPro] correto
              and  e.iVer=e.iVAt
            order by a.pPId,c.pItem,b.pLote
           ";
   fpc_append($sEcoTxt,"$sIdent sSql=$sSql");   

   $aDb  = faDbSelect($hDb,$sSql);
   foreach ($aDb as $aLin) {
      $pOP_Manuf = $aLin[0];
      $nQt_Manuf = $aLin[1];
      $pUn_Manuf = $aLin[2];
      $pItem_Ins = $aLin[3];
      $pLote_Ins = $aLin[4];
      $nCons_Ins = $aLin[5];
      $pUniO_Ins = $aLin[6];
      $sItem_Ins = $aLin[7];

      fpc_append($sEcoTxt,"$sIdent pOP_Manuf=$pOP_Manuf, nQt_Manuf=$nQt_Manuf, pUn_Manuf=$pUn_Manuf, pItem_Ins=$pItem_Ins, pLote_Ins=$pLote_Ins, nCons_Ins=$nCons_Ins, pUniO_Ins=$pUniO_Ins, sItem_Ins=$sItem_Ins");

      $pConv    = 0;
      $fConv    = 0;
      $nFator   = ($ppUn==$pUn_Manuf) ? 1 : fnConverterUnidades($ppIt,$ppUn,$pUn_Manuf,$sXLogItem,$pConv,$fConv);
      fpc_append($sEcoTxt,"$sIdent pConv=$pConv, fConv=$fConv, nFator=$nFator");
      if (($pConv>0) || ($nFator!=0)) {
         $nPd_Em_Un_Manuf = $pnPd*$nFator;
         $nProporcao_Pd   = $nPd_Em_Un_Manuf/$nQt_Manuf;
         $nPd_Ins         = round($nProporcao_Pd*$nCons_Ins,9);

         $nCn_Em_Un_Manuf = $pnCn*$nFator;
         $nProporcao_Cn   = $nCn_Em_Un_Manuf/$nQt_Manuf;
         $nCn_Ins         = round($nProporcao_Cn*$nCons_Ins,9);


         fpc_append($sEcoTxt,"$sIdent nPd_Em_Un_Manuf=$nPd_Em_Un_Manuf, nProporcao_Pd=$nProporcao_Pd, nCn_Ins=$nCn_Ins, nPd_Ins=$nPd_Ins");

         $sSql = "insert into OP_ConsPerdas (pInc,pCapa,pOP1,pOP2,pItem,pLote,pUni,nCons,nPerda) values ($sLogin,$pDoc,$ppOP,$pOP_Manuf,$pItem_Ins,$pLote_Ins,$pUniO_Ins,$nCn_Ins,$nPd_Ins)";
         fpc_append($sEcoTxt,"$sIdent sSql=$sSql");
         $lOk  = flDbInsert($hDb,$sSql);
         fpc_append($sEcoTxt,"$sIdent lOK=$lOk");
          
         if ($lOk==true) {
            $lOk = flCalcPerdasDosInsumos($ppOP,$pItem_Ins,$pLote_Ins,$nCn_Ins,$nPd_Ins,$pUniO_Ins);
         }
         if ($lOk==false) break;


      } else {
         $sSql = "select sCodigo from Itens where pPId=$ppIt and iVer=iVAt";
         $aTmp = faDbSelect($hDb,$sSql);
         $sCod = $aTmp[0][0];
         $sSql = "select sCodigo from UnidadeMedida where pPId=$ppUn and iVer=iVAt";
         $aTmp = faDbSelect($hDb,$sSql);
         $sUn1 = $aTmp[0][0];

         $sSql = "select sCodigo from UnidadeMedida where pPId=$pUn_Manuf and iVer=iVAt";
         $aTmp = faDbSelect($hDb,$sSql);
         $sUn2 = $aTmp[0][0];

         fpc_append($sEcoTxt,"$sIdent No h o fator de converso entre as unidades de medida [$sUn1] e [$sUn2] - erro ao processar item [$sCod]");
         flUserLog($aUserLog,"No h o fator de converso entre as unidades de medida [$sUn1] e [$sUn2] - erro ao processar item [$sCod]");
      }
   }   // foreach

   fpc_append($sEcoTxt,"$sIdent final flCalcPerdasDosInsumos");
   fpc_append($sEcoTxt,"$sIdent ----------------------------");

   $iNivel = $iNivelOriginal;

   return $lOk;

}

?>
