///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Algoritimo Regressivo/IMAM
//
// Otimizao do processo batch para clculo das estatsticas e parmetros de maneira que a execuo seja mais eficiente e rpida. 
// Assim o grande o benefcio desta tcnica reside na leitura, processamento, e atualizao dos resultados, que  realizada em uma
// nica varredura das transaes do banco de dados, otimizando dramaticamente o desempenho do sistema.
//  preciso que a rotina de processamento prepare os dados dos inputs indexando, isto  , ordenando os registros de movimentao
// primeiro pelo cdigo, e da pela da de movimentao, de forma retroativa.


// A2.1: Determinao do Saldo Mdio Dirio
                   Somatria (Saldo x dias)
SALDO MDIO = __________________________________




//////////////////////////////////////////////////////////////////////////////////////////////////////

// FUNES ASC_II/DEFASADAS



**************************
FUNCTION fSKUMain(iCodCE1)
**************************
Mens(maxrow()-1,maxrow(),d_ESP)
local p,k,iCodPro,lTemPai
local cSql
cSql  = " select b.IN_BOM_PRO, "
cSql += "        b.IN_BOM_COM, "
cSql += "        b.IN_PRO_EST, "
cSql += "        b.IN_COM_EST, "
cSql += "        b.IN_VEN_EST, "
cSql += "        a.MEDCONS   , "   && Vindo da interface
cSql += "        a.MEDSAI    , "   && Carregado pelo processo de Estatistica 2
cSql += "        a.DPSAI     , "
cSql += "        a.CVSAI     , "
cSql += "        a.CMEDIO    , "
cSql += "        a.PRMEDV    , "
cSql += "        b.TIPO      , "
cSql += "        a.LTCOMB    , "
cSql += "        a.DE        , "
cSql += "        c.FS        , "
cSql += "        a.TMEA      , "
cSql += "        a.MEDSAL    , "
cSql += "        a.CVSAI     , "
cSql += "        a.COD_PRO   , "
cSql += "        b.EST_NIVEL   "
cSql += " from " + SetTabela("tpro202") + " a," 
cSql +=            SetTabela("titm002") + " b,"
cSql +=            SetTabela("tpro203") + " c "
cSql += " where a.COD_PRO = b.RECNO  and "
cSql += "       a.COD_CE3 = c.RECNO  and "
cSql += "       a.COD_CE1 = " + astr(iCodCE1) 
aArray      = rdd_select(cSql)
iNrCampos   = 20
iNrProdutos = len(aArray)/iNrCampos
declare aItens[iNrProdutos,23]
*  1 - Item esta OK
*  2 - InBomPro
*  3 - InBomCom
*  4 - InProEst
*  5 - InComEst
*  6 - InVenEst
*  7 - Cod_Pro
*  8 - Media Saida     Interface
*  9 - DP    Saida     Case
* 10 - CoefV Saida     Case
* 11 - Media Saida     Estatistica
* 12 - C.Medio                   
* 13 - P.Medio                     
* 14 - Tipo do Item (1-Comprado,2-Manufaturado,3-Fantasma,4-3o)
* 15 - LTComb + DE
* 16 - Fator Seguranca Pretendido
* 17 - TMEA
* 18 - Saldo Medio
* 19 - CoefVariacao Saida
* 20 - Est.Nivel
* 21 - Saldo Medio B
* 22 - Saldo Medio C
* 23 - DP - C
p = 0
for i=1 to len(aArray) step iNrCampos
   ++p
   iCodPro = aArray[i+18]
   lTemPai = pTemPai(iCodPro)
   aItens[p, 1] = 0
   aItens[p, 2] = aArray[i   ]
   aItens[p, 3] = aArray[i+ 1]
   aItens[p, 4] = aArray[i+ 2]
   aItens[p, 5] = aArray[i+ 3]
   aItens[p, 6] = aArray[i+ 4]
   aItens[p, 7] = aArray[i+18]
   aItens[p, 8] = if(lTemPai,0,aArray[i+ 5])
   aItens[p, 9] = aArray[i+ 7]
   aItens[p,10] = aArray[i+ 8]
   aItens[p,11] = aArray[i+ 6]
   aItens[p,12] = aArray[i+ 9]
   aItens[p,13] = aArray[i+10]
   aItens[p,14] = if(lTemPai,0,aArray[i+11])
   aItens[p,15] = aArray[i+12]+aArray[i+13]
   aItens[p,16] = aArray[i+14]
   aItens[p,17] = aArray[i+15]
   aItens[p,18] = aArray[i+16]
   aItens[p,19] = aArray[i+17]
   aItens[p,20] = aArray[i+19]
next
declare aPais  [iNrProdutos,2,300]
for p = 1 to iNrProdutos
   cSql   = "select COD1_PRO,QT+(1*REFUGO/100) from " + SetTabela("titm030") + " where COD2_PRO = " + astr(aItens[p,7])
   aArray = rdd_select(cSql)
   k      =0
   for i = 1 to 300
      if i <= len(aArray)/2
         aPais[p,1,i] = aArray[++k]
         aPais[p,2,i] = aArray[++k]
      else
         aPais[p,1,i] = 0
         aPais[p,2,i] = 0
      endif
   next
next

iCp1ImbG    = 0
iCp2ImbG    = 0
iCp3ImbG    = 0

iPotV1G     = 0    
iPotV2G     = 0             
iPotV3G     = 0             

iCMD1G      = 0   
iCMD2G      = 0  
iCMD3G      = 0   

iVMD1G      = 0  
iVMD2G      = 0   
iVMD3G      = 0   

fSKUJet()
fSKUGravar(iCodCE1)
IAVetor(ChaveAtual())
RETURN(.t.)

****************************
FUNCTION fSKUGravar(iCodCE1)
****************************
Mens(maxrow()-1,maxrow(),d_ESP)
local cSql
local p
local uai
for p=1 to iNrProdutos
   iYb  = aItens[p,11]
   iSMb = aItens[p,21]
   iYc  = aItens[p, 8]
   iDPc = aItens[p,23]
   iSMc = aItens[p,22]
   cSql  = " update " + SetTabela("tpro202") + " set "
   cSql += " Y_b  = " + str(iYb,18,5)    + ","
   cSql += " SM_b = " + str(iSMb,18,5)   + ","
   cSql += " Y_c  = " + str(iYc,18,5)    + ","
   cSql += " MEDCONS = " + str(iYc,18,5) + ","
   cSql += " DP_c = " + str(iDPc,18,5)   + ","
   cSql += " SM_c = " + str(iSMc,18,5) 
   cSql += " where COD_CE1 = " + astr(ChaveAtual(1)) + " and "
   cSql += "       COD_PRO = " + astr(aItens[p,7])
   uai = rdd_update(cSql)
   if !uai
      exit
   endif
next
if uai
   cSql  = " update " + SetTabela("tpro201") + " set "
   cSql += " CI1  = " + str(iCp1ImbG,18,5) + ","
   cSql += " CI2  = " + str(iCp2ImbG,18,5) + ","
   cSql += " CI3  = " + str(iCp2ImbG,18,5) + ","
   cSql += " PV1  = " + str(iPotV1G ,18,5) + ","
   cSql += " PV2  = " + str(iPotV2G ,18,5) + ","
   cSql += " PV3  = " + str(iPotV3G ,18,5) + ","
   cSql += " CMD1 = " + str(iCMD1G  ,18,5) + ","
   cSql += " CMD2 = " + str(iCMD2G  ,18,5) + ","
   cSql += " CMD3 = " + str(iCMD3G  ,18,5) + ","
   cSql += " VMD1 = " + str(iVMD1G  ,18,5) + ","
   cSql += " VMD2 = " + str(iVMD2G  ,18,5) + ","
   cSql += " VMD3 = " + str(iVMD3G  ,18,5) 
   cSql += " where RECNO = " + astr(iCodCE1)

   uai = rdd_update(cSql)
endif
if uai
   rdd_commit()
else
   rdd_rollbck()
   tat("O resultado do processo nao pode ser gravado ...",.t.)
endif
RETURN(.t.)

***************************
FUNCTION fSKUQualP(iCodPro)
***************************
local p
for p=1 to iNrProdutos
   if aItens[p,7] = iCodPro
      exit
   endif
next
RETURN(p)

******************************************
FUNCTION fSKUTodosOsPaisEstaoCalculados(p)
******************************************
local uai := .t.
local iCodPai
local pPai
local i 
for i = 1 to 300
   iCodPai = aPais[p,1,i]
   if iCodPai > 0
      pPai = fSKUQualP(iCodPai)
      if pPai <= iNrProdutos
         uai = !empty(aItens[pPai,1])
      endif
   else
      exit
   endif
   if !uai
      exit
   endif
next   
RETURN(uai)

******************
FUNCTION fSKUJet()
******************
local p
local pInicial := 1
local lLoop := .t.
PoeRegua(12,.f.,"",.t.)
while lLoop
   lLoop = .f.
   for p = pInicial to iNrProdutos
      if !fSKUEstaCalculada(p).and.fSKUTodosOsPaisEstaoCalculados(p)
         TicRegua(iNrProdutos,.t.,.t.)
         fSKUItemCalcula(p)
         lLoop = .t.
         pInicial = p+1
	 exit
      endif
   next  
   if !lLoop .and. pInicial<>1
      pInicial = 1
      lLoop    = .t.
   endif
end
RETURN(.t.)

*****************************
FUNCTION fSKUEstaCalculada(p)
*****************************
RETURN(aItens[p,1]=1)

***************************
FUNCTION fSKUItemCalcula(p)
***************************
local iCodPai
local pPai
local iCoefB
local i
aItens[p, 1] = 1
*aItens[p, 8] = 0
*aItens[p,11] = 0
for i = 1 to 300
   iCodPai = aPais[p,1,i]
   iCoefB  = aPais[p,2,i]
   if iCodPai > 0
      pPai = fSKUQualP(iCodPai)
      if pPai <= iNrProdutos
         iInBomPro     = aItens[pPai, 2]
	 iInBomCom     = aItens[pPai, 3]
	 iInProEst     = aItens[pPai, 4] 
	 iInComEst     = aItens[pPai, 5]
	 iInVenEst     = aItens[pPai, 6]
	 iTipoPai      = aItens[pPai,18]
         iConsPai      = aItens[pPai,11]/if(iTipoPai=1.or.iTipoPai=4,iInComEst,iInProEst)
         iInBomPro     = aItens[p, 2]
	 iInBomCom     = aItens[p, 3]
	 iInProEst     = aItens[p, 4] 
	 iInComEst     = aItens[p, 5]
	 iInVenEst     = aItens[p, 6]
	 iTipo         = aItens[p,18]
	 iCons         = iCoefB * iConsPai * if(iTipo=1.or.iTipo=4,iInBomCom*iInComEst,iInBomPro*iInProEst)
         aItens[p,11] += iCons     

         iInBomPro     = aItens[pPai, 2]
	 iInBomCom     = aItens[pPai, 3]
	 iInProEst     = aItens[pPai, 4] 
	 iInComEst     = aItens[pPai, 5]
	 iInVenEst     = aItens[pPai, 6] 
	 iTipoPai      = aItens[pPai,18]
         iConsPai      = aItens[pPai, 8]/if(iTipoPai=1.or.iTipoPai=4,iInComEst,iInProEst)
         iInBomPro     = aItens[p, 2]
	 iInBomCom     = aItens[p, 3]
	 iInProEst     = aItens[p, 4] 
	 iInComEst     = aItens[p, 5]
	 iInVenEst     = aItens[p, 6]
	 iTipo         = aItens[p,18]
	 iCons         = iCoefB * iConsPai * if(iTipo=1.or.iTipo=4,iInBomCom*iInComEst,iInBomPro*iInProEst)
         aItens[p, 8] += iCons     
      endif
   else
      exit
   endif
next   

iDPa  = aItens[p, 9]
iYa   = aItens[p,11]
iYb   = aItens[p, 8]
iFS   = aItens[p,16]
iLT   = aItens[p,15]  && Ja esta somado ao DE
iTmea = aItens[p,17]
iSM   = aItens[p,18]
iCM   = aItens[p,12]
iPM   = aItens[p,13]
iCV   = aItens[p,19]
iDPb  = iCV * iYb/100
iEstNiv = aItens[p,20]

aItens[p,23] = iDPb
iCp1ImbG   += iSM * iCM
iPotV1G    += iSM * iPM             
iCMD1G     += iYa * iCM            
iVMD1G     += iYa * iPM

iEstSeg      = iDPa * iFS
iPRep1       = iYa * iLT + iEstSeg
iPRep2       = iLT*iYa/iTMEA + iFS*iDPa/((iLT/iTMEA)^(1/2))
iSMB         = ((iEstNiv+iPRep1)/2 + (iEstNiv+iPRep2)/2 )/2
aItens[p,21] = iSMB
iCp2ImbG    += iSMB * iCM
iPotV2G     += iSMB * iPM             
iCMD2G      += iYb * iCM            
iVMD2G      += iYb * iPM

iEstSeg      = iDPb * iFS
iPRep1       = iYb  * iLT + iEstSeg
iPRep2       = iLT*iYb/iTMEA + iFS*iDPb/((iLT/iTMEA)^(1/2))
iSMB         = ((iEstNiv+iPRep1)/2 + (iEstNiv+iPRep2)/2 )/2
aItens[p,22] = iSMB
iCp3ImbG    += iSMB * iCM
iPotV3G     += iSMB * iPM             
iCMD3G      += iYb * iCM            
iVMD3G      += iYb * iPM

RETURN(.t.)


***********************************************************************
**********************
FUNCTION RelStatItem()
**********************
***
   local i
   Mens(maxrow()-1,maxrow(),d_ESP)
   
   local cSql := "select a.D1        ,"
         cSql += "       a.D2        ,"
         cSql += "       a.COD_PRO   ,"
         cSql += "       a.SOMAENT   ,"
         cSql += "       a.SOMASAI   ,"
         cSql += "       a.INTSAL    ," 
         cSql += "       a.CONTSAI   ," 
         cSql += "       a.CONTENT   ," 
         cSql += "       a.DDIAS     ," 
         cSql += "       a.S2ENT     ," 
         cSql += "       a.S2SAI     ," 
         cSql += "       a.S2SAL     ," 
         cSql += "       a.MEDENT    ," 
         cSql += "       a.MEDSAI    ," 
         cSql += "       a.MEDSAL    ," 
         cSql += "       a.TMER      ," 
         cSql += "       a.TMEA      ," 
         cSql += "       a.SENT2N    ," 
         cSql += "       a.SSAI2N    ," 
         cSql += "       a.INTS2N    ," 
         cSql += "       a.LOTEEM    ," 
         cSql += "       a.LOTESM    ," 
         cSql += "       a.SINCRON   ," 
         cSql += "       a.DPENT     ," 
         cSql += "       a.DPSAI     ," 
         cSql += "       a.DPSAL     ," 
         cSql += "       a.CVENT     ," 
         cSql += "       a.CVSAI     ," 
         cSql += "       a.CVSAL     ," 
         cSql += "       a.ESTSEG    ," 
         cSql += "       a.PREP1     ," 
         cSql += "       a.PREP2     ," 
         cSql += "       a.COBMEDIA  ,"
         cSql += "       a.GIRO      ," 
         cSql += "       a.COBINST   ," 
         cSql += "       a.RSI       ," 
         cSql += "       a.PAYBACK   ," 
         cSql += "       a.EXPRUP    ," 
         cSql += "       a.POTMEDRUP ,"
         cSql += "       a.POTINSRUP ,"
         cSql += "       a.NS1       ," 
         cSql += "       a.NS2       ," 
         cSql += "       a.CMEDIO    ," 
         cSql += "       a.MGBRUTA   ," 
         cSql += "       a.PRMEDV    ," 
         cSql += "       a.LTCOMB    ," 
         cSql += "       a.LTAPU     ," 
         cSql += "       a.SDOINI    ,"
         cSql += "       a.SDOFIN    ,"
         cSql += "       a.SDOZERO   ,"
         cSql += "       a.MAXENT    ,"
         cSql += "       a.MAXSAI    ,"
         cSql += "       a.MAXSAL    ,"
         cSql += "       a.MINENT    ,"
         cSql += "       a.MINSAI    ,"
         cSql += "       a.MINSAL    ,"
         cSql += "       a.SDOATU    ,"
         cSql += "       a.ACHEGAR   ,"
         cSql += "       a.SDOABPP1  ,"
         cSql += "       a.SDOABPP2  ,"
         cSql += "       a.SDOABPP3  ,"
         cSql += "       a.NESTQT    ,"
         cSql += "       a.NESTDIAS  ,"
         cSql += "       a.CAPMAX    ,"
         cSql += "       b.CODIGO PROCOD, "
         cSql += "       b.PRODUTO   ,"
         cSql += "       b.UN_EST    ,"
         cSql += "       b.TIPO      ,"
         cSql += "       b.ABC       ,"
         cSql += "       b.EST_MIN   ,"
         cSql += "       b.CAPAMAX   ,"
         cSql += "       b.EST_NIVEL ,"
         cSql += "       c.NS NSPRET ,"
         cSql += "       d.AG        ,"
         cSql += "       e.MAG       ,"
         cSql += "       f.BU        ,"
         cSql += "       a.RECNO"
         cSql += " from " + SetTabela("tpro202") + " a,"
         cSql +=            SetTabela("titm002") + " b,"
         cSql +=            SetTabela("tpro203") + " c,"
         cSql +=            SetTabela("titm012") + " d,"
         cSql +=            SetTabela("titm011") + " e,"
         cSql +=            SetTabela("titm010") + " f "
         cSql += " where b.RECNO = a.COD_PRO       and "
         cSql += "       c.RECNO = a.COD_CE3       and "
         cSql += "       d.RECNO = b.COD_AG        and "
         cSql += "       e.RECNO = d.COD_MAG       and "
         cSql += "       f.RECNO = d.COD_BU        and "
         cSql += "       a.RECNO = " + str(ChaveAtual())
   AbreRS(cSql,"tmp")

if tmp->(eof()) .or. tmp->DDIAS = 0
   tat("Nao ha estatistica para o Item ...",.t.)
   FechaRS("tmp")
elseif LigaImp("PB")     
   dData1       = tmp->D1
   dData2       = tmp->D2
   aDdias       = tmp->DDIAS   //dData2 - dData1 + 1
   iDiasUteis   = 0
   for i=1 to aDdias
      if E_DiaUtil(dData1+i-1)
         iDiasUteis++
      endif
   next

   iCodPro      = tmp->COD_PRO
   cCodigo      = tmp->PROCOD
   cProduto     = tmp->PRODUTO
   cUnEst       = tmp->UN_EST
   iTipoItem    = tmp->TIPO
   iLeadTime    = tmp->LTCOMB
   iNSPRET      = tmp->NSPRET
   iDiasMinAbaixo = tmp->SDOABPP1
   iDiasPR1Abaixo = tmp->SDOABPP2
   iDiasPR2Abaixo = tmp->SDOABPP3
   iDiasZerado    = tmp->SDOZERO
 
   cAG          = tmp->AG
   cMAG         = tmp->MAG 
   cBU          = tmp->BU 
   cClasse_ABC  = alltrim(tmp->ABC)
   
   do case
      case cClasse_ABC="A"
         cObsABC = "Alto valor de consumo"
      case cClasse_ABC="B"
         cObsABC = "Medio valor de consumo"
      case cClasse_ABC="C"
         cObsABC = "Baixo valor de consumo"
   endcase   


   iSaldoI      = tmp->SDOINI
   iSaldoF      = tmp->SDOFIN
   iNrEntradas  = tmp->CONTSAI
   iNrSaidas    = tmp->CONTENT
   iTotEntradas = tmp->SOMAENT
   iTotSaidas   = tmp->SOMASAI
   iMedEntradas = tmp->MEDENT
   iMedSaidas   = tmp->MEDSAI
   iMedSaldo    = tmp->MEDSAL
   iDPEntradas  = tmp->DPENT
   iDPSaidas    = tmp->DPSAI
   iDPSaldo     = tmp->DPSAL
   iMaxEntradas = tmp->MAXENT
   iMaxSaidas   = tmp->MAXSAI
   iMaxSaldo    = tmp->MAXSAL
   iMinEntradas = tmp->MINENT
   iMinSaidas   = tmp->MINSAI
   iMinSaldo    = tmp->MINSAL
   iLtMEntradas = tmp->LOTEEM
   iLtMSaidas   = tmp->LOTESM
   iCfEntradas  = tmp->CVENT
   iCfSaidas    = tmp->CVSAI
   iCfSaldo     = tmp->CVSAL
   do case
      case tmp->CVENT <= 50
         cMvEntradas  = " REPETITIVA" 
      case tmp->CVENT <= 300
         cMvEntradas  = "ESTATISTICA"
      case tmp->CVENT <= 600
         cMvEntradas  = "  OCASIONAL"
      otherwise
         cMvEntradas  = "       RARA"
   endcase
   do case
      case tmp->CVENT <= 50
         cMvSaidas  = " REPETITIVA" 
      case tmp->CVENT <= 300
         cMvSaidas  = "ESTATISTICA"
      case tmp->CVENT <= 600
         cMvSaidas  = "  OCASIONAL"
      otherwise
         cMvSaidas  = "       RARA"
   endcase
   iTMER        = tmp->TMER
   iTMEA        = tmp->TMEA
   do case
      case iTMEA <=3
         cClasse_PQR  = "P"
         cObsPQR = "Pelo menos 1 saida em 3 dias"
      case iTMEA <=30 
         cClasse_PQR  = "Q"
         cObsPQR = "Pelo menos 1 saida por mes"
      otherwise
         cClasse_PQR  = "R"
         cObsPQR = "Menos 1 saida por mes"
   endcase
   iSincronia   = tmp->SINCRON*100
   
   iGiro        = tmp->GIRO
   iCbM         = tmp->COBMEDIA
   iCbI         = tmp->COBINST
   iExpRup      = tmp->EXPRUP
   cPMR         = if(tmp->POTMEDRUP,"SIM","NAO")
   cPIR         = if(tmp->POTINSRUP,"SIM","NAO")
   
   iCM          = tmp->CMEDIO 
   iPM          = tmp->PRMEDV
   iMB          = tmp->MGBRUTA
   iRSI         = tmp->RSI
   iPB          = tmp->PAYBACK
   
   iEstSeg      = tmp->ESTSEG
   iEstSegCM    = tmp->ESTSEG*tmp->CMEDIO
   iEstSegPM    = tmp->ESTSEG*tmp->PRMEDV
   iEstMin      = tmp->EST_MIN
   iEstMinCM    = tmp->EST_MIN*tmp->CMEDIO
   iEstMinPM    = tmp->EST_MIN*tmp->PRMEDV
   iEstNiv      = tmp->EST_NIVEL
   iEstNivCM    = tmp->EST_NIVEL*tmp->CMEDIO
   iEstNivPM    = tmp->EST_NIVEL*tmp->PRMEDV
   iEstMax      = tmp->CAPAMAX
   iEstMaxCM    = tmp->CAPAMAX*tmp->CMEDIO
   iEstMaxPM    = tmp->CAPAMAX*tmp->PRMEDV
   iEstAtu      = tmp->SDOATU
   iEstAtuCM    = tmp->SDOATU*tmp->CMEDIO
   iEstAtuPM    = tmp->SDOATU*tmp->PRMEDV
   iEstACh      = tmp->ACHEGAR
   iEstAChCM    = tmp->ACHEGAR*tmp->CMEDIO
   iEstAChPM    = tmp->ACHEGAR*tmp->PRMEDV
   do case
      case tmp->SDOATU > tmp->CAPAMAX
         cZona1 = "QT EXCEDENTE      "
      case tmp->SDOATU >= tmp->EST_MIN
         cZona1 = "QT ADEQUADA       "
      case tmp->SDOATU >= tmp->ESTSEG
         cZona1 = "REPOSICAO ACIONADA"
      otherwise
         cZona1 = "CRITICO           "
   endcase
   do case
      case tmp->MEDSAL > tmp->CAPAMAX
         cZona2 = "QT EXCEDENTE      "
      case tmp->MEDSAL >= tmp->EST_MIN
         cZona2 = "QT ADEQUADA       "
      case tmp->MEDSAL >= tmp->ESTSEG
         cZona2 = "REPOSICAO ACIONADA"
      otherwise
         cZona2 = "CRITICO           "
   endcase
   iPRep1       = tmp->PREP1
   iPRep1CM     = tmp->PREP1*tmp->CMEDIO
   iPRep1PM     = tmp->PREP1*tmp->PRMEDV
   iPRepMin1    = 100*tmp->PREP1/tmp->EST_MIN
   iPRep2       = tmp->PREP2
   iPRep2CM     = tmp->PREP2*tmp->CMEDIO
   iPRep2PM     = tmp->PREP2*tmp->PRMEDV
   iPRepMin2    = 100*tmp->PREP2/tmp->EST_MIN

   iNEst1       = iPRep1+tmp->NESTQT
   iNEst1CM     = iNEst1*tmp->CMEDIO
   iNEst1Dia    = tmp->NESTDIAS
   iCapM1       = iNEst1+tmp->CAPMAX
   iCapM1CM     = iCapM1*tmp->CMEDIO
   iNEst2       = iPRep2+tmp->NESTQT
   iNEst2CM     = iNEst2*tmp->CMEDIO
   iNEst2Dia    = tmp->NESTDIAS
   iCapM2       = iNEst2+tmp->CAPMAX
   iCapM2CM     = iCapM2*tmp->CMEDIO

   do case
      case tmp->SDOATU > tmp->CAPAMAX
         cZona3 = "QT EXCEDENTE      "
      case tmp->SDOATU >= tmp->PREP1
         cZona3 = "QT ADEQUADA       "
      case tmp->SDOATU >= tmp->ESTSEG
         cZona3 = "REPOSICAO ACIONADA"
      otherwise
         cZona3 = "CRITICO           "
   endcase

   do case
      case tmp->MEDSAL > tmp->CAPAMAX
         cZona4 = "QT EXCEDENTE      "
      case tmp->MEDSAL >= tmp->PREP1  
         cZona4 = "QT ADEQUADA       "
      case tmp->MEDSAL >= tmp->ESTSEG
         cZona4 = "REPOSICAO ACIONADA"
      otherwise
         cZona4 = "CRITICO           "
   endcase

   do case
      case tmp->SDOATU > tmp->CAPAMAX
         cZona5 = "QT EXCEDENTE      "
      case tmp->SDOATU >= tmp->PREP2
         cZona5 = "QT ADEQUADA       "
      case tmp->SDOATU >= tmp->ESTSEG
         cZona5 = "REPOSICAO ACIONADA"
      otherwise
         cZona5 = "CRITICO           "
   endcase

   do case
      case tmp->MEDSAL > tmp->CAPAMAX
         cZona6 = "QT EXCEDENTE      "
      case tmp->MEDSAL >= tmp->PREP2  
         cZona6 = "QT ADEQUADA       "
      case tmp->MEDSAL >= tmp->ESTSEG
         cZona6 = "REPOSICAO ACIONADA"
      otherwise
         cZona6 = "CRITICO           "
   endcase

   FechaRS("tmp")

**************
**************
**************

   cCabecalho   = "Estatisticas e Dinamica de Estoque" 
   a = "Painel de Indicadores - Item Profile               " + dtoc(date()+2922) + " - " + time()
   @ prow()   ,(80-len(a))/2 say a
   @ prow()+1 ,        0  say replicate("_",80)
   

   @ prow()+1 ,        0  say "DADOS"
   @ prow()+1 ,        0  say "-----"
   a = dtoc(dData1) + " a " + dtoc(dData2) + " - " + transform(aDdias,"@e 99999") + " dias - " + astr(iDiasUteis) + " dias uteis"
   @ prow()   ,80-len(a)  say a
   @ prow()+1 ,        0  say replicate("_",80)


   @ prow()+1 ,        0  say "IDENTIFICACAO"
   a = alltrim(cAG) + "/" + alltrim(cMAG) + "/" + alltrim(cBU)
   @ prow()   , 80-len(a) say a
   a = alltrim(cCodigo) + "/" + alltrim(cProduto)
   @ prow()+1 ,        0  say "-------------"
   @ prow()   , 80-len(a) say a

   a = alltrim(cUnEst)  + "/" + alltrim(right(TipoItem[iTipoItem],len(TipoItem[iTipoItem])-2))
   @ prow()+1 , 80-len(a) say a
   @ prow()+1 ,        0  say "Tipo de Demanda    : " + if(pTemPai(iCodPro),"Dependente","Independente")
   @ prow()+1 ,        0  say "Classificacao (ABC): " + cClasse_ABC + " -" + cObsABC
   @ prow()+1 ,        0  say "Popularidade  (PQR): " + cClasse_PQR + " -" + cObsPQR
   @ prow()+2 ,        0  say "           LeadTime: " + transform(iLeadTime , "@e 999") + " dia(s)"
   @ prow()+1 ,        0  say "  Nivel de Servico : " + transform(iNSPRET    , "@e 99999") + " %"

   @ prow()+1 ,        0  say replicate("_",80)


/*
   @ prow()+1 ,        0  say "NIVEIS DE SERVICO"
   a = "Data Entrega Planejada  X  Entrega Efetiva  : " + transform(iNS1,"@e 999.99") + " %"
   @ prow()   , 80-len(a) say a

   @ prow()+1 ,        0  say "-----------------"
   @ prow()   , 80-len(a) say "Data Entrega Planejada  X  Emissao N.Fiscal : " + transform(iNS2,"@e 999.99") + " %"

   @ prow()+1 ,        0  say replicate("_",80)
*/


   @ prow()+1 ,        0  say "ESTATISTICAS"
   @ prow()   ,       23  say "ENTRADAS"
   @ prow()   ,       40  say "SAIDAS"
   @ prow()   ,       56  say "SALDO"
   @ prow()+1 ,        0  say "------------"
   @ prow()   ,       19  say "------------"
   @ prow()   ,       34  say "------------"
   @ prow()   ,       49  say "------------"

   @ prow()+1 ,        0  say "      Maior Valor"
   @ prow()   ,       20  say transform(iMaxEntradas,"@e 999,999,999")
   @ prow()   ,       35  say transform(iMaxSaidas  ,"@e 999,999,999")
   @ prow()   ,       50  say transform(iMaxSaldo   ,"@e 999,999,999")
   @ prow()   ,       69  say left(cUnEst,10)

   @ prow()+1 ,        0  say "      Menor Valor"
   @ prow()   ,       20  say transform(iMinEntradas,"@e 999,999,999")
   @ prow()   ,       35  say transform(iMinSaidas  ,"@e 999,999,999")
   @ prow()   ,       50  say transform(iMinSaldo   ,"@e 999,999,999")
   @ prow()   ,       69  say left(cUnEst,10)

   @ prow()+1 ,        0  say "        Media/Dia"        
   @ prow()   ,       20  say transform(iMedEntradas,"@e 999,999,999")
   @ prow()   ,       35  say transform(iMedSaidas  ,"@e 999,999,999")
   @ prow()   ,       50  say transform(iMedSaldo   ,"@e 999,999,999")
   @ prow()   ,       69  say left(cUnEst,10)

   @ prow()+1 ,        0  say "    Desvio Padrao"
   @ prow()   ,       20  say transform(iDPEntradas,"@e 999,999,999")
   @ prow()   ,       35  say transform(iDPSaidas  ,"@e 999,999,999")
   @ prow()   ,       50  say transform(iDPSaldo   ,"@e 999,999,999")
   @ prow()   ,       69  say left(cUnEst,10)


   @ prow()+1 ,        0  say "   Coef. Variacao"
   @ prow()   ,       25  say transform(iCfEntradas,"@e 999.99")
   @ prow()   ,       40  say transform(iCfSaidas  ,"@e 999.99")
   @ prow()   ,       55  say transform(iCfSaldo   ,"@e 999.99")
   @ prow()   ,       69  say "%"

   @ prow()+2 ,        0  say "    Nr.Transacoes"           
   @ prow()   ,       26  say transform(iNrEntradas,"@e 99999")
   @ prow()   ,       41  say transform(iNrSaidas  ,"@e 99999")

   @ prow()+1 ,        0  say "            Total"                        
   @ prow()   ,       20  say transform(iTotEntradas,"@e 999,999,999")
   @ prow()   ,       35  say transform(iTotSaidas  ,"@e 999,999,999")
   @ prow()   ,       69  say left(cUnEst,10)

   @ prow()+1 ,        0  say "       Lote Medio"                                             
   @ prow()   ,       20  say transform(iLtMEntradas,"@e 999,999,999")
   @ prow()   ,       35  say transform(iLtMSaidas  ,"@e 999,999,999")
   @ prow()   ,       69  say left(cUnEst,10)

   @ prow()+1 ,        0  say "     (TMER)(TMEA)"
   @ prow()   ,       25  say transform(iTMER,"@e 999.99")
   @ prow()   ,       40  say transform(iTMEA,"@e 999.99")
   @ prow()   ,       69  say "dia(s)"
   @ prow()+1 ,        0  say "     Movimentacao"
   @ prow()   ,       20  say cMvEntradas
   @ prow()   ,       35  say cMvSaidas
   @ prow()+2 ,        0  say "Sincronia (TMEA/TMER) " + transform(iSincronia,"@e 999.99") + " %"
   @ prow()+1 ,        0  say replicate("_",80)


   @ prow()+1 ,        0  say "INDICES OPERACIONAIS"
//   @ prow()   ,       45  say "Giro     " + transform(iGiro,"@e 999.99") + " vez(es) a/a"
   @ prow()+1 ,        0  say "--------------------"
//   @ prow()   ,       34  say "Cobertura Media     " + transform(iCbM ,"@e 999.99") + " dia(s)" 
   @ prow()+1 ,       20  say "        Cobertura Instantanea     " + transform(iCbI ,"@e 999.99") + " dia(s)" 
   @ prow()+1 ,       20  say "          Exposicao a Ruptura     " + transform(100*iExpRup/aDdias,"@e 999.99") + " %" 
   @ prow()+1 ,        0  say replicate("_",80)


/*
   @ prow()+1 ,        0  say "INDICES FINANCEIROS"
   @ prow()   ,       38  say "Custo Medio   " + transform(iCM,"@e 9,999.99")                                + " R$"
   @ prow()+1 ,        0  say "-------------------" 
   @ prow()   ,       38  say "Preco Medio   " + transform(iPM,"@e 9,999.99")                                + " R$"
   @ prow()+1 ,       10  say "                           Margem Bruta   " + transform(iMB, "@e 9,999.99")   + " %"
   @ prow()+1 ,       10  say "     Retorno sobre o Investimento - RSI   " + transform(iRSI,"@e 9,999.99")   + " %"
   @ prow()+1 ,       10  say "                                PayBack   " + transform(iPB, "@e 9,999.99")   + " dia(s)"
   @ prow()+1 ,        0  say replicate("_",80)
*/

   @ prow()+1 ,        0  say "DINAMICA DE ESTOQUES"
   @ prow()   ,       23  say "QT [" + right(space(9)+alltrim(left(cUnEst,9)),9) + "]"
   @ prow()   ,       39  say " Vlr C.M. [R$]"
   @ prow()+1 ,        0  say "--------------------"
   @ prow()   ,       23  say "--------------"
   @ prow()   ,       39  say "--------------"
   @ prow()+1 ,        4  say "P.Reposicao Atual  "
   @ prow()   ,       26  say transform(iEstMin  ,"@e 999,999,999")
   @ prow()   ,       39  say transform(iEstMinCM,"@e 999,999,999.99")
   @ prow()+1 ,        4  say "     Nivel Estoque "
   @ prow()   ,       26  say transform(iEstNiv  ,"@e 999,999,999")
   @ prow()   ,       39  say transform(iEstNivCM,"@e 999,999,999.99")
   @ prow()+1 ,        4  say " Capacidade Maxima "
   @ prow()   ,       26  say transform(iEstMax  ,"@e 999,999,999")
   @ prow()   ,       39  say transform(iEstMaxCM,"@e 999,999,999.99")
   @ prow()+2 ,       10  say "Saldo Atual "
   @ prow()   ,       26  say transform(iEstAtu  ,"@e 999,999,999")
   @ prow()   ,       39  say transform(iEstAtuCM,"@e 999,999,999.99")
   @ prow()+1 ,       16  say "Medio  "
   @ prow()   ,       26  say transform(iMedSaldo ,"@e 999,999,999")
   @ prow()   ,       39  say transform(iMedSaldo*iCM,"@e 999,999,999.99")
   @ prow()+1 ,       14  say "Inicial  "
   @ prow()   ,       26  say transform(iSaldoI,"@e 999,999,999")
   @ prow()   ,       39  say transform(iSaldoI*iCM,"@e 999,999,999.99")
   @ prow()+1 ,       14  say "  Final  "
   @ prow()   ,       26  say transform(iSaldoF,"@e 999,999,999")
   @ prow()   ,       39  say transform(iSaldoF*iCM,"@e 999,999,999.99")
   @ prow()+2 ,        4  say "Estoque Seguranca  "
   @ prow()   ,       26  say transform(iEstSeg  ,"@e 999,999,999")
   @ prow()   ,       39  say transform(iEstSegCM,"@e 999,999,999.99")

   @ prow()+2 ,        1  say "Ponto de Reposicao 1  "
   @ prow()   ,       26  say transform(iPRep1  ,"@e 999,999,999")
   @ prow()   ,       39  say transform(iPRep1CM,"@e 999,999,999.99")
   @ prow()   ,       55  say transform(iPRepMin1,"@e 999.99") + " %"

   @ prow()+1 ,        1  say "Nivel Estoque PREP 1  "
   @ prow()   ,       26  say transform(iNEst1   ,"@e 999,999,999")
   @ prow()   ,       39  say transform(iNEst1CM ,"@e 999,999,999.99")
   @ prow()   ,       55  say transform(iNEst1Dia,"@e 999.99") + " [dias]"

   @ prow()+1 ,        1  say "Capacidade Max PREP1  "
   @ prow()   ,       26  say transform(iCapM1   ,"@e 999,999,999")
   @ prow()   ,       39  say transform(iCapM1CM ,"@e 999,999,999.99")

   @ prow()+2 ,        1  say "Ponto de Reposicao 2  "
   @ prow()   ,       26  say transform(iPRep2  ,"@e 999,999,999")
   @ prow()   ,       39  say transform(iPRep2CM,"@e 999,999,999.99")
   @ prow()   ,       55  say transform(iPRepMin2,"@e 999.99") + " %"

   @ prow()+1 ,        1  say "Nivel Estoque PREP 2  "
   @ prow()   ,       26  say transform(iNEst2   ,"@e 999,999,999")
   @ prow()   ,       39  say transform(iNEst2CM ,"@e 999,999,999.99")
   @ prow()   ,       55  say transform(iNEst2Dia,"@e 999.99") + " [dias]"

   @ prow()+1 ,        1  say "Capacidade Max PREP2  "
   @ prow()   ,       26  say transform(iCapM2   ,"@e 999,999,999")
   @ prow()   ,       39  say transform(iCapM2CM ,"@e 999,999,999.99")

   @ prow()+1 ,        0  say "(Candidatos Est.Min.)"
   a = "(Relacao ao"
   @ prow()   ,80-len(a)  say a
   a = "Est.Minimo)"
   @ prow()+1 ,80-len(a)  say a
   @ prow()+1 ,        0  say replicate("_",80)

   @ prow()+1 ,        0  say "COMENTARIOS"                                
   @ prow()+1 ,        0  say "-----------"                                
   @ prow()+1 ,        2  say "Zona de Operacao do Estoque Atual: " + cZona1 + " (visto do P.Reposicao Atual)"
   @ prow()+1 ,        2  say "                      Saldo Medio: " + cZona2

   @ prow()+2 ,        2  say "                    Estoque Atual: " + cZona3 + " (visto do P.Reposicao 1)"
   @ prow()+1 ,        2  say "                      Saldo Medio: " + cZona4

   @ prow()+2 ,        2  say "                    Estoque Atual: " + cZona5 + " (visto do P.Reposicao 2)"
   @ prow()+1 ,        2  say "                      Saldo Medio: " + cZona6

   a = "Durante "  + transform(iDiasMinAbaixo,"@e 9999") +"[dias] ou " + transform(100*iDiasMinAbaixo/aDdias,"@e 999.99") + " [%] do tempo a SKU esteve abaixo do Ponto de Reposicao Atual"
   @ prow()+2 ,        2  say a
   a = "Durante " + transform(iDiasPR1Abaixo,"@e 9999") +"[dias] ou "+ transform(100*iDiasPR1Abaixo/aDdias,"@e 999.99") + " [%] do tempo a SKU esteve abaixo do Ponto de Reposicao 1"
   @ prow()+1 ,        2  say a
   a = "Durante " + transform(iDiasPR2Abaixo,"@e 9999") +"[dias] ou "+ transform(100*iDiasPR2Abaixo/aDdias,"@e 999.99") + " [%] do tempo a SKU esteve abaixo do Ponto de Reposicao 2"
   @ prow()+1 ,        2  say a
   a = "Durante " + transform(iExpRup,"@e 9999") +"[dias] ou "+ transform(100*iExpRup/aDdias,"@e 999.99") + " [%] do tempo a SKU esteve abaixo do Est.Seguranca -exposicao"
   @ prow()+1 ,        2  say a
   a = "Durante " + transform(iDiasZerado,"@e 9999") +"[dias] ou " + transform(100*iDiasZerado/aDdias,"@e 999.99") + " [%] do tempo o item esteve com saldo <= 0          -ruptura"
   @ prow()+1 ,        2  say a

   @ prow()+1 ,        0  say replicate("_",80)
   @ prow()+1 ,        0  say space(80)
   @ prow()+1 ,        0  say space(80)
   @ prow()+1 ,        0  say space(80)
   @ prow()+1 ,        0  say space(80)
   @ prow()+1 ,        0  say space(80)
   @ prow()+1 ,        0  say space(80)
   @ prow()+1 ,        0  say space(80)
   @ prow()+1 ,        0  say space(80)
   DesligaImp(.t.)
endif
RETURN(.t.)

/*

* Alterar Niveis de Estoque e estoques minimos
* Alterar Niveis de Servico e Tempos de Estoque
* Alterar volume de vendas -> isso reprograma os itens de demanda dependente

* y  = ax     E[y]  = E[ax]    = aE[x]
* y2 = a2x2   E[y2] = E[a2x2]  = a2E[x2]
* Vy  = E[y2]   - (E[y])2
* Vy  = a2E[x2] -  a2E[x]2
* Vy  = a2(E[x2] - E[x]2) 
* Vy  = a2Vx
* DPy = aDPx

* My = CoefBx .Mx + CoefBw .Mw
* Vy = CoefBx2.Vx + CoefBw2.Vw

* atencao aos dias uteis no processo
* filho -> pai
              - media saidas periodo
	      - dp saidas    periodo

              - media saida pretendida - via total de venda pretendido no periodo - parametro do cenario
               (novo calculo de media, dp, eseg, p.reposicao,giro, ...

              - CoefBom
	      - Indices de conversao
*/

*****************
FUNCTION RelSKU()
*****************
local cSql
local p
***
   Mens(maxrow()-1,maxrow(),d_ESP)

   iCodCE1     = ChaveAtual(1)
   iNrProdutos = 0
   
   cSql        = " select a.COD_PRO   ,"
   cSql       += "        a.CMEDIO    ,"
   cSql       += "        a.PRMEDV    ,"
   cSql       += "        b.CODIGO    ,"
   cSql       += "        b.PRODUTO   ,"
   cSql       += "        b.TIPO      ,"
   cSql       += "        c.AG        ,"
   cSql       += "        d.MAG       ,"
   cSql       += "        e.BU        ,"
   cSql       += "        a.MGBRUTA   ,"
   cSql       += "        b.CAPAMAX   ,"
   cSql       += "        b.EST_MIN   ,"
   cSql       += "        b.EST_NIVEL ,"
   cSql       += "        b.UN_EST    ,"
   cSql       += "        a.D1        ,"
   cSql       += "        a.D2        ,"
   cSql       += "        a.DE        ,"
   cSql       += "        a.LTCOMB    ,"
   cSql       += "        a.COD_CE3   ,"
   cSql       += "        a.NS1       ,"
   cSql       += "        a.MEDSAI    ,"
   cSql       += "        a.DPSAI     ,"
   cSql       += "        a.MEDSAL    ,"
   cSql       += "        a.TMEA      ,"
   cSql       += "        a.Y_B       ,"
   cSql       += "        a.Y_C       ,"     
   cSql       += "        f.CI1        ," 
   cSql       += "        f.CI2       ," 
   cSql       += "        f.CI3        ," 
   cSql       += "        f.PV1        ," 
   cSql       += "        f.PV2        ," 
   cSql       += "        f.PV3       ," 
   cSql       += "        f.CMD1      ," 
   cSql       += "        f.CMD2      ," 
   cSql       += "        f.CMD3      ," 
   cSql       += "        f.VMD1      ," 
   cSql       += "        f.VMD2      ," 
   cSql       += "        f.VMD3      ," 
   cSql       += "        a.RSI       ," 
   cSql       += "        a.PAYBACK    " 
   cSql       += " from " + SetTabela("tpro202") + " a,"
   cSql       +=            SetTabela("titm002") + " b,"
   cSql       +=            SetTabela("titm012") + " c,"
   cSql       +=            SetTabela("titm011") + " d,"
   cSql       +=            SetTabela("titm010") + " e,"
   cSql       +=            SetTabela("tpro201") + " f "
   cSql       += " where a.RECNO = " + astr(ChaveAtual()) + " and "
   cSql       += "       b.RECNO = a.COD_PRO       and "
   cSql       += "       c.RECNO = b.COD_AG        and "
   cSql       += "       d.RECNO = c.COD_MAG       and "
   cSql       += "       e.RECNO = d.COD_BU        and "
   cSql       += "       f.RECNO = a.COD_CE1"

   local aArray := rdd_select(cSql)

   iCodPro     = aArray[ 1]
   iCM         = aArray[ 2]
   iPM         = aArray[ 3]
   cCodigo     = aArray[ 4]
   cProduto    = aArray[ 5]
   iTipoItem   = aArray[ 6]
   cAG         = aArray[ 7]
   cMAG        = aArray[ 8]
   cBU         = aArray[ 9]
   iMB         = aArray[10]
   iEstMax     = aArray[11]
   iEstMin     = aArray[12]
   iEstNiv     = aArray[13]       
   cUnEst      = aArray[14]
   dData1      = ctod(BrData(aArray[15]))
   dData2      = ctod(BrData(aArray[16]))
   iDE         = aArray[17]
   iLT         = aArray[18]
   iCodCE3     = aArray[19]
   iNSA        = alltrim(aArray[20])
   iYA         = aArray[21]   
   iDPA        = aArray[22]                          
   iSMA        = aArray[23]                            
   iTMEA       = aArray[24]
   iYB         = aArray[25]  
   iYC         = aArray[26]                 
   iCp1ImbG    = aArray[27]
   iPotV1G     = aArray[28]             
   iCMD1G      = aArray[29]            
   iVMD1G      = aArray[30]            
   iCp2ImbG    = aArray[31]
   iPotV2G     = aArray[32]             
   iCMD2G      = aArray[33]            
   iVMD2G      = aArray[34]            
   iCp3ImbG    = aArray[35]
   iPotV3G     = aArray[36]             
   iCMD3G      = aArray[37]            
   iVMD3G      = aArray[38]            
   iRSI1I      = aArray[39]                   
   iPB1I       = aArray[40]            

   iCV         = iDPA/iYA

   cSql        = "select NS,FS from " +  SetTabela("tpro203") + " where RECNO = " + astr(iCodCE3)
   aArray      = rdd_select(cSql)
   iNSB        = alltrim(aArray[1])
   iFSB        = aArray[2]

   aDdias      = dData2 - dData1 + 1
   iDiasUteis   = 0
   for i=1 to aDdias
      if E_DiaUtil(dData1+i-1)
         iDiasUteis++
      endif
   next

   lPA         = if(pTemPai(iCodPro),"Dependente","Independente")
   cTipoDemanda= lPA

   p           = fSKUQualP(iCodPro)
   iDPB        = iCV*iYB
   iEstSegB    = iDPB * iFSB
   iPRep1B     = iYB * (iDE+iLT) + iEstSegB
   iPRep2B     = (iDE+iLT)*iYB/iTMEA + iFSB*iDPB/((iDE+iLT)/iTMEA)^(1/2)
   iSMB        = ((iEstNiv+iPRep1B)/2 + (iEstNiv+iPRep2B)/2 )/2


   iDPC        = iCV*iYC
   iEstSegC    = iDPC + iFSB
   iPRep1C     = iYC * (iDE+iLT) + iEstSegC       
   iPRep2C     = (iDE+iLT    ) *iYC/iTMEA + iFSB*iDPC/((iDE+iLT)/iTMEA)^(1/2)
   iSMC        = ((iEstNiv+iPRep1C)/2 + (iEstNiv+iPRep2C)/2 )/2
   

   iCbA        = iSMA/iYA
   iCbB        = iSMB/iYB
   iCbC        = iSMC/iYC

   iGiroA      = 365/iCbA
   iGiroB      = 365/iCbB
   iGiroC      = 365/iCbC

   iCp1ImbI    = iSMA * iCM
   iCp2ImbI    = iSMB * iCM
   iCp3ImbI    = iSMC * iCM

   iPotV1I     = iSMA * iPM    
   iPotV2I     = iSMB * iPM             
   iPotV3I     = iSMC * iPM             

   iCMD1I      = iYA  * iCM   
   iCMD2I      = iYB  * iCM   
   iCMD3I      = iYC  * iCM   

   iVMD1I      = iYA  * iPM  
   iVMD2I      = iYB  * iPM   
   iVMD3I      = iYC  * iPM   


*   aRSI         = 100*((iValFat-(iQtFat*iCusto))             / (aMedSal*iCusto))
*   aMGBruta     = 100*((iValFat-(iQTFat*iCusto))/iValFat)

*  iRSI2I      = iMB*iYB*aDdias*iPM/(iSMB*iCM)     
*  iRSI3I      = iMB*iYC*aDdias*iPM/(iSMC*iCM)     

   iRSI2I      = iRSI1I*iSMA/iSMB     
   iRSI3I      = iRSI1I*iSMA/iSMC     

   iPB2I       = 365/iRSI2I            
   iPB3I       = 365/iRSI3I            


***

if LigaImp("PB")

   a = "Caso / Cenario - de " + dtoc(dData1) + " a " + dtoc(dData2) + " - " + astr(aDdias) + " dias - " + astr(iDiasUteis) + " uteis"
   cCabecalho = a
   @ 0       ,(80-len(a))/2 say a
   @ prow()+1,            0 say replicate("_",80)
   
   @ prow()+1,        0 say "ANALISE INDIVIDUAL"
   a = alltrim(cCodigo)+"/"+alltrim(cProduto)
   @ prow()  ,80-len(a) say a
   @ prow()+1,        0 say "------------------"
   a = alltrim(cAg)+"/"+alltrim(cMag)+"/"+alltrim(cBU)
   @ prow()  ,80-len(a) say a
   a = alltrim(right(TipoItem[iTipoItem],len(TipoItem[iTipoItem])-2))+"/"+alltrim(cUnEst)
   @ prow()+1,80-len(a) say a   
   a = "        Est. Maximo " + transform(iEstMax,"@e 999,999,999") + " " + cUnEst
   @ prow()+1,       0  say a        
   a = "Tipo de Demanda - " + cTipoDemanda
   @ prow()  ,80-len(a) say a        
   a = "        Est. Minimo " + transform(iEstMin,"@e 999,999,999") + " " + cUnEst
   @ prow()+1,       0  say a        
   a = "         Est. Nivel " + transform(iEstNiv,"@e 999,999,999") + " " + cUnEst
   @ prow()+1,       0  say a        
   a = "        Custo Medio " + transform(iCM,"@E 999,999.99") + "  R$"
   @ prow()+1,       0  say a        
   a = "        Preco Medio " + transform(iPM,"@E 999,999.99") + "  R$"
   @ prow()+1,       0  say a        
   a = "       Margem Bruta " + transform(iMB,"@e 999,999.99") + "  %"
   @ prow()+1,       0  say a        
   a = "  N.Servico Apurado     " + transform(val(iNSA),"@e 999.99") + "  %" 
   @ prow()+1,       0  say a        
   a = " N.Servico Desejado      " + strtran(strtran(iNSB,".",",")," %","  %") 
   @ prow()+1,       0  say a        
   a = "    Dias de Estoque " + transform(iDE,"@e 999,999") + "     dia(s)"
   @ prow()+1,       0  say a        
   a = "          Lead Time " + transform(iLT,"@e 999,999") + "     dia(s)"
   @ prow()+1,       0  say a        

   @ prow()+2,      27  say "   CASO"
   @ prow()  ,      37  say "   BALANCEANDO"
   @ prow()  ,      58  say "   CENARIO"

   @ prow()+1,      27  say "-------"
   @ prow()  ,      37  say "--------------"
   @ prow()  ,      58  say "----------"

   @ prow()+1,       0  say "      Media Saidas"
   @ prow()  ,      20  say transform(iYA ,"@E 999,999,999")
   @ prow()  ,      37  say transform(iYB ,"@E 999,999,999")
   @ prow()  ,      54  say transform(iYC ,"@E 999,999,999")
   @ prow()  ,      75  say left(cUnEst,5)
   @ prow()+1,       0  say "     Desvio Padrao"
   @ prow()  ,      20  say transform(iDPA,"@E 999,999,999")
   @ prow()  ,      37  say transform(iDPB,"@E 999,999,999")
   @ prow()  ,      54  say transform(iDPC,"@E 999,999,999")
   @ prow()  ,      75  say left(cUnEst,5)

   @ prow()+1,       0  say "       Saldo Medio"
   @ prow()  ,      20  say transform(iSMA ,"@e 999,999,999")
   @ prow()  ,      37  say transform(iSMB ,"@e 999,999,999")
   @ prow()  ,      54  say transform(iSMC ,"@e 999,999,999")
   @ prow()  ,      75  say left(cUnEst,5)

   @ prow()+1,       0  say "   Cobertura Media"
   @ prow()  ,      20  say transform(iCbA,"@e 999,999.999")
   @ prow()  ,      37  say transform(iCbB,"@E 999,999.999")
   @ prow()  ,      54  say transform(iCbC,"@E 999,999.999")
   @ prow()  ,      75  say "dia(s)"

   @ prow()+1,       0  say "              Giro"
   @ prow()  ,      20  say transform(iGiroA,"@e 999,999.999")
   @ prow()  ,      37  say transform(iGiroB,"@E 999,999.999")
   @ prow()  ,      54  say transform(iGiroC,"@E 999,999.999")
   @ prow()  ,      75  say "a/a"         

   @ prow()+2,       0  say " Estoque Seguranca"
   @ prow()  ,      37  say transform(iEstSegB,"@E 999,999,999")
   @ prow()  ,      54  say transform(iEstSegC,"@E 999,999,999")
   @ prow()  ,      75  say left(cUnEst,5)

   @ prow()+1,       0  say "     P.Reposicao 1"
   @ prow()  ,      37  say transform(iPRep1B,"@e 999,999,999")
   @ prow()  ,      54  say transform(iPRep1C,"@e 999,999,999")
   @ prow()  ,      75  say left(cUnEst,5)

   @ prow()+1,       0  say "     P.Reposicao 2"
   @ prow()  ,      37  say transform(iPRep2B,"@e 999,999,999")
   @ prow()  ,      54  say transform(iPRep2C,"@e 999,999,999")
   @ prow()  ,      75  say left(cUnEst,5)

   @ prow()+2,       0  say "   Cap.Imobilizado"
   @ prow()  ,      20  say transform(iCp1ImbI,"@e 999,999,999.99")
   @ prow()  ,      37  say transform(iCp2ImbI,"@e 999,999,999.99")
   @ prow()  ,      54  say transform(iCp3ImbI,"@e 999,999,999.99")
   @ prow()  ,      75  say "R$"
   @ prow()+1,       0  say "  Vl.Venda Estoque"
   @ prow()  ,      20  say transform(iPotV1I,"@e 999,999,999.99")
   @ prow()  ,      37  say transform(iPotV2I,"@e 999,999,999.99")
   @ prow()  ,      54  say transform(iPotV3I,"@e 999,999,999.99")
   @ prow()  ,      75  say "R$"
   @ prow()+1,       0  say "         Venda/dia"
   @ prow()  ,      20  say transform(iVMD1I,"@e 999,999,999.99")
   @ prow()  ,      37  say transform(iVMD2I,"@e 999,999,999.99")
   @ prow()  ,      54  say transform(iVMD3I,"@e 999,999,999.99")
   @ prow()  ,      75  say "R$"
   @ prow()+1,       0  say "         Custo/dia"
   @ prow()  ,      20  say transform(iCMD1I,"@e 999,999,999.99")
   @ prow()  ,      37  say transform(iCMD2I,"@e 999,999,999.99")
   @ prow()  ,      54  say transform(iCMD3I,"@e 999,999,999.99")
   @ prow()  ,      75  say "R$"
   @ prow()+1,       0  say " Ret.Cap.Investido"
   @ prow()  ,      20  say transform(iRSI1I,"@e 999,999,999.99")
   @ prow()  ,      37  say transform(iRSI2I,"@e 999,999,999.99")
   @ prow()  ,      54  say transform(iRSI3I,"@e 999,999,999.99")
   @ prow()  ,      75  say "%"
   @ prow()+1,       0  say "          Pay Back"
   @ prow()  ,      20  say transform(iPB1I,"@e 999,999,999.99")
   @ prow()  ,      37  say transform(iPB2I,"@e 999,999,999.99")
   @ prow()  ,      54  say transform(iPB3I,"@e 999,999,999.99")
   @ prow()  ,      75  say "dias"

   @ prow()+1,       0 say replicate("_",80)
   
   @ prow()+1,       0 say "ANALISE GLOBAL"
   @ prow()+1,       0 say "--------------"
   @ prow()+1,      27  say "   CASO"
   @ prow()  ,      37  say "   BALANCEANDO"
   @ prow()  ,      58  say "   CENARIO"

   @ prow()+1,      27  say "-------"
   @ prow()  ,      37  say "--------------"
   @ prow()  ,      58  say "----------"
   @ prow()+1,       0  say "   Cap.Imobilizado" 
   @ prow()  ,      20  say transform(iCp1ImbG,"@e 999,999,999.99")
   @ prow()  ,      37  say transform(iCp2ImbG,"@e 999,999,999.99")
   @ prow()  ,      54  say transform(iCp3ImbG,"@e 999,999,999.99")
   @ prow()  ,      75  say "R$"
   @ prow()+1,       0  say "  Vl.Venda Estoque"
   @ prow()  ,      20  say transform(iPotV1G,"@e 999,999,999.99")
   @ prow()  ,      37  say transform(iPotV2G,"@e 999,999,999.99")
   @ prow()  ,      54  say transform(iPotV3G,"@e 999,999,999.99")
   @ prow()  ,      75  say "R$"
   @ prow()+1,       0  say "         Venda/dia"
   @ prow()  ,      20  say transform(iVMD1G,"@e 999,999,999.99")
   @ prow()  ,      37  say transform(iVMD2G,"@e 999,999,999.99")
   @ prow()  ,      54  say transform(iVMD3G,"@e 999,999,999.99")
   @ prow()  ,      75  say "R$"
   @ prow()+1,       0  say "      Custo/diario"
   @ prow()  ,      20  say transform(iCMD1G,"@e 999,999,999.99")
   @ prow()  ,      37  say transform(iCMD2G,"@e 999,999,999.99")
   @ prow()  ,      54  say transform(iCMD3G,"@e 999,999,999.99")
   @ prow()  ,      75  say "R$"
   @ prow()+1,       0 say replicate("_",80)

   @ prow()+1,0 say space(80)
   @ prow()+1,0 say space(80)
   @ prow()+1,0 say space(80)
   @ prow()+1,0 say space(80)
   DesligaImp(.t.)
endif
RETURN(.t.)

********************
FUNCTION RelSKUSdo()
********************
Mens(maxrow()-1,maxrow(),d_ESP)
local i
local a
local cSql
local aArray := {}
local cWhere
iCabec80_132   = 80
iPaginaInicial = 0
sTipoLetra     = "m_12"
cLenLinha      = 132
cQuebra        = ""
lQuebra        = .f.
lNovaPaginaQuebra = .f.
cQuebraTitulo  = ""
cQuebraCampo   = ""
lCabec         = .t.
lCabec2Dedicado = .f.
RelFiltroLinha = ""
iQtCampos      = 9
declare vRGrid[7,iQtCampos]

* Cabecalhos
vRGrid[1, 1] = "CODIGO"
vRGrid[1, 2] = "PRODUTO"
vRGrid[1, 3] = "UN.EST"
vRGrid[1, 4] = "   SDO CASO"
vRGrid[1, 5] = "    VALOR CMed"
vRGrid[1, 6] = "SDO BALANCO"
vRGrid[1, 7] = "    VALOR CMed"
vRGrid[1, 8] = "SDO CENARIO"
vRGrid[1, 9] = "    VALOR CMed" 

* Campos
vRGrid[2, 1] = "left(rel->codigo,6)"
vRGrid[2, 2] = "left(rel->produto,30)"
vRGrid[2, 3] = "left(rel->un_est,5)"                                     
vRGrid[2, 4] = "rel->MEDSAL"
vRGrid[2, 5] = "rel->MEDSAL*rel->CMEDIO"
vRGrid[2, 6] = "rel->SM_b"                                       
vRGrid[2, 7] = "rel->SM_b*rel->CMEDIO"
vRGrid[2, 8] = "rel->SM_c"             
vRGrid[2, 9] = "rel->SM_c*rel->CMEDIO"

* Pictures
vRGrid[3, 1] = ""
vRGrid[3, 2] = ""
vRGrid[3, 3] = ""
vRGrid[3, 4] = "@e 999,999,999"
vRGrid[3, 5] = "@e 999,999,999.99"
vRGrid[3, 6] = "@e 999,999,999"
vRGrid[3, 7] = "@e 999,999,999.99"  
vRGrid[3, 8] = "@e 999,999,999"  
vRGrid[3, 9] = "@e 999,999,999.99"  


* Colunas
vRGrid[4, 1] = 0   && Forco quebras de linhas dessa forma
vRGrid[4, 2] = 1  
vRGrid[4, 3] = 1  
vRGrid[4, 4] = 1  
vRGrid[4, 5] = 1  
vRGrid[4, 6] = 1  
vRGrid[4, 7] = 1  
vRGrid[4, 8] = 1  
vRGrid[4, 9] = 1  

* Totaliza 
vRGrid[5, 1] = .f.
vRGrid[5, 2] = .f.
vRGrid[5, 3] = .f.
vRGrid[5, 4] = .f.
vRGrid[5, 5] = .t.
vRGrid[5, 6] = .f.
vRGrid[5, 7] = .t.
vRGrid[5, 8] = .f.
vRGrid[5, 9] = .t.

* Zerar Totalizadores-Parciais
vRGrid[6, 1] = 0  
vRGrid[6, 2] = 0  
vRGrid[6, 3] = 0  
vRGrid[6, 4] = 0  
vRGrid[6, 5] = 0  
vRGrid[6, 6] = 0  
vRGrid[6, 7] = 0  
vRGrid[6, 8] = 0  
vRGrid[6, 9] = 0  

* Zerar Totalizadores-Gerais  
vRGrid[7, 1] = 0  
vRGrid[7, 2] = 0  
vRGrid[7, 3] = 0  
vRGrid[7, 4] = 0  
vRGrid[7, 5] = 0  
vRGrid[7, 6] = 0  
vRGrid[7, 7] = 0  
vRGrid[7, 8] = 0  
vRGrid[7, 9] = 0  

***
   Mens(maxrow()-1,maxrow(),d_ESP)
   cCabecalho    = "Saldos Medios do Caso / Balanceado / Cenario"
   if LigaImp("PB")  && Papel Branco
      cSql  = " select b.CODIGO ,"
      cSql += "        b.PRODUTO,"
      cSql += "        b.UN_EST ,"
      cSql += "        a.MEDSAL ,"
      cSql += "        a.SM_b   ,"
      cSql += "        a.SM_c   ,"
      cSql += "        a.CMEDIO ,"
      cSql += "        a.RECNO "
      cSql += " from " + SetTabela("tpro202") + " a, " 
      cSql +=            SetTabela("titm002") + " b  "
      cSql += " where a.COD_PRO = b.RECNO and "
      cSql += "       a.COD_CE1 = " + astr(ChaveAtual(1)) 
      cSql += " order by b.CODIGO" 
      AbreRS(cSql,"REL")
      RelImpressao("RelSKUSdo")
      FechaRS("REL")
      DesligaImp(.t.)
   endif      
***   
RETURN(.t.)

****************************
FUNCTION fNivOperMPDE(iTipo)
****************************
Mens(maxrow()-1,maxrow(),d_ESP)
* Relatorio Nivel de Operacao MPDE
**********************************
local i
local a

local cSql
local cWhere := ""


iCabec80_132   = 80
iPaginaInicial = 0
sTipoLetra     = "m_10_cond"
cLenLinha      = 80
cQuebra        = ""
lQuebra        = .t.
lNovaPaginaQuebra = .f.
cQuebraTitulo  = "Tipo de Item: "
cQuebraCampo   = "TipoItem[rel->valor1]+'/ '+CatItem[rel->valor2]"
lCabec         = .t.
lCabec2Dedicado = .f.
RelFiltroLinha = ""
iQtCampos      = 3

declare vRGrid[7,iQtCampos]

* Cabecalhos
vRGrid[1,1]   = "CODIGO"
vRGrid[1,2]   = "PRODUTO"
vRGrid[1,3]   = "NIVEL OPERACAO"

* Campos
vRGrid[2,1]   = "left(rel->CARACTER1,10)"
vRGrid[2,2]   = "left(rel->CARACTER2,30)"
vRGrid[2,3]   = "rel->CARACTER3"

* Pictures
vRGrid[3,1]   = ""
vRGrid[3,2]   = ""
vRGrid[3,3]   = ""

* Colunas
vRGrid[4,1]   = 0   && Forco quebras de linhas dessa forma
vRGrid[4,2]   = 1
vRGrid[4,3]   = 1

* Totaliza
vRGrid[5,1]   = .f.
vRGrid[5,2]   = .f.
vRGrid[5,3]   = .f.

* Zerar Totalizadores-Parciais
vRGrid[6,1]   = 0
vRGrid[6,2]   = 0
vRGrid[6,3]   = 0

* Zerar Totalizadores-Gerais
vRGrid[7,1]   = 0
vRGrid[7,2]   = 0
vRGrid[7,3]   = 0

cSql  = " select b.TIPO,b.CATEGORIA,b.CODIGO,b.PRODUTO,b.EST_MIN P1,a.PREP1 P2,a.PREP2 P3,a.ESTSEG,b.CAPAMAX,sum(d.QT_EST-d.QT_ACO) QT_EST, sum(d.QT_EST) xxx "
cSql += " from "+SetTabela("tpro202") +" a,"
cSql +=          SetTabela("titm002") +" b,"
cSql +=          SetTabela("tpro201") +" c,"
cSql +=          SetTabela("titm014a")+" d,"
cSql +=          SetTabela("titm014") +" e "
cSql += " where a.COD_PRO    = b.RECNO    and "
cSql += "       d.COD_PRO    = a.COD_PRO  and "
cSql += "       d.COD_LOC    = e.RECNO    and "
cSql += "       e.ACONSELHAR = 1          and "
cSql += "       c.RECNO      = "+str(ChaveAtual(1))+"         and "
cSql += "       b.EST_MIN    > 0          and "
cSql += "       a.PREP1      > 0          and "
cSql += "       a.PREP2      > 0          and "
cSql += "       a.CMEDIO     > 0          and "
cSql += "       a.D2-a.D1    > 10         and "
cSql += "       a.COD_CE1    = c.RECNO    and "
cSql += "       a.COD_CE3    > 0          and "
cSql += "       a.DE         > 0          and "
cSql += "       a.D1         is not null  and "
cSql += "       a.D2         is not null      "
cSql += " group by  b.TIPO,b.CATEGORIA,b.CODIGO,b.PRODUTO,b.EST_MIN,a.PREP1,a.PREP2,a.ESTSEG,b.CAPAMAX "
cSql += " order by b.TIPO,b.CATEGORIA,b.CODIGO "
NrProcesso = GerarContador("PROCESSO")
AbreRS(cSql,"tmp")
local nOperacao := ""
local nRupt     := 0
local nCrit     := 0
local nDisp     := 0
local nCobe     := 0
local nExce     := 0
local nTotal    := 0
local uai       := .t.
if tmp->(eof())
   TAT("Sem Registros...",.t.)
   uai = .f.
endif
while !tmp->(eof()) .and. uai
   ++nTotal
   do case
      case tmp->QT_EST <= 0
         nOperacao = "1-Ruptura"
         ++nRupt
      case tmp->QT_EST <= tmp->ESTSEG
         nOperacao = "2-Critica"
         ++nCrit
      case tmp->QT_EST <= tmp->P1 .and. iTipo = 1
         nOperacao = "3-Disparo Ponto Atual"
         ++nDisp
      case tmp->QT_EST <= tmp->P2 .and. iTipo = 2
         nOperacao = "3-Disparo Ponto Classico"
         ++nDisp
      case tmp->QT_EST <= tmp->P3 .and. iTipo = 3
         nOperacao = "3-Disparo Ponto Reposicao MPDE"
         ++nDisp
      case tmp->QT_EST <= tmp->CAPAMAX
         nOperacao = "4-Coberto"
         ++nCobe
      case tmp->QT_EST > tmp->CAPAMAX
         nOperacao = "5-Excesso"
         ++nExce
   endcase
   cSql = "insert into "+SetTabela("ttmp000")+" (PROCESSO,VALOR1,VALOR2,CARACTER1,CARACTER2,CARACTER3) values ("+str(NrProcesso)+","+str(tmp->TIPO)+","+str(tmp->CATEGORIA)+",'"+tmp->CODIGO+"','"+tmp->PRODUTO+"','"+nOperacao+"')"
   uai = rdd_insert(cSql)
   tmp->(dbskip())
end
FechaRS("tmp")

cCabecalho = "Nivel de Operacao Estoques (Rupt:"+transform(nRupt/nTotal*100,"@E 999")+"%)(Crit:"+transform(nCrit/nTotal*100,"@e 999")+"%)(Disp:"+transform(nDisp/nTotal*100,"@e 999")+"%)(Cob:"+transform(nCobe/nTotal*100,"@e 999")+"%)(Exc:"+transform(nExce/nTotal*100,"@e 999")+"%)"


if !lastkey()=27 .and. Mens(maxrow()-1,maxrow(),d_ESP) .and. uai
   cSql = "select VALOR1,VALOR2,CARACTER1,CARACTER2,CARACTER3,RECNO from "+SetTabela("ttmp000")+" where PROCESSO = "+str(NrProcesso)+" order by VALOR1,VALOR2,CARACTER3"
   if LigaImp("PB")  && Papel Branco
      AbreRS(cSql,"REL")
      RelImpressao("NivOper")
      FechaRS("REL")
      DesligaImp(.t.)
   endif
endif
rdd_rollbck()
RETURN(.t.)

***************************
FUNCTION fCompSumPRepMPDE()
***************************
Mens(maxrow()-1,maxrow(),d_ESP)
* Relatorio Nivel de Operacao MPDE
**********************************
local i
local a

local cSql
local cWhere := ""


iCabec80_132   = 80
iPaginaInicial = 0
sTipoLetra     = "m_10_cond"
cLenLinha      = 80
cQuebra        = ""
lQuebra        = .f.
lNovaPaginaQuebra = .f.
cQuebraTitulo  = ""
cQuebraCampo   = ""
lCabec         = .t.
lCabec2Dedicado = .f.
RelFiltroLinha = ""
iQtCampos      = 5

declare vRGrid[7,iQtCampos]

* Cabecalhos
vRGrid[1,1]   = "TIPO"
vRGrid[1,2]   = "CATEGORIA"
vRGrid[1,3]   = "PRAtual*CM"
vRGrid[1,4]   = "PrClassico*CM"
vRGrid[1,5]   = "PrIMAM*CM"

* Campos
vRGrid[2,1]   = "TipoItem[rel->TIPO]"
vRGrid[2,2]   = "left(CatItem[rel->CATEGORIA],15)"
vRGrid[2,3]   = "rel->V1"
vRGrid[2,4]   = "rel->V2"
vRGrid[2,5]   = "rel->V3"

* Pictures
vRGrid[3,1]   = ""
vRGrid[3,2]   = ""
vRGrid[3,3]   = "@ez 999,999,999.99"
vRGrid[3,4]   = "@ez 999,999,999.99"
vRGrid[3,5]   = "@ez 999,999,999.99"

* Colunas
vRGrid[4,1]   = 0   && Forco quebras de linhas dessa forma
vRGrid[4,2]   = 1
vRGrid[4,3]   = 1
vRGrid[4,4]   = 1
vRGrid[4,5]   = 1

* Totaliza
vRGrid[5,1]   = .f.
vRGrid[5,2]   = .f.
vRGrid[5,3]   = .f.
vRGrid[5,4]   = .f.
vRGrid[5,5]   = .f.

* Zerar Totalizadores-Parciais
vRGrid[6,1]   = 0
vRGrid[6,2]   = 0
vRGrid[6,3]   = 0
vRGrid[6,4]   = 0
vRGrid[6,5]   = 0

* Zerar Totalizadores-Gerais
vRGrid[7,1]   = 0
vRGrid[7,2]   = 0
vRGrid[7,3]   = 0
vRGrid[7,4]   = 0
vRGrid[7,5]   = 0

cCabecalho = "Comparativo de Pontos de Reposio Valorizado Custo Medio (SUMARIZADO)"
cSql  = " select count(*) "
cSql += " from "+SetTabela("tpro202")+" a,"
cSql +=          SetTabela("titm002")+" b,"
cSql +=          SetTabela("tpro201")+" c "
cSql += " where a.COD_PRO = b.RECNO       and "
cSql += "       c.RECNO   = "+str(ChaveAtual(1))+" and "
cSql += "       b.EST_MIN > 0             and "
cSql += "       a.PREP1   > 0             and "
cSql += "       a.PREP2   > 0             and "
cSql += "       a.CMEDIO  > 0             and "
cSql += "       a.D2-a.D1 > 10            and "
cSql += "       a.COD_CE1 = c.RECNO       and "
cSql += "       a.COD_CE3 > 0             and "
cSql += "       a.DE      > 0             and "
cSql += "       a.D1      is not null     and "
cSql += "       a.D2      is not null         "
aArray = rdd_cursor(cSql)
if empty(aArray[1])
   TAT("Sem Registros...",.t.)
endif
if aArray[1] > 0 .and. !lastkey()=27 .and. Mens(maxrow()-1,maxrow(),d_ESP)
   cSql  = " select b.TIPO,b.CATEGORIA,sum(b.EST_MIN*a.CMEDIO) V1,sum(a.PREP1*a.CMEDIO) V2,sum(a.PREP2*a.CMEDIO) V3,sum(a.PREP2) xxx "
   cSql += " from "+SetTabela("tpro202")+" a,"
   cSql +=          SetTabela("titm002")+" b,"
   cSql +=          SetTabela("tpro201")+" c "
   cSql += " where a.COD_PRO = b.RECNO       and "
   cSql += "       c.RECNO   = "+str(ChaveAtual(1))+" and "
   cSql += "       b.EST_MIN > 0             and "
   cSql += "       a.PREP1   > 0             and "
   cSql += "       a.PREP2   > 0             and "
   cSql += "       a.CMEDIO  > 0             and "
   cSql += "       a.D2-a.D1 > 10            and "
   cSql += "       a.COD_CE1 = c.RECNO       and "
   cSql += "       a.COD_CE3 > 0             and "
   cSql += "       a.DE      > 0             and "
   cSql += "       a.D1      is not null     and "
   cSql += "       a.D2      is not null         "
   cSql += " group by b.TIPO,b.CATEGORIA "
   cSql += " order by b.TIPO,b.CATEGORIA "
   if LigaImp("PB")  && Papel Branco
      AbreRS(cSql,"REL")
      RelImpressao("CompPRepSum")
      FechaRS("REL")
      DesligaImp(.t.)
   else
      tat("Nada a imprimir ...",.t.)
   endif
endif
RETURN(.t.)

************************
FUNCTION fCompPRepMPDE()
************************
Mens(maxrow()-1,maxrow(),d_ESP)
**********************************
local i
local a

local cSql
local cWhere := ""


iCabec80_132   = 132
iPaginaInicial = 0
sTipoLetra     = "m_12_cond"
cLenLinha      = 264
cQuebra        = ""
lQuebra        = .t.
lNovaPaginaQuebra = .f.
cQuebraTitulo  = "Tipo de Item: "
cQuebraCampo   = "TipoItem[rel->tipo]+'/ '+CatItem[rel->categoria]"
lCabec         = .t.
lCabec2Dedicado = .f.
RelFiltroLinha = ""
iQtCampos      = 12

declare vRGrid[7,iQtCampos]

* Cabecalhos
vRGrid[1,1]   = "SKU"
vRGrid[1,2]   = "DESCRICAO"
vRGrid[1,3]   = "      PRAtual"
vRGrid[1,4]   = "   PRClassico"
vRGrid[1,5]   = " %AtuXCla"
vRGrid[1,6]   = "       PRImam"
vRGrid[1,7]   = "   %AtXIm"
vRGrid[1,8]   = "   PRAtual*CM"
vRGrid[1,9]   = "   PRClass*CM"
vRGrid[1,10]  = "    PRImam*CM"
vRGrid[1,11]  = "Dif(At-Class)"
vRGrid[1,12]  = " Dif(At-Imam)"

* Campos
vRGrid[2,1]   = "rel->CODIGO"
vRGrid[2,2]   = "left(rel->PRODUTO,25)"
vRGrid[2,3]   = "rel->EST_MIN"
vRGrid[2,4]   = "rel->PREP1"
vRGrid[2,5]   = "rel->PP1"
vRGrid[2,6]   = "rel->PREP2"
vRGrid[2,7]   = "rel->PP2"
vRGrid[2,8]   = "rel->VP1"
vRGrid[2,9]   = "rel->VP2"
vRGrid[2,10]  = "rel->VP3"
vRGrid[2,11]  = "rel->VDIF1"
vRGrid[2,12]  = "rel->VDIF2"

* Pictures
vRGrid[3,1]   = ""
vRGrid[3,2]   = ""
vRGrid[3,3]   = "@ez 99,999,999.99"
vRGrid[3,4]   = "@ez 99,999,999.99"
vRGrid[3,5]   = "@ez 99,999.99"
vRGrid[3,6]   = "@ez 99,999,999.99"
vRGrid[3,7]   = "@ez 99,999.99"
vRGrid[3,8]   = "@ez 99,999,999.99"
vRGrid[3,9]   = "@ez 99,999,999.99"
vRGrid[3,10]  = "@ez 99,999,999.99"
vRGrid[3,11]  = "@ez 99,999,999.99"
vRGrid[3,12]  = "@ez 99,999,999.99"

* Colunas
vRGrid[4,1]   = 0   && Forco quebras de linhas dessa forma
vRGrid[4,2]   = 1
vRGrid[4,3]   = 1
vRGrid[4,4]   = 1
vRGrid[4,5]   = 1
vRGrid[4,6]   = 1
vRGrid[4,7]   = 1
vRGrid[4,8]   = 1
vRGrid[4,9]   = 1
vRGrid[4,10]  = 1
vRGrid[4,11]  = 1
vRGrid[4,12]  = 1

* Totaliza
vRGrid[5,1]   = .f.
vRGrid[5,2]   = .f.
vRGrid[5,3]   = .f.
vRGrid[5,4]   = .f.
vRGrid[5,5]   = .f.
vRGrid[5,6]   = .f.
vRGrid[5,7]   = .f.
vRGrid[5,8]   = .t.
vRGrid[5,9]   = .t.
vRGrid[5,10]  = .t.
vRGrid[5,11]  = .t.
vRGrid[5,12]  = .t.

* Zerar Totalizadores-Parciais
vRGrid[6,1]   = 0
vRGrid[6,2]   = 0
vRGrid[6,3]   = 0
vRGrid[6,4]   = 0
vRGrid[6,5]   = 0
vRGrid[6,6]   = 0
vRGrid[6,7]   = 0
vRGrid[6,8]   = 0
vRGrid[6,9]   = 0
vRGrid[6,10]  = 0
vRGrid[6,11]  = 0
vRGrid[6,12]  = 0

* Zerar Totalizadores-Gerais
vRGrid[7,1]   = 0
vRGrid[7,2]   = 0
vRGrid[7,3]   = 0
vRGrid[7,4]   = 0
vRGrid[7,5]   = 0
vRGrid[7,6]   = 0
vRGrid[7,7]   = 0
vRGrid[7,8]   = 0
vRGrid[7,9]   = 0
vRGrid[7,10]  = 0
vRGrid[7,11]  = 0
vRGrid[7,12]  = 0

cCabecalho = "Comparativo de Pontos de Reposio Valorizado Custo Medio"
cSql  = " select count(*) "
cSql += " from "+SetTabela("tpro202")+" a,"
cSql +=          SetTabela("titm002")+" b,"
cSql +=          SetTabela("tpro201")+" c "
cSql += " where a.COD_PRO = b.RECNO       and "
cSql += "       c.RECNO   = "+str(ChaveAtual(1))+" and "
cSql += "       b.EST_MIN > 0             and "
cSql += "       a.PREP1   > 0             and "
cSql += "       a.PREP2   > 0             and "
cSql += "       a.CMEDIO  > 0             and "
cSql += "       a.D2-a.D1 > 10            and "
cSql += "       a.COD_CE1 = c.RECNO       and "
cSql += "       a.COD_CE3 > 0             and "
cSql += "       a.DE      > 0             and "
cSql += "       a.D1      is not null     and "
cSql += "       a.D2      is not null         "
aArray = rdd_cursor(cSql)
if empty(aArray[1])
   TAT("Sem Registros...",.t.)
endif
if aArray[1] > 0 .and. !lastkey()=27 .and. Mens(maxrow()-1,maxrow(),d_ESP)
   cSql  = " select b.TIPO,b.CATEGORIA,b.CODIGO,b.PRODUTO,b.EST_MIN,a.PREP1,a.PREP2,(1-(b.EST_MIN/a.PREP1))*100 PP1,(1-(b.EST_MIN/a.PREP2))*100 PP2,b.EST_MIN*a.CMEDIO VP1,a.PREP1*a.CMEDIO VP2,a.PREP2*a.CMEDIO VP3, (b.EST_MIN*a.CMEDIO)-(a.PREP1*a.CMEDIO) VDIF1,(b.EST_MIN*a.CMEDIO)-(a.PREP2*a.CMEDIO) VDIF2, a.PREP2 XXX "
   cSql += " from "+SetTabela("tpro202")+" a,"
   cSql +=          SetTabela("titm002")+" b,"
   cSql +=          SetTabela("tpro201")+" c "
   cSql += " where a.COD_PRO = b.RECNO       and "
   cSql += "       c.RECNO   = "+str(ChaveAtual(1))+" and "
   cSql += "       b.EST_MIN > 0             and "
   cSql += "       a.PREP1   > 0             and "
   cSql += "       a.PREP2   > 0             and "
   cSql += "       a.CMEDIO  > 0             and "
   cSql += "       a.D2-a.D1 > 10            and "
   cSql += "       a.COD_CE1 = c.RECNO       and "
   cSql += "       a.COD_CE3 > 0             and "
   cSql += "       a.DE      > 0             and "
   cSql += "       a.D1      is not null     and "
   cSql += "       a.D2      is not null         "
   cSql += "order by b.TIPO,b.CATEGORIA,b.CODIGO,b.PRODUTO "
   if LigaImp("PB")  && Papel Branco
      AbreRS(cSql,"REL")
      RelImpressao("ComparaPrep")
      FechaRS("REL")
      DesligaImp(.t.)
   else
      tat("Nada a imprimir ...",.t.)
   endif
endif
RETURN(.t.)


********************
FUNCTION fForaMPDE()
********************
Mens(maxrow()-1,maxrow(),d_ESP)
**********************************
local i
local a

local cSql
local cWhere := ""


iCabec80_132   = 132
iPaginaInicial = 0
sTipoLetra     = "m_12_cond"
cLenLinha      = 264
cQuebra        = ""
lQuebra        = .t.
lNovaPaginaQuebra = .f.
cQuebraTitulo  = "Tipo de Item: "
cQuebraCampo   = "TipoItem[rel->tipo]+'/ '+CatItem[rel->categoria]"
lCabec         = .t.
lCabec2Dedicado = .f.
RelFiltroLinha = ""
iQtCampos      = 9

declare vRGrid[7,iQtCampos]

* Cabecalhos
vRGrid[1,1]   = "SKU"
vRGrid[1,2]   = "DESCRICAO"
vRGrid[1,3]   = "S/PReposAtual"
vRGrid[1,4]   = "S/PRepos1    "
vRGrid[1,5]   = "S/PRepos2    "
vRGrid[1,6]   = "S/CustoMedio "
vRGrid[1,7]   = "MovInf10dias "
vRGrid[1,8]   = "S/NS         "
vRGrid[1,9]   = "S/LeadTime   "

* Campos
vRGrid[2,1]   = "rel->CODIGO"
vRGrid[2,2]   = "left(rel->PRODUTO,25)"
vRGrid[2,3]   = "if(rel->EST_MIN=0 ,'S/PReposAtual','             ')"
vRGrid[2,4]   = "if(rel->PREP1=0   ,'S/PRepos1    ','             ')"
vRGrid[2,5]   = "if(rel->PREP2=0   ,'S/PRepos2    ','             ')"
vRGrid[2,6]   = "if(rel->CMEDIO=0  ,'S/CustoMedio ','             ')"
vRGrid[2,7]   = "if(rel->DT < 10   ,'MovInf10dias ','             ')"
vRGrid[2,8]   = "if(empty(rel->NS) ,'S/NS         ','             ')"
vRGrid[2,9]   = "if(rel->DE=0      ,'S/LeadTime   ','             ')"

* Pictures
vRGrid[3,1]   = ""
vRGrid[3,2]   = ""
vRGrid[3,3]   = ""
vRGrid[3,4]   = ""
vRGrid[3,5]   = ""
vRGrid[3,6]   = ""
vRGrid[3,7]   = ""
vRGrid[3,8]   = ""
vRGrid[3,9]   = ""

* Colunas
vRGrid[4,1]   = 0   && Forco quebras de linhas dessa forma
vRGrid[4,2]   = 1
vRGrid[4,3]   = 1
vRGrid[4,4]   = 1
vRGrid[4,5]   = 1
vRGrid[4,6]   = 1
vRGrid[4,7]   = 1
vRGrid[4,8]   = 1
vRGrid[4,9]   = 1

* Totaliza
vRGrid[5,1]   = .f.
vRGrid[5,2]   = .f.
vRGrid[5,3]   = .f.
vRGrid[5,4]   = .f.
vRGrid[5,5]   = .f.
vRGrid[5,6]   = .f.
vRGrid[5,7]   = .f.
vRGrid[5,8]   = .t.
vRGrid[5,9]   = .t.

* Zerar Totalizadores-Parciais
vRGrid[6,1]   = 0
vRGrid[6,2]   = 0
vRGrid[6,3]   = 0
vRGrid[6,4]   = 0
vRGrid[6,5]   = 0
vRGrid[6,6]   = 0
vRGrid[6,7]   = 0
vRGrid[6,8]   = 0
vRGrid[6,9]   = 0

* Zerar Totalizadores-Gerais
vRGrid[7,1]   = 0
vRGrid[7,2]   = 0
vRGrid[7,3]   = 0
vRGrid[7,4]   = 0
vRGrid[7,5]   = 0
vRGrid[7,6]   = 0
vRGrid[7,7]   = 0
vRGrid[7,8]   = 0
vRGrid[7,9]   = 0

cCabecalho = "Itens nao processados pelo Algoritimo Regressivo"
cSql  = " select count(*) "
cSql += " from "+SetTabela("tpro202")+" a left outer join "+SetTabela("tpro203")+" d on d.RECNO = a.COD_CE3,"
cSql +=          SetTabela("titm002")+" b, "
cSql +=          SetTabela("tpro201")+" c  "
cSql += " where a.COD_PRO = b.RECNO       and "
cSql += "       a.COD_CE1 = c.RECNO       and "
cSql += "       c.RECNO   = "+str(ChaveAtual(1))+" and "
cSql += "      (b.EST_MIN = 0             or  "
cSql += "       a.PREP1   = 0             or  "
cSql += "       a.PREP2   = 0             or  "
cSql += "       a.CMEDIO  = 0             or  "
cSql += "       a.D2-a.D1 < 10            or  "
cSql += "       a.COD_CE3 = 0             or  "
cSql += "       a.DE      = 0             or  "
cSql += "       a.D1      is null         or  "
cSql += "       a.D2      is null)            "
aArray = rdd_cursor(cSql)
if empty(aArray[1])
   TAT("Sem Registros...",.t.)
endif
if aArray[1] > 0 .and. !lastkey()=27 .and. Mens(maxrow()-1,maxrow(),d_ESP)
   cSql  = " select b.TIPO,b.CATEGORIA,b.CODIGO,b.PRODUTO,b.EST_MIN,a.PREP1,a.PREP2,a.CMEDIO,a.D2-a.D1 DT,d.NS,a.DE,a.RECNO "
   cSql += " from "+SetTabela("tpro202")+" a left outer join "+SetTabela("tpro203")+" d on d.RECNO = a.COD_CE3,"
   cSql +=          SetTabela("titm002")+" b, "
   cSql +=          SetTabela("tpro201")+" c  "
   cSql += " where a.COD_PRO = b.RECNO       and "
   cSql += "       a.COD_CE1 = c.RECNO       and "
   cSql += "       c.RECNO   = "+str(ChaveAtual(1))+" and "
   cSql += "      (b.EST_MIN = 0             or  "
   cSql += "       a.PREP1   = 0             or  "
   cSql += "       a.PREP2   = 0             or  "
   cSql += "       a.CMEDIO  = 0             or  "
   cSql += "       a.D2-a.D1 < 10            or  "
   cSql += "       a.COD_CE3 = 0             or  "
   cSql += "       a.DE      = 0             or  "
   cSql += "       a.D1      is null         or  "
   cSql += "       a.D2      is null)            "
   cSql += " order by b.TIPO,b.CATEGORIA,b.CODIGO,b.PRODUTO "
   if LigaImp("PB")
      AbreRS(cSql,"REL")
      RelImpressao("NaoProcessaMPDE")
      FechaRS("REL")
      DesligaImp(.t.)
   else
      tat("Nada a imprimir ...",.t.)
   endif
endif
RETURN(.t.)

*******************
FUNCTION fSPRO202()
*******************
Mens(maxrow()-1,maxrow(),d_ESP)
local uai      := .t.
local cSql     := "select count(*) from " + SetTabela("tpro202") + " where COD_CE1 = " + str(ChaveAtual())
local aArray   := rdd_cursor(cSql)

local pro201di := ctod("  /  /  ")
local pro201df := ctod("  /  /  ")
local itm020di := ctod("  /  /  ")
local itm020df := ctod("  /  /  ")
local iCodLoc  := 0
if aArray[1] > 0
   cc("spro202","[1]")
else
   cSql  = "select DI,DF,RECNO from "+SetTabela("tpro201")+" where RECNO = "+str(ChaveAtual())
   AbreRS(cSql,"pro201")
   if !pro201->(eof())
      pro201di = pro201->DI
      pro201df = pro201->DF
   else
      Tat("erro, cenario sem periodo informado, nao montado relacao de SKU...",.t.)
      uai = .f.
   endif
   FechaRS("pro201")
   Mens(maxrow()-1,maxrow(),"Aguarde, montando relacao de SKU(s)")
   if uai

      cSql  = " select COD_CE3,DE,DCEN1,DCEN2,COD_ALM,RECNO "
      cSql += " from " + SetTabela("titm002")
      cSql += " where (TIPO = 2 and CATEGORIA in (1,2,3,4,5)) or (TIPO = 1 and CATEGORIA in (1,5) or (TIPO=4 and CATEGORIA = 5)) "
      cSql += " and INATIVO = 0"


      //(Manufaturado & Marca total/propria/exclusiva/ter...) ou (Comprado & MAterial Produtivo)

      AbreRS(cSql,"tmp0")
      while !tmp0->(eof()) .and. uai

         /*
         cSql  = "insert into " + SetTabela("tpro202") + "(COD_CE1,COD_PRO,COD_CE3,DE,D1,D2) values ("
         cSql +=  str(ChaveAtual())     + ","
         cSql += str(tmp0->(RECNO()))    + ","
         cSql += str(tmp0->COD_CE3)      + ","
         cSql += str(tmp0->DE)           + ","
         cSql += if(empty(tmp0->DCEN1),UsData(tmp0->DCEN1)+",","'"+UsData(tmp0->DCEN1)+"',")
         cSql += if(empty(tmp0->DCEN2),UsData(tmp0->DCEN2)+")","'"+UsData(tmp0->DCEN2)+"')")
         */


         iCodLoc  = AlmoxLoc(tmp0->COD_ALM,1,.f.)
//         if tmp0->COD_ALM = 17 // Alteracao devido a mudanca do armazem Carapicuiba
//            xCOD_ALM = 3
//            xCOD_LOC = 7
//         else
            xCOD_ALM = tmp0->COD_ALM
            xCOD_LOC = iCodLoc 
//         endif

         cSql = "select min(data) DI,max(data) DF,max(recno) from "+SetTabela("titm020")+ " where COD_PRO = "+str(tmp0->(RECNO()))+" and DATA >= '"+UsData(pro201di)+"' and DATA <= '"+UsData(pro201df)+"' and COD_ALM = "+str(xCOD_ALM)+" and COD_LOC = "+str(xCOD_LOC)
         AbreRS(cSql,"itm020")
         if !itm020->(eof())
            itm020di = itm020->DI
            itm020df = itm020->DF
         else
            itm020di = ctod("  /  /  ")
            itm020df = ctod("  /  /  ")
         endif
         FechaRS("itm020")

         cSql  = "insert into " + SetTabela("tpro202") + "(COD_CE1,COD_PRO,COD_ALM,D1,D2) values ("
         cSql +=  str(ChaveAtual())     + ","
         cSql += str(tmp0->(RECNO()))    + ","
         cSql += str(xCOD_ALM)      + ","
         cSql += if(empty(itm020di),"null","'"+UsData(itm020di)+"'") + ","
         cSql += if(empty(itm020df),"null","'"+UsData(itm020df)+"'") + ")"

//         cSql += if(empty(tmp0->DCEN1),UsData(tmp0->DCEN1)+",","'"+UsData(tmp0->DCEN1)+"',")
//         cSql += if(empty(tmp0->DCEN2),UsData(tmp0->DCEN2)+")","'"+UsData(tmp0->DCEN2)+"')")
         uai = rdd_insert(cSql)
         tmp0->(dbskip())
      end
      FechaRS("tmp0")
   endif
   if uai
      rdd_commit()
      cc("spro202","[1]")
   else
      rdd_rollbck()
      tat("Operacao NAO foi realizada com exito ...",.t.)
   endif
endif
RETURN(.t.)



*********************************************************
FUNCTION fTempoMedioProcesso(iTipo,dData1,dData2,iCodPro)
*********************************************************
* iTipo  = 1         Pedido  ->  Input
*          2    (*)   Input  ->  Entrega Planejada
*          3          Input  ->  Emissao da NF
*          4     Emissao NF  ->  Efetiva de Entrega
*          5         Pedido  ->  Efetiva de Entrega
local cSql
local iTMProc := 0
do case
   case iTipo = 1
      cSql = " select avg(a.DT_INPUT-a.DT_OV)  "
   case iTipo = 2
      cSql = " select avg(a.DT_ENTREGA-a.DT_INPUT)  "
   case iTipo = 3
      cSql = " select avg(c.D_EMISSAO-a.DT_INPUT)  "
   case iTipo = 4
      cSql = " select avg(c.DTTRABAIXA-c.D_EMISSAO)  "
   case iTipo = 5
      cSql = " select avg(c.DTTRABAIXA-a.DT_OV)  "
end
cSql += " from " + SetTabela("tsls001") + " a, "
cSql +=            SetTabela("tsls056") + " b, "
cSql +=            SetTabela("tsls401") + " c, "
cSql +=            SetTabela("tsls402") + " d  "
cSql += " where   a.COD_TOV     = b.RECNO  and "
cSql += "         c.COD_OV      = a.RECNO  and "
cSql += "         d.COD_NF      = c.RECNO  and "
cSql += "         d.COD_PRO     = " + str(iCodPro) + " and "
cSql += "         a.DT_ENTREGA  >= '" + UsData2(dData1) + "' and "
cSql += "         a.DT_ENTREGA  <= '" + UsData2(dData2) + "' and "
cSql += "         b.E_TRANREM    =  0            and "
cSql += "         b.E_DEVOLUCA   =  0                "
local aArray := rdd_cursor(cSql)
if len(aArray) > 0
   iTMProc = aArray[1]
else
   iTMProc = 0
endif
RETURN(iTMProc)

******************************************
FUNCTION fLTApurado(iCodPro,dData1,dData2)
******************************************
local cSql
local iLTApu := 0
cSql = " select avg(b.DT_ENT_OK - a.DT_ENT)  "
cSql += " from " + SetTabela("tsls502") + " a,"
cSql +=            SetTabela("tsls521") + " b "
cSql += " where a.RECNO = b.COD_OC1 and "
cSql += "       a.COD_PRO      =  " + str(iCodPro)   + "  and "
cSql += "       a.DT_ENT      >= '" + UsData2(dData1) + "' and "
cSql += "       a.DT_ENT      <= '" + UsData2(dData2) + "' and "
cSql += "       b.DT_ENT_OK is not null "
local aArray := rdd_cursor(cSql)
if ResultSum(aArray[1])
   iLTApu = aArray[1]
else
   iLTApu = 0
endif
RETURN(iLTApu)

******************************************************
FUNCTION NEWRegressiva(iTipo)
******************************************************
*- iTipo = 1 Regressiva - Itens em Estoque
*- iTipo = 2 Regressiva - Cenarios
******************************************************
*   aSomaEnt     SOMA entrada
*   aSomaSai     SOMA saida
*   aIntSal      INTEGRAL saldo
*   aContSai     CONTAGEM saida
*   aContEnt     CONTAGEM entrada
*   aDdias       n
*   aS2Ent       SomaEntrada^2
*   aS2Sai       SomaSaida^2
*   aS2Sal       SomaSaldo^2
*
*   aMedEnt      Media Entrada
*   aMedSai      Media Saida
*   aMedSal      Media Saldo
*   aTMER        TMER
*   aTMEA        TMEA
*
*   aSEnt2N      (SomaEntrada)^2/n
*   aSSai2N      (SomaSaida)^2/n
*   aIntS2N      (IntegralSaldo)^2/n
*   aLoteEM      LoteE medio
*   aLoteSM      LoteS medio
*   aSincron     Sincronia
*
*   aDPEnt       DesvPad Entrada
*   aDPSai       DesvPad Saida
*   aDPSal       DescPad Saldo
*   aCVEnt       Coeficiente Variabilidade Entrada
*   aCVSai       Coeficiente Variabilidade Saida
*   aCVSal       Coeficiente Variabilidade Saldo
******************************************************
* Gravar a ultima acuracia medida no sistema
* Gravar a ultima curva ABC

Mens(maxrow()-1,maxrow(),d_ESP)

*- 1o. Controle
local iCodLoc     := 0
local iSaldo      := 0
local iSaldoAtual := 0
local iCodPro     := 0
local iFS         := 0
local iEstMin     := 0
local iCusto      := 0
local iValFat     := 0
local iQtFat      := 0
local uai         := .t.
local dData1      := ctod("  /  /  ")
local dData2      := ctod("  /  /  ")
local vD1         := ctod("  /  /  ")
local tData       := ctod("  /  /  ")


*- 2o. Acumuladores
local vContEnt    := 0
local vContSai    := 0
local vDdias      := 0
local v2Entrada   := 0  && Entrada^2
local v2Saida     := 0  && Saida^2
local vSdoDdias   := 0  && Sdo*Ddias
local v2Saldo     := 0  && Sdo^2
local v2SdoDdias  := 0  && Sdo^2*Ddias

*- 3o. Acumuladores
local aSomaEnt    := 0
local aSomaSai    := 0
local aIntSal     := 0
local aContSai    := 0
local aContEnt    := 0
local aDdias      := 0
local aS2Ent      := 0
local aS2Sai      := 0
local aS2Sal      := 0

*- 4o. Acumuladores
local aMedEnt     := 0
local aMedSai     := 0
local aMedSal     := 0
local aTMER       := 0
local aTMEA       := 0

*- 5o. Acumuladores
local aSEnt2N     := 0
local aSSai2N     := 0
local aIntS2N     := 0
local aLoteEM     := 0
local aLoteSM     := 0
local aSincron    := 0

*- 6o. Acumuladores
local aDPEnt      := 0
local aDPSai      := 0
local aDPSal      := 0
local aCVEnt      := 0
local aCVSai      := 0
local aCVSal      := 0

local aGiro       := 0
local aCobMedia   := 0
local aCobInstant := 0
local aRSI        := 0
local aPayBack    := 0
local aEstSeg     := 0
local aPRep1      := 0
local aPRep2      := 0
local aExpRup     := 0
local aPotMedRup  := .f.
local aPotInsRup  := .f.
local aNS1        := 0
local aNS2        := 0
local aTMProc1    := 0
local aTMProc2    := 0
local aTMProc3    := 0
local aTMProc4    := 0
local aTMProc5    := 0
local aMGBruta    := 0
local aPRMedV     := 0
local aLTCOMB     := 0
local aLTAPU      := 0
local aSdoFin     := 0
local aSdoIni     := 0
local aMaxEnt     := 0
local aMinEnt     := 0
local aMaxSai     := 0
local aMinSai     := 0
local aMaxSal     := -999999999999
local aMinSal     := 999999999999
local aChegar     := 0
local aSdoAcPP1   := 0   && PRep. Informado
local aSdoAcPP2   := 0   && PRep. Calculado1
local aSdoAcPP3   := 0   && PRep. Calculado2
local aSdoAbPP1   := 0   && PRep. Informado
local aSdoAbPP2   := 0   && PRep. Calculado1
local aSdoAbPP3   := 0   && PRep. Calculado2
local aSdoZero    := 0

cSql   = " select count(*) from " + SetTabela("tpro202")
if iTipo = 1
   cSql += " where COD_CE1    =  " + str(ChaveAtual(1))
elseif iTipo = 2
    cSql += " where RECNO      =  " + str(ChaveAtual())
endif
cSql += " and COD_CE3 > 0 "
aArray = rdd_cursor(cSql)
iTotal = aArray[1]
PoeRegua(15,.f.)

cSql  = " select D1,D2,RECNO "
cSql += " from " + SetTabela("tpro202")
if iTipo = 1
 cSql += " where COD_CE1    =  " + str(ChaveAtual(1))
elseif iTipo = 2
 cSql += " where RECNO      =  " + str(ChaveAtual())
endif
cSql += " and COD_CE3 > 0 "
AbreRS(cSql,"tpr")
if iTipo = 1
   cSql  = " select COD_PRO,count(*)"
   cSql += " from " + SetTabela("tsls401") + " a,"
   cSql +=            SetTabela("tsls402") + " b,"
   cSql +=            SetTabela("tsls056") + " c "
   cSql += " where b.COD_NF      = a.RECNO                and "
   cSql += "       a.D_EMISSAO  >= '" + UsData(tpr->D1) + "'  and "
   cSql += "       a.D_EMISSAO  <= '" + UsData(tpr->D2) + "'  and "
   cSql += "       c.RECNO       = a.COD_TOV              and "
   cSql += "       c.E_TRANREM   = 0                      and "
   cSql += "       c.E_DEVOLUCA  = 0                      and "
   cSql += "         a.DT_ENTREGA  = a.DTTRABAIXA "
   cSql += " group by COD_PRO "
   aA1 = rdd_select(cSql)
   cSql  = " select COD_PRO,count(*)"
   cSql += " from " + SetTabela("tsls401") + " a,"
   cSql +=            SetTabela("tsls402") + " b,"
   cSql +=            SetTabela("tsls056") + " c "
   cSql += " where b.COD_NF      = a.RECNO                and "
   cSql += "       a.D_EMISSAO  >= '" + UsData(tpr->D1) + "'  and "
   cSql += "       a.D_EMISSAO  <= '" + UsData(tpr->D2) + "'  and "
   cSql += "       c.RECNO       = a.COD_TOV              and "
   cSql += "       c.E_TRANREM   = 0                      and "
   cSql += "       c.E_DEVOLUCA  = 0                      and "
   cSql += "       a.DT_ENTREGA  = a.D_EMISSAO "
   cSql += " group by COD_PRO "
   aA2 = rdd_select(cSql)
   cSql  = " select COD_PRO,count(*)"
   cSql += " from " + SetTabela("tsls401") + " a,"
   cSql +=            SetTabela("tsls402") + " b,"
   cSql +=            SetTabela("tsls056") + " c "
   cSql += " where b.COD_NF      = a.RECNO                and "
   cSql += "       a.D_EMISSAO  >= '" + UsData(tpr->D1) + "'  and "
   cSql += "       a.D_EMISSAO  <= '" + UsData(tpr->D2) + "'  and "
   cSql += "       c.RECNO       = a.COD_TOV              and "
   cSql += "       c.E_TRANREM   = 0                      and "
   cSql += "       c.E_DEVOLUCA  = 0                          "
   cSql += " group by COD_PRO "
   aA3 = rdd_select(cSql)
endif
while !tpr->(EOF()) .and. TicRegua(iTotal,.f.,.t.)
   cSql  = " select a.COD_PRO                                   ,"
   cSql += "        a.D1                                        ,"
   cSql += "        a.D2                                        ,"
   cSql += "        a.DE                                        ,"
   cSql += "        b.EST_MIN                                   ,"
   cSql += "        b.COD_ALM                                   ,"
   cSql += "        b.C_IPIMEDIO                                ,"
   cSql += "        c.FS                                        ,"
   cSql += "        d.AG                                        ,"
   cSql += "        e.MAG                                       ,"
   cSql += "        f.BU                                        ,"
   cSql += "        sum(g.rficmvalor+g.v1+g.ipivalor) VLFAT     ,"
   cSql += "        sum(g.qt)                         QTFAT     ,"
   cSql += "        avg(j.DT_INPUT-j.DT_OV)           TMPROC1   ,"
   cSql += "        avg(j.DT_ENTREGA-j.DT_INPUT)      TMPROC2   ,"
   cSql += "        avg(h.D_EMISSAO-j.DT_INPUT)       TMPROC3   ,"
   cSql += "        avg(h.DTTRABAIXA-h.D_EMISSAO)     TMPROC4   ,"
   cSql += "        avg(h.DTTRABAIXA-j.DT_OV)         TMPROC5   ,"
   cSql += "        avg(h.DTTRABAIXA-j.DT_OV)         TMPROC6   ,"
   cSql += "        a.RECNO                                     "
   cSql += " from " + SetTabela("tpro202") + " a, "
   cSql +=            SetTabela("titm002") + " b, "
   cSql +=            SetTabela("tpro203") + " c, "
   cSql +=            SetTabela("titm012") + " d, "
   cSql +=            SetTabela("titm011") + " e, "
   cSql +=            SetTabela("titm010") + " f, "
   cSql +=            SetTabela("tsls402") + " g, "
   cSql +=            SetTabela("tsls401") + " h, "
   cSql +=            SetTabela("tsls056") + " i, "
   cSql +=            SetTabela("tsls001") + " j  "
   cSql += "  where a.RECNO      = " + str(tpr->(RECNO())) +  " and "
   cSql += "        b.RECNO      = a.COD_PRO                    and "
   cSql += "        c.RECNO      = a.COD_CE3                    and "
   cSql += "        d.RECNO      = b.COD_AG                     and "
   cSql += "        e.RECNO      = d.COD_MAG                    and "
   cSql += "        f.RECNO      = d.COD_BU                     and "
   cSql += "        g.COD_PRO    = b.RECNO                      and "
   cSql += "        h.RECNO      = g.COD_NF                     and "
   cSql += "        i.RECNO      = h.COD_TOV                    and "
   cSql += "        j.RECNO      = h.COD_OV                     and "
   cSql += "        h.D_EMISSAO >= '" + UsData2(tpr->D1) + "'   and "
   cSql += "        h.D_EMISSAO <= '" + UsData2(tpr->D2) + "'   and "
   cSql += "        h.CANC       = 0                            and "
   cSql += "        h.E_ENTRADA  = 0                            and "
   cSql += "        i.E_BONIFICA = 0                            and "
   cSql += "        i.E_TRANREM  = 0                            and "
   cSql += "        i.E_DEVOLUCA = 0                                "
   cSql += " group by a.COD_PRO,c.FS,a.DE,a.D1,a.D2,b.EST_MIN,b.COD_ALM,d.AG,e.MAG,f.BU,b.C_IPIMEDIO,a.RECNO "
   AbreRS(cSql,"tpro202")
   if !tpro202->(eof())
      iCusto      = tpro202->C_IPIMEDIO
      iValFat     = tpro202->VLFAT
      iQtFat      = tpro202->QTFAT
      aMGBruta    = ((iValFat-(iQTFat*iCusto))/iValFat)*100
      aPRMedV     = tpro202->VLFAT/tpro202->QTFAT

      iCodPro     = tpro202->COD_PRO
      iFS         = tpro202->FS
      iDE         = tpro202->DE         && Dias de Estoque mudar o nome do Campo p/ DE
      aLTCOMB     = fRegrLeadTime(iCodPro)  && Em Dias
      dData1      = tpro202->D1
      dData2      = tpro202->D2
      vD1         = dData2

      iCodLoc     = AlmoxLoc(tpro202->COD_ALM,1,.f.)
      aSdoIni     = Saldo2EstEm(dData1,tpro202->COD_PRO,iCodLoc)
      iSaldo      = Saldo2EstEm(dData2,tpro202->COD_PRO,iCodLoc)
      iSaldoAtual = Saldo2EstEm(m->Hoje+1,tpro202->COD_PRO,iCodLoc)
      aSdoFin     = iSaldo
      iS1         = .t.
      iEstMin     = tpro202->EST_MIN

      cSql   = " select COD_PRO         ,"
      cSql  += "        DATA            ,"
      cSql  += "        sum(ENTRADA)    ,"
      cSql  += "        sum(SAIDA)      ,"
      cSql  += "        max(ENTRADA)    ,"
      cSql  += "        min(ENTRADA)    ,"
      cSql  += "        max(SAIDA)      ,"
      cSql  += "        min(SAIDA)       "
      cSql  += " from " + SetTabela("titm020")
      cSql  += " where COD_PRO =  " + astr(tpro202->COD_PRO)   + "  and "
      cSql  += "       DATA   >= '" + UsData2(dData1)          + "' and "
      cSql  += "       DATA   <= '" + UsData2(dData2)          + "' and "
      cSql  += "       COD_LOC =  " + str(iCodLoc)
      cSql  += " group by COD_PRO,DATA "
      cSql  += " order by COD_PRO,DATA DESC"
      aArray = rdd_select(cSql)
      Alert(cSql)

      if len(aArray) > 0
         aMaxEnt = aArray[5]
         aMinEnt = aArray[6]
         aMaxSai = aArray[7]
         aMinSai = aArray[8]
      else
         aMaxEnt = 0
         aMinEnt = 0
         aMaxSai = 0
         aMinSai = 0
      endif


      for i=1 to len(aArray) step 8
         aMaxEnt = max(aMaxEnt,aArray[i+4])
         aMaxSai = max(aMaxSai,aArray[i+6])
         if aArray[i+2] > 0
            vContEnt++
         endif
         if aArray[i+3] > 0
            vContSai++
         endif
         if ctod(BrData(aArray[i+1])) <> vD1
            vDdias   = vD1 - ctod(BrData(aArray[i+1]))
            vD1      = ctod(BrData(aArray[i+1]))
         endif
         v2Entrada   = aArray[i+2]^2
         v2Saida     = aArray[i+3]^2
         vSdoDdias   = iSaldo * vDdias
         v2Saldo     = iSaldo^2
         v2SdoDdias  = (iSaldo^2) * vDdias

         aSomaEnt   += aArray[i+2]
         aSomaSai   += aArray[i+3]
         aIntSal    += vSdoDdias
         aContSai    = vContSai
         aContEnt    = vContEnt
         aS2Ent  += v2Entrada
         aS2Sai  += v2Saida
         aS2Sal  += v2SdoDdias
         if iSaldo < aMinSal
            aMinSal  =  iSaldo
         endif
         if iSaldo > aMaxSal
            aMaxSal  =  iSaldo
         endif
         iSaldo = iSaldo + aArray[i+3] - aArray[i+2]
      next

      vDdias       = vD1 - dData1
      aS2Sal      += if(vD1<>dData2,(iSaldo^2) * vDdias,0)
      aIntSal     += iSaldo * (vD1 - dData1)

      *aDdias       = dData2 - dData1
      aDdias = 0
      for i=1 to dData2 - dData1
         if E_DiaUtil(dData1+i-1)
            aDdias++
         endif
      next

      aMedEnt      = aSomaEnt/aDdias
      aMedSai      = aSomaSai/aDdias
      aMedSal      = aIntSal/aDdias
      aTMER        = aDdias / vContEnt
      aTMEA        = aDdias / vContSai

      aSEnt2N      = (aSomaEnt^2)/aDdias
      aSSai2N      = (aSomaSai^2)/aDdias
      aIntS2N      = (aIntSal^2)/aDdias
      aLoteEM      = aSomaEnt / vContEnt
      aLoteSM      = aSomaSai / vContSai
      aSincron     = aTMEA/aTMER

      aDPEnt       = ((aS2Ent-aSEnt2N)/aDdias)^(1/2)
      aDPSai       = ((aS2Sai-aSSai2N)/aDdias)^(1/2)
      aDPSal       = ((aS2Sal-aIntS2n)/aDdias)^(1/2)

      aCVEnt       = (aDPEnt/aMedEnt)*100
      aCVSai       = (aDPSai/aMedSai)*100
      aCVSal       = (aDPSal/aMedSal)*100

      aEstSeg      = aDPSai*iFS
      aPRep1       = (aMedSai*(iDE+aLTCOMB))+aEstSeg
      aPRep2       = (iDE+aLTCOMB) *aMedSai/aTMEA  + iFS *aDPSai/((iDE+aLTCOMB)/aTMEA)^(1/2)
      aRSI         = 100*((iValFat-(iQtFat*iCusto)) / (aMedSal*iCusto))

      aPayBack     = 365 / aRSI
      aCobMedia    = aMedSal / aMEdSai
      aGiro        = 365/aCobMedia
      aCobInstant  = iSaldoAtual/aMedSai

      iSaldo = aSdoFin

      for i=1 to len(aArray) step 8
         if iSaldo < aEstSeg
            aExpRup++
         endif
         if iSaldo <= 0
            aSdoZero++
         endif
         if iSaldo >= iEstMin
            aSdoAcPP1++                 && PRep. Informado
         elseif iSaldo <  iEstMin
            aSdoAbPP1++
         endif
         if iSaldo >= aPRep1
            aSdoAcPP2++                 && PRep. Calculado1
         elseif iSaldo < aPRep1
            aSdoAbPP2++
         endif
         if iSaldo >= aPRep2
            aSdoAcPP3++                 && PRep. Calculado2
         elseif iSaldo < aPRep2
            aSdoAbPP3++
         endif
         iSaldo = iSaldo + aArray[i+3] - aArray[i+2]
      next

      aExpRup     = 100*aExpRup/aDdias
      aPotMedRup  = aCobMedia < aLTCOMB
      aPotInsRup  = aCobInstant < aLTCOMB

      if iTipo = 1
         aNS1 = 100*(fAchaA1(iCodPro)/fAchaA3(iCodPro))
         aNS2 = 100*(fAchaA2(iCodPro)/fAchaA3(iCodPro))
      endif

      if iTipo = 2
         aNS1        = fNSProduto(iCodPro,dData1,dData2,1)         && Dt Plan X DT Efet Ent
         aNS2        = fNSProduto(iCodPro,dData1,dData2,2)         && Dt Plan X Emissao NF
      endif

      aTMProc1    = tpro202->TMPROC1
      aTMProc2    = tpro202->TMPROC2
      aTMProc3    = tpro202->TMPROC3
      aTMProc4    = tpro202->TMPROC4
      aTMProc5    = tpro202->TMPROC5

      aLTAPU      = fLTApurado(iCodPro,dData1,dData2)

      aChegar     = fRegrOPQtAChegar(iCodPro,dData1,dData2)+fRegrOCQtAChegar(iCodPro,dData1,dData2)

      cSql  = " update " + SetTabela("tpro202")                                 + " set "
      cSql += " D1       = '" + UsData2(dData1)                                 + "',"
      cSql += " D2       = '" + UsData2(dData2)                                 + "',"
      cSql += " SOMAENT  = " + str(aSomaEnt,18,5)                               + ","
      cSql += " SOMASAI  = " + str(aSomaSai,18,5)                               + ","
      cSql += " INTSAL   = " + str(aIntSal,18,5)                                + ","
      cSql += " CONTSAI  = " + str(aContSai,18,5)                               + ","
      cSql += " CONTENT  = " + str(aContEnt,18,5)                               + ","
      cSql += " DDIAS    = " + str(aDdias,18,5)                                 + ","
      cSql += " S2ENT    = " + str(aS2Ent,18,5)                                 + ","
      cSql += " S2SAI    = " + str(aS2Sai,18,5)                                 + ","
      cSql += " S2SAL    = " + str(aS2Sal,18,5)                                 + ","
      cSql += " MEDENT   = " + str(aMedEnt,18,5)                                + ","
      cSql += " MEDSAI   = " + str(aMedSai,18,5)                                + ","
      cSql += " MEDSAL   = " + str(aMedSal,18,5)                                + ","
      cSql += " TMER     = " + str(aTMER,18,5)                                  + ","
      cSql += " TMEA     = " + str(aTMEA,18,5)                                  + ","
      cSql += " SENT2N   = " + str(aSEnt2N,18,5)                                + ","
      cSql += " SSAI2N   = " + str(aSSai2N,18,5)                                + ","
      cSql += " INTS2N   = " + str(aIntS2N,18,5)                                + ","
      cSql += " LOTEEM   = " + str(aLoteEM,18,5)                                + ","
      cSql += " LOTESM   = " + str(aLoteSM,18,5)                                + ","
      cSql += " SINCRON  = " + str(aSincron,18,5)                               + ","
      cSql += " DPENT    = " + str(aDPEnt,18,5)                                 + ","
      cSql += " DPSAI    = " + str(aDPSai,18,5)                                 + ","
*      cSql += " DPSAL    = " + str(aDPSal,18,5)                                + ","
      cSql += " CVENT    = " + str(aCVEnt,18,5)                                 + ","
      cSql += " CVSAI    = " + str(aCVSai,18,5)                                 + ","
*      cSql += " CVSAL    = " + str(aCVSal,18,5)                                + ","
      cSql += " ESTSEG   = " + str(aEstSeg,18,5)                                + ","
      cSql += " PREP1    = " + str(aPRep1,18,5)                                 + ","
      cSql += " PREP2    = " + str(aPRep2,18,5)                                 + ","
      cSql += " COBMEDIA = " + str(aCobMedia,18,5)                              + ","
      cSql += " GIRO     = " + str(aGiro,18,5)                                  + ","
      cSql += " COBINST  = " + str(aCobInstant,18,5)                            + ","
      cSql += " RSI      = " + str(aRSI,18,5)                                   + ","
      cSql += " PAYBACK  = " + str(aPayBack,18,5)                               + ","
      cSql += " EXPRUP   = " + str(aExpRup,18,5)                                + ","
      cSql += " POTMEDRUP= " + if(aPotMedRup,"1","0")                           + ","
      cSql += " POTINSRUP= " + if(aPotInsRup,"1","0")                           + ","
      cSql += " NS1      = " + str(aNS1,18,5)                                   + ","
      cSql += " NS2      = " + str(aNS2,18,5)                                   + ","
      cSql += " TMPROC1  = " + str(aTMPROC1,18,5)                               + ","
      cSql += " TMPROC2  = " + str(aTMPROC2,18,5)                               + ","
      cSql += " TMPROC3  = " + str(aTMPROC3,18,5)                               + ","
      cSql += " TMPROC4  = " + str(aTMPROC4,18,5)                               + ","
      cSql += " TMPROC5  = " + str(aTMPROC5,18,5)                               + ","
      cSql += " CMEDIO   = " + str(iCusto,18,5)                                 + ","
      cSql += " MGBRUTA  = " + str(aMGBruta,18,5)                               + ","
      cSql += " PRMEDV   = " + str(aPRMEDV,18,5)                                + ","
      cSql += " LTCOMB   = " + str(aLTCOMB,18,5)                                + ","
      cSql += " LTAPU    = " + str(aLTAPU,18,5)                                 + ","
      cSql += " SDOINI   = " + str(aSdoIni,18,5)                                + ","
      cSql += " SDOFIN   = " + str(aSdoFin,18,5)                                + ","
      cSql += " MAXENT   = " + str(aMaxEnt,18,5)                                + ","
      cSql += " MINENT   = " + str(aMinEnt,18,5)                                + ","
      cSql += " MAXSAI   = " + str(aMaxSai,18,5)                                + ","
      cSql += " MINSAI   = " + str(aMinSai,18,5)                                + ","
      cSql += " MAXSAL   = " + str(aMaxSal,18,5)                                + ","
      cSql += " MINSAL   = " + str(aMinSal,18,5)                                + ","
      cSql += " SDOATU   = " + str(iSaldoAtual,18,5)                            + ","
      cSql += " ACHEGAR  = " + str(aChegar,18,5)                                + ","
      cSql += " SDOACPP1 = " + str(aSdoAcPP1,18,5)                              + ","
      cSql += " SDOACPP2 = " + str(aSdoAcPP2,18,5)                              + ","
      cSql += " SDOACPP3 = " + str(aSdoAcPP3,18,5)                              + ","
      cSql += " SDOABPP1 = " + str(aSdoAbPP1,18,5)                              + ","
      cSql += " SDOABPP2 = " + str(aSdoAbPP2,18,5)                              + ","
      cSql += " SDOABPP3 = " + str(aSdoAbPP3,18,5)                              + ","
      cSql += " SDOZERO  = " + str(aSdoZero,18,5)
      cSql += " where RECNO = " + str(tpro202->(RECNO()))
      uai = rdd_update(cSql)
      if uai
         rdd_commit()
      endif
   endif
   FechaRS("tpro202")

   iCodLoc     := 0
   iSaldo      := 0
   iSaldoAtual := 0
   iCodPro     := 0
   iFS         := 0
   iEstMin     := 0
   iCusto      := 0
   iValFat     := 0
   iQtFat      := 0
   uai         := .t.
   dData1      := ctod("  /  /  ")
   dData2      := ctod("  /  /  ")
   vD1         := ctod("  /  /  ")
   vContEnt    := 0
   vContSai    := 0
   vDdias      := 0
   v2Entrada   := 0
   v2Saida     := 0
   vSdoDdias   := 0
   v2Saldo     := 0
   v2SdoDdias  := 0
   aSomaEnt    := 0
   aSomaSai    := 0
   aIntSal     := 0
   aContSai    := 0
   aContEnt    := 0
   aDdias      := 0
   aS2Ent      := 0
   aS2Sai      := 0
   aS2Sal      := 0
   aMedEnt     := 0
   aMedSai     := 0
   aMedSal     := 0
   aTMER       := 0
   aTMEA       := 0
   aSEnt2N     := 0
   aSSai2N     := 0
   aIntS2N     := 0
   aLoteEM     := 0
   aLoteSM     := 0
   aSincron    := 0
   aDPEnt      := 0
   aDPSai      := 0
   aDPSal      := 0
   aCVEnt      := 0
   aCVSai      := 0
   aCVSal      := 0
   aGiro       := 0
   aCobMedia   := 0
   aCobInstant := 0
   aRSI        := 0
   aPayBack    := 0
   aEstSeg     := 0
   aPRep1      := 0
   aPRep2      := 0
   aExpRup     := 0
   aPotMedRup  := .f.
   aPotInsRup  := .f.
   aNS1        := 0
   aNS2        := 0
   aTMProc1    := 0
   aTMProc2    := 0
   aTMProc3    := 0
   aTMProc4    := 0
   aTMProc5    := 0
   aMGBruta    := 0
   aPRMedV     := 0
   aLTCOMB     := 0
   aLTAPU      := 0
   aSdoFin     := 0
   aSdoIni     := 0
   aMaxEnt     := 0
   aMinEnt     := 0
   aMaxSai     := 0
   aMinSai     := 0
   aMaxSal     := -999999999999
   aMinSal     := 999999999999
   aChegar     := 0
   aSdoAcPP1   := 0
   aSdoAcPP2   := 0
   aSdoAcPP3   := 0
   aSdoAbPP1   := 0
   aSdoAbPP2   := 0
   aSdoAbPP3   := 0
   aSdoZero    := 0

   tpr->(dbskip())
end
FechaRS("tpr")
if uai
   rdd_commit()
else
   rdd_rollbck()
endif
RETURN(.t.)


/////////////////////////////////
function MPDEAlgRegressivo(iTipo)
/////////////////////////////////

// iTipo = 1 - Item em Questao
// iTipo = 2 - Todos os Itens

*- Campos auxiliares
local auxEntCount  := 0
local auxSaiCount  := 0
local auxDdias     := 0
local auxEntrada2  := 0  && Entrada^2
local auxSaida2    := 0  && Saida^2
local auxSdoDdias  := 0  && Sdo*Ddias
local auxSdo2      := 0  && Sdo^2
local auxSdo2Ddias := 0  && Sdo^2*Ddias

* Acumuladores
local aSumEnt      := 0
local aSumSai      := 0
local aIntSdo      := 0
local aEntCount    := 0
local aSaiCount    := 0
local aN           := 0  && dDias Totais
local aSumEnt2     := 0
local aSumSai2     := 0
local aSumSdo2     := 0

local aMedEnt     := 0
local aMedSai     := 0
local aMedSdo     := 0
local aTMER       := 0
local aTMEA       := 0

local aSumEnt2N   := 0
local aSumSai2N   := 0
local aIntSdo2N   := 0
local aLoteEMed   := 0
local aLoteSMed   := 0
local aSincron    := 0

local aDPEnt      := 0
local aDPSai      := 0
local aDPSdo      := 0
local aCVEnt      := 0
local aCVSai      := 0
local aCVSdo      := 0

//Estatisticas
local sEstSeg     := 0
local sPRep1      := 0
local sPRep2      := 0
local sCobInstant := 0

local aMaxEnt     := 0
local aMinEnt     := 0
local aMaxSai     := 0
local aMinSai     := 0
local aMaxSal     := -999999999999
local aMinSal     := 999999999999
local aCM         := 0
local aSdoAcPP1   := 0   && PRep. Informado
local aSdoAcPP2   := 0   && PRep. Calculado1
local aSdoAcPP3   := 0   && PRep. Calculado2
local aSdoAbPP1   := 0   && PRep. Informado
local aSdoAbPP2   := 0   && PRep. Calculado1
local aSdoAbPP3   := 0   && PRep. Calculado2
local aSdoZero    := 0
local aSdoFin     := 0
local aSdoIni     := 0
local aExpRup     := 0
local aCobInst    := 0

local aGiro       := 0
local aCobMedia   := 0
local aRSI        := 0
local aPayBack    := 0
local aPotMedRup  := .f.
local aPotInsRup  := .f.
local aNS1        := 0
local aNS2        := 0
local aTMProc1    := 0
local aTMProc2    := 0
local aTMProc3    := 0
local aTMProc4    := 0
local aTMProc5    := 0
local aMGBruta    := 0
local aLTCOMB     := 0
local aLTAPU      := 0

// Variaveis locais
local iCodLoc        := 0
local xCodPro        := 0
local xCod202        := 0
local qSdo           := 0
local dData          := ctod("  /  /  ")
local tmpD1          := ctod("  /  /  ")
local tmpD2          := ctod("  /  /  ")
local nFS            := 0
local nLeadTime      := 0
local nNEstDias      := 0
local nSdoAtual      := 0
local NSPret         := 0
local k              := 0
local aDiasSdo[3000]
local nEstMin        := 0
local nCapMax        := 0

// Conta os registros para Regua

cSql   = " select count(*) from " + SetTabela("tpro202") + " where COD_CE3 > 0 and DE > 0 and D1 is not null and D2 is not null and "
if iTipo = 1
   cSql += "RECNO   =" + str(ChaveAtual())
else
   cSql += "COD_CE1 =" + str(ChaveAtual(1))
endif
aArray = rdd_cursor(cSql)
iTotal = aArray[1]
PoeRegua(15,.f.)

cSql   = " select a.COD_PRO                     ,"
cSql  += "        a.COD_LOC                     ,"
cSql  += "        a.DATA                        ,"
cSql  += "        b.D1                          ,"
cSql  += "        b.D2                          ,"
cSql  += "        d.FS                          ,"
cSql  += "        b.DE                          ,"
cSql  += "        b.NESTDIAS                    ,"
cSql  += "        b.RECNO        COD_202        ,"
cSql  += "        d.NS                          ,"
cSql  += "        e.C_IPIMEDIO                  ,"
cSql  += "        e.EST_MIN                     ,"
cSql  += "        sum(a.ENTRADA) qENTRADA       ,"
cSql  += "        sum(a.SAIDA)   qSAIDA         ,"
cSql  += "        max(a.ENTRADA) qMAXENT        ,"
cSql  += "        min(a.ENTRADA) qMINENT        ,"
cSql  += "        max(a.SAIDA)   qMAXSAI        ,"
cSql  += "        min(a.SAIDA)   qMINSAI        ,"
cSql  += "        min(a.SAIDA)   xxx            "
cSql  += " from " + SetTabela("titm020") + " a,"        // Movimentaes de Estoque
cSql  +=            SetTabela("tpro202") + " b,"        // Produtos MPDE
cSql  +=            SetTabela("titm014") + " c,"        // Localizacoes
cSql  +=            SetTabela("tpro203") + " d,"        // Nivel de Servico Pretendido
cSql  +=            SetTabela("titm002") + " e "        // Nivel de Servico Pretendido
cSql  += " where a.DATA      >= b.D1                              and "
cSql  += "       a.DATA      <= b.D2                              and "
cSql  += "       a.COD_PRO    = e.RECNO                           and "
cSql  += "       a.COD_PRO    = b.COD_PRO                         and "
cSql  += "       b.COD_ALM    = c.COD_ALM                         and "
cSql  += "       b.COD_CE3    = d.RECNO                           and "
cSql  += "       b.DE         > 0                                 and "
cSql  += "       b.NESTDIAS   > 0                                 and "
cSql  += "       b.D1         is not null                         and "
cSql  += "       b.D2         is not null                         and "
cSql  += "       b.D2-b.D1    >= 10                               and "
if iTipo = 1
cSql += "        b.RECNO      =  " + str(ChaveAtual())  +       " and "
else
cSql += "        b.COD_CE1    =  " + str(ChaveAtual(1)) +       " and "
endif
cSql  += "       a.COD_LOC    = c.RECNO                           and "
cSql  += "       c.ACONSELHAR = 1"
cSql  += " group by a.COD_PRO,a.COD_LOC,a.DATA,b.D1,b.D2,d.FS,b.DE,b.NESTDIAS,b.RECNO,d.NS,e.C_IPIMEDIO,e.EST_MIN "
cSql  += " order by a.COD_PRO,a.DATA DESC"
AbreRS(cSql,"tmp")
xCodPro = 0
while !tmp->(eof())

   if xCodPro <> tmp->COD_PRO
      k = 0
      // calcula o saldo do final do perodo
      cSql  = " select sum(ENTRADA)-sum(SAIDA) "
      cSql += " from "+SetTabela("titm020")
      cSql += " where COD_PRO="+str(tmp->COD_PRO)
      cSql += "   and COD_LOC="+str(tmp->COD_LOC)
      cSql += "   and DATA <= '"+UsData2(tmp->D2)+"'"
      aArray = rdd_select(cSql)
      if len(aArray)>0; qSdo = aArray[1]; endif
      // Campos Auxiliares do Sdo
      auxSdo2 = qSdo^2
      dData   = tmp->D2

      aMinEnt      = if(tmp->qENTRADA>0,tmp->qENTRADA,999999999999)
      aMinSai      = if(tmp->qSAIDA>0,tmp->qSAIDA,999999999999)
      aMinSal      = qSdo
      aSdoFin      = qSdo

      cSql="select QT_EST-QT_ACO from "+SetTabela("titm014a")+" where COD_PRO="+str(tmp->COD_PRO)+" and COD_LOC="+str(tmp->COD_LOC)
      aArray = rdd_select(cSql)
      if len(aArray)>0; nSdoAtual = aArray[1]; endif

      // Aqui Gravar dados
      // Aqui Zerar Variaveis
   endif

   xCod202   = tmp->COD_202
   nFS       = tmp->FS
   nLeadTime = tmp->DE
   nNEstDias = tmp->NESTDIAS                    // Nivel de estoque em Dias
   NSPret    = tmp->NS
   xCOD202   = tmp->COD_202
   aCM       = tmp->C_IPIMEDIO
   nEstMin   = tmp->EST_MIN

   // Campos Auxiliares
   if tmp->qENTRADA > 0; auxEntCount++ ; endif  // auxEntCount:         0
   if tmp->qSAIDA   > 0; auxSaiCount++ ; endif  // auxSaiCount:         1
   auxDdias      = dData - tmp->DATA            // auxDdias   :       352
   auxEntrada2   = tmp->qENTRADA^2              // auxEntrada2:         0
   auxSaida2     = tmp->qSAIDA^2                // auxSaida2  :    160000
   auxSdoDdias   = qSdo * auxDdias              //
   auxSdo2       = qSdo^2                       //
   auxSdo2Ddias  = qSdo^2*auxDdias              //

   // Processa Acumuladores
   if tmp->qENTRADA > 0; aSumEnt += tmp->qENTRADA ; endif       //
   if tmp->qSAIDA   > 0; aSumSai += tmp->qSAIDA   ; endif       //
   aIntSdo      += qSdo*auxDdias                                // *
   aEntCount     =  auxEntCount                                 //
   aSaiCount     =  auxSaiCount                                 //
   aN           += auxDdias                                     // *
   aSumEnt2     += auxEntrada2                                  //
   aSumSai2     += auxSaida2                                    //
   aSumSdo2     += auxSdo2Ddias                                 // *

   aMedEnt       =  aSumEnt/aN                                  // *
   aMedSai       =  aSumSai/aN                                  // *
   aMedSdo       =  aIntSdo/aN                                  // *
   aTMER         =  aN/aEntCount                                // *
   aTMEA         =  aN/aSaiCount                                // *
   nNESTQT       =  aMedSai*nNEstDias                           // *
   nCapMax       =  aMedSai                                     // *

   aSumEnt2N     =  (aSumEnt^2)/aN                              // *
   aSumSai2N     =  (aSumSai^2)/aN                              // *
   aIntSdo2N     =  (aIntSdo^2)/aN                              // *
   aLoteEMed     =  aSumEnt/aEntCount                           //
   aLoteSMed     =  aSumSai/aSaiCount                           //
   aSincron      =  aTMER/aTMEA                                 // *

   aDPEnt        =  ((aSumEnt2-((aSumEnt^2)/aN))/aN)^(1/2)      // *
   aDPSai        =  ((aSumSai2-((aSumSai^2)/aN))/aN)^(1/2)      // *
   aDPSdo        =  ((aSumSdo2-((aIntSdo^2)/aN))/aN)^(1/2)      // *
   aCVEnt        =  (aDPEnt/aMedEnt)*100                        // *
   aCVSai        =  (aDPSai/aMedSai)*100                        // *
   aCVSdo        =  (aDPSdo/aMedSdo)*100                        // *

   aMaxEnt       = max(tmp->qENTRADA,aMaxEnt)
   aMinEnt       = min(if(tmp->qENTRADA>0,tmp->qENTRADA,999999999999),aMinEnt)
   aMaxSai       = max(tmp->qSAIDA,aMaxSai)
   aMinSai       = min(if(tmp->qSAIDA>0,tmp->qSAIDA,999999999999),aMinSai)
   aMaxSal       = max(qSdo,aMaxSal)
   aMinSal       = min(qSdo,aMinSal)

   aDiasSdo[++k] = auxDdias
   aDiasSdo[++k] = qSdo

   aSdoIni      = qSdo
   aCobInst     = nSdoAtual/aMedSai

   dData = tmp->DATA
   qSdo  = qSdo + tmp->qSAIDA - tmp->qENTRADA                   // qSdo:         0
   tmpD1 = tmp->D1
   tmpD2 = tmp->D2

   xCodPro = tmp->COD_PRO

   tmp->(dbskip())                      // SKIP NA SKU

   if xCodPro <> tmp->COD_PRO .and.  dData <> tmpD1
       auxDdias          = dData - tmpD1
       auxSdoDdias       = qSdo * auxDdias
       auxSdo2           = qSdo^2
       auxSdo2Ddias      = qSdo^2*auxDdias

       aIntSdo          += qSdo*auxDdias                                // *
       aN               += auxDdias                                     // *

       aSumSdo2         += auxSdo2Ddias                                 // *

       aMedEnt           =  aSumEnt/aN                                  // *
       aMedSai           =  aSumSai/aN                                  // *
       aMedSdo           =  aIntSdo/aN                                  // *
       aTMER             =  aN/aEntCount                                // *
       aTMEA             =  aN/aSaiCount                                // *
       nNESTQT           =  aMedSai*nNEstDias                           // *
       nCapMax           =  aMedSai                                     // *

       aSumEnt2N         =  (aSumEnt^2)/aN                              // *
       aSumSai2N         =  (aSumSai^2)/aN                              // *
       aIntSdo2N         =  (aIntSdo^2)/aN                              // *
       aSincron          =  aTMER/aTMEA                                 // *

       aDPEnt            =  ((aSumEnt2-((aSumEnt^2)/aN))/aN)^(1/2)      // *
       aDPSai            =  ((aSumSai2-((aSumSai^2)/aN))/aN)^(1/2)      // *
       aDPSdo            =  ((aSumSdo2-((aIntSdo^2)/aN))/aN)^(1/2)      // *
       aCVEnt            =  (aDPEnt/aMedEnt)*100                        // *
       aCVSai            =  (aDPSai/aMedSai)*100                        // *
       aCVSdo            =  (aDPSdo/aMedSdo)*100                        // *

       aDiasSdo[++k]     = auxDdias
       aDiasSdo[++k]     = qSdo

       aSdoIni           = qSdo
   endif


   // Lead-Time = Perodo de tempo (lead-time) requerido para executar o processo de reposio
   if xCodPro <> tmp->COD_PRO   // Processa Estatisticas
      sEstSeg     = aDPSai*nFS
      sPRep1      = sEstSeg+aMedSai*nLeadTime
      sPRep2      = (nLeadTime/aTMEA)*(aMedSai+(aDPSai/((nLeadTime/aTMEA)^(1/2)))*nFS)
      aCobInst    = nSdoAtual/aMedSai

      // Carrega quantos dias o saldo esteve abaixo do PRep1 ou PRep2 ou PRepUSO
      // aDiasSdo = {dias,sdo...}


      for i=1 to k step 2
         if aDiasSdo[i+1] >= nEstMin ; aSdoAcPP1 += aDiasSdo[i]; endif
         if aDiasSdo[i+1] >= sPRep1  ; aSdoAcPP2 += aDiasSdo[i]; endif
         if aDiasSdo[i+1] >= sPRep2  ; aSdoAcPP3 += aDiasSdo[i]; endif
         if aDiasSdo[i+1]  < nEstMin ; aSdoAbPP1 += aDiasSdo[i]; endif
         if aDiasSdo[i+1]  < sPrep1  ; aSdoAbPP2 += aDiasSdo[i]; endif
         if aDiasSdo[i+1]  < sPrep2  ; aSdoAbPP3 += aDiasSdo[i]; endif
         if aDiasSdo[i+1]  = 0       ; aSdoZero  += aDiasSdo[i]; endif
         if aDiasSdo[i+1]  < sEstSeg ; aExpRup   += aDiasSdo[i]; endif
      next

/*
      Alert("nFS:"+str(nFS))
      Alert("LeadTime:"+str(nLeadTime))
      Alert("nSdoAtual:"+str(nSdoAtual))
      Alert("sEstSeg:"+str(sEstSeg))
      Alert("sPRep1:"+str(sPRep1))
      Alert("sPRep2:"+str(sPRep2))
      Alert("sCobInstant:"+str(sCobInstant))
*/
      o = 0
      if aN > 1
         cSql  = " update " + SetTabela("tpro202")                              + " set "
         cSql += " DDIAS    =  " + str(aN)                                      + ","
         cSql += " D1       = '" + UsData2(tmpD1)                               + "',"
         cSql += " D2       = '" + UsData2(tmpD2)                               + "',"
         cSql += " SOMAENT  =  " + str(aSumEnt,18,5)                            + ","
         cSql += " SOMASAI  =  " + str(aSumSai,18,5)                            + ","
         cSql += " INTSAL   =  " + str(aIntSdo,18,5)                            + ","
         cSql += " CONTSAI  =  " + str(aSaiCount,18,5)                          + ","
         cSql += " CONTENT  =  " + str(aEntCount,18,5)                          + ","
         cSql += " DDIAS    =  " + str(aN,18,5)                                 + ","
       //cSql += " S2ENT    =  " + str(aSumEnt2,18,5)                           + ","
       //cSql += " S2SAI    =  " + str(aSumSai2,18,5)                           + ","
       //cSql += " S2SAL    =  " + str(aSumSdo2,18,5)                           + ","
         cSql += " MEDENT   =  " + str(aMedEnt,18,5)                            + ","
         cSql += " MEDSAI   =  " + str(aMedSai,18,5)                            + ","
         cSql += " MEDSAL   =  " + str(aMedSdo,18,5)                            + ","
         cSql += " TMER     =  " + str(aTMER,18,5)                              + ","
         cSql += " TMEA     =  " + str(aTMEA,18,5)                              + ","
       //cSql += " SENT2N   =  " + str(aSumEnt2N,18,5)                          + ","
       //cSql += " SSAI2N   =  " + str(aSumSai2N,18,5)                          + ","
       //cSql += " INTS2N   =  " + str(aIntSdo2N,18,5)                          + ","
         cSql += " LOTEEM   =  " + str(aLoteEMed,18,5)                          + ","
         cSql += " LOTESM   =  " + str(aLoteSMed,18,5)                          + ","
         cSql += " SINCRON  =  " + str(aSincron,18,5)                           + ","
         cSql += " DPENT    =  " + str(aDPEnt,18,5)                             + ","
         cSql += " DPSAI    =  " + str(aDPSai,18,5)                             + ","
         cSql += " DPSAL    =  " + str(aDPSdo,18,5)                             + ","
         cSql += " CVENT    =  " + str(aCVEnt,18,5)                             + ","
         cSql += " CVSAI    =  " + str(aCVSai,18,5)                             + ","
         cSql += " CVSAL    =  " + str(aCVSdo,18,5)                             + ","
         cSql += " ESTSEG   =  " + str(sEstSeg,18,5)                            + ","
         cSql += " PREP1    =  " + str(sPRep1,18,5)                             + ","
         cSql += " PREP2    =  " + str(sPRep2,18,5)                             + ","
         cSql += " NESTQT   =  " + str(nNESTQT,18,5)                            + ","
         cSql += " CAPMAX   =  " + str(nCapMax,18,5)                            + ","
         cSql += " COBMEDIA =  " + str(o,18,5)                                  + ","
         cSql += " GIRO     =  " + str(o,18,5)                                  + ","
         cSql += " COBINST  =  " + str(aCobInst,18,5)                           + ","
         cSql += " RSI      =  " + str(o,18,5)                                  + ","
         cSql += " PAYBACK  =  " + str(o,18,5)                                  + ","
         cSql += " EXPRUP   =  " + str(aExpRup,18,5)                            + ","
         cSql += " POTMEDRUP=  " + if(.f.,"1","0")                              + ","
         cSql += " POTINSRUP=  " + if(.f.,"1","0")                              + ","
         cSql += " NS1      =  " + str(o,18,5)                                  + ","
         cSql += " NS2      =  " + str(o,18,5)                                  + ","
         cSql += " TMPROC1  =  " + str(o,18,5)                                  + ","
         cSql += " TMPROC2  =  " + str(o,18,5)                                  + ","
         cSql += " TMPROC3  =  " + str(o,18,5)                                  + ","
         cSql += " TMPROC4  = " + str(o,18,5)                                   + ","
         cSql += " TMPROC5  = " + str(o,18,5)                                   + ","
         cSql += " CMEDIO   = " + str(aCM,18,5)                                 + ","
         cSql += " MGBRUTA  = " + str(o,18,5)                                   + ","
         cSql += " PRMEDV   = " + str(o,18,5)                                   + ","
         cSql += " LTCOMB   = " + str(nLeadTime,18,5)                           + ","
         cSql += " LTAPU    = " + str(o,18,5)                                   + ","
         cSql += " SDOINI   = " + str(aSdoIni,18,5)                             + ","
         cSql += " SDOFIN   = " + str(aSdoFin,18,5)                             + ","
         cSql += " MAXENT   = " + str(aMaxEnt,18,5)                             + ","
         cSql += " MINENT   = " + str(aMinEnt,18,5)                             + ","
         cSql += " MAXSAI   = " + str(aMaxSai,18,5)                             + ","
         cSql += " MINSAI   = " + str(aMinSai,18,5)                             + ","
         cSql += " MAXSAL   = " + str(aMaxSal,18,5)                             + ","
         cSql += " MINSAL   = " + str(aMinSal,18,5)                             + ","
         cSql += " SDOATU   = " + str(nSdoAtual,18,5)                           + ","
         cSql += " ACHEGAR  = " + str(o,18,5)                                   + ","
         cSql += " SDOACPP1 = " + str(aSdoAcPP1,18,5)                           + ","
         cSql += " SDOACPP2 = " + str(aSdoAcPP2,18,5)                           + ","
         cSql += " SDOACPP3 = " + str(aSdoAcPP3,18,5)                           + ","
         cSql += " SDOABPP1 = " + str(aSdoAbPP1,18,5)                           + ","
         cSql += " SDOABPP2 = " + str(aSdoAbPP2,18,5)                           + ","
         cSql += " SDOABPP3 = " + str(aSdoAbPP3,18,5)                           + ","
         cSql += " SDOZERO  = " + str(aSdoZero,18,5)
         cSql += " where RECNO = " + str(xCod202)
         uai = rdd_update(cSql)
         if uai
            rdd_commit()
         else
            GerarTXT(cSql)
            Tat("Erro na execucao do processo...",.t.)
         endif
      endif
      TicRegua(iTotal,.f.,.t.)

      auxEntCount  = 0
      auxSaiCount  = 0
      auxDdias     = 0
      auxEntrada2  = 0
      auxSaida2    = 0
      auxSdoDdias  = 0
      auxSdo2      = 0
      auxSdo2Ddias = 0

      aSumEnt      = 0
      aSumSai      = 0
      aIntSdo      = 0
      aEntCount    = 0
      aSaiCount    = 0
      aN           = 0
      aSumEnt2     = 0
      aSumSai2     = 0
      aSumSdo2     = 0

      aMedEnt      = 0
      aMedSai      = 0
      aMedSdo      = 0
      aTMER        = 0
      aTMEA        = 0

      nNESTQT      = 0
      nCapMAx      = 0

      aSumEnt2N    = 0
      aSumSai2N    = 0
      aIntSdo2N    = 0
      aLoteEMed    = 0
      aLoteSMed    = 0
      aSincron     = 0

      aDPEnt       = 0
      aDPSai       = 0
      aDPSdo       = 0
      aCVEnt       = 0
      aCVSai       = 0
      aCVSdo       = 0

      sEstSeg      = 0
      sPRep1       = 0
      sPRep2       = 0
      sCobInstant  = 0

      aMaxEnt      = 0
      aMinEnt      = 0
      aMaxSai      = 0
      aMinSai      = 0
      aMaxSal      = -999999999999
      aMinSal      = 999999999999
      aCM          = 0
      afill(aDiasSdo,0)
      aSdoAcPP1    = 0
      aSdoAcPP2    = 0
      aSdoAcPP3    = 0
      aSdoAbPP1    = 0
      aSdoAbPP2    = 0
      aSdoAbPP3    = 0
      aSdoZero     = 0
      nEstMin      = 0
      aSdoFin      = 0
      aSdoIni      = 0
      aExpRup      = 0
      aCobInst     = 0
   endif
end
FechaRS("tmp")

RETURN(.t.)

//   Alert("DATA:"+dtoc(tmp->DATA))
//   Alert("dData:"+dtoc(dData))
//   Alert("qSdo:"+str(qSdo))                   //     400      800       1300     1000       700     500
//   Alert("auxEntCount:"+str(auxEntCount))     //       0        0          1        2         3       3
//   Alert("auxSaiCount:"+str(auxSaiCount))     //       1        2          2        2         2       3
//   Alert("auxDdias:"+str(auxDdias))           //      13       54         72        9        25      32
//   Alert("auxEntrada2:"+str(auxEntrada2))     //       0        0      90000    90000     40000       0
//   Alert("auxSaida2:"+str(auxSaida2))         //  160000   250000          0        0         0  250000
//   Alert("auxSdoDdias:"+str(auxSdoDdias))     //    5200    43200      93600     9000     17500   16000
//   Alert("auxSdo2:"+str(auxSdo2))             //  160000   640000    1690000  1000000    490000  250000
//   Alert("auxSdo2Ddias:"+str(auxSdo2Ddias))   // 2080000 34560000  121680000  9000000  12250000 8000000

/*
       Alert("aIntSdo"+str(aIntSdo))
       Alert("aEntCount"+str(aEntCount))
       Alert("aSaiCount"+str(aSaiCount))
       Alert("aN"+str(aN))
       Alert("aSumEnt2"+str(aSumEnt2))
       Alert("aSumSai2"+str(aSumSai2))
       Alert("aSumSdo2"+str(aSumSdo2))

       Alert("aMedEnt"+str(aMedEnt))
       Alert("aMedSai"+str(aMedSai))
       Alert("aMedSdo"+str(aMedSdo))
       Alert("aTMER"+str(aTMER))
       Alert("aTMEA"+str(aTMEA))

       Alert("aSumEnt2N"+str(aSumEnt2N))
       Alert("aSumSai2N"+str(aSumSai2N))
       Alert("aIntSdo2N"+str(aIntSdo2N))
       Alert("aLoteEMed"+str(aLoteEMed))
       Alert("aLoteSMed"+str(aLoteSMed))
       Alert("aSincron"+str(aSincron))

       Alert("aDPEnt"+str(aDPEnt))
       Alert("aDPSai"+str(aDPSai))
       Alert("aDPSdo"+str(aDPSdo))
       Alert("aCVEnt"+str(aCVEnt))
       Alert("aCVSai"+str(aCVSai))
       Alert("aCVSdo"+str(aCVSdo))

       Alert("DATA:"+dtoc(tmpD1))
       Alert("dData:"+dtoc(dData))
       Alert("auxDdias:"+str(auxDdias))                 //       160
       Alert("auxSdoDdias:"+str(auxSdoDdias))           //    160000
       Alert("auxSdo2:"+str(auxSdo2))                   //   1000000
       Alert("auxSdo2Ddias:"+str(auxSdo2Ddias))         // 160000000
*/

//////////////////////////
FUNCTION fNSGenericoMPDE()
//////////////////////////
Mens(maxrow()-1,maxrow(),d_ESP)
local cSql := "update "+SetTabela("tpro202")+" set COD_CE3 = "+str(ChaveAtual())+" where COD_CE1="+str(ChaveAtual(2))
local uai  := rdd_update(cSql)
if uai
   rdd_commit()
else
   rdd_rollbck()
   tat("Operacao NAO foi realizada com exito ...",.t.)
endif
RETURN(.t.)

//////////////////////
FUNCTION fNSFichaSKU()
//////////////////////
Mens(maxrow()-1,maxrow(),d_ESP)
local uai := .t.
local cSql := "select COD_PRO,RECNO from "+SetTabela("tpro202")+" where COD_CE1="+str(ChaveAtual(1))
AbreRS(cSql,"tmp")
while !tmp->(eof()) .and. uai
   cSql = "select COD_CE3 from "+SetTabela("titm002")+" where RECNO="+str(tmp->COD_PRO)+" and COD_CE3 > 0"
   aArray = rdd_select(cSql)
   if len(aArray)>0
      cSql = "update "+SetTabela("tpro202")+" set COD_CE3="+str(aArray[1])+" where RECNO="+str(tmp->(RECNO()))
      uai  = rdd_update(cSql)
   else
      cSql = "update "+SetTabela("tpro202")+" set COD_CE3=0 where RECNO="+str(tmp->(RECNO()))
      uai  = rdd_update(cSql)
   endif
   tmp->(dbskip())
end
if uai
   rdd_commit()
else
   rdd_rollbck()
   tat("Operacao NAO foi realizada com exito ...",.t.)
endif
FechaRS("tmp")
RETURN(.t.)

//////////////////////////
FUNCTION fLTGenericoMPDE()
//////////////////////////
local a          := IncBox("Qual o LeadTime Generico que deseja aplicar?","@e 999","",.f.,"0")
local cSql
if f_OK(1,"Atualiza o LT das SKU com LT=0? (Nao=todos)") .and. Mens(maxrow()-1,maxrow(),d_ESP)
   cSql = "update "+SetTabela("tpro202")+" set DE = "+str(a)+" where COD_CE1="+str(ChaveAtual(1)) + "and DE=0"
else
   cSql = "update "+SetTabela("tpro202")+" set DE = "+str(a)+" where COD_CE1="+str(ChaveAtual(1))
endif
local uai  := rdd_update(cSql)
if uai
   rdd_commit()
else
   rdd_rollbck()
   tat("Operacao NAO foi realizada com exito ...",.t.)
endif
RETURN(.t.)

//////////////////////
FUNCTION fLTFichaSKU()
//////////////////////
Mens(maxrow()-1,maxrow(),d_ESP)
local uai := .t.
local cSql := "select COD_PRO,RECNO from "+SetTabela("tpro202")+" where COD_CE1="+str(ChaveAtual(1))
AbreRS(cSql,"tmp")

while !tmp->(eof()) .and. uai
   cSql = "select DE,EST_MIN,EST_NIVEL,CAPAMAX from "+SetTabela("titm002")+" where RECNO="+str(tmp->COD_PRO)+" and COD_CE3 > 0"
   aArray = rdd_select(cSql)
   if len(aArray)>0
      cSql  = " update "+SetTabela("tpro202")
      cSql += " set DE        ="+str(aArray[1])+","
      cSql += "     PREP1     ="+str(aArray[2])+","
      cSql += "     NESTQT    ="+str(aArray[3])+","
      cSql += "     CAPMAX    ="+str(aArray[4])+" where RECNO="+str(tmp->(RECNO()))
      uai  = rdd_update(cSql)
   else
      cSql = "update "+SetTabela("tpro202")+" set DE=0 where RECNO="+str(tmp->(RECNO()))
      uai  = rdd_update(cSql)
   endif
   tmp->(dbskip())
end
if uai
   rdd_commit()
else
   rdd_rollbck()
   tat("Operacao NAO foi realizada com exito ...",.t.)
endif
FechaRS("tmp")
RETURN(.t.)

//////////////////////
FUNCTION fNIVDIASSKU()
//////////////////////
local a          := IncBox("Quantos dias de estoque deseja utilizar?","@e 999","",.f.,"0")
local cSql
if f_OK(1,"Atualiza o Nivel de Estoque em dias ou os com valor=0? (Nao=todos)") .and. Mens(maxrow()-1,maxrow(),d_ESP)
   cSql = "update "+SetTabela("tpro202")+" set NESTDIAS = "+str(a)+" where COD_CE1="+str(ChaveAtual(1)) + "and NESTDIAS=0"
else
   cSql = "update "+SetTabela("tpro202")+" set NESTDIAS = "+str(a)+" where COD_CE1="+str(ChaveAtual(1))
endif
local uai  := rdd_update(cSql)
if uai
   rdd_commit()
else
   rdd_rollbck()
   tat("Operacao NAO foi realizada com exito ...",.t.)
endif
RETURN(.t.)


//////////////////////
FUNCTION fLTProcAuto()
//////////////////////
RETURN(.t.)

*************************
FUNCTION fAchaA1(iCodPro)
*************************
local i
for i=1 to len(aA1) step 2
   if aA1[i] = iCodPro
      exit
   endif
next
if i > len(aA1)
   uai = 0
else
   uai = aA1[i+1]
endif
RETURN(uai)

*************************
FUNCTION fAchaA2(iCodPro)
*************************
local i
for i=1 to len(aA2) step 2
   if aA2[i] = iCodPro
      exit
   endif
next
if i > len(aA2)
   uai = 0
else
   uai = aA2[i+1]
endif
RETURN(uai)

*************************
FUNCTION fAchaA3(iCodPro)
*************************
local i
for i=1 to len(aA3) step 2
   if aA3[i] = iCodPro
      exit
   endif
next
if i > len(aA3)
   uai = 0
else
   uai = aA3[i+1]
endif
RETURN(uai)

*******************************
FUNCTION fRegrLeadTime(iCodPro)  && Em Dias
*******************************
local uai    := 0
local cSql   := " select LTENTR "
      cSql   += " from " + SetTabela("titm040")
      cSql   += " where COD_PRO = " + str(iCodPro) + " and "
      cSql   += "       PREFER  = 1"
local aArray := rdd_select(cSql)
if len(aArray) > 0
   uai = aArray[1]
endif
RETURN(uai)

**************************
FUNCTION MoviGramas(iTipo)
**************************
local iChave
local iCodPro  := ChaveAtual()
local cSql     := "select COD_ALM,UN_EST,EST_MIN,EST_NIVEL,CAPAMAX from " + SetTabela("titm002") + " where RECNO = " + astr(iCodPro)
local aArray   := rdd_select(cSql)
local iCodLoc  := aArray[1]
local cUnEst   := left(aArray[2],5)
local iEstMin  := aArray[3]
local iEstNiv  := aArray[4]
local iCapaMax := aArray[5]
local iMaxE    := 0
local iMaxS    := 0
local iMaxSd   := 0
local iMinSd   := 999999999999
local iMaxPos  := 0
local iMaxNeg  := 0
local iLarguraGrafico := 68
local i,k
local iTS      := 0
local iTTSaldo := 0

if D1aD2() .and. Mens(maxrow()-1,maxrow(),d_ESP)
   local iNrDias := dData2 - dData1 + 1
   local iNrProc := GerarContador("PROCESSO")
   local iSaldo  := Saldo2EstEm(dData1,iCodPro,iCodLoc)
   local iSaldoI := iSaldo

   for i = 1 to iNrDias
      cSql  = " insert into " + SetTabela("ttmp000") + " (PROCESSO,CHAVE,CARACTER0) values ("
      cSql += astr(iNrProc)      + ","
      cSql += astr(i)            + ",'"
      cSql += dtoc(dData1+(i-1)) + "')"
      uai   = rdd_insert(cSql)
      if !uai
         exit
      endif
   next

   if uai
      cSql   = " select DATA,sum(ENTRADA),sum(SAIDA)"
      cSql  += " from " + SetTabela("titm020")
      cSql  += " where COD_PRO =  " + astr(iCodPro)   + "  and "
      cSql  += "       DATA   >= '" + UsData2(dData1) + "' and "
      cSql  += "       DATA   <= '" + UsData2(dData2) + "' and "
      cSql  += "       COD_LOC =  " + astr(iCodLoc)
      cSql  += " group by DATA "
      cSql  += " order by DATA "

      aArray = rdd_select(cSql)

      for i = 1 to len(aArray) step 3
         iSaldo += (aArray[i+1]-aArray[i+2])
         iMaxE   = max(iMaxE ,aArray[i+1])
         iMaxS   = max(iMaxS ,aArray[i+2])
         iTS    += aArray[i+2]
         iMaxSd  = max(iMaxSd,iSaldo)
         iMinSd  = min(iMinSd,iSaldo)
         iMinSd  = min(0,iMinSd)
         iMaxPos = max(iMaxPos,max(iMaxE,iMaxSd))
         iMaxPos = max(iMaxPos,iCapaMax)
         iMaxNeg = min(iMaxNeg,min(-1*iMaxS,iMinSd))
      next
      iRange   = iMaxE   + iMaxS
      iRangeSd = iMaxSd  - iMinSd
      iRangePN = iMaxPos - iMaxNeg
      iPP      = iMaxE/iRange
      iPN      = iMaxS/iRange
      iPPSd    = iMaxSd/iRangeSd
      iPNSd    = abs(iMinSd)/iRangeSd
      iPPPN    = iMaxPos/iRangePN
      iPNPN    = abs(iMaxNeg)/iRangePN

      iZero    = int(iLarguraGrafico * iPN)
      iZeroSd  = int(iLarguraGrafico * iPNSd)
      iZeroPN  = int(iLarguraGrafico * iPNPN)

      iSaldo   = iSaldoI

      for i = 1 to iNrDias
         if iTipo = 1 &&& Entrada e Saida
            a = space(iZero) + chr(179)
            cSql    = " update " + SetTabela("ttmp000") + " set "
            cSql   += " CARACTER1 = '" + a + "'"
            cSql   += " where PROCESSO = " + astr(iNrProc) + " and "
            cSql   += "       CHAVE    = " + astr(i)
            uai     = rdd_update(cSql)
         elseif iTipo = 2
            a = space(iZeroSD) + "0"
            cSql    = " update " + SetTabela("ttmp000") + " set "
            cSql   += " CARACTER1 = '" + a + "'"
            cSql   += " where PROCESSO = " + astr(iNrProc) + " and "
            cSql   += "       CHAVE    = " + astr(i)
            uai     = rdd_update(cSql)
         else
            a = space(iZeroPN) + chr(179)
            cSql    = " update " + SetTabela("ttmp000") + " set "
            cSql   += " CARACTER1 = '" + a + "'"
            cSql   += " where PROCESSO = " + astr(iNrProc) + " and "
            cSql   += "       CHAVE    = " + astr(i)
            uai     = rdd_update(cSql)
         endif
         if !uai
            exit
         endif
      next
      if uai
         Ult_a     = ""
         Ult_Saldo = iSaldoI
         Ult_Chave = 0
         for i = 1 to len(aArray) step 3
            iSaldo += (aArray[i+1]-aArray[i+2])
            iChave  = ctod(BrData(aArray[i])) - dData1 + 1
            dData   = ctod(BrData(aArray[i]))
            if iTipo=1
               a       = right(space(iZero)+replicate("<",iLarguraGrafico*iPN*aArray[i+2]/iMaxS),iZero)  + chr(179) + left(replicate(">",iLarguraGrafico*iPP*aArray[i+1]/iMaxE)+space(iLarguraGrafico-iZero),iLarguraGrafico-iZero)
               cSql    = " update " + SetTabela("ttmp000") + " set "
               cSql   += " CARACTER1 = '" + a + "'"
               cSql   += " where PROCESSO = " + astr(iNrProc) + " and "
               cSql   += "       CHAVE    = " + astr(iChave)
               uai     = rdd_update(cSql)
            elseif iTipo=2
               if iSaldo > 0
                  a = space(iZeroSd)  + "0" + left(replicate("*",iLarguraGrafico*iPPSd*iSaldo/iMaxSd)+space(iLarguraGrafico-iZeroSd),iLarguraGrafico-iZeroSd)
               elseif iSaldo < 0
                  a = right(space(iZeroSd)+replicate("*",iLarguraGrafico*iPNSd*iSaldo/iMinSd),iZeroSd)  + "0" + space(iLarguraGrafico-iZeroSd)
               else
                  a = space(iZeroSd)  + "0"
               endif
               if !empty(Ult_Chave)
                  cSql    = " update " + SetTabela("ttmp000") + " set "
                  cSql   += " CARACTER1 = '" + Ult_a + "'"
                  cSql   += " where PROCESSO = " + astr(iNrProc) + " and "
                  cSql   += "       CHAVE     < " + astr(iChave) + " and "
                  uai     = rdd_update(cSql)
               endif
               if uai
                  cSql    = " update " + SetTabela("ttmp000") + " set "
                  cSql   += " CARACTER1 = '" + a + "'"
                  cSql   += " where PROCESSO  = " + astr(iNrProc) + " and "
                  cSql   += "       CHAVE     = " + astr(iChave)
                  uai     = rdd_update(cSql)
               endif
               Ult_a     = a
               Ult_Chave = iChave
            else
               if !empty(Ult_Chave)
                  cSql    = " update " + SetTabela("ttmp000") + " set "
                  cSql   += " VALOR1 = " + str(Ult_Saldo,18,5)
                  cSql   += " where PROCESSO = " + astr(iNrProc) + " and "
                  cSql   += "       CHAVE     < " + astr(iChave) + " and "
                  cSql   += "       CHAVE     > " + astr(Ult_Chave)
                  uai     = rdd_update(cSql)
               endif
               if uai
                  a       = right(space(iZeroPN)+replicate("<",iLarguraGrafico*iPNPN*aArray[i+2]/abs(iMaxNeg)),iZeroPN)  + chr(179) + left(replicate(">",iLarguraGrafico*iPPPN*aArray[i+1]/iMaxPos)+space(iLarguraGrafico-iZeroPN),iLarguraGrafico-iZeroPN)
                  cSql    = " update " + SetTabela("ttmp000") + " set "
                  cSql   += " CARACTER1 = '" + a + "',"
                  cSql   += " VALOR1    = " + str(iSaldo,18,5)
                  cSql   += " where PROCESSO = " + astr(iNrProc) + " and "
                  cSql   += "       CHAVE    = " + astr(iChave)
                  uai     = rdd_update(cSql)
               endif
               Ult_Saldo = iSaldo
               Ult_Chave = iChave
            endif
            if !uai
               exit
            endif
         next
      endif
   endif
   if uai .and. iTipo=3  && Pondo o saldo (*) na tmp000->caracter1
      for i=1 to iNrDias
         cSql   = "select CARACTER1,VALOR1 from " + SetTabela("ttmp000") + " where PROCESSO = " + astr(iNrProc) + " and CHAVE = " + astr(i)
         aArray = rdd_select(cSql)
         iSaldo = aArray[2]
         a      = aArray[1]

         E(a)
         a = space(iZeroPN)  + "0" + left(replicate("*",iLarguraGrafico*iPPPN*iEstMin/iMaxPos)+space(iLarguraGrafico-iZeroPN),iLarguraGrafico-iZeroPN)
         k = len(rtrim(a))
         a = D()
         a = left(a,k-1) + "m" + right(a,len(a)-k)

         E(a)
         a = space(iZeroPN)  + "0" + left(replicate("*",iLarguraGrafico*iPPPN*iEstNiv/iMaxPos)+space(iLarguraGrafico-iZeroPN),iLarguraGrafico-iZeroPN)
         k = len(rtrim(a))
         a = D()
         a = left(a,k-1) + "N" + right(a,len(a)-k)

         E(a)
         a = space(iZeroPN)  + "0" + left(replicate("*",iLarguraGrafico*iPPPN*iCapaMax/iMaxPos)+space(iLarguraGrafico-iZeroPN),iLarguraGrafico-iZeroPN)
         k = len(rtrim(a))
         a = D()
         a = left(a,k-1) + "M" + right(a,len(a)-k)

         E(a)
         iTTSaldo += iSaldo
         if iSaldo > 0
            a = space(iZeroPN)  + "0" + left(replicate("*",iLarguraGrafico*iPPPN*iSaldo/iMaxPos)+space(iLarguraGrafico-iZeroPN),iLarguraGrafico-iZeroPN)
            k = len(rtrim(a))
         elseif iSaldo < 0
            a = right(space(iZeroPN)+replicate("*",iLarguraGrafico*iPNPN*iSaldo/iMaxNeg),iZeroPN)  + "0" + space(iLarguraGrafico-iZeroPN)
            k       = len(a) - len(ltrim(a))
         else
            a = space(iZeroSd)  + "0"
            k       = len(a)
         endif
         a = D()
         a = left(a,k-1) + "*" + right(a,len(a)-k)

         cSql    = " update " + SetTabela("ttmp000") + " set "
         cSql   += " CARACTER1 = '" + a + "',"
         cSql   += " VALOR1    = " + astr(iSaldo)
         cSql   += " where PROCESSO = " + astr(iNrProc) + " and "
         cSql   += "       CHAVE    = " + astr(i)
         uai     = rdd_update(cSql)
      next
   endif
   if uai
      cns_TMP1 = iNrProc
      cns_TMP2 = alltrim(transform(iTTSaldo/iNrDias,"@e 999,999,999.99"))
      cns_TMP3 = alltrim(transform(iTS/iNrDias,"@e 999,999,999.99")) + " " + alltrim(cUnEst)
      cns_TMP4 = alltrim(transform(iTTSaldo/iTS,"@e 99,999.99")) + " dia(s)"

      cc("sitm200")
   else
      tat("O Processo nao foi realizado com exito ...",.t.)
   endif
   rdd_rollbck()
endif
RETURN(.t.)

***********************************
FUNCTION Movi2Gramas(iTipo,xCodPro)
***********************************
* iTipo = 3 - Cenarios de Producao

local iChave
local iCodPro
if iTipo = 3
   iCodPro = xCodPro
else
   iCodPro  := ChaveAtual()
endif
local cSql     := "select COD_ALM,UN_EST,EST_MIN,EST_NIVEL,CAPAMAX from " + SetTabela("titm002") + " where RECNO = " + astr(iCodPro)
local aArray   := rdd_select(cSql)
local iCodAlm  := aArray[1]
local iCodLoc  := AlmoxLoc(iCodAlm,1,.f.)
local cUnEst   := left(aArray[2],5)
local iEstMin  := aArray[3]
local iEstNiv  := aArray[4]
local iCapaMax := aArray[5]
local iMin     := 0
local iMax     := 0
local iZero
local iLarguraGrafico := 68
local i,k
local iTS      := 0
local iTTSaldo := 0
local MediaConsumo
local DPConsumo
local iRuptura := 0
local a
local b := 0
local iEstCritico := 0
if (iTipo = 3 .or. D1aD2()) .and. Mens(maxrow()-1,maxrow(),d_ESP)
   local iNrDias := dData2 - dData1 + 1
   local iNrProc := GerarContador("PROCESSO")
   local iSaldo  := Saldo2EstEm(dData1,iCodPro,iCodLoc)
   local iSaldoI := iSaldo

   for i = 1 to iNrDias
      cSql  = " insert into " + SetTabela("ttmp000") + " (PROCESSO,CHAVE,D1,CARACTER0) values ("
      cSql += astr(iNrProc)      + ","
      cSql += astr(i)            + ",'"
      cSql += UsData(dData1+(i-1)) + "','"
      cSql += dtoc(dData1+(i-1)) + "')"
      uai   = rdd_insert(cSql)
      if !uai
         exit
      endif
   next

   if uai
      cSql   = " select DATA,sum(ENTRADA),sum(SAIDA)"
      cSql  += " from " + SetTabela("titm020")
      cSql  += " where COD_PRO =  " + astr(iCodPro)   + "  and "
      cSql  += "       DATA   >= '" + UsData2(dData1) + "' and "
      cSql  += "       DATA   <= '" + UsData2(dData2) + "' "
      cSql  += "       COD_LOC =  " + astr(iCodLoc)
      cSql  += " group by DATA "
      cSql  += " order by DATA "

      aArray = rdd_select(cSql)

      for i = 1 to len(aArray) step 3
         iSaldo += (aArray[i+1]-aArray[i+2])
         iMaxE   = max(iMaxE ,aArray[i+1])
         iMaxS   = max(iMaxS ,aArray[i+2])
         iTS    += aArray[i+2]
         iMaxSd  = max(iMaxSd,iSaldo)
         iMinSd  = min(iMinSd,iSaldo)
         iMinSd  = min(0,iMinSd)
         iMax    = max(iMax,max(iMaxE,iMaxSd))
         iMax    = max(iMax,iCapaMax)
         iMin    = min(iMin,min(-1*iMaxS,iMinSd))
      next
      MediaConsumo = iTS/iNrDias
      iRange   = iMax - iMin
      iPP      = iMax/iRange
      iPN      = abs(iMin)/iRange
      iZero    = int(iLarguraGrafico * iPN)
      for i = 1 to iNrDias
         a = if(iZero-1>0,space(iZero-1),"") + chr(179)
         cSql    = " update " + SetTabela("ttmp000") + " set "
         cSql   += " CARACTER1 = '" + a + "'"
         cSql   += " where PROCESSO = " + astr(iNrProc) + " and "
         cSql   += "       CHAVE    = " + astr(i)
         uai     = rdd_update(cSql)
         if !uai
            exit
         endif
      next
      if uai
         iSaldo    = iSaldoI
         Ult_Chave = 0
         for i = 1 to len(aArray) step 3
            iChave  = ctod(BrData(aArray[i])) - dData1 + 1
            dData   = ctod(BrData(aArray[i]))
            cSql    = " update " + SetTabela("ttmp000") + " set "
            cSql   += " VALOR1          = " + str(iSaldo,18,5)  &&+ ","
            cSql   += " where PROCESSO  = " + astr(iNrProc) + " and "
            cSql   += "       CHAVE     < " + astr(iChave) + " and "
            cSql   += "       CHAVE     > " + astr(Ult_Chave)
            uai     = rdd_update(cSql)
            iSaldo += (aArray[i+1]-aArray[i+2])
            if uai
               a       = right(if(iZero-1>0,space(iZero-1),"")+replicate("<",iLarguraGrafico*iPN*aArray[i+2]/abs(iMin)),iZero-1)
               a      += chr(179)
               a      += left(replicate("E",iLarguraGrafico*iPP*aArray[i+1]/iMax)+space(iLarguraGrafico-iZero),iLarguraGrafico-iZero)
               cSql    = " update " + SetTabela("ttmp000") + " set "
               cSql   += " CARACTER1      = '" + a + "',"
               cSql   += " VALOR1         = " + str(iSaldo,18,5) + ","
               cSql   += " VALOR2          = " + str(aArray[i+2]*-1,18,5) + "," // Saida
               cSql   += " VALOR3          = " + str(aArray[i+1],18,5)  // Entrada
               cSql   += " where PROCESSO = " + astr(iNrProc) + " and "
               cSql   += "       CHAVE    = " + astr(iChave)
               uai     = rdd_update(cSql)
            endif
            Ult_Saldo = iSaldo
            Ult_Chave = iChave
            if !uai
               exit
            endif
         next
      endif
   endif
   local r1 := 0
   local r2 := 0
   local r3 := 0
   local rDP := 0
   if uai && Pondo o saldo (*) na tmp000->caracter1
      for i=1 to iNrDias
         cSql   = "select CARACTER1,VALOR1,VALOR2 from " + SetTabela("ttmp000") + " where PROCESSO = " + astr(iNrProc) + " and CHAVE = " + astr(i)
         aArray = rdd_select(cSql)
         iSaldo = aArray[2]
         a      = aArray[1]
         b     += (aArray[3]-MediaConsumo)^2    && Este seria o calculo do Desvio Padrao ?

         r1    += aArray[3]^2
         r2    += aArray[3]

         E(a)
         a = if(iZero-1>0,space(iZero-1),"") + "0" + left(replicate("*",iLarguraGrafico*iPP*iEstMin/iMax)+space(iLarguraGrafico-iZero),iLarguraGrafico-iZero)
         k = len(rtrim(a))
         a = D()
         a = left(a,k-1) + "m" + right(a,len(a)-k)

         E(a)
         a = if(iZero-1>0,space(iZero-1),"") + "0" + left(replicate("*",iLarguraGrafico*iPP*iEstNiv/iMax)+space(iLarguraGrafico-iZero),iLarguraGrafico-iZero)
         k = len(rtrim(a))
         a = D()
         a = left(a,k-1) + "N" + right(a,len(a)-k)

         E(a)
         a = if(iZero-1>0,space(iZero-1),"") + "0" + left(replicate("*",iLarguraGrafico*iPP*iCapaMax/iMax)+space(iLarguraGrafico-iZero),iLarguraGrafico-iZero)
         k = len(rtrim(a))
         a = D()
         a = left(a,k-1) + "M" + right(a,len(a)-k)

         E(a)
         iTTSaldo += iSaldo
         rS1      += iSaldo*iNrDias
         if iSaldo > 0
            a = if(iZero-1>0,space(iZero-1),"") + "0" + left(replicate("*",iLarguraGrafico*iPP*iSaldo/iMax)+space(iLarguraGrafico-iZero),iLarguraGrafico-iZero)
            k = len(rtrim(a))
         elseif iSaldo < 0
            a = right(space(iZero)+replicate("*",iLarguraGrafico*iPN*iSaldo/iMax),iZero)  + "0" + space(iLarguraGrafico-iZero)
            k       = len(a) - len(ltrim(a))
         else
            a = if(iZero-1>0,space(iZero-1),"") + "0"
            k       = len(a)
         endif
         a = D()
         a = left(a,k-1) + "*" + right(a,len(a)-k)

         cSql    = " update " + SetTabela("ttmp000") + " set "
         cSql   += " CARACTER1      = '" + a + "'"
         cSql   += " where PROCESSO = " + astr(iNrProc) + " and "
         cSql   += "       CHAVE    = " + astr(i)
         uai     = rdd_update(cSql)
      next
   endif
   if uai

      r2  = r2 / iNrDias
      r2  = r2^2
      r3  = ((r1/iNrDias)-r2)^(1/2)
      rDP = r3


      cns_TMP1    = iNrProc
      cns_TMP2    = alltrim(transform(iTTSaldo/iNrDias,"@e 999,999,999.99"))
      cns_TMP3    = alltrim(transform(iTS/iNrDias,"@e 999,999,999.99")) + " " + alltrim(cUnEst)
      cns_TMP4    = alltrim(transform(iTTSaldo/iTS,"@e 99,999.99")) + " dia(s)"

      DPConsumo   = (b/iNrDias)^(1/2)
      iEstCritico = ((b^(1/2) ) / iNrDias ) * 1.28
      cns_TMP5    = alltrim(transform(rDP * 2.33 ,"@e 99,999.99"))
      cns_TMP6    = alltrim(transform(((rDP * 2.33) + MediaConsumo) * 3,"@e 999,999.99"))
      cSql        = "select count(*) from " + SetTabela("ttmp000") + " where PROCESSO = " + astr(iNrProc) + " and VALOR1 <= " + alltrim(str(iEstCritico,18,5))
      aArray      = rdd_cursor(cSql)
      iRuptura    = aArray[1]
      cns_TMP7    = alltrim(transform(iRuptura*100/iNrDias,"@e 999.99")) + "% / " + alltrim(transform(iRuptura,"@e 999")) + " em " + alltrim(transform(iNrDias,"@e 999")) + " dia(s)"
      cns_TMP8    = (rDP/MediaConsumo)*100

      local sSinal := "#999#~Movigrama~Valores~Dia~1~6~0~Saldo~2~Entrada~1~Saida~1~EstMin~2~NivelEst~2~Capacidade Max~2~"
      cSql="select d1,valor1,valor2,valor3 from "+SetTabela("ttmp000")+" where PROCESSO = "+astr(iNrProc)+" order by d1"
      aArray2 = rdd_select(cSql)
      for i=1 to len(aArray2) step 4
           sSinal += "~"  //dtoc(ctod(BrData(aArray2[i])))+"~"
           sSinal += str(aArray2[i+1])+"~"      // Saldo
           sSinal += str(aArray2[i+3])+"~"      // Entrada
           sSinal += str(aArray2[i+2])+"~"      // Saida
           sSinal += str(iEstMin)+"~"           // EstMin
           sSinal += str(iEstNiv)+"~"           // EstMin
           sSinal += str(iCapaMax)+"~"          // Capacidade Max
      next
      GerarTXT(sSinal)


      if iTipo = 3
         rdd_rollbck()
         cSql  = " update " + SetTabela("tpro202")      + " set "
         cSql += " D1          = '" + UsData(dData1)    + "',"
         cSql += " D2          = '" + UsData(dData2)    + "',"
         cSql += " SALDOMEDIO  = "  + cns_TMP2          + ", "
         cSql += " MEDSAIDIA   = "  + cns_TMP3          + ", "
         cSql += " DESVPADRAO  = "  + str(DPConsumo)
         cSql += " where RECNO = COD_C1  = " + str(ChaveAtual(1)) + " and "
         cSql += "       COD_PRO = " + str(iCodPro)
         uai = rdd_update(cSql)
      else
         cc("sitm200")
      endif
   else
      tat("O Processo nao foi realizado com exito ...",.t.)
   endif
   rdd_commit()
   if iTipo = 3
      rdd_commit()
      IAVetor(ChaveAtual())
   else
      rdd_rollbck()
   endif

endif
RETURN(.t.)

***********************************
FUNCTION Movi3Gramas(iTipo,xCodPro)
***********************************
// Movigrama p/ verso MultiCamada Client Flash

* iTipo = 3 - Cenarios de Producao
#ifdef OnDemand_compile
local iChave
local iCodPro
local xPRep1     := 0
local xPRep2     := 0
local xEstSeg    := 0
local xDPSai     := 0
local xDPEnt     := 0
local dData1     := ctod("  /  /  ")
local dData2     := ctod("  /  /  ")
local xNivEstPR1 := 0
local xCapMaxPR1 := 0
if iTipo = 3
   iCodPro = xCodPro
elseif iTipo = 4
   aArray = rdd_select("select COD_PRO,PREP1,PREP2,ESTSEG,DPSAI,DPENT,D1,D2,NESTQT,CAPMAX from "+ SetTabela("tpro202") +  " where RECNO = "+ str(ChaveAtual()))
   if len(aArray) > 0
      iCodPro = aArray[1]
      xPRep1  = aArray[2]
      xPRep2  = aArray[3]
      xEstSeg = aArray[4]
      xDPSai  = aArray[5]
      xDPEnt  = aArray[6]
      dData1  = ctod(BrData(aArray[7]))
      dData2  = ctod(BrData(aArray[8]))
      xNivEstPR1 = xPRep1+aArray[9]
      xCapMaxPR1 = xNivEstPR1+aArray[10]
   endif

else
   iCodPro  = ChaveAtual()
endif
local cSql     := "select COD_ALM,UN_EST,EST_MIN,EST_NIVEL,CAPAMAX,CODIGO,PRODUTO from " + SetTabela("titm002") + " where RECNO = " + astr(iCodPro)
local aArray   := rdd_select(cSql)
local iCodAlm  := aArray[1]
local iCodLoc  := AlmoxLoc(iCodAlm,1,.f.)
local cUnEst   := left(aArray[2],5)
local iEstMin  := aArray[3]
local iEstNiv  := aArray[4]
local iCapaMax := aArray[5]
local ProCod   := aArray[6]
local Produto  := aArray[7]
local iMin     := 0
local iMax     := 0
local iZero
local iLarguraGrafico := 68
local i,k
local iTS      := 0
local iTTSaldo := 0
local MediaConsumo
local DPConsumo
local iRuptura := 0
local a
local b := 0
local iEstCritico := 0
//Alert(str(iEstMin))
//Alert(str(iEstNiv))
//Alert(str(iCapaMax))
if (iTipo = 3 .or. iTipo = 4 .or. D1aD2()) .and. Mens(maxrow()-1,maxrow(),d_ESP)
   local iNrDias := dData2 - dData1 + 1
   local iNrProc := GerarContador("PROCESSO")
   local iSaldo  := Saldo2EstEm(dData1,iCodPro,iCodLoc)
   local iSaldoI := iSaldo

   for i = 1 to iNrDias
      cSql  = " insert into " + SetTabela("ttmp000") + " (PROCESSO,CHAVE,D1,CARACTER0) values ("
      cSql += astr(iNrProc)      + ","
      cSql += astr(i)            + ",'"
      cSql += UsData(dData1+(i-1)) + "','"
      cSql += dtoc(dData1+(i-1)) + "')"
      uai   = rdd_insert(cSql)
      if !uai
         exit
      endif
   next

   if uai
      cSql   = " select DATA,sum(ENTRADA),sum(SAIDA)"
      cSql  += " from " + SetTabela("titm020")
      cSql  += " where COD_PRO =  " + astr(iCodPro)   + "  and "
      cSql  += "       DATA   >= '" + UsData2(dData1) + "' and "
      cSql  += "       DATA   <= '" + UsData2(dData2) + "' and "
      cSql  += "       COD_LOC =  " + astr(iCodLoc)
      cSql  += " group by DATA "
      cSql  += " order by DATA "
  //    Alert(cSql)

      aArray = rdd_select(cSql)

      for i = 1 to len(aArray) step 3
         iSaldo += (aArray[i+1]-aArray[i+2])
         iMaxE   = max(iMaxE ,aArray[i+1])
         iMaxS   = max(iMaxS ,aArray[i+2])
         iTS    += aArray[i+2]
         iMaxSd  = max(iMaxSd,iSaldo)
         iMinSd  = min(iMinSd,iSaldo)
         iMinSd  = min(0,iMinSd)
         iMax    = max(iMax,max(iMaxE,iMaxSd))
         iMax    = max(iMax,iCapaMax)
         iMin    = min(iMin,min(-1*iMaxS,iMinSd))
      next
      MediaConsumo = iTS/iNrDias
      iRange   = iMax - iMin
      iPP      = iMax/iRange
      iPN      = abs(iMin)/iRange
      iZero    = int(iLarguraGrafico * iPN)
      for i = 1 to iNrDias
         a = if(iZero-1>0,space(iZero-1),"") + chr(179)
         cSql    = " update " + SetTabela("ttmp000") + " set "
         cSql   += " CARACTER1 = '" + a + "'"
         cSql   += " where PROCESSO = " + astr(iNrProc) + " and "
         cSql   += "       CHAVE    = " + astr(i)
         uai     = rdd_update(cSql)
         if !uai
            exit
         endif
      next
      if uai
         iSaldo    = iSaldoI
         Ult_Chave = 0
         for i = 1 to len(aArray) step 3
            iChave  = ctod(BrData(aArray[i])) - dData1 + 1
            dData   = ctod(BrData(aArray[i]))
            cSql    = " update " + SetTabela("ttmp000") + " set "
            cSql   += " VALOR1          = " + str(iSaldo,18,5)  &&+ ","
            cSql   += " where PROCESSO  = " + astr(iNrProc) + " and "
            cSql   += "       CHAVE     < " + astr(iChave) + " and "
            cSql   += "       CHAVE     > " + astr(Ult_Chave)
            uai     = rdd_update(cSql)
            iSaldo += (aArray[i+1]-aArray[i+2])
            if uai
               cSql    = " update " + SetTabela("ttmp000") + " set "
               //cSql   += " CARACTER1      = '" + a + "',"
               cSql   += " VALOR1         = " + str(iSaldo,18,0) + ","
               cSql   += " VALOR2          = " + str(aArray[i+2]*-1,18,0) + "," // Saida
               cSql   += " VALOR3          = " + str(aArray[i+1],18,0)  // Entrada
               cSql   += " where PROCESSO = " + astr(iNrProc) + " and "
               cSql   += "       CHAVE    = " + astr(iChave)
               uai     = rdd_update(cSql)
            endif
            Ult_Saldo = iSaldo
            Ult_Chave = iChave
            if !uai
               exit
            endif
         next
      endif
   endif
   local r1 := 0
   local r2 := 0
   local r3 := 0
   local rDP := 0
   if uai && Pondo o saldo (*) na tmp000->caracter1
      for i=1 to iNrDias
         cSql   = "select CARACTER1,VALOR1,VALOR2 from " + SetTabela("ttmp000") + " where PROCESSO = " + astr(iNrProc) + " and CHAVE = " + astr(i)
         aArray = rdd_select(cSql)
         iSaldo = aArray[2]
         a      = aArray[1]
         b     += (aArray[3]-MediaConsumo)^2    && Este seria o calculo do Desvio Padrao ?

         r1    += aArray[3]^2
         r2    += aArray[3]

         iTTSaldo += iSaldo
         rS1      += iSaldo*iNrDias
      next
   endif
   if uai

      r2  = r2 / iNrDias
      r2  = r2^2
      r3  = ((r1/iNrDias)-r2)^(1/2)
      rDP = r3


      cns_TMP1    = iNrProc
      cns_TMP2    = alltrim(transform(iTTSaldo/iNrDias,"@e 999,999,999.99"))
      cns_TMP3    = alltrim(transform(iTS/iNrDias,"@e 999,999,999.99")) + " " + alltrim(cUnEst)
      cns_TMP4    = alltrim(transform(iTTSaldo/iTS,"@e 99,999.99")) + " dia(s)"

      DPConsumo   = (b/iNrDias)^(1/2)
      iEstCritico = ((b^(1/2) ) / iNrDias ) * 1.28
      cns_TMP5    = alltrim(transform(rDP * 2.33 ,"@e 99,999.99"))
      cns_TMP6    = alltrim(transform(((rDP * 2.33) + MediaConsumo) * 3,"@e 999,999.99"))
      cSql        = "select count(*) from " + SetTabela("ttmp000") + " where PROCESSO = " + astr(iNrProc) + " and VALOR1 <= " + alltrim(str(iEstCritico,18,5))
      aArray      = rdd_cursor(cSql)
      iRuptura    = aArray[1]
      cns_TMP7    = alltrim(transform(iRuptura*100/iNrDias,"@e 999.99")) + "% / " + alltrim(transform(iRuptura,"@e 999")) + " em " + alltrim(transform(iNrDias,"@e 999")) + " dia(s)"
      cns_TMP8    = (rDP/MediaConsumo)*100

      cSql="select d1,valor1,valor2,valor3 from "+SetTabela("ttmp000")+" where PROCESSO = "+astr(iNrProc)+" order by d1"
      aArray2 = rdd_select(cSql)
      local sSinal := ""
      if iTipo = 4
         sSinal = "#161#~"+alltrim(ProCod)+"/"+alltrim(PRODUTO)+"~Valores~Dia~1~12~0~Saldos~2~Entradas~1~Saidas~1~PRepos Atual~2~NivelEst~2~Capacidade Max~2~PRepos Classico~2~PRepos IMAM~2~Est Seguranca~2~DesvPadrao Sai~2~NivEst PRep1~2~CapMax PRep1~2~"
         //sSinal = "#161#~"+dtoc(dData1)+"/"+dtoc(dData2)+"~Valores~Dia~1~10~0~Saldos~2~Entradas~1~Saidas~1~PRepos Atual~2~NivelEst~2~Capacidade Max~2~PRepos Classico~2~PRepos IMAM~2~Est Seguranca~2~DesvPadrao Sai~2~"
      else
         sSinal = "#161#~"+alltrim(ProCod)+"/"+alltrim(PRODUTO)+"~Valores~Dia~1~6~0~Saldo~2~Entrada~1~Saida~1~EstMin~2~NivelEst~2~Capacidade Max~2~"
      endif
      for i=1 to len(aArray2) step 4
           sSinal += "~"  //dtoc(ctod(BrData(aArray2[i])))+"~"
           sSinal += str(aArray2[i+1])+"~"      // Saldo
           sSinal += str(aArray2[i+3])+"~"      // Entrada
           sSinal += str(aArray2[i+2])+"~"      // Saida
           sSinal += str(iEstMin)+"~"           // EstMin
           sSinal += str(iEstNiv)+"~"           // EstMin
           sSinal += str(iCapaMax)+"~"          // Capacidade Max
           if iTipo = 4
              sSinal += str(xPRep1,15,0)+"~"            // PRepos1
              sSinal += str(xPRep2,15,0)+"~"            // PRepos2
              sSinal += str(xEstSeg,15,0)+"~"           // nEstSeg
              sSinal += str(xDPSai*-1,15,0)+"~"         // nDPSai
              sSinal += str(xNivEstPR1,15,0)+"~"        // Nivel Estoque sobre PRep1
              sSinal += str(xCapMaxPR1,15,0)+"~"        // Capacidade Max sobre PRep1
           endif
//         Alert(sSinal)
      next
   else
      tat("O Processo nao foi realizado com exito ...",.t.)
   endif
   //Alert("FINAL:"+sSinal)
   memowrit(zksLooksPath+"graf.edi",sSinal)
   flJOB_Grafico(zksLooksPath+"graf.edi")
   rdd_rollbck()
endif
#else
Tat("Nao disponivel nesta interface...",.t.)
#endif
RETURN(.t.)


///////////////////////
FUNCTION fGrafCompar1()
///////////////////////
#ifdef OnDemand_compile
// Assinatura
// Titulo Principal
// Titulo Eixo X
// Titulo Eixo Y
// Movigrama 0/1
// Numero de SubGrupos
// Liga/Desliga Pontos (s p/ Grficos de Linha)
// Titulo SubGrupo
// Tipo de Grfico (1 - Barra/ 2- Linha)
// ... (Titulo subGrupo e Tipo Grfico de acordo com o numero de SubGrupos)
// Grupo
// Valor
// ... (Valor1,Valor2,Valor3 ... De acordo com o Numero de SubGrupos)

   cSql  = " select sum(b.EST_MIN*a.CMEDIO) V1,sum(a.PREP1*a.CMEDIO) V2,sum(a.PREP2*a.CMEDIO) V3,sum(a.PREP2) xxx "
   cSql += " from "+SetTabela("tpro202")+" a,"
   cSql +=          SetTabela("titm002")+" b,"
   cSql +=          SetTabela("tpro201")+" c "
   cSql += " where a.COD_PRO = b.RECNO       and "
   cSql += "       c.RECNO   = "+str(ChaveAtual(1))+" and "
   cSql += "       b.EST_MIN > 0             and "
   cSql += "       a.PREP1   > 0             and "
   cSql += "       a.PREP2   > 0             and "
   cSql += "       a.CMEDIO  > 0             and "
   cSql += "       a.D2-a.D1 > 10            and "
   cSql += "       a.COD_CE1 = c.RECNO       and "
   cSql += "       a.COD_CE3 > 0             and "
   cSql += "       a.DE      > 0             and "
   cSql += "       a.D1      is not null     and "
   cSql += "       a.D2      is not null         "
   aArray = rdd_select(cSql)
   if len(aArray) > 0
      local sSinal := "#161#~Comparativo Ponto Reposicao Vlr CM~Valores~PReposicao~0~3~0~PrAtual~1~PRep Classico~1~PRep IMAM~1~~"
            sSinal += str(aArray[1],15,0)+"~"   //P Rep1
            sSinal += str(aArray[2],15,0)+"~"   //P Rep2
            sSinal += str(aArray[3],15,0)+"~"   //P Rep3
      memowrit(zksLooksPath+"graf.edi",sSinal)
      flJOB_Grafico(zksLooksPath+"graf.edi")
      rdd_rollbck()
   endif
#else
   Tat("Nao disponivel nesta interface...",.t.)
#endif
RETURN(.t.)

////////////////////////////
FUNCTION fGrafNivOper(iTipo)
////////////////////////////
#ifdef OnDemand_compile
// Assinatura
// Titulo Principal
// Titulo Eixo X
// Titulo Eixo Y
// Movigrama 0/1
// Numero de SubGrupos
// Liga/Desliga Pontos (s p/ Grficos de Linha)
// Titulo SubGrupo
// Tipo de Grfico (1 - Barra/ 2- Linha)
// ... (Titulo subGrupo e Tipo Grfico de acordo com o numero de SubGrupos)
// Grupo
// Valor
// ... (Valor1,Valor2,Valor3 ... De acordo com o Numero de SubGrupos)
   cSql  = " select b.TIPO,b.CATEGORIA,b.CODIGO,b.PRODUTO,b.EST_MIN P1,a.PREP1 P2,a.PREP2 P3,a.ESTSEG,b.CAPAMAX,sum(d.QT_EST-d.QT_ACO) QT_EST, sum(d.QT_EST) xxx "
   cSql += " from "+SetTabela("tpro202") +" a,"
   cSql +=          SetTabela("titm002") +" b,"
   cSql +=          SetTabela("tpro201") +" c,"
   cSql +=          SetTabela("titm014a")+" d,"
   cSql +=       SetTabela("titm014") +" e "
   cSql += " where a.COD_PRO    = b.RECNO    and "
   cSql += "       d.COD_PRO    = a.COD_PRO  and "
   cSql += "       d.COD_LOC    = e.RECNO    and "
   cSql += "       e.ACONSELHAR = 1          and "
   cSql += "       c.RECNO      = "+str(ChaveAtual(1))+"         and "
   cSql += "       b.EST_MIN    > 0          and "
   cSql += "       a.PREP1      > 0          and "
   cSql += "       a.PREP2      > 0          and "
   cSql += "       a.CMEDIO     > 0          and "
   cSql += "       a.D2-a.D1    > 10         and "
   cSql += "       a.COD_CE1    = c.RECNO    and "
   cSql += "       a.COD_CE3    > 0          and "
   cSql += "       a.DE         > 0          and "
   cSql += "       a.D1         is not null  and "
   cSql += "       a.D2         is not null      "
   cSql += " group by  b.TIPO,b.CATEGORIA,b.CODIGO,b.PRODUTO,b.EST_MIN,a.PREP1,a.PREP2,a.ESTSEG,b.CAPAMAX "
   cSql += " order by b.TIPO,b.CATEGORIA,b.CODIGO "
   AbreRS(cSql,"tmp")
   local nOperacao := ""
   local nRupt  := 0
   local nCrit  := 0
   local nDisp  := 0
   local nCobe  := 0
   local nExce  := 0
   local nTotal := 0
   local uai       := .t.
   if tmp->(eof())
      TAT("Sem Registros...",.t.)
      uai = .f.
   endif
   while !tmp->(eof()) .and. uai
      ++nTotal
      do case
         case tmp->QT_EST <= 0
            nOperacao = "1-Ruptura"
            ++nRupt
         case tmp->QT_EST <= tmp->ESTSEG
            nOperacao = "2-Critica"
            ++nCrit
         case tmp->QT_EST <= tmp->P1 .and. iTipo = 1
            nOperacao = "3-Disparo Ponto Atual"
            ++nDisp
         case tmp->QT_EST <= tmp->P2 .and. iTipo = 2
            nOperacao = "3-Disparo Ponto Classico"
            ++nDisp
         case tmp->QT_EST <= tmp->P3 .and. iTipo = 3
            nOperacao = "3-Disparo Ponto Reposicao MPDE"
            ++nDisp
         case tmp->QT_EST <= tmp->CAPAMAX
            nOperacao = "4-Coberto"
            ++nCobe
         case tmp->QT_EST > tmp->CAPAMAX
            nOperacao = "5-Excesso"
            ++nExce
      endcase
      tmp->(dbskip())
   end
   FechaRS("tmp")
   local sSinal := "#161#~Comparativo Ponto Reposicao Vlr CM~Valores~PReposicao~0~5~0~Ruptura~1~Critico~1~Disparo~1~Coberto~1~Excesso~1~~"
         sSinal += str(nRupt/nTotal*100,15,0)+"~"
         sSinal += str(nCrit/nTotal*100,15,0)+"~"
         sSinal += str(nDisp/nTotal*100,15,0)+"~"
         sSinal += str(nCobe/nTotal*100,15,0)+"~"
         sSinal += str(nExce/nTotal*100,15,0)+"~"
   memowrit(zksLooksPath+"graf.edi",sSinal)
   flJOB_Grafico(zksLooksPath+"graf.edi")
#else
   Tat("Nao disponivel nesta interface...",.t.)
#endif
RETURN(.t.)
