<?php
session_start();
header("Content-type: text/html; charset=iso-8859-1");
ob_start(); // Inicia o fluxo
?>
<?php
set_time_limit(300); 
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");
require_once('/qtux/library/phplot-6.1.0/phplot.php');

$sCia     = trim($_POST['sCia']);
$dDataDe  = trim($_POST['dDataDe']);
$dDataAte = trim($_POST['dDataAte']);

$sQry = '';
$sTit = '';
if ($sCia != '') {
   $sQry .= " and a.sPasta = '$sCia'";
   $sTit .= "Cia - $sCia ";
}

if ($dDataDe != '') {
   $sQry .= " and cast(a.tIn0 as date) >= '$dDataDe'";
   $sTit .= "De $dDataDe ";
}

if ($dDataAte != '') {
   $sQry .= " and cast(a.tIn0 as date) <= '$dDataAte'";
   $sTit .= "At $dDataAte ";
}

$sDSN  = "/qtux/database/gps_producao/gps_01.gdb";

$hDb = fhDbConnect($sDSN);
$sSql    = "select cast (a.tIn0 as date)       as Data,
                   extract(year   from a.tIn0) as Ano,
                   extract(month  from a.tIn0) as Mes,
                   extract(day    from a.tIn0) as Dia,
                   extract(hour   from a.tIn0) as Hora,
                   extract(minute from a.tIn0) as Minuto,
                   count(*),
                   avg((a.nTopIni+a.nTopFin)/2)

              from SysJobs a
             where a.lExc = 0
               and a.iVer = a.iVAt
               $sQry

             group by
                   cast (a.tIn0 as date),
                   extract(year   from a.tIn0),
                   extract(month  from a.tIn0),
                   extract(day    from a.tIn0),
                   extract(hour   from a.tIn0),
                   extract(minute from a.tIn0)
                   
             order by
                   extract(year   from a.tIn0),
                   extract(month  from a.tIn0),
                   extract(day    from a.tIn0),
                   extract(hour   from a.tIn0),
                   extract(minute from a.tIn0)
                   ";

$aDb    = faDbSelect($hDb,$sSql);

if (count($aDb)) {
   $aComp = array();
   $aAVG  = array();
//   $sAVG  = '';
//   $sProc = '';
   foreach ($aDb as $aLin) {
      $aComp[] = array('',$aLin[6],$aLin[7]);
      $aAVG[]  = array('',$aLin[7]);
//      $sAVG    .= $aLin[7].'<br>';
//      $sProc   .= $aLin[8].'<br>';
   }

   $plot = new PHPlot(1300, 550,'Sys_GerarGrafico_Comp.png');
   
   $plot->SetIsInline(true);
   $plot->SetTitle('Grfico COUNT - AVG');
   $plot->SetDataValues($aComp);
   $plot->SetLegend(array('Count','AVG'));
   $plot->SetLegendPixels(30, 0); // Move legend to upper left
   $plot->SetPlotType('lines');
   $plot->SetDataColors(array('blue','red'));
   $plot->DrawGraph();

   $plot = new PHPlot(1300, 550,'Sys_GerarGrafico_AVG.png');
   
   $plot->SetIsInline(true);
   $plot->SetTitle('Grfico AVG');
   $plot->SetDataValues($aAVG);
   $plot->SetLegend('AVG');
   $plot->SetLegendPixels(40, 0); // Move legend to upper left
   $plot->SetPlotType('lines');
   $plot->SetDataColors('green');
   $plot->DrawGraph();

   if (file_exists('Sys_GerarGrafico_Comp.png') && file_exists('Sys_GerarGrafico_AVG.png')) {
      if ($_SERVER['SERVER_ADDR'] == '187.45.234.236') {
         $sTit .= 'Servidor VELHO';
      } else if ($_SERVER['SERVER_ADDR'] == '177.153.5.216' ) {
         $sTit .= 'Servidor NOVO';
      } else {
         $sTit .= 'Servidor DESCONHECIDO';
      }
      echo "<center>$sTit</center>
               <table>
                  <tr>
                     <td>
                        <img src=Sys_GerarGrafico_Comp.png />
                     </td>
                  </tr>
                  <tr>
                     <td>
                        <img src=Sys_GerarGrafico_AVG.png />
                     </td>
                  </tr>
               </table>
           ";
      $html = ob_get_clean();
      // pega o conteudo do buffer, insere na variavel e limpa a memria
   
      $html = utf8_encode($html);
      // converte o conteudo para uft-8
   
      define('MPDF_PATH', '/qtux/library/mpdf53/');
      include(MPDF_PATH.'mpdf.php');
      // inclui a classe
   
      $mpdf = new mPDF('pt','A4',9,'',8,8,5,14,9,9,'P');
      //$mpdf = new mPDF();
      // cria o objeto
   
         $mpdf->allow_charset_conversion=true;
      // permite a conversao (opcional)
      $mpdf->charset_in='UTF-8';
      // converte todo o PDF para utf-8
      
      $mpdf->WriteHTML($html);
      // escreve definitivamente o conteudo no PDF
      
      $mpdf->Output('/qtux/library/temp/Grafico_'.date("d-m-Y").'.pdf','D');

   } else {
      echo 'No encontrou a imagem';
   }
} else {
  echo 'Sem dados para mostrar';
}
?>