<?php
set_time_limit(300); 
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");
require_once('/qtux/library/phplot-6.1.0/phplot.php');

$sDSN  = "/qtux/database/gps_producao/gps_01.gdb";

$hDb = fhDbConnect($sDSN);
$sSql    = "select cast (a.tIn0 as date)       as Data,
                   extract(year   from a.tIn0) as Ano,
                   extract(month  from a.tIn0) as Mes,
                   extract(day    from a.tIn0) as Dia,
                   extract(hour   from a.tIn0) as Hora,
                   extract(minute from a.tIn0) as Minuto,
                   count(*),
                   avg((a.nTopIni+a.nTopFin)/2)

              from SysJobs a
             where a.lExc    = 0
               and a.iVer  = a.iVAt
               and cast (a.tIn0 as date) >=  '01/Jun/2014'

             group by
                   cast (a.tIn0 as date),
                   extract(year   from a.tIn0),
                   extract(month  from a.tIn0),
                   extract(day    from a.tIn0),
                   extract(hour   from a.tIn0),
                   extract(minute from a.tIn0)
             order by
                   extract(year   from a.tIn0) ,
                   extract(month  from a.tIn0) ,
                   extract(day    from a.tIn0) ,
                   extract(hour   from a.tIn0) ,
                   extract(minute from a.tIn0)";
/*
$sSql    = "select cast (a.tIn0 as date)       as Data,
                   extract(year   from a.tIn0) as Ano,
                   extract(month  from a.tIn0) as Mes,
                   extract(day    from a.tIn0) as Dia,
                   extract(hour   from a.tIn0) as Hora,
                   0,
                   count(*)/60,
                   avg((a.nTopIni+a.nTopFin)/2)

              from SysJobs a
             where a.lExc    = 0
               and a.iVer  = a.iVAt

             group by
                   cast (a.tIn0 as date),
                   extract(year   from a.tIn0),
                   extract(month  from a.tIn0),
                   extract(day    from a.tIn0),
                   extract(hour   from a.tIn0)
             order by
                   extract(year   from a.tIn0) ,
                   extract(month  from a.tIn0) ,
                   extract(day    from a.tIn0) ,
                   extract(hour   from a.tIn0) ";

*/

$aDb    = faDbSelect($hDb,$sSql);

$aCount = array();
$aAVG = array();
foreach ($aDb as $aLin) {
   $aCount[] = array($aLin[4],$aLin[6],$aLin[7]);
   $aAVG[] = array('',$aLin[7]);
}

$plot = new PHPlot(1300, 550);
$plot->SetTitle('Grfico COUNT - AVG');
$plot->SetDataValues($aCount);
$plot->SetLegend(array('Count','AVG'));
$plot->SetLegendPixels(30, 30); // Move legend to upper left
$plot->SetPlotType('lines');
$plot->SetDataColors(array('blue', 'red'));
$plot->DrawGraph();

?>