<?php
/*

Critrios para cada status da Requisio

1) Para aprovar   -> no pode estar aprovada nem cancelada
2) Para alocar    -> tem que estar aprovada e no confirmada, pode j estar pre-alocada, no cancelada
3) Para desalocar -> tem que estar aprovada e no confirmada, desalocar os que tiverem alocados, no cancelada
4) Para confirmar -> tem que estar aprovada e no confirmada, pelo menos 1 deve estar alocado, no cancelada
5) Para enviar    -> tem que estar aprovada, confirmada, no enviada e no cancelada
6) Para receber   -> tem que estar aprovada, confirmada, enviada, no recebida e no cancelada
7) Para cancelar  -> tem que estar no cancelada, no recebida, se alocada desalocar

cancelar desde antes do aprovar
cancelar desde o aprovar
cancelar desde o alocar
cancelar desde o confirmar
cancelar desde o enviar
cancelar desde recebido -> no existe  uma devoluo
                           se o receptor no quer receber, ento a requisio no ser entregue/recebida

--

Saldo em transito

Aps aprovado no altera mais dados da ficha.
Aps confirmado no altera mais dados dos suprimentos pedidos
Qq lcmto que fizer o saldo <0 tem que retornar falso

--

Todas as mensagens relacionadas

   Essa Requisio foi cancelada
   Essa Requisio j foi cancelada

   Essa Requisio j foi confirmada
   Essa Requisio no foi confirmada

   Essa Requisio no foi alocada

   Essa Requisio j foi aprovada
   Essa Requisio no foi aprovada

   Essa Requisio j foi enviada
   Essa Requisio no foi enviada

   Essa Requisio j foi recebida

   p0 = a
   p1 = Requisio
   p2 = {'', j, no}
   p3 = {cancelada, confirmada, alocada, aprovada, enviada, recebida}

   Ess[p0] [p1] [p2] foi [p3] 


*/

set_time_limit(300);
require_once("../pFuncoes1.php");
//require_once('../nusoap-0.7/nusoap.php'); nao estou usando o soap

$psId    = $_GET["sId"];
$sDSN    = $_GET["sDSN"];
$sPathFS = $_GET["sPathFS"];
$psLogin  = $_GET["sLogin"];
$sOpt    = $_GET["sOpt"]; // Checar as permisses de acesso
$sRoot   = $_GET["sRoot"];
//
$hDb     = fhDbConnect($sDSN);
if (flExec($hDb,$psLogin,$sOpt,$sRoot)==false) echo 'Sem permisso';
else {

   $lOk     = false;
   $sSql    = "select a.tCanc,a.tConf from RSup a where a.pPId=$psId and a.iVer=a.iVAt";
   $aDb     = faDBSelect($hDb,$sSql);
   $tCanc   = $aDb[0][0];
   $tConf   = $aDb[0][1];
   
   if (!empty($tCanc)) {          // foi cancelada
      echo 'Essa Requisio foi cancelada';
   } else if (!empty($tConf)) {   // ja foi confirmada
      echo 'Essa Requisio j foi confirmada';
   } else {
      $sTab = 'RSup';
      $aCpo = array('tConf','pConf');
      $sUpd = "update $sTab set iVAt=iVAt+1 where pPId=$psId ";
      $lOk  = flDbUpdate($hDb,$sUpd);
      if ($lOk==true) {
         $sIns = "insert into $sTab select * from $sTab where pPId=$psId and iVer+1=iVAt";
         $lOk  = flDbInsert($hDb,$sIns);
      }
      if ($lOk==true) {
         $sUpd = "update $sTab set $aCpo[0]='now',$aCpo[1]=$psLogin where pPId=$psId and iVer=iVAt";
         $lOk  = flDbUpdate($hDb,$sUpd);
      }
   
      if ($lOk==true) {
         flDbCommit($hDb);
         echo 1;
      } else {
         flDbRollBack($hDb);
         echo 0;
      }
   }

}
flDbDisconnect($hDb);
?>