<html>
<head>
<title>NeuroCosmic</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<script>
var global_jTipo      = 1;   // [0]-Zodado, [1]-Carta Cosmolgica
var global_jStatus    = 1;   // [0]-parar, [1]-avanar 1 dia, [-1]-voltar 1 dia
var global_iMapaPasso = 0;   // toda de 4 passos, 0 at 3
var global_iLat = 0;
var global_iLon = 0;
var global_iFHr = 0;
var iAnoEln = 1960;
var iEfeEln = 10;

var iXM       = 250;
var iYM       = 250;
var iTotEl    = 12
var iROrb     = 180;
var iEsp      = 25;
var iRInt     = 50;
var nStepAng  = 2 * Math.PI / iTotEl;
var iRSun     = 10;
var iOrbSun   = 140;
var iRPolos   = 15;
var aSem      = ['Dom','Seg','Ter','Qua','Qui','Sex','Sab'];
var aElZod    = [4,6,1,7,0,2,9,11,8,10,5,3];   // iRelogio-1
//                0         1         2         3         4         5         6         7         8          9        10        11
//                1         2         3         4         5         6         7         8         9         10        11        12
//                Preto     Branco    Amarelo   Prata     Dourado   Rosa      Verde     Celeste   Vermelho  Azul      Marron    Violeta
var aCores    = ['#000000','#eeeeee','#ffff00','#cccccc','#DBA901','#FF00FF','#00FF00','#2E9AFE','#FF0000','#0000ff','#A0522D','#8B008B'];
// em ordem do relgio

var aSigColor = ["<spam style='background-color:"+aCores[ 5-1]+"'>&nbsp;&nbsp;&nbsp;</spam>",
                 "<spam style='background-color:"+aCores[ 7-1]+"'>&nbsp;&nbsp;&nbsp;</spam>",
                 "<spam style='background-color:"+aCores[ 2-1]+"'>&nbsp;&nbsp;&nbsp;</spam>",
                 "<spam style='background-color:"+aCores[ 8-1]+"'>&nbsp;&nbsp;&nbsp;</spam>",
                 "<spam style='background-color:"+aCores[ 1-1]+"'>&nbsp;&nbsp;&nbsp;</spam>",
                 "<spam style='background-color:"+aCores[ 3-1]+"'>&nbsp;&nbsp;&nbsp;</spam>",
                 "<spam style='background-color:"+aCores[10-1]+"'>&nbsp;&nbsp;&nbsp;</spam>",
                 "<spam style='background-color:"+aCores[12-1]+"'>&nbsp;&nbsp;&nbsp;</spam>",
                 "<spam style='background-color:"+aCores[ 9-1]+"'>&nbsp;&nbsp;&nbsp;</spam>",
                 "<spam style='background-color:"+aCores[11-1]+"'>&nbsp;&nbsp;&nbsp;</spam>",
                 "<spam style='background-color:"+aCores[ 6-1]+"'>&nbsp;&nbsp;&nbsp;</spam>",
                 "<spam style='background-color:"+aCores[ 4-1]+"'>&nbsp;&nbsp;&nbsp;</spam>"];

// ordem do zodiaco
var aSZod     = ['AR','TA','GE','CN','LE','VI','LI','SC','SA','CP','AQ','PI'];
var aSZodOpos = ['LI','SC','SA','CP','AQ','PI','AR','TA','GE','CN','LE','VI'];

var aZodEle   = [0,1,3,2,0,1,3,2,0,1,3,2];   // 0-fogo, 1-terra, 2-gua, 3-ar   - parelhado com aSZod
var iPing     = 0

if (global_jTipo==0) var nAngI = Math.PI*(4/2);
else                 var nAngI = Math.PI*(2/3-1/4);   // carta cosmologica
var nDAng     =  2 * Math.PI / iTotEl;
var nDAng10   =  nDAng/3;   // 10 graus

var tDataBase = new Date();
//console.log('tDataBase='+tDataBase);
var iDataAno;
var iDataMes;
var iDataDia;
var sDataMes;
var sDataDia;
var iDataHor;
var iDataMin;
var sDataHor;
var sDataMin;
var sDataSeg  = '00';

var tDataProx = new Date();

var iTotPla = 11;
var aPla3  = new Array();   // est na ordem que chega das efemrides
aPla3.push('sun');   //  0 - fogo
aPla3.push('moo');   //  1 - gua
aPla3.push('mer');   //  2 - terra
aPla3.push('ven');   //  3 - gua
aPla3.push('mar');   //  4 - fogo
aPla3.push('jup');   //  5 - terra
aPla3.push('sat');   //  6 - ar
aPla3.push('ura');   //  7 - ar
aPla3.push('nep');   //  8 - gua
aPla3.push('plu');   //  9 - fogo
aPla3.push('eln');   // 10 - ar   ---> iEfeEln
aPla3.push('ter');   // 11 - terra

var aPlaZod = new Array();   // ordem do das efemrides -> iRelgio-1 
aPlaZod.push(4);   //  0-sol - dourado   5
aPlaZod.push(11);  //  1-lua - violeta  12
aPlaZod.push(2);   //  2-mer - amarelo   3
aPlaZod.push(7);   //  3-ven - celeste   8
aPlaZod.push(8);   //  4-mar - vermelho  9
aPlaZod.push(6);   //  5-jup - verde     7
aPlaZod.push(5);   //  6-sat - rosa      6
aPlaZod.push(1);   //  7-ura - branco    2
aPlaZod.push(3);   //  8-net - prata     4
aPlaZod.push(0);   //  9-plu - preto     1
aPlaZod.push(9);   // 10-eln - azul     10
aPlaZod.push(10);  // 11-ter - marron   11

var aEf = new Array();
var iMinToSeg = 60;
var iHorToSeg = 60*iMinToSeg;
var iDiaToSeg = 24*iHorToSeg;
//console.log('iHorToSeg='+iHorToSeg+', iDiaToSeg='+iDiaToSeg);

var aPoloX = new Array();
var aPoloY = new Array();
var aPolo  = new Array();
for (var i=0; i<iTotEl; i++) aPolo[i]=-1;

var iFogo  = 0;
var iTerra = 1;
var iAgua  = 2;
var iAr    = 3;

var aIrmaos = new Array();   // ndice de Efemrides
aIrmaos.push([9,0,4 ]);      // 0-fogo em ordem dos atmicos
aIrmaos.push([2,5,11]);      // 1-terra  -- idem --
aIrmaos.push([1,3,8 ]);      // 2-gua   -- idem --
aIrmaos.push([7,6,10]);      // 3-ar     -- idem --

var aPosicao = new Array(); // ndice Relogio contendo ndice de Efemrides
aPosicao.push(-1);   //  0
aPosicao.push(-1);   //  1
aPosicao.push(-1);   //  2
aPosicao.push(-1);   //  3
aPosicao.push(-1);   //  4
aPosicao.push(-1);   //  5
aPosicao.push(-1);   //  6
aPosicao.push(-1);   //  7
aPosicao.push(-1);   //  8
aPosicao.push(-1);   //  9
aPosicao.push(-1);   // 10
aPosicao.push(-1);   // 11

var aConexao = new Array(); // ndice Relogio contendo ndice de Efemrides
aConexao.push(-1);   //  0
aConexao.push(-1);   //  1
aConexao.push(-1);   //  2
aConexao.push(-1);   //  3
aConexao.push(-1);   //  4
aConexao.push(-1);   //  5
aConexao.push(-1);   //  6
aConexao.push(-1);   //  7
aConexao.push(-1);   //  8
aConexao.push(-1);   //  9
aConexao.push(-1);   // 10
aConexao.push(-1);   // 11

aFasesHr  = [9,-9,-9,9];
aFases    = ['nova','crescente','cheia','minguante'];
aFasePNG  = ['lua_nova.png','lua_crescente_1.png','lua_crescente_2.png','lua_crescente_3.png','lua_cheia.png','lua_minguante_1.png','lua_minguante_2.png','lua_minguante_3.png'];
sPathPNG  = 'imagens/';
aFasesSeg = new Array();

aChacra  = ['Ori','Coracao','Percepcao','Centro'];

aEfe = new Array();
aEfe.push([-1,-1,-1]);   // ori - atomico, ativo,passivo
aEfe.push([-1,-1,-1]);   // cor - atomico, ativo,passivo
aEfe.push([-1,-1,-1]);   // per - atomico, ativo,passivo
aEfe.push([-1,-1,-1]);   // cen - atomico, ativo,passivo

aEf21 = new Array();
aEf21.push(['','','']);   // ori - atomico, ativo,passivo
aEf21.push(['','','']);   // cor - atomico, ativo,passivo
aEf21.push(['','','']);   // per - atomico, ativo,passivo
aEf21.push(['','','']);   // cen - atomico, ativo,passivo

aCoresDiasSem = new Array();                  // contedo iRelogio-1
//                   d  2  3  4  5  6  s
aCoresDiasSem.push([11, 2, 7, 4, 8, 6, 5]);   // 1a hr nascer sol - fogo - d,2,3,4,5,6,s     [ 0]
aCoresDiasSem.push([ 5,11, 2, 7, 1, 8, 6]);   // 2a hr                                       [ 1]
aCoresDiasSem.push([ 6, 5, 3, 2, 7, 4, 8]);   // 3a hr                                       [ 2]
aCoresDiasSem.push([ 8, 6, 5,11, 0, 7, 4]);   // ...                                         [ 3]
aCoresDiasSem.push([ 1, 8, 6, 5, 3, 0, 7]);   //                                             [ 4]
aCoresDiasSem.push([ 7, 4, 8, 6, 5,11, 2]);   //                                             [ 5]
                                                                                            
aCoresDiasSem.push([ 2, 7, 4, 8, 6, 5, 3]);   // meio dia - terra - d,2,3,4,5,6,s            [ 6]
aCoresDiasSem.push([ 3, 0, 7, 4, 8, 6, 5]);   //                                             [ 7]
aCoresDiasSem.push([ 5, 3, 2, 7, 4, 8, 6]);   //                                             [ 8]
aCoresDiasSem.push([ 6, 5,11, 0, 7, 1, 8]);   //                                             [ 9]
aCoresDiasSem.push([ 8, 6, 5, 3, 2, 7, 1]);   //                                             [10]
aCoresDiasSem.push([ 4, 8, 6, 5,11, 2, 7]);   //                                             [11]
                                                                                            
aCoresDiasSem.push([ 7, 1, 8, 6, 5, 3, 2]);   // por sol - agua - d,2,3,4,5,6,s              [12]
aCoresDiasSem.push([ 2, 7, 4, 8, 6, 5,11]);   //                                             [13]
aCoresDiasSem.push([11, 2, 7, 4, 8, 6, 5]);   //                                             [14]
aCoresDiasSem.push([ 5, 3, 2, 7, 4, 8, 6]);   //                                             [15]
aCoresDiasSem.push([ 6, 5, 3, 0, 7, 4, 8]);   //                                             [23]
aCoresDiasSem.push([ 8, 6, 5,11, 2, 7, 3]);   //                                             [16]
                                                                                            
aCoresDiasSem.push([ 4, 8, 6, 5,11, 2, 7]);   // meia noite - ar - d,2,3,4,5,6,s             [17]
aCoresDiasSem.push([ 7, 4, 8, 6, 5,11, 0]);   //                                             [18]
aCoresDiasSem.push([ 2, 7, 1, 8, 6, 5, 3]);   //                                             [19]
aCoresDiasSem.push([ 3, 0, 7, 1, 8, 6, 5]);   //                                             [20]
aCoresDiasSem.push([ 5,11, 0, 7, 4, 8, 6]);   //                                             [21]
aCoresDiasSem.push([ 6, 5,11, 2, 7, 4, 8]);   //                                             [23]


aTabHrsCores  = new Array();
//fogo               Jan     Fev     Mar     Abr     Mai     Jun     Jul     Ago     Set     Out     Nov     Dez
aTabHrsCores.push(['05:25','05:46','06:03','06:16','06:28','06:42','06:50','06:43','06:19','05:48','05:22','05:12']);  //  0   // incio do dia - nascer do sol
aTabHrsCores.push(['06:31','06:49','07:03','07:14','07:24','07:36','07:42','07:37','07:17','06:51','06:29','06:21']);  //  1
aTabHrsCores.push(['07:38','07:53','08:04','08:13','08:21','08:30','08:35','08:31','08:15','07:54','07:37','07:30']);  //  2
aTabHrsCores.push(['08:45','08:56','09:05','09:11','09:17','09:24','09:28','09:25','09:13','08:57','08:44','08:39']);  //  3
aTabHrsCores.push(['09:52','10:00','10:05','10:10','10:14','10:18','10:21','10:19','10:11','10:00','10:52','10:48']);  //  4
aTabHrsCores.push(['10:59','11:03','11:06','11:08','11:10','11:12','11:14','11:13','11:09','11:03','11:59','11:57']);  //  5

//terra
aTabHrsCores.push(['12:01','12:01','12:01','12:01','12:01','12:01','12:01','12:01','12:01','12:01','12:01','12:01']);  //  6
aTabHrsCores.push(['13:11','13:11','13:08','13:03','12:58','12:56','12:57','12:59','13:01','13:02','13:05','13:08']);  //  7
aTabHrsCores.push(['14:22','14:21','14:15','14:05','13:56','13:52','13:53','13:57','14:01','14:04','14:09','14:16']);  //  8
aTabHrsCores.push(['15:32','15:31','15:22','15:07','14:54','14:48','14:49','14:56','15:02','15:06','15:14','15:24']);  //  9
aTabHrsCores.push(['16:42','16:41','16:29','16:14','15:01','15:55','15:56','15:03','16:09','16:13','16:21','16:31']);  // 10
aTabHrsCores.push(['17:53','17:51','17:36','17:11','16:49','16:39','16:41','16:52','17:02','17:10','17:22','17:39']);  // 11

//agua
aTabHrsCores.push(['18:58','18:56','18:37','18:07','17:41','17:29','17:32','17:45','18:57','18:06','18:21','18:41']);  // 12   // incio da noite - por do sol
aTabHrsCores.push(['19:49','19:47','19:32','19:07','18:45','18:35','18:37','18:48','19:58','19:06','19:18','19:35']);  // 13
aTabHrsCores.push(['20:41','20:39','20:27','20:07','19:49','19:41','19:43','19:52','20:00','20:06','20:16','20:29']);  // 14
aTabHrsCores.push(['21:32','21:31','21:22','21:07','20:54','20:48','20:49','20:56','21:02','21:06','21:14','21:24']);  // 15
aTabHrsCores.push(['22:24','22:23','22:17','22:07','21:58','21:55','21:55','21:59','22:03','22:06','22:11','22:18']);  // 16
aTabHrsCores.push(['23:15','23:15','23:12','23:07','23:02','23:00','23:01','23:03','23:05','23:06','23:09','23:12']);  // 17

//ar
aTabHrsCores.push(['00:01','00:01','00:01','00:01','00:01','00:01','00:01','00:01','00:01','00:01','00:01','00:01']);  // 18
aTabHrsCores.push(['00:55','00:59','01:02','01:04','01:06','01:08','01:10','01:09','01:05','00:59','00:55','00:53']);  // 19
aTabHrsCores.push(['01:50','01:58','02:03','02:08','02:12','02:16','02:19','02:17','02:09','01:58','01:50','01:46']);  // 20
aTabHrsCores.push(['02:45','02:56','03:05','03:11','03:17','03:24','03:28','03:25','03:13','02:57','02:44','02:39']);  // 21
aTabHrsCores.push(['03:40','03:55','04:06','04:15','04:23','04:32','04:37','04:33','04:17','03:56','03:39','03:32']);  // 22
aTabHrsCores.push(['04:35','04:53','05:07','05:18','05:28','05:40','05:46','05:41','05:21','04:55','04:33','04:25']);  // 23

aPoloSt = [0,0,0,0,0,0,0,0,0,0,0,0];   // 0-baixo, 1-cima
aPoloGr = [0,0,0,0,0,0,0,0,0,0,0,0];
aPoloCr = ['','','','','','','','','','','',''];

aDetalhes = new Array();
aDetalhes.push(['','','','']);   //  0-chacra -> 0-Ori, 1-Corao, 2-Percepo, 3-Centro
aDetalhes.push(['','','','']);   //  1-DataHora
aDetalhes.push(['','','','']);   //  2-Fase Lua
aDetalhes.push(['','','','']);   //  3-Sol 
aDetalhes.push(['','','','']);   //  4-Pla1 
aDetalhes.push(['','','','']);   //  5-Pos1
aDetalhes.push(['','','','']);   //  6-P121
aDetalhes.push(['','','','']);   //  7-Pos121
aDetalhes.push(['','','','']);   //  8-Pla2
aDetalhes.push(['','','','']);   //  9-Pos2
aDetalhes.push(['','','','']);   // 10-P221
aDetalhes.push(['','','','']);   // 11-Pos221
aDetalhes.push(['','','','']);   // 12-Pla3
aDetalhes.push(['','','','']);   // 13-Pos3
aDetalhes.push(['','','','']);   // 14-P321
aDetalhes.push(['','','','']);   // 15-Pos321
aDetalhes.push(['','','','']);   // 16-Lat
aDetalhes.push(['','','','']);   // 17-Long
aDetalhes.push(['','','','']);   // 18-Fuso

aDetalhes.push(['','','','']);   // 19-Setas Atmicos
aDetalhes.push(['','','','']);   // 20-Setas Ativos
aDetalhes.push(['','','','']);   // 21-Setas Passivos

/*
iRel        iZod            iEfe
----------------------------------
 1-Plu[0]   Ar-Sol[0]       Dta[.]  
 2-Ura[1]   Ta-Jup[1]       Sol[0]   
 3-Mer[2]   Gm-Ura[2]       Lua[1] 
 4-Net[3]   Ca-Ven[3]       Mer[2] 
 5-Sol[4]   Le-Plu[4]       Ven[3] 
 6-Sat[5]   Vg-Mer[5]       Mar[4] 
 7-Jup[6]   Li-Eln[6]       Jup[5] 
 8-Ven[7]   Sc-Lua[7]       Sat[6] 
 9-Mar[8]   Sa-Mar[8]       Ura[7] 
10-Eln[9]   Cp-Ter[9]       Net[8] 
11-Ter[10]  Aq-Sat[10]      Plu[9]
12-Lua[11]  Pi-Net[11]      Eln[10]
*/

function fiRelToZod(pi) {return aElZod.indexOf(pi);}
function fiZodToRel(pi) {return aElZod[pi];}

function fiEfeToRel(pi) {return aPlaZod[pi];}
function fiRelToEfe(pi) {return aPlaZod.indexOf(pi);}

function fiZodToEfe(pi) {return fiRelToEfe(fiZodToRel(pi));}
function fiEfeToZod(pi) {return fiRelToZod(fiEfeToRel(pi));}
   
function flOnLoad() {
/////////////////////
   var svg = document.getElementById('GrafoSvg');

   // Circulo zodiaco
   nAngI0 = nAngI;
   nDAng0 = nDAng;
   for (var i=0; i<iTotEl; i++) {
      if (global_jTipo==1) {

         nAngI=nAngI0;
         nDAng=nDAng0;
         nDAn2=nDAng0;

         if ((i==0)||(i==1)){
            nAngI-=nDAng10;
            nDAng-=nDAng10;
            nDAn2 =nDAng;
         }

         if ((i==3)||(i==4)){
            nAngI-=4*nDAng10;
            nDAng-=nDAng10;
            nDAn2 =nDAng;
         }

         if ((i==6)||(i==7)){
            nAngI-=7*nDAng10;
            nDAng-=nDAng10;
            nDAn2 =nDAng;
         }

         if ((i==9)||(i==10)){
            nAngI-=10*nDAng10;
            nDAng-=nDAng10;
            nDAn2 =nDAng;
         }

         if (i==2){
            nAngI-=nDAng10;
            nDAng-=nDAng10;
            nDAn2 =Number(nDAng+nDAng10);
         }

         if (i==5){
            nAngI-=4*nDAng10;
            nDAng-=nDAng10;
            nDAn2 =Number(nDAng+nDAng10/2);
         }
         if (i==8){
            nAngI-=7*nDAng10;
            nDAng-=nDAng10;
            nDAn2 =Number(nDAng+nDAng10/3);
         }

         if (i==11){
            nAngI-=10*nDAng10;
            nDAng-=nDAng10;
            nDAn2 =Number(nDAng+nDAng10/4);
         }

      } else nDAn2=nDAng;
      var iXi    = Number(iXM+iROrb*Math.cos(nAngI-i*nDAng)).toFixed(5);
      var iYi    = Number(iYM-iROrb*Math.sin(nAngI-i*nDAng)).toFixed(5);
      var iXf    = Number(iXM+iROrb*Math.cos(nAngI-Number(i+1)*nDAn2)).toFixed(5);
      var iYf    = Number(iYM-iROrb*Math.sin(nAngI-Number(i+1)*nDAn2)).toFixed(5);
      var oArc   = document.createElementNS("http://www.w3.org/2000/svg", 'path');
      var sPars  = "M"+iXi+" "+iYi+" A "+iROrb+" "+iROrb+" 0 0 1 "+iXf+" "+iYf;
      oArc.setAttribute('d',sPars);

      if (global_jTipo==0) oArc.setAttribute('stroke',aCores[fiZodToRel(i)]);
      else                 oArc.setAttribute('stroke',aCores[i]);   // carta cosmologica

      oArc.setAttribute('stroke-width',iEsp);
      oArc.setAttribute('fill','none');
      svg.appendChild(oArc);
      //console.log('i='+i+', iXi='+iXi+', iYi='+iYi+', iXf='+iXf+', iYf='+iYf+', id='+'A'+(i+1));


      // Dados dos Polos
      // ---------------

      // Graus
      var iCXLocal = Number(iXM+(iROrb+iEsp)*Math.cos(nAngI-i*nDAng));
      var iCYLocal = Number(iYM-(iROrb+iEsp)*Math.sin(nAngI-i*nDAng));
      if (i< 6) iCXLocal+=18;
      if (i>=6) iCXLocal-=36;
      if ((i>=3) && (i<9)) iCYLocal+=5

      // Retangulo dos Graus
      var rectPolo = document.createElementNS("http://www.w3.org/2000/svg", "rect");
      rectPolo.setAttribute('x',iCXLocal);
      rectPolo.setAttribute('y',iCYLocal-12);
      rectPolo.setAttribute('width' ,16);
      rectPolo.setAttribute('height',16);
      rectPolo.setAttribute('style', "stroke:#000000; stroke-width: 1; fill:#ffffff;");
      if (global_jTipo==0) rectPolo.setAttribute('style', "display:none;");
      rectPolo.id = 'polo_rect_'+i;
      svg.appendChild(rectPolo);
    
      // Text dos Graus
      var textPolo = document.createElementNS("http://www.w3.org/2000/svg", "text");
      textPolo.setAttribute('x',Number(iCXLocal+2));
      textPolo.setAttribute('y',iCYLocal);
      textPolo.setAttribute('style', 'fill:#000000;');
      textPolo.setAttribute('font-size',12);
      if (global_jTipo==0) textPolo.setAttribute('style', "display:none;");
      textPolo.id = 'polo_txt_'+i;
      textPolo.textContent = '...';
      svg.appendChild(textPolo);

      // Setas Parte 1/5 - Corpo Vertical
      var iCXI = Number(iCXLocal + ((i<6) ? +25 : -10));
      var iCYI = Number(iCYLocal-12);
      var iCXF = Number(iCXLocal + ((i<6) ? +25 : -10));
      var iCYF = Number(iCYLocal+5);
      var setaPolo1 = document.createElementNS("http://www.w3.org/2000/svg", "line");
      setaPolo1.setAttribute('x1',iCXI);
      setaPolo1.setAttribute('y1',iCYI);
      setaPolo1.setAttribute('x2',iCXF);
      setaPolo1.setAttribute('y2',iCYF);
      setaPolo1.setAttribute('stroke-width','0.5');
      setaPolo1.setAttribute('stroke','#000000');
      setaPolo1.setAttribute('style', "display:none;");
      setaPolo1.id = 'polo_Seta1_'+i;
      svg.appendChild(setaPolo1);

      // Setas Parte 2/5 - Seta Cima Direita
      var iCXI = Number(iCXLocal + ((i<6) ? +25 : -10));
      var iCYI = Number(iCYLocal-12);
      var iCXF = Number(iCXLocal + ((i<6) ? +30 : -5 ));
      var iCYF = Number(iCYLocal-7);
      var setaPolo2 = document.createElementNS("http://www.w3.org/2000/svg", "line");
      setaPolo2.setAttribute('x1',iCXI);
      setaPolo2.setAttribute('y1',iCYI);
      setaPolo2.setAttribute('x2',iCXF);
      setaPolo2.setAttribute('y2',iCYF);
      setaPolo2.setAttribute('stroke-width','0.5');
      setaPolo2.setAttribute('stroke','#000000');
      setaPolo2.setAttribute('style', "display:none;");
      setaPolo2.id = 'polo_Seta2_'+i;
      svg.appendChild(setaPolo2);

      // Setas Parte 3/5 - Seta Cima Esquerda
      var iCXI = Number(iCXLocal + ((i<6) ? +25 : -10));
      var iCYI = Number(iCYLocal-12);
      var iCXF = Number(iCXLocal + ((i<6) ? +20 : -15));
      var iCYF = Number(iCYLocal-7);
      var setaPolo3 = document.createElementNS("http://www.w3.org/2000/svg", "line");
      setaPolo3.setAttribute('x1',iCXI);
      setaPolo3.setAttribute('y1',iCYI);
      setaPolo3.setAttribute('x2',iCXF);
      setaPolo3.setAttribute('y2',iCYF);
      setaPolo3.setAttribute('stroke-width','0.5');
      setaPolo3.setAttribute('stroke','#000000');
      setaPolo3.setAttribute('style', "display:none;");
      setaPolo3.id = 'polo_Seta3_'+i;
      svg.appendChild(setaPolo3);

      // Setas Parte 4/5 - Seta Baixo Direita
      var iCXI = Number(iCXLocal + ((i<6) ? +30 : -5 ));
      var iCYI = Number(iCYLocal);
      var iCXF = Number(iCXLocal + ((i<6) ? +25 : -10));
      var iCYF = Number(iCYLocal+5);
      var setaPolo4 = document.createElementNS("http://www.w3.org/2000/svg", "line");
      setaPolo4.setAttribute('x1',iCXI);
      setaPolo4.setAttribute('y1',iCYI);
      setaPolo4.setAttribute('x2',iCXF);
      setaPolo4.setAttribute('y2',iCYF);
      setaPolo4.setAttribute('stroke-width','0.5');
      setaPolo4.setAttribute('stroke','#000000');
      setaPolo4.setAttribute('style', "display:none;");
      setaPolo4.id = 'polo_Seta4_'+i;
      svg.appendChild(setaPolo4);

      // Setas Parte 5/5 - Seta Baixo Esquerda
      var iCXI = Number(iCXLocal + ((i<6) ? +20 : -15));
      var iCYI = Number(iCYLocal);
      var iCXF = Number(iCXLocal + ((i<6) ? +25 : -10));
      var iCYF = Number(iCYLocal+5);
      var setaPolo5 = document.createElementNS("http://www.w3.org/2000/svg", "line");
      setaPolo5.setAttribute('x1',iCXI);
      setaPolo5.setAttribute('y1',iCYI);
      setaPolo5.setAttribute('x2',iCXF);
      setaPolo5.setAttribute('y2',iCYF);
      setaPolo5.setAttribute('stroke-width','0.5');
      setaPolo5.setAttribute('stroke','#000000');
      setaPolo5.setAttribute('style', "display:none;");
      setaPolo5.id = 'polo_Seta5_'+i;
      svg.appendChild(setaPolo5);

      // Cor - Retangulo
      var iCXLocal = Number(iXM+(iROrb+iEsp)*Math.cos(nAngI-i*nDAng));
      var iCYLocal = Number(iYM-(iROrb+iEsp)*Math.sin(nAngI-i*nDAng));
      if (i>=6) iCXLocal-=18;
      if ((i>=3) && (i<9)) iCYLocal+=5

      var rectCor = document.createElementNS("http://www.w3.org/2000/svg", "rect");
      rectCor.setAttribute('x',iCXLocal);
      rectCor.setAttribute('y',iCYLocal-12);
      rectCor.setAttribute('width' ,16);
      rectCor.setAttribute('height',16);
      rectCor.setAttribute('style', "stroke:#000000; stroke-width: 1; fill:#dddddd;");
      rectCor.setAttribute('font-size',12);
      if (global_jTipo==0) rectCor.setAttribute('style', "display:none;");
      rectCor.id = 'cor_rect_'+i;
      svg.appendChild(rectCor);

   }   // for (var i=0; i<iTotEl; i++)

   // Circulo da Terra
   var iCXLocal = iXM;
   var iCYLocal = iYM;
   var iRLocal  = iRInt;
   var circle = document.createElementNS("http://www.w3.org/2000/svg", "circle");
   circle.setAttribute('cx', iCXLocal);
   circle.setAttribute('cy', iCYLocal);
   circle.setAttribute('r' , iRLocal);
   circle.setAttribute('style', "stroke:"+aCores[11-1]+"; fill:"+aCores[11-1]+";");
   if (global_jTipo==1) circle.setAttribute('style', "display:none;");
   circle.id = "circle_int";
   svg.appendChild(circle);

   // Message box
   var iL = 75;
   var iH = 20;
   var iCXLocal = iXM;
   var iCYLocal = iYM;

   // Data da Terra
   var text = document.createElementNS("http://www.w3.org/2000/svg", "text");
   text.setAttribute('x',Number(iCXLocal-iL/2-5));
   text.setAttribute('y',Number(iCYLocal+iH/4));
   text.setAttribute('style', "fill:#ffffff;");
   text.setAttribute('font-size',12);
   if (global_jTipo==1) text.setAttribute('style', "display:none;");
   text.id = 'central_txt';
   text.textContent = '...';
   svg.appendChild(text);

   // Planetas
   for (var i=0; i<iTotPla; i++) {
      var oCircle = document.createElementNS("http://www.w3.org/2000/svg", "circle");
      oCircle.setAttribute('cx', Number(iXM+iOrbSun));
      oCircle.setAttribute('cy', iYM);
      oCircle.setAttribute('r' , (i==0 ? iRSun : iRSun/2));
      oCircle.setAttribute('style', 'stroke:'+aCores[aPlaZod[i]]+'; fill:'+aCores[aPlaZod[i]]+';');
      if (global_jTipo==1) oCircle.setAttribute('style', "display:none;");
      oCircle.id = aPla3[i];
      svg.appendChild(oCircle);
   }

   // Polos
   if (global_jTipo==1) {   // carta cosmolgica
      for (var i=0; i<iTotEl; i++) {
         var iAng = 30*i-60;
         if ((i==1)||(i==3)||(i==7)||(i==9))  iAng-=10;
         if ((i==2)||(i==4)||(i==8)||(i==10)) iAng-=20;
         if ((i==5)||(i==11))                 iAng-=30;

         if (i==0) iAng-=4;
         if (i==1) iAng-=2;

         if (i==4) iAng+=2;
         if (i==5) iAng+=4;

         if (i==6) iAng-=8;
         if (i==7) iAng-=6;
         if (i==8) iAng-=2;

         if (i==10) iAng+=2;
         if (i==11) iAng+=4;

         var iRad = iAng*Math.PI / 180;
         var iCXLocal = Number(iOrbSun * Math.cos(iRad) + iXM);
         var iCYLocal = Number(iOrbSun * Math.sin(iRad) + iYM);
         aPoloX.push(iCXLocal);
         aPoloY.push(iCYLocal);
         var oPolo = document.createElementNS("http://www.w3.org/2000/svg", "circle");
         oPolo.setAttribute('cx',iCXLocal);
         oPolo.setAttribute('cy',iCYLocal);
         oPolo.setAttribute('r' , iRPolos);
         oPolo.setAttribute('style', 'stroke:'+aCores[aPlaZod[i]]+'; fill:'+aCores[aPlaZod[i]]+';');
         oPolo.id = 'Polo_'+i;
         svg.appendChild(oPolo);
      }
      var iCXI = Number(iXM-iROrb+iEsp/2);
      var iCYI = Number(iYM);
      var iCXF = Number(iXM+iROrb-iEsp/2);
      var iCYF = Number(iYM);
      var oHor = document.createElementNS("http://www.w3.org/2000/svg", "line");
      oHor.setAttribute('x1',iCXI);
      oHor.setAttribute('y1',iCYI);
      oHor.setAttribute('x2',iCXF);
      oHor.setAttribute('y2',iCYF);
      oHor.setAttribute('stroke-width','0.5');
      oHor.setAttribute('stroke','#000000');
      oHor.id = 'LineH';
      svg.appendChild(oHor);
  
      var iCXI = iXM;
      var iCYI = Number(iYM-iROrb+iEsp/2);
      var iCXF = iXM;
      var iCYF = Number(iYM+iROrb-iEsp/2);
      var oVer = document.createElementNS("http://www.w3.org/2000/svg", "line");
      oVer.setAttribute('x1',iCXI);
      oVer.setAttribute('y1',iCYI);
      oVer.setAttribute('x2',iCXF);
      oVer.setAttribute('y2',iCYF);
      oVer.setAttribute('stroke-width','0.5');
      oVer.setAttribute('stroke','#000000');
      oVer.id = 'LineV';
      svg.appendChild(oVer);
      

   }

   // Curvas
   for (var i=0; i<iTotEl; i++) {
      for (var j=0; j<iTotEl; j++) {
         var oCurve =  document.createElementNS("http://www.w3.org/2000/svg", "path");
         var iPoloI = i;
         var iPoloF = j;
         var iRefX  = aPoloX[iPoloI]<aPoloX[iPoloF] ? aPoloX[iPoloI] : aPoloX[iPoloF]
         var iAncX  = iXM; //(iRefX + Math.abs(aPoloX[iPoloF]-aPoloX[iPoloI]))/2;
         var iAncY  = iYM; //Math.abs(aPoloY[iPoloF]-aPoloY[iPoloI])/2;
         var sCurve = "M" + aPoloX[iPoloI] + " " + aPoloY[iPoloI] + " Q " +  iAncX + " " + iAncY + " " + aPoloX[iPoloF] + " " + aPoloY[iPoloF]; 
         oCurve.setAttribute('d',sCurve);
         oCurve.setAttribute('stroke', aCores[aPlaZod[iPoloI]]);
         oCurve.setAttribute('stroke-width', '0');
         oCurve.setAttribute('fill', 'none');
         oCurve.setAttribute('id', 'Curva ' + iPoloI + 'x' + iPoloF);
         svg.appendChild(oCurve);
      }
   }

   if (global_jTipo==0) {   // zodaco

      document.getElementById('btn_CalcCarta').style.display='none';
      document.getElementById('table_Detalhes').style.display='none';
      document.getElementById('span_DataNas').style.display='none';
      document.getElementById('span_MensNasc').style.display='none';
      document.getElementById('input_Not9Meses').style.display='none';


   } else {                 // carta cosmolgica

      document.getElementById('input_Voltar').style.display='none';
      document.getElementById('input_Parar').style.display='none';    
      document.getElementById('input_Avancar').style.display='none';
      document.getElementById('input_Menos1D').style.display='none';  
      document.getElementById('input_Mais1D').style.display='none';   
      document.getElementById('input_Menos21D').style.display='none'; 
      document.getElementById('input_Mais21D').style.display='none';  
      document.getElementById('input_Menos87D').style.display='none'; 
      document.getElementById('input_Mais87D').style.display='none';  
      document.getElementById('input_Menos1H').style.display='none';  
      document.getElementById('input_Mais1H').style.display='none';   
      document.getElementById('input_Menos9H').style.display='none';  
      document.getElementById('input_Mais9H').style.display='none';   
      document.getElementById('btn_Ir').style.display='none';
      document.getElementById('span_FaseLua').style.display='none';
      document.getElementById('span_FaseLuaPNG').style.display='none';
      document.getElementById('table_graus').style.display='none';
      document.getElementById('table_Detalhes').style.display='none';
      document.getElementById('span_DataCeu').style.display='none';
   }

   document.getElementById('span_DataNasPre').style.display='none';
   document.getElementById('span_SemPre').style.display='none';
   document.getElementById('sel_DiasPre').style.display='none';
   document.getElementById('sel_MesesPre').style.display='none';
   document.getElementById('sel_AnosPre').style.display='none';
   document.getElementById('sel_HorPre').style.display='none';
   document.getElementById('sel_MinPre').style.display='none';
   document.getElementById('span_2PontosB').style.display='none';

   if (global_jTipo==0) flPing();
}

function fiTerToRel(psMes,piSem,psHor,psMin) {   // retorno = iTrueRelgio-1
//////////////////////////////////////////////
   var jMes = psMes*1-1;
   var sHrM = psHor+':'+psMin;
   var l230 = false;
   var sHM0 = aTabHrsCores[0][jMes];
   var iSem = piSem - ((sHrM<sHM0)?1:0);
   for (var i=0; i<24; i++) {
      if (i<23) {
         var sHMI = aTabHrsCores[i][jMes];
         var sHMF = aTabHrsCores[Number(i+1)][jMes];
         //console.log('i='+i+', sHrM='+sHrM+', sHMI='+sHMI+', sHMF='+sHMF);
         if (sHMF < sHMI) {       // isso vai ocorrer na virada da meia noite - [23:mm -> 00:mm]
            l230 = false; 
            if (sHrM >= sHMI) {   // sHrM ainda no virou a meia noite - 23:MM >= 23:mm - nesse caso o sHMF de 00:mm passa a ser 24:mm
               l230 = true;
               var sHMF2 = '24:'+sHMF.substr(3,2);
               var sHrM2 = sHrM;
               //console.log('a) sHMF2='+sHMF2+', sHrM2='+sHrM2);
            } else if (sHrM < sHMF) {              // sHrM j virou a meia noite        - 00:MM <  23:mm - nesse caso o tanto o sHMF qto o sHrM passam a ser 24:mm
               l230 = true;
               var sHMF2 = '24:'+sHMF.substr(3,2);
               var sHrM2 = '24:'+sHrM.substr(3,2);
               //console.log('b) sHMF2='+sHMF2+', sHrM2='+sHrM2);
            }
            if (l230) if ( (sHrM2>=sHMI) && (sHrM2<sHMF2) ) break;
         } else {
            if ( (sHrM>=sHMI) && (sHrM<sHMF) ) {
               break;
            }
         }
      } else break;
   }
//console.log('i='+i+', iSem='+iSem);
   iRel = aCoresDiasSem[i][iSem];
//console.log('psMes='+psMes+', piSem='+piSem+', iSem='+iSem+', psHor='+psHor+', psMin='+psMin+', jMes='+jMes+', sHrM='+sHrM+', iRel='+iRel+', sHM0='+sHM0);
   return (iRel);
}

function flPing() {
///////////////////
//   console.log('flPing');
//   if (global_jStatus!=0) {
      tDataBase.setSeconds(iPing);
      //console.log('flPing-tDataBase='+tDataBase+', iPing='+iPing);
      iDataAno  = tDataBase.getFullYear();    // yyyy
      iDataMes  = Number(tDataBase.getMonth()+1);   // 0-11 -> 1-12   - 1*1  para forar ser um numero
      iDataDia  = tDataBase.getDate();        // 1-31
      iDataHor  = tDataBase.getHours();
      iDataMin  = tDataBase.getMinutes();
      sDataMes  = iDataMes<10 ? '0'+iDataMes : iDataMes;
      sDataDia  = iDataDia<10 ? '0'+iDataDia : iDataDia;
      sDataHor  = iDataHor<10 ? '0'+iDataHor : iDataHor;
      sDataMin  = iDataMin<10 ? '0'+iDataMin : iDataMin;
      sDataBase = iDataAno+'-'+sDataMes+'-'+sDataDia+' '+sDataHor+':'+sDataMin+':'+sDataSeg;
      //console.log('tDataBase='+tDataBase+', iDataAno='+iDataAno+', iDataMes='+iDataMes+', iDataDia='+iDataDia);
      //console.log('sDataBase='+sDataBase+', iPing='+iPing);
      iPing     = 0;
   

      var sPar = 'zodiaco_carga_3.php?sDataBase='+sDataBase+'&iLat='+global_iLat+'&iLon='+global_iLon+'&iFHr='+global_iFHr;
//console.log('sPar='+sPar);
      //console.log('sPar='+sPar);
      var oReq = foCreateReq();
      oReq.open("GET",sPar,true);
      oReq.onreadystatechange = function() {
         if ((oReq.readyState==4) && (oReq.status==200)) {
            var sMsg = oReq.responseText;
            //console.log('flPing-sMsg='+sMsg);
            if (global_jTipo==0) flPosPing(sMsg);            // zodaco
            else {
               if (++global_iMapaPasso<=5) flPosCalcularCarta(sMsg);         // carta cosmolgica
               else                        flPosCalcularCarta21Dias(sMsg);   // 21 dias
            }
         }
      }
      oReq.send(null);
//   }
}

function flPosPing(psMsg) {
///////////////////////////
//console.log('flPosPing-psMsg='+psMsg);
   var aTmp = psMsg.split('^');
   var sMsg = aTmp[0];
       aEf  = sMsg.split('~');
   var sDta = aEf[0];
   var sAno = sDta.substr(0,4);
   var sMes = sDta.substr(5,2);
   var sDia = sDta.substr(8,2);
   var sHor = sDta.substr(11,2);
   var sMin = sDta.substr(14,2);

   var iSem = new Date(sAno,sMes-1,sDia).getDay();   // Dia da Semana, mes=0 -> janeiro
   var sSem = aSem[iSem];
   //console.log('sDta='+sDta+', iSem='+iSem+', sSem='+sSem);

   document.getElementById('span_Sem').innerHTML = sSem;
   document.getElementById('sel_Dias').selectedIndex  = sDia-1;
   document.getElementById('sel_Meses').selectedIndex = sMes-1;
   //console.log('sAno='+sAno+', Number(sAno-1920)='+Number((sAno-1920));
   document.getElementById('sel_Anos').selectedIndex  = Number(sAno-1920);
   document.getElementById('sel_Hor').selectedIndex   = sHor;
   document.getElementById('sel_Min').selectedIndex   = sMin/5;

   var jFaseLua = aEf[12];
   var jFasePNG = aEf[13];
   var sFaseLua = aFases[jFaseLua];
   var sFasePNG = aFasePNG[jFasePNG];
   document.getElementById('span_FaseLua').innerHTML=sFaseLua;
   document.getElementById('span_FaseLuaPNG').innerHTML='<img style="vertical-align: middle; height:20px; width:20px;" src="'+sPathPNG+sFasePNG+'">';


   //console.log('iPing='+iPing);
   var oTxt = document.getElementById('central_txt');
   oTxt.textContent = sDia+'/'+sMes+'/'+sAno+' '+sHor+':'+sMin;
   for (var i=0; i<iTotPla; i++) {   // ordem das efemrides
      var sSun = aEf[Number(i+1)];
      var sGr  = sSun.substr(0,2);
      var sZd  = sSun.substr(2,2);  
      var sMi  = sSun.substr(4,2);
      for (var j=0; j<aSZod.length; j++) if (sZd==aSZod[j]) break;   // j=zodiaco
      var iAng     = Number(j*30 + Number(sGr) + Number(sMi/60));
//    var iAng     = aEf[Number(i+1)];   // depende do retorno
      var iRad     = iAng*Math.PI / 180;
      var iCXLocal = Number(iOrbSun * Math.cos(iRad) + iXM);
      var iCYLocal = Number(iOrbSun * Math.sin(iRad) + iYM);
      var oSun     = document.getElementById(aPla3[i]);
      oSun.setAttribute('cx',iCXLocal);
      oSun.setAttribute('cy',iCYLocal);
      flSetCurvas2(i,aElZod[j]);   // i=retorno das efemrides, j=zodiaco, 
//      console.log('iCXLocal='+iCXLocal+' ,iCYLocal='+iCYLocal+' ,iAng='+iAng+' ,i='+i+' ,sSun='+sSun+' ,sGr='+sGr+' ,sZd='+sZd+' ,sMi='+sMi+' ,iRad='+iRad);
   }

// for (var i=0; i<iTotPla; i++) document.getElementById('td_'+aPla3[i]).innerHTML = fsReplSig2Color(aEf[i+1]);

   if (global_jStatus==1) {
      iPing=iDiaToSeg;
      setTimeout('flPing()',0.01);
   }
   if (global_jStatus==-1) {
      iPing=-iDiaToSeg;
      setTimeout('flPing()',1000);
   }
   if (global_jStatus==0)  {
      //setTimeout('flPing()',10);
   }

}   // flPosPing

function flIrParaData() {
/////////////////////////
   var oDia  = document.getElementById('sel_Dias');
   var oMes  = document.getElementById('sel_Meses');
   var oAno  = document.getElementById('sel_Anos');
   var oHor  = document.getElementById('sel_Hor');
   var oMin  = document.getElementById('sel_Min');

   var sDia  = oDia.options[oDia.selectedIndex].value;
   var sMes  = oMes.options[oMes.selectedIndex].value;
   var sAno  = oAno.options[oAno.selectedIndex].value;
   var sHor  = oHor.options[oHor.selectedIndex].value;
   var sMin  = (oMin.options[oMin.selectedIndex].value*5 < 10 ? '0' : '') + oMin.options[oMin.selectedIndex].value*5;
   var sSeg  = '00';
   var sData = sMes+'/'+sDia+'/'+sAno+' '+sHor+':'+sMin+':'+sSeg;
   var tData = Date.parse(sData);   // Valid format is month/day/year

   var sBase = sDataMes+'/'+sDataDia+'/'+iDataAno+' '+sDataHor+':'+sDataMin+':'+sDataSeg;
   var tBase = Date.parse(sBase);   // Valid format is month/day/year
   var iDif  = Math.abs(tData-tBase);
   iPing = Math.ceil(iDif / (1000            )) * (tData>=tBase ? 1 : -1);
   //console.log('flIrParaData-sData='+sData+', tData='+tData+', sBase='+sBase+', tBase='+tBase+', iDif='+iDif+', iPing='+iPing);
   flPing();
}

function flCalcularCarta() {
////////////////////////////
//console.log('flCalcularCarta');
   iPing     = 0;
   aPosicao  = [-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1];
   aConexao  = [-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1];
   aDetalhes = new Array();
   aDetalhes.push(['','','','']);   //  0-chacra -> 0-Ori, 1-Corao, 2-Percepo, 3-Centro
   aDetalhes.push(['','','','']);   //  1-DataHora
   aDetalhes.push(['','','','']);   //  2-Fase Lua
   aDetalhes.push(['','','','']);   //  3-Sol
   aDetalhes.push(['','','','']);   //  4-Pla1
   aDetalhes.push(['','','','']);   //  5-Pos1
   aDetalhes.push(['','','','']);   //  6-P121
   aDetalhes.push(['','','','']);   //  7-Pos121
   aDetalhes.push(['','','','']);   //  8-Pla2
   aDetalhes.push(['','','','']);   //  9-Pos2
   aDetalhes.push(['','','','']);   // 10-P221
   aDetalhes.push(['','','','']);   // 11-Pos221
   aDetalhes.push(['','','','']);   // 12-Pla3
   aDetalhes.push(['','','','']);   // 13-Pos3
   aDetalhes.push(['','','','']);   // 14-P321
   aDetalhes.push(['','','','']);   // 15-Pos321
   aDetalhes.push(['','','','']);   // 16-Lat
   aDetalhes.push(['','','','']);   // 17-Long
   aDetalhes.push(['','','','']);   // 18-Fuso
   aDetalhes.push(['','','','']);   // 19-Setas dos Atmicos
   aDetalhes.push(['','','','']);   // 20-Setas dos Ativos
   aDetalhes.push(['','','','']);   // 21-Setas dos Passivos

   var oDia   = document.getElementById('sel_Dias');
   var oMes   = document.getElementById('sel_Meses');
   var oAno   = document.getElementById('sel_Anos');
   var oHor   = document.getElementById('sel_Hor');
   var oMin   = document.getElementById('sel_Min');
   var sDia   = oDia.options[oDia.selectedIndex].value;
   var sMes   = oMes.options[oMes.selectedIndex].value;
   var sAno   = oAno.options[oAno.selectedIndex].value;
   var sHor   = oHor.options[oHor.selectedIndex].value;
   var sMin   = (oMin.options[oMin.selectedIndex].value*5 < 10 ? '0' : '') + oMin.options[oMin.selectedIndex].value*5;
   var sSeg   = '00';
   var sData  = sMes+'/'+sDia+'/'+sAno+' '+sHor+':'+sMin+':'+sSeg;
   var tData  = Date.parse(sData);   // Valid format is month/day/year


   tDataBase.setSeconds(iPing);
   //console.log('flPing-tDataBase='+tDataBase+', iPing='+iPing);
   iDataAno  = tDataBase.getFullYear();    // yyyy
   iDataMes  = Number(tDataBase.getMonth()+1);   // 0-11 -> 1-12   - 1*1  para forar ser um numero
   iDataDia  = tDataBase.getDate();        // 1-31
   iDataHor  = tDataBase.getHours();
   iDataMin  = tDataBase.getMinutes();
   sDataMes  = iDataMes<10 ? '0'+iDataMes : iDataMes;
   sDataDia  = iDataDia<10 ? '0'+iDataDia : iDataDia;
   sDataHor  = iDataHor<10 ? '0'+iDataHor : iDataHor;
   sDataMin  = iDataMin<10 ? '0'+iDataMin : iDataMin;

   var sBase = sDataMes+'/'+sDataDia+'/'+iDataAno+' '+sDataHor+':'+sDataMin+':'+sDataSeg;
   var tBase = Date.parse(sBase);   // Valid format is month/day/year
   var iDif  = Math.abs(tData-tBase);                            // milisegundos
   iPing = Math.ceil(iDif / (1000)) * (tData>=tBase ? 1 : -1);   // segundos
   //console.log('flIrParaData-sData='+sData+', tData='+tData+', sBase='+sBase+', tBase='+tBase+', iDif='+iDif+', iPing='+iPing);
   flPing();
}

function flPosCalcularCarta(psMsg) {
////////////////////////////////////
//console.log('flPosCalcularCarta-global_iMapaPasso='+global_iMapaPasso);
   if (global_iMapaPasso<=4) {
      //console.log('psMsg='+psMsg);
      var aTmp = psMsg.split('^');
      var sMsg = aTmp[0];
      var aEf  = sMsg.split('~');

      var jFaseLua  = aEf[12];
      var iFasesHr  = aFasesHr[jFaseLua];
      var iFasesSeg = iFasesHr*iHorToSeg;
      aFasesSeg.push(iFasesSeg);

      var sDta = aEf[0];
      var sAno = sDta.substr(0,4);
      var sMes = sDta.substr(5,2);
      var sDia = sDta.substr(8,2);
      var sHor = sDta.substr(11,2);
      var sMin = sDta.substr(14,2);
      var sDBr = sDia+'/'+sMes+'/'+sAno+' '+sHor+':'+sMin;

      var iSem = new Date(sAno,sMes-1,sDia).getDay();   // Dia da Semana, mes=0 -> janeiro
      var sSem = aSem[iSem];
      //console.log('sDta='+sDta+', iSem='+iSem+', sSem='+sSem);

      var sSun = aEf[1];
      var sGr  = sSun.substr(0,2);
      var sZd  = sSun.substr(2,2);
      var sMi  = sSun.substr(4,2);

      var iZod = aSZod.indexOf(sZd);
      var iEfe = fiZodToEfe(iZod);   
      var sPla = aPla3[iEfe];      // Atmico
      var aSeq = faSeqPla(iEfe);   // ndice do Zodaco
      var sAti = aPla3[aSeq[1]];   // Ativo
      var sPas = aPla3[aSeq[2]];   // Passivo
      //console.log('sDta='+sDta+', sSun='+sSun+', sZd='+sZd+', sPla='+sPla+', global_iMapaPasso='+global_iMapaPasso+', sAti='+sAti+', sPas='+sPas+' iEfe='+iEfe+', iZod='+iZod);
      aEfe[global_iMapaPasso-1][0] = iEfe;
      aEfe[global_iMapaPasso-1][1] = aSeq[1];
      aEfe[global_iMapaPasso-1][2] = aSeq[2];


      // Caso Elno antes de 1960
      var iEfeS  = 0;
      var iEfeL  = 1;
      var sZodSO = aSZodOpos[aSZod.indexOf(sZd)];    // Sol Oposio

      var sLua   = aEf[Number(iEfeL+1)];   // 0-Sol, mas no retorno da efemridas o campo 0  a data e os demais so +1
      var sZdL   = sLua.substr(2,2);
      var sZodLO = aSZodOpos[aSZod.indexOf(sZdL)];   // Lua Oposio

      jND = fjNoiteDia(sMes,sHor,sMin);       // 0-Noite, 1-Dia

      // Atmico
      // -------
      if      ( (iEfe==iEfeEln) && (sAno<iAnoEln) && (jND==0) ) var jCaso=0;
      else if ( (iEfe==iEfeEln) && (sAno<iAnoEln) && (jND==1) ) var jCaso=1;
      else                                                      var jCaso=2;

      if      (jCaso==0) var iEX0 = Number(iEfeS+1);   //  elno, antes de 1960 e  de noite - oposio ao Sol
      else if (jCaso==1) var iEX0 = Number(iEfeL+1);   //  elno, antes de 1960 e  de dia   - oposio   Lua
      else               var iEX0 = Number(iEfe+1);    // 0-Sol, mas no retorno da efemridas o campo 0  a data e os demais so +1

      if (iEX0<12) {
         var sXX0 = aEf[iEX0];   // sGr0+sZd0+sMi0 ex "18SC23"
         aEf21[global_iMapaPasso-1][0] = sXX0;
         var sGr0 = sXX0.substr(0,2);
         if      (jCaso==0) var sZd0 = sZodSO;
         else if (jCaso==1) var sZd0 = sZodLO;
         else               var sZd0 = sXX0.substr(2,2);
         var sMi0 = sXX0.substr(4,2);
         if      (jCaso==0) sPla += '(sun)';
         else if (jCaso==1) sPla += '(moo)';
         if (jCaso<=1) sXX0 += '('+sZd0+')';
         var iZo0 = aSZod.indexOf(sZd0);
         var iEf0 = fiZodToEfe(iZo0);
         var sPl0 = aPla3[iEf0];
         if (global_iMapaPasso==1) aConexao[6] = iEf0;   // ori
         if (global_iMapaPasso==2) aConexao[0] = iEf0;   // cor  
         if (global_iMapaPasso==3) aConexao[3] = iEf0;   // per
         if (global_iMapaPasso==4) aConexao[9] = iEf0;   // cen
         //console.log('iEX0='+iEX0+', sXX0='+sXX0+', iEfe='+iEfe+', sPl0='+sPl0+', sGr0='+sGr0+', sZd0='+sZd0+', sMi0='+sMi0+', iZo0='+iZo0+', iEf0='+iEf0+', sPl0='+sPl0);
      } else {   //  a terra - tabela de cores
         var iEfeTer = fiRelToEfe(fiTerToRel(sMes,iSem,sHor,sMin));
         var iEX0Ter = Number(iEfeTer+1);
         var sXX0    = aEf[iEX0Ter];
         aEf21[global_iMapaPasso-1][0] = sXX0;
         var sGr0    = sXX0.substr(0,2);
         var sXX0    = aPla3[iEX0Ter-1]+'('+sXX0+')';
         if (global_iMapaPasso==1) aConexao[6] = iEfeTer;   // ori
         if (global_iMapaPasso==2) aConexao[0] = iEfeTer;   // cor  
         if (global_iMapaPasso==3) aConexao[3] = iEfeTer;   // per
         if (global_iMapaPasso==4) aConexao[9] = iEfeTer;   // cen
      }
      if (global_iMapaPasso==1) aPosicao[6] = (iEfe==iEfeEln) ? iEfeEln : iEX0-1;   // ori
      if (global_iMapaPasso==2) aPosicao[0] = (iEfe==iEfeEln) ? iEfeEln : iEX0-1;   // cor  
      if (global_iMapaPasso==3) aPosicao[3] = (iEfe==iEfeEln) ? iEfeEln : iEX0-1;   // per
      if (global_iMapaPasso==4) aPosicao[9] = (iEfe==iEfeEln) ? iEfeEln : iEX0-1;   // cen

      if (global_iMapaPasso==1) aPoloCr[6] = aCores[fiEfeToRel((iEX0<12) ? iEf0 : iEfeTer)];   // ori
      if (global_iMapaPasso==2) aPoloCr[0] = aCores[fiEfeToRel((iEX0<12) ? iEf0 : iEfeTer)];   // cor  
      if (global_iMapaPasso==3) aPoloCr[3] = aCores[fiEfeToRel((iEX0<12) ? iEf0 : iEfeTer)];   // per
      if (global_iMapaPasso==4) aPoloCr[9] = aCores[fiEfeToRel((iEX0<12) ? iEf0 : iEfeTer)];   // cen

      if (global_iMapaPasso==1) aPoloGr[6] = sGr0;   // ori
      if (global_iMapaPasso==2) aPoloGr[0] = sGr0;   // cor  
      if (global_iMapaPasso==3) aPoloGr[3] = sGr0;   // per
      if (global_iMapaPasso==4) aPoloGr[9] = sGr0;   // cen

      // Ativo
      // -----
      if      ( (aSeq[1]==iEfeEln) && (sAno<iAnoEln) && (jND==0) ) var jCaso=0;
      else if ( (aSeq[1]==iEfeEln) && (sAno<iAnoEln) && (jND==1) ) var jCaso=1;
      else                                                         var jCaso=2;

      if      (jCaso==0) var iEX1 = Number(iEfeS+1);    //  elno, antes de 1960 e  de noite - oposio ao Sol
      else if (jCaso==1) var iEX1 = Number(iEfeL+1);    //  elno, antes de 1960 e  de dia   - oposio   Lua
      else               var iEX1 = Number(aSeq[1]+1);  // 

      if (iEX1<12) {
         var sXX1 = aEf[iEX1];
         aEf21[global_iMapaPasso-1][1] = sXX1;
         var sGr1 = sXX1.substr(0,2);
         if      (jCaso==0) var sZd1 = sZodSO;
         else if (jCaso==1) var sZd1 = sZodLO;
         else               var sZd1 = sXX1.substr(2,2);
         var sMi1 = sXX1.substr(4,2);
         if      (jCaso==0) sAti += '(sun)';
         else if (jCaso==1) sAti += '(moo)';
         if (jCaso<=1) sXX1 += '('+sZd1+')';
         var iZo1 = aSZod.indexOf(sZd1);
         var iEf1 = fiZodToEfe(iZo1);
         var sPl1 = aPla3[iEf1];
         if (global_iMapaPasso==1) aConexao[7]  = iEf1;   // ori
         if (global_iMapaPasso==2) aConexao[1]  = iEf1;   // cor  
         if (global_iMapaPasso==3) aConexao[4]  = iEf1;   // per
         if (global_iMapaPasso==4) aConexao[10] = iEf1;   // cen
         //console.log('iEX1='+iEX1+', sXX1='+sXX1+', aSeq[1]='+aSeq[1]+', sPl1='+sPl1+', sGr1='+sGr1+', sZd1='+sZd1+', sMi1='+sMi1+', iZo1='+iZo1+', iEf1='+iEf1+', jCaso='+jCaso);
      } else {   //  a terra - tabela de cores
         var iEfeTer = fiRelToEfe(fiTerToRel(sMes,iSem,sHor,sMin));
         var iEX1Ter = Number(iEfeTer+1);
         var sXX1    = aEf[iEX1Ter];
         aEf21[global_iMapaPasso-1][1] = sXX1;
         var sGr1    = sXX1.substr(0,2);
         var sXX1    = aPla3[iEX1Ter-1]+'('+sXX1+')';
         if (global_iMapaPasso==1) aConexao[7]  = iEfeTer;   // ori
         if (global_iMapaPasso==2) aConexao[1]  = iEfeTer;   // cor  
         if (global_iMapaPasso==3) aConexao[4]  = iEfeTer;   // per
         if (global_iMapaPasso==4) aConexao[10] = iEfeTer;   // cen
      }
      if (global_iMapaPasso==1) aPosicao[7]  = (aSeq[1]==iEfeEln) ? iEfeEln : iEX1-1;   // ori
      if (global_iMapaPasso==2) aPosicao[1]  = (aSeq[1]==iEfeEln) ? iEfeEln : iEX1-1;   // cor  
      if (global_iMapaPasso==3) aPosicao[4]  = (aSeq[1]==iEfeEln) ? iEfeEln : iEX1-1;   // per
      if (global_iMapaPasso==4) aPosicao[10] = (aSeq[1]==iEfeEln) ? iEfeEln : iEX1-1;   // cen

      if (global_iMapaPasso==1) aPoloCr[7]  = aCores[fiEfeToRel((iEX1<12) ? iEf1 : iEfeTer)];   // ori
      if (global_iMapaPasso==2) aPoloCr[1]  = aCores[fiEfeToRel((iEX1<12) ? iEf1 : iEfeTer)];   // cor  
      if (global_iMapaPasso==3) aPoloCr[4]  = aCores[fiEfeToRel((iEX1<12) ? iEf1 : iEfeTer)];   // per
      if (global_iMapaPasso==4) aPoloCr[10] = aCores[fiEfeToRel((iEX1<12) ? iEf1 : iEfeTer)];   // cen

      if (global_iMapaPasso==1) aPoloGr[7]  = sGr1;   // ori
      if (global_iMapaPasso==2) aPoloGr[1]  = sGr1;   // cor  
      if (global_iMapaPasso==3) aPoloGr[4]  = sGr1;   // per
      if (global_iMapaPasso==4) aPoloGr[10] = sGr1;   // cen

      // Passivo
      // -------
      if      ( (aSeq[2]==iEfeEln) && (sAno<iAnoEln) && (jND==0) ) var jCaso=0;
      else if ( (aSeq[2]==iEfeEln) && (sAno<iAnoEln) && (jND==1) ) var jCaso=1;
      else                                                         var jCaso=2;

      if      (jCaso==0) var iEX2 = Number(iEfeS+1);    //  elno, antes de 1960 e  de noite - oposio ao Sol
      else if (jCaso==1) var iEX2 = Number(iEfeL+1);    //  elno, antes de 1960 e  de dia   - oposio   Lua
      else               var iEX2 = Number(aSeq[2]+1);  // 

      if (iEX2<12) {
         var sXX2 = aEf[iEX2];
         aEf21[global_iMapaPasso-1][2] = sXX2;
         var sGr2 = sXX2.substr(0,2);
         if      (jCaso==0) var sZd2 = sZodSO;
         else if (jCaso==1) var sZd2 = sZodLO;
         else               var sZd2 = sXX2.substr(2,2);
         var sMi2 = sXX2.substr(4,2);
         if      (jCaso==0) sPas += '(sun)';
         else if (jCaso==1) sPas += '(moo)';
         if (jCaso<=1) sXX2 += '('+sZd2+')';
         var iZo2 = aSZod.indexOf(sZd2);
         var iEf2 = fiZodToEfe(iZo2);
         var sPl2 = aPla3[iEf2];
         //console.log('iEX2='+iEX2+', sXX2='+sXX2+', aSeq[2]='+aSeq[2]+', sPl2='+sPl2+', sGr2='+sGr2+', sZd2='+sZd2+', sMi2='+sMi2+', iZo2='+iZo2+', iEf2='+iEf2+', sPl2='+sPl2);
         if (global_iMapaPasso==1) aConexao[8]  = iEf2;   // ori
         if (global_iMapaPasso==2) aConexao[2]  = iEf2;   // cor  
         if (global_iMapaPasso==3) aConexao[5]  = iEf2;   // per
         if (global_iMapaPasso==4) aConexao[11] = iEf2;   // cen
      } else {   //  a terra - tabela de cores
         var iEfeTer = fiRelToEfe(fiTerToRel(sMes,iSem,sHor,sMin));
         var iEX2Ter = Number(iEfeTer+1);
         var sXX2    = aEf[iEX2Ter];
         aEf21[global_iMapaPasso-1][2] = sXX2;
         var sGr2    = sXX2.substr(0,2);
         var sXX2    = aPla3[iEX2Ter-1]+'('+sXX2+')';
         if (global_iMapaPasso==1) aConexao[8]  = iEfeTer;   // ori
         if (global_iMapaPasso==2) aConexao[2]  = iEfeTer;   // cor  
         if (global_iMapaPasso==3) aConexao[5]  = iEfeTer;   // per
         if (global_iMapaPasso==4) aConexao[11] = iEfeTer;   // cen
      }
      if (global_iMapaPasso==1) aPosicao[8]  = (aSeq[2]==iEfeEln) ? iEfeEln : iEX2-1;   // ori
      if (global_iMapaPasso==2) aPosicao[2]  = (aSeq[2]==iEfeEln) ? iEfeEln : iEX2-1;   // cor  
      if (global_iMapaPasso==3) aPosicao[5]  = (aSeq[2]==iEfeEln) ? iEfeEln : iEX2-1;   // per
      if (global_iMapaPasso==4) aPosicao[11] = (aSeq[2]==iEfeEln) ? iEfeEln : iEX2-1;   // cen

      if (global_iMapaPasso==1) aPoloCr[8]  = aCores[fiEfeToRel((iEX2<12) ? iEf2 : iEfeTer)];   // ori
      if (global_iMapaPasso==2) aPoloCr[2]  = aCores[fiEfeToRel((iEX2<12) ? iEf2 : iEfeTer)];   // cor  
      if (global_iMapaPasso==3) aPoloCr[5]  = aCores[fiEfeToRel((iEX2<12) ? iEf2 : iEfeTer)];   // per
      if (global_iMapaPasso==4) aPoloCr[11] = aCores[fiEfeToRel((iEX2<12) ? iEf2 : iEfeTer)];   // cen

      if (global_iMapaPasso==1) aPoloGr[8]  = sGr2;   // ori
      if (global_iMapaPasso==2) aPoloGr[2]  = sGr2;   // cor  
      if (global_iMapaPasso==3) aPoloGr[5]  = sGr2;   // per
      if (global_iMapaPasso==4) aPoloGr[11] = sGr2;   // cen


      // isso esta repetindo 12 vezes para cada chamada dessa funo
      for (var i in aPosicao) document.getElementById('Polo_'+i).setAttribute('style', 'stroke:'+aCores[fiEfeToRel(aPosicao[i])]+'; fill:'+aCores[fiEfeToRel(aPosicao[i])]+';');

      aDetalhes[ 0][global_iMapaPasso-1] = aChacra[global_iMapaPasso-1];
      aDetalhes[ 1][global_iMapaPasso-1] = sDBr+'('+sSem+')';
      aDetalhes[ 2][global_iMapaPasso-1] = aFases[jFaseLua].substr(0,3) + '/' + iFasesHr + ':00 Hr'
      aDetalhes[ 3][global_iMapaPasso-1] = sSun;

      aDetalhes[ 4][global_iMapaPasso-1] = sPla;
      aDetalhes[ 5][global_iMapaPasso-1] = sXX0;
      aDetalhes[ 6][global_iMapaPasso-1] = '';
      aDetalhes[ 7][global_iMapaPasso-1] = '';
               
      aDetalhes[ 8][global_iMapaPasso-1] = sAti;
      aDetalhes[ 9][global_iMapaPasso-1] = sXX1;
      aDetalhes[10][global_iMapaPasso-1] = '';
      aDetalhes[11][global_iMapaPasso-1] = '';
               
      aDetalhes[12][global_iMapaPasso-1] = sPas;
      aDetalhes[13][global_iMapaPasso-1] = sXX2;
      aDetalhes[14][global_iMapaPasso-1] = '';
      aDetalhes[15][global_iMapaPasso-1] = '';
               
      aDetalhes[16][global_iMapaPasso-1] = '';
      aDetalhes[17][global_iMapaPasso-1] = '';
      aDetalhes[18][global_iMapaPasso-1] = '';

      if ((document.getElementById('input_Not9Meses').checked) && (global_iMapaPasso-1==0)) {   // considerar a data prevista de nascimento

         var oDiaP  = document.getElementById('sel_DiasPre');
         var oMesP  = document.getElementById('sel_MesesPre');
         var oAnoP  = document.getElementById('sel_AnosPre');
         var oHorP  = document.getElementById('sel_HorPre');
         var oMinP  = document.getElementById('sel_MinPre');
         var sDiaP  = oDiaP.options[oDiaP.selectedIndex].value;
         var sMesP  = oMesP.options[oMesP.selectedIndex].value;
         var sAnoP  = oAnoP.options[oAnoP.selectedIndex].value;
         var sHorP  = oHorP.options[oHorP.selectedIndex].value;
         var sMinP  = (oMinP.options[oMinP.selectedIndex].value*5 < 10 ? '0' : '') + oMinP.options[oMinP.selectedIndex].value*5;
         var sSegP  = '00';
         var sDataP = sMesP+'/'+sDiaP+'/'+sAnoP+' '+sHorP+':'+sMinP+':'+sSegP;
         var tDataP = Date.parse(sDataP);   // Valid format is month/day/year

         var oDia   = document.getElementById('sel_Dias');
         var oMes   = document.getElementById('sel_Meses');
         var oAno   = document.getElementById('sel_Anos');
         var oHor   = document.getElementById('sel_Hor');
         var oMin   = document.getElementById('sel_Min');
         var sDia   = oDia.options[oDia.selectedIndex].value;
         var sMes   = oMes.options[oMes.selectedIndex].value;
         var sAno   = oAno.options[oAno.selectedIndex].value;
         var sHor   = oHor.options[oHor.selectedIndex].value;
         var sMin   = (oMin.options[oMin.selectedIndex].value*5 < 10 ? '0' : '') + oMin.options[oMin.selectedIndex].value*5;
         var sSeg   = '00';
         var sData  = sMes+'/'+sDia+'/'+sAno+' '+sHor+':'+sMin+':'+sSeg;
         var tData  = Date.parse(sData);   // Valid format is month/day/year

         var iDif   = Math.abs(tDataP-tData);                                // milisegundos
         iDifS      = Math.ceil(iDif / (1000)) * (tDataP>=tData ? 1 : -1);   // segundos - se tDataP >= tData tenho q da data de nascimento tData ir para a data prevista tDataP somando, cc subtraio
         iPing      = Number(iDifS-87*iDiaToSeg+iFasesSeg);

      } else {
         iPing      = Number(-87*iDiaToSeg+iFasesSeg);
      }

      flPing();

   } else {
//console.log('flCalcularCarta21Dias-call');
      flCalcularCarta21Dias();
   }
}

function flCalcularCarta21Dias() {
//////////////////////////////////
//console.log('flCalcularCarta21Dias');
   iPing     = 0;
   var oDia  = document.getElementById('sel_Dias');
   var oMes  = document.getElementById('sel_Meses');
   var oAno  = document.getElementById('sel_Anos');
   var oHor  = document.getElementById('sel_Hor');
   var oMin  = document.getElementById('sel_Min');
   var sDia  = oDia.options[oDia.selectedIndex].value;
   var sMes  = oMes.options[oMes.selectedIndex].value;
   var sAno  = oAno.options[oAno.selectedIndex].value;
   var sHor  = oHor.options[oHor.selectedIndex].value;
   var sMin  = (oMin.options[oMin.selectedIndex].value*5 < 10 ? '0' : '') + oMin.options[oMin.selectedIndex].value*5;
   var sSeg  = '00';
   var sData = sMes+'/'+sDia+'/'+sAno+' '+sHor+':'+sMin+':'+sSeg;
   var tData = Date.parse(sData);   // Valid format is month/day/year

   tDataBase.setSeconds(iPing);
   //console.log('flCalcularCarta21Dias-tDataBase='+tDataBase+', iPing='+iPing);
   iDataAno  = tDataBase.getFullYear();    // yyyy
   iDataMes  = Number(tDataBase.getMonth()+1);   // 0-11 -> 1-12   - 1*1  para forar ser um numero
   iDataDia  = tDataBase.getDate();        // 1-31
   iDataHor  = tDataBase.getHours();
   iDataMin  = tDataBase.getMinutes();
   sDataMes  = iDataMes<10 ? '0'+iDataMes : iDataMes;
   sDataDia  = iDataDia<10 ? '0'+iDataDia : iDataDia;
   sDataHor  = iDataHor<10 ? '0'+iDataHor : iDataHor;
   sDataMin  = iDataMin<10 ? '0'+iDataMin : iDataMin;

   var sBase = sDataMes+'/'+sDataDia+'/'+iDataAno+' '+sDataHor+':'+sDataMin+':'+sDataSeg;
   var tBase = Date.parse(sBase);   // Valid format is month/day/year
   var iDif  = Math.abs(tData-tBase);
   iPing = Math.ceil(iDif / (1000)) * (tData>=tBase ? 1 : -1);
   iPing+= 21*iDiaToSeg;
   //console.log('flIrParaData-sData='+sData+', tData='+tData+', sBase='+sBase+', tBase='+tBase+', iDif='+iDif+', iPing='+iPing);
   flPing();
}

function flPosCalcularCarta21Dias(psMsg) {
//////////////////////////////////////////
//console.log('flPosCalcularCarta21Dias-global_iMapaPasso='+global_iMapaPasso);
   if (global_iMapaPasso<=9) {
      //console.log('psMsg='+psMsg);
      var aTmp = psMsg.split('^');
      var sMsg = aTmp[0];
      var aEf  = sMsg.split('~');

      var iFasesSeg = aFasesSeg[global_iMapaPasso-6];
      //console.log('flPosCalcularCarta21Dias-iFasesSeg='+iFasesSeg);

      var sDta = aEf[0];
      var sAno = sDta.substr(0,4);
      var sMes = sDta.substr(5,2);
      var sDia = sDta.substr(8,2);
      var sHor = sDta.substr(11,2);
      var sMin = sDta.substr(14,2);
      var sDBr = sDia+'/'+sMes+'/'+sAno+' '+sHor+':'+sMin;
   
      var iSem = new Date(sAno,sMes-1,sDia).getDay();   // Dia da Semana, mes=0 -> janeiro
      //console.log('sDta='+sDta+', iSem='+iSem);

      var sSun = aEf[1];
      var sGr  = sSun.substr(0,2);
      var sZd  = sSun.substr(2,2);
      var sMi  = sSun.substr(4,2);
      
      iEfe  = aEfe[global_iMapaPasso-6][0];
      iSeq1 = aEfe[global_iMapaPasso-6][1];
      iSeq2 = aEfe[global_iMapaPasso-6][2];

      // Caso Elno antes de 1960
      var iEfeS  = 0;
      var iEfeL  = 1;
      var sZodSO = aSZodOpos[aSZod.indexOf(sZd)];    // Sol Oposio

      var sLua   = aEf[Number(iEfeL+1)];   // 0-Sol, mas no retorno da efemridas o campo 0  a data e os demais so +1
      var sZdL   = sLua.substr(2,2);
      var sZodLO = aSZodOpos[aSZod.indexOf(sZdL)];   // Lua Oposio

      jND = fjNoiteDia(sMes,sHor,sMin);       // 0-Noite, 1-Dia

      // Atmico
      // -------
      if      ( (iEfe==iEfeEln) && (sAno<iAnoEln) && (jND==0) ) var jCaso=0;
      else if ( (iEfe==iEfeEln) && (sAno<iAnoEln) && (jND==1) ) var jCaso=1;
      else                                                      var jCaso=2;

      if      (jCaso==0) var iEX0 = Number(iEfeS+1);   //  elno, antes de 1960 e  de noite - oposio ao Sol
      else if (jCaso==1) var iEX0 = Number(iEfeL+1);   //  elno, antes de 1960 e  de dia   - oposio   Lua
      else               var iEX0 = Number(iEfe+1);    // 0-Sol, mas no retorno da efemridas o campo 0  a data e os demais so +1

      if (iEX0<12) {
         var sXX0 = aEf[iEX0];
         var sGr0 = sXX0.substr(0,2);
         if      (jCaso==0) var sZd0 = sZodSO;
         else if (jCaso==1) var sZd0 = sZodLO;
         else               var sZd0 = sXX0.substr(2,2);
         var sMi0 = sXX0.substr(4,2);
         if (jCaso<=1) sXX0 += '('+sZd0+')';
         var iZo0 = aSZod.indexOf(sZd0);
         var iEf0 = fiZodToEfe(iZo0);
         var sPl0 = aPla3[iEf0];
         //console.log('iEX0='+iEX0+', sXX0='+sXX0+', iEfe='+iEfe+', sPl0='+sPl0+', sGr0='+sGr0+', sZd0='+sZd0+', sMi0='+sMi0+', iZo0='+iZo0+', iEf0='+iEf0+', sPl0='+sPl0);
      } else {   //  a terra - tabela de cores
         var iEfeTer = fiRelToEfe(fiTerToRel(sMes,iSem,sHor,sMin));
         var iEX0Ter = Number(iEfeTer+1);
         var sXX0    = aEf[iEX0Ter];
      }
      jSeta0 = fjSeta21Dias(aEf21[global_iMapaPasso-6][0],sXX0);
      if (global_iMapaPasso-6==0) aPoloSt[6] = jSeta0;   // ori
      if (global_iMapaPasso-6==1) aPoloSt[0] = jSeta0;   // cor  
      if (global_iMapaPasso-6==2) aPoloSt[3] = jSeta0;   // per
      if (global_iMapaPasso-6==3) aPoloSt[9] = jSeta0;   // cen

      // Ativo
      // -----
      if      ( (iSeq1==iEfeEln) && (sAno<iAnoEln) && (jND==0) ) var jCaso=0;
      else if ( (iSeq1==iEfeEln) && (sAno<iAnoEln) && (jND==1) ) var jCaso=1;
      else                                                       var jCaso=2;

      if      (jCaso==0) var iEX1 = Number(iEfeS+1);    //  elno, antes de 1960 e  de dia   - oposio  Lua
      else if (jCaso==1) var iEX1 = Number(iEfeL+1);    //  elno, antes de 1960 e  de noite - oposio ao Sol
      else               var iEX1 = Number(iSeq1+1);    //

      if (iEX1<12) {
         var sXX1 = aEf[iEX1];
         var sGr1 = sXX1.substr(0,2);
         if      (jCaso==0) var sZd1 = sZodSO;
         else if (jCaso==1) var sZd1 = sZodLO;
         else               var sZd1 = sXX1.substr(2,2);
         var sMi1 = sXX1.substr(4,2);
         if (jCaso<=1) sXX1 += '('+sZd1+')';
         var iZo1 = aSZod.indexOf(sZd1);
         var iEf1 = fiZodToEfe(iZo1);
         var sPl1 = aPla3[iEf1];
         //console.log('iEX1='+iEX1+', sXX1='+sXX1+', aSeq[1]='+aSeq[1]+', sPl1='+sPl1+', sGr1='+sGr1+', sZd1='+sZd1+', sMi1='+sMi1+', iZo1='+iZo1+', iEf1='+iEf1+', sPl1='+sPl1);
      } else {   //  a terra - tabela de cores
         var iEfeTer = fiRelToEfe(fiTerToRel(sMes,iSem,sHor,sMin));
         var iEX1Ter = Number(iEfeTer+1);
         var sXX1    = aEf[iEX1Ter];
      }
      jSeta1 = fjSeta21Dias(aEf21[global_iMapaPasso-6][1],sXX1);
      if (global_iMapaPasso-6==0) aPoloSt[7]  = jSeta1;   // ori
      if (global_iMapaPasso-6==1) aPoloSt[1]  = jSeta1;   // cor  
      if (global_iMapaPasso-6==2) aPoloSt[4]  = jSeta1;   // per
      if (global_iMapaPasso-6==3) aPoloSt[10] = jSeta1;   // cen

      // Passivo
      // -------
      if      ( (iSeq2==iEfeEln) && (sAno<iAnoEln) && (jND==0) ) var jCaso=0;
      else if ( (iSeq2==iEfeEln) && (sAno<iAnoEln) && (jND==1) ) var jCaso=1;
      else                                                       var jCaso=2;

      if      (jCaso==0) var iEX2 = Number(iEfeS+1);    //  elno, antes de 1960 e  de dia   - oposio  Lua
      else if (jCaso==1) var iEX2 = Number(iEfeL+1);    //  elno, antes de 1960 e  de noite - oposio ao Sol
      else               var iEX2 = Number(iSeq2+1);    //

      if (iEX2<12) {
         var sXX2 = aEf[iEX2];
         var sGr2 = sXX2.substr(0,2);
         if      (jCaso==0) var sZd2 = sZodSO;
         else if (jCaso==1) var sZd2 = sZodLO;
         else               var sZd2 = sXX2.substr(2,2);
         var sMi2 = sXX2.substr(4,2);
         if (jCaso<=1) sXX2 += '('+sZd2+')';
         var iZo2 = aSZod.indexOf(sZd2);
         var iEf2 = fiZodToEfe(iZo2);
         var sPl2 = aPla3[iEf2];
         //console.log('iEX2='+iEX2+', sXX2='+sXX2+', aSeq[2]='+aSeq[2]+', sPl2='+sPl2+', sGr2='+sGr2+', sZd2='+sZd2+', sMi2='+sMi2+', iZo2='+iZo2+', iEf2='+iEf2+', sPl2='+sPl2);
      } else {   //  a terra - tabela de cores
         var iEfeTer = fiRelToEfe(fiTerToRel(sMes,iSem,sHor,sMin));
         var iEX2Ter = Number(iEfeTer+1);
         var sXX2    = aEf[iEX2Ter];
      }
      jSeta2 = fjSeta21Dias(aEf21[global_iMapaPasso-6][2],sXX2);
      if (global_iMapaPasso-6==0) aPoloSt[8]  = jSeta2;   // ori
      if (global_iMapaPasso-6==1) aPoloSt[2]  = jSeta2;   // cor  
      if (global_iMapaPasso-6==2) aPoloSt[5]  = jSeta2;   // per
      if (global_iMapaPasso-6==3) aPoloSt[11] = jSeta2;   // cen

      aDetalhes[ 6][global_iMapaPasso-6] = sDBr;
      aDetalhes[ 7][global_iMapaPasso-6] = sXX0;
               
      aDetalhes[10][global_iMapaPasso-6] = sDBr;
      aDetalhes[11][global_iMapaPasso-6] = sXX1;
               
      aDetalhes[14][global_iMapaPasso-6] = sDBr;
      aDetalhes[15][global_iMapaPasso-6] = sXX2;

      aDetalhes[19][global_iMapaPasso-6] = jSeta0;
      aDetalhes[20][global_iMapaPasso-6] = jSeta1;
      aDetalhes[21][global_iMapaPasso-6] = jSeta2;

//console.log('global_iMapaPasso-6='+(global_iMapaPasso-5)+', jSeta0='+jSeta0+', jSeta1='+jSeta1+', jSeta2='+jSeta2);

      if ((document.getElementById('input_Not9Meses').checked) && (global_iMapaPasso-6==0)) {   // considerar a data prevista de nascimento

         var oDiaP  = document.getElementById('sel_DiasPre');
         var oMesP  = document.getElementById('sel_MesesPre');
         var oAnoP  = document.getElementById('sel_AnosPre');
         var oHorP  = document.getElementById('sel_HorPre');
         var oMinP  = document.getElementById('sel_MinPre');
         var sDiaP  = oDiaP.options[oDiaP.selectedIndex].value;
         var sMesP  = oMesP.options[oMesP.selectedIndex].value;
         var sAnoP  = oAnoP.options[oAnoP.selectedIndex].value;
         var sHorP  = oHorP.options[oHorP.selectedIndex].value;
         var sMinP  = (oMinP.options[oMinP.selectedIndex].value*5 < 10 ? '0' : '') + oMinP.options[oMinP.selectedIndex].value*5;
         var sSegP  = '00';
         var sDataP = sMesP+'/'+sDiaP+'/'+sAnoP+' '+sHorP+':'+sMinP+':'+sSegP;
         var tDataP = Date.parse(sDataP);   // Valid format is month/day/year

         var oDia   = document.getElementById('sel_Dias');
         var oMes   = document.getElementById('sel_Meses');
         var oAno   = document.getElementById('sel_Anos');
         var oHor   = document.getElementById('sel_Hor');
         var oMin   = document.getElementById('sel_Min');
         var sDia   = oDia.options[oDia.selectedIndex].value;
         var sMes   = oMes.options[oMes.selectedIndex].value;
         var sAno   = oAno.options[oAno.selectedIndex].value;
         var sHor   = oHor.options[oHor.selectedIndex].value;
         var sMin   = (oMin.options[oMin.selectedIndex].value*5 < 10 ? '0' : '') + oMin.options[oMin.selectedIndex].value*5;
         var sSeg   = '00';
         var sData  = sMes+'/'+sDia+'/'+sAno+' '+sHor+':'+sMin+':'+sSeg;
         var tData  = Date.parse(sData);   // Valid format is month/day/year

         var iDif   = Math.abs(tDataP-tData);                                // milisegundos
         iDifS      = Math.ceil(iDif / (1000)) * (tDataP>=tData ? 1 : -1);   // segundos - se tDataP >= tData tenho q da data de nascimento tData ir para a data prevista tDataP somando, cc subtraio
         iPing      = Number(iDifS-87*iDiaToSeg+iFasesSeg);

      } else {
         iPing      = Number(-87*iDiaToSeg+iFasesSeg);
      }

      flPing();

   } else {
      flSetAllCurvas();
      flSetDetalhes();
   }
}

/*
//fogo               Jan     Fev     Mar     Abr     Mai     Jun     Jul     Ago     Set     Out     Nov     Dez
aTabHrsCores.push(['05:25','05:46','06:03','06:16','06:28','06:42','06:50','06:43','06:19','05:48','05:22','05:12']);  //  0   // incio do dia - nascer do sol

//agua
aTabHrsCores.push(['18:58','18:56','18:37','18:07','17:41','17:29','17:32','17:45','18:57','18:06','18:21','18:41']);  // 12   // incio da noite - por do sol
*/

function fjNoiteDia(psMes,psHor,psMin) {
////////////////////////////////////////
   var jMes  = psMes*1-1;
   var sHrM  = psHor+':'+psMin;
   var sHM0  = aTabHrsCores[ 0][jMes];   // incio manh
   var sHM12 = aTabHrsCores[12][jMes];   // incio noite

   if ((sHrM>=sHM0) && (sHrM<sHM12)) var jRet=1;   //  de dia
   else                              var jRet=0;   //  de noite

//console.log('psMes='+psMes+', psHor='+psHor+', psMin='+psMin+', jMes='+jMes+', sHrM='+sHrM+', sHM0='+sHM0+', sHM12='+sHM12+', jRet='+jRet);
   return (jRet);
}

function fjSeta21Dias(psZd,psZd21) {   // aEf21[global_iMapaPasso-5][2],sXX2 -> jRet - [0] desce, [1] sobe
////////////////////////////////////
   // sequencia -> terra - fogo - gua - ar
   var jRet  = 0;   // default = descer
   var sGr   = psZd.substr(0,2);
   var sZd   = psZd.substr(2,2);
   var sMi   = psZd.substr(4,2);
   var sGr21 = psZd21.substr(0,2);
   var sZd21 = psZd21.substr(2,2);
   var sMi21 = psZd21.substr(4,2);
   
   var sGM   = sGr+':'+sMi;
   var sGM21 = sGr21+':'+sMi21;

   if (sZd==sZd21) {
      if (sGM21>=sGM) jRet=1;
//console.log('a) sZd='+sZd+', sZd21='+sZd21+', sGr21='+sGr21+', sGr='+sGr+', jRet='+jRet+', sGM21='+sGM21+', sGM='+sGM);
   } else {   // regra fogo->terra ou ar->gua = desce, terra->ar (sobe), gua->fogo (ver o grau)
      var jZd   = aZodEle[aSZod.indexOf(sZd)];     // 0-fogo, 1-agua, 2-terra, 3-ar
      var jZd21 = aZodEle[aSZod.indexOf(sZd21)];   // 0-fogo, 1-agua, 2-terra, 3-ar

      if (jZd==0) {                   // est em fogo
         if (jZd21==0) {              // foi pra fogo - ver os graus
            if (sGM21>=sGM) jRet=1;
         } else if (jZd21==1) {       // foi pra terra - desce
            // mantm default
         } else if (jZd21==2) {       // foi pra gua - sobe, ver os graus (em caso de gemoes)
            //if (sGM21>=sGM) jRet=1;
            jRet=1;
         } else {                     // foi pro ar - sobe
            jRet=1;
         }

      } else if (jZd==1) {            // se est em terra
         if (jZd21==0) {              // foi pra fogo - sobe
            jRet=1;
         } else if (jZd21==1) {       // foi pra terra - ver os graus
            if (sGM21>=sGM) jRet=1;
         } else if (jZd21==2) {       // foi pra gua - sobe
            jRet=1;
         } else {                     // foi pro ar - sobe
            jRet=1;
         }

      } else if (jZd==2) {            // se est em gua 
         if (jZd21==0) {              // foi pra fogo - desce, ver os graus (em caso de gemoes)
            // if (sGM21>=sGM) jRet=1;
            // mantm default
         } else if (jZd21==1) {       // foi pra terra - desce
            // mantm default
         } else if (jZd21==2) {       // foi pra gua - ver os graus
            if (sGM21>=sGM) jRet=1;
         } else {                     // foi pro ar - sobe
            jRet=1;
         }
      } else if (jZd==3) {            // est em ar
         if (jZd21==0) {              // foi pra fogo - desce
            // mantm default
         } else if (jZd21==1) {       // foi pra terra - desce
            // mantm default
         } else if (jZd21==2) {       // foi pra gua - desce
            // mantm default
         } else {                     // foi pro ar - ver os graus
            if (sGM21>=sGM) jRet=1;
         }
      }
//console.log('b) sZd='+sZd+', sZd21='+sZd21+', sGr21='+sGr21+', sGr='+sGr+', jZd='+jZd+', jRet='+jRet+', sGM21='+sGM21+', sGM='+sGM);
   }
   return jRet;
}
function flSetDetalhes() {
//////////////////////////
   document.getElementById( '0x0').innerHTML='Chacra';
   document.getElementById( '1x0').innerHTML='Data e Hora';
   document.getElementById( '2x0').innerHTML='Fase Lua';
   document.getElementById( '3x0').innerHTML='Sol';
   document.getElementById( '4x0').innerHTML='Atomico';
   document.getElementById( '5x0').innerHTML='Posicao';
   document.getElementById( '6x0').innerHTML='21 Dias';
   document.getElementById( '7x0').innerHTML='Posicao';
   document.getElementById( '8x0').innerHTML='Ativo';
   document.getElementById( '9x0').innerHTML='Posicao';
   document.getElementById('10x0').innerHTML='21 Dias';
   document.getElementById('11x0').innerHTML='Posicao';
   document.getElementById('12x0').innerHTML='Passivo';
   document.getElementById('13x0').innerHTML='Posicao';
   document.getElementById('14x0').innerHTML='21 Dias';
   document.getElementById('15x0').innerHTML='Posicao';
   document.getElementById('16x0').innerHTML='Lat';
   document.getElementById('17x0').innerHTML='Long';
   document.getElementById('18x0').innerHTML='Fuso';

   for (var i=0; i<=18; i++) {
      for (var j=1; j<=4; j++) {
         document.getElementById(i+'x'+j).innerHTML=aDetalhes[i][j-1];
      }
   }

   // Setas
   document.getElementById( 5+'x'+1).innerHTML+=aDetalhes[19][0]==0 ? '<b>&nbsp;&darr;</b>' : '<b>&nbsp;&uarr;</b>';   // ori - atmico
   document.getElementById( 9+'x'+1).innerHTML+=aDetalhes[20][0]==0 ? '<b>&nbsp;&darr;</b>' : '<b>&nbsp;&uarr;</b>';   // ori - ativo
   document.getElementById(13+'x'+1).innerHTML+=aDetalhes[21][0]==0 ? '<b>&nbsp;&darr;</b>' : '<b>&nbsp;&uarr;</b>';   // ori - passivo

   document.getElementById( 5+'x'+2).innerHTML+=aDetalhes[19][1]==0 ? '<b>&nbsp;&darr;</b>' : '<b>&nbsp;&uarr;</b>';   // cor - atmico
   document.getElementById( 9+'x'+2).innerHTML+=aDetalhes[20][1]==0 ? '<b>&nbsp;&darr;</b>' : '<b>&nbsp;&uarr;</b>';   // cor - ativo
   document.getElementById(13+'x'+2).innerHTML+=aDetalhes[21][1]==0 ? '<b>&nbsp;&darr;</b>' : '<b>&nbsp;&uarr;</b>';   // cor - passivo

   document.getElementById( 5+'x'+3).innerHTML+=aDetalhes[19][2]==0 ? '<b>&nbsp;&darr;</b>' : '<b>&nbsp;&uarr;</b>';   // per - atmico
   document.getElementById( 9+'x'+3).innerHTML+=aDetalhes[20][2]==0 ? '<b>&nbsp;&darr;</b>' : '<b>&nbsp;&uarr;</b>';   // per - ativo
   document.getElementById(13+'x'+3).innerHTML+=aDetalhes[21][2]==0 ? '<b>&nbsp;&darr;</b>' : '<b>&nbsp;&uarr;</b>';   // per - passivo

   document.getElementById( 5+'x'+4).innerHTML+=aDetalhes[19][3]==0 ? '<b>&nbsp;&darr;</b>' : '<b>&nbsp;&uarr;</b>';   // cen - atmico
   document.getElementById( 9+'x'+4).innerHTML+=aDetalhes[20][3]==0 ? '<b>&nbsp;&darr;</b>' : '<b>&nbsp;&uarr;</b>';   // cen - ativo
   document.getElementById(13+'x'+4).innerHTML+=aDetalhes[21][3]==0 ? '<b>&nbsp;&darr;</b>' : '<b>&nbsp;&uarr;</b>';   // cen - passivo

   for (var i=0; i<iTotEl; i++) {
      document.getElementById('polo_txt_'+i).innerHTML=aPoloGr[i];
      document.getElementById('cor_rect_'+i).setAttribute('style', "stroke:#000000; stroke-width: 1; fill:"+aPoloCr[i]+";");
      document.getElementById('polo_Seta1_'+i).setAttribute('style',"display:;");
      document.getElementById('polo_Seta2_'+i).setAttribute('style',"display:none;");
      document.getElementById('polo_Seta3_'+i).setAttribute('style',"display:none;");
      document.getElementById('polo_Seta4_'+i).setAttribute('style',"display:none;");
      document.getElementById('polo_Seta5_'+i).setAttribute('style',"display:none;");
      if (aPoloSt[i]==0) {
         document.getElementById('polo_Seta4_'+i).setAttribute('style',"display:;");
         document.getElementById('polo_Seta5_'+i).setAttribute('style',"display:;");
      } else {
         document.getElementById('polo_Seta2_'+i).setAttribute('style',"display:;");
         document.getElementById('polo_Seta3_'+i).setAttribute('style',"display:;");
      }

   }

   document.getElementById('table_Detalhes').style.display='';

}

function faSeqPla(piPlaZod) {
/////////////////////////////
   for (var i=0; i<4; i++) {
      for (var j=0; j<3; j++) if (aIrmaos[i][j]==piPlaZod) break;
      if (j<3) break;
   }
   
   var aRet = new Array();
   aRet.push(piPlaZod);
   if (j==0) {
      aRet.push(aIrmaos[i][1]);
      aRet.push(aIrmaos[i][2]);
   } else if (j==1) {
      aRet.push(aIrmaos[i][2]);
      aRet.push(aIrmaos[i][0]);
   } else {
      aRet.push(aIrmaos[i][0]);
      aRet.push(aIrmaos[i][1]);
   }
   return aRet;
}

function foCreateReq() {
////////////////////////
   var oReq;
   try {
      oReq = new XMLHttpRequest();
   } catch(e) {
      try {
         oReq = new ActiveXObject("Msxm12.XMLHTTP");
      } catch(e) {
         try {
            oReq = new ActiveXObject("Microsoft.XMLHTTP");
         } catch(e) {
            oReq = null;
         }
      }
   }
   if (oReq==null) alert("Erro criando oReq");
   return(oReq);
}

function flSetAllCurvas() {
///////////////////////////
   for (var i=0; i<12; i++) for (var j=0; j<12; j++) flResetCurvas(i,j);
   for (var i in aPosicao)  for (var j in aPosicao) if (aConexao[i]==aPosicao[j]) flSetCurvas(i,j);
   return (true);
}

function flSetCurvas(piPoloI,piPoloF) {
////////////////////////////////////////
   if (piPoloF>=0) {
      var oCurve = document.getElementById('Curva ' + piPoloI + 'x' + piPoloF);
      oCurve.setAttribute('stroke-width', '1');
      oCurve.setAttribute('stroke',aCores[fiEfeToRel(aPosicao[piPoloI])]);
   }
   return true;
}

function flResetCurvas(piPoloI,piPoloF) {
/////////////////////////////////////////
   var oCurve = document.getElementById('Curva ' + piPoloI + 'x' + piPoloF);
   oCurve.setAttribute('stroke-width', '0');
   return true;
}

function flSetCurvas2(piPoloI,piPoloF) {
///////////////////////////////////////
/*
   if (aPolo[piPoloI]>=0) {
      var oCurve = document.getElementById('Curva ' + piPoloI + 'x' + aPolo[piPoloI]);
      oCurve.setAttribute('stroke-width', '0');
   }

   aPolo[piPoloI] = piPoloF;
   var oCurve = document.getElementById('Curva ' + piPoloI + 'x' + aPolo[piPoloI]);
   oCurve.setAttribute('stroke-width', '1');
*/
   var sTd = aEf[piPoloI+1].replace(aSZod[aElZod.indexOf(piPoloF)],aSigColor[aElZod.indexOf(piPoloF)]);
   document.getElementById('td_'+aPla3[piPoloI]).innerHTML = sTd;
   return true;
}

function flValidarCampos() {
////////////////////////////
   var sLat = document.getElementById("txt_Lat").value;
   var sLon = document.getElementById("txt_Lon").value;
   var sFHr = document.getElementById("txt_FHr").value;

//console.log('sLat='+sLat+', sLon='+sLon+', sFHr='+sFHr);

   aMsgLat = new Array();
   aMsgLat.push('O campo [Latitude] deve ser preenchido corretamente');
   
   if (sLat.indexOf(',')>=0)                      aMsgLat.push(' - Use o "." como separador decimal');
   if (sLat.length==0)                            aMsgLat.push(' - Informe um numero entre -90 e 90 graus');
   if ((sLat*1<-90)||(sLat*1>90) || isNaN(sLat))  aMsgLat.push(' - Deve ser um numero entre -90 e 90 graus');

   aMsgLon = new Array();
   aMsgLon.push('O campo [Longitude] deve ser preenchido corretamente');
   if (sLon.indexOf(',')>=0)                      aMsgLon.push(' - Use o "." como separador decimal');
   if (sLon.length==0)                            aMsgLon.push(' - Informe um numero entre -180 e 180 graus');
   if ((sLon*1<-90)||(sLon*1>90) || isNaN(sLon))  aMsgLon.push(' - Deve ser um numero entre -180 e 180 graus');

   aMsgFHr = new Array();
   aMsgFHr.push('O campo [Fuso Horario] deve ser preenchido corretamente');
   if (sFHr.indexOf(',')>=0)                      aMsgFHr.push(' - Use o "." como separador decimal');
   if (sFHr.length==0)                            aMsgFHr.push(' - Informe um numero entre -12 e 12 horas');
   if ((sFHr*1<-12)||(sFHr*1>12) || isNaN(sFHr))  aMsgFHr.push(' - Deve ser um numero entre -12 e 12 horas');

   var sRet = '';
   if (aMsgLat.length>1) sRet += aMsgLat.join(String.fromCharCode(10))+String.fromCharCode(10);
   if (aMsgLon.length>1) sRet += aMsgLon.join(String.fromCharCode(10))+String.fromCharCode(10);
   if (aMsgFHr.length>1) sRet += aMsgFHr.join(String.fromCharCode(10))+String.fromCharCode(10);

   if (sRet.length==0) {
      global_iLat = sLat;
      global_iLon = sLon;
      global_iFHr = sFHr;
      if (global_jTipo==0) flIrParaData();
      else                 flCalcularCarta();
   } else alert (sRet);

   return true;
}

function flTrataNot9Meses(poCheck) {
////////////////////////////////////
   //alert(poCheck.checked);
   if (poCheck.checked) {
      document.getElementById('span_DataNasPre').style.display='';
      document.getElementById('span_SemPre').style.display='';
      document.getElementById('sel_DiasPre').style.display='';
      document.getElementById('sel_MesesPre').style.display='';
      document.getElementById('sel_AnosPre').style.display='';
      document.getElementById('sel_HorPre').style.display='';
      document.getElementById('sel_MinPre').style.display='';
      document.getElementById('span_2PontosB').style.display='';
   } else {
      document.getElementById('span_DataNasPre').style.display='none';
      document.getElementById('span_SemPre').style.display='none';
      document.getElementById('sel_DiasPre').style.display='none';
      document.getElementById('sel_MesesPre').style.display='none';
      document.getElementById('sel_AnosPre').style.display='none';
      document.getElementById('sel_HorPre').style.display='none';
      document.getElementById('sel_MinPre').style.display='none';
      document.getElementById('span_2PontosB').style.display='none';
   }
}
</script>
</head>


<body onload='flOnLoad();'>
<center>
<input id='input_Voltar'   type="button" value="Voltar"         onclick="global_jStatus=-1; flPing();">
<input id='input_Parar'    type="button" value="Parar"          onclick="global_jStatus= 0;">
<input id='input_Avancar'  type="button" value="Avan&ccedil;ar" onclick="global_jStatus= 1; flPing();">
<br>
<input id='input_Menos1D'  type="button" value="-  1 dia" onclick="iPing=-iDiaToSeg; flPing();">
<input id='input_Mais1D'   type="button" value="+  1 dia" onclick="iPing= iDiaToSeg; flPing();">

<input id='input_Menos21D' type="button" value="- 21 dias" onclick="iPing=-21*iDiaToSeg; flPing();">
<input id='input_Mais21D'  type="button" value="+ 21 dias" onclick="iPing= 21*iDiaToSeg; flPing();">

<input id='input_Menos87D' type="button" value="- 87 dias" onclick="iPing=-87*iDiaToSeg; flPing();">
<input id='input_Mais87D'  type="button" value="+ 87 dias" onclick="iPing= 87*iDiaToSeg; flPing();">

<input id='input_Menos1H'  type="button" value="- 1 hora" onclick="iPing=-iHorToSeg; flPing();">
<input id='input_Mais1H'   type="button" value="+ 1 hora" onclick="iPing= iHorToSeg; flPing();">

<input id='input_Menos9H'  type="button" value="- 9 horas" onclick="iPing=-9*iHorToSeg; flPing();">
<input id='input_Mais9H'   type="button" value="+ 9 horas" onclick="iPing= 9*iHorToSeg; flPing();">


<br>
<span id='span_DataNas'>Data de Nascimento:</span>
<span id='span_DataCeu'>Data:</span>
<span id='span_Sem' style='font-family: verdana; font-size: 10px;'></span>
<select id="sel_Dias">
   <option value="01">01</option>
   <option value="02">02</option>
   <option value="03">03</option>
   <option value="04">04</option>
   <option value="05">05</option>
   <option value="06">06</option>
   <option value="07">07</option>
   <option value="08">08</option>
   <option value="09">09</option>
   <option value="10">10</option>
   <option value="11">11</option>
   <option value="12">12</option>
   <option value="13">13</option>
   <option value="14">14</option>
   <option value="15">15</option>
   <option value="16">16</option>
   <option value="17">17</option>
   <option value="18">18</option>
   <option value="19">19</option>
   <option value="20">20</option>
   <option value="21">21</option>
   <option value="22">22</option>
   <option value="23">23</option>
   <option value="24">24</option>
   <option value="25">25</option>
   <option value="26">26</option>
   <option value="27">27</option>
   <option value="28">28</option>
   <option value="29">29</option>
   <option value="30">30</option>
   <option value="31">31</option>
</select> 

<select id="sel_Meses">
   <option value="01">Janeiro</option>
   <option value="02">Fevereiro</option>
   <option value="03">Mar&ccedil;o</option>
   <option value="04">Abril</option>
   <option value="05">Maio</option>
   <option value="06">Junho</option>
   <option value="07">Julho</option>
   <option value="08">Agosto</option>
   <option value="09">Setembro</option>
   <option value="10">Outubro</option>
   <option value="11">Novembro</option>
   <option value="12">Dezembro</option>
</select> 

<select id="sel_Anos">

<?php
for ($i=1920; $i<=2100; $i++) echo "<option value='$i'>$i</option>";
?>
</select>

&nbsp;

<select id="sel_Hor">
   <option value="00">00</option>
   <option value="01">01</option>
   <option value="02">02</option>
   <option value="03">03</option>
   <option value="04">04</option>
   <option value="05">05</option>
   <option value="06">06</option>
   <option value="07">07</option>
   <option value="08">08</option>
   <option value="09">09</option>
   <option value="10">10</option>
   <option value="11">11</option>
   <option value="12">12</option>
   <option value="13">13</option>
   <option value="14">14</option>
   <option value="15">15</option>
   <option value="16">16</option>
   <option value="17">17</option>
   <option value="18">18</option>
   <option value="19">19</option>
   <option value="20">20</option>
   <option value="21">21</option>
   <option value="22">22</option>
   <option value="23">23</option>
</select> 
<span id='span_2PontosA'>:</span>
<select id="sel_Min">
   <option value="00">00</option>
   <option value="01">05</option>
   <option value="02">10</option>
   <option value="03">15</option>
   <option value="04">20</option>
   <option value="05">25</option>
   <option value="06">30</option>
   <option value="07">35</option>
   <option value="08">40</option>
   <option value="09">45</option>
   <option value="10">50</option>
   <option value="11">55</option>
</select> 

<br>
<br>
<span id='span_MensNasc'>Nascimento nao foi de 9 meses</span>
<input id='input_Not9Meses' type='checkbox' onchange='flTrataNot9Meses(this);'/>
<br>
<span id='span_DataNasPre'>Data Prevista:</span>
<span id='span_SemPre' style='font-family: verdana; font-size: 10px;'></span>
<select id='sel_DiasPre'>
   <option value="01">01</option>
   <option value="02">02</option>
   <option value="03">03</option>
   <option value="04">04</option>
   <option value="05">05</option>
   <option value="06">06</option>
   <option value="07">07</option>
   <option value="08">08</option>
   <option value="09">09</option>
   <option value="10">10</option>
   <option value="11">11</option>
   <option value="12">12</option>
   <option value="13">13</option>
   <option value="14">14</option>
   <option value="15">15</option>
   <option value="16">16</option>
   <option value="17">17</option>
   <option value="18">18</option>
   <option value="19">19</option>
   <option value="20">20</option>
   <option value="21">21</option>
   <option value="22">22</option>
   <option value="23">23</option>
   <option value="24">24</option>
   <option value="25">25</option>
   <option value="26">26</option>
   <option value="27">27</option>
   <option value="28">28</option>
   <option value="29">29</option>
   <option value="30">30</option>
   <option value="31">31</option>
</select> 

<select id='sel_MesesPre'>
   <option value="01">Janeiro</option>
   <option value="02">Fevereiro</option>
   <option value="03">Mar&ccedil;o</option>
   <option value="04">Abril</option>
   <option value="05">Maio</option>
   <option value="06">Junho</option>
   <option value="07">Julho</option>
   <option value="08">Agosto</option>
   <option value="09">Setembro</option>
   <option value="10">Outubro</option>
   <option value="11">Novembro</option>
   <option value="12">Dezembro</option>
</select> 

<select id='sel_AnosPre'>

<?php
for ($i=1920; $i<=2100; $i++) echo "<option value='$i'>$i</option>";
?>
</select>

&nbsp;

<select id='sel_HorPre'>
   <option value="00">00</option>
   <option value="01">01</option>
   <option value="02">02</option>
   <option value="03">03</option>
   <option value="04">04</option>
   <option value="05">05</option>
   <option value="06">06</option>
   <option value="07">07</option>
   <option value="08">08</option>
   <option value="09">09</option>
   <option value="10">10</option>
   <option value="11">11</option>
   <option value="12">12</option>
   <option value="13">13</option>
   <option value="14">14</option>
   <option value="15">15</option>
   <option value="16">16</option>
   <option value="17">17</option>
   <option value="18">18</option>
   <option value="19">19</option>
   <option value="20">20</option>
   <option value="21">21</option>
   <option value="22">22</option>
   <option value="23">23</option>
</select> 
<span id='span_2PontosB'>:</span>
<select id='sel_MinPre'>
   <option value="00">00</option>
   <option value="01">05</option>
   <option value="02">10</option>
   <option value="03">15</option>
   <option value="04">20</option>
   <option value="05">25</option>
   <option value="06">30</option>
   <option value="07">35</option>
   <option value="08">40</option>
   <option value="09">45</option>
   <option value="10">50</option>
   <option value="11">55</option>
</select> 

<br>
<br>
Latitude:     <input type="text" id="txt_Lat" style="font-family: verdana; font-size: 12px; width: 70px;" value="-23.1865"/>
Longitude:    <input type="text" id="txt_Lon" style="font-family: verdana; font-size: 12px; width: 70px;" value="-46.8845"/>
Fuso Horario: <input type="text" id="txt_FHr" style="font-family: verdana; font-size: 12px; width: 50px;" value="-3"/>

<input id='btn_Ir'        type="button" value="Ir"             onclick="global_jStatus=0; flValidarCampos();">
<input id='btn_CalcCarta' type="button" value="Calcular Carta" onclick="global_jStatus=0; global_iMapaPasso=0; flValidarCampos();">
<br>
<span id='span_FaseLua'></span>
<span id='span_FaseLuaPNG'></span>
<br>
<table id='table_graus' style='font-family: Verdana; font-size: 10px;'>
<tr><td>Sol</td><td id='td_sun'></td>
    <td>Lua</td><td id='td_moo'></td>
    <td>Mer</td><td id='td_mer'></td>
    <td>Ven</td><td id='td_ven'></td>
    <td>Mar</td><td id='td_mar'></td>
    <td>   </td><td id='td_XXX'></td></tr>

<tr><td>Jup</td><td id='td_jup'></td>
    <td>Sat</td><td id='td_sat'></td>
    <td>Ura</td><td id='td_ura'></td>
    <td>Net</td><td id='td_nep'></td>
    <td>Plu</td><td id='td_plu'></td>
    <td>Eln</td><td id='td_eln'></td></tr>

</table> 
<table>
<tr>
<td>
<table id='table_Detalhes' style='font-family: Verdana; font-size: 10px;'>
<tr style='background-color: #aaaaaa;'><td id= '0x0'></td><td id= '0x1'><td id= '0x2'><td id= '0x3'><td id= '0x4'></td></tr>
<tr style='background-color: #eeeeee;'><td id= '1x0'></td><td id= '1x1'><td id= '1x2'><td id= '1x3'><td id= '1x4'></td></tr>
<tr style='background-color: #eeeeee;'><td id= '2x0'></td><td id= '2x1'><td id= '2x2'><td id= '2x3'><td id= '2x4'></td></tr>
<tr style='background-color: #eeeeee;'><td id= '3x0'></td><td id= '3x1'><td id= '3x2'><td id= '3x3'><td id= '3x4'></td></tr>
<tr style='background-color: #cccccc;'><td id= '4x0'></td><td id= '4x1'><td id= '4x2'><td id= '4x3'><td id= '4x4'></td></tr>
<tr style='background-color: #cccccc;'><td id= '5x0'></td><td id= '5x1'><td id= '5x2'><td id= '5x3'><td id= '5x4'></td></tr>
<tr style='background-color: #cccccc;'><td id= '6x0'></td><td id= '6x1'><td id= '6x2'><td id= '6x3'><td id= '6x4'></td></tr>
<tr style='background-color: #cccccc;'><td id= '7x0'></td><td id= '7x1'><td id= '7x2'><td id= '7x3'><td id= '7x4'></td></tr>
<tr style='background-color: #eeeeee;'><td id= '8x0'></td><td id= '8x1'><td id= '8x2'><td id= '8x3'><td id= '8x4'></td></tr>
<tr style='background-color: #eeeeee;'><td id= '9x0'></td><td id= '9x1'><td id= '9x2'><td id= '9x3'><td id= '9x4'></td></tr>
<tr style='background-color: #eeeeee;'><td id='10x0'></td><td id='10x1'><td id='10x2'><td id='10x3'><td id='10x4'></td></tr>
<tr style='background-color: #eeeeee;'><td id='11x0'></td><td id='11x1'><td id='11x2'><td id='11x3'><td id='11x4'></td></tr>
<tr style='background-color: #cccccc;'><td id='12x0'></td><td id='12x1'><td id='12x2'><td id='12x3'><td id='12x4'></td></tr>
<tr style='background-color: #cccccc;'><td id='13x0'></td><td id='13x1'><td id='13x2'><td id='13x3'><td id='13x4'></td></tr>
<tr style='background-color: #cccccc;'><td id='14x0'></td><td id='14x1'><td id='14x2'><td id='14x3'><td id='14x4'></td></tr>
<tr style='background-color: #cccccc;'><td id='15x0'></td><td id='15x1'><td id='15x2'><td id='15x3'><td id='15x4'></td></tr>
<tr style='background-color: #eeeeee; display:none;'><td id='16x0'></td><td id='16x1'><td id='16x2'><td id='16x3'><td id='16x4'></td></tr>
<tr style='background-color: #eeeeee; display:none;'><td id='17x0'></td><td id='17x1'><td id='17x2'><td id='17x3'><td id='17x4'></td></tr>
<tr style='background-color: #eeeeee; display:none;'><td id='18x0'></td><td id='18x1'><td id='18x2'><td id='18x3'><td id='18x4'></td></tr>
</table>
</td>
<td style='border: 0px solid black;'><svg id="GrafoSvg" width="500" height="500"></svg></td>
</tr></table>
</center>
</body>
</html>