<?php
// https://tiny.com.br/api-docs/api2-produtos-obter

set_time_limit(5*60);   // 5 min
//require_once("../pPublics1.php");
require_once("../../pFuncoes1.php");


$sDSN = '/qtux/database/xecomm/gps_01.gdb';
$hDb  = fhDbConnect($sDSN);

//$sSql = "select iId from xecomm_erpTinyItensSaldos where (sImg='' or sImg is null) and iVer=iVAt";
$sSql = "select iId from xecomm_erpTinyItensSaldos where iVer=iVAt";
$aIds = faDbSelect1D($hDb,$sSql);


$url = 'https://api.tiny.com.br/api2/lista.atualizacoes.estoque';
$token = '299f95ee3215b25ee5a4e1975cdbfdf53e1f2760';
$dataAlteracao = '11/03/2022';   // dd/mm/yyyy hh:mm:ss - Pode ser informado somente a data ou data e hora. Exemplos: 01/01/2011 ou 01/01/2012 15:30:00.
$formato = 'json';   // 'XML';
//$data = "token=$token&dataAlteracao=$dataAlteracao&formato=$formato";

$iItm = 0;
$iPag = 0;
while (true) {
   $iPag++;
   $data = "token=$token&dataAlteracao=$dataAlteracao&formato=$formato&pagina=$iPag";
   $lOk  = flEnviarREST($url, $data);    
   echo "lOk=$lOk, iPag=$iPag, iItm=$iItm".chr(10);
   if ($iItm<100) break;   // Se qtd de itens q veio da consulta menor q o default 100, ento foi a ultima pagina da consulta - var global flEnviarREST
}

if ($lOk) {
   flDbCommit($hDb);
   echo 'commit'.chr(10);
} else {
   flDbRollBack($hDb);
   echo 'rollback'.chr(10);
}
flDbDisconnect($hDb);


function flEnviarREST($url, $data, $optional_headers = null) {
//////////////////////////////////////////////////////////////
 global $aIds;
 global $iItm;
 global $hDb;
 $lOk = true;

 $params = array('http' => array(
   'method' => 'POST',
     'content' => $data
 ));
 
 if ($optional_headers !== null) {
   $params['http']['header'] = $optional_headers;
 }
 
 $ctx = stream_context_create($params);
 $fp = @fopen($url, 'rb', false, $ctx);
 if (!$fp) {
   throw new Exception("Problema com $url, $php_errormsg");
 }
 $response = @stream_get_contents($fp);
 if ($response === false) {
   throw new Exception("Problema obtendo retorno de $url, $php_errormsg");
 }
 
 //echo $response; 

 $oJSON = json_decode($response);

 $aItm = $oJSON->retorno->produtos;
 $iLoopIns = 0;
 $iLoopUpd = 0;
 foreach ($aItm as $oItm) {
   
   $iId   = $oItm->produto->id;
   $sCItm = $oItm->produto->codigo;
   $sItm  = utf8_decode($oItm->produto->nome);
   $sUni  = $oItm->produto->unidade;
   $nSdo  = $oItm->produto->saldo;
   $nRes  = $oItm->produto->saldoReservado; 
   $nDis  = $nSdo-$nRes;

   //echo "iId   = $iId"  .chr(10);
   //echo "sCItm = $sCItm".chr(10);
   //echo "sItm  = $sItm" .chr(10);
   //echo "sUni  = $sUni" .chr(10);

   //echo "nSdo  = $nSdo" .chr(10);
   //echo "nRes  = $nRes" .chr(10);
   //echo "nDis  = $nDis" .chr(10);

   //echo '--'.chr(10);


   if (in_array($iId,$aIds)==false) {
      $aIds[] = $iId;

      $aIns   = array();
      $aIns[] = array('iId'   , $iId  );
      $aIns[] = array('sCItm' , $sCItm);
      $aIns[] = array('sItm'  , $sItm );
      $aIns[] = array('sUni'  , $sUni );
      $aIns[] = array('nSdo'  , $nSdo );
      $aIns[] = array('nRes'  , $nRes );
      $sSql = fsArrToInsert('xecomm_erpTinyItensSaldos',$aIns);
      $lOk  = flDbInsert($hDb,$sSql);
      $iLoopIns++;
   } else {
      $sSql = "update xecomm_erpTinyItensSaldos set nSdo=$nSdo, nRes=$nRes where iId=$iId and iVer=iVAt";
      $lOk = flDbUpdate($hDb,$sSql);
      $iLoopUpd++;
   }
   echo $sSql.chr(10);
   echo "lOk=$lOk".chr(10);
   if ($lOk==false) break;

 }

 echo 'Total Inserts='.$iLoopIns.chr(10);
 echo 'Total Updates='.$iLoopUpd.chr(10);
 $iItm = $iLoopIns+$iLoopUpd;
 return $lOk;
 // echo "iItm=$iItm".chr(10);
 //return $response;
}
