<?php

$iTime = time();

include('../../pFuncoes1.php');
include('../../pPublics1.php');


$pRep     = 133;   // $pLogin;
$pDestDef = 36669;


$sDSN = '/qtux/database/tq/gps_01.gdb';   // sCliPasta
$hDb  = fhDbConnect($sDSN);


// (A) - PRepUNeg -> Emissores e Destinatrios por Emissor
// -------------------------------------------------------
$sSql     = "select a.pEmi,a.pDest,a.jTpLiP from PRepUNeg a where a.pRep=$pRep and a.iVer=a.iVAt and a.lExc=0 and a.jTipo=1 group by a.pEmi,a.pDest,a.jTpLiP";   // o group by  reduntante, s para garantir
//echo "Qry PRepUNeg";
$aDb      = faDbSelect($hDb,$sSql);
$aE       = array();   // $aE = {pEmi}
$aD       = array();   // $aD = {pDest}
$aED      = array();   // $aED[$pEmi] = {$pDest} - todos os destinatrios de cada emissor
$aED_TpLP = array();   // $aED_TpLP[$pEmi][$pDest] = $jTpLP;
$iLoop    = 0;
foreach ($aDb as $aLin) {
   $pEmi  = $aLin[0];
   $pDest = $aLin[1]; 
   $jTpLP = $aLin[2];
   if (in_array($pEmi ,$aE)==false) $aE[] = $pEmi;
   if (in_array($pDest,$aD)==false) $aD[] = $pDest;
   if (isset($aED[$pEmi])  ==false) $aED[$pEmi] = array();
   $aED[$pEmi][] = $pDest;

   if (isset($aED_TpLP[$pEmi]        )  ==false) $aED_TpLP[$pEmi]         = array();
   if (isset($aED_TpLP[$pEmi][$pDest])  ==false) $aED_TpLP[$pEmi][$pDest] = $jTpLP;
   $iLoop++;
}
//echo " --> total de ($iLoop) registros".chr(10);
$sInE = implode(',',$aE);
$sInD = implode(',',$aD);

// (B) - Cadastro de Emissores
// ---------------------------
$sSql   = "select a.pPId,a.sCoringa,a.sSigla,a.sCNPJ,a.jEnderEmit_CRT,b.nImpPFlex from CUP a join CUP b on a.pUCorp=b.pPId and b.iVer=b.iVAt where a.pPId in ($sInE) and a.iVer=a.iVAt and a.lExc=0";
//echo "Qry CUP Emissores";
$aDb    = faDbSelect($hDb,$sSql);
$aCadE  = array();   // $aCadE[$pEmi]   = array('sNome'=>$sNome,'sSigla'=>$sSigla,'sCNPJ'=>$sCNPJ,'jEnderEmit_CRT'=>$jEnderEmit_CRT);
$iLoop    = 0;
foreach ($aDb as $aLin) {
   $pEmi           = $aLin[0];
   $sNome          = $aLin[1];
   $sSigla         = $aLin[2];
   $sCNPJ          = $aLin[3];
   $jEnderEmit_CRT = $aLin[4];
   $nImpPFlex      = $aLin[5];
   $aCadE[$pEmi]   = array('sNome'=>$sNome,'sSigla'=>$sSigla,'sCNPJ'=>$sCNPJ,'jEnderEmit_CRT'=>$jEnderEmit_CRT,'nImpPFlex'=>$nImpPFlex);
   $iLoop++;
}
//echo " --> total de ($iLoop) registros".chr(10);

// (C) - Cadastro de Destinatrios
// -------------------------------
$sSql   = "select pPId,sCoringa,jTipo,(case when jTipo=0 then sCPF else sCNPJ end),jDest_indIEDest from CUP where pPId in ($sInD) and iVer=iVAt and lExc=0";
//echo "Qry CUP Destinatrios";
$aDb    = faDbSelect($hDb,$sSql);
$aCadD  = array();   // $aCadD[$pDest] = array('sNome'=>$sNome,'jTipo'=>$jTipo,'sDoc'=>$sDoc)
$iLoop    = 0;
foreach ($aDb as $aLin) {
   $pDest           = $aLin[0];
   $sNome           = $aLin[1];
   $jTipo           = $aLin[2]-1;   // (*)
   $sDoc            = $aLin[3];
   $jDest_indIEDest = $aLin[4];
   $aCadD[$pDest] = array('sNome'=>$sNome,'jTipo'=>$jTipo,'sDoc'=>$sDoc,'jDest_indIEDest'=>$jDest_indIEDest);
   $iLoop++;
}
//echo " --> total de ($iLoop) registros".chr(10);

// (D) - Cadastro de Endereos
// ---------------------------
// Emissores
$sSql   = "select a.pPId,a.pCUP,b.sLog,b.sBai,a.sNr,a.sComp,c.sCidade,d.sUF,d.sSigla,c.pUF
           from Enderecos a join CEPs    b on a.pCEP = b.pPId and b.iVer=b.iVAt and b.lExc=0
                            join Cidades c on b.pCid = c.pPId and c.iVer=c.iVAt
                            join UFs     d on c.pUF  = d.pPId and d.iVer=d.iVAt
           where a.pCUP in ($sInE) 
             and a.lUNegPos=1
             and a.iVer=a.iVAt 
             and a.lExc=0";
//echo "Qry CUP Enderecos Emissores";
$aDb    = faDbSelect($hDb,$sSql);
$aEndeE = array();   // $aEndeE[$pCUP] = array('sLog'=>$sLog,'sBai'=>$sBai,'sNr'=>$sNr,'sComp'=>$sComp,'sCid'=>$sCid,'sUF'=>$sUF,'sSigla'=>$sSigla,'pUF'=>$pUF);
$aUFPos = array();
$iLoop    = 0;
foreach ($aDb as $aLin) {
   $pPId     = $aLin[0];
   $pCUP     = $aLin[1];
   $sLog     = $aLin[2];
   $sBai     = $aLin[3];
   $sNr      = $aLin[4];
   $sComp    = $aLin[5];
   $sCid     = $aLin[6];
   $sUF      = $aLin[7];
   $sSigla   = $aLin[8];
   $pUFPos   = $aLin[9];
   if (in_array($pUFPos,$aUFPos)==false) $aUFPos[] = $pUFPos;
   if (isset($aEndeE[$pCUP])==false) $aEndeE[$pCUP] = array('pPId'=>$pPId, 'sLog'=>$sLog, 'sBai'=>$sBai, 'sNr'=>$sNr, 'sComp'=>$sComp, 'sCid'=>$sCid, 'sUF'=>$sUF, 'sSigla'=>$sSigla, 'pUFPos'=>$pUFPos);   // 1 pra 1
   $iLoop++;
}
//echo " --> total de ($iLoop) registros".chr(10);
$sInUFPos = implode(',',$aUFPos);

$aUFDestEnt = array();
// Destinatrios  - Entrega
$sSql   = "select a.pPId,a.pCUP,b.sLog,b.sBai,a.sNr,a.sComp,c.sCidade,d.sUF,d.sSigla,d.lGram,d.nPFCPUFDest,d.nPICMSUFDest,d.nPICMSInterPart,d.nVlMl1,d.nVlMl2,d.nVlMl3,c.pUF
           from Enderecos a join CEPs    b on a.pCEP = b.pPId and b.iVer=b.iVAt and b.lExc=0
                            join Cidades c on b.pCid = c.pPId and c.iVer=c.iVAt
                            join UFs     d on c.pUF  = d.pPId and d.iVer=d.iVAt
           where a.pCUP in ($sInD) 
             and a.lCliEnt=1 
             and a.iVer=a.iVAt 
             and a.lExc=0";
//echo "Qry CUP Enderecos Destinatrios";
$aDb    = faDbSelect($hDb,$sSql);
$aEndeD = array();
$iLoop    = 0;
foreach ($aDb as $aLin) {
   $pPId            = $aLin[ 0];
   $pCUP            = $aLin[ 1];
   $sLog            = $aLin[ 2];
   $sBai            = $aLin[ 3];
   $sNr             = $aLin[ 4];
   $sComp           = $aLin[ 5];
   $sCid            = $aLin[ 6];
   $sUF             = $aLin[ 7];
   $sSigla          = $aLin[ 8];
   $lGram           = $aLin[ 9];
   $nPFCPUFDest     = $aLin[10];
   $nPICMSUFDest    = $aLin[11];
   $nPICMSInterPart = $aLin[12];
   $nVlMl1          = $aLin[13];
   $nVlMl2          = $aLin[14];
   $nVlMl3          = $aLin[15];
   $pUFPos          = 0;
   $pUFEnt          = $aLin[16];
   if (in_array($pUFEnt,$aUFDestEnt)==false) $aUFDestEnt[] = $pUFEnt;

   if (isset($aEndeD[$pCUP])==false) {
      $aEndeD[$pCUP] = array('pPId'=>$pPId, 'sLog'=>$sLog,'sBai'=>$sBai,'sNr'=>$sNr,'sComp'=>$sComp,'sCid'=>$sCid,'sUF'=>$sUF,'sSigla'=>$sSigla,'lGram'=>$lGram,'nPFCPUFDest'=>$nPFCPUFDest,'nPICMSUFDest'=>$nPICMSUFDest,'nPICMSInterPart'=>$nPICMSInterPart,'nVlMl1'=>$nVlMl1,'nVlMl2'=>$nVlMl2,'nVlMl3'=>$nVlMl3,'pUFPos'=>$pUFPos,'pUFEnt'=>$pUFEnt);
   }
   $iLoop++;
}
//echo " --> total de ($iLoop) registros".chr(10);
$sInUFDestEnt = implode(',',$aUFDestEnt);

// Destinatrios  - Postal
$sSql   = "select a.pPId,a.pCUP,b.sLog,b.sBai,a.sNr,a.sComp,c.sCidade,d.sUF,d.sSigla,d.lGram,d.nPFCPUFDest,d.nPICMSUFDest,d.nPICMSInterPart,d.nVlMl1,d.nVlMl2,d.nVlMl3,c.pUF
           from Enderecos a join CEPs    b on a.pCEP = b.pPId and b.iVer=b.iVAt and b.lExc=0
                            join Cidades c on b.pCid = c.pPId and c.iVer=c.iVAt
                            join UFs     d on c.pUF  = d.pPId and d.iVer=d.iVAt
           where a.pCUP in ($sInD) 
             and a.lCliPos=1 
             and a.iVer=a.iVAt 
             and a.lExc=0";
//echo "Qry CUP Enderecos Destinatrios Postal";

$aDb    = faDbSelect($hDb,$sSql);
//$aEndeD = array();
$aUFDestPos = array();
$iLoop    = 0;
foreach ($aDb as $aLin) {
 //$pPId            = $aLin[ 0];
   $pCUP            = $aLin[ 1];
 //$sLog            = $aLin[ 2];
 //$sBai            = $aLin[ 3];
 //$sNr             = $aLin[ 4];
 //$sComp           = $aLin[ 5];
 //$sCid            = $aLin[ 6];
 //$sUF             = $aLin[ 7];
 //$sSigla          = $aLin[ 8];
 //$lGram           = $aLin[ 9];
 //$nPFCPUFDest     = $aLin[10];
 //$nPICMSUFDest    = $aLin[11];
 //$nPICMSInterPart = $aLin[12];
 //$nVlMl1          = $aLin[13];
 //$nVlMl2          = $aLin[14];
 //$nVlMl3          = $aLin[15];
   $pUFPos          = $aLin[16];

   if (in_array($pUFPos,$aUFDestPos)==false) $aUFDestPos[] = $pUFPos;

   if (isset($aEndeD[$pCUP])==true) $aEndeD[$pCUP]['pUFPos'] = $pUFPos;   // meio reduntante todos os campos nesse 2o loop para os endereos postais
   $iLoop++;
}
//echo " --> total de ($iLoop) registros".chr(10);
$sInUFDestPos = implode(',',$aUFDestPos);

// (E) - Cadastro de Tipos de Operao do TotalNet
// -----------------------------------------------
$sSql    = "select pPId,sCodigo,sDescricao,lBonif,lFinanc,lDevoluc from TOper where lESalles=1 and iVer=iVAt and lExc=0 and jTipo=1";
//echo "Qry Tipos de Operao";
$aDb     = faDbSelect($hDb,$sSql);
$aTOper  = array();
$aCadTOper = array();   // $aCadTOper[$pTOper] = array($sCTOper,$sTOper);
$iLoop    = 0;
foreach ($aDb as $aLin) {
   $pTOper   = $aLin[0];
   $sCTOper  = $aLin[1];
   $sTOper   = $aLin[2];
   $lBonif   = $aLin[3];
   $lFinanc  = $aLin[4];
   $lDevoluc = $aLin[5];
   $aTOper[] = $pTOper;
   $aCadTOper[$pTOper] = array('sCTOper'=>$sCTOper,'sTOper'=>$sTOper,'lBonif'=>$lBonif,'lFinanc'=>$lFinanc,'lDevoluc'=>$lDevoluc);
   $iLoop++;
}
//echo " --> total de ($iLoop) registros".chr(10);
$sInTOper = implode(',',$aTOper);


// (F) - Emissor, Destinatrio, TOper + Parametros
// -----------------------------------------------
$aTOpED  = array();
foreach ($aED as $pEmi=>$aDest) {   // $aED[$pEmi] = {$pDest}
   $sInDest = implode(',',$aDest);
   if (isset($aTOpED[$pEmi])==false) $aTOpED[$pEmi] = array();

   $sSql = "select a.pPId,a.pDest,a.pTOper,a.lZFM,a.jIDE_IndFinal,a.nPEncFinTpED,a.nPDescLog
            from PTOpED a
            where a.lExc=0 
              and a.iVer=a.iVAt
              and a.pEmi  = $pEmi
              and a.pDest  in ($sInDest) 
              and a.pTOper in ($sInTOper)
           ";

   //echo "Qry PTOpED pEmi=$pEmi";
   $aDb  = faDbSelect($hDb,$sSql);
   $iLoop    = 0;
   foreach ($aDb as $aLin) {
      $pPId          = $aLin[0];
      $pDest         = $aLin[1];
      $pTOper        = $aLin[2];
      $lZFM          = $aLin[3];
      $jIDE_IndFinal = $aLin[4];
      $nPEncFinTpED  = $aLin[5];
      $nPDescLog     = $aLin[6];
      $jTpLP         = isset($aED_TpLP[$pEmi][$pDest]) ? $aED_TpLP[$pEmi][$pDest] : 0;   // se nao acho a lista uso 0 como default, isso nunca vai acontecer mas  uma precauo de programao

      if (isset($aTOpED [$pEmi][$pDest])         ==false) $aTOpED [$pEmi][$pDest]          = array();
//echo "pEmi=$pEmi, pDest=$pDest, pTOper=$pTOper, nPDescLog=$nPDescLog".chr(10);
      if (isset($aTOpED [$pEmi][$pDest][$pTOper])==false) $aTOpED [$pEmi][$pDest][$pTOper] = array('pPId'=>$pPId, 'lZFM'=>$lZFM, 'jIDE_IndFinal'=>$jIDE_IndFinal, 'nPEncFinTpED'=>$nPEncFinTpED, 'nPDescLog'=>$nPDescLog, 'jTpLP'=>$jTpLP);

      $iLoop++;
   }
   //echo " --> total de ($iLoop) registros".chr(10);
}   // for

// (G) - Emissor, Destinatrio, TOper, Itens
// -----------------------------------------
$aItens  = array();
$aTOpEDI = array();   // $aTOpEDI[$pEmi][$pDest][$pTOper] = {$pItem}
$aCPgmto     = array();
$aPED_CPgmt0 = array();
$aPED_CPgmto = array();
foreach ($aED as $pEmi=>$aDest) {   // $aED[$pEmi] = {$pDest}
   $sInDest = implode(',',$aDest);
   if (isset($aTOpEDI[$pEmi])==false) $aTOpEDI[$pEmi] = array();

   // Dest Default
   $sSql = "select b.pPId,a.pTOper,b.pItem,b.nDesc
            from PTOpED a join PTOpED_Item b on a.pPId=b.pPTOpED and b.iVer=b.iVAt and b.lExc=0
            where a.lExc=0 
              and a.iVer=a.iVAt
              and a.pEmi  = $pEmi
              and a.pDest = $pDestDef 
              and a.pTOper in ($sInTOper)
           ";

   //echo "Qry PTOpEDI Default pEmi=$pEmi";
   //echo $sSql.chr(10);
   $aDb  = faDbSelect($hDb,$sSql);
   $iLoop    = 0;
   foreach ($aDb as $aLin) {
      $pPId          = $aLin[0];
      $pTOper        = $aLin[1];
      $pItem         = $aLin[2]; 
      $nPDescTpEDG   = $aLin[3];
      if (in_array($pItem,$aItens)==false) $aItens[] = $pItem;

      if (isset($aTOpEDI[$pEmi][$pDestDef]                 )==false) $aTOpEDI[$pEmi][$pDestDef]                  = array();
      if (isset($aTOpEDI[$pEmi][$pDestDef][$pTOper]        )==false) $aTOpEDI[$pEmi][$pDestDef][$pTOper]         = array();
      if (isset($aTOpEDI[$pEmi][$pDestDef][$pTOper][$pItem])==false) $aTOpEDI[$pEmi][$pDestDef][$pTOper][$pItem] = array();
      $aTOpEDI[$pEmi][$pDestDef][$pTOper][$pItem] = array('pPId'=>$pPId, 'nPDescTpEDG'=>$nPDescTpEDG);


      $iLoop++;
   }
   //echo " --> total de ($iLoop) registros".chr(10);
   
   // Dest da vez
   $sSql = "select a.pDest,a.pTOper,b.pItem,b.nDesc
            from PTOpED a join PTOpED_Item b on a.pPId=b.pPTOpED and b.iVer=b.iVAt and b.lExc=0
            where a.lExc=0 
              and a.iVer=a.iVAt
              and a.pEmi  = $pEmi
              and a.pDest  in ($sInDest) 
              and a.pTOper in ($sInTOper)
           ";

   //echo "Qry PTOpEDI Dest pEmi=$pEmi";
   //echo $sSql.chr(10);
   $aDb  = faDbSelect($hDb,$sSql);
   $iDb  = count($aDb);
   $iLoop = $iDb;
   //echo " --> total de ($iLoop) registros".chr(10);
   if ($iDb==0) {   
   } else {
      foreach ($aDb as $aLin) {
         $pDest         = $aLin[0];
         $pTOper        = $aLin[1];
         $pItem         = $aLin[2];
         $nPDescTpEDG   = $aLin[3];
         if (in_array($pItem,$aItens)==false) $aItens[] = $pItem;
         if (isset($aTOpEDI[$pEmi][$pDest]                 )==false) $aTOpEDI[$pEmi][$pDest]                  = array();
         if (isset($aTOpEDI[$pEmi][$pDest][$pTOper]        )==false) $aTOpEDI[$pEmi][$pDest][$pTOper]         = array();
         if (isset($aTOpEDI[$pEmi][$pDest][$pTOper][$pItem])==false) $aTOpEDI[$pEmi][$pDest][$pTOper][$pItem] = array();
         $aTOpEDI[$pEmi][$pDest][$pTOper][$pItem] = array('pPId'=>$pPId, 'nPDescTpEDG'=>$nPDescTpEDG);
      }
   } 

   // PED -> CPgmto - escalas da liberao de cond pgmto
   $sSql = "select a.pDest,d.sCPgmto,d.nDFin,d.nDMed,d.pPId
            from PED a join PED_FPgmto        b on a.pPId    = b.pPED     and b.iVer=b.iVAt and b.lExc=0
                       join PED_FPgmto_CPgmto c on b.pPId    = c.pPED_FPg and c.iVer=c.iVAt and c.lExc=0
                       join CPgmto            d on c.pCPgmto = d.pPId     and d.iVer=d.iVAt and d.lExc=0
            where a.iVer  = a.iVAt
              and a.lExc  = 0
              and a.lBloq = 0
              and a.jTipo = 1
              and a.pEmi  = $pEmi
              and a.pDest in ($sInDest)
            order by c.lDefault desc, a.pDest


           ";
   //echo "Qry CPgmto pEmi=$pEmi";
   //echo $sSql.chr(10);
   $aDb  = faDbSelect($hDb,$sSql);
   $iLoop    = 0;
   foreach ($aDb as $aLin) {
      $pDest   = $aLin[0];
      $sCPgmto = $aLin[1];
      $nDFin   = $aLin[2];
      $nDMed   = $aLin[3];
      $pCPgmto = $aLin[4];
//echo "nDFin=$nDFin".chr(10);
      $pED     = "'".$pEmi.'/'.$pDest."'";
      if (isset($aCPgmto[$pCPgmto])==false) $aCPgmto[$pCPgmto] = array('sCPgmto'=>$sCPgmto,'nDFin'=>$nDFin,'nDMed'=>$nDMed);
      if (isset($aPED_CPgmt0[$pED])==false) $aPED_CPgmt0[$pED] = $pCPgmto;
      if (isset($aPED_CPgmto[$pED])==false) $aPED_CPgmto[$pED] = array();
      $aPED_CPgmto[$pED][] = $pCPgmto;
      $iLoop++;
   }
   //echo " --> total de ($iLoop) registros".chr(10);
   //
}   // for


$sInItens = implode(',',$aItens);
$aInItensPartes = quebrarListaIN($sInItens, 1500);
$whereConditions = [];
foreach ($aInItensPartes as $parte) {
    $whereConditions[] = "a.pPId IN ($parte)";
}

$whereClause = "(" . implode(" OR ", $whereConditions) . ")";
$whereClaus2 = str_replace('a.pPId','a.pItem',$whereClause);
$whereClaus3 = str_replace('a.pPId','b.pItem',$whereClause);


// (H) - Cadastro de Itens
// -----------------------
$sSql = "select a.pPId,
                a.sCodigo,
                a.sDescricao,
                b.pPId,
                b.sCodigo,
                b.sDescricao,
                c.pPId,
                c.sCodigo,
                c.sSubGrupo,
                d.pPId,
                d.sCodigo,
                d.sGrupo,
                a.pUnVen,
                e.sCodigo sCUni,   -- vira da Ordens_Itens nao do CadItens
                a.nMl,
                a.nTmpICMS_vBCST,
                a.nTmpICMS_vICMSST,
                a.nTmpICMS_vICMS,
                b.nAliqTranspNac
         
         from Itens a join NCM           b on a.pNCM        = b.pPId and b.iVer = b.iVAt
                      join SubGrupoSKU   c on a.pSubGrpSku  = c.pPId and c.iVer = c.iVAt
                      join GrupoSKU      d on c.pGrupoSku   = d.pPId and d.iVer = d.iVAt
                 left join UnidadeMedida e on a.pUnVen      = e.pPId and e.iVer = e.iVAt
         where $whereClause
           and a.iVer=a.iVAt";

//   --  a.pPId in ($sInItens)
//echo $sSql;

////echo "itens".chr(10);
//echo "Qry Cadastro de Itens";

$aDb       = faDbSelect($hDb,$sSql);
$aCadItens = array();   // $aCItens[$pItem] = array($sCodigo,$sDescricao);
$aCadNCM   = array();   // $aCItens[$pItem] = array($sCodigo,$sDescricao);
$aCadSGrp  = array();   // $aCItens[$pItem] = array($sCodigo,$sDescricao);
$aCadGrp   = array();   // $aCItens[$pItem] = array($sCodigo,$sDescricao);
$aNCM      = array();
$aSGrp     = array();   // valor inicial para nao dar erro no $sIn...
$iLoop     = 0;
foreach ($aDb as $aLin) {
   $pItem             = $aLin[ 0];
   $sCItem            = $aLin[ 1];
   $sItem             = $aLin[ 2];
   $pNCM              = $aLin[ 3];
   $sCNCM             = $aLin[ 4];
   $sNCM              = $aLin[ 5];
   $pSGrp             = $aLin[ 6];
   $sCSGrp            = $aLin[ 7];
   $sSGrp             = $aLin[ 8];
   $pGrp              = $aLin[ 9];
   $sCGrp             = $aLin[10];
   $sGrp              = $aLin[11];
   $pUnVen            = $aLin[12];
   $sUnVen            = $aLin[13];
   $nMl               = $aLin[14];
   $nTmpICMS_vBCST    = $aLin[15];
   $nTmpICMS_vICMSST  = $aLin[16];
   $nTmpICMS_vICMS    = $aLin[17];
   $nAliqTranspNac    = $aLin[18];
   $aCadItens[$pItem] = array('sCItem'=>$sCItem, 'sItem'=>$sItem, 'pNCM'=>$pNCM, 'pSGrp'=>$pSGrp, 'pGrp'=>$pGrp, 'pUnVen'=>$pUnVen, 'sUnVen'=>$sUnVen, 'nMl'=>$nMl, 'nTmpICMS_vBCST'=>$nTmpICMS_vBCST, 'nTmpICMS_vICMSST'=>$nTmpICMS_vICMSST, 'nTmpICMS_vICMS'=>$nTmpICMS_vICMS, 'pNCM'=>$pNCM, 'sCNCM'=>$sCNCM, 'sNCM'=>$sNCM, 'nAliqTranspNac'=>$nAliqTranspNac, 'pSGrp'=>$pSGrp, 'sCSGrp'=>$sCSGrp, 'sSGrp'=>$sSGrp, 'pGrp'=>$pGrp, 'sCGrp'=>$sCGrp, 'sGrp'=>$sGrp);
   $aCadNCM  [$pNCM ] = array('sCNCM'=>$sCNCM, 'sNCM'=>$sNCM, 'nAliqTranspNac'=>$nAliqTranspNac);
   $aCadSGrp [$pSGrp] = array('sCSGrp'=>$sCSGrp, 'sSGrp'=>$sSGrp, 'pGrp'=>$pGrp);
   $aCadGrp  [$pGrp ] = array('sCGrp'=>$sCGrp, 'sGrp'=>$sGrp);
   if (in_array($pNCM,$aNCM  )==false) $aNCM [] = $pNCM;
   if (in_array($pSGrp,$aSGrp)==false) $aSGrp[] = $pSGrp;
   $iLoop++;


}   // for
//echo " --> total de ($iLoop) registros".chr(10);
$sInNCM = implode(',',$aNCM);
$sInSGrp = implode(',',$aSGrp);

// (I) - Tabela de Preos
// ----------------------
/*
3-Propria - TabPrecos_Clientes - Itens

1-Varejo (todas outras) - TabPrecos_UF - pCUP=0, pUF=0
  *lPromo==1 GrupoSubGrupo
   lPromo==0 Itens

*/
$sSql = "select a.pPId pTab,
                b.pPId pTabI,
                a.pEmi,
                c.pCUP,
                a.jTpLiP,   -- aTpLiP  = 1-Varejo,2-Distribuidor,3-Propria,4-Distribuidor(A),5-Distribuidor(B),6-Atacadista,7-Distribuidor(C),8-Outras,9-Atacado,10-IFC Base,11-IFC Poltica, 12-Loja Integrada,13-Loja Giorno
                b.pItem,
                b.nValor,
                b.nValor1,
                b.nValor2,
                a.sCodigo,
                a.sDescricao,
                a.lPromo
         from TabPrecos     a     join TabPrecos_Itens    b on b.pTab  = a.pPId and b.lExc=0 and b.iVer=b.iVAt and $whereClaus3
                                  join TabPrecos_Clientes c on c.pTabP = a.pPId and c.lExc=0 and c.iVer=c.iVAt and c.pCUP in ($sInD)
         where a.lExc=0
           and a.pEmi in ($sInE)
           and a.iVer=a.iVAt
           and a.jTpLiP = 2
         order by a.jTpLiP
        ";

////echo $sSql;

//echo "tab preco 1/2".chr(10);
//echo "Qry Tabela de Preos por Clientes";
$aDb  = faDbSelect($hDb,$sSql);

$aTab       = array();   // $aTab[$pTab] = array($sCTab,$sTab);
$aTabEmiCUP = array();   // $aTabEmiCUP[$pCUP] = array(...)
$iLoop      = 0;
foreach ($aDb as $aLin) {
   $pTab  = $aLin[ 0];
   $pTabI = $aLin[ 1];
   $pEmi  = $aLin[ 2];
   $pCUP  = $aLin[ 3]>0?$aLin[3]:0;   // pCUP = pDest
   $pUF   = $aLin[ 4]>0?$aLin[4]:0;
   $jTpL  = $aLin[ 5];
   $pItm  = $aLin[ 6];
   $nVa0  = $aLin[ 7];
   $nVa1  = $aLin[ 8];
   $nVa2  = $aLin[ 9];
   $sCTab = $aLin[10];
   $sTab  = $aLin[11];

   if (isset($aTab[$pTab])==false) $aTab[$pTab] = array($sCTab,$sTab);

   if (isset($aTabEmiCUP[$pEmi]              )==false) $aTabEmiCUP[$pEmi]               = array();
   if (isset($aTabEmiCUP[$pEmi][$pCUP]       )==false) $aTabEmiCUP[$pEmi][$pCUP]        = array();
   if (isset($aTabEmiCUP[$pEmi][$pCUP][$pItm])==false) $aTabEmiCUP[$pEmi][$pCUP][$pItm] = array();
   $aTabEmiCUP[$pEmi][$pCUP][$pItm] = array('pTab'=>$pTab,'pTabI'=>$pTabI,'nVa0'=>$nVa0,'nVa1'=>$nVa1,'nVa2'=>$nVa2);
   $iLoop++;
}   // for
//echo " --> total de ($iLoop) registros".chr(10);

//
$sSql = "select a.pPId pTab,
                b.pPId pTabI,
                a.pEmi,
                d.pUF,
                a.jTpLiP,   -- aTpLiP  = 1-Varejo,2-Distribuidor,3-Propria,4-Distribuidor(A),5-Distribuidor(B),6-Atacadista,7-Distribuidor(C),8-Outras,9-Atacado,10-IFC Base,11-IFC Poltica, 12-Loja Integrada,13-Loja Giorno
                b.pItem,
                b.nValor,
                b.nValor1,
                b.nValor2,
                a.sCodigo,
                a.sDescricao,
                a.lPromo
         from TabPrecos     a     join TabPrecos_Itens    b on b.pTab  = a.pPId and b.lExc=0 and b.iVer=b.iVAt and $whereClaus3
                                  join TabPrecos_UF       d on d.pTabP = a.pPId and d.lExc=0 and d.iVer=d.iVAt and d.pUF in ($sInUFDestEnt)
         where a.lExc=0
           and a.pEmi  in ($sInE)
           and a.iVer=a.iVAt
           and a.jTpLiP<>2
         order by a.jTpLiP
        ";

//echo "tab preco 2/2".chr(10);
//echo "Qry Tabela de Preos por UF";
$aDb  = faDbSelect($hDb,$sSql);

//$aTab       = array();   // $aTab[$pTab] = array($sCTab,$sTab);
$aTabEmiUF  = array();   // $aTabEmiUF [$pUF ] = array(...)
$iLoop = 0;
foreach ($aDb as $aLin) {
   $pTab  = $aLin[ 0];
   $pTabI = $aLin[ 1];
   $pEmi  = $aLin[ 2];
   $pCUP  = $aLin[ 3]>0?$aLin[3]:0;   // pCUP = pDest
   $pUF   = $aLin[ 4]>0?$aLin[4]:0;
   $jTpL  = $aLin[ 5];
   $pItm  = $aLin[ 6];
   $nVa0  = $aLin[ 7];
   $nVa1  = $aLin[ 8];
   $nVa2  = $aLin[ 9];
   $sCTab = $aLin[10];
   $sTab  = $aLin[11];


   if (isset($aTab[$pTab])==false) $aTab[$pTab] = array($sCTab,$sTab);

   if (isset($aTabEmiUF [$pEmi]              )==false) $aTabEmiUF [$pEmi]               = array();
   if (isset($aTabEmiUF [$pEmi][$pUF ]       )==false) $aTabEmiUF [$pEmi][$pUF ]        = array();
   if (isset($aTabEmiUF [$pEmi][$pUF ][$pItm])==false) $aTabEmiUF [$pEmi][$pUF ][$pItm] = array();
   $aTabEmiUF [$pEmi][$pUF] [$pItm] = array('pTab'=>$pTab,'pTabI'=>$pTabI,'nVa0'=>$nVa0,'nVa1'=>$nVa1,'nVa2'=>$nVa2);
   $iLoop++;

}   // for
//echo " --> total de ($iLoop) registros".chr(10);

$sSql = "select pPId,pEmi,sCodigo,sDescricao from GrpPromo where pEmi in ($sInE) and iVer=iVAt and lExc=0";
//echo "Qry Tabela de Preos por GrupoPromocional Capa";
$aDb  = faDbSelect($hDb,$sSql);
$aGrpPromo = array();
$aInPromo  = array(0);   // ateno 0 para nao dar ero no select
$iLoop = 0;
foreach ($aDb as $aLin) {
   $pGrpPromo = $aLin[0];
   $pEmi      = $aLin[1];
   $sCod      = $aLin[2];
   $sDesc     = $aLin[3];
   $aInPromo[] = $pGrpPromo;
   $aGrpPromo[$pGrpPromo] = array($sCod,$sDesc);
   $iLoop++;
}
//echo " --> total de ($iLoop) registros".chr(10);
$sInPromo = implode(',',$aInPromo);


$sSql = "select a.pGrpProm,a.pItem from GrpPromo_Itens a where a.pGrpProm in ($sInPromo) and $whereClaus2 and a.iVer=a.iVAt and a.lExc=0";
//echo "Qry Tabela de Preos por GrupoPromocional Itens";
$aDb  = faDbSelect($hDb,$sSql);
$aGrpPromo_Itens = array();
$iLoop = 0;
foreach ($aDb as $aLin) {
   $pGrpPromo = $aLin[0];
   $pItem     = $aLin[1];
   if (isset($aGrpPromo_Itens[$pGrpPromo])==false) $aGrpPromo_Itens[$pGrpPromo] = array();
   $aGrpPromo_Itens[$pGrpPromo][] = $pItem;
   $iLoop++;
}
//echo " --> total de ($iLoop) registros".chr(10);

$sSql = "select a.pTabP,
                a.pGrpProm,
                a.nQtDe1 ,
                a.nQtAte1,
                a.nPrU1  ,
                a.nPCom1 ,
                a.nQtDe2 ,
                a.nQtAte2,
                a.nPrU2  ,
                a.nPCom2 ,
                a.nQtDe3 ,
                a.nQtAte3,
                a.nPrU3  ,
                a.nPCom3 ,
                b.sCodigo,
                b.sDescricao
         from TabPrecos_GrpPromo a join TabPrecos b on a.pTabP=b.pPId and b.iVer=b.iVAt
         where a.pGrpProm in ($sInPromo) 
           and a.iVer=a.iVAt 
           and a.lExc=0";
//echo "Qry Tabelas de Preo por GrupoPromocional Escalas";
$aDb  = faDbSelect($hDb,$sSql);
$aTabPromo = array();
$iLoop = 0;
foreach ($aDb as $aLin) {
   $pTab      = $aLin[ 0];   // 
   $pGrpPromo = $aLin[ 1];
   $nQtDe1    = $aLin[ 2];
   $nQtAte1   = $aLin[ 3];
   $nPrU1     = $aLin[ 4];
   $nPCom1    = $aLin[ 5];
   $nQtDe2    = $aLin[ 6];
   $nQtAte2   = $aLin[ 7];
   $nPrU2     = $aLin[ 8];
   $nPCom2    = $aLin[ 9];
   $nQtDe3    = $aLin[10];
   $nQtAte3   = $aLin[11];
   $nPrU3     = $aLin[12];
   $nPCom3    = $aLin[13];
   $sCTab     = $aLin[14];
   $sTab      = $aLin[15];

   if (isset($aTab[$pTab])==false) $aTab[$pTab] = array($sCTab,$sTab);
   //
   if (isset($aTabPromo[$pTab]            )==false) $aTabPromo[$pTab]             = array();
   if (isset($aTabPromo[$pTab][$pGrpPromo])==false) $aTabPromo[$pTab][$pGrpPromo] = array('nQtDe1'=>$nQtDe1,'nQtAte1'=>$nQtAte1,'nPrU1'=>$nPrU1,'nPCom1'=>$nPCom1,'nQtDe2'=>$nQtDe2,'nQtAte2'=>$nQtAte2,'nPrU2'=>$nPrU2,'nPCom2'=>$nPCom2,'nQtDe3'=>$nQtDe3,'nQtAte3'=>$nQtAte3,'nPrU3'=>$nPrU3,'nPCom3'=>$nPCom3);
   $iLoop++;

}
//echo " --> total de ($iLoop) registros".chr(10);




// (J) - RegFiscais
// ----------------
$aCadRegF = array();   // 
foreach ($aE as $pEmi) {
   for ($j=0; $j<2; $j++) {
      if ($j==0) {   // jTipo=5
         $sWhere = " and a.jTipo=5 and a.pSubGrpSku in ($sInSGrp) ";
      } else {   // jTipo=4
         $sWhere = " and a.jTipo=4 ";
      } 

      $sSql = "select
                   a.lIPI                ,   --  0
                   a.lIPI_RE             ,   --  1
                   a.lPIS                ,   --  2   
                   a.lPISST              ,   --  3   
                   a.lPIS_RE             ,   --  4   
                   a.lCofins             ,   --  5
                   a.lCofinsST           ,   --  6
                   a.lCofins_RE          ,   --  7   
                   a.lICMS               ,   --  8  
                   a.lICMS_SN            ,   --  9
                   a.lICMS_RE            ,   -- 10
   
                   a.pCFO                ,   -- 11
                   a.pCFO_RE             ,   -- 12        
                   
                   a.jCSTIPI             ,   -- 13
                   a.nIpiAli             ,   -- 14
                   a.nPRBCIPI            ,   -- 15
                   a.nMEstim             ,   -- 16
                   a.jCSTIPI_RE          ,   -- 17   
                   a.nIpiAli_RE          ,   -- 18  
  
                   a.nPPIS               ,   -- 19
                   a.jCSTPIS             ,   -- 20
                   a.nPPIS_RE            ,   -- 21 
                   a.jCSTPIS_RE          ,   -- 22 
   
                   a.nPCofins            ,   -- 23
                   a.jCSTCofins          ,   -- 24
                   a.nPCofins_RE         ,   -- 25
                   a.jCSTCofins_RE       ,   -- 26   
   
                   a.jCSTICMS            ,   -- 27
                   a.jICMS_modBC         ,   -- 28
                   a.nPRedBC             ,   -- 29
                   a.jICMS_modBCST       ,   -- 30
                   a.nPICMS              ,   -- 31
                   a.nPRedBCST           ,   -- 32
                   a.nPIcmsST            ,   -- 33
                   a.nPIncidIPIICMS      ,   -- 34
   
                   a.jCSTICMS_RE         ,   -- 35 
                   a.jICMS_modBC_RE      ,   -- 36 
                   a.nPRedBC_RE          ,   -- 37 
                   a.jICMS_modBCST_RE    ,   -- 38 
                   a.nPICMS_RE           ,   -- 39 
                   a.nPRedBCST_RE        ,   -- 40 
                   a.nPICMSST_RE         ,   -- 41 
                   a.nPIncidIPIICMS_RE   ,   -- 42 
   
                   a.pCBenef             ,   -- 43
                   a.nMestim_RE          ,   -- 44 
      
                   a.lICMS_FCP           ,   -- 45
                   a.lICMS_FCPST         ,   -- 46
                   a.lICMS_FCPSTRet      ,   -- 47
                   a.lCalcDeson          ,   -- 48
                   a.lFCPConsFinal       ,   -- 49
                   a.lFCPConsFinal_RE    ,   -- 50
                   a.lICMS_FCP_RE        ,   -- 51
                   a.lICMS_FCPST_RE      ,   -- 52 
                   a.lICMS_FCPSTRet_RE   ,   -- 53
   
                   a.jGrupo_simples      ,   -- 54
                   a.nICMSSN_pMVAST      ,   -- 55
                   a.nICMSSN_pRedBCST    ,   -- 56
                   a.nICMSSN_pICMSST     ,   -- 57
                   a.nICMSSN_pCredSN     ,   -- 58
                   a.nICMSSN_pICMS       ,   -- 59
   
                   a.jGrupo_simples_RE   ,   -- 60
                   a.nICMSSN_pMVAST_RE   ,   -- 61
                   a.nICMSSN_pRedBCST_RE ,   -- 62
                   a.nICMSSN_pICMSST_RE  ,   -- 63
                   a.nICMSSN_pCredSN_RE  ,   -- 64
                   a.nICMSSN_pICMS_RE    ,   -- 65
   
                   a.pSubGrpSku          ,   -- 66  pSGrp
                   a.jOrig               ,   -- 67  =0
                   a.pTOper              ,   -- 68  pTOper
                   a.pPId                ,   -- 69  pRegF
                   a.pNCM                ,   -- 70  pNCM
                   a.pUF2                ,   -- 71  pUFPos dos Destinatrio 
                   a.pEmi                ,   -- 72  pEmi
                   a.jTipo                   -- 73  (4,5) priorizar o 5
   
                 from RegFiscais a
                 where a.jFinalidade=0
                 --and a.jOrig=0
                   and a.iVer=a.iVat
                   and a.lExc=0
   
                   and a.pEmi = $pEmi
                   and a.pTOper in ($sInTOper)
                   and a.pNCM   in ($sInNCM)
                   and a.pUF2   in ($sInUFDestPos)

                   $sWhere

                ";   //
      //echo $sSql.chr(10);
      //echo "reg fiscal j=$j".chr(10);
      $k = $j+1;
      //echo "Qry Registros Fiscais $k/2 pEmi=$pEmi";
      //echo chr(10).$sSql.chr(10);
      $aDb  = faDbSelect($hDb,$sSql);
      $iDb  = count($aDb);
      //echo ", iDb=$iDb".chr(10);
      $iLoop = 0;
      foreach ($aDb as $aLin) {
      //   $pTab  = $aLin[0];

         /* Lgicos */
         $lIPI                = $aLin[ 0];
         $lIPI_RE             = $aLin[ 1];
         $lPIS                = $aLin[ 2];   
         $lPISST              = $aLin[ 3];   
         $lPIS_RE             = $aLin[ 4];   
         $lCofins             = $aLin[ 5];
         $lCofinsST           = $aLin[ 6];
         $lCofins_RE          = $aLin[ 7];   
         $lICMS               = $aLin[ 8];  
         $lICMS_SN            = $aLin[ 9];
         $lICMS_RE            = $aLin[10];
      
         /* CFO */
         $pCFO                = $aLin[11];
         $pCFO_RE             = $aLin[12];        
         
         /* IPI */
         $jCSTIPI             = $aLin[13];
         $nIpiAli             = $aLin[14];
         $nPRBCIPI            = $aLin[15];
         $nMEstim             = $aLin[16];
         $jCSTIPI_RE          = $aLin[17];   
         $nIpiAli_RE          = $aLin[18];  
      
         /* PIS */
         $nPPIS               = $aLin[19];
         $jCSTPIS             = $aLin[20];
         $nPPIS_RE            = $aLin[21]; 
         $jCSTPIS_RE          = $aLin[22]; 
      
         /* Cofins */
         $nPCofins            = $aLin[23];
         $jCSTCofins          = $aLin[24];
         $nPCofins_RE         = $aLin[25];
         $jCSTCofins_RE       = $aLin[26];   
      
         /* ICMS */
         $jCSTICMS            = $aLin[27];
         $jICMS_modBC         = $aLin[28];
         $nPRedBC             = $aLin[29];
         $jICMS_modBCST       = $aLin[30];
         $nPICMS              = $aLin[31];
         $nPRedBCST           = $aLin[32];
         $nPIcmsST            = $aLin[33];
         $nPIncidIPIICMS      = $aLin[34];
      
         /* ICMS RE */
         $jCSTICMS_RE         = $aLin[35]; 
         $jICMS_modBC_RE      = $aLin[36]; 
         $nPRedBC_RE          = $aLin[37]; 
         $jICMS_modBCST_RE    = $aLin[38]; 
         $nPICMS_RE           = $aLin[39]; 
         $nPRedBCST_RE        = $aLin[40]; 
         $nPICMSST_RE         = $aLin[41]; 
         $nPIncidIPIICMS_RE   = $aLin[42]; 
      
         /* ... */
         $pCBenef             = $aLin[43];
         $nMestim_RE          = $aLin[44]; 
         
         /* Flags FCP */
         $lICMS_FCP           = $aLin[45];
         $lICMS_FCPST         = $aLin[46];
         $lICMS_FCPSTRet      = $aLin[47];
         $lCalcDeson          = $aLin[48];
         $lFCPConsFinal       = $aLin[49];
         $lFCPConsFinal_RE    = $aLin[50];
         $lICMS_FCP_RE        = $aLin[51];
         $lICMS_FCPST_RE      = $aLin[52]; 
         $lICMS_FCPSTRet_RE   = $aLin[53];
      
         /* Simples Nacional */
         $jGrupo_simples      = $aLin[54];
         $nICMSSN_pMVAST      = $aLin[55];
         $nICMSSN_pRedBCST    = $aLin[56];
         $nICMSSN_pICMSST     = $aLin[57];
         $nICMSSN_pCredSN     = $aLin[58];
         $nICMSSN_pICMS       = $aLin[59];
      
         /* Simples Nacional Regime Especial */
         $jGrupo_simples_RE   = $aLin[60];
         $nICMSSN_pMVAST_RE   = $aLin[61];
         $nICMSSN_pRedBCST_RE = $aLin[62];
         $nICMSSN_pICMSST_RE  = $aLin[63];
         $nICMSSN_pCredSN_RE  = $aLin[64];
         $nICMSSN_pICMS_RE    = $aLin[65];
      
         /*... */                      
         $pSubGrpSku          = $aLin[66];   // {$pSGrp}
         $jOrig               = $aLin[67];   // =0
         $pTOper              = $aLin[68];   // {$pTOper}
         $pRegF               = $aLin[69];   // pRegDep
         $pNCM                = $aLin[70];   // {pNCM}
         $pUF2                = $aLin[71];   // {pUFPos} dos Destinatrio 
       //$pEmi                = $aLin[72];   // {$pEmi}
         $jTipo               = $aLin[73];   // (4,5) priorizar o 5


         $aLinAssoc = array(

         'pPId'                => $pRegF,
         'lIPI'                => $lIPI               ,
         'lIPI_RE'             => $lIPI_RE            ,
         'lPIS'                => $lPIS               ,   
         'lPISST'              => $lPISST             ,   
         'lPIS_RE'             => $lPIS_RE            ,   
         'lCofins'             => $lCofins            ,
         'lCofinsST'           => $lCofinsST          ,
         'lCofins_RE'          => $lCofins_RE         ,   
         'lICMS'               => $lICMS              ,  
         'lICMS_SN'            => $lICMS_SN           ,
         'lICMS_RE'            => $lICMS_RE           ,
                                
         'pCFO'                => $pCFO               ,
         'pCFO_RE'             => $pCFO_RE            ,        
                                
         'jCSTIPI'             => $jCSTIPI            ,
         'nIpiAli'             => $nIpiAli            ,
         'nPRBCIPI'            => $nPRBCIPI           ,
         'nMEstim'             => $nMEstim            ,
         'jCSTIPI_RE'          => $jCSTIPI_RE         ,   
         'nIpiAli_RE'          => $nIpiAli_RE         ,  
                                
         'nPPIS'               => $nPPIS              ,
         'jCSTPIS'             => $jCSTPIS            ,
         'nPPIS_RE'            => $nPPIS_RE           , 
         'jCSTPIS_RE'          => $jCSTPIS_RE         , 
                                
         'nPCofins'            => $nPCofins           ,
         'jCSTCofins'          => $jCSTCofins         ,
         'nPCofins_RE'         => $nPCofins_RE        ,
         'jCSTCofins_RE'       => $jCSTCofins_RE      ,   
                                
         'jCSTICMS'            => $jCSTICMS           ,
         'jICMS_modBC'         => $jICMS_modBC        ,
         'nPRedBC'             => $nPRedBC            ,
         'jICMS_modBCST'       => $jICMS_modBCST      ,
         'nPICMS'              => $nPICMS             ,
         'nPRedBCST'           => $nPRedBCST          ,
         'nPIcmsST'            => $nPIcmsST           ,
         'nPIncidIPIICMS'      => $nPIncidIPIICMS     ,
                                
         'jCSTICMS_RE'         => $jCSTICMS_RE        , 
         'jICMS_modBC_RE'      => $jICMS_modBC_RE     , 
         'nPRedBC_RE'          => $nPRedBC_RE         , 
         'jICMS_modBCST_RE'    => $jICMS_modBCST_RE   , 
         'nPICMS_RE'           => $nPICMS_RE          , 
         'nPRedBCST_RE'        => $nPRedBCST_RE       , 
         'nPICMSST_RE'         => $nPICMSST_RE        , 
         'nPIncidIPIICMS_RE'   => $nPIncidIPIICMS_RE  , 
                                
         'pCBenef'             => $pCBenef            ,
         'nMestim_RE'          => $nMestim_RE         , 
                                
         'lICMS_FCP'           => $lICMS_FCP          ,
         'lICMS_FCPST'         => $lICMS_FCPST        ,
         'lICMS_FCPSTRet'      => $lICMS_FCPSTRet     ,
         'lCalcDeson'          => $lCalcDeson         ,
         'lFCPConsFinal'       => $lFCPConsFinal      ,
         'lFCPConsFinal_RE'    => $lFCPConsFinal_RE   ,
         'lICMS_FCP_RE'        => $lICMS_FCP_RE       ,
         'lICMS_FCPST_RE'      => $lICMS_FCPST_RE     , 
         'lICMS_FCPSTRet_RE'   => $lICMS_FCPSTRet_RE  ,
                                
         'jGrupo_simples'     => $jGrupo_simples      ,
         'nICMSSN_pMVAST'     => $nICMSSN_pMVAST      ,
         'nICMSSN_pRedBCST'   => $nICMSSN_pRedBCST    ,
         'nICMSSN_pICMSST'    => $nICMSSN_pICMSST     ,
         'nICMSSN_pCredSN'    => $nICMSSN_pCredSN     ,
         'nICMSSN_pICMS'      => $nICMSSN_pICMS       ,
                                
         'jGrupo_simples_RE'  => $jGrupo_simples_RE   ,
         'nICMSSN_pMVAST_RE'  => $nICMSSN_pMVAST_RE   ,
         'nICMSSN_pRedBCST_RE'=> $nICMSSN_pRedBCST_RE ,
         'nICMSSN_pICMSST_RE' => $nICMSSN_pICMSST_RE  ,
         'nICMSSN_pCredSN_RE' => $nICMSSN_pCredSN_RE  ,
         'nICMSSN_pICMS_RE'   => $nICMSSN_pICMS_RE    ,
                                
         'pSubGrpSku'         => $pSubGrpSku          ,
         'jOrig'              => $jOrig               ,
         'pTOper'             => $pTOper              ,
       //'pRegF'              => $pRegF               ,
         'pNCM'               => $pNCM                ,
         'pUF2'               => $pUF2                ,
         'pEmi'               => $pEmi                ,
         'jTipo'              => $jTipo               );


       //$aCadRegF[] = $aLin;
         $aCadRegF[] = $aLinAssoc;
       //$aCadRegF[$pRegF] = $aLinAssoc;



         if ($j==0) {
            // $jTipo=5
            if (isset($aReg5                           )==false) $aReg5                            = array();
            if (isset($aReg5[$pUF2]                    )==false) $aReg5[$pUF2]                     = array();
            if (isset($aReg5[$pUF2][$pNCM]             )==false) $aReg5[$pUF2][$pNCM]              = array();
            if (isset($aReg5[$pUF2][$pNCM][$pSubGrpSku])==false) $aReg5[$pUF2][$pNCM][$pSubGrpSku] = array();

            if (($aLinAssoc['lIPI'      ]==1)&&(isset($aReg5[$pUF2][$pNCM][$pSubGrpSku]['lIPI'      ])==false)) $aReg5[$pUF2][$pNCM][$pSubGrpSku]['lIPI'      ] = $pRegF;
            if (($aLinAssoc['lIPI_RE'   ]==1)&&(isset($aReg5[$pUF2][$pNCM][$pSubGrpSku]['lIPI_RE'   ])==false)) $aReg5[$pUF2][$pNCM][$pSubGrpSku]['lIPI_RE'   ] = $pRegF;
            if (($aLinAssoc['lPIS'      ]==1)&&(isset($aReg5[$pUF2][$pNCM][$pSubGrpSku]['lPIS'      ])==false)) $aReg5[$pUF2][$pNCM][$pSubGrpSku]['lPIS'      ] = $pRegF;
            if (($aLinAssoc['lPISST'    ]==1)&&(isset($aReg5[$pUF2][$pNCM][$pSubGrpSku]['lPISST'    ])==false)) $aReg5[$pUF2][$pNCM][$pSubGrpSku]['lPISST'    ] = $pRegF;
            if (($aLinAssoc['lPIS_RE'   ]==1)&&(isset($aReg5[$pUF2][$pNCM][$pSubGrpSku]['lPIS_RE'   ])==false)) $aReg5[$pUF2][$pNCM][$pSubGrpSku]['lPIS_RE'   ] = $pRegF;
            if (($aLinAssoc['lCofins'   ]==1)&&(isset($aReg5[$pUF2][$pNCM][$pSubGrpSku]['lCofins'   ])==false)) $aReg5[$pUF2][$pNCM][$pSubGrpSku]['lCofins'   ] = $pRegF;
            if (($aLinAssoc['lCofinsST' ]==1)&&(isset($aReg5[$pUF2][$pNCM][$pSubGrpSku]['lCofinsST' ])==false)) $aReg5[$pUF2][$pNCM][$pSubGrpSku]['lCofinsST' ] = $pRegF;
            if (($aLinAssoc['lCofins_RE']==1)&&(isset($aReg5[$pUF2][$pNCM][$pSubGrpSku]['lCofins_RE'])==false)) $aReg5[$pUF2][$pNCM][$pSubGrpSku]['lCofins_RE'] = $pRegF;
            if (($aLinAssoc['lICMS'     ]==1)&&(isset($aReg5[$pUF2][$pNCM][$pSubGrpSku]['lICMS'     ])==false)) $aReg5[$pUF2][$pNCM][$pSubGrpSku]['lICMS'     ] = $pRegF;
            if (($aLinAssoc['lICMS_SN'  ]==1)&&(isset($aReg5[$pUF2][$pNCM][$pSubGrpSku]['lICMS_SN'  ])==false)) $aReg5[$pUF2][$pNCM][$pSubGrpSku]['lICMS_SN'  ] = $pRegF;
            if (($aLinAssoc['lICMS_RE'  ]==1)&&(isset($aReg5[$pUF2][$pNCM][$pSubGrpSku]['lICMS_RE'  ])==false)) $aReg5[$pUF2][$pNCM][$pSubGrpSku]['lICMS_RE'  ] = $pRegF;
            //echo chr(10)."jTipo=5, pRegF=$pRegF, pUF2=$pUF2, pNCM=$pNCM, pSubGrpSku=$pSubGrpSku".chr(10);
         } else {
            // $jTipo=4
            if (isset($aReg4              )==false) $aReg4               = array();
            if (isset($aReg4[$pUF2]       )==false) $aReg4[$pUF2]        = array();
            if (isset($aReg4[$pUF2][$pNCM])==false) $aReg4[$pUF2][$pNCM] = array();

            if (($aLinAssoc['lIPI'      ]==1)&&(isset($aReg4[$pUF2][$pNCM]['lIPI'      ])==false)) $aReg4[$pUF2][$pNCM]['lIPI'      ] = $pRegF;
            if (($aLinAssoc['lIPI_RE'   ]==1)&&(isset($aReg4[$pUF2][$pNCM]['lIPI_RE'   ])==false)) $aReg4[$pUF2][$pNCM]['lIPI_RE'   ] = $pRegF;
            if (($aLinAssoc['lPIS'      ]==1)&&(isset($aReg4[$pUF2][$pNCM]['lPIS'      ])==false)) $aReg4[$pUF2][$pNCM]['lPIS'      ] = $pRegF;
            if (($aLinAssoc['lPISST'    ]==1)&&(isset($aReg4[$pUF2][$pNCM]['lPISST'    ])==false)) $aReg4[$pUF2][$pNCM]['lPISST'    ] = $pRegF;
            if (($aLinAssoc['lPIS_RE'   ]==1)&&(isset($aReg4[$pUF2][$pNCM]['lPIS_RE'   ])==false)) $aReg4[$pUF2][$pNCM]['lPIS_RE'   ] = $pRegF;
            if (($aLinAssoc['lCofins'   ]==1)&&(isset($aReg4[$pUF2][$pNCM]['lCofins'   ])==false)) $aReg4[$pUF2][$pNCM]['lCofins'   ] = $pRegF;
            if (($aLinAssoc['lCofinsST' ]==1)&&(isset($aReg4[$pUF2][$pNCM]['lCofinsST' ])==false)) $aReg4[$pUF2][$pNCM]['lCofinsST' ] = $pRegF;
            if (($aLinAssoc['lCofins_RE']==1)&&(isset($aReg4[$pUF2][$pNCM]['lCofins_RE'])==false)) $aReg4[$pUF2][$pNCM]['lCofins_RE'] = $pRegF;
            if (($aLinAssoc['lICMS'     ]==1)&&(isset($aReg4[$pUF2][$pNCM]['lICMS'     ])==false)) $aReg4[$pUF2][$pNCM]['lICMS'     ] = $pRegF;
            if (($aLinAssoc['lICMS_SN'  ]==1)&&(isset($aReg4[$pUF2][$pNCM]['lICMS_SN'  ])==false)) $aReg4[$pUF2][$pNCM]['lICMS_SN'  ] = $pRegF;
            if (($aLinAssoc['lICMS_RE'  ]==1)&&(isset($aReg4[$pUF2][$pNCM]['lICMS_RE'  ])==false)) $aReg4[$pUF2][$pNCM]['lICMS_RE'  ] = $pRegF;

            //echo chr(10)."jTipo=4, pRegF=$pRegF, pUF2=$pUF2, pNCM=$pNCM, lPIS=$lPIS".chr(10);
         }
         $iLoop++;
      }   // foreach qry regfiscal
      //echo " --> total de ($iLoop) registros".chr(10);
   }   // for $j
}   // foreach $pEmi


// TOpEDI x RegFiscal




// 9a
$sSql = "select a.pPId,
                a.pEmi,
                a.pDest,
                a.pNCM,
                a.lICMS_RE,
                a.lIPI_RE
         from RegEspec_ClientesNCM a
         where a.jTipo    = 1  -- estou priorizando a SAIDA/VENDA
           and (a.lICMS_RE = 1 or a.lIPI_RE  = 1)
           and a.pEmi  in ($sInE)
           and a.pDest in ($sInD)
           and a.pNCM  in ($sInNCM)
           and a.iVer=a.iVAt
           and a.lExc=0";

//echo "Qry Regime Especial 9";
//echo $sSql;
$aDb  = faDbSelect($hDb,$sSql);
$aRegEspec_ClientesNCM = array();
$iLoop = 0;
foreach ($aDb as $aLin) {
   $pPId     = $aLin[0];
   $pEmi     = $aLin[1];
   $pDest    = $aLin[2];
   $pNCM     = $aLin[3];
   $lICMS_RE = $aLin[4];
   $lIPI_RE  = $aLin[5];
   $aRegEspec_ClientesNCM[] = array('pPId'=>$pPId,'pEmi'=>$pEmi,'pDest'=>$pDest,'pNCM'=>$pNCM,'lICMS_RE',$lICMS_RE,'lIPI_RE'=>$lIPI_RE);
   $iLoop++;
}
//echo " --> total de ($iLoop) registros".chr(10);


// 11
$sSql = "select a.pPId,
                a.pEmi,
                a.pDest,
                a.pItem,
                a.nValor
         from RegEspec_IPIUniTrib a
         where a.jTipo    = 1  -- estou priorizando a SAIDA/VENDA
           and a.pEmi  in ($sInE)
           and a.pDest in ($sInD)
           and $whereClaus2
           and a.iVer=a.iVAt
           and a.lExc=0";

//echo "Qry Regime Especial 11";
$aDb  = faDbSelect($hDb,$sSql);
$aRegEspec_IPIUniTrib  = array();
$iLoop = 0;
foreach ($aDb as $aLin) {
   $pPId   = $aLin[0];
   $pEmi   = $aLin[1];
   $pDest  = $aLin[2];
   $pItem  = $aLin[3];
   $nValor = $aLin[4];
   $aRegEspec_IPIUniTrib[] = array('pPId'=>$pPId,'pEmi'=>$pEmi,'pDest'=>$pDest,'pItem'=>$pItem,'nValor'=>$nValor);

   $iLoop++;
}
//echo " --> total de ($iLoop) registros".chr(10);


// 12a 
$sSql = "select a.pPId,
                a.pNCM,
                a.pEmi,
                a.pItem,
                a.lICMS_RE,
                a.lIPI_RE,
                a.lPIS_RE,
                a.lCOFINS_RE,
                a.lICMSSN_RE
         from RegEspec_ItensNCM a
         where  a.jTipo    = 1  -- estou priorizando a SAIDA/VENDA
         --and (a.lICMS_RE = 1 or a.lIPI_RE = 1)
           and  a.pEmi  in ($sInE)
           and  $whereClaus2
           and  a.pNCM  in ($sInNCM)
           and  a.iVer=a.iVAt 
           and  a.lExc=0";

//echo "Qry Regime Especial 12";
$aDb  = faDbSelect($hDb,$sSql);
$aRegEspec_ItensNCM = array();
$iLoop = 0;
foreach ($aDb as $aLin) {
   $pPId       = $aLin[0];
   $pNCM       = $aLin[1];
   $pEmi       = $aLin[2];
   $pItem      = $aLin[3];
   $lICMS_RE   = $aLin[4];
   $lIPI_RE    = $aLin[5];
   $lPIS_RE    = $aLin[6];
   $lCOFINS_RE = $aLin[7];
   $lICMSSN_RE = $aLin[8];
   $sNCMItem = $pNCM.'/'.$pItem;

   $aRegEspec_ItensNCM[] = array('pPId'=>$pPId, 'pNCM'=>$pNCM, 'pEmi'=>$pEmi, 'pItem'=>$pItem, 'lICMS_RE'=>$lICMS_RE, 'lIPI_RE'=>$lIPI_RE, 'lPIS_RE'=>$lPIS_RE, 'lCOFINS_RE'=>$lCOFINS_RE, 'lICMSSN_RE'=>$lICMSSN_RE);

   $iLoop++;
}
//echo " --> total de ($iLoop) registros".chr(10);

// 16
$sSql = "select a.pPId,
                a.pNCM,
                a.pEmi,
                a.pItem,
                a.lICMS_RE,
                a.lIPI_RE,
                a.lPIS_RE,
                a.lCOFINS_RE,
                d.pUF,
                a.lICMSSN_RE
         from RegEspec_ItensNCM a join RegEspec_ItensNCM_UFs d on d.pCapa = a.pPId and d.iVer=d.iVat and d.lExc=0
         where a.jTipo    = 1  -- estou priorizando a SAIDA/VENDA
           and a.pEmi  in ($sInE)
           and $whereClaus2
           and a.pNCM  in ($sInNCM)    -- todos os NCMs
           and a.lExc=0 
           and a.iVer=a.iVAt";


//echo "Qry Regime Especial 16";
$aDb  = faDbSelect($hDb,$sSql);
$iDb  = count($aDb);
$aRegEspec_ItensNCM_UF = array();

$iLoop = 0;
foreach ($aDb as $aLin) {
   $pPId        = $aLin[0];
   $pNCM        = $aLin[1];
   $pEmi        = $aLin[2];
   $pItem       = $aLin[3];
   $lICMS_RE    = $aLin[4];
   $lIPI_RE     = $aLin[5];
   $lPIS_RE     = $aLin[6];
   $lCOFINS_RE  = $aLin[7];
   $pUF         = $aLin[8];
   $lICMSSN_RE  = $aLin[9];
   $sNCMItem = $pNCM.'/'.$pItem;

   $aRegEspec_ItensNCM_UF[] = array('pPId'=>$pPId, 'pNCM'=>$pNCM, 'pEmi'=>$pEmi, 'pItem'=>$pItem, 'lICMS_RE'=>$lICMS_RE, 'lIPI_RE'=>$lIPI_RE, 'lPIS_RE'=>$lPIS_RE, 'lCOFINS_RE'=>$lCOFINS_RE, 'pUF'=>$pUF, 'lICMSSN_RE'=>$lICMSSN_RE);

   $iLoop++;
}
//echo " --> total de ($iLoop) registros".chr(10);

// 17 - select count
$sSql = "select pPId,
                pEmi,
                pDest,
                lICMS_RE,
                lIPI_RE
         from RegEspec_Clientes 
         where jTipo    = 1  -- estou priorizando a SAIDA/VENDA
           and lICMS_RE=1
           and pEmi  in ($sInE) 
           and pDest in ($sInD) 
           and iVer=iVAt 
           and lExc=0";
//echo "Qry Regime Especial RegEspec_Clientes";
$aDb  = faDbSelect($hDb,$sSql);
$aRegEspec_Clientes = array();
$iLoop = 0;
foreach ($aDb as $aLin) {
   $pPId     = $aLin[0];
   $pEmi     = $aLin[1];
   $pDest    = $aLin[2];
   $lICMS_RE = $aLin[3];
   $lIPI_RE  = $aLin[4];
   $aRegEspec_Clientes[] = array('pPId'=>$pPId, 'pEmi'=>$pEmi, 'pDest'=>$pDest, 'lICMS_RE'=>$lICMS_RE, 'lIPI_RE'=>$lIPI_RE);
   $iLoop++;
}

//echo " --> total de ($iLoop) registros".chr(10);

// 18 - Limite de Crdito
$sSql = "select aa.pEmi         as CodigoUnidFat,
                aa.pDest        as CodigoCliente,
                aa.pGrp         as CodigoGrupoCli,
                sum(aa.sumExp1) as LimiteCredito,
                sum(aa.sumExp2) as Disponivel
           from (
                  select a.pEmi         as pEmi,
                         a.pDest        as pDest,
                         b.pCliGrupo    as pGrp,
                         sum(a.nLCred)  as sumExp1,
                         0              as sumExp2
                  from LIM_Credito a join CUP b on a.pDest = b.pPId and b.iVer = b.iVAt
                  where a.iVer    = a.iVAt
                    and a.lExc    = 0
                    and a.jEntSai = 1
                    and a.jTipo   = 0
                    and cast('today' as date) >= cast(a.dValDe as date)
                    and cast('today' as date) <= cast(a.dValAte as date)
                    and a.pEmi  in ($sInE)
                    and a.pDest in ($sInD)
                  group by a.pEmi, a.pDest, b.pCliGrupo
         
                  UNION ALL
         
                  select c.pEmi       as pEmi,
                         c.pDest      as pDest,
                         d.pCliGrupo  as pGrp,
                         0            as sumExp1,
                         sum(b.nVenc) as sumExp2
                  from FIN_Titulos b join Ordens c on b.pOrdem = c.pPId
                                                  and c.tConf   is not null
                                                  and c.tLibCom is not null
                                                  and c.tCanc   is null
                                                  and c.lExc = 0
                                                  and c.iVer = c.iVAt
                                                  and c.pEmi  in ($sInE)
                                                  and c.pDest in ($sInD)
         
                                     join CUP d on c.pDest = d.pPId
                                               and d.iVer = d.iVAt
                  where b.iVer  = b.iVAt
                    and b.lExc  = 0
                    and b.jTipo = 0
                    and b.tPgmto is null
                    and b.tCanc is null
                  group by c.pEmi, c.pDest, d.pCliGrupo
         ) aa
         group by aa.pEmi,aa.pDest,aa.pGrp";

//echo "Qry Limite de Crdito Clientes";
$aDb  = faDbSelect($hDb,$sSql);
$aLimCred_Clientes = array();
$iLoop = 0;
foreach ($aDb as $aLin) {
   $pPId   = $iLoop+1;
   $pEmi   = $aLin[0];
   $pDest  = $aLin[1];
   $pCGrp  = $aLin[2];
   $nVal1  = $aLin[3];
   $nVal2  = $aLin[4];
   $aLimCred_Clientes[] = array('pPId'=>$pPId, 'pEmi'=>$pEmi, 'pDest'=>$pDest, 'pCGrp'=>$pCGrp, 'nVal1'=>$nVal1, 'nVal2'=>$nVal2);
   $iLoop++;
}
//echo " --> total de ($iLoop) registros".chr(10);


// -- //
// -- //
// -- //
// -- //
// -- //
// -- //
// -- //
// -- //
// -- //
// -- //
// -- //
// -- //
// -- //
// -- //
// -- //
// -- //



// Emi     -> $aCadE[$pEmi ] = array('sNome'=>$sNome,'sSigla'=>$sSigla,'sCNPJ'=>$sCNPJ,'jEnderEmit_CRT'=>$jEnderEmit_CRT,'nImpPFlex'=>$nImpPFlex);
$aTabEmi = array();
foreach ($aCadE as $pEmi => $aLin) {
   $aTabEmi[] = array('pPId'=>$pEmi,'sNome'=>$aLin['sNome'],'sSigla'=>$aLin['sSigla'],'sCNPJ'=>$aLin['sCNPJ'],'jEnderEmit_CRT'=>$aLin['jEnderEmit_CRT'],'nImpPFlex'=>$aLin['nImpPFlex']);
}

// Dest    -> $aCadD[$pDest] = array('sNome'=>$sNome,'jTipo'=>$jTipo,'sDoc'=>$sDoc,'jDest_indIEDest'=>$jDest_indIEDest);
$aTabDest = array();
foreach ($aCadD as $pDest => $aLin) {
   $aTabDest[] = array('pPId'=>$pDest,'sNome'=>$aLin['sNome'],'jTipo'=>$aLin['jTipo'],'sDoc'=>$aLin['sDoc'],'jDest_indIEDest'=>$aLin['jDest_indIEDest']);
}
// TOper   -> $aCadTOper[$pTOper] = array('sCTOper'=>$sCTOper,'sTOper'=>$sTOper,'lBonif'=>$lBonif,'lFinanc'=>$lFinanc,'lDevoluc'=>$lDevoluc);
$aTabTOper = array();
foreach ($aCadTOper as $pTOper => $aLin) {
   $aTabTOper[] = array('pPId'     => $pTOper, 
                        'sCTOper'  => $aLin['sCTOper'],
                        'sTOper'   => $aLin['sTOper'],
                        'lBonif'   => $aLin['lBonif'],
                        'lFinanc'  => $aLin['lFinanc'],
                        'lDevoluc' => $aLin['lDevoluc']);
}

// EndEmi  -> $aEndeE[$pCUP] = array('pPId'=>$pPId,'sLog'=>$sLog, 'sBai'=>$sBai, 'sNr'=>$sNr, 'sComp'=>$sComp, 'sCid'=>$sCid, 'sUF'=>$sUF, 'sSigla'=>$sSigla, 'pUFPos'=>$pUFPos);
$aTabEndEmi = array();
foreach ($aEndeE as $pEmi => $aLin) {
   $aTabEndEmi[] = array('pCUP'=>$pEmi,
                         'pPId'   => $aLin['pPId'],
                         'sLog'   => $aLin['sLog'],
                         'sBai'   => $aLin['sBai'],
                         'sNr'    => $aLin['sNr'],
                         'sComp'  => $aLin['sComp'],
                         'sCid'   => $aLin['sCid'],
                         'sUF'    => $aLin['sUF'],
                         'sSigla' => $aLin['sSigla'],
                         'pUFPos' => $aLin['pUFPos']);
}

// EndDest -> $aEndeD[$pCUP] = array('pPId'=>$pPId,'sLog'=>$sLog,'sBai'=>$sBai,'sNr'=>$sNr,'sComp'=>$sComp,'sCid'=>$sCid,'sUF'=>$sUF,'sSigla'=>$sSigla,'lGram'=>$lGram,'nPFCPUFDest'=>$nPFCPUFDest,'nPICMSUFDest'=>$nPICMSUFDest,'nPICMSInterPart'=>$nPICMSInterPart,'nVlMl1'=>$nVlMl1,'nVlMl2'=>$nVlMl2,'nVlMl3'=>$nVlMl3,'pUFPos'=>$pUFPos,'pUFEnt'=>$pUFEnt);
$aTabEndDest = array();
foreach ($aEndeD as $pDest => $aLin) {
   $aTabEndDest[] = array('pCUP'            => $pDest,
                          'pPId'            => $aLin['pPId'],
                          'sLog'            => $aLin['sLog'],
                          'sBai'            => $aLin['sBai'],
                          'sNr'             => $aLin['sNr'],
                          'sComp'           => $aLin['sComp'],
                          'sCid'            => $aLin['sCid'],
                          'sUF'             => $aLin['sUF'],
                          'sSigla'          => $aLin['sSigla'],
                          'lGram'           => $aLin['lGram'],
                          'nPFCPUFDest'     => $aLin['nPFCPUFDest'],
                          'nPICMSUFDest'    => $aLin['nPICMSUFDest'],
                          'nPICMSInterPart' => $aLin['nPICMSInterPart'],
                          'nVlMl1'          => $aLin['nVlMl1'],
                          'nVlMl2'          => $aLin['nVlMl2'],
                          'nVlMl3'          => $aLin['nVlMl3'],
                          'pUFPos'          => $aLin['pUFPos'],
                          'pUFEnt'          => $aLin['pUFEnt']);
}


// TOpED   -> $aTOpED [$pEmi][$pDest][$pTOper] = array('pPId'=>$pPId, 'lZFM'=>$lZFM, 'jIDE_IndFinal'=>$jIDE_IndFinal, 'nPDescLog'=>$nPDescLog);
$aTabTOpED = array();
foreach ($aTOpED as $pEmi=>$aLin) {
   foreach ($aLin as $pDest=>$aLin2) {
      foreach ($aLin2 as $pTOper=>$aLin3) {
//echo "pEmi=$pE	mi, pDest=$pDest, pTOper=$pTOper, aLin3=".chr(10);
//echo var_dump($aLin3).chr(10);
         $aTabTOpED[] = array('pPId'=>$aLin3['pPId'], 'pEmi'=>$pEmi, 'pDest'=>$pDest, 'pTOper'=>$pTOper, 'lZFM'=>$aLin3['lZFM'], 'jIDE_IndFinal'=>$aLin3['jIDE_IndFinal'], 'nPEncFinTpED'=>$nPEncFinTpED, 'nPDescLog'=>$aLin3['nPDescLog'], 'jTpLP'=>$aLin3['jTpLP']);

      }
   }
}

// TOpEDI -> $aTOpEDI[$pEmi][$pDestDef][$pTOper][$pItem] = array('pPId'=>$pPId, 'nPEncFinTpED'=>$nPEncFinTpED);
$aTabTOpEDI = array();
$iLoop=0;
foreach ($aTOpEDI as $pEmi=>$aLin) {
   foreach ($aLin as $pDest=>$aLin2) {
      foreach ($aLin2 as $pTOper=>$aLin3) {
         foreach ($aLin3 as $pItem=>$aLin4) {
            $iLoop++;
            $pNCM  = $aCadItens[$pItem]['pNCM'];
            $pSGrp = $aCadItens[$pItem]['pSGrp'];
            $pUF2  = $aEndeD[$pDest]['pUFPos'];
if ($iLoop<10) echo "pNCM=$pNCM, pSGrp=$pSGrp, pUF2=$pUF2, pDest=$pDest<br>";

            $pRegF_IPI       = isset($aReg5[$pUF2][$pNCM][$pSGrp]['lIPI'      ]   ) ? $aReg5[$pUF2][$pNCM][$pSGrp]['lIPI'      ] : (isset($aReg4[$pUF2][$pNCM]['lIPI'      ]) ? $aReg4[$pUF2][$pNCM]['lIPI'      ] : 0);
            $pRegF_IPI_RE    = isset($aReg5[$pUF2][$pNCM][$pSGrp]['lIPI_RE'   ]   ) ? $aReg5[$pUF2][$pNCM][$pSGrp]['lIPI_RE'   ] : (isset($aReg4[$pUF2][$pNCM]['lIPI_RE'   ]) ? $aReg4[$pUF2][$pNCM]['lIPI_RE'   ] : 0);
            $pRegF_PIS       = isset($aReg5[$pUF2][$pNCM][$pSGrp]['lPIS'      ]   ) ? $aReg5[$pUF2][$pNCM][$pSGrp]['lPIS'      ] : (isset($aReg4[$pUF2][$pNCM]['lPIS'      ]) ? $aReg4[$pUF2][$pNCM]['lPIS'      ] : 0);
            $pRegF_PISST     = isset($aReg5[$pUF2][$pNCM][$pSGrp]['lPISST'    ]   ) ? $aReg5[$pUF2][$pNCM][$pSGrp]['lPISST'    ] : (isset($aReg4[$pUF2][$pNCM]['lPISST'    ]) ? $aReg4[$pUF2][$pNCM]['lPISST'    ] : 0);
            $pRegF_PIS_RE    = isset($aReg5[$pUF2][$pNCM][$pSGrp]['lPIS_RE'   ]   ) ? $aReg5[$pUF2][$pNCM][$pSGrp]['lPIS_RE'   ] : (isset($aReg4[$pUF2][$pNCM]['lPIS_RE'   ]) ? $aReg4[$pUF2][$pNCM]['lPIS_RE'   ] : 0);
            $pRegF_Cofins    = isset($aReg5[$pUF2][$pNCM][$pSGrp]['lCofins'   ]   ) ? $aReg5[$pUF2][$pNCM][$pSGrp]['lCofins'   ] : (isset($aReg4[$pUF2][$pNCM]['lCofins'   ]) ? $aReg4[$pUF2][$pNCM]['lCofins'   ] : 0);
            $pRegF_CofinsST  = isset($aReg5[$pUF2][$pNCM][$pSGrp]['lCofinsST' ]   ) ? $aReg5[$pUF2][$pNCM][$pSGrp]['lCofinsST' ] : (isset($aReg4[$pUF2][$pNCM]['lCofinsST' ]) ? $aReg4[$pUF2][$pNCM]['lCofinsST' ] : 0);
            $pRegF_Cofins_RE = isset($aReg5[$pUF2][$pNCM][$pSGrp]['lCofina_RE']   ) ? $aReg5[$pUF2][$pNCM][$pSGrp]['lCofina_RE'] : (isset($aReg4[$pUF2][$pNCM]['lCofina_RE']) ? $aReg4[$pUF2][$pNCM]['lCofina_RE'] : 0);
            $pRegF_ICMS      = isset($aReg5[$pUF2][$pNCM][$pSGrp]['lICMS'     ]   ) ? $aReg5[$pUF2][$pNCM][$pSGrp]['lICMS'     ] : (isset($aReg4[$pUF2][$pNCM]['lICMS'     ]) ? $aReg4[$pUF2][$pNCM]['lICMS'     ] : 0);
            $pRegF_ICMS_SN   = isset($aReg5[$pUF2][$pNCM][$pSGrp]['lICMS_SN'  ]   ) ? $aReg5[$pUF2][$pNCM][$pSGrp]['lICMS_SN'  ] : (isset($aReg4[$pUF2][$pNCM]['lICMS_SN'  ]) ? $aReg4[$pUF2][$pNCM]['lICMS_SN'  ] : 0);
            $pRegF_ICMS_RE   = isset($aReg5[$pUF2][$pNCM][$pSGrp]['lICMS_RE'  ]   ) ? $aReg5[$pUF2][$pNCM][$pSGrp]['lICMS_RE'  ] : (isset($aReg4[$pUF2][$pNCM]['lICMS_RE'  ]) ? $aReg4[$pUF2][$pNCM]['lICMS_RE'  ] : 0);

            $aTabTOpEDI[] = array('pPId'            => $aLin4['pPId']        ,
                                  'pEmi'            => $pEmi                 ,  
                                  'pDest'           => $pDest                , 
                                  'pTOper'          => $pTOper               , 
                                  'pItem'           => $pItem                , 
                                  'nPDescTpEDG'     => $aLin4['nPDescTpEDG'] , 
                                  'pRegF_IPI'       => $pRegF_IPI            ,     
                                  'pRegF_IPI_RE'    => $pRegF_IPI_RE         ,
                                  'pRegF_PIS'       => $pRegF_PIS            ,
                                  'pRegF_PISST'     => $pRegF_PISST          ,
                                  'pRegF_PIS_RE'    => $pRegF_PIS_RE         ,
                                  'pRegF_Cofins'    => $pRegF_Cofins         ,
                                  'pRegF_CofinsST'  => $pRegF_CofinsST       ,
                                  'pRegF_Cofins_RE' => $pRegF_Cofins_RE      ,
                                  'pRegF_ICMS'      => $pRegF_ICMS           ,
                                  'pRegF_ICMS_SN'   => $pRegF_ICMS_SN        ,
                                  'pRegF_ICMS_RE'   => $pRegF_ICMS_RE  
                                  );


         }
      }
   }
}

// ED_CPgmto -> $aPED_CPgmto[$pED] = $pCPgmto;   // $pED     = $pEmi.'/'.$pDest;
$aTabED_CPgmto = array();
foreach ($aPED_CPgmto as $psED=>$pCPgmto) {
   $pEmi  = explode('/',$psED)[0];
   $pDest = explode('/',$psED)[1];
 //$aTabED_CPgmto[] = array('pPId'=>$aLin['pPId'], 'pEmi'=>$pEmi, 'pDest'=>$pDest, 'pCPgmto'=>$pCPgmto);
   $aTabED_CPgmto[] = array('pEmi'=>$pEmi, 'pDest'=>$pDest, 'pCPgmto'=>$pCPgmto);
}

// CPgmto    -> $aCPgmto[$pCPgmto] = array($sCPgmto,$nDFin,$nDMed);
$aTabCPgmto = array();
foreach ($aCPgmto as $pCPgmto=>$aLin) {
   $aTabCPgmto[] = array('pPId'=>$pCPgmto, 'sCPgmto'=>$aLin['sCPgmto'], 'nDFin'=>$aLin['nDFin'], 'nDMed'=>$aLin['nDMed']);
}


// Itens     -> $aCadItens[$pItem] = array('sCItem'=>$sCItem, 'sItem'=>$sItem, 'pNCM'=>$pNCM, 'pSGrp'=>$pSGrp, 'pGrp'=>$pGrp, 'pUnVen'=>$pUnVen, 'sUnVen'=>$sUnVen, 'nMl'=>$nMl,'nTmpICMS_vBCST'=>$nTmpICMS_vBCST, 'nTmpICMS_vICMSST'=>$nTmpICMS_vICMSST,'nTmpICMS_vICMS'=>$nTmpICMS_vICMS);
$aTabItens = array();
foreach ($aCadItens as $pItem=>$aLin) {
   $aTabItens[] = array('pPId'=>$pItem, 'sCItem'=>$aLin['sCItem'], 'sItem'=>$aLin['sItem'], 'pNCM'=>$aLin['pNCM'], 'pSGrp'=>$aLin['pSGrp'], 'pGrp'=>$aLin['pGrp'], 'pUnVen'=>$aLin['pUnVen'], 'sUnVen'=>$aLin['sUnVen'], 'nMl'=>$aLin['nMl'],'nTmpICMS_vBCST'=>$aLin['nTmpICMS_vBCST'], 'nTmpICMS_vICMSST'=>$aLin['nTmpICMS_vICMSST'],'nTmpICMS_vICMS'=>$aLin['nTmpICMS_vICMS'], 'pNCM'=>$aLin['pNCM'], 'sCNCM'=>$aLin['sCNCM'], 'sNCM'=>$aLin['sNCM'], 'nAliqTranspNac'=>$aLin['nAliqTranspNac'], 'pSGrp'=>$aLin['pSGrp'], 'sCSGrp'=>$aLin['sCSGrp'], 'sSGrp'=>$aLin['sSGrp'], 'pGrp'=>$aLin['pGrp'], 'sCGrp'=>$aLin['sCGrp'], 'sGrp'=>$aLin['sGrp']);
}


// TabPr_CUP -> $aTabEmiCUP[$pEmi][$pCUP][$pItm] = array($pTab,$nVa0,$nVa1,$nVa2);
$aTabPrCUP = array();
foreach ($aTabEmiCUP as $pEmi=>$aLin) {
   foreach ($aLin as $pCUP=>$aLin2) {
      foreach ($aLin2 as $pItem=>$aLin3) {
         $aTabPrCUP[] = array('pPId'=>$aLin3['pTab'], 'pEmi'=>$pEmi, 'pCUP'=>$pCUP, 'pItem'=>$pItem, 'nVa0'=>$aLin3['nVa0'], 'nVa1'=>$aLin3['nVa1'], 'nVa2'=>$aLin3['nVa2']);
      }
   }
}

// TabPr_UF  -> $aTabEmiUF[$pEmi][$pUF][$pItm] = array($pTab,$nVa0,$nVa1,$nVa2);
$aTabPrUF = array();
foreach ($aTabEmiUF as $pEmi=>$aLin) {
   foreach ($aLin as $pUF=>$aLin2) {
      foreach ($aLin2 as $pItem=>$aLin3) {
         $aTabPrUF[] = array('pPId'=>$aLin3['pTab'], 'pEmi'=>$pEmi, 'pUF'=>$pUF, 'pItem'=>$pItem, 'nVa0'=>$aLin3['nVa0'], 'nVa1'=>$aLin3['nVa1'], 'nVa2'=>$aLin3['nVa2']);
      }
   }
}

// TabPr_GrpPromo -> $aTabPromo[$pTab][$pGrpPromo] = array($nQtDe1,$nQtAte1,$nPrU1,$nPCom1,$nQtDe2,$nQtAte2,$nPrU2,$nPCom2,$nQtDe3,$nQtAte3,$nPrU3,$nPCom3);
$aTabPr_GrpPromo = array();
foreach ($aTabPromo as $pTab=>$aLin) {
   foreach ($aLin as $pGrpPromo=>$aLin2) {
      $aTabPr_GrpPromo[] = array('pPId'=>$pTab, 'pGrpPromo'=>$pGrpPromo, 'nQtDe1'=>$aLin2['nQtDe1'], 'nQtAte1'=>$aLin2['nQtAte1'], 'nPrU1'=>$aLin2['nPrU1'], 'nPCom1'=>$aLin2['nPCom1'], 'nQtDe2'=>$aLin2['nQtDe2'], 'nQtAte2'=>$aLin2['nQtAte2'], 'nPrU2'=>$aLin2['nPrU2'], 'nPCom2'=>$aLin2['nPCom2'] , 'nQtDe3'=>$aLin2['nQtDe3'], 'nQtAte3'=>$aLin2['nQtAte3'], 'nPrU3'=>$aLin2['nPrU3'], 'nPCom3'=>$aLin2['nPCom3']);
   }
}


// RegFiscal -> $aRegF[$pRegF] = $aLin;
// $aTabRegF = array();    // = $aCadRegF
                        
// Regime Especial
// $aRegEspec_ClientesNCM
// $aRegEspec_IPIUniTrib

// aRegEspec_ItensNCM
// aRegEspec_ItensNCM_UF
// aRegEspec_Clientes
// aLimCred_Clientes
//--//


$response = [
    'success' => true,
    'data' => [
        'emissores'              => $aTabEmi,
        'destinatarios'          => $aTabDest,
        'enderecosemissores'     => $aTabEndEmi,
        'enderecosdestinatarios' => $aTabEndDest,
        'tiposdeoperacao'        => $aTabTOper,
        'TOpED'                  => $aTabTOpED,
        'TOpEDI'                 => $aTabTOpEDI,
        'ED_CPgmto'              => $aTabED_CPgmto,
        'CPgmto'                 => $aTabCPgmto,
        'Itens'                  => $aTabItens,
        'TabPrCUP'               => $aTabPrCUP,
        'TabPrUF'                => $aTabPrUF,
        'TabPr_GrpPromo'         => $aTabPr_GrpPromo,
        'TabRegFiscais'          => $aCadRegF,
        'RegEspec_ClientesNCM'   => $aRegEspec_ClientesNCM,
        'RegEspec_IPIUniTrib'    => $aRegEspec_IPIUniTrib,
        'RegEspec_ItensNCM'      => $aRegEspec_ItensNCM,
        'RegEspec_ItensNCM_UF'   => $aRegEspec_ItensNCM_UF,
        'RegEspec_Clientes'      => $aRegEspec_Clientes,
        'LimCred_Clientes'       => $aLimCred_Clientes
    ],
    'timestamp' => date('Y-m-d H:i:s')
];

// Define o cabealho e retorna JSON
//header('Content-Type: application/json; charset=utf-8');
//$response = array_map('utf8_encode', $response);
//$response = convert_to_utf8($response);
echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
//
 
function convert_to_utf8($data) {
    if (is_array($data)) {
        return array_map('convert_to_utf8', $data);
    } elseif (is_string($data)) {
        // Verifica se j no  UTF-8
        if (mb_detect_encoding($data, 'UTF-8', true) === false) {
            return utf8_encode($data);
        }
        return $data;
    }
    return $data;
}



function quebrarListaIN($lista, $tamanhoChunk = 1500) {
///////////////////////////////////////////////////////
    $itens = explode(',', $lista);
    $chunks = array_chunk($itens, $tamanhoChunk);
    
    $partes = [];
    foreach ($chunks as $chunk) {
        $partes[] = implode(',', $chunk);
    }
    
    return $partes;
}


?>