async function flOVCalculoFiscal() {
////////////////////////////////////
// Vem da Tela - usurio informa
// Capa
var pEmi                          = oGlobalOV.Emi.pPId                   ;
var pDest                         = oGlobalOV.Dest.pPId                  ;
var tEntrega                      = oGlobalOV.tEntrega                   ;
var sObs                          = oGlobalOV.sObs                       ;
var pCPmgto                       = oGlobalOV.CPgmto.pPId                ;
var pTOper                        = oGlobalOV.TOper.pPId                 ;
var jItem                         = oGlobalOV.jItem                      ;
// Linha
var pItem                         = oGlobalOV.aItens[jItem].pItem         ;
var nPrBruto                      = oGlobalOV.aItens[jItem].nPrBruto      ;    
var nPDescInc                     = oGlobalOV.aItens[jItem].nPDescInc     ;   
var nQt                           = oGlobalOV.aItens[jItem].nQt           ;         

// Vem do Banco - necessrios fiscal
var jDest_indIEDest               = oGlobalOV.Dest.jDest_indIEDest       ;
var lBonif                        = oGlobalOV.TOper.lBonif               ;
var lFinanc                       = oGlobalOV.TOper.lFinanc              ;
var lDevoluc                      = oGlobalOV.TOper.lDevoluc             ;
var pUFEmiEndPos                  = oGlobalOV.EndeE.pUFPos               ;
var jEnderEmit_CRT                = oGlobalOV.EndeE.jEnderEmit_CRT       ;
var pDestUFEnt                    = oGlobalOV.EndeD.pUFEnt               ;
var pUFDestEndPos                 = oGlobalOV.EndeD.pUFPos               ;
var nPFCPUFDest                   = oGlobalOV.EndeD.nPFCPUFDest          ;
var nPICMSUFDest                  = oGlobalOV.EndeD.nPICMSUFDest         ;
var nPICMSInterPart               = oGlobalOV.EndeD.nPICMSInterPart      ;
var pUF2                          = oGlobalOV.EndeD.pUFPos               ;
var lZFM                          = oGlobalOV.EDTOp.lZFM                 ;
var jIDE_IndFinal                 = oGlobalOV.EDTOp.jIDE_IndFinal        ;
var nPEncFinTpED                  = oGlobalOV.EDTOp.nPEncFinTpED         ;
var nPDescLog                     = oGlobalOV.EDTOp.nPDescLog            ;   
var jTpLP                         = oGlobalOV.EDTOp.jTpLP                ;
var nDFin                         = oGlobalOV.CPgmto.nDFin               ;   // PED_CPgmto[pEmi][pDest] -> pCPgmto

// Valores matados
var nPDescTpED                    = 0                                    ;   // matado erp_ORDENS_CanalWeb.dda - ChaveIrma6
var nVAcresOsa                    = 0                                    ;
var jOrig                         = 0                                    ;
var jICMS_Orig                    = jOrig                                ;
var jICMSPart_Orig                = jOrig                                ;
var jICMSST_Orig                  = jOrig;

// Reset oGlobalOV
oGlobalOV.nTot_vIPI               = 0                                    ;   // IPI
oGlobalOV.nTot_vPIS               = 0                                    ;   // PIS
oGlobalOV.nTot_vCOFINS            = 0                                    ;   // COFINS
oGlobalOV.nTot_vICMS              = 0                                    ;   // ICMS
oGlobalOV.nTot_vICMSDeson         = 0                                    ;
oGlobalOV.nTot_vBCST              = 0                                    ;
oGlobalOV.nTot_vST                = 0                                    ;
oGlobalOV.nVFCPUFDest             = 0                                    ;
oGlobalOV.nVICMSUFDest            = 0                                    ;
oGlobalOV.nVICMSUFRemet           = 0                                    ;
oGlobalOV.nICMSTot_vFCP           = 0                                    ;
oGlobalOV.nICMSTot_vFCPST         = 0                                    ;
oGlobalOV.nICMSTot_vFCPSTRet      = 0                                    ;
oGlobalOV.nTot_vBCST              = 0                                    ;
oGlobalOV.nTot_vST                = 0                                    ;
oGlobalOV.nICMSTot_vFCP           = 0                                    ;
oGlobalOV.nICMSTot_vFCPST         = 0                                    ;
oGlobalOV.nICMSTot_vFCPSTRet      = 0                                    ;

//oGlobalOV.jItem

for (var jItem in oGlobalOV.aItens) {
// -----------------------
// Loop nos Itens da Ordem
// -----------------------

   // Vem da Tela - usurio informa
   var pItem                      = oGlobalOV.aItens[jItem].pItem              ;
   var nPrBruto                   = oGlobalOV.aItens[jItem].nPrBruto           ;    
   var nPDescInc                  = oGlobalOV.aItens[jItem].nPDescInc          ;   
   var nQt                        = oGlobalOV.aItens[jItem].nQt                ;         

   // Vem do Banco - necessrios fiscal
   var pNCM                       = oGlobalOV.aItens[jItem].pNCM;
   var pSubGrpSku                 = oGlobalOV.aItens[jItem].pSGrp;
   var nTmpICMS_vBCST             = oGlobalOV.aItens[jItem].nTmpICMS_vBCST     ;   // Valor BC ICMS retido   ; nTmpICMS_vBCST
   var nTmpICMS_vICMSST           = oGlobalOV.aItens[jItem].nTmpICMS_vICMSST   ;   // Valor ICMS retido      ; nTmpICMS_vICMSST
   var nTmpICMS_vICMS             = oGlobalOV.aItens[jItem].nTmpICMS_vICMS     ;   //
   var nAliqTranspNac             = oGlobalOV.aItens[jItem].nAliqTranspNac     ;   
   var pSGrp                      = oGlobalOV.aItens[jItem].pSGrp              ;
   var nPDescTpEDG                = oGlobalOV.aItens[jItem].nPDescTpEDG        ;   // ** aqui testar pDest caso nao exista pDestDef 'PTOpEDI'

   // Clculos - valores
   var nVDescInc                  = Number((nPrBruto*nPDescInc   /100).toFixed(5))                                                                              ;
   var nVDescTpEDG                = Number((nPrBruto*nPDescTpEDG /100).toFixed(5))                                                                              ;
   var nVDescTpED                 = Number((nPrBruto*nPDescTpED  /100).toFixed(5))                                                                              ;
   var nVEncFinTpED               = Number((nPrBruto*nPEncFinTpED/100).toFixed(5))                                                                              ;
   var nVDescCP                   = ((lBonif==1)||((lFinanc==0)&&(lDevoluc==0))) ? 0 : Number(((nPrBruto-((nPrBruto/100*(nPDescInc))))*nDFin/100).toFixed(5))   ;
   var nVDescLog                  = (nPDescLog>0) ? Number((((nPrBruto-((nPrBruto/100*(nPDescInc))))-nVDescCP)/100*nPDescLog).toFixed(5)) : 0                   ;
   var nProd_vUnCom               = nPrBruto-nVDescTpED-nVDescTpEDG-nVDescInc-nVDescCP-nVDescLog+nVEncFinTpED                                                   ;
   var nProd_vProd                = Number((nProd_vUnCom*nQt).toFixed(2))                                                                                       ;
   var nProd_vUnCom               = (nQt>0) ? Number((nProd_vProd/nQt).toFixed(10)) : nProd_vUnCom                                                              ;
   var nTot_vTrib                 = Number((nProd_vProd*nAliqTranspNac/100).toFixed(2))                                                                         ;

   // Busca dos Registros Fiscais
   oCadRegFItem = foCadRegFItem();

   // Carga Inicial IPI
   pRegF                          = oCadRegFItem.pRegFIPI                           ;
   pRegFiscais_RegFIPI            = pRegF                                           ;
   nRegFiscais_PRBCIPI            = pRegF==0 ? 0 : oCadRegFItem.nPRBCIPI            ;
   jRegFiscais_CSTIPI             = pRegF==0 ? 0 : oCadRegFItem.jCSTIPI             ;
   nRegFiscais_IpiAli             = pRegF==0 ? 0 : oCadRegFItem.nIpiAli             ;

   // Carga Inicial IPI_RE
   pRegF                          = oCadRegFItem.pRegFIPI_RE                        ;
   pRegFiscais_RegFIPI_RE         = pRegF                                           ;
   jRegFiscais_CSTIPI_RE          = pRegF==0 ? 0 : oCadRegFItem.jCSTIPI_RE          ;
   nRegFiscais_IpiAli_RE          = pRegF==0 ? 0 : oCadRegFItem.nIpiAli_RE          ;

   // Carga Inicial PIS
   pRegF                          = oCadRegFItem.pRegFPIS                           ;
   pRegFiscais_RegFPIS            = pRegF                                           ;
   nRegFiscais_PPIS               = pRegF==0 ? 0 : oCadRegFItem.nPPIS               ;
   jRegFiscais_CSTPIS             = pRegF==0 ? 0 : oCadRegFItem.jCSTPIS             ;
   
   // Carga Inicial PIS_RE
   pRegF                          = oCadRegFItem.pRegFPIS_RE                        ;
   pRegFiscais_RegFPIS_RE         = pRegF                                           ;
   nRegFiscais_PPIS_RE            = pRegF==0 ? 0 : oCadRegFItem.nPPIS_RE            ;
   jRegFiscais_CSTPIS_RE          = pRegF==0 ? 0 : oCadRegFItem.jCSTPIS_RE          ;

   // Carga Inicial Cofins
   pRegF                          = oCadRegFItem.pRegFCofins                        ;
   pRegFiscais_RegFCofins         = pRegF                                           ;
   nRegFiscais_PCofins            = pRegF==0 ? 0 : oCadRegFItem.nPCofins            ;
   jRegFiscais_CSTCofins          = pRegF==0 ? 0 : oCadRegFItem.jCSTCofins          ;
   
   // Carga Inicial Cofins_RE
   pRegF                          = oCadRegFItem.pRegFCofins_RE                     ;
   pRegFiscais_RegFCofins_RE      = pRegF                                           ;
   nRegFiscais_PCofins_RE         = pRegF==0 ? 0 : oCadRegFItem.nPCofins_RE         ;
   jRegFiscais_CSTCofins_RE       = pRegF==0 ? 0 : oCadRegFItem.jCSTCofins_RE       ;

   // Carga Inicial ICMS
   pRegF                          = oCadRegFItem.pRegFICMS                          ;
   pRegFiscais_RegFICMS           = pRegF                                           ;
   jRegFiscais_CSTICMS            = pRegF==0 ? 0 : oCadRegFItem.jCSTICMS            ;
   jRegFiscais_ICMS_modBC         = pRegF==0 ? 0 : oCadRegFItem.jICMS_modBC         ;
   nRegFiscais_PRedBCST           = pRegF==0 ? 0 : oCadRegFItem.nPRedBCST           ;
   jRegFiscais_ICMS_modBCST       = pRegF==0 ? 0 : oCadRegFItem.jICMS_modBCST       ;
   nRegFiscais_PICMS              = pRegF==0 ? 0 : oCadRegFItem.nPICMS              ;
   nRegFiscais_MEstim             = pRegF==0 ? 0 : oCadRegFItem.nMEstim             ;
   nRegFiscais_PIcmsST            = pRegF==0 ? 0 : oCadRegFItem.nPIcmsST            ;
   nRegFiscais_PIncidIPIICMS      = pRegF==0 ? 0 : oCadRegFItem.nPIncidIPIICMS      ;
   lRegFiscais_ICMS_FCP           = pRegF==0 ? 0 : oCadRegFItem.lICMS_FCP           ;
   lRegFiscais_ICMS_FCPST         = pRegF==0 ? 0 : oCadRegFItem.lICMS_FCPST         ;
   lRegFiscais_ICMS_FCPSTRet      = pRegF==0 ? 0 : oCadRegFItem.lICMS_FCPSTRet      ;
   pRegFiscais_CBenef             = pRegF==0 ? 0 : oCadRegFItem.pCBenef             ;
   lRegFiscais_CalcDeson          = pRegF==0 ? 0 : oCadRegFItem.lCalcDeson          ;
   lRegFiscais_FCPConsFinal       = pRegF==0 ? 0 : oCadRegFItem.lFCPConsFinal       ;
   nRegFiscais_PRedBC             = pRegF==0 ? 0 : oCadRegFItem.nPRedBC             ;
                
   // Carga Inicial ICMS_RE
   pRegF                          = oCadRegFItem.pRegFICMS_RE                       ;
   pRegFiscais_RegFICMS_RE        = pRegF                                           ;
   jRegFiscais_CSTICMS_RE         = pRegF==0 ? 0 : oCadRegFItem.jCSTICMS_RE         ;       
   jRegFiscais_ICMS_modBC_RE      = pRegF==0 ? 0 : oCadRegFItem.jICMS_modBC_RE      ;    
   nRegFiscais_PRedBCST_RE        = pRegF==0 ? 0 : oCadRegFItem.nPRedBCST_RE        ;
   jRegFiscais_ICMS_modBCST_RE    = pRegF==0 ? 0 : oCadRegFItem.jICMS_modBCST_RE    ;
   nRegFiscais_PICMS_RE           = pRegF==0 ? 0 : oCadRegFItem.nPICMS_RE           ;
   nRegFiscais_Mestim_RE          = pRegF==0 ? 0 : oCadRegFItem.nMestim_RE          ;
   nRegFiscais_PICMSST_RE         = pRegF==0 ? 0 : oCadRegFItem.nPICMSST_RE         ;
   nRegFiscais_PIncidIPIICMS_RE   = pRegF==0 ? 0 : oCadRegFItem.nPIncidIPIICMS_RE   ;
   lRegFiscais_FCPConsFinal_RE    = pRegF==0 ? 0 : oCadRegFItem.lFCPConsFinal_RE    ;
   lRegFiscais_ICMS_FCP_RE        = pRegF==0 ? 0 : oCadRegFItem.lICMS_FCP_RE        ;
   lRegFiscais_ICMS_FCPST_RE      = pRegF==0 ? 0 : oCadRegFItem.lICMS_FCPST_RE      ;
   lRegFiscais_ICMS_FCPSTRet_RE   = pRegF==0 ? 0 : oCadRegFItem.lICMS_FCPSTRet_RE   ;
   nRegFiscais_PRedBC_RE          = pRegF==0 ? 0 : oCadRegFItem.nPRedBC_RE          ;
                      
   // Carga Inicial - ICMS SN
   pRegF                          = oCadRegFItem.pRegFICMS_SN                       ;
   pRegFiscais_RegFICMS_SN        = pRegF                                           ;
   jRegFiscais_Grupo_simples      = pRegF==0 ? 0 : oCadRegFItem.jGrupo_simples      ;
   nRegFiscais_ICMSSN_pMVAST      = pRegF==0 ? 0 : oCadRegFItem.nICMSSN_pMVAST      ;
   nRegFiscais_ICMSSN_pRedBCST    = pRegF==0 ? 0 : oCadRegFItem.nICMSSN_pRedBCST    ;
   nRegFiscais_ICMSSN_pICMSST     = pRegF==0 ? 0 : oCadRegFItem.nICMSSN_pICMSST     ;
   nRegFiscais_ICMSSN_pCredSN     = pRegF==0 ? 0 : oCadRegFItem.nICMSSN_pCredSN     ;
   nRegFiscais_ICMSSN_pICMS       = pRegF==0 ? 0 : oCadRegFItem.nICMSSN_pICMS       ;
   jRegFiscais_Grupo_simples_RE   = pRegF==0 ? 0 : oCadRegFItem.jGrupo_simples_RE   ; 
   nRegFiscais_ICMSSN_pMVAST_RE   = pRegF==0 ? 0 : oCadRegFItem.nICMSSN_pMVAST_RE   ; 
   nRegFiscais_ICMSSN_pRedBCST_RE = pRegF==0 ? 0 : oCadRegFItem.nICMSSN_pRedBCST_RE ; 
   nRegFiscais_ICMSSN_pICMSST_RE  = pRegF==0 ? 0 : oCadRegFItem.nICMSSN_pICMSST_RE  ; 
   nRegFiscais_ICMSSN_pCredSN_RE  = pRegF==0 ? 0 : oCadRegFItem.nICMSSN_pCredSN_RE  ; 
   nRegFiscais_ICMSSN_pICMS_RE    = pRegF==0 ? 0 : oCadRegFItem.nICMSSN_pICMS_RE    ; 
   

   // INICIO - Regime Especial
   // INICIO Valores Iniciais 
   // -----------------------------------------
   // oNCM_RE              9
   // oNCMIPI_RE           9
   // oItensIPI_RE        11
   // oItemNCM_ICMSRE     12
   // oItemNCM_IPIRE      12
   // oItemNCM_PISRE      12
   // oItemNCM_COFINSRE   12
   // oItemNCM_ICMSSNRE   12
   // oItemNCM_UF_IPI     16
   // oItemNCM_UF_PIS     16
   // oItemNCM_UF_COFINS  16
   // oItemNCM_UF_ICMS    16
   // oItemNCM_UF_ICMSSN  16
   // oRE_ClientesICMS    17
   // oRE_ClientesIPI     17

   sNCMItem = pNCM+'/'+pItem;

   // RegEspec_ClientesNCM - 9
   // ------------------------
   aPar = [pEmi,pDest,pNCM];
   sSql = "select a.lICMS_RE,a.lIPI_RE from RegEspec_ClientesNCM a where (a.lICMS_RE=1 or a.lIPI_RE=1) and a.pEmi=? and a.pDest=? and a.pNCM=?";
   oDb  = await foDbSelect(sSql,aPar);

   oNCM_RE    = {};
   oNCMIPI_RE = {};
   for (let j = 0; j < oDb.length; j++) {
      lICMS_RE = oDb[j].lICMS_RE;
      lIPI_RE  = oDb[j].lIPI_RE;
      if (lICMS_RE==true) {   // (lICMS_RE === 1) // SQLite retorna 1/0 para boolean
         if (oNCM_RE[pNCM]==null) oNCM_RE[pNCM] = 1;   // (oNCM_RE[pNCM] === null || oNCM_RE[pNCM] === undefined)
      }
      if (lIPI_RE==true) {
         if (oNCMIPI_RE[pNCM])==null) oNCMIPI_RE[pNCM] = 1;
      }
   }
    
   // RegEspec_IPIUniTrib - 11
   // ------------------------
   aPar = [pEmi,pDest,pItem];
   sSql = "select a.nValor from RegEspec_IPIUniTrib a where a.pEmi=? and a.pDest=? and a.pItem=?";
   oDb  = await foDbSelect(sSql,aPar);

   oItensIPI_RE = {};
   for (let j = 0; j < oDb.length; j++) {
      nValor = oDb[j].nValor;
      if (oItensIPI_RE[pItem]==null) oItensIPI_RE[pItem] = nValor;
   }
   
   // RegEspec_ItensNCM - 12 
   // ----------------------
   aPar = [pEmi,pItem];
   sSql = "select a.lICMS_RE,a.lIPI_RE,a.lPIS_RE,a.lCOFINS_RE,a.lICMSSN_RE from RegEspec_ItensNCM a where a.pEmi=? and a.pItem=?";
   oDb  = await foDbSelect(sSql,aPar);

   oItemNCM_ICMSRE   = {};
   oItemNCM_IPIRE    = {};
   oItemNCM_PISRE    = {};
   oItemNCM_COFINSRE = {}; 
   oItemNCM_ICMSSNRE = {};
   for (let j = 0; j < oDb.length; j++) {
      lICMS_RE   = oDb[j].lICMS_RE   ;
      lIPI_RE    = oDb[j].lIPI_RE    ;
      lPIS_RE    = oDb[j].lPIS_RE    ;
      lCOFINS_RE = oDb[j].lCOFINS_RE ;
      lICMSSN_RE = oDb[j].lICMSSN_RE ;
      if (lICMS_RE==true) {
         if (oItemNCM_ICMSRE[sNCMItem]   ==null) oItemNCM_ICMSRE[sNCMItem]     = 1;
      }   
      if (lIPI_RE==true) {
         if (oItemNCM_IPIRE[sNCMItem]    ==null) oItemNCM_IPIRE[sNCMItem]      = 1;
      }   
      if (lPIS_RE==true) {
         if (oItemNCM_PISRE[sNCMItem]    ==null) oItemNCM_PISRE[sNCMItem]      = 1;
      }   
      if (lCOFINS_RE==true) {
         if (oItemNCM_COFINSRE[sNCMItem] ==null) oItemNCM_COFINSRE[sNCMItem]   = 1;
      }   
      if (lICMSSN_RE==true) {
         if (oItemNCM_ICMSSNRE[sNCMItem] ==null) oItemNCM_ICMSSNRE[sNCMItem]   = 1;
      }   
   }
   
   // RegEspec_ItensNCM x RegEspec_ItensNCM_UFs - 16
   // ----------------------------------------------
   aPar = [pEmi,pItem];
   sSql = "select a.lICMS_RE,a.lIPI_RE,a.lPIS_RE,a.lCOFINS_RE,d.pUF,a.lICMSSN_RE from RegEspec_ItensNCM a join RegEspec_ItensNCM_UFs d on d.pCapa=a.pPId where a.pEmi=? and a.pItem=?";
   oDb  = await foDbSelect(sSql,aPar);

   oItemNCM_UF_IPI    = {};
   oItemNCM_UF_PIS    = {};
   oItemNCM_UF_COFINS = {};
   oItemNCM_UF_ICMS   = {};
   oItemNCM_UF_ICMSSN = {};
   for (let j = 0; j < oDb.length; j++) {
      lICMS_RE    = oDb[j].lICMS_RE    ;
      lIPI_RE     = oDb[j].lIPI_RE     ;
      lPIS_RE     = oDb[j].lPIS_RE     ;
      lCOFINS_RE  = oDb[j].lCOFINS_RE  ;
      pUF         = oDb[j].pUF         ;
      lICMSSN_RE  = oDb[j].lICMSSN_RE  ;
      if (lIPI_RE==true) {
         if (oItemNCM_UF_IPI[sNCMItem])    ==null) oItemNCM_UF_IPI[sNCMItem]     = [];
         oItemNCM_UF_IPI[sNCMItem].push(pUF);
      }
      if (lPIS_RE==true) {
         if (oItemNCM_UF_PIS[sNCMItem])    ==null) oItemNCM_UF_PIS[sNCMItem]     = [];
         oItemNCM_UF_PIS[sNCMItem].push(pUF);
      }
      if (lCOFINS_RE==true) {
         if (oItemNCM_UF_COFINS[sNCMItem]) ==null) oItemNCM_UF_COFINS[sNCMItem]  = [];
         oItemNCM_UF_COFINS[sNCMItem].push(pUF);
      }
      if (lICMS_RE==true) {
         if (oItemNCM_UF_ICMS[sNCMItem])   ==null) oItemNCM_UF_ICMS[sNCMItem]    = [];
         oItemNCM_UF_ICMS[sNCMItem].push(pUF);
      }
      if (lICMSSN_RE==true) {
         if (oItemNCM_UF_ICMSSN[sNCMItem]) ==null) oItemNCM_UF_ICMSSN[sNCMItem]  = [];
         oItemNCM_UF_ICMSSN[sNCMItem].push(pUF);
      }
   }
   
   // RegEspec_Clientes - 17
   // ----------------------
   aPar = [pEmi,pDest];
   sSql = "select lICMS_RE,lIPI_RE from RegEspec_Clientes where pEmi  = ? and pDest = ?";
   oDb  = await foDbSelect(sSql,aPar);
   oRE_ClientesICMS = {};
   oRE_ClientesIPI  = {};
   for (let j = 0; j < oDb.length; j++) {
      lICMS_RE = oDb[j].lICMS_RE;
      lIPI_RE  = oDb[j].lIPI_RE ;
      if (lICMS_RE==true) {
         if (oRE_ClientesICMS[pDest])==null) oRE_ClientesICMS[pDest] = 1;
      }
      if (lIPI_RE==true) {
         if (oRE_ClientesIPI[pDest])==null) oRE_ClientesIPI[pDest] = 1;
      }
   }
   // Fim Valores Iniciais - Regime Especial
  
   // Inicio Calculos - Regime Especial
   // ---------------------------------
   // lDestICMS_RE
   // lDestIPI_RE
   // lINCMPIS_RE
   // lINCMCOFINS_RE
   // lDestICMSSN_RE

   oDest_RE          = {};
   oDestNCM_RE       = {};
   oItemNCMICMS_RE   = {};
   oDestIPI_RE       = {};
   oDestNCMIPI_RE    = {};
   oItemNCMIPI_RE    = {};
   oItemNCMPIS_RE    = {};
   oItemNCMCOFINS_RE = {};
   oItemNCMICMSSN_RE = {};

   // Regime Especial ICMS
   if (oDest_RE[pDest]==null) {   // ICMS_RE / aDest_RE - FISCAL 3.5 - Regime Especial por Emissor + Destinatrio
      oDest_RE[pDest] = (oRE_ClientesICMS[pDest]==null) ? 0 : 1;
   }
   lDestICMS_RE = oDest_RE[pDest]>0;
   if (lDestICMS_RE==false) {   // // NCM - aDestNCM_RE - 3.6. Regime Especial por Emissor + Destinatrio + NCM
      if (oDestNCM_RE[pNCM]==null) {
         oDestNCM_RE[pNCM] = (oaNCM_RE[pNCM]==null) ? 0 : 1;
      }
      lDestICMS_RE = (oDestNCM_RE[pNCM]>0);
   }
   if (lDestICMS_RE==false) {   // // NCM - ITEM - ICMS - 3.7. Regime Especial por Emissor + Item + NCM + {UFs}
      if (oItemNCMICMS_RE[sNCMItem]==null) {
         if ((oItemNCM_UF_ICMS[sNCMItem]==null)||(oItemNCM_UF_ICMS[sNCMItem].length==0)||(oItemNCM_UF_ICMS[sNCMItem].includes(pDestUFEnt))) {
            oItemNCMICMS_RE[sNCMItem] = oItemNCM_ICMSRE[sNCMItem]==null ? 0 : 1;
         }
      }
      lDestICMS_RE = ((oItemNCMICMS_RE[sNCMItem]!=null)&&(oItemNCMICMS_RE[sNCMItem]>0));
   }
   
   // Regime Especial IPI
   if (oDestIPI_RE[pDest]==null) {   // IPI_RE - aDestIPI_RE - FISCAL 3.5 - Regime Especial por Emissor + Destinatrio
      oDestIPI_RE[pDest] = (oRE_ClientesIPI[pDest]==null) ? 0 : 1;
   }
   lDestIPI_RE = (aDestIPI_RE[pDest]>0);
   if (lDestIPI_RE==false) {
      if (oDestNCMIPI_RE[pNCM]==null) {
         oDestNCMIPI_RE[pNCM] = oNCMIPI_RE[pNCM]==null ? 0 : 1;
      }
      lDestIPI_RE = (oDestNCMIPI_RE[pNCM]>0);
   }
   if (lDestIPI_RE==false) {   // // NCM - ITEM - IPI
      if (oItemNCMIPI_RE[sNCMItem]==null) {
         if ((oItemNCM_UF_IPI[sNCMItem]==null)||(oItemNCM_UF_IPI[sNCMItem].length==0)||(oItemNCM_UF_IPI[sNCMItem].includes(pDestUFEnt))) {   // no tem SOA de UFs ou a pDestUFEnt consta no SOA - aplicar RE
            oItemNCMIPI_RE[sNCMItem] = oItemNCM_IPIRE[sNCMItem]==null ? 0: 1;
         }
      }
      lDestIPI_RE = ((oItemNCMIPI_RE[sNCMItem]!=null)&&(oItemNCMIPI_RE[sNCMItem]>0));
   }
   
   // Regime Especial PIS
   lINCMPIS_RE = false;   // NCM - ITEM - PIS
   if (lINCMPIS_RE==false) {   // 
      if (oItemNCMPIS_RE[sNCMItem]==null) {
         if ((oItemNCM_UF_PIS[sNCMItem]==null)||(oItemNCM_UF_PIS[sNCMItem].length==0)||(oItemNCM_UF_PIS[sNCMItem].includes(pDestUFEnt))) {   // no tem SOA de UFs ou a pDestUFEnt consta no SOA - aplicar RE
            oItemNCMPIS_RE[sNCMItem] = oItemNCM_PISRE[sNCMItem]==null ? 0 : 1;
         }
      }
      lINCMPIS_RE = ((oItemNCMPIS_RE[sNCMItem]!=null)&&(oItemNCMPIS_RE[sNCMItem]>0));
   }
   
   // Regime Especial COFINS
   lINCMCOFINS_RE = false;   // NCM - ITEM - COFINS
   if (lINCMCOFINS_RE==false) {
      if (oItemNCMCOFINS_RE[sNCMItem]==null) {
         if ((oItemNCM_UF_COFINS[sNCMItem]==null)||(oItemNCM_UF_COFINS[sNCMItem].length==0)||(oItemNCM_UF_COFINS[sNCMItem].includes(pDestUFEnt))) {   // no tem SOA de UFs ou a pDestUFEnt consta no SOA - aplicar RE
            oItemNCMCOFINS_RE[sNCMItem] = oItemNCM_COFINSRE[sNCMItem]==null ? 0 : 1;
         }
      }
      lINCMCOFINS_RE = ((oItemNCMCOFINS_RE[sNCMItem]!=null)&&(oItemNCMCOFINS_RE[sNCMItem]>0));
   }
   
   // Regime Especial ICMSSN
   lDestICMSSN_RE=false;
   if (lDestICMSSN_RE==false) {
      if (oItemNCMICMSSN_RE[sNCMItem]==null) {
         if ((oItemNCM_UF_ICMSSN[sNCMItem]==null)||(oItemNCM_UF_ICMSSN[sNCMItem].length==0)||(oItemNCM_UF_ICMSSN[sNCMItem].includes(pDestUFEnt))) {   // no tem SOA de UFs ou a pDestUFEnt consta no SOA - aplicar RE
            oItemNCMICMSSN_RE[sNCMItem] = oItemNCM_ICMSSNRE[sNCMItem]==null ? 0 : 1;
         }
      }
      lDestICMSSN_RE = ((oItemNCMICMSSN_RE[sNCMItem]!=null)&&(oItemNCMICMSSN_RE[sNCMItem]>0));
   }
   // FIM Calculos 
   // FIM - Regime Especial

   // ---------------------------------------------------------------------  
   // ---------------------------------------------------------------------  
   // INICIO IMPOSTOS
   // ---------------------------------------------------------------------  
   // ---------------------------------------------------------------------  
   // INICIO - Imposto IPI
   jIPINT_CST    = ((lDestIPI_RE==true) && (jEnderEmit_CRT==2)) ? jRegFiscais_CSTIPI_RE : jRegFiscais_CSTIPI;
   nIPITrib_pIPI = 0;
   nIPITrib_vBC  = 0;
   nIPITrib_vIPI = 0;
   lIPI_UT       = oItensIPI_RE[pItem]!=null ? 1 : 0;
   nIPIVal_UT    = lIPI_UT ? oItensIPI_RE[pItem] : 0;
   if ([0, 6, 7, 13].includes(jIPINT_CST)) {   // 00, 49, 50, 99 - os demais nao calcula
      nPRBCIPI       = nRegFiscais_PRBCIPI;   // reduo % BC IPI	
      nIPITrib_pIPI  = ((lDestIPI_RE==true) && (jEnderEmit_CRT==2)) ? nRegFiscais_IpiAli_RE : nRegFiscais_IpiAli;
      nIPITrib_vBC   = nIPITrib_pIPI==0 ? 0 : fnRound(nProd_vProd * (1 - nPRBCIPI / 100),2);
      nIPITrib_vIPI  = ((lIPI_UT==true)&&(jEnderEmit_CRT==2)) ? fnRound(nIPIVal_UT*nQt,2) : fnRound(nIPITrib_pIPI*nIPITrib_vBC/100,2);
   }
   nIPITrib_vBC = nIPITrib_pIPI == 0 ? 0 : fnRound(nProd_vProd*(1-nPRBCIPI/100),2);   // Base Calculo sempre carregada
   // FIM - Imposto IPI
   
   // INICIO - Imposto PIS
   if (jEnderEmit_CRT<=2) {   // regime normal + simples nacional
      jPIS_CST  = (lINCMPIS_RE==true) ? jRegFiscais_CSTPIS_RE   : jRegFiscais_CSTPIS     ;
      nPIS_pPIS = (lINCMPIS_RE==true) ? nRegFiscais_PPIS_RE     : nRegFiscais_PPIS       ;
      nPIS_vBC  = 0;
      nPIS_vPIS = 0;
      if (([0,1,8,3,4,5,6,7].includes(jPIS_CST))||(nPIS_pPIS>0)) {
         nPIS_vBC  = nProd_vProd;
         nPIS_vPIS = fnRound(nPIS_pPIS*nPIS_vBC/100,2);
      }
   }
   if (jEnderEmit_CRT<2) {   // simples nacional
      jPIS_CST  = jRegFiscais_CSTPIS;
      nPIS_pPIS = nRegFiscais_PPIS;
      if (jPIS_CST==1) {    // 02 - Operao Tributvel (base de clculo = valor da operao)
         nPIS_vBC  = nProd_vProd;
         nPIS_vPIS = fnRound(nPIS_pPIS*nPIS_vBC/100,2);
      }
   }
   nPIS_vBC  = nProd_vProd;   // independente dos clculos a base de clculo deve ser carregada;
   // FIM - Imposto PIS
   
   // INICIO - Imposto COFINS
   if (jEnderEmit_CRT==2) {   // regime normal
      jCOFINS_CST     = ((lINCMCOFINS_RE==true) && (jEnderEmit_CRT==2)) ? jRegFiscais_CSTCofins_RE   : jRegFiscais_CSTCofins;
      nCOFINS_pCOFINS = ((lINCMCOFINS_RE==true) && (jEnderEmit_CRT==2)) ? nRegFiscais_PCofins_RE     : nRegFiscais_PCofins;
      nCOFINS_vBC     = 0;
      nCOFINS_vCOFINS = 0;
      if (([0,1,8,3,4,5,6,7,11].includes(jCOFINS_CST))||(nCOFINS_pCOFINS>0)) {
         nCOFINS_vBC     = nProd_vProd;
         nCOFINS_vCOFINS = fnRound(nCOFINS_pCOFINS*nCOFINS_vBC/100,2);
      }
   } else if (jEnderEmit_CRT<2) {   // simples nacional
      jCOFINS_CST     = jRegFiscais_CSTCofins;
      nCOFINS_pCOFINS = nRegFiscais_PCofins;
      nCOFINS_vBC     = nProd_vProd;
      nCOFINS_vCOFINS = fnRound(nCOFINS_pCOFINS*nCOFINS_vBC/100,2);
   }
   nCOFINS_vBC  = nProd_vProd;   // independente dos clculos a base de clculo deve ser carregada;
   // FIM - Imposto COFINS 
   
   // INICIO Imposto ICMS
   jICMS_GrupoTrib   = 0;
   jICMS_Orig        = 0;
   jICMS_modBC       = 0;
   nICMS_vBC         = 0;
   nICMS_pICMS       = 0;
   nICMS_vICMS       = 0;
   nICMS_vICMSDeson  = 0;
   jICMS_modBCST     = 0;
   nICMS_pMVAST      = 0;
   nICMS_pRedBCST    = 0;
   nICMS_vBCST       = 0;
   nICMS_pICMSST     = 0;
   nICMS_vICMSST     = 0;
   nICMS_pRedBC      = 0;
   nICMS_vBCSTRet    = 0;
   nICMS_vICMSSTRet  = 0;
   jICMSPart_Orig    = 0;
   jICMSST_Orig      = 0;
   nVBCUFDest        = 0;
   nVBCFCPUFDest     = 0;
   nPICMSInter       = 0;
   nVFCPUFDest       = 0;
   nVICMSUFDest      = 0;
   nVICMSUFRemet     = 0;
   nICMS_pST         = 0;
   nICMS_pFCP        = 0;
   nICMS_vFCP        = 0;
   nICMS_vBCFCP      = 0;
   nICMS_pFCPST      = 0;
   nICMS_vFCPST      = 0;
   nICMS_vBCFCPST    = 0;
   nICMS_pFCPSTRet   = 0;
   nICMS_vFCPSTRet   = 0;
   nICMS_vBCFCPSTRet = 0;
   jICMS_motDesICMS  = 0;
   lCalcDeson = 0;
   nICMS_vICMSSubstituto = 0;
   
   if (jEnderEmit_CRT==2) {   // regime normal
   
      jICMS_GrupoTrib    = (lDestICMS_RE==true) ? jRegFiscais_CSTICMS_RE       : jRegFiscais_CSTICMS       ;
      jICMS_modBC        = (lDestICMS_RE==true) ? jRegFiscais_ICMS_modBC_RE    : jRegFiscais_ICMS_modBC    ;
      nICMS_pRedBCST     = (lDestICMS_RE==true) ? nRegFiscais_PRedBCST_RE      : nRegFiscais_PRedBCST      ;
      jICMS_modBCST      = (lDestICMS_RE==true) ? jRegFiscais_ICMS_modBCST_RE  : jRegFiscais_ICMS_modBCST  ;
      nICMS_pICMS        = (lDestICMS_RE==true) ? nRegFiscais_PICMS_RE         : nRegFiscais_PICMS         ;
      nICMS_pMVAST       = (lDestICMS_RE==true) ? nRegFiscais_Mestim_RE        : nRegFiscais_MEstim        ;
      nICMS_pICMSST      = (lDestICMS_RE==true) ? nRegFiscais_PICMSST_RE       : nRegFiscais_PIcmsST       ;  
      nPIncidIPIICMS     = (lDestICMS_RE==true) ? nRegFiscais_PIncidIPIICMS_RE : nRegFiscais_PIncidIPIICMS ;
      lICMS_FCP          = lRegFiscais_ICMS_FCP         ;
      lICMS_FCPST        = lRegFiscais_ICMS_FCPST       ;
      lICMS_FCPSTRet     = lRegFiscais_ICMS_FCPSTRet    ;
      pCBenef            = pRegFiscais_CBenef           ;
      lCalcDeson         = lRegFiscais_CalcDeson        ;
      lFCPConsFinal      = lRegFiscais_FCPConsFinal     ;
      lFCPConsFinal_RE   = lRegFiscais_FCPConsFinal_RE  ;
      lICMS_FCP_RE       = lRegFiscais_ICMS_FCP_RE      ;
      lICMS_FCPST_RE     = lRegFiscais_ICMS_FCPST_RE    ;
      lICMS_FCPSTRet_RE  = lRegFiscais_ICMS_FCPSTRet_RE ;
      lBCST_Gram         = false;
   
      if (jICMS_GrupoTrib==0) {           // CST . 00 . Tributada integralmente 
      // ------------------------------------------------------------------------------------------------------------------
         nICMS_vBC    = nProd_vProd+(nIPITrib_vIPI*nPIncidIPIICMS/100);
         nICMS_vICMS  = fnRound(nICMS_pICMS*nICMS_vBC/100,2);
         if (((lICMS_FCP==1) || (lICMS_FCP_RE==1)) && (jIDE_IndFinal==0)) {
            nICMS_pFCP   = nPFCPUFDest;
            nICMS_vBCFCP = nICMS_vBC;
            nICMS_vFCP   = fnRound(nICMS_pFCP*nICMS_vBCFCP/100,2);
         }
   
      } else if (jICMS_GrupoTrib==1) {     // CST - 10 - Tributada e com cobrana do ICMS por substituio tributria
      // ------------------------------------------------------------------------------------------------------------------
         nICMS_vBC    = nProd_vProd+(nIPITrib_vIPI*nPIncidIPIICMS/100);
         nICMS_vICMS  = fnRound(nICMS_pICMS*nICMS_vBC/100,2);
         if (lBCST_Gram==true) {
            nICMS_vBCST  = nBCST_Gram;
            nICMS_pMVAST = 0;
         } else {
            nICMS_vBCST = (nProd_vProd+nIPITrib_vIPI)*(1+nICMS_pMVAST/100);
         }
         if (nICMS_pRedBCST>0) {
            if (lBCST_Gram==true) {
               nICMS_vBCST  = nBCST_Gram;
               nICMS_pMVAST = 0;
            } else {
               n0 = (100-nICMS_pRedBCST)/100;
               n1 = nICMS_vBCST*(100-nICMS_pRedBCST)/100;
               nICMS_vBCST = fnRound(nICMS_vBCST*(100-nICMS_pRedBCST)/100,2);
            }
         }
         nV1            = nICMS_vBCST*nICMS_pICMSST/100;
         nV2            = nProd_vProd*nICMS_pICMS/100;   // *
         nICMS_vICMSST  = fnRound(nV1-nV2,2);
         nICMS_pFCP0    = nPFCPUFDest;
         nPICMSUFDest0  = nPICMSUFDest;
         nICMS_pST      = nICMS_pFCP0+nPICMSUFDest0;
         if (((lICMS_FCP==1) || (lICMS_FCP_RE==1)) && (jIDE_IndFinal==0)) {
            nICMS_pFCP   = nPFCPUFDest;
            nICMS_vBCFCP = nICMS_vBC; 
            nICMS_vFCP   = fnRound(nICMS_pFCP*nICMS_vBCFCP/100,2);
         }
         if (((lICMS_FCPST==1) ||(lICMS_FCPST_RE==1)) && (jIDE_IndFinal==0)) {
            nICMS_pFCPST   = nPFCPUFDest;
            nICMS_vBCFCPST = nICMS_vBCST;
            nICMS_vFCPST   = fnRound(nICMS_pFCPST*nICMS_vBCFCPST/100,2);
         }
   
      } else if (jICMS_GrupoTrib==2) {    // CST - 20 - Com reduo de base de clculo
      // ------------------------------------------------------------------------------------------------------------------
         nICMS_pRedBC = ((lDestICMS_RE==true) && (jEnderEmit_CRT==2)) ? nRegFiscais_PRedBC_RE    : nRegFiscais_PRedBC      ;
         nICMS_vBC    = nProd_vProd+(nIPITrib_vIPI*nPIncidIPIICMS/100);
         nICMS_vBC    = fnRound(nICMS_vBC*(100-nICMS_pRedBC)/100,2);   // reduzindo base
         nICMS_vICMS  = fnRound(nICMS_pICMS*nICMS_vBC/100,2);
   
         if (lZFM==1) { 
            nICMS_vICMSDeson = nProd_vProd*nICMS_pICMS/100;
            nICMS_vBC        = 0;
            nICMS_vICMS      = 0;
         }
         if (lCalcDeson==1) {
            nICMS_vBCDeson      = nProd_vProd+(nIPITrib_vIPI*nPIncidIPIICMS/100);   
            nICMS_vICMSIntegral = fnRound(nICMS_pICMS*nICMS_vBCDeson/100,2);                    
            nICMS_vICMSDeson    = nICMS_vICMSIntegral-nICMS_vICMS;                   
         }
         // fcp II
         if (((lICMS_FCP==1) || (lICMS_FCP_RE==1)) && (jIDE_IndFinal==0)) {
            nICMS_pFCP   = nPFCPUFDest;
            nICMS_vBCFCP = nICMS_vBC;
            nICMS_vFCP   = fnRound(nICMS_pFCP*nICMS_vBCFCP/100,2);
         }
   
      } else if (jICMS_GrupoTrib==3) {     // CST - 30 - Isenta ou no tributada e com cobrana do ICMS por substituio tributria
      // ------------------------------------------------------------------------------------------------------------------
         if (nICMS_pMVAST==0) {
         } else {
            if (lZFM==1) {
               nICMS_vBCST = fnRound(nProd_vProd-(nProd_vProd*nICMS_pICMS/100),2);
               nICMS_vBCST = (nICMS_vBCST+nIPITrib_vIPI)*(1+nICMS_pMVAST/100);
            } else {
               if (lBCST_Gram==true) {
                  nICMS_vBCST  = nBCST_Gram;
                  nICMS_pMVAST = 0;
               } else {
                  nICMS_vBCST  = fnRound((nProd_vProd+nIPITrib_vIPI)*(1+nICMS_pMVAST/100),2);
               }
            }
            if (nICMS_pRedBCST>0) { 
               if (lBCST_Gram==true) {
                  nICMS_vBCST  = nBCST_Gram;
                  nICMS_pMVAST = 0;
               } else {
                  nICMS_vBCST  = fnRound(nICMS_vBCST*(100-nICMS_pRedBCST)/100,2);
               }
            } 
            nV1 = nICMS_vBCST*nICMS_pICMSST/100;
            if (nICMS_pRedBCST>0) nV2 = nProd_vProd*nICMS_pICMS/100;   // (*)
            else                   nV2 = nProd_vProd*nICMS_pICMS/100;
            nICMS_vICMSST = fnRound(nV1-nV2,2);
         }  
         if (lZFM==1) { 
            nICMS_vBC        = nProd_vProd;                     
            nICMS_vICMSDeson = nICMS_vBC*nICMS_pICMS/100;      
         }
   
      } else if ((jICMS_GrupoTrib>=4) && (jICMS_GrupoTrib<=6)) {     // CST - 40,41,50 - sem calculo -> 40 - Isenta, 41 - No tributada, 50 - Suspenso    
      // ------------------------------------------------------------------------------------------------------------------
         if (lZFM==1) {
            nICMS_vBC        = nProd_vProd;
            nICMS_vICMSDeson = nICMS_vBC*nICMS_pICMS/100;
         }
         if (((lICMS_FCPST==1) ||(lICMS_FCPST_RE)) && (jIDE_IndFinal==0)) {
            nICMS_pFCPST   = nPFCPUFDest;
            nICMS_vBCFCPST = nICMS_vBCST;
            nICMS_vFCPST   = fnRound(nICMS_pFCPST*nICMS_vBCFCPST/100,2);
         }
   
      } else if (jICMS_GrupoTrib==8) {   // 60 - ICMS cobrado anteriormente por substituio tributria
      // ------------------------------------------------------------------------------------------------------------------
         if (nICMS_pMVAST==0) {
         } else {
            if (jICMS_modBCST==0) {         // modalidade Preo tabelado ou mximo sugerido
            } elseif (jICMS_modBCST==1) {   // modalidade Lista Negativa (valor)
            } elseif (jICMS_modBCST==2) {   // modalidade Lista Positiva (valor)
            } elseif (jICMS_modBCST==3) {   // modalidade Lista Neutra (valor)
            } elseif (jICMS_modBCST==4) {   // modalidade Margem Valor Agregado (%)
               if (lBCST_Gram==true) {
                  nICMS_vBCST = nBCST_Gram;
                  nICMS_pMVAST = 0;
               } else {
                  nICMS_vBCST = fnRound(((nProd_vProd+nIPITrib_vIPI)*(1+nICMS_pMVAST/100)),2);
               }
               nV1 = nICMS_vBCST*nICMS_pICMSST/100;
               nV2 = nProd_vProd*nICMS_pICMS  /100;
               nICMS_vICMSST = fnRound(nV1-nV2,2);
            } elseif (jICMS_modBCST==5) {   // modalidade Pauta (valor)
            }
         }
         nICMS_vBCSTRet        = nQt*nTmpICMS_vBCST   ;
         nICMS_vICMSSTRet      = nQt*nTmpICMS_vICMSST ;
         nICMS_vICMSSubstituto = nQt*nTmpICMS_vICMS   ;
         nICMS_pFCP0           = nPFCPUFDest;
         nPICMSUFDest0         = nPICMSUFDest;
         nICMS_pST             = nICMS_pFCP0+nPICMSUFDest0;
         if (((lICMS_FCPSTRet==1) || (lICMS_FCPSTRet_RE==1))&& (jIDE_IndFinal==0)) {
            nICMS_pFCPSTRet    = nPFCPUFDest;
            nICMS_vBCFCPSTRet  = nICMS_vBCSTRet;
            nICMS_vFCPSTRet    = fnRound(nICMS_pFCPSTRet*nICMS_vBCFCPSTRet/100,2);
         }
   
      } else if (jICMS_GrupoTrib==9) {   // CST - 70 - Com reduo de base de clculo e cobrana do ICMS por substituio tributria
      // ------------------------------------------------------------------------------------------------------------------
         nICMS_pRedBC = ((lDestICMS_RE==true) && (jEnderEmit_CRT==2)) ? nRegFiscais_PRedBC_RE : nRegFiscais_PRedBC;
         nICMS_vBC    = nProd_vProd+(nIPITrib_vIPI*nPIncidIPIICMS/100);
         if (nICMS_pRedBC>0) nICMS_vBC = fnRound(nICMS_vBC*(100-nICMS_pRedBC)/100,2);
         nICMS_vICMS = fnRound(nICMS_pICMS*nICMS_vBC/100,2);
         if (jICMS_modBCST==0) {         // modalidade Preo tabelado ou mximo sugerido
            if (lBCST_Gram==true) {
               nICMS_vBCST  = nBCST_Gram;
               nICMS_pMVAST = 0;
            } else {
               nICMS_vBCST  = fnRound((nProd_vProd+nIPITrib_vIPI)*(1+nICMS_pMVAST/100),2);
            }
            if (nICMS_pRedBCST>0) {
               if (lBCST_Gram==true) {
                  nICMS_vBCST  = nBCST_Gram;
                  nICMS_pMVAST = 0;
               } else {
                  nICMS_vBCST  = fnRound(nICMS_vBCST*(100-nICMS_pRedBCST)/100,2);
               }
            }
            nV1 = nICMS_vBCST*nICMS_pICMSST/100;
            if (nICMS_pRedBC>0) nV2 = nProd_vProd*(nICMS_pICMS*(100-nICMS_pRedBC)/100)/100;
            else                 nV2 = nICMS_vICMS;
            nICMS_vICMSST = fnRound(nV1-nV2,2);
         } else if (jICMS_modBCST==1) {   // modalidade Lista Negativa (valor)
         } else if (jICMS_modBCST==2) {   // modalidade Lista Positiva (valor)
         } else if (jICMS_modBCST==3) {   // modalidade Lista Neutra (valor)
         } else if (jICMS_modBCST==4) {   // modalidade Margem Valor Agregado (%)
            if (lBCST_Gram==true) {
               nICMS_vBCST  = nBCST_Gram;
               nICMS_pMVAST = 0;
            } else {
               nICMS_vBCST  = fnRound((nProd_vProd+nIPITrib_vIPI)*(1+nICMS_pMVAST/100),2);
            }
            if (nICMS_pRedBCST>0) {
               if (lBCST_Gram==true) {
                  nICMS_vBCST  = nBCST_Gram;
                  nICMS_pMVAST = 0;
               } else {
                  nICMS_vBCST  = fnRound(nICMS_vBCST*(100-nICMS_pRedBCST)/100,2);
               }
            }
            nV1 = nICMS_vBCST*nICMS_pICMSST/100;
            if (nICMS_pRedBCST>0) nV2 = nProd_vProd*(nICMS_pICMS*(100-nICMS_pRedBC)/100)/100;
            else                  nV2 = nICMS_vICMS;
            nICMS_vICMSST = fnRound(nV1-nV2,2);
   
         } else if (jICMS_modBCST==5) {   //  modalidade Pauta (valor)
         }  
         if (((lICMS_FCPST==1)||(lICMS_FCPST_RE==1)) && (jIDE_IndFinal==0)) {
            nICMS_pFCPST   = nPFCPUFDest;
            nICMS_vBCFCPST = nICMS_vBCST;
            nICMS_vFCPST   = fnRound(nICMS_pFCPST*nICMS_vBCFCPST/100,2);
         }
         if (lZFM==1) { 
            nICMS_vICMSDeson = nICMS_vICMS;
            nICMS_vBC        = 0;
            nICMS_vICMS      = 0;
         }
   
      } else if (jICMS_GrupoTrib==10) {   // 90 - Outros
      // ------------------------------------------------------------------------------------------------------------------
         nICMS_pRedBC  = ((lDestICMS_RE==true) && (jEnderEmit_CRT==2)) ? nRegFiscais_PRedBC_RE : nRegFiscais_PRedBC;
         nICMS_vBC     = nProd_vProd+(nIPITrib_vIPI*nPIncidIPIICMS/100);
         if (nICMS_pRedBC>0) nICMS_vBC = fnRound(nICMS_vBC*(100-nICMS_pRedBC)/100,2);
         nICMS_vICMS   = fnRound(nICMS_pICMS*nICMS_vBC/100,2);
         if (nICMS_pMVAST==0) {
         } else {
            // SUBS. TRIB
            if (jICMS_modBCST==0) {         // modalidade Preo tabelado ou mximo sugerido
            } else if (jICMS_modBCST==1) {   // modalidade Lista Negativa (valor)
            } else if (jICMS_modBCST==2) {   // modalidade Lista Positiva (valor)
            } else if (jICMS_modBCST==3) {   // modalidade Lista Neutra (valor)
            } else if (jICMS_modBCST==4) {   // modalidade Margem Valor Agregado (%)
               if (lBCST_Gram==true) {
                  nICMS_vBCST  = nBCST_Gram;
                  nICMS_pMVAST = 0;
               } else {
                  nICMS_vBCST  = fnRound((nProd_vProd+nIPITrib_vIPI)*(1+nICMS_pMVAST/100),2);
               }
               nV1 = nICMS_vBCST*nICMS_pICMSST/100;
               if (nICMS_pRedBCST>0) nV2 = nProd_vProd*(nICMS_pICMS*(100-nICMS_pRedBCST)/100)/100;
               else                   nV2 = nProd_vProd* nICMS_pICMS/100;
               nICMS_vICMSST = fnRound(nV1-nV2,2);
            } else if (jICMS_modBCST==5) {   //  modalidade Pauta (valor)
            }
         }  
         if (((lICMS_FCP==1)||(lICMS_FCP_RE==1)) && (jIDE_IndFinal==0)) {
            nICMS_pFCP     = nPFCPUFDest;
            nICMS_vBCFCP   = nICMS_vBC;
            nICMS_vFCP     = fnRound(nICMS_pFCP*nICMS_vBCFCP/100,2);
         }
         if (((lICMS_FCPST==1)||(lICMS_FCPST_RE==1)) && (jIDE_IndFinal==0)) {
            nICMS_pFCPST   = nPFCPUFDest;
            nICMS_vBCFCPST = nICMS_vBCST;
            nICMS_vFCPST   = fnRound(nICMS_pFCPST*nICMS_vBCFCPST/100,2);
         }
         if (lZFM==1) { 
            nICMS_vICMSDeson = nICMS_vICMS;
            nICMS_vBC        = 0;
            nICMS_vICMS      = 0;
         }
      }   // if icms-grupo tributario
   }   // regime normal
   // FIM Imposto ICMS
   
   // INICIO Venda Consumidor
   if ( (jIDE_IndFinal==1) && (pUFEmiEndPos!=pUFDestEndPos) ) {   //  venda para consumidor final && 
      if (jDest_indIEDest==2) {   // 9=No Contribuinte que pode ou no possuir Inscrio NFe/NF Tc 2013.005
         nVBCUFDest       = nICMS_vBC;                                            
         if (lFCPConsFinal==1) { 
            nVBCFCPUFDest = nICMS_vBC;
            nPFCPUFDest   = nPFCPUFDest;                     
            nVFCPUFDest   = nVBCUFDest*nPFCPUFDest/100;
         }
         nPICMSUFDest     = nPICMSUFDest;
         nPICMSInter      = nICMS_pICMS;
         nPDifADest_Inter = nPICMSUFDest-nPICMSInter;
         nVICMSDif        = nVBCUFDest/100*nPDifADest_Inter;
         nVICMSUFDest     = nVICMSDif/100*nPICMSInterPart;
         nPDifUFRem_Dest  = 100-nPICMSInterPart;
         nVICMSUFRemet    = nVICMSDif/100*nPDifUFRem_Dest;
      } else {   // contribuinte
         nVBCUFDest       = nICMS_vBC;
         if (lFCPConsFinal==1) { 
            nVBCFCPUFDest = nICMS_vBC;
            nPFCPUFDest   = nPFCPUFDest;
            nVFCPUFDest   = nVBCUFDest*nPFCPUFDest/100;
         }
         nPICMSUFDest     = nPICMSUFDest;
         nPICMSInter      = nICMS_pICMS;
         nPDifADest_Inter = nPICMSUFDest-nPICMSInter;
         nVICMSDif        = nVBCUFDest/100*nPDifADest_Inter;
         nVICMSUFDest     = nVICMSDif/100*nPICMSInterPart;
         nPDifUFRem_Dest  = 100-nPICMSInterPart;
         nVICMSUFRemet    = nVICMSDif/100*nPDifUFRem_Dest;
      }
   }   // FIM - Venda Consumidor Final

   // Inicio ICMS - Imposto simples nacional
   jICMSSN_CST           = 0;
   jICMSSN_Orig          = 0;
   nICMSSN_pCredSN       = 0;
   nICMSSN_vCredICMSSN   = 0;
   jICMSSN_modBCST       = 0;
   nICMSSN_pMVAST        = 0;
   nICMSSN_pRedBCST      = 0;
   nICMSSN_vBCST         = 0;
   nICMSSN_pICMSST       = 0;
   nICMSSN_vICMSST       = 0;
   nICMSSN_vBCSTRet      = 0;
   nICMSSN_vICMSSTRet    = 0;
   jICMSSN_modBC         = 0;
   nICMSSN_vBC           = 0;
   nICMSSN_pRedBC        = 0;
   nICMSSN_pICMS         = 0;
   nICMSSN_vICMS         = 0;
   nICMSSN_pFCPST        = 0;
   nICMSSN_vFCPST        = 0;
   nICMSSN_vBCFCPST      = 0;
   nICMSSN_pFCPSTRet     = 0;
   nICMSSN_vFCPSTRet     = 0;
   nICMSSN_vBCFCPSTRet   = 0;
   
   if (jEnderEmit_CRT<2) {
      jICMSSN_CST       = (lDestICMSSN_RE==true) ? jRegFiscais_Grupo_simples_RE   : jRegFiscais_Grupo_simples   ;
      nICMSSN_pMVAST    = (lDestICMSSN_RE==true) ? nRegFiscais_ICMSSN_pMVAST_RE   : nRegFiscais_ICMSSN_pMVAST   ;
      nICMSSN_pRedBCST  = (lDestICMSSN_RE==true) ? nRegFiscais_ICMSSN_pRedBCST_RE : nRegFiscais_ICMSSN_pRedBCST ;
      nICMSSN_pICMSST   = (lDestICMSSN_RE==true) ? nRegFiscais_ICMSSN_pICMSST_RE  : nRegFiscais_ICMSSN_pICMSST  ;
      nICMSSN_pCredSN   = (lDestICMSSN_RE==true) ? nRegFiscais_ICMSSN_pCredSN_RE  : nRegFiscais_ICMSSN_pCredSN  ;
      nICMSSN_pICMS     = (lDestICMSSN_RE==true) ? nRegFiscais_ICMSSN_pICMS_RE    : nRegFiscais_ICMSSN_pICMS    ;
      lICMSSN_FCP       = (lDestICMSSN_RE==true) ? lRegFiscais_ICMS_FCP_RE        : lRegFiscais_ICMS_FCP        ;
      lICMSSN_FCPST     = (lDestICMSSN_RE==true) ? lRegFiscais_ICMS_FCPST_RE      : lRegFiscais_ICMS_FCPST      ;
      lICMSSN_FCPSTRet  = (lDestICMSSN_RE==true) ? lRegFiscais_ICMS_FCPSTRet_RE   : lRegFiscais_ICMS_FCPSTRet   ;
      if (jICMSSN_CST==0)        {   // 101
         nICMSSN_vCredICMSSN      = fnRound(nICMSSN_pCredSN*nProd_vProd/100,2);
      } else if ((jICMSSN_CST==1) || (jICMSSN_CST==2) || (jICMSSN_CST==6) || (jICMSSN_CST==7)) {   // 102,103,300,400
      } else if  (jICMSSN_CST==3) {   // 201
         nICMSSN_vCredICMSSN      = fnRound(nICMSSN_pCredSN*nProd_vProd/100,2);
         nICMSSN_vBCST            = nProd_vProd*(1+nICMSSN_pMVAST/100);
         nV1                      = nICMSSN_vBCST * nICMSSN_pICMSST/100;
         if (nICMSSN_pRedBCST>0) {
            if (nICMSSN_pICMS>0) nV2 = nProd_vProd * (nICMSSN_pICMS  *(100-nICMSSN_pRedBCST)/100)/100;
            else                  nV2 = nProd_vProd * (nICMSSN_pICMSST*(100-nICMSSN_pRedBCST)/100)/100;
         } else {
            if (nICMSSN_pICMS>0) nV2 = nProd_vProd * nICMSSN_pICMS  /100;
            else                  nV2 = nProd_vProd * nICMSSN_pICMSST/100;
         }
         nICMSSN_vICMSST = fnRound(nV1-nV2,2);
      } else if ((jICMSSN_CST==4) || (jICMSSN_CST==5)) {   // 202,203
         nICMSSN_vBCST = nProd_vProd  * (1+nICMSSN_pMVAST/100);
         nV1 = nICMSSN_vBCST*nICMSSN_pICMSST/100;
         if (nICMSSN_pRedBCST>0) {
            if (nICMSSN_pICMS>0) nV2 = nProd_vProd * (nICMSSN_pICMS  *(100-nICMSSN_pRedBCST)/100)/100;
            else                  nV2 = nProd_vProd * (nICMSSN_pICMSST*(100-nICMSSN_pRedBCST)/100)/100;
         } else {
            if (nICMSSN_pICMS>0) nV2 = nProd_vProd * nICMSSN_pICMS  /100;
            else                  nV2 = nProd_vProd * nICMSSN_pICMSST/100;
         }
         nICMSSN_vICMSST = fnRound(nV1-nV2,2);
      } else if  (jICMSSN_CST==8) {   // 500
         nICMSSN_vBCSTRet      = nQt*nTmpICMS_vBCST;
         nICMSSN_vICMSSTRet    = nQt*nTmpICMS_vICMSST;
         nICMS_vICMSSubstituto = nQt*nTmpICMS_vICMS;
      } else if  (jICMSSN_CST==9) {   // 900
         nICMSSN_vBCST = lBonif==true ? 0 : (nProd_vProd*(1+nICMSSN_pMVAST/100));
         nV1           = nICMSSN_vBCST*nICMSSN_pICMSST/100;
         if (nICMSSN_pRedBCST>0) {
            if (nICMSSN_pICMS>0) nV2 = nProd_vProd*(nICMSSN_pICMS  *(100-nICMSSN_pRedBCST)/100)/100;
            else                 nV2 = nProd_vProd*(nICMSSN_pICMSST*(100-nICMSSN_pRedBCST)/100)/100;
         } else {
            if (nICMSSN_pICMS>0) nV2 = nProd_vProd * nICMSSN_pICMS  /100;
            else                 nV2 = nProd_vProd * nICMSSN_pICMSST/100;
         }
         nICMSSN_vICMSST = fnRound(nV1-nV2,2);
      }
   }   // if j...CRT<2
   // FIM - Imposto ICMSSN
   // ---------------------
   // FIM Todos os Impostos
   // ---------------------

   // Atualizando oGlobalOV[jItem] -  dados das Linhas
   // ------------------------------------------------

   // Calculados
   oGlobalOV.aItens[jItem].nVDescInc             = nVDescInc                               ;
   oGlobalOV.aItens[jItem].nVDescTpEDG           = nVDescTpEDG                             ;
   oGlobalOV.aItens[jItem].nVDescTpED            = nVDescTpED                              ;
   oGlobalOV.aItens[jItem].nVEncFinTpED          = nVEncFinTpED                            ;
   oGlobalOV.aItens[jItem].nVDescCP              = nVDescCP                                ;
   oGlobalOV.aItens[jItem].nVDescLog             = nVDescLog                               ;
   oGlobalOV.aItens[jItem].nProd_vUnCom          = nProd_vUnCom                            ;
   oGlobalOV.aItens[jItem].nProd_vProd           = nProd_vProd                             ;
   oGlobalOV.aItens[jItem].nProd_vUnCom          = nProd_vUnCom                            ;
   oGlobalOV.aItens[jItem].nTot_vTrib            = nTot_vTrib                              ;

   // IPI
   oGlobalOV.aItens[jItem].pIPIRegFis            = pRegFiscais_RegFIPI                     ;
   oGlobalOV.aItens[jItem].jIPINT_CST            = jIPINT_CST                              ;
   oGlobalOV.aItens[jItem].nIPITrib_pIPI         = nIPITrib_pIPI                           ;
   oGlobalOV.aItens[jItem].nIPITrib_vBC          = nIPITrib_vBC                            ;
   oGlobalOV.aItens[jItem].nIPITrib_vIPI         = nIPITrib_vIPI                           ;
   oGlobalOV.aItens[jItem].nPRBCIPI              = nPRBCIPI                                ;
   if ((lDestIPI_RE)         &&(jEnderEmit_CRT==2)) oGlobalOV.aItens[jItem].lIPI_RE    = 1 ;
   else                                             oGlobalOV.aItens[jItem].lIPI_RE    = 0 ;
   if ((lIPI_UT    )         &&(jEnderEmit_CRT==2)) oGlobalOV.aItens[jItem].lIPI_UT    = 1 ;

   // PIS
   oGlobalOV.aItens[jItem].pPISRegFis            = pRegFiscais_RegFPIS                     ;
   oGlobalOV.aItens[jItem].jPIS_CST              = jPIS_CST                                ;
   oGlobalOV.aItens[jItem].nPIS_pPIS             = nPIS_pPIS                               ;
   oGlobalOV.aItens[jItem].nPIS_vBC              = nPIS_vBC                                ;
   oGlobalOV.aItens[jItem].nPIS_vPIS             = nPIS_vPIS                               ;
   if ((lINCMPIS_RE==true)   &&(jEnderEmit_CRT==2)) oGlobalOV.aItens[jItem].lPIS_RE    = 1 ;
   else                                             oGlobalOV.aItens[jItem].lPIS_RE    = 0 ;  

   // COFINS
   oGlobalOV.aItens[jItem].pCOFINSRegFis         = pRegFiscais_RegFCofins                  ;
   oGlobalOV.aItens[jItem].jCOFINS_CST           = jCOFINS_CST                             ;
   oGlobalOV.aItens[jItem].nCOFINS_pCOFINS       = nCOFINS_pCOFINS                         ;
   oGlobalOV.aItens[jItem].nCOFINS_vBC           = nCOFINS_vBC                             ;
   oGlobalOV.aItens[jItem].nCOFINS_vCOFINS       = nCOFINS_vCOFINS                         ;
   if ((lINCMCOFINS_RE==true)&&(jEnderEmit_CRT==2)) oGlobalOV.aItens[jItem].lCOFINS_RE = 1 ;
   else                                             oGlobalOV.aItens[jItem].lCOFINS_RE = 0 ;
   
   // ICMS
   oGlobalOV.aItens[jItem].pICMSRegFis           = pRegFiscais_RegFICMS                    ;
   oGlobalOV.aItens[jItem].jICMS_GrupoTrib       = jICMS_GrupoTrib                         ;
   oGlobalOV.aItens[jItem].jICMS_Orig            = jICMS_Orig                              ;
   oGlobalOV.aItens[jItem].jICMS_modBC           = jICMS_modBC                             ;
   oGlobalOV.aItens[jItem].nICMS_pICMS           = nICMS_pICMS                             ;
   oGlobalOV.aItens[jItem].nICMS_vICMS           = nICMS_vICMS                             ;
   oGlobalOV.aItens[jItem].nICMS_vICMSDeson      = nICMS_vICMSDeson                        ;
   oGlobalOV.aItens[jItem].jICMS_modBCST         = jICMS_modBCST                           ;
   oGlobalOV.aItens[jItem].nICMS_pMVAST          = nICMS_pMVAST                            ;
   oGlobalOV.aItens[jItem].nICMS_pRedBCST        = nICMS_pRedBCST                          ;
   oGlobalOV.aItens[jItem].nICMS_vBCST           = nICMS_vBCST                             ;
   oGlobalOV.aItens[jItem].nICMS_pICMSST         = nICMS_pICMSST                           ;
   oGlobalOV.aItens[jItem].nICMS_vICMSST         = nICMS_vICMSST                           ;
   oGlobalOV.aItens[jItem].nICMS_pRedBC          = nICMS_pRedBC                            ;
   oGlobalOV.aItens[jItem].nICMS_vBCSTRet        = nICMS_vBCSTRet                          ;
   oGlobalOV.aItens[jItem].nICMS_vICMSSTRet      = nICMS_vICMSSTRet                        ;
   oGlobalOV.aItens[jItem].jICMSPart_Orig        = jICMSPart_Orig                          ;
   oGlobalOV.aItens[jItem].jICMSST_Orig          = jICMSST_Orig                            ;
   oGlobalOV.aItens[jItem].nVBCUFDest            = nVBCUFDest                              ;
   oGlobalOV.aItens[jItem].nPFCPUFDest           = nPFCPUFDest                             ;
   oGlobalOV.aItens[jItem].nVBCFCPUFDest         = nVBCFCPUFDest                           ;
   oGlobalOV.aItens[jItem].nPICMSUFDest          = nPICMSUFDest                            ;
   oGlobalOV.aItens[jItem].nPICMSInter           = nPICMSInter                             ;
   oGlobalOV.aItens[jItem].nPICMSInterPart       = nPICMSInterPart                         ;
   oGlobalOV.aItens[jItem].nVFCPUFDest           = nVFCPUFDest                             ;
   oGlobalOV.aItens[jItem].nVICMSUFDest          = nVICMSUFDest                            ;
   oGlobalOV.aItens[jItem].nVICMSUFRemet         = nVICMSUFRemet                           ;
   oGlobalOV.aItens[jItem].nICMS_pST             = nICMS_pST                               ;
   oGlobalOV.aItens[jItem].nICMS_pFCP            = nICMS_pFCP                              ;
   oGlobalOV.aItens[jItem].nICMS_vFCP            = nICMS_vFCP                              ;
   oGlobalOV.aItens[jItem].nICMS_vBCFCP          = nICMS_vBCFCP                            ;
   oGlobalOV.aItens[jItem].nICMS_pFCPST          = nICMS_pFCPST                            ;
   oGlobalOV.aItens[jItem].nICMS_vFCPST          = nICMS_vFCPST                            ;
   oGlobalOV.aItens[jItem].nICMS_vBCFCPST        = nICMS_vBCFCPST                          ;
   oGlobalOV.aItens[jItem].nICMS_pFCPSTRet       = nICMS_pFCPSTRet                         ;
   oGlobalOV.aItens[jItem].nICMS_vFCPSTRet       = nICMS_vFCPSTRet                         ;
   oGlobalOV.aItens[jItem].nICMS_vBCFCPSTRet     = nICMS_vBCFCPSTRet                       ;
   if (lDestICMS_RE  )  oGlobalOV.aItens[jItem].lRE        = 1                             ;
   else                 oGlobalOV.aItens[jItem].lRE        = 0                             ;
   if (lDestIPI_RE   )  oGlobalOV.aItens[jItem].lRE_IPI    = 1                             ;
   else                 oGlobalOV.aItens[jItem].lRE_IPI    = 0                             ;
   if (lINCMPIS_RE   )  oGlobalOV.aItens[jItem].lRE_PIS    = 1                             ;
   else                 oGlobalOV.aItens[jItem].lRE_PIS    = 0                             ;
   if (lINCMCOFINS_RE)  oGlobalOV.aItens[jItem].lRE_COFINS = 1                             ;
   else                 oGlobalOV.aItens[jItem].lRE_COFINS = 0                             ;
   if (lZFM==1       )  oGlobalOV.aItens[jItem].nICMS_vBC  = 0                             ;
   else                 oGlobalOV.aItens[jItem].nICMS_vBC  = nICMS_vBC                     ;
   if (lZFM==1) {
      oGlobalOV.aItens[jItem].jICMS_motDesICMS    = 6                                      ;
      oGlobalOV.aItens[jItem].jICMS_IndDeduzDeson = 1                                      ;
   } elseif(lCalcDeson==1) {
      oGlobalOV.aItens[jItem].jICMS_motDesICMS    = 8                                      ;
      oGlobalOV.aItens[jItem].jICMS_IndDeduzDeson = 0                                      ;   // resetei
   } else {
      oGlobalOV.aItens[jItem].jICMS_motDesICMS    = jICMS_motDesICMS                       ;
      oGlobalOV.aItens[jItem].jICMS_IndDeduzDeson = 0                                      ;   // resetei
   }
   
   // ICMS SN
   oGlobalOV.aItens[jItem].pICMSSNRegFis         = pRegFiscais_RegFICMS_SN                 ;
   oGlobalOV.aItens[jItem].jGrupo_simples        = jICMSSN_CST                             ;
   oGlobalOV.aItens[jItem].jICMSSN_CSOSN         = jICMSSN_CST                             ;
   oGlobalOV.aItens[jItem].jICMSSN_Orig          = jICMSSN_Orig                            ;
   oGlobalOV.aItens[jItem].nICMSSN_pCredSN       = nICMSSN_pCredSN                         ;
   oGlobalOV.aItens[jItem].nICMSSN_vCredICMSSN   = nICMSSN_vCredICMSSN                     ;
   oGlobalOV.aItens[jItem].jICMSSN_modBCST       = jICMSSN_modBCST                         ;
   oGlobalOV.aItens[jItem].nICMSSN_pMVAST        = nICMSSN_pMVAST                          ;
   oGlobalOV.aItens[jItem].nICMSSN_pRedBCST      = nICMSSN_pRedBCST                        ;
   oGlobalOV.aItens[jItem].nICMSSN_vBCST         = nICMSSN_vBCST                           ;
   oGlobalOV.aItens[jItem].nICMSSN_pICMSST       = nICMSSN_pICMSST                         ;
   oGlobalOV.aItens[jItem].nICMSSN_vICMSST       = nICMSSN_vICMSST                         ;
   oGlobalOV.aItens[jItem].nICMSSN_vBCSTRet      = nICMSSN_vBCSTRet                        ;
   oGlobalOV.aItens[jItem].nICMSSN_vICMSSTRet    = nICMSSN_vICMSSTRet                      ;
   oGlobalOV.aItens[jItem].jICMSSN_modBC         = jICMSSN_modBC                           ;
   oGlobalOV.aItens[jItem].nICMSSN_vBC           = nICMSSN_vBC                             ;
   oGlobalOV.aItens[jItem].nICMSSN_pRedBC        = nICMSSN_pRedBC                          ;
   oGlobalOV.aItens[jItem].nICMSSN_pICMS         = nICMSSN_pICMS                           ;
   oGlobalOV.aItens[jItem].nICMSSN_vICMS         = nICMSSN_vICMS                           ;
   oGlobalOV.aItens[jItem].nICMSSN_pFCPST        = nICMSSN_pFCPST                          ;
   oGlobalOV.aItens[jItem].nICMSSN_vFCPST        = nICMSSN_vFCPST                          ;
   oGlobalOV.aItens[jItem].nICMSSN_vBCFCPST      = nICMSSN_vBCFCPST                        ;
   oGlobalOV.aItens[jItem].nICMSSN_pFCPSTRet     = nICMSSN_pFCPSTRet                       ;
   oGlobalOV.aItens[jItem].nICMSSN_vFCPSTRet     = nICMSSN_vFCPSTRet                       ;
   oGlobalOV.aItens[jItem].nICMSSN_vBCFCPSTRet   = nICMSSN_vBCFCPSTRet                     ;
   oGlobalOV.aItens[jItem].nICMS_vICMSSubstituto = nICMS_vICMSSubstituto                   ; 

   // Atualizando oGlobalOV -  dados da Capa   
   // ------------------------------------------------
   oGlobalOV.nTot_vIPI           += nIPITrib_vIPI     ;   // IPI
   oGlobalOV.nTot_vPIS           += nPIS_vPIS         ;   // PIS
   oGlobalOV.nTot_vCOFINS        += nCOFINS_vCOFINS   ;   // COFINS
   oGlobalOV.nTot_vICMS          += nICMS_vICMS       ;   // ICMS
   oGlobalOV.nTot_vICMSDeson     += nICMS_vICMSDeson  ;
   oGlobalOV.nTot_vBCST          += nICMS_vBCST       ;
   oGlobalOV.nTot_vST            += nICMS_vICMSST     ;
   oGlobalOV.nVFCPUFDest         += nVFCPUFDest       ;
   oGlobalOV.nVICMSUFDest        += nVICMSUFDest      ;
   oGlobalOV.nVICMSUFRemet       += nVICMSUFRemet     ;
   oGlobalOV.nICMSTot_vFCP       += nICMS_vFCP        ;
   oGlobalOV.nICMSTot_vFCPST     += nICMS_vFCPST      ;
   oGlobalOV.nICMSTot_vFCPSTRet  += nICMS_vFCPSTRet   ;
   oGlobalOV.nTot_vBCST          += nICMSSN_vBCST     ;
   oGlobalOV.nTot_vST            += nICMSSN_vICMSST   ;
   oGlobalOV.nICMSTot_vFCP       += nICMSSN_vFCP      ;
   oGlobalOV.nICMSTot_vFCPST     += nICMSSN_vFCPST    ;
   oGlobalOV.nICMSTot_vFCPSTRet  += nICMSSN_vFCPSTRet ;

}   // for (var jItem in oGlobalOV.aItens[])
return true;
}

async function foCadRegFItem() {
////////////////////////////////
   var oRet = {};
   var aPar = [oGlobalOV.EndeD.pUFPos,oGlobalOV.aItens[jItem].pNCM,oGlobalOV.aItens[jItem].pSGrp];
   var sSql = "select * from RegFiscal where jTipo=5 and pUF2=? and pNCM=? and pSubGrpSku=?";
   var oDb  = await foDbSelect(sSql,aPar);   

   oRet.pRegFIPI       = 0;
   oRet.pRegFIPI_RE    = 0;
   oRet.pRegFPIS       = 0;
   oRet.pRegFPIS_RE    = 0;
   oRet.pRegFCofins    = 0;
   oRet.pRegFCofins_RE = 0;
   oRet.pRegFICMS      = 0;
   oRet.pRegFICMS_RE   = 0;
   oRet.pRegFICMS_SN   = 0;

   for (let j = 0; j < oDb.length; j++) {

      //  IPI
      if ((oRet.pRegFIPI==0) && (oDb[j].lIPI==1)) {
         oRet.pRegFIPI            = oDb[j].pPId                   ;
         oRet.nPRBCIPI            = oDb[j].nPRBCIPI               ;
         oRet.jCSTIPI             = oDb[j].jCSTIPI                ;
         oRet.nIpiAli             = oDb[j].nIpiAli                ;
      }
      //  IPI_RE
      if ((oRet.pRegFIPI_RE==0) && (oDb[j].lIPI_RE==1)) {
         oRet.pRegFIPI_RE         = oDb[j].pPId                   ;
         oRet.jCSTIPI_RE          = oDb[j].jCSTIPI_RE             ;
         oRet.nIpiAli_RE          = oDb[j].nIpiAli_RE             ;
      }
      //  PIS
      if ((oRet.pRegFPIS==0) && (oDb[j].lPIS==1)) {
         oRet.pRegFPIS            = oDb[j].pPId                   ;
         oRet.jCSTPIS             = oDb[j].jCSTPIS                ;
         oRet.nPIS                = oDb[j].nPIS                   ;
      }
      //  PIS_RE
      if ((oRet.pRegFPIS_RE==0) && (oDb[j].lPIS_RE==1)) {
         oRet.pRegFPIS_RE         = oDb[j].pPId                   ;
         oRet.jCSTPIS_RE          = oDb[j].jCSTPIS_RE             ;
         oRet.nPIS_RE             = oDb[j].nPIS_RE                ;
      }
      //  Cofins
      if ((oRet.pRegFCofins==0) && (oDb[j].lCofins==1)) {
         oRet.pRegFCofins         = oDb[j].pPId                   ;
         oRet.jCSTCofins          = oDb[j].jCSTCofins             ;
         oRet.nCofins             = oDb[j].nCofins                ;
      }
      //  Cofins_RE
      if ((oRet.pRegFCofins_RE==0) && (oDb[j].lCofins_RE==1)) {
         oRet.pRegFCofins_RE      = oDb[j].pPId                   ;
         oRet.jCSTCofins_RE       = oDb[j].jCSTCofins_RE          ;
         oRet.nCofins_RE          = oDb[j].nCofins_RE             ;
      }
      //  ICMS
      if ((oRet.pRegFICMS==0) && (oDb[j].lICMS==1)) {
         oRet.pRegFICMS           = oDb[j].pPId                   ;
         oRet.jCSTICMS            = oDb[j].jCSTICMS               ;
         oRet.jICMS_modBC         = oDb[j].jICMS_modBC            ;
         oRet.nPRedBCST           = oDb[j].nPRedBCST              ;
         oRet.jICMS_modBCST       = oDb[j].jICMS_modBCST          ;
         oRet.nPICMS              = oDb[j].nPICMS                 ;
         oRet.nMEstim             = oDb[j].nMEstim                ;
         oRet.nPIcmsST            = oDb[j].nPIcmsST               ;
         oRet.nPIncidIPIICMS      = oDb[j].nPIncidIPIICMS         ;
         oRet.lICMS_FCP           = oDb[j].lICMS_FCP              ;
         oRet.lICMS_FCPST         = oDb[j].lICMS_FCPST            ;
         oRet.lICMS_FCPSTRet      = oDb[j].lICMS_FCPSTRet         ;
         oRet.pCBenef             = oDb[j].pCBenef                ;
         oRet.lCalcDeson          = oDb[j].lCalcDeson             ;
         oRet.lFCPConsFinal       = oDb[j].lFCPConsFinal          ;
         oRet.nPRedBC             = oDb[j].nPRedBC                ;
      }
      //  ICMS_RE
      if ((oRet.pRegFICMS_RE==0) && (oDb[j].lICMS_RE==1)) {
         oRet.pRegFICMS_RE        = oDb[j].pPId                   ;
         oRet.jCSTICMS_RE         = oDb[j].jCSTICMS_RE            ;       
         oRet.jICMS_modBC_RE      = oDb[j].jICMS_modBC_RE         ;    
         oRet.nPRedBCST_RE        = oDb[j].nPRedBCST_RE           ;
         oRet.jICMS_modBCST_RE    = oDb[j].jICMS_modBCST_RE       ;
         oRet.nPICMS_RE           = oDb[j].nPICMS_RE              ;
         oRet.nMestim_RE          = oDb[j].nMestim_RE             ;
         oRet.nPICMSST_RE         = oDb[j].nPICMSST_RE            ;
         oRet.nPIncidIPIICMS_RE   = oDb[j].nPIncidIPIICMS_RE      ;
         oRet.lFCPConsFinal_RE    = oDb[j].lFCPConsFinal_RE       ;
         oRet.lICMS_FCP_RE        = oDb[j].lICMS_FCP_RE           ;
         oRet.lICMS_FCPST_RE      = oDb[j].lICMS_FCPST_RE         ;
         oRet.lICMS_FCPSTRet_RE   = oDb[j].lICMS_FCPSTRet_RE      ;
         oRet.nPRedBC_RE          = oDb[j].nPRedBC_RE             ;
      }
      //  ICMS_SN
      if ((oRet.pRegFICMS_SN==0) && (oDb[j].lICMS_SN==1)) {
         oRet.pRegFICMS_SN        = oDb[j].pPId                   ;
         oRet.jGrupo_simples      = oDb[j].jGrupo_simples         ;
         oRet.nICMSSN_pMVAST      = oDb[j].nICMSSN_pMVAST         ;
         oRet.nICMSSN_pRedBCST    = oDb[j].nICMSSN_pRedBCST       ;
         oRet.nICMSSN_pICMSST     = oDb[j].nICMSSN_pICMSST        ;
         oRet.nICMSSN_pCredSN     = oDb[j].nICMSSN_pCredSN        ;
         oRet.nICMSSN_pICMS       = oDb[j].nICMSSN_pICMS          ;
         oRet.jGrupo_simples_RE   = oDb[j].jGrupo_simples_RE      ; 
         oRet.nICMSSN_pMVAST_RE   = oDb[j].nICMSSN_pMVAST_RE      ; 
         oRet.nICMSSN_pRedBCST_RE = oDb[j].nICMSSN_pRedBCST_RE    ; 
         oRet.nICMSSN_pICMSST_RE  = oDb[j].nICMSSN_pICMSST_RE     ; 
         oRet.nICMSSN_pCredSN_RE  = oDb[j].nICMSSN_pCredSN_RE     ; 
         oRet.nICMSSN_pICMS_RE    = oDb[j].nICMSSN_pICMS_RE       ; 
      }
   }   // for j oDb
   return oRet;
}

function fnRound(pnValue,piDec) {
/////////////////////////////////
    return Number(pnValue.toFixed(piDec));
}

const foDbSelect = (sSql, aPar = []) => {
/////////////////////////////////////////
// Funo foDbSelect sugerida pela IA - supondo db como conexo
  return new Promise((resolve, reject) => {
    db.transaction((tx) => {
      tx.executeSql(
        sSql,
        aPar,
        (_, results) => {
          const rows = [];
          for (let i = 0; i < results.rows.length; i++) {
            rows.push(results.rows.item(i));
          }
          resolve(rows);
        },
        (_, error) => {
          reject(error);
          return false;
        }
      );
    });
  });
};