import PyPDF2
from PIL import Image
from pyzbar.pyzbar import decode

def extract_qr_codes(pdf_path):
    pdf_file = open(pdf_path, 'rb')
    pdf_reader = PyPDF2.PdfFileReader(pdf_file)
    
    for page_num in range(pdf_reader.numPages):
        page = pdf_reader.getPage(page_num)
        xObject = page['/Resources']['/XObject'].getObject()
        
        for obj in xObject:
            if xObject[obj]['/Subtype'] == '/Image':
                size = (xObject[obj]['/Width'], xObject[obj]['/Height'])
                data = xObject[obj].getData()
                
                if xObject[obj]['/Filter'] == '/FlateDecode':
                    img = Image.frombytes('RGB', size, data)
                else:
                    img = Image.open(io.BytesIO(data))
                    
                decoded_objs = decode(img)
                for obj in decoded_objs:
                    print('QR Code:', obj.data)

    pdf_file.close()

extract_qr_codes('ICMS_vencto_11_03_24.pdf')


