<?php
// Include configuration file  
require_once 'config.php'; 

$sEmail = $_GET['sEmail'];

?>

<!DOCTYPE html>
<html lang="en-US">
<head>
<title>Checkout</title>
<meta charset="utf-8">

<!-- Stylesheet file -->
<link href="css/style.css" rel="stylesheet">
	
<!-- Stripe JavaScript library -->
<script src="https://js.stripe.com/v3/"></script>

</head>
<body>
<div class="container">
    <div class="item">
        <!-- Display errors returned by checkout session -->
		<div id="paymentResponse"></div>
            
        <!-- Product details -->
        <h2><?php echo $productName; ?></h2>
        <img src="images/radar02.png" alt="Radar de Oportunidades" width="250" height="250"/>
        <p>Plano mensal para uso do sistema Radar de oportunidades</p>
        <p>Pre&ccedil;o: <b>R$<?php echo $productPrice.' '.strtoupper($currency); ?></b></p>
        
        <!-- Buy button -->
        <div id="buynow">
            <button class="stripe-button" id="payButton">Comprar</button>
        </div>
    </div>
</div>

<script>
var sEmail = '<?=$sEmail;?>';
var buyBtn = document.getElementById('payButton');
var responseContainer = document.getElementById('paymentResponse');
    
// Create a Checkout Session with the selected product
var createCheckoutSession = function (stripe) {
    return fetch("stripe_charge.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
        },
        body: JSON.stringify({
            checkoutSession: 1,
            sEmail: sEmail,
        }),
    }).then(function (result) {
        return result.json();
    });
};

// Handle any errors returned from Checkout
var handleResult = function (result) {
    if (result.error) {
        responseContainer.innerHTML = '<p>'+result.error.message+'</p>';
    }
    buyBtn.disabled = false;
    buyBtn.textContent = 'Buy Now';
};

// Specify Stripe publishable key to initialize Stripe.js
var stripe = Stripe('<?php echo STRIPE_PUBLISHABLE_KEY; ?>');

buyBtn.addEventListener("click", function (evt) {
    buyBtn.disabled = true;
    buyBtn.textContent = 'Aguarde...';
    
    createCheckoutSession().then(function (data) {
        if(data.sessionId){
            stripe.redirectToCheckout({
                sessionId: data.sessionId,
            }).then(handleResult);
        } else {
            handleResult(data);
        }
    });
});
</script>
</body>
</html>