<?php
require_once("RetornoCNAB400Base.php");

/**Classe para leitura de arquivos de retorno de cobranças no padrão 400 posições do Bradesco.<br/>.
* Baseado no documento "Cobrança Bradesco - Manual Operacional para Troca de Arquivos" do Bradesco 
* (arquivo layout_cobranca_port_bradesco.pdf)
* @copyright GPLv2
* @package ArquivoRetornoTitulosBancarios
* @author Manoel Campos da Silva Filho. http://manoelcampos.com/contato
* @version 0.4
*/
class RetornoCNAB400Bradesco extends RetornoCNAB400Base {
/**@property int DETALHE Define o valor que identifica uma coluna do tipo DETALHE*/
   const DETALHE = 1;

   public function __construct($nomeArquivo=NULL, $aoProcessarLinhaFunctionName=""){
      parent::__construct($nomeArquivo, $aoProcessarLinhaFunctionName);
   }

/**Processa a linha header do arquivo
* @param string $linha Linha do header de arquivo processado
* @return array<mixed> Retorna um vetor contendo os dados dos campos do header do arquivo.*/
   protected function processarHeaderArquivo($linha) {
//O formato de 400 posicoes do bradesco é diferente do padrao FEBRABAN
//(pelo menos do usado pelo BB). Assim, nao é chamada a funcao na classe
//pai pois a mesma é totalmente reimplementada aqui
//$vlinha = parent::processarHeaderArquivo($linha);	
		
      $aHeader = array();	 
      //X = ALFANUMÉRICO 9 = NUMÉRICO V = VÍRGULA DECIMAL ASSUMIDA
      $aHeader["registro"]           = substr($sLin,                      0,     1); //9 Identificação do Registro Header: “0”
      $aHeader["tipo_operacao"]      = substr($sLin,                      1,     1); //9 Tipo de Operação: “2”
      $aHeader["id_tipo_operacao"]   = substr($sLin,                      2,     7); //X Identificação Tipo de Operação “RETORNO”
      $aHeader["id_tipo_servico"]    = substr($sLin,                      9,     2); //9 Identificação do Tipo de Serviço: “01”
      $aHeader["tipo_servico"]       = substr($sLin,                     11,    15); //X Identificação por Extenso do Tipo de Serviço: “COBRANCA”
      $aHeader["cod_empresa"]        = substr($sLin,                     26,    20);
      $aHeader["nome_empresa"]       = substr($sLin,                     46,    30); //razao social
      $aHeader["num_banco"]          = substr($sLin,                     76,     3); //237 (Código do bradesco)
      $aHeader["banco"]              = substr($sLin,                     79,    15); //Nome do banco (BRADESCO)
      $aHeader["data_gravacao"]      = $this->formataData(substr($sLin,  94,     6)); //9 Data da Gravação: Informe no formado “DDMMAA”
      $aHeader["densidade_gravacao"] = substr($sLin,                    100,     8); //01600000 
      $aHeader["num_aviso_bancario"] = substr($sLin,                    108,     5); 
      $aHeader["data_credito"]       = $this->formataData(substr($sLin, 379,     6)); // “DDMMAA”
      $aHeader["sequencial_reg"]     = substr($sLin,                    394,     6); //9 Seqüencial do Registro: ”000001”
      return $aHeader;
   }

/**Processa uma linha detalhe do arquivo.
* @param string $sLin Linha detalhe do arquivo processado
* @return array<mixed> Retorna um vetor contendo os dados dos campos da linha detalhe.*/
   protected function processarDetalhe($sLin) {
      //O formato de 400 posicoes do bradesco é diferente do padrao FEBRABAN
      //(pelo menos do usado pelo BB). Assim, nao é chamada a funcao na classe
      //pai pois a mesma é totalmente reimplementada aqui	
      //$aDetalhe = parent::processarDetalhe($sLin);
      $aDetalhe = array();
      //X = ALFANUMÉRICO 9 = NUMÉRICO V   = VÍRGULA DECIMAL ASSUMIDA
      $aDetalhe["registro"]              = substr($sLin,                        0,   1);   //9  Id do Registro Detalhe: 1 
      $aDetalhe["tipo_inscr_empresa"]    = substr($sLin,                        1,   2);   //9  01-CPF | 02-CNPJ | 03-PIS/PASEP | 98-Não tem | 99-Outro
      $aDetalhe["num_inscr_empresa"]     = substr($sLin,                        3,   14);  //9  CNPJ/CPF, Número, Filial ou Controle
      $aDetalhe["id_empresa_banco"]      = substr($sLin,                       20,   17);  //9  Identificação da Empresa Cedente no Banco
                                                                                          //Zero, Carteira (size=3), Agência (size=5) e Conta Corrente (size=8)
      $aDetalhe["num_controle_part"]     = substr($sLin,                       37,   25);  //No Controle do Participante | Uso da Empresa 
      $aDetalhe["nosso_numero"]          = substr($sLin,                       70,   12);  //Identificação do Título no Banco
      $aDetalhe["id_rateio_credito"]     = substr($sLin,                      104,   1);   //Indicador de Rateio Crédito “R” 
      $aDetalhe["carteira"]              = substr($sLin,                      107,   1);   //Carteira
      $aDetalhe["id_ocorrencia"]         = substr($sLin,                      108,   2);   //Identificação de Ocorrência (vide pg 47)
      $aDetalhe["data_ocorrencia"]       = $this->formataData(substr($sLin,   110,   6));  //X  Data da Entrada/Liquidação (DDMMAA)
      $aDetalhe["num_documento"]         = substr($sLin,                      116,   10);  //A  Número título dado pelo cedente
      //$aDetalhe["id_titulo_banco"]       = substr($sLin,                      126,   20);  //mesmo valor que o campo nosso_numero (indicado anteriormente)
      $aDetalhe["data_vencimento"]       = $this->formataData(substr($sLin,   146,    6)); //9  Data de vencimento (DDMMAA) 
      $aDetalhe["valor"]                 = $this->formataNumero(substr($sLin, 152,   13)); //9  v99 Valor do título
      $aDetalhe["cod_banco"]             = substr($sLin,                      165,    3);  //9  Código do banco recebedor 
      $aDetalhe["agencia"]               = substr($sLin,                      168,    5);  //9  Código da agência recebedora 
      $aDetalhe["desp_cobranca"]         = $this->formataNumero(substr($sLin, 175,   13)); // Despesas de cobrança para
                                                                                          //os Códigos de Ocorrência 
                                                                                          //02 - Entrada Confirmada 
                                                                                          //28 - Débito de Tarifas
      $aDetalhe["outras_despesas"]       = $this->formataNumero(substr($sLin, 188,   13)); //9  v99 Outras despesas
      $aDetalhe["juros_atraso"]          = $this->formataNumero(substr($sLin, 201,   13)); //9  v99 Juros atraso
      $aDetalhe["iof"]                   = $this->formataNumero(substr($sLin, 214,   13)); //9  v99 IOF 
      $aDetalhe["desconto_concedido"]    = $this->formataNumero(substr($sLin, 240,   13)); //9  v99 Desconto concedido 
      $aDetalhe["valor_recebido"]        = $this->formataNumero(substr($sLin, 253,   13)); //9  v99 Valor pago
      $aDetalhe["juros_mora"]            = $this->formataNumero(substr($sLin, 266,   13)); //9  v99 Juros de mora
      $aDetalhe["outros_recebimentos"]   = $this->formataNumero(substr($sLin, 279,   13)); //9  v99 Outros recebimentos
      $aDetalhe["motivo_cod_ocorrencia"] = substr($sLin,                      318,   10);  //Motivos das Rejeições para 
                                                                                          //os Códigos de Ocorrência da Posição 109 a 110 
      $aDetalhe["num_cartorio"]          = substr($sLin,                      368,    2);
      $aDetalhe["num_protocolo"]         = substr($sLin,                      370,   10);
      $aDetalhe["valor_abatimento"]      = $this->formataNumero(substr($sLin, 227,   13)); //9  v99 Valor do abatimento
      $aDetalhe["abatimento_nao_aprov"]  = $this->formataNumero(substr($sLin, 292,   13)); //9  v99 Abatimento não aproveitado pelo sacado
      $aDetalhe["valor_lancamento"]      = $this->formataNumero(substr($sLin, 305,   13)); //9  v99 Valor do lançamento
      $aDetalhe["indicativo_dc"]         = substr($sLin,                      318,    1);  //9  Indicativo de débito/crédito - ver nota 11
      $aDetalhe["indicador_valor"]       = substr($sLin,                      319,    1);  //9  Indicador de valor -ver  nota 12
      $aDetalhe["valor_ajuste"]          = $this->formataNumero(substr($sLin, 320,   12)); //9  v99 Valor do ajuste - ver nota 13
      $aDetalhe["sequencial"]            = substr($sLin,                      394,    6);  //9 Seqüencial do registro
      return $aDetalhe;
   }
	
/**Processa a linha trailer do arquivo.
* @param string $sLin Linha trailer do arquivo processado
* @return array<mixed> Retorna um vetor contendo os dados dos campos da linha trailer do arquivo.*/
   protected function processarTrailerArquivo($sLin) {
      //O formato de 400 posicoes do bradesco é diferente do padrao FEBRABAN
      //(pelo menos do usado pelo BB). Assim, nao é chamada a funcao na classe
      //pai pois a mesma é totalmente reimplementada aqui	
      //$aTrailer = parent::processarTrailerArquivo($sLin);	
      $aTrailer = array();
      //X = ALFANUMÉRICO 9 = NUMÉRICO V = VÍRGULA DECIMAL ASSUMIDA
      $aTrailer["registro"]                = substr($sLin,                        0,   1);  //9  Identificação do Registro Trailer: “9”
      $aTrailer["retorno"]                 = substr($sLin,                        1,   1);  //9  “2”
      $aTrailer["tipo_registro"]           = substr($sLin,                        2,   2);  //9  “01”
      $aTrailer["cod_banco"]               = substr($sLin,                        4,   3);  
      $aTrailer["cob_simples_qtd_titulos"] = substr($sLin,                       17,   8);  //9  Cobrança Simples - quantidade de títulos em cobranca
      $aTrailer["cob_simples_vlr_total"]   = $this->formataNumero(substr($sLin,  25,  14)); //9  v99 Cobrança Simples - valor total
      $aTrailer["cob_simples_num_aviso"]   = substr($sLin,                       39,   8);  //9  Cobrança Simples - Número do aviso
      $aTrailer["qtd_regs02"]              = substr($sLin,                       57,   5);  //Quantidade  de Registros- Ocorrência 02 – Confirmação de Entradas
      $aTrailer["valor_regs02"]            = $this->formataNumero(substr($sLin,  62,  12)); //Valor dos Registros- Ocorrência 02 – Confirmação de Entradas
      $aTrailer["valor_regs06liq"]         = $this->formataNumero(substr($sLin,  74,  12)); //Valor dos Registros- Ocorrência 06 liquidacao
      $aTrailer["qtd_regs06"]              = substr($sLin,                       86,   5);  //Quantidade  de Registros- Ocorrência 06 – liquidacao
      $aTrailer["valor_regs06"]            = $this->formataNumero(substr($sLin,  91,  12)); //Valor dos Registros- Ocorrência 06
      $aTrailer["qtd_regs09"]              = substr($sLin,                      103,   5);  //Quantidade  de Registros- Ocorrência 09 e 10
      $aTrailer["valor_regs02"]            = $this->formataNumero(substr($sLin, 108,  12)); //Valor dos  Registros- Ocorrência 09 e 10
      $aTrailer["qtd_regs13"]              = substr($sLin,                      120,   5);  //Quantidade  de Registros- Ocorrência 13
      $aTrailer["valor_regs13"]            = $this->formataNumero(substr($sLin, 125,  12)); //Valor dos  Registros- Ocorrência 13
      $aTrailer["qtd_regs14"]              = substr($sLin,                      137,   5);  //Quantidade  de Registros- Ocorrência 14
      $aTrailer["valor_regs14"]            = $this->formataNumero(substr($sLin, 142,  12)); //Valor dos  Registros- Ocorrência 14
      $aTrailer["qtd_regs12"]              = substr($sLin,                      154,   5);  //Quantidade  de Registros- Ocorrência 12
      $aTrailer["valor_regs12"]            = $this->formataNumero(substr($sLin, 159,  12)); //Valor dos  Registros- Ocorrência 12
      $aTrailer["qtd_regs19"]              = substr($sLin,                      171,   5);  //Quantidade  de Registros- Ocorrência 19
      $aTrailer["valor_regs19"]            = $this->formataNumero(substr($sLin, 176,  12)); //Valor dos  Registros- Ocorrência 19
      $aTrailer["valor_total_rateios"]     = $this->formataNumero(substr($sLin, 362,  15));
      $aTrailer["qtd_rateios"]             = substr($sLin,                      377,   8);
      $aTrailer["sequencial"]              = substr($sLin,                      394,   6);  //9  Seqüencial do registro
      return $aTrailer;
   }	

/**Processa uma linha do arquivo de retorno.
* @param int $iNumLin Número_linha a ser processada
* @param string $sLin String contendo a linha a ser processada
* @return array Retorna um vetor associativo contendo os valores_linha processada.*/
   public function processarLinha($iNumLin, $sLin) {
      $iTamLinha = 400; //total de caracteres das linhas do arquivo
      //o +2 é utilizado para contar o \r\n no final da linha
//      if (strlen($sLin)!=$iTamLinha and strlen($sLin)!=$iTamLinha+2) die("A linha $iNumLin no tem $iTamLinha posies. Possui " . strlen($sLin));
//      if (trim($sLin)=="") die("A linha $iNumLin est vazia.");

      //é adicionado um espaço vazio no início_linha para que
      //possamos trabalhar com índices iniciando_1, no lugar_zero,
      //e assim, ter os valores_posição_campos exatamente
      //como no manual CNAB400
      $sLin = " $sLin";
      $sTipoLin = substr($sLin,  1,  1);
      if($sTipoLin == $this->HEADER_ARQUIVO) {
         $sRet = $this->processarHeaderArquivo($sLin);
      } else if($sTipoLin == $this->DETALHE) {
         $sRet = $this->processarDetalhe($sLin);
      } else if($sTipoLin == $this->TRAILER_ARQUIVO) {
         $sRet = $this->processarTrailerArquivo($sLin); 
      } else {
         $sRet = NULL;
      }
      return $sRet;
   }
}

?>
