<?php 

// path to swiss ephemeris library files
$libPath = './sweph/';

putenv("PATH=$libPath");

//$usersTimezone = 'Asia/Kathmandu';
//$currentDate = new DateTime("now", new DateTimeZone($usersTimezone) );

$currentDate = new DateTime("now");

$date = $currentDate->format('d.m.Y');
$time = $currentDate->format('H:i:s');

# OUTPUT ARRAY
# Planet Name, Planet Degree, Planet Speed per day

// More about command line options: https://www.astro.com/cgi/swetest.cgi?arg=-h&p=0

// TROPICAL ZODIAC
exec ("swetest -edir$libPath -b$date -ut$time -p0123456789mt -eswe -fPls -g, -head", $output_t);
//var_dump($output_t); 

// SIDEREAL ZODIAC using Lahiri Ayanamsa | Planetary position for single day
exec ("swetest -edir$libPath -b$date -ut$time -p0123456789mt -n1 -sid1 -eswe -fPls -g, -head", $output_s);
//var_dump($output_s); 

// SIDERAL ZODIAC using Lahiri Ayanamsa | Planetary position for 5 consecutive days
exec ("swetest -edir$libPath -b$date -ut$time -p0123456789mt -n5 -sid1 -eswe -fPls -g, -head", $output_s5);
//var_dump($output_s5); 

//exec ("swetest -edir$libPath -b$date -ut$time -p0123456789Dmt -eswe -fPZs -g, -head", $output);
//var_dump($output);

exec ("swetest -edir$libPath -b$date -ut$time -p0123456789Dmt -eswe -fPZs -g, -house -head", $output);
var_dump($output);
 

$h_sys          = 'P';
$latitude       = -23.1865;
$longitude      = -46.8845;

exec ("swetest -edir$libPath -b$date -ut$time -p0123456789DAmt -sid1 -eswe -house$longitude,$latitude,$h_sys -fPZs -g, -head", $output2);
var_dump($output2);


exec ("swetest -edir$libPath -b$date -ut$time -p0123456789Dmt -eswe -fPZs -g, -head", $output3);
var_dump($output3);
