set sql dialect 3;
connect '/qtux/database/tq/gps_01.gdb';

/*
select first 100 substring(b.sCNPJ from 1 for 8)  sCNPJRaiz
  from FIN_Titulos a, 
       CUP         b
where a.iVer      = a.iVAt
  and a.pSacado   = b.pPId and b.iVer = b.iVAt
  and a.pCedente in (3050,5,9,10,3046)
  and a.lPrevisao = 0
  and a.jTipo     = 0
  and a.pNFe      > 0
  and b.sCNPJ    <> '' 
  and a.nBruto    >0
  and substring(b.sCNPJ from 1 for 14) = b.sCNPJ
group by substring(b.sCNPJ from 1 for 8);
*/

SET STAT;

select substring(b.sCNPJ from 1 for 8)  sCNPJRaiz,
                 min(b.tIn0)   tCliPriCad,
                 max(a.tIn0)   tUltComp,
                 max(a.pPreNF) pUltComp,
                (select aa.nTot_vNF from PreNF aa where aa.iver=aa.ivat and aa.pPid = max(a.pPreNF)) nUltComp,
                 sum(case when (a.tPgmto is null and a.lExc = 0 and a.tCanc is null) then a.nBruto else 0 end) nDebAtual,
                 sum(case when (a.tPgmto is null and a.lExc = 0 and a.tCanc is null and a.tVenc >= cast('today' as date)) then a.nBruto else 0 end) nDebAtualAVenc,
                 sum(case when (a.tPgmto is null and (cast('today' as date)-cast(a.tVenc as date))>=5)  then a.nBruto else 0 end) nDebAtualVenc5,
                 sum(case when (a.tPgmto is null and a.lExc = 0 and a.tCanc is null and (cast('today' as date)-cast(a.tVenc as date))>=15) then a.nBruto else 0 end) nDebAtualVenc15,
                 sum(case when (a.tPgmto is null and a.lExc = 0 and a.tCanc is null and (cast('today' as date)-cast(a.tVenc as date))>=30) then a.nBruto else 0 end) nDebAtualVenc30
  from FIN_Titulos a, 
       CUP         b
where a.iVer      = a.iVAt
  and a.pSacado   = b.pPId and b.iVer = b.iVAt
  and a.pCedente in (3050,5,9,10,3046)
  and a.lPrevisao = 0
  and a.jTipo     = 0
  and a.pNFe      > 0
  and b.sCNPJ    <> '' 
  and a.nBruto    >0
  and substring(b.sCNPJ from 1 for 14) = b.sCNPJ
  and substring(b.sCNPJ from 1 for 8) = '06057223'
group by substring(b.sCNPJ from 1 for 8);





/*
select a.sProd_cProd,
       case when a.sDes <> '' then a.sDes else a.sProd_xProd end,
       b.sEmit_CNPJ,
       1,
       count(*),
       count(*) OVER (PARTITION BY NFCapa b) AS a.sProd_xProd
from NFLinha a, NFCapa b
where a.PRECNONF=b.PRECNO
  and a.iVer=a.iVAt
  and b.iVer=b.iVAt
group by a.sProd_cProd,case when a.sDes <> '' then a.sDes else a.sProd_xProd end,b.sEmit_CNPJ
order by a.sProd_cProd,case when a.sDes <> '' then a.sDes else a.sProd_xProd end,b.sEmit_CNPJ;

*/
/*
select SUM(Mark) OVER (PARTITION BY id) AS Cost,firstname from TableA


T9585                                                        AGUA PERF RENOVAR BAMBU C/ HORTELA 18X15G                                                                                                                                                                12460301000187            1
T9585                                                        AGUA PERF RENOVAR BAMBU C/ HORTELA 18X15G

DECLARE @table TABLE (nome varchar(50),sala tinyint,CPF VARCHAR(50),DATA DATE)

insert into @table values('Getulio',1,'7777777777','2014-11-01');
insert into @table values('Maria',1,'8888888888','2014-11-02');
insert into @table values('Jose',2,'9999999999','2014-11-03');
insert into @table values('Joao',2,'1111111111','2014-11-04');
insert into @table values('Pedro',2,'2222222222','2014-11-05');
insert into @table values('Lucas',3,'3333333333','2014-11-06');

WITH SALA(SALA,TOTAL,POR_SALA)
AS
(
select DISTINCT
SALA 
,COUNT(SALA) OVER() AS [TOTAL]
,COUNT(SALA) OVER(PARTITION BY SALA ) AS [POR_SALA]
from
@table
WHERE 
DATA BETWEEN '2014-11-01' AND '2014-11-04'
AND CPF IN ('7777777777','8888888888','9999999999','1111111111')
)
SELECT * FROM SALA WHERE POR_SALA > 1
*/