set sql dialect 3;
connect 'localhost:/qtux/database/tq/gps_01.gdb';

show table Comissao_Range_TOper;
--show table CUP;

select a.pPId         pPreNF /*,

                         a.pEmi,
                         a.pRepCom,
                         k.lBonif,
                         a.tNFCapa,
                         b.pPId         pCC_CupOper,
                         c.tFinanc,
                         '', --d.jModCom,
                         e.pRepRegComU,
                         -- Parametros de Comisso por Regies Comerciais
                         f.nMB1D,
                         f.nMB1A,
                         f.nCom1,
                         f.nMB2D,
                         f.nMB2A,
                         f.nCom2,
                         f.nMB3D,
                         f.nMB3A,
                         f.nCom3,
                         f.nMB4D,
                         f.nMB4A,
                         f.nCom4,
                         f.nMB5D,
                         f.nMB5A,
                         f.nCom5,
                         h.pItem,
                         h.pPId          pPreNF_Itens,
                         h.nVDescInc,
                         h.nQt,
                         case when k.lBonif=0 then h.nProd_vUnCom else (coalesce(h.NPROD_VPROD,0)+coalesce(h.NPROD_VSEG,0)+coalesce(h.NPROD_VOUTRO,0)+coalesce(h.NICMS_VICMSST,0)+coalesce(h.NIPITRIB_VIPI,0))/h.nQt end,
                         h.nCTR_VlCalcI,
                         -- Comisso por Regio Comercial - Grupos/Sub-grupos de Itens
                         j.nCom          nComRGSubGrupo,
                         -- Comisso por Regio Comercial - Grupos/Sub-grupos de Itens
                         l.nCom          nComRepGSubGrupo,
                         i.pSubGrpSku,
                         e.sCoringa      sRep,
                         e.sCodRep,
                         m.iIde_nNF,
                         i.sCodigo       sCodItem,
                         g.pPId,
                         e.pRepFin,
                         cast (a.tNFCapaCanc as date),
                         a.lDevoluc,
                         e.nComFRep,
                         b.pCUPOperFin,
                         c.pPId   pMovCCAchou*/
                    from PreNF a --join PRepUNeg                  d on a.pPRepUNeg   = d.pPId       and d.iVer     = d.iVAt    and d.lExc  = 0
                                 join CUP                       e on a.pRepCom     = e.pPId       and e.iVer     = e.iVAt    and e.lExc  = 0
                                 join PreNF_Itens               h on h.pPreNF      = a.pPId       and h.iVer     = h.iVAt    and h.lExc  = 0
                                 join NFCapa                    m on a.pNF         = m.pPId       and m.iVer     = m.iVAt    and m.lExc  = 0
/*                                 join TOper                     k on a.pTOper      = k.pPId       and k.iVer     = k.iVAt    and k.lExc  = 0
                                 join Itens                     i on i.pPId        = h.pItem+0    and i.iVer     = i.iVAt    and i.lExc  = 0
                                 left join CC_CupOper           b on b.pUNeg       = a.pEmi       and b.pCUPOper = a.pRepCom and b.iVer  = b.iVAt and b.lExc = 0
                                 left join MovCC_CupOper        c on c.pDocOper    = a.pPId       and c.jAuto    = 1         and c.jTipo = 1      and c.iVer = c.iVAt and c.lExc = 0
                                 left join COM_RegCom           f on e.pRepRegComU = f.pRegCom    and a.pEmi     = f.pEmi    and f.iVer = f.iVAt
                                 left join COM_Rep              g on e.pPId        = g.pRep       and a.pEmi     = g.pEmi    and g.iVer = g.iVAt
                                 left join COM_RegCom_SubGSKU   j on i.pSubGrpSku  = j.pSubGrpSku and f.pPId     = j.pComR   and i.iVer = i.iVAt
                                 left join COM_Rep_SubGSKU      l on i.pSubGrpSku  = l.pSubGrpSku and g.pPId     = l.pComRep and l.iVer = l.iVAt*/
                   where a.jTipo = 1 and a.iVer = a.iVAt and a.lExc=0
                     and a.LPRENF_COMPLEMENTO = 0
                     and a.lTransfRem         = 0
--                     and h.nProd_vUnCom       > 0
                     and a.lRefat             = 0
--                     and a.pTOper in (131,139,13,1,52,55,94,96,99,167,168,112,97,113,40,134)
                     
                      and ((cast(m.tIde_Emi as date) >= cast('2019/08/01' as date)) or (cast(a.tNFCapaCanc as date) >= cast('2019/08/01' as date) ))and ((cast(m.tIde_Emi as date) <= cast('2019/08/31' as date)) or (cast(a.tNFCapaCanc as date) <= cast('2019/08/31' as date) )) 
and a.pEmi=3158 
and a.pRepCom = 35094
                    order by a.pPId;

/*
35094 JOSE BARTOLOMEU  - RN (TERMOGEL)                                                 01.24.17
35100 JOSE BARTOLOMEU - COLLIE                                                         01.23.08
35041 JOSE BARTOLOMEU / RN - DISTRIBUIDOR                                              01.15.10
  298 JOSE BARTOLOMEU CESAR DA FONSECA - RN                                            01.15.09
*/



--# qry RepCom X repFin
select first 100 skip 0 
       a.pPId				pRepCom			,
  		 a.sCoringa			RepCom			,
       a.sCodRep   		sCodRepCom		,
       a.jTipo									,
       a.pRepFin								,
       b.sCoringa    	sRepFin			
from CUP  a left join CUP  b on a.pRepFin = b.pPId and b.iVer = b.iVAt  
where a.iVer = a.iVAt   			and 
      a.lExc = 0        			and 
      a.sCoringa like '%BARTO%' 	and	--# add
      a.lRep = 1  
order by 2;

--#(1) 1.1. Processar Comisses -> dd_files/erp_FIN_Comissoes_Range.dda/Padrao_1 
select tDataDe		,
       tDataAte	,
       tFecham		,
		 pUNeg		,
		 pRepCom 
from Comissao_Range 
where pPId	=	5 		--# Range a Processar 
and iVer=iVAt;


--#(2) qry {TOper,...} do Range em questo Comissao_Range 
select a.pCapa,a.pTOper,b.sCodigo,b.sDescricao
from Comissao_Range_TOper 	a,
     TOper 						b
where a.iVer   = a.iVAt 		and 
      a.lExc   = 0      		and 
      a.pCapa  = 5        		and  --# {ptOper...} de Comissao_Range 
      a.pTOper = b.pPId 		and 
      b.iVer   = b.iVat;


--#qry grid (1) saldos
select     a.pCUPOperFin				 ,
           b.sCoringa 		sEmi		 ,
           c.sCodRep       sCodRep   ,
           c.sCoringa 		sRep		 ,
           a.pCUPOperFin				 ,
       sum(d.nTCTR)   		nTCTR		 ,
       sum(d.nTBaseCalc) 	nTBaseCalc,
  	    sum(d.nValor)   		nValorCred,
  cast(sum(case when (d.lDeb=1) then (-d.nValor) else 0           end) as numeric(12,2)) nValorDeb,
  cast(sum(case when (d.lDeb=0) then (d.nValor)  else (-d.nValor) end) as numeric(12,2)) nSaldo	  ,
     sum(e.nTot_vProd) nTot_vProd  
from  CC_CupOper a   join MovCC_CupOper d on d.pCC_CupOper = a.pPId and d.iVer = d.iVAt and d.lExc = 0       and  ((d.pRepFin = 41875 )) --# (41875) BARTO PROMOCOES DE VENDAS LTDA ME            
                left join CUP           b on a.pUNeg       = b.pPId and b.iVer = b.iVAt
                left join CUP           c on a.pCUPOperFin = c.pPId and c.iVer = c.iVAt            
                left join PreNF         e on d.pDocOper    = e.pPId and e.iVer = e.iVAt  
where a.lExc  = 0      and 
      a.iVer  = a.iVAt and 
      a.jTipo = 1  
group by a.pCUPOperFin,b.sCoringa,c.sCodRep,c.sCoringa,a.pCUPOperFin  
order by c.sCoringa,b.sCoringa;


--#qry grid (2) CC fechados por periodo
select first 100 skip 0 
       a.pPId									,
       a.tValor								,
       a.pDocOper								,
       a.nValor								,
       a.jTipo									,
       a.jAuto									,
      a.lDeb									,
  left(a.sDescricao,25)						,
       c.iIde_nNf								,
       (case when a.jOrigComis=4 then left(g.sCoringa	,25) 		else left(d.sCoringa	,25) 	end) sCoringa	,
       (case when a.jOrigComis=4 then left(g.sCNPJ		,15) 		else left(d.sCNPJ 	,15)	end) sCNPJ		,
       (case when a.jOrigComis=4 then left(g.sCPF		,15) 		else left(d.sCPF 		,15)	end) sCPF		,
       a.tFinanc								,
       a.nTCTR									,
       a.nTBaseCalc							,
       b.nTot_vProd							,
       a.nPComis								,
       b.pNF									,
    left(e.sCodigo,15)			sTOper	,
       e.lBonif								,
       e.lDevoluc								,
       b.tNFCapaCanc							,
       a.nMargem								,
       a.jOrigComis							,
       a.pVerba								,
       a.pTitVerba 
from MovCC_CupOper a left join PreNF 			b on a.pDocOper 	= b.pPId and b.iVer = b.iVAt 
                     left join NFCapa 			c on b.pNF 			= c.pPId and c.iVer = c.iVAt 
                     left join CUP 				d on b.pDest 		= d.pPId and d.iVer = d.iVAt 
                     left join TOper 			e on b.pTOper 		= e.pPId and e.iVer = e.iVAt 
                     left join FIN_ACORDOS 	f on a.pVerba 		= f.pPId and f.iVer = f.iVAt 
                     left join CUP 				g on f.pCedente 	= g.pPId and g.iVer = g.iVAt 
where a.pRepFin = 41875 	 and  --(41875) BARTO PROMOCOES DE VENDAS LTDA ME 
	   a.lExc    = 0 			 and 
      a.iVer    = a.iVAt 	 and 
      a.tFinanc is not null and 
 cast(a.tValor as date) >= '08/01/2019' and 
 cast(a.tValor as date) <= '08/30/2019' 
order by a.tValor desc;

/*
--# qry (1) saldos
select   a.pCUPOperFin					,
         b.sCoringa 		sEmi			,
         c.sCoringa 		sRep			,
         a.pCUPOperFin					,
         e.pPId							,	--# add p/ identificar cia
     sum(d.nTCTR)   		nTCTR 		,
     sum(d.nTBaseCalc) 	nTBaseCalc	,
     sum(d.nValor)   	nValorCred	,
cast(sum(case when (d.lDeb=1) then (-d.nValor) 	else 0 				end) as numeric(12,2)) nValorDeb	,
cast(sum(case when (d.lDeb=0) then (d.nValor) 	else (-d.nValor) 	end) as numeric(12,2)) nSaldo		,
     sum(e.nTot_vProd) nTot_vProd  
from  CC_CupOper a   		join MovCC_CupOper 	d on d.pCC_CupOper 	= a.pPId and d.iVer = d.iVAt and d.lExc=0 		and d.pRepFin = 41875
 							 left join CUP      			b on a.pUNeg    		= b.pPId and b.iVer = b.iVAt
                      left join CUP      			c on a.pCUPOperFin 	= c.pPId and c.iVer = c.iVAt
                      left join PreNF     		e on d.pDocOper  		= e.pPId and e.iVer = e.iVAt
  where a.lExc  = 0   		and 
        a.iVer  = a.iVAt   and 
        
        a.jTipo = 1  
group by a.pCUPOperFin,b.sCoringa,c.sCoringa,a.pCUPOperFin
		 -- # p/ identificar cia ,e.pPId
order by c.sCoringa,b.sCoringa;
*/

/*
--# qry (2) CC movimentos fechados do REPFIN
select first 100 skip 0 
a.pPId, a.tValor, a.pDocOper, a.nValor, a.jTipo, a.jAuto, a.lDeb, a.sDescricao, c.iIde_nNf, 
(case when a.jOrigComis=4 then g.sCoringa else d.sCoringa end) sCoringa, 
(case when a.jOrigComis=4 then g.sCNPJ else d.sCNPJ end) sCNPJ, 
(case when a.jOrigComis=4 then g.sCPF else d.sCPF end) sCPF, 
a.tFinanc, a.nTCTR, a.nTBaseCalc, b.nTot_vProd, a.nPComis, b.pNF, e.sCodigo sTOper, e.lBonif, e.lDevoluc, b.tNFCapaCanc, a.nMargem, a.jOrigComis, a.pVerba, a.pTitVerba 
from MovCC_CupOper a left join PreNF  			b on a.pDocOper 	= b.pPId and b.iVer = b.iVAt 
                     left join NFCapa 			c on b.pNF 			= c.pPId and c.iVer = c.iVAt 
                     left join CUP 				d on b.pDest 		= d.pPId and d.iVer = d.iVAt 
                     left join TOper 			e on b.pTOper 		= e.pPId and e.iVer = e.iVAt 
                     left join FIN_ACORDOS	f on a.pVerba 		= f.pPId and f.iVer = f.iVAt 
                     left join CUP 				g on f.pCedente 	= g.pPId and g.iVer = g.iVAt 
where a.pRepFin = 41875 and 
      a.lExc = 0 and 
      a.iVer = a.iVAt and 
      a.tFinanc is not null and 
 cast(a.tValor as date) >= '08/01/2019' and 
 cast(a.tValor as date) <= '08/30/2019' 
order by a.tValor desc;
*/





/*
   select a.pPId,
          a.tDataDe,
          a.tDataAte,
          a.tCalc,
          a.pCalc,
          b.sCoringa   sCalc,
          a.tFecham,
          a.pFecham,
          c.sCoringa   sFecham,
          a.pUNeg,
          d.sSigla,

          a.pRepCom,
          e.sCodRep,
          e.sCoringa   sRepCom
   from Comissao_Range a left join CUP    b on a.pCalc   = b.pPId and b.iVer = b.iVAt
                         left join CUP    c on a.pFecham = c.pPId and c.iVer = c.iVAt
                         left join CUP    d on a.pUNeg   = d.pPId and d.iVer = d.iVAt
                         left join CUP    e on a.pRepCom = e.pPId and e.iVer = e.iVAt

   where a.iVer = a.iVAt
     and a.lExc = 0
   order by a.tDataDe;
*/

/*
select first 100 skip 0 a.pPId,
 a.pOrdemGrupo,
 a.pBOPaiDeTodos,
 a.tLibCom,
 a.tLib,
 a.lGerarPreNF,
 a.tConc,
 a.tIn0,
 a.tEmissao,
 a.tConf,
 a.tCanc,
 a.pTOper,
 a.pDest,
 a.pEmi,
 a.nDescFin,
 a.nPDescLog,
 a.tEntPla,
 a.tEntPlaCalc,
 a.jTipo jEntSai,
 a.sDoc,
 a.jOrigem,
 b.sCoringa sEmi,
 b.sSigla sCIA,
 c.sCoringa sDest,
 c.sCNPJ,
 c.sCPF,
 a.pMoe,
 a.nTot_vNF,
 a.jBC_Pis,
 a.jBC_Cofins,
 a.jBC_Icms,
 a.jBC_IPI,
 a.jBC_II,
 a.jBC_ICMSST,
 a.jBC_ISS,
 a.jVl_ICMSST,
 a.jVl_ICMS,
 a.lLimCred,
 a.lNA_Bonif,
 a.lFinanc,
 a.pTOper,
 a.fTOper,
 d.sDescricao sTOper,
 d.sCodigo sTOperCod,
 a.lTransfRem,
 a.lCalculado,
 a.lFeriado,
 a.jDtPlaEnt,
 a.jFase,
 a.pWebNet,
 e.iNROrdem,
 h.nDFin,
 a.lTransfDep3o,
 a.lCliInativo,
 q.sSigla sDestSiglaEnt
 from Ordens a join CUP b on a.pEmi = b.pPId and b.iVer = a.fEmi
 join CUP c on a.pDest = c.pPId and c.iVer = a.fDest
 join TOper d on a.pTOper = d.pPId and d.iVer = a.fTOper
 left join Enderecos n on a.pDestEndEnt = n.pPId and n.iVer = n.iVAt
 left join CEPs o on n.pCEP = o.pPId and o.iVer = o.iVAt
 left join Cidades p on o.pCid = p.pPId and p.iVer = p.iVAt
 left join UFs q on p.pUF = q.pPId and q.iVer = q.iVAt
 left join CUP i on a.pRepCom = i.pPId and i.iVer = i.iVAt
 left join Ordens_ASC e on a.pWebNet = e.pPId and e.iVer = e.iVAt 
 left join Ordens_FPgmto f on f.pOrdem = a.pPId and f.iVer = f.iVAt and f.lExc=0 
 left join PED_FPgmto_CPgmto g on f.pPED_FPgmto_CPgmto = g.pPId and g.iVer = (case when f.fPED_FPgmto_CPgmto=0 then g.iVAt else f.fPED_FPgmto_CPgmto end) and g.lExc=0 
 left join CPgmto h on g.pCPgmto = h.pPId and h.iVer = h.iVAt and h.lExc=0
 where a.pEmi = 5 and a.pTOper = 208 and a.lExc = 0 and a.iVer = a.iVAt
 and a.jTipo = 1
 and (a.tLibCom is not null or a.jOrigem<>4)
 order by a.pPId desc;
*/
/*
select first 100 skip 0 
     a.pPId									,
     a.pOrdem								,
     a.nQt									,
     a.nProd_vProd						,
     a.nPrBruto							,
     b.sCodigo   				sCodItem	,
     a.nIPITrib_vIPI						,
     g.sCodigo   				sCodNCM	
from Ordens_Itens a  left join Moeda     k   on a.pMoe   = k.pPId   and k.iVer   = k.iVAt              
                     left join Cambio    kk  on a.pCam   = kk.pPId  and kk.iVer  = kk.iVAt              
                     left join Moeda     kk1 on kk.pMoe2 = kk1.pPId and kk1.iVer = kk1.iVAt              
                     left join NCM       g   on a.pNCM   = g.pPId   and g.iVer   = a.fNCM,
        Itens         b,
        UnidadeMedida c,
        Ordens        d,  
        TOper         e 
where a.lExc    = 0       and
      a.iVer    = a.iVAt  and
      a.pOrdem  > 300000  and
      a.pOrdem  = d.pPId  and a.nIPITrib_vIPI > 0 and
      d.pEmi    = 5 		  and 
      d.pTOper  = 208	  and
      d.iVer    = d.iVAt  and
      a.pItem   = b.pPId  and
      b.iVer    = a.fItem and
      a.pUni    = c.pPId  and
      c.iVer    = c.iVAt  and
      d.pTOper  = e.pPId  and 
      e.iVer    = d.fTOper

order by a.iSerial;
*/

/*
show table Orc_Capa;
show table OrcGrpUNeg_Capa;
show table OrcGrpUNeg_Linha;
show table OrcGrpUNeg_Linha;
show table Ordens_Item_CContabil;
show table Ordens;
show table Ordens_Itens;
show table Orc_PlaConta;
*/



/*
show table RangeRel_SaldosMov_Dep;
show table RangeRel_SaldosMov_Itens;
insert into RangeRel_ConsumosMov 
(jFormato,sPathSaida,pImp,sImp,sDoc,pIns,tLancDe,tLancAte,pUNeg,pQuemF,pInc,sVer) 
values (0,'',0,'','teste',0,'Jun-04-2019','Jun-12-2019',10,0,2,'dd_files/erp_EST_RangeRel_ConsumoMov.dda/Padrao_1');
show table RangeRel_ConsumoMov_Dep;
show table RangeRel_ConsumoMov_Itens;
*/


--select jFormato,sPathSaida,pImp,sImp,pUNeg,pIns,sDoc,pQuemF,tLancDe,tLancAte  from RangeRel_ConsumoMov  where  pPId = 1 and  iVer  = iVAt;
--show table Rel_ConsumoMov;
--insert into Rel_ConsumoMov (pInc,pRCMov,sCItm,sDItm,iDUtl,iDUtz,tESMo,tDMin,tDMax,nQSdoT,nCMed,nMaxC,nEstD,nCobe) values (1,0,'35136','TAMPA 500 ML AMARELA DESINFETA',20,10,'2019-04-25','2019-04-01','2019-04-25',164877.99999758,8243.899999879,34607.999998800,209890.000148050,25.460037136687);
--delete from Rel_ConsumoMov;
--select sCItm,iDUtl,iDUtz,tDMin,tDMax,nQSdoT from Rel_ConsumoMov where iver =ivat;

--insert into Rel_ConsumoMov (pInc,pRCMov,sCItm,sDItm,iDUtl,iDUtz,tESMo,tDMin,tDMax,nQSdoT,nCMed,nMaxC,nEstD,nCobe) values (1,0,'34649','PREFORMA CRISTAL 84 GRAMAS FIN',24,19,'2019-04-30','2019-04-01','2019-04-30',354728.99997284,14780.374998868,42578.999997600,400938.002473650,27.126375515124);

/*
select a.jOrigem,
                      count(*),
                      sum(case when (a.tDataF is null) then (1) else (0) end)  nAbertos,
                      sum(case when (a.tDataF is not null) then (1) else (0) end) nFechados,
                      sum(b.nCusto)
               from Chamado_Consumidor   a join Chamado_Ocorrencias  b on a.pPId  = b.pCHA   and b.iVer = b.iVAt
               where a.iVer  = a.iVAt  and cast(a.tIn0 as date) >= '07/01/2019' and cast(a.tIn0 as date) <= '08/08/2019'
                 and a.lExc = 0
               group by a.jOrigem
               order by 1
;
*/

--select count(*) from Rel_ConsumoMov where iver=ivat;

/*
show table EST_INSTANCIAS;

select sum(a.nSdo-a.nRes)
from EST_RegDepositos a,
     EST_Depositos    b,
     EST_Instancias   c,
     UnidadeMedida    d,
     Itens            e  
where a.lExc  = 0
  and a.iVer  = a.iVAt
  and a.pDep  = b.pPId
  and b.iVer  = b.iVAt
  and b.lMRPII= 1
  and a.pIns  = c.pPId
  and c.iVer  = c.iVAt 
  and c.lRese = 1
  and a.pUni  = d.pPId
  and d.iVer  = d.iVAt 
  and a.pItem = e.pPId
  and 43640;

select substring(f.sDescricao from 1 for 20)     sItem,
                 substring(f.sCodigo from 1 for 10)        sCodigo,
                 cast(a.tIn0 as date)                      tMov,
                 sum(a.nQtSdo)                             nQtSdo,
                 substring(c.sUnidade from 1 for 8)        sUniSdo,
                 f.pUneg

            from EST_MovSaldos    a left join LotesItens       d  on a.pLote    = d.pPId  and d.iVer    = d.iVAt
                                         join UnidadeMedida    b  on a.pUniOri  = b.pPId  and b.iVer    = b.iVAt
                                         join UnidadeMedida    c  on a.pUniSdo  = c.pPId  and c.iVer    = c.iVAt
                                         join EST_RegDepositos e  on a.pRegDep  = e.pPId  and e.iVer    = e.iVat and e.lExc    = 0
                                         join Itens            f  on e.pItem    = f.pPId  and f.iVer    = f.iVAt
                                         join CUP              h  on f.pUNeg    = h.pPId  and h.iVer    = h.iVAt
                                         join EST_Instancias   g  on e.pIns     = g.pPId  and g.iVer    = g.iVAt and (g.lRese  = 1 )
                                         join UnidadeMedida    ee on e.pUni     = ee.pPId and ee.iVer   = ee.iVAt
                                         join EST_Depositos    i  on e.pDep     = i.pPid  and i.iVer    = i.iVAt and i.lExc    = 0
                                    left join UFis             aa on i.pUFis    = aa.pPId and aa.iVer   = aa.iVAt
                                    left join UFis             kk on aa.pParent = kk.pPId and kk.iVer   = kk.iVAt
            where a.iVer    = a.iVAt and a.lExc    = 0
              and cast(a.tIn0  as date) >= '2019-06-12'
            and (f.LMANUF    = 1 or f.LCOMPRADO  = 1)
            and f.lImprod    = 0
            and f.sCodigo    in ('34649')
            and a.pOP        > 0
            group by substring(f.sDescricao from 1 for 20),substring(f.sCodigo from 1 for 10),cast(a.tIn0 as date),substring(c.sUnidade from 1 for 8),f.pUneg
            order by substring(f.sCodigo from 1 for 10),cast(a.tIn0 as date);

*/
/*
PPID                            DECIMAL(18, 0) Not Null default 0
PCIA                            DECIMAL(18, 0) Nullable default 0
TDE                             TIMESTAMP Nullable default 'now'
TORCATE                         TIMESTAMP Nullable default 'now'
TLIB                            TIMESTAMP Nullable default 'now'
PLIB                            DECIMAL(18, 0) Nullable default 0
TCON                            TIMESTAMP Nullable default 'now'
PCON                            DECIMAL(18, 0) Nullable default 0
PORGGRPUNEG_CAPA                DECIMAL(18, 0) Nullable default 0
SVER                            VARCHAR(5000) CHARACTER SET ISO8859_1 Nullable                                 COLLATE PT_BR
TATE                            TIMESTAMP Nullable
ILIDO                           DECIMAL(9, 0) Nullable DEFAULT 0
TULTLIDO                        TIMESTAMP Nullable
Table ORC_CAPA:

PPID                            DECIMAL(18, 0) Not Null default 0
PCIA                            DECIMAL(18, 0) Nullable default 0
SDESCRICAO                      VARCHAR(100) CHARACTER SET ISO8859_1 Nullable                                 COLLATE PT_BR
SVER                            VARCHAR(5000) CHARACTER SET ISO8859_1 Nullable                                 COLLATE PT_BR
ILIDO                           DECIMAL(9, 0) Nullable DEFAULT 0
TULTLIDO                        TIMESTAMP Nullable
Table ORCGRPUNEG_CAPA:

PPID                            DECIMAL(18, 0) Not Null default 0
PCIA                            DECIMAL(18, 0) Nullable default 0
PORCGRPUNEG_CAPA                DECIMAL(18, 0) Nullable default 0
FORCGRPUNEG_CAPA                DECIMAL(7, 0) Nullable default 0
PUNEG                           DECIMAL(18, 0) Nullable default 0
SVER                            VARCHAR(5000) CHARACTER SET ISO8859_1 Nullable  COLLATE PT_BR
ILIDO                           DECIMAL(9, 0) Nullable DEFAULT 0
TULTLIDO                        TIMESTAMP Nullable
Table ORCGRPUNEG_LINHA:
*/	

/*

select PPID,TDE,TORCATE,TLIB,TCON,PORGGRPUNEG_CAPA,TATE from ORC_CAPA where iVer = iVAt;
select SDESCRICAO,PPID,PCIA from ORCGRPUNEG_CAPA where iVer = iVAt;
select PPID,PCIA,PORCGRPUNEG_CAPA,FORCGRPUNEG_CAPA,PUNEG from ORCGRPUNEG_LINHA where iVer = iVAt;

          select a.pPId,
                  a.tDe,
                  a.tAte,
                  a.pOrgGrpUNeg_Capa
           from Orc_Capa          a,
                OrcGrpUNeg_Capa   b,
                OrcGrpUNeg_Linha  c
           where a.iVer = a.iVAt
              and a.pOrgGrpUNeg_Capa = b.pPId and b.iVer=b.iVAt
              and c.pOrcGrpUNeg_Capa = b.pPId and c.iVer=c.iVAt
              and cast(a.tDe as date) <= '2019-05-12'
              and cast(a.tAte as date) >= '2019-05-12'
              and a.lExc=0;

*/
--    select pUNeg from OrcGrpUNeg_Linha  where iVer = iVAt and pOrcGrpUNeg_Capa=$pOrgGrpUNeg  and lExc=0;

/*
           select a.pCPla
           from Ordens_Item_CContabil  a,
                Ordens_Itens           b
           where a.iVer=a.iVAt and a.lExc=0
             and a.pOrdemItem = b.pPId and b.iVer=b.iVAt b.lExc=0
             and b.pOrdem = $ppOrdem
           group by a.pCPla;


           select f.pCPla
           from   PreNF_Itens   a   join PreNF                 e on a.pPreNF      = e.pPId and e.iVer = e.iVAt and e.lFinanc =1
                                    join Itens                 d on a.pItem       = d.pPId and d.iVer = d.iVAt
                                    join PreNF_Item_CContabil  f on f.pPreNFItem  = a.pPId and f.iVer = f.iVAt
           where a.lExc    = 0 and a.iVer = a.iVAt
             and a.pPreNF  = 356444
             and a.pItem > 0
           group by f.pCPla;

*/


--    select nOrc,lOrc from Orc_PlaConta where iVer = iVAt and lExc=0 and pOrc=$pOrc and pPla=$pPla;

/*
          select  sum(coalesce(b.NPROD_VPROD,0)+coalesce(b.NPROD_VFRETE,0)+coalesce(b.NPROD_VSEG,0)+coalesce(b.NPROD_VOUTRO,0)+coalesce(b.NICMS_VICMSST,0)+coalesce(b.NIPITRIB_VIPI,0))
          from Ordens                  a  join Ordens_Itens            b on b.pOrdem      = a.pPId and b.iVer=b.iVAt and b.lExc=0
                                          join Ordens_Item_CContabil   c on c.pOrdemItem  = b.pPId and c.iVer=c.iVAt and c.lExc=0 and c.lDeb = 1 -- and c.pCPla = ...
          Where a.iVer=a.iVAt
            and a.lExc=0
            and a.tCanc is null
            and a.tConf is not null
            and a.jTipo =0
            and a.pSacado in
            and a.pEmi in ($sInUNeg)
            and ((a.jDtPlaEnt=0 and cast(a.tEntPlaCalc as date) >= '$tDe' ) or (a.jDtPlaEnt=1 and cast(a.tEntPla as date) >= '$tDe' ))
            and ((a.jDtPlaEnt=0 and cast(a.tEntPlaCalc as date) <= '$tAte') or (a.jDtPlaEnt=1 and cast(a.tEntPla as date) <= '$tAte'));
           select f.pCPla
           from   PreNF_Itens   a   join PreNF                 e on a.pPreNF      = e.pPId and e.iVer = e.iVAt and e.lFinanc =1
                                    join Itens                 d on a.pItem       = d.pPId and d.iVer = d.iVAt
                                    join PreNF_Item_CContabil  f on f.pPreNFItem  = a.pPId and f.iVer = f.iVAt
           where a.lExc    = 0 and a.iVer = a.iVAt
             and a.pPreNF  = 356444
             and a.pItem > 0
           group by f.pCPla;

          select  sum(coalesce(b.NPROD_VPROD,0)+coalesce(b.NPROD_VFRETE,0)+coalesce(b.NPROD_VSEG,0)+coalesce(b.NPROD_VOUTRO,0)+coalesce(b.NICMS_VICMSST,0)+coalesce(b.NIPITRIB_VIPI,0))
          from PreNF                   a  join PreNF_Itens             b on b.pPreNF      = a.pPId and b.iVer=b.iVAt and b.lExc=0
                                          join PreNF_Item_CContabil    c on c.pPreNFItem  = b.pPId and c.iVer=c.iVAt and c.lExc=0 
          Where a.iVer=a.iVAt
            and a.lExc=0
            and a.jTipo =0
            and a.pDest in (49419)
            and a.pEmi in (5)
            and ((a.jDtPlaEnt=0 and cast(a.tEntPlaCalc as date) >= '2019-05-17' ) or (a.jDtPlaEnt=1 and cast(a.tEntPla as date) >= '2019-05-17' ))
            and ((a.jDtPlaEnt=0 and cast(a.tEntPlaCalc as date) <= '2019-05-17') or (a.jDtPlaEnt=1 and cast(a.tEntPla as date) <= '2019-05-17'));

*/


/*
select  sum( coalesce(NPROD_VPROD,0)
            +coalesce(NPROD_VFRETE,0)
            +coalesce(NPROD_VSEG,0)
            +coalesce(NPROD_VOUTRO,0)
            +coalesce(NICMS_VICMSST,0)
            +coalesce(NIPITRIB_VIPI,0))

from Ordens_Itens   a,
     Ordens         b

Where a.iVer   = a.iVAt and a.lExc=0
  and a.pOrdem = b.pPId 
  and b.iVer   = b.iVAt and b.lExc=0
  and b.tCanc is null
  and b.jTipo  = 0

  and ( 
        (b.jDtPlaEnt=0 and cast(b.tEntPlaCalc as date) >= '01-05-2019') or 
        (b.jDtPlaEnt=1 and cast(b.tEntPla     as date) >= '01-05-2019')    
      )
  and ( 
        (b.jDtPlaEnt=0 and cast(b.tEntPlaCalc as date) <= '01-05-2019') or 
        (b.jDtPlaEnt=1 and cast(b.tEntPla     as date) <= '01-05-2019')    
      )
;
*/


/*
Cdigo	
SKU	
DiasUteis	DUteis periodo fora feriados/domingos
DiasUteisUtilizados	Dentro dos DUteis acima quantos dias ele foi utilizado
Data da Mov De/Ate 	Primeiro dia consumido e ltimo
ConsumoMdio	
Estoque Disponvel	(O Saldo tem que ser do EST_Reg_Deposito / Utilizar a flag do relatrio do MRP (somente instancias disponveis)

Cia
Deposito
Instancia


MximoConsumoDia	
Cobertura 	(Disponvel/Consumo mdio)

POP                             DECIMAL(18, 0) Nullable default 0
FOP                             DECIMAL(7, 0) Nullable default 0
PPRENF                          DECIMAL(18, 0) Nullable default 0
FPRENF   

  and a.pRegDep = 24897  1000 - Agua 
  and a.pRegDep = 57934  25090-TQ-POLIETILENO ALTA DENSIDADE BRANCO COBREVALE 

  where a.pDep  = 21 
  where a.pDep = 30 
    and b.pPId  = 19286 
    and b.pPId  = 46620 

  (case when (a.tCISP_Pgmto is null) then cast('today' as date) else cast(a.tCISP_Pgmto as date) end)-(case when (cast(a.tVenc as date)<'1970-01-01') then cast(a.tEmissao as date) else cast(a.tVenc  as date) end) i1DCB,
  (case when (cast(a.tVenc as date)<'1970-01-01') then 0 else (cast(a.tVenc  as date)-cast(a.tEmissao as date))  end ) i2DCB,

*/

/*

show table EST_MovSaldos;
show table EST_RegDepositos;
show table EST_Depositos;
show table EST_Instancias;
*/

--SET STAT;
--SET PLAN ON;


--select pMUN,pUF,count(*) from FERIADOS where iver=ivat group by pMUN,pUF order by 1,2;

--select substring(SDESCRICAO from 1 for 15),LTRANS,LRESE,LDEVO,LRECE,LINSP,LREJE,LPERD,LINVE,ILIDO,TULTLIDO from EST_Instancias where iver=ivat;

/*
          select substring(h.sSigla        from 1 for 7)   sCIA,
                 substring(aa.sUFis        from 1 for 20)  sUn1,
                 substring(kk.sUFis        from 1 for 26)  sUn2,
                 i.lMRPII                                  lEDepMRP,
                 substring(f.sDescricao    from 1 for 40)  sItem,
                 substring(f.sCodigo       from 1 for 10)  sCodigo,
                 substring(a.sDescricao    from 1 for 50)  sDescMov,
                 cast(a.tIn0 as date)                      dMov,
                 substring(g.sDescricao    from 1 for 20)  sInstancia,
                 substring(b.sUnidade      from 1 for 20)  sUniOri,
                 substring(a.nFator        from 1 for 20)  nFator,
                 substring(a.nQtSdo        from 1 for 20)  nQtSdo,
                 substring(c.sUnidade      from 1 for 20)  sUniSdo,
                 substring(d.sDescricao    from 1 for 30)  sLote,
                 substring((e.nSdo-e.nRes) from 1 for 20)  sSdoRes,
                 substring(ee.sUnidade     from 1 for 20)  sUniSdoRes
*/
/*          select 
                 substring(a.sDescricao    from 1 for 30)  sDescMov,
                 cast(a.tIn0 as date)                      dMov,
                 substring(g.sDescricao    from 1 for 10)  sInstancia,
                 substring(a.nQtSdo        from 1 for 20)  nQtSdo,
                 a.pOSa,
                 a.pOEn,
                 a.pOP,
                 a.pRFis,  
                 a.pPreNF, 
                 a.pNFE,   
                 a.pOperest 
select g.LTRANS,   
       g.LRESE ,  
       g.LDEVO ,  
       g.LRECE ,  
       g.LINSP ,  
       g.LREJE ,  
       g.LPERD ,  
       g.LINVE ,       
       g.ILIDO ,
       count(*)

group by g.LTRANS,
         g.LRESE ,
         g.LDEVO ,
         g.LRECE ,
         g.LINSP ,
         g.LREJE ,
         g.LPERD ,
         g.LINVE , 
         g.ILIDO ;

SUBSTRING        LTRANS   LRESE   LDEVO   LRECE   LINSP   LREJE   LPERD   LINVE        ILIDO                  TULTLIDO
=============== ======= ======= ======= ======= ======= ======= ======= ======= ============ =========================
Disponvel            0       1       0       0       0       0       0       0            0                    <null>
Inspeo              0       0       0       0       1       0       0       0            0                    <null>
Recebimento           0       0       0       1       0       0       0       0            0                    <null>
Trnsito              1       0       0       0       0       0       0       0            0                    <null>

and lRese 
and lInsp 
and lRece 
and lTrans 
 */
--show table Enderecos;

/*
          select a.pOSa    , 
                 a.pOEn    , 
                 a.pOP     , 
       substring(f.sDescricao    from 1 for 10)  sItem,
                 a.pRFis   ,   
                 a.pPreNF  ,  
                 a.pNFE    , 
                 substring(a.nQtSdo        from 1 for 20)  nQtSdo,                
                 a.pOperest,
                 substring(a.sDescricao  from 1 for 10) sDesc, 
                 count(*) 
*/

/*
select
                 count(case when f.LACABADO=1 and a.pOSa    <>0 then (1) else (0) end) lAcabado_pOSa   ,                 
                 count(case when f.LACABADO=1 and a.pOEn    <>0 then (1) else (0) end) lAcabado_pOEn   , 
                 count(case when f.LACABADO=1 and a.pOP     <>0 then (1) else (0) end) lAcabado_pOP    , 
                 count(case when f.LACABADO=1 and a.pRFis   <>0 then (1) else (0) end) lAcabado_pRFis  ,   
                 count(case when f.LACABADO=1 and a.pPreNF  <>0 then (1) else (0) end) lAcabado_pPreNF ,  
                 count(case when f.LACABADO=1 and a.pNFE    <>0 then (1) else (0) end) lAcabado_pNFE   , 
                 count(case when f.LACABADO=1 and a.nQtSdo  <>0 then (1) else (0) end) lAcabado_nQtSdo ,                
                 count(case when f.LACABADO=1 and a.pOperest<>0 then (1) else (0) end) lAcabado_pOperest,

                 count(case when f.LCOMPRADO=1 and a.pOSa    <>0 then (1) else (0) end) lComprado_pOSa   ,                 
                 count(case when f.LCOMPRADO=1 and a.pOEn    <>0 then (1) else (0) end) lComprado_pOEn   , 
                 count(case when f.LCOMPRADO=1 and a.pOP     <>0 then (1) else (0) end) lComprado_pOP    , 
                 count(case when f.LCOMPRADO=1 and a.pRFis   <>0 then (1) else (0) end) lComprado_pRFis  ,   
                 count(case when f.LCOMPRADO=1 and a.pPreNF  <>0 then (1) else (0) end) lComprado_pPreNF ,  
                 count(case when f.LCOMPRADO=1 and a.pNFE    <>0 then (1) else (0) end) lComprado_pNFE   , 
                 count(case when f.LCOMPRADO=1 and a.nQtSdo  <>0 then (1) else (0) end) lComprado_nQtSdo ,                
                 count(case when f.LCOMPRADO=1 and a.pOperest<>0 then (1) else (0) end) lComprado_pOperest,

                 count(case when f.LMANUF=1 and a.pOSa    <>0 then (1) else (0) end) lManuf_pOSa   ,                 
                 count(case when f.LMANUF=1 and a.pOEn    <>0 then (1) else (0) end) lManuf_pOEn   , 
                 count(case when f.LMANUF=1 and a.pOP     <>0 then (1) else (0) end) lManuf_pOP    , 
                 count(case when f.LMANUF=1 and a.pRFis   <>0 then (1) else (0) end) lManuf_pRFis  ,   
                 count(case when f.LMANUF=1 and a.pPreNF  <>0 then (1) else (0) end) lManuf_pPreNF ,  
                 count(case when f.LMANUF=1 and a.pNFE    <>0 then (1) else (0) end) lManuf_pNFE   , 
                 count(case when f.LMANUF=1 and a.nQtSdo  <>0 then (1) else (0) end) lManuf_nQtSdo ,                
                 count(case when f.LMANUF=1 and a.pOperest<>0 then (1) else (0) end) lManuf_pOperest
*/

--          select f.LACABADO,f.LCOMPRADO,f.LMANUF,f.LVENDA,f.LREVENDA,f.LCONSUMO,f.LPROD,f.LIMPROD,f.LPROPRIA,f.LTERC,count(*)
/*
            select (case when f.LACABADO  =1 then (1) else ('') end) LACABADO , 
                   (case when f.LCOMPRADO =1 then (1) else ('') end) LCOMPRADO,
                   (case when f.LMANUF    =1 then (1) else ('') end) LMANUF   ,
                   (case when f.LVENDA    =1 then (1) else ('') end) LVENDA   ,
                   (case when f.LREVENDA  =1 then (1) else ('') end) LREVENDA ,
                   (case when f.LCONSUMO  =1 then (1) else ('') end) LCONSUMO ,
                   (case when f.LPROD     =1 then (1) else ('') end) LPROD    ,
                   (case when f.LIMPROD   =1 then (1) else ('') end) LIMPROD  ,
                   (case when f.LPROPRIA  =1 then (1) else ('') end) LPROPRIA ,
                   (case when f.LTERC     =1 then (1) else ('') end) LTERC    , 
                   count(*)
*/
/*
          select a.pOSa    , 
                 a.pOEn    , 
                 a.pOP     , 
       substring(f.sDescricao    from 1 for 10)  sItem,
                 a.pRFis   ,   
                 a.pPreNF  ,  
                 a.pNFE    , 
                 substring(a.nQtSdo        from 1 for 20)  nQtSdo,                
                 a.pOperest,
                 substring(a.sDescricao  from 1 for 10) sDesc 
*/
/*

                 select first 5000
                 a.PREGDEP   ,
                 a.NRESDEP ,
                 a.NRESLOTE,
                 a.ILIDO   ,
                 a.POSA      ,
                 a.POEN      ,
                 a.POP       ,
                 a.PRFIS     ,
                 a.PRSUPU    ,
                 a.PRSUPD    ,
                 a.PPRENF    ,
                 a.PNFE      ,
                 a.PUNIORI   ,
                 a.PCONV     ,
                 a.POPEREST  ,
                 a.JNOTA     ,
                 a.PFOR      ,
                 a.JTIPO     ,
                 substring(f.sDescricao    from 1 for 10)  sItem,
                 substring(a.sDescricao  from 1 for 10) sDesc 
*/

/*
          select first 5000
                 substring(h.sSigla from 1 for 7)          sCIA,
                 substring(aa.sUFis from 1 for 20)         sUn1,
                 substring(kk.sUFis from 1 for 26)         sUn2,
                 i.lMRPII                                  lEDepMRP,  
                 substring(f.sDescricao from 1 for 20)     sItem,
                 substring(f.sCodigo from 1 for 10)        sCodigo,
                 substring(a.sDescricao from 1 for 20)     sDescMov,
                 cast(a.tIn0 as date)                      dMov,
                 substring(g.sDescricao from 1 for 10)     sInstancia,
                 substring(b.sUnidade from 1 for 8)        sUniOri,
                 substring(a.nFator from 1 for 12)         nFator,
                 substring(a.nQtSdo from 1 for 17)         nQtSdo,
                 substring(c.sUnidade from 1 for 8)        sUniSdo,
                 substring(d.sDescricao from 1 for 15)     sLote,
                 substring((e.nSdo-e.nRes) from 1 for 17)  sSdoRes,
                 substring(ee.sUnidade from 1 for 10)      sUniSdoRes,
                 a.POSA      ,
                 a.POEN      ,
                 a.POP       ,
                 a.PRFIS     
 */
  
/*       
          select first 5000
                 substring(h.sSigla from 1 for 7)          sCIA,
                 substring(aa.sUFis from 1 for 20)         sUn1,
                 substring(f.sDescricao from 1 for 20)     sItem,
                 substring(f.sCodigo from 1 for 10)        sCodigo,
                 substring(a.sDescricao from 1 for 20)     sDescMov,
                 cast(a.tIn0 as date)                      dMov,
                 substring(g.sDescricao from 1 for 10)     sInstancia,
                 substring(b.sUnidade from 1 for 8)        sUniOri,
                 substring(a.nFator from 1 for 12)         nFator,
                 substring(a.nQtSdo from 1 for 17)         nQtSdo,
                 substring(c.sUnidade from 1 for 8)        sUniSdo,
                 substring(d.sDescricao from 1 for 15)     sLote,
                 substring((e.nSdo-e.nRes) from 1 for 17)  sSdoRes,
                 substring(ee.sUnidade from 1 for 10)      sUniSdoRes,
                 a.POP       


            from EST_MovSaldos    a left join LotesItens       d  on a.pLote    = d.pPId  and d.iVer    = d.iVAt
                                         join UnidadeMedida    b  on a.pUniOri  = b.pPId  and b.iVer    = b.iVAt
                                         join UnidadeMedida    c  on a.pUniSdo  = c.pPId  and c.iVer    = c.iVAt
                                         join EST_RegDepositos e  on a.pRegDep  = e.pPId  and e.iVer    = e.iVat and e.lExc    = 0
                                         join Itens            f  on e.pItem    = f.pPId  and f.iVer    = f.iVAt
                                         join CUP              h  on f.pUNeg    = h.pPId  and h.iVer    = h.iVAt
                                         join EST_Instancias   g  on e.pIns     = g.pPId  and g.iVer    = g.iVAt and (g.lRese  = 1 )
                                         join UnidadeMedida    ee on e.pUni     = ee.pPId and ee.iVer   = ee.iVAt
                                         join EST_Depositos    i  on e.pDep     = i.pPid  and i.iVer    = i.iVAt and i.lExc    = 0
                                    left join UFis             aa on i.pUFis    = aa.pPId and aa.iVer   = aa.iVAt
                                    left join UFis             kk on aa.pParent = kk.pPId and kk.iVer   = kk.iVAt
            where a.iVer    = a.iVAt and a.lExc    = 0 
              and cast(a.tIn0  as date) >= '2019-04-01'
            and (f.LMANUF    = 1 or f.LCOMPRADO  = 1)
            and f.lImprod    = 0
            and f.sCodigo    = '34649'
            and a.pOP        > 0   
--            and (f.LACABADO  = 1 and f.LMANUF    = 1)
--            and f.LACABADO   = 1 
--            and f.LCOMPRADO  = 1

--            group by f.LACABADO,f.LCOMPRADO,f.LMANUF,f.LVENDA,f.LREVENDA,f.LCONSUMO,f.LPROD,f.LIMPROD,f.LPROPRIA,f.LTERC
            order by f.sDescricao,a.tIn0;

;
*/

/*
              and cast(a.tIn0  as date) >= '2019-01-01'
              and (f.LACABADO  = 1 and f.LCOMPRADO = 1) -- 719529
--            and (f.LACABADO  = 1 and f.LMANUF    = 1) -- 1387249
--            and f.LACABADO   = 1
--            and f.LCOMPRADO  = 1
*/

--              and (a.pNFE > 0 and a.pOSa > 0 and a.pPreNF > 0) and a.nQtSdo < 0 and e.pItem   = 19286 /*saidas PA */
--                and (a.pOP  > 0 or a.pOEn > 0 )and a.nQtSdo > 0 and e.pItem   = 19286 /*entradas PA */ 

--              and (a.pOP       > 0 or a.pOEn > 0 or a.pRFis >0 )and a.nQtSdo < 0 and e.pItem   = 27317 /*saidas insumos TAMPA BAIX*/ 
--              and a.pOperest  > 0 and a.nQtSdo > 0 and e.pItem   = 27317 /*entradas transferencias/ajustes insumos TAMPA BAIX*/

--              and (a.pOP       > 0 or a.pOEn > 0 or a.pRFis >0 )and a.nQtSdo < 0 and e.pItem   = 35628 /*saidas insumos ALCOOL GEL 0A2 12X120ML 10009*/ 
--              and a.pOperest  > 0 and a.nQtSdo > 0 and e.pItem   = 35628 /*entradas transferencias/ajustes insumos 35628*/
/*
              and LACABADO  = 1
              and LCOMPRADO = 0
              and LMANUF    = 0
              and LVENDA    = 0
              and LREVENDA  = 0
              and LCONSUMO  = 0 
              and LPROD     = 0 
              and LIMPROD   = 0
              and LPROPRIA  = 0 
              and LTERC     = 0

group by  f.LACABADO,f.LCOMPRADO,f.LMANUF,f.LVENDA,f.LREVENDA,f.LCONSUMO,f.LPROD,f.LIMPROD,f.LPROPRIA,f.LTERC;


select 

*/
--            and a.pOSa      <> 0 
--            and a.pRFis     > 0 
--            and a.pPreNF    > 0 
--            and a.pNFE      > 0 
--            and a.pOperest  > 0 
--            and e.pItem   = 19286
--            and a.pPreNF  > 0

/*
group by a.pOSa    ,
         a.pOEn    ,
         a.pOP     ,
         a.pRFis   ,
         a.pPreNF  ,
         a.pNFE    ,
         a.pOperest,
substring(a.nQtSdo      from 1 for 20),
substring(f.sDescricao  from 1 for 10),
substring(a.sDescricao  from 1 for 10)
--            order by a.pPId desc
  */            
;

/*
select first 26 skip 0 
--     i.pPId,
     substring(aa.sUFis from 1 for 40) sUn1,
     substring(kk.sUFis from 1 for 50) sUn2,
     i.lMRPII  
from  EST_Depositos i   left join UFis aa on i.pUFis  = aa.pPId and aa.iVer = aa.iVAt
                        left join UFis kk on aa.pParent = kk.pPId and kk.iVer = kk.iVAt
where i.iVer  = i.iVAt
   and i.lExc  = 0  
order by coalesce(kk.sUFis,'')||coalesce(aa.sUFis,'');


*/

/*
--        select first 1000 skip 0 
          select substring(h.sSigla from 1 for 7)          sCIA,
                 substring(aa.sUFis from 1 for 20)         sUn1,
                 substring(kk.sUFis from 1 for 26)         sUn2,
                 i.lMRPII                                  lEDepMRP,  
                 substring(f.sDescricao from 1 for 20)     sItem,
                 substring(f.sCodigo from 1 for 10)        sCodigo,
                 substring(a.sDescricao from 1 for 20)     sDescMov,
                 cast(a.tIn0 as date)                      dMov,
                 substring(g.sDescricao from 1 for 10)     sInstancia,
                 substring(b.sUnidade from 1 for 8)        sUniOri,
                 substring(a.nFator from 1 for 12)         nFator,
                 substring(a.nQtSdo from 1 for 17)         nQtSdo,
                 substring(c.sUnidade from 1 for 8)        sUniSdo,
                 substring(d.sDescricao from 1 for 15)     sLote,
                 substring((e.nSdo-e.nRes) from 1 for 17)  sSdoRes,
                 substring(ee.sUnidade from 1 for 10)      sUniSdoRes

            from EST_MovSaldos    a left join LotesItens d on a.pLote=d.pPId and d.iVer=d.iVAt,
                 UnidadeMedida    b,
                 UnidadeMedida    c,
                 EST_RegDepositos e,
                 UnidadeMedida    ee,
                 Itens            f,
                 EST_Instancias   g,
                 CUP              h,
                 EST_Depositos    i left join UFis aa on i.pUFis    = aa.pPId and aa.iVer = aa.iVAt
                                    left join UFis kk on aa.pParent = kk.pPId and kk.iVer = kk.iVAt
            where a.lExc    = 0
              and a.iVer    = a.iVAt
              and a.pRegDep = e.pPId
              and e.iVer    = e.iVat
              and e.lExc    = 0
--              and e.pPId    = 57934
              and a.pOP     > 0

            --and e.pPId    = 24897
            --and a.pPreNF  > 0

              and a.pUniOri = b.pPId
              and b.iVer    = b.iVAt
              and a.pUniSdo = c.pPId
              and c.iVer    = c.iVAt
              and e.pItem   = f.pPId
              and f.iVer    = f.iVAt
              and e.pIns    = g.pPId
              and g.iVer    = g.iVAt
              and g.lRese   = 1
              and e.pItem   = 46620
              and f.pUNeg   = h.pPId
              and h.iVer    = h.iVAt
              and e.pUni    = ee.pPId
              and ee.iVer   = ee.iVat
              and e.pDep    = i.pPid
              and i.iVer    = i.iVAt
              and i.lExc    = 0
            order by a.pPId desc;
*/


/*
select first 100 skip 0 
--     a.pOP,
--     a.pPreNF,
--     a.pPId,

     substring(h.sSigla from 1 for 7) sCIA,
     substring(aa.sUFis from 1 for 20) sUn1,
     substring(kk.sUFis from 1 for 26) sUn2,
     i.lMRPII,  
     substring(f.sDescricao from 1 for 20) sItem,
     substring(f.sCodigo from 1 for 10) sCodigo,
--   f.pPId,

     cast(a.tIn0 as date) dMov,

     substring((e.nSdo-e.nRes) from 1 for 17) SdoRes,
     substring(ee.sUnidade from 1 for 10) sUniSdoRes,

     substring(a.sDescricao from 1 for 20),
     substring(g.sDescricao from 1 for 10) sIns,
     substring(b.sUnidade from 1 for 8) sUniOri,
     substring(a.nFator from 1 for 12) nFator,
     substring(a.nQtSdo from 1 for 17) nQtSdo,

     substring(c.sUnidade from 1 for 8) sUniSdo,
     substring(d.sDescricao from 1 for 15) sLote

from EST_MovSaldos    a left join LotesItens d on a.pLote=d.pPId and d.iVer=d.iVAt,
     UnidadeMedida    b,
     UnidadeMedida    c,
     EST_RegDepositos e,
     UnidadeMedida    ee,
     Itens            f,
     EST_Instancias   g,
     CUP              h,
     EST_Depositos    i left join UFis aa on i.pUFis    = aa.pPId and aa.iVer = aa.iVAt
                        left join UFis kk on aa.pParent = kk.pPId and kk.iVer = kk.iVAt

where a.lExc    = 0
  and a.iVer    = a.iVAt

  and a.pRegDep = e.pPId
  and e.iVer    = e.iVat
  and e.lExc    = 0
  and e.pPId    = 57934
  and a.pOP     > 0

--and e.pPId    = 24897
--and a.pPreNF  > 0

  and a.pUniOri = b.pPId
  and b.iVer    = b.iVAt
  and a.pUniSdo = c.pPId
  and c.iVer    = c.iVAt

  and e.pItem   = f.pPId
  and f.iVer    = f.iVAt

  and e.pIns    = g.pPId
  and g.iVer    = g.iVAt

  and f.pUNeg   = h.pPId
  and h.iVer    = h.iVAt
 
  and e.pUni    = ee.pPId
  and ee.iVer   = ee.iVat

  and e.pDep    = i.pPid
  and i.iVer    = i.iVAt
  and i.lExc    = 0
order by a.pPId desc;
*/

/*
select first 26 skip 0 
--     i.pPId,
     substring(aa.sUFis from 1 for 40) sUn1,
     substring(kk.sUFis from 1 for 50) sUn2,
     i.lMRPII  
from  EST_Depositos i   left join UFis aa on i.pUFis  = aa.pPId and aa.iVer = aa.iVAt
                        left join UFis kk on aa.pParent = kk.pPId and kk.iVer = kk.iVAt
where i.iVer  = i.iVAt
   and i.lExc  = 0  
order by coalesce(kk.sUFis,'')||coalesce(aa.sUFis,'');
*/

/*
select first 100 skip 0 
     a.pPId,
     a.pLote,
     a.tIn0,
     a.sDescricao,
     a.nQtOri,
     a.jTipo,
     b.sUnidade sUniOri,
     a.nFator,
     a.nQtSdo,
     c.sUnidade sUniSdo,
     d.sDescricao sLote,
     a.sObs  
from EST_MovSaldos a left join LotesItens d on a.pLote=d.pPId and d.iVer=d.iVAt,
     UnidadeMedida b,
     UnidadeMedida c
where a.lExc = 0
  and a.iVer = a.iVAt
--and a.pRegDep = 24897 
  and a.pRegDep = 57934 
  and a.pUniOri = b.pPId
  and b.iVer = b.iVAt
  and a.pUniSdo = c.pPId
  and c.iVer = c.iVAt
order by a.pPId desc;

select first 100 skip 0 
       a.pPId,
       a.pItem,
       b.sCodigo,
       b.sDescricao sItem,
       c.sDescricao sIns,
       e.sSigla sCIA,
       d.sUnidade,
       a.nQtMin,
       a.nQtMax,
       a.nNivel,
       a.nSdo,
       a.nRes,
       a.pDep 
from EST_RegDepositos a,
     Itens b,
     CUP e,
     EST_Instancias c,
     UnidadeMedida d
--where a.pDep  = 21 
  where a.pDep = 30 
    and a.lExc  = 0
    and a.iVer  = a.iVAt

    and a.pItem = b.pPId 
    and b.iVer  = b.iVAt

    and a.pIns  = c.pPId
    and c.iVer  = c.iVAt
    and a.pUni  = d.pPId
    and d.iVer  = d.iVAt
    and b.pUNeg = e.pPId
    and e.iVer  = e.iVAt
  --and b.pPId  = 19286 
    and b.pPId  = 46620 
order by b.sCodigo,b.sDescricao,c.sDescricao,e.sCoringa;
*/

/*
                 PPID                 PLOTE                      TIN0 SDESCRICAO                                                                                                          NQTORI        JTIPO SUNIORI              NFATOR                NQTSDO SUNISDO    SLOTE     SOBS   
===================== ===================== ========================= ========================================================================== =========================================================================================
             12876950                287379 2019-05-21 21:22:44.3580  Ordem 347550, PreNF 354873, NFe 175754                               -25.000000000            0 Caixa              1.000000         -25.000000000 Caixa      19/131    <null> 
             12876460                287379 2019-05-21 19:49:38.4070  Ordem 347484, PreNF 354813, NFe 175739                                -5.000000000            0 Caixa              1.000000          -5.000000000 Caixa      19/131    <null> 
             12876366                289681 2019-05-21 19:13:41.5710  Ordem de Simples Transferencia [56907] - linha ID [207109]           385.000000000            0 Caixa              1.000000         385.000000000 Caixa      19/141    <null> 
             12876360                289681 2019-05-21 19:13:14.5150  Ordem de Simples Transferencia [56904] - linha ID [207096]            55.000000000            0 Caixa              1.000000          55.000000000 Caixa      19/141    <null> 
             12875637                287379 2019-05-21 18:08:52.3600  Transferencia Automtica do Processo de Retorno Saldos [124239]       48.000000000            0 Caixa              1.000000          48.000000000 Caixa      19/131    <null> 
             12875230                287379 2019-05-21 18:08:05.5990  Transferencia Automtica Processo de Reserva [124239]                -49.000000000            0 Caixa              1.000000         -49.000000000 Caixa      19/131    <null> 
             12873767                287379 2019-05-21 17:39:25.8590  Ordem 347619, PreNF 354797, NFe 175734                                -5.000000000            0 Caixa              1.000000          -5.000000000 Caixa      19/131    <null> 
             12851811                287379 2019-05-21 09:13:43.6040  Ordem 347482, PreNF 354479, NFe 175677                               -20.000000000            0 Caixa              1.000000         -20.000000000 Caixa      19/131    <null> 
             12851714                287379 2019-05-21 08:55:15.6050  Ordem 347535, PreNF 354790, NFe 175675                               -20.000000000            0 Caixa              1.000000         -20.000000000 Caixa      19/131    <null> 
             12851693                287379 2019-05-21 08:55:09.7080  Ordem 347548, PreNF 354743, NFe 175673                               -20.000000000            0 Caixa              1.000000         -20.000000000 Caixa      19/131    <null> 
             12851585                287379 2019-05-21 08:39:33.6810  Ordem 347595, PreNF 354828, NFe 175671                               -20.000000000            0 Caixa              1.000000         -20.000000000 Caixa      19/131    <null> 
             12846926                287379 2019-05-21 03:39:43.7750  Ordem 347496, PreNF 354487, NFe 175655                               -20.000000000            0 Caixa              1.000000         -20.000000000 Caixa      19/131    <null> 
             12846812                287379 2019-05-21 03:29:51.3760  Ordem 347520, PreNF 354470, NFe 175654                               -10.000000000            0 Caixa              1.000000         -10.000000000 Caixa      19/131    <null> 


                 PPID                 PITEM SCODIGO              SITEM                                                                                                                                                                                                    SINS                                               SCIA       SUNIDADE                                                                                                            NQTMIN                NQTMAX                NNIVEL                  NSDO                  NRES                  PDEP 
===================== ===================== ==================== =============================================================================== ================================================== ========== =============================================================================== ===================== ===================== ===================== ===================== ===================== ===================== 
                32941                 19286 1000                 AGUA SANIT DACLOR 12X1 LT                                                                                                                                                                                Devoluo                                          TQ         Caixa                                                                                                          0.000000000           0.000000000           0.000000000           0.000000000           0.000000000                    21 
                24897                 19286 1000                 AGUA SANIT DACLOR 12X1 LT                                                                                                                                                                                Disponvel                                         TQ         Caixa                                                                                                          0.000000000           0.000000000           0.000000000        7600.000000000        2020.000000000                    21 
                28844                 19286 1000                 AGUA SANIT DACLOR 12X1 LT                                                                                                                                                                                Inspeo                                           TQ         Caixa                                                                                                          0.000000000           0.000000000           0.000000000           0.000000000           0.000000000                    21 
                69550                 19286 1000                 AGUA SANIT DACLOR 12X1 LT                                                                                                                                                                                Recebimento                                        TQ         Caixa                                                                                                          0.000000000           0.000000000           0.000000000           0.000000000           0.000000000                    21 
                29212                 19286 1000                 AGUA SANIT DACLOR 12X1 LT                                                                                                                                                                                Rejeito                                            TQ         Caixa                                                                                                          0.000000000           0.000000000           0.000000000           0.000000000           0.000000000                    21 
                26271                 19286 1000                 AGUA SANIT DACLOR 12X1 LT                                                                                                                                                                                Trnsito                                           TQ         Caixa                                                                                                          0.000000000           0.000000000           0.000000000           0.000000000           0.000000000                    21 


*/

/*
select a.pPId,
          a.tIN0,
          a.nSdo,
          a.nRes
     from EST_RegDepSdo  a
    where a.lExc  = 0
      and a.iVer = a.iVAt
      and a.pRegDep  = {ChaveAtual_1}
   order by a.tIN0 desc

   select a.pPId,
          a.tIN0,
          a.nSdo,
          a.nRes
     from EST_LotesSdo  a
    where a.lExc  = 0
      and a.iVer = a.iVAt
      and a.pLote   = {ChaveAtual_1}
      and a.pRegDep = {ChaveAtual_2}
   order by a.tIN0 desc

   select a.pPId,
          a.tIn0,
          a.sDescricao,
          a.nQtOri,
          a.jTipo,
          b.sUnidade sUniOri,
          a.nFator,
          a.nQtSdo,
          c.sUnidade sUniSdo,
          a.sObs

   from EST_MovSaldos   a,
        UnidadeMedida   b,
        UnidadeMedida   c
   where a.lExc = 0              and a.iVer  = a.iVAt
     and a.pUniOri = b.pPId      and b.iVer  = b.iVAt
     and a.pUniSdo = c.pPId      and c.iVer  = c.iVAt
     and a.pRegDep = {ChaveAtual_2}
     and a.pLote   = {ChaveAtual_1}
//     and a.nQtSdo > 0

*/










/*
select tPCDCDD,PPID
from CISP_LINHA
                  where iVer=iVat and lExc = 0
                    and pCISP  = 0;
                    and substring(sPCCCLI from 1 for 8) = '06051297';
*/

/*
select a.tEmissao         	 tEmissao,
                          substring(c.sCNPJ from 1 for 8)  sCNPJSac,
                          a.tVenc            	 tVcmto,
                          a.tCISP_Pgmto          tPgmto,
                          (case when (a.tCISP_Pgmto is null) then cast('today' as date) else cast(a.tCISP_Pgmto as date) end)-(case when (cast(a.tVenc as date)<'1970-01-01') then cast(a.tEmissao as date) else cast(a.tVenc  as date) end) i1DCB,
                          (case when (cast(a.tVenc as date)<'1970-01-01') then 0 else (cast(a.tVenc  as date)-cast(a.tEmissao as date))  end ) i2DCB,
                        --a.nVenc   vVcmto,
                          a.nBruto  vVcmto,
                          a.nPgmto  vPgmto,
                          a.pPId,
                          a.tIn0,
                          d.nTot_VNF,
                          a.pNFe,
                          c.sCNPJ,
                          a.nBruto,
                          a.lExc,
                          e.lExc,
                          a.tCanc,
                          e.tCanc
                        from FIN_Titulos a 
                                         --join CUP         b on a.pCedente  = b.pPId and b.iVer = b.iVAt 
                                           join CUP         c on a.pSacado   = c.pPId and c.iVer = c.iVAt
                                           join NFcapa      d on a.pNFe      = d.pPId and d.iVer = d.iVAt
                                           join PreNF       e on d.pPreNF    = e.pPId and e.iVer = e.iVAt
                              
                   where a.iVer = a.iVAt
                      and a.pCedente in (3050,5,9,10,3046)
                      and a.lPrevisao = 0
                      and a.jTipo     = 0
                      and a.nBruto>0
                      and a.pCapa     = 0
                      and c.sCNPJ<>'' 
                      and substring(c.sCNPJ from 1 for 14) = c.sCNPJ
                      and substring(c.sCNPJ from 1 for 8)<>'00000000'
                    --and a.tCanc    is null
                    --and e.tCanc    is null
                    --and a.nVenc>0
                    --and a.lExc      = 0
                    --and cast(a.tIn0  as date) >= '2017-08-07' and cast(a.tIn0  as date) <= '2018-08-03'
                    and substring(c.sCNPJ from 1 for 8) = '00541297'
                    --and substring(c.sCNPJ from 1 for  14)='06057223029900'
                   order by substring(c.sCNPJ from 1 for 8), cast(a.tVenc as date);
*/


/*
SET STAT;
SET PLAN ON;

select a.tEmissao         	 tEmissao,
                          substring(c.sCNPJ from 1 for 8)  sCNPJSac,
                          a.tVenc            	 tVcmto,
                          a.tCISP_Pgmto          tPgmto,
                          (case when (a.tCISP_Pgmto is null) then cast('today' as date) else cast(a.tCISP_Pgmto as date) end)-(case when (cast(a.tVenc as date)<'1970-01-01') then cast(a.tEmissao as date) else cast(a.tVenc  as date) end) i1DCB,
                          (case when (cast(a.tVenc as date)<'1970-01-01') then 0 else (cast(a.tVenc  as date)-cast(a.tEmissao as date))  end ) i2DCB,
                        --a.nVenc   vVcmto,
                          a.nBruto  vVcmto,
                          a.nPgmto  vPgmto,
                          a.pPId,
                          a.tIn0,
                          d.nTot_VNF,
                          a.pNFe,
                          c.sCNPJ,
                          a.nBruto,
                          a.lExc,
                          e.lExc,
                          a.tCanc tCancA,
                          e.tCanc tCancE
                        from FIN_Titulos a 
                                         --join CUP         b on a.pCedente  = b.pPId and b.iVer = b.iVAt 
                                           join CUP         c on a.pSacado   = c.pPId and c.iVer = c.iVAt and c.sCNPJ<>'' and substring(c.sCNPJ from 1 for 14) = c.sCNPJ
                                           join NFcapa      d on a.pNFe      = d.pPId and d.iVer = d.iVAt
                                           join PreNF       e on d.pPreNF    = e.pPId and e.iVer = e.iVAt
                              
                      where a.iVer = a.iVAt
                        and a.pCedente in (3050,5,9,10,3046)
                        and a.lPrevisao = 0
                        and a.jTipo     = 0
                        and a.nBruto>0
                        and a.pCapa     = 0
                      --and a.tCanc    is null
                      --and e.tCanc    is null
                      --and a.nVenc>0
                      --and a.lExc      = 0
--                        and cast(a.tIn0  as date) >= '$tDe' and cast(a.tIn0  as date) <= '$tAte'
--                        and substring(c.sCNPJ from 1 for 8) = '06057223'
--                        and substring(c.sCNPJ from 1 for  14)='06057223029900'
       order by substring(c.sCNPJ from 1 for 8), cast(a.tVenc as date)
;
*/

/*
select substring(b.sCNPJ from 1 for 8)  sCNPJRaiz,
                 min(b.tIn0)   tCliPriCad,
                 max(a.tIn0)   tUltComp,
                 (select aa.nTot_vNF from NFCapa aa where aa.iver=aa.ivat and aa.pPid = max(a.pNFe)) nUltComp,
                 max(a.pNFe)   pUltComp,

                (select max(a2.tIn0) from NFCapa a2 where a2.iver = a2.ivat and cast(a2.tIn0 as date) < cast(max(a.tIn0) as date) and substring(a2.sDest_CNPJ from 1 for 8) = substring(b.sCNPJ from 1 for 8)  ) tPUltComp,
                (select max(a2.pPId) from NFCapa a2 where a2.iver = a2.ivat and cast(a2.tIn0 as date) < cast(max(a.tIn0) as date) and substring(a2.sDest_CNPJ from 1 for 8) = substring(b.sCNPJ from 1 for 8)  ) pPUltComp,
                (select a3.nTot_vNF from NFCapa a3 where a3.iver=a3.ivat and a3.pPid = 
                 (
--                  select max(a4.pPId) from NFCapa a4 where a4.iver = a4.ivat and a4.pPid < max(a.pNFe)
                (select max(a2.pPId) from NFCapa a2 where a2.iver = a2.ivat and cast(a2.tIn0 as date) < cast(max(a.tIn0) as date) and substring(a2.sDest_CNPJ from 1 for 8) = substring(b.sCNPJ from 1 for 8)  ) 
                  )
                 ) nPUltComp,

                 sum(case when (a.tPgmto is null) then a.nBruto else 0 end) nDebAtual,
                 sum(case when (a.tPgmto is null and a.tVenc >= cast('today' as date)) then a.nBruto else 0 end) nDebAtualAVenc,
                 sum(case when (a.tPgmto is null and (cast('today' as date)-cast(a.tVenc as date))>=5)  then a.nBruto else 0 end) nDebAtualVenc5,
                 sum(case when (a.tPgmto is null and (cast('today' as date)-cast(a.tVenc as date))>=15) then a.nBruto else 0 end) nDebAtualVenc15,
                 sum(case when (a.tPgmto is null and (cast('today' as date)-cast(a.tVenc as date))>=30) then a.nBruto else 0 end) nDebAtualVenc30
                
  from FIN_Titulos a,
       CUP         b
where a.iVer      = a.iVAt
  and a.pSacado   = b.pPId and b.iVer = b.iVAt
  and a.pCedente in (3050,5,9,10,3046)
  and a.lPrevisao = 0
  and a.jTipo     = 0
  and a.pNFe      > 0
  and b.sCNPJ    <> ''
  and a.nBruto    >0
  and substring(b.sCNPJ from 1 for 14) = b.sCNPJ
--  and substring(b.sCNPJ from 1 for 8) = '06057223'
--  and substring(b.sCNPJ from 1 for 14) = '06057223003510'
--  and cast(a.tIn0  as date) >= '2017-07-26' and cast(a.tIn0  as date) <= '2018-07-22'
group by substring(b.sCNPJ from 1 for 8);
*/

--select first 20 coalesce(tCanc,'now'),tCanc,'now' from FIN_Titulos where iver=ivat and tCanc is not null;
--select sCNPJ,TIN0,PPID from CUP where substring(sCNPJ from 1 for 8) = '06057223' and iver=ivat order by TIN0;
--select pPId,nTot_vNF,tIN0 from PreNF where iver=ivat and pDest =2012 order by tIN0;

/*
select a.pPId,a.tEmissao         	 tEmissao,
                          substring(c.sCNPJ from 1 for 8)  sCNPJSac,
                          a.tVenc            	 tVcmto,
                          a.tCISP_Pgmto          tPgmto,
                          (case when (a.tCISP_Pgmto is null) then cast('today' as date) else cast(a.tCISP_Pgmto as date) end)-(case when (cast(a.tVenc as date)<'1970-01-01') then cast(a.tEmissao as date) else cast(a.tVenc  as date) end) i1DCB,
                          (case when (cast(a.tVenc as date)<'1970-01-01') then 0 else (cast(a.tVenc  as date)-cast(a.tEmissao as date))  end ) i2DCB,
                        --a.nVenc   vVcmto,
                          a.nBruto  vVcmto,
                          a.nPgmto  vPgmto,
                          a.pPId,
                          a.tIn0,
                          d.nTot_VNF,
                          a.pNFe,
                          c.sCNPJ,
                          a.nBruto
                          
                        from FIN_Titulos a, 
                             CUP         b, 
                             CUP         c,
                             NFcapa      d,
                             PreNF       e
                              
                      where a.iVer      = a.iVAt
                        and a.pCedente in (3050,5,9,10,3046)
                        and a.pNFe   = d.pPId and d.iVer=d.iVAt 
                        and d.pPreNF = e.pPId and e.iVer=e.iVAt 
                      --and a.tCanc is null
                      --  and e.tCanc is null
                        and a.lPrevisao = 0
                        and a.jTipo     = 0
         
                      --and cast(a.tVenc as date) >= '2017-07-26' and cast(a.tVenc as date) <= '2018-07-22'
                        and cast(a.tIn0  as date) >= '2017-07-26' and cast(a.tIn0  as date) <= '2018-07-22'
                        and c.sCNPJ <> '' 
                      --and a.nVenc>0
                        and a.nBruto>0
                        and a.pCapa    = 0
                        and a.pCedente = b.pPId and b.iVer = b.iVAt
                        and a.pSacado  = c.pPId and c.iVer = c.iVAt
                      --and a.lExc     = 0
                        and c.sCNPJ<>'' and substring(c.sCNPJ from 1 for 14) = c.sCNPJ
                        and substring(c.sCNPJ from 1 for 8) = '06057223'
--                        and substring(c.sCNPJ from 1 for  14)='06057223029900'
         order by a.pPId,substring(c.sCNPJ from 1 for 8), cast(a.tVenc as date);
*/