  /////////////////////////
 // FUNCOES DO CONTRATO //
/////////////////////////

//FlagShip ovl_ctr.prg -oovl_ctr.x -lrddib -Mmain

*******************
FUNCTION main(sCia)
*******************

FS_SET("escdelay",3)
set decimals to 6
set date to british

do case
   case sCia = "totalquimica"
      rdd_connect("192.168.1.110:/qtux/database/cias/producao/ibtotal.gdb","sysdba","masterkey")
   case sCia = "santarita"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBSRita/ibtotal.gdb","sysdba","masterkey")
   case sCia = "sanpet"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBSanpet/ibtotal.gdb","sysdba","masterkey")
   case sCia = "sancare"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBSancare/ibsancare.gdb","sysdba","masterkey")
   case sCia = "log"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBLog/iblog.gdb","sysdba","masterkey")
   case sCia = "cdi"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBCDI/ibcdi.gdb","sysdba","masterkey")
   case sCia = "rio"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBRio/ibrio.gdb","sysdba","masterkey")
   case sCia = "arte"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBArte/ibarte.gdb","sysdba","masterkey")
   case sCia = "tgel"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBTGel/ibtgel.gdb","sysdba","masterkey")
   case sCia = "sd"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBSD/ibsd.gdb","sysdba","masterkey")
endcase


//rdd_connect("192.168.1.110:/qtux/database/cias/producao/ibtotal.gdb","sysdba","masterkey") 
Variaveis()
Pilhas()
sLog  = "### PROCESSO CONTRATOS DA CIA EM QUESTAO EM:"+UsData2(date()+1461)+time()+chr(10)
sLog += "### CIA:"+upper(alltrim(sCia))+chr(10)

fLog  = "/qtux/logs/jobs/contratos.log"


m->Hoje = date()+1461

fCTR(.f.,0) 

flBAS_GravaLog(fLog,sLog)
RETURN(.t.)

FUNCTION flBAS_GravaLog(psFile,psMsg)
/////////////////////////////////////
local iFile
if file(psFile)
   while .t.
      iFile=fopen(psFile,2)
      if iFile>=0
         fseek(iFile,0,2)
         exit
      endif
   end
else
   iFile=fcreate(psFile,666)
endif
fwrite(iFile,psMsg+chr(10))
fclose(iFile)
RETURN(.t.)

************************
FUNCTION fCTR(p0,pChave)
************************
// Execucao em processo noturno atraves da cron.						*
//
// 	p0 = .t.- assume parametros default
// 	d1	- data inicial
// 	d2	- data final
//
// Range / Carga default de valores para procesamento
//
// (Re)processa debitos/creditos das RN AF Auto (Proc1)
//		debitos  -> NF
//              creditos -> NF Canc
//
// (Re)processa creditos das RN ABCDEFGH Manual	
// 		das contas a receber 		(Proc2)
// 		das contas a pagar   		(Proc3)
// 		das devolucoes A/F (auto) 

local uai       := .t.
local d1        := ctod("  /  /  ")
local d2        := ctod("  /  /  ")
local x1        := .t.




// 1 Qry Traduzida
aArray := rdd_select("select D1,D2 from " + SetTabela("tctr000"))
if empty(len(aArray))
   uai := .f.
   if !p0
      //Tat("Nao consta em parametros a data para execucao...",.t.)
   endif
else
   d1 = ctod(BrData(aArray[1]))
   d2 = ctod(BrData(aArray[2]))
endif

if uai .and. x1; uai = fCTRProc1(d1,d2,p0,pChave); endif	// AF Auto Debito/Credito-canc	-  Tested
if uai .and. x1; uai = fCTRProc2(d1,d2,p0,pChave); endif	// ABCDEFGH Man do CR
if uai .and. x1; uai = fCTRProc3(d1,d2,p0,pChave); endif	// ABCDEFGH Man do CP
if uai .and. x1; uai = fCTRProc4(d1,d2,p0,pChave); endif	//  
if uai .and. x1; uai = fCTRProc5(d1,d2,p0,pChave); endif	// 
if uai .and. x1; uai = fCTRProc6(d1,d2,p0,pChave); endif	// Distribui valores pontuais nas NF's

fSQLCommit(uai,.f.,.f.)
fLOGCRON("ovl_ctr.x",m->Hoje,Time(),m->Hoje,Time(),uai)

RETURN(.t.)

***********************************
FUNCTION fCTRProc1(d1,d2,p0,pChave) // Processo que calcula CTR das NFs auto A/F
***********************************
//
// Range / Carga default de valores para procesamento
//
// (Re)processa debitos das regras A/F:
//
// Processar todos os debitos provenientes de regras de negocio automaticas do tipo A/F.
// Processar todos os creditos provenientes de regras de negocio automaticas do tipo A/F das NF CANCELADAS.
// Execucao em processo noturno atraves da cron.						*
// pChave = COD_CTR1
//
if !p0
   //mens(maxrow()-1,maxrow(),"Processo 1/4 - (Re)processando debitos do tipo A/F automatico... ")
endif
sLog += "### START FASE (1):"+time()+chr(10)
local i
local uai       	:= .t.
local aArray    	:= {}
local cSql      	:= ""
local nCOD_CTR1		:= 0
local nCOD_CTR11	:= 0
local nCOD_NF		:= 0
local nNUM_NF           := 0
local dDATA		:= ctod("  /  /  ")
local dCANC		:= ctod("  /  /  ")
local dDTBASE		:= ctod("  /  /  ")
local nCANC		:= .f.
local nTIPO_REGRA	:= 0
local nTIPO_EXEC	:= 0
local nTIPO_BASE	:= 0
local nPORC_A		:= 0
local nPORC_F		:= 0
local nSDOTRAN		:= 0
local xTVLCNF		:= 0
local xVLC402		:= 0.00
local xTVLBC		:= 0.00
local xVLBC		:= 0.00

// * Processar debitos provenientes de RN automaticas do tipo A/F

if uai		// Excluir movimentos do tipo (A/F) automatico
// 2 Qry Traduzida
   cSql = " select RECNO from " + SetTabela("tctr012")
   cSql += " where DATA >= '"+UsData2(d1)+"' and DATA <= '"+UsData2(d2)+"' "
   if pChave > 0
      cSql += " and COD_CTR1 = "+str(pChave)
   endif
   cSql += "   and TIPO_REGRA in (1,6) and ORIGEM in (2,6) " 
   aArray = rdd_cursor(cSql)
   for i=1 to len(aArray)
// 3 Qry Traduzida
      uai = rdd_delete("delete from "+SetTabela("tctr012")+" where RECNO="+str(aArray[i]))
      if uai
         uai = rdd_delete("delete from "+SetTabela("tctr015")+" where COD_CTR12="+str(aArray[i]))
      endif
      if !uai 
         exit
      endif
   next
endif

// Loop nos contratos em vigencia

// 4 Qry Traduzida
cSql  = " select NUMERO,DESCRICAO,V_D1,V_D2,ABRAN,TIPO_DBASE,lItem,RECNO "
cSql += " from " + SetTabela("tctr001")	// Capa do Contrato
//cSql += " where V_D1 <= '"+UsData2(d1)+"'"
//cSql += "   and V_D2 >= '"+UsData2(d2)+"'"
if pChave > 0
   cSql += " where RECNO="+str(pChave)
endif
AbreRS(cSql,"ctr001")
if ctr001->(eof()) .and. !p0
   //mens(maxrow()-1,maxrow(),"Nada ha relacionar (debitos A/F,canc A/F-cont)...")
endif
while !ctr001->(eof()) .and. uai

   // Query Principal
   cSql  = " select b.CODIGO RNCOD			      ,"
   cSql += "	    b.DESCRICAO RNDESC			      ,"
   cSql += "	    b.TIPO_REGRA			      ,"
   cSql += "	    b.TIPO_EXEC				      ,"
   cSql += "	    b.TIPO_COBR				      ,"
   cSql += "	    b.TIPO_CALC				      ,"
   cSql += "	    b.TIPO_BASE				      ,"
   cSql += "	    b.PORC				PORC_A,"
   cSql += "        b.RECNO                           COD_CR11," // RN
   cSql += "	    c.COD_CLI				      ," // CLIENTE ?
   cSql += "	    c.PORC				PORC_F,"
   cSql += "	    c.LT				      ,"
   cSql += "        g.D_EMISSAO                               ,"
   cSql += "        g.DTTRABAIXA                              ,"
   cSql += "        g.CANC                                    ,"
   cSql += "        g.DT_CANC				      ,"
   cSql += "        g.NUM_NF                                  ,"
   cSql += "        g.RECNO                             COD_NF," // NF
   cSql += "        h.COD_PRO              		      ,"
   cSql += "        h.RECNO                            COD_NFV," // PRODUTO NA 402
   cSql += "        sum(((h.QT*h.PRU-h.ICMVALOR)+h.RFICMVALOR)-h.DESCESP) VEXI,"  // sum ex-impostos  (Compos da Base / Tipo de Calculo)
   cSql += "        sum(((h.QT*h.PRU)+RFICMVALOR)-h.DESCESP) VICM,"  // sum c/icms
   cSql += "        sum(((h.QT*h.PRU+h.IPIVALOR)+h.RFICMVALOR)-h.DESCESP) VIPI,"  // sum c/icms+ipi
   cSql += "        avg(((h.QT*h.PRU-h.ICMVALOR)+h.RFICMVALOR)-h.DESCESP)	  MEXI,"  // med ex-impostos
   cSql += "        avg(((h.QT*h.PRU)+h.RFICMVALOR)-h.DESCESP) 		  MICM,"  // med c/icms
   cSql += "        avg(((h.QT*h.PRU+h.IPIVALOR)+RFICMVALOR)-h.DESCESP) 	  MIPI,"  // med c/icms+ipi	--> local imposto unico
   cSql += "        g.RECNO                           	       " 
   cSql += " from " + SetTabela("tctr011") + " b,"	// RN 
   cSql +=            SetTabela("tctr111") + " c,"	// Clientes p/ Contrato
   if ctr001->lItem
      cSql +=            SetTabela("tctr112") + " d,"	// Produtos p/ Contrato
   endif
   cSql +=            SetTabela("tsls019") + " e,"	// Clientes
   cSql +=            SetTabela("titm002") + " f,"	// Itens 
   cSql +=            SetTabela("tsls401") + " g,"	// Capa NF
   cSql +=            SetTabela("tsls402") + " h,"	// Linha NF
   cSql +=            SetTabela("tsls056") + " i "      // Tipo de Ordem
   cSql += " where b.INATIVO     = 0                  "
   cSql += "   and b.TIPO_REGRA  in (1,6) 	      "		// RN tipo (A/F) auto
   cSql += "   and b.TIPO_EXEC   = 1                  "		// Somente as Automaticas
   cSql += "   and b.COD_CTR1    = " + str(ctr001->(RECNO()))
   cSql += "   and c.COD_CTR1    = b.COD_CTR1         "
   if ctr001->lItem
      cSql += "   and d.COD_CTR1    = b.COD_CTR1         "
      cSql += "   and d.COD_PRO     = f.RECNO            "		// Filtro Produto
   endif
   cSql += "   and c.COD_CLI     = e.RECNO            "		// Filtro Cliente
   cSql += "   and h.COD_NF      = g.RECNO            "
   cSql += "   and g.COD_CLI     = e.RECNO            "
   cSql += "   and h.COD_PRO     = f.RECNO            "
   cSql += "   and i.RECNO       = g.COD_TOV          "
   cSql += "   and g.E_ENTRADA   = 0                  "  
   cSql += "   and i.E_BONIFICA  = 0                  "
   cSql += "   and i.E_DEVOLUCA  = 0                  "
   cSql += "   and i.E_TRANREM   = 0                  "
   cSql += "   and i.GERA_CPCR   = 1                  "
   cSql += " and ((g.D_EMISSAO >='"+UsData2(d1)+"' and g.D_EMISSAO  <='"+UsData2(d2)+"' and " 
   cSql += "       g.D_EMISSAO >='"+UsData2(ctr001->V_D1)+"' and g.D_EMISSAO  <='"+UsData2(ctr001->V_D2)+"') or "
   cSql += "      (g.DT_CANC   >='"+UsData2(d1)+"' and g.DT_CANC    <='"+UsData2(d2)+"' and "
   cSql += "       g.DT_CANC   >='"+UsData2(ctr001->V_D1)+"' and g.DT_CANC    <='"+UsData2(ctr001->V_D2)+"')) "
   cSql += " group by b.CODIGO,b.DESCRICAO,b.TIPO_REGRA,b.TIPO_EXEC,b.TIPO_COBR,b.TIPO_CALC,b.TIPO_BASE,b.PORC,b.RECNO,c.COD_CLI,c.PORC,c.LT,g.D_EMISSAO,g.DTTRABAIXA,g.CANC,g.DT_CANC,g.NUM_NF,g.RECNO,h.COD_PRO,h.RECNO "
   cSql += "  order by g.RECNO,b.RECNO "
   AbreRS(cSql,"tmp")
//   sLog += "### Qry (1):"+cSql+" / "+if(uai,"OK","NOK")+chr(10)
   nCOD_NF = tmp->COD_NF
   if tmp->(eof()) .and. !p0
      //mens(maxrow()-1,maxrow(),"Nada ha relacionar (debitos A/F,canc A/F-nf)...")
   endif
   while !tmp->(eof()) .and. uai
      // Saldo em Transito - DTTRABAIXA is null
      // debito    = previsto
      // credito   = realizado

      // ICM/ICMS+IPI/ExImpostos
      do case; case tmp->TIPO_BASE=1; do case; case tmp->TIPO_REGRA=1 
                                                  xTVLCNF += (tmp->VICM*tmp->PORC_A)/100   //(A)/(F)
                                                  xVLC402  = (tmp->VICM*tmp->PORC_A)/100   //(A)/(F) 
                                               case tmp->TIPO_REGRA=6
                                                  xTVLCNF += (tmp->VICM*tmp->PORC_F)/100
                                                  xVLC402  = (tmp->VICM*tmp->PORC_F)/100; endcase 
               case tmp->TIPO_BASE=2; do case; case tmp->TIPO_REGRA=1
                                                  xTVLCNF += (tmp->VIPI*tmp->PORC_A)/100   //(A)/(F)
                                                  xVLC402  = (tmp->VIPI*tmp->PORC_A)/100   //(A)/(F)
                                               case tmp->TIPO_REGRA=6
                                                  xTVLCNF += (tmp->VIPI*tmp->PORC_F)/100
                                                  xVLC402  = (tmp->VIPI*tmp->PORC_F)/100; endcase
               case tmp->TIPO_BASE=3; do case; case tmp->TIPO_REGRA=1
                                                  xTVLCNF += (tmp->VEXI*tmp->PORC_A)/100   //(A)/(F)
                                                  xVLC402  = (tmp->VEXI*tmp->PORC_A)/100   //(A)/(F)
                                               case tmp->TIPO_REGRA=6
                                                  xTVLCNF += (tmp->VEXI*tmp->PORC_F)/100
                                                  xVLC402  = (tmp->VEXI*tmp->PORC_F)/100; endcase
        // case tmp->TIPOBASE=4	// Imposto Unico
      endcase

      do case; case tmp->TIPO_BASE=1; xTVLBC += tmp->VICM; xVLBC = tmp->VICM			// c/ ICMS
               case tmp->TIPO_BASE=2; xTVLBC += tmp->VIPI; xVLBC = tmp->VIPI			// c/ ICMS+IPI
               case tmp->TIPO_BASE=3; xTVLBC += tmp->VEXI; xVLBC = tmp->VEXI			// s/ ICMS s/ IPI
      endcase

      if tmp->D_EMISSAO >= d1 .and. tmp->D_EMISSAO <= d2
         cSql  = "insert into "+SetTabela("tctr015")+" (COD_402,COD_CTR11,COD_NF,VALOR,BC,ORIGEM) values ("
         cSql += str(tmp->COD_NFV)		+ ","
         cSql += str(tmp->COD_CR11)        	+ ","
         cSql += str(tmp->COD_NF)		+ ","
         cSql += str(xVLC402,15,5)		+ ","
         cSql += str(xVLBC,15,5)		+ ",2)"
         uai = rdd_insert(cSql)
      endif

      if tmp->CANC .and. tmp->DT_CANC >= d1 .and. tmp->DT_CANC <= d2
         cSql  = "insert into "+SetTabela("tctr015")+" (COD_402,COD_CTR11,COD_NF,VALOR,BC,ORIGEM) values ("
         cSql += str(tmp->COD_NFV)		+ ","
         cSql += str(tmp->COD_CR11)      	+ ","
         cSql += str(tmp->COD_NF)		+ ","
         cSql += str(xVLC402,15,5)		+ ","
         cSql += str(xVLBC,15,5)		+ ",6)"
         uai = rdd_insert(cSql)
      endif

      xVLBC   = 0
      xVLC402 = 0

      nCOD_CTR1		= ctr001->(RECNO()) 
      nCOD_CTR11	= tmp->COD_CR11 
      nCOD_NF		= tmp->COD_NF		// Chave do Processo
      nNUM_NF           = tmp->NUM_NF
      dDATA		= tmp->D_EMISSAO
      do case; case ctr001->TIPO_DBASE=1; dDTBASE = tmp->D_EMISSAO   	// Data Base  =	(1) Emissao NF
               case ctr001->TIPO_DBASE=2; dDTBASE = tmp->DTTRABAIXA	// 		(2) Entrega
      endcase
      nCANC		= tmp->CANC
      dCANC		= tmp->DT_CANC
      nTIPO_REGRA	= tmp->TIPO_REGRA 
      nTIPO_EXEC	= tmp->TIPO_EXEC
      nTIPO_BASE	= tmp->TIPO_BASE 
      if tmp->TIPO_REGRA=1
         nPORC_A	= tmp->PORC_A 
         nPORC_F        = 0 
      endif
      if tmp->TIPO_REGRA=6
         nPORC_A	= 0 
         nPORC_F	= tmp->PORC_F
      endif
      nSDOTRAN		= if(empty(tmp->DTTRABAIXA),1,0)	// Saldo em Transito

      tmp->(dbskip())

      if (dDATA >= d1 .and. dDATA <= d2) .and. (tmp->(EOF()) .or. (tmp->COD_NF <> nCOD_NF .or. tmp->COD_CR11 <> nCOD_CTR11)) .and. uai
         uai = fCTRIncCC(nCOD_CTR1,nCOD_CTR11,nCOD_NF,0,0,dDATA,dDTBASE,0,xTVLCNF,2,nTIPO_REGRA,nTIPO_EXEC,nTIPO_BASE,nPORC_A,nPORC_F,xTVLBC,nSDOTRAN,0,0,0,0,0,0,0,str(nNUM_NF))
         if uai
            aArray  = rdd_cursor("select max(RECNO) from "+SetTabela("tctr012")+" where COD_NF= "+str(nCOD_NF)+" and ORIGEM=2")
            cSql    = "update "+SetTabela("tctr015")+" set COD_CTR12="+str(aArray[1])+" where COD_CTR12=0 and ORIGEM=2 and COD_NF="+str(nCOD_NF)
            uai     = rdd_update(cSql)
         endif
      endif

      // NF Cancelada (Credito no C/C)
      if (nCANC .and. dCANC >= d1 .and. dCANC <= d2) .and. (tmp->(EOF()) .or. (tmp->COD_NF <> nCOD_NF .or. tmp->COD_CR11 <> nCOD_CTR11)) .and. uai
         uai = fCTRIncCC(nCOD_CTR1,nCOD_CTR11,nCOD_NF,0,0,dCANC,dDTBASE,xTVLCNF,0,6,nTIPO_REGRA,nTIPO_EXEC,nTIPO_BASE,nPORC_A,nPORC_F,xTVLBC,nSDOTRAN,0,0,0,0,0,0,0,str(nNUM_NF))
         if uai
            aArray = rdd_cursor("select max(RECNO) from "+SetTabela("tctr012")+" where COD_NF= "+str(nCOD_NF)+" and ORIGEM=6")
            cSql   = "update "+SetTabela("tctr015")+" set COD_CTR12="+str(aArray[1])+" where COD_CTR12=0 and ORIGEM=6 and COD_NF="+str(nCOD_NF)
            uai    = rdd_update(cSql)
         endif
      endif
      if ((nCANC .and. dCANC >= d1 .and. dCANC <= d2) .or. (dDATA >= d1 .and. dDATA <= d2)) .and. (tmp->(EOF()) .or. (tmp->COD_NF <> nCOD_NF .or. tmp->COD_CR11 <> nCOD_CTR11)) .and. uai
         xTVLCNF   = 0
         xTVLBC    = 0
      endif
   end
   FechaRS("tmp")
   ctr001->(dbskip())
end
FechaRS("ctr001")
sLog += "### END FASE (1):"+time()+" / "+if(uai,"OK","NOK")+chr(10)
RETURN(uai)

***********************************
FUNCTION fCTRProc2(d1,d2,p0,pChave)	// Creditos do Contas a Receber
***********************************
sLog += "### START FASE (2):"+time()+chr(10)

// 	dData1	- data inicial	fct fCTRd1ad2()
// 	dData2	- data final	fct fCTRd1ad2()
//
// Range / Carga default de valores para procesamento
//
// (Re)processa Creditos provenientes:	
// 	p1	- das CONTAS A RECEBER		(default) --> 	.t.		
if !p0
   //mens(maxrow()-1,maxrow(),"Processo 2/4 - (Re)processando creditos CR do tipo A-I ... ")
endif
local uai := .t.
// Excluir movimentos com Origem Credito e Cobranca lancado no CC automaticamente
cSql  = " delete from "+SetTabela("tctr012")
//cSql += " where ((DTBASE >= '"+UsData2(d1)+"' and DTBASE <= '"+UsData2(d2)+"') or DTBASE is null) "
cSql += " where DATA >= '"+UsData2(d1)+"' and DATA <= '"+UsData2(d2)+"' "
cSql += "   and ORIGEM = 3 " 
if pChave > 0
   cSql += " and COD_CTR1="+str(pChave)
endif
uai = rdd_delete(cSql)
if uai 
   cSql  = " select a.COD_CTR1,a.COD_CTR11,b.DOC,b.DP,a.COD_CR,a.VALOR,c.TIPO_REGRA,c.TIPO_EXEC,c.TIPO_BASE,RECNO from "
   cSql += SetTabela("tctr002") + " a,"
   cSql += SetTabela("tfin020") + " b,"
   cSql += SetTabela("tctr011") + " c "
   cSql += " where  b.RECNO  = a.COD_CR    "
   cSql += "   and  a.COD_CR > 0           "
   cSql += "   and  c.RECNO  = a.COD_CTR11 "
   cSql += "   and  b.DP >= '"+UsData2(d1)+"'"
   cSql += "   and  b.DP <= '"+UsData2(d2)+"'"
   if pChave > 0
      cSql += " and c.COD_CTR1="+str(pChave)
   endif
//   sLog += "### Qry (2):"+cSql+" / "+if(uai,"OK","NOK")+chr(10)
   AbreRS(cSql,"tmp")
   if tmp->(eof()) .and. !p0
      //mens(maxrow()-1,maxrow(),"Nada ha relacionar (creditos A-I CR)...")
   endif
   while !tmp->(eof()) .and. uai
      uai = fCTRIncCC(tmp->COD_CTR1,tmp->COD_CTR11,0,tmp->COD_CR,0,tmp->DP,tmp->DP,tmp->VALOR,0,3,tmp->TIPO_REGRA,tmp->TIPO_EXEC,tmp->TIPO_BASE,0,0,0,0,0,0,0,0,0,0,0,tmp->DOC)
      tmp->(dbskip())
   end
   FechaRS("tmp")
endif
sLog += "### END FASE (2):"+time()+" / "+if(uai,"OK","NOK")+chr(10)
RETURN(uai)

***********************************
FUNCTION fCTRProc3(d1,d2,p0,pChave)	// Creditos do Contas a Pagar
***********************************
sLog += "### START FASE (3):"+time()+chr(10)

// 	dData1	- data inicial	fct fCTRd1ad2()
// 	dData2	- data final	fct fCTRd1ad2()
//
// Range / Carga default de valores para procesamento
//
// (Re)processa Creditos provenientes:	
// 	p2	- das contas a pagar				.t.
if !p0
   //mens(maxrow()-1,maxrow(),"Processo 3/4 - (Re)processando creditos CP do tipo A-I ... ")
endif
local uai := .t.
// Excluir movimentos com Origem Contas a Pagar lancado no CC automaticamente
cSql  = " delete from "+SetTabela("tctr012")
//cSql += " where ((DTBASE >= '"+UsData2(d1)+"' and DTBASE <= '"+UsData2(d2)+"') or DTBASE is null) "
cSql += " where DATA >= '"+UsData2(d1)+"' and DATA <= '"+UsData2(d2)+"' "
cSql += "   and ORIGEM = 4 " 
if pChave > 0
   cSql += " and COD_CTR1="+str(pChave)
endif
uai = rdd_delete(cSql)
if  uai
   cSql  = " select a.COD_CTR1,a.COD_CTR11,b.DP,b.DOC,a.COD_CP,a.VALOR,c.TIPO_REGRA,c.TIPO_EXEC,c.TIPO_BASE,c.RECNO from "
   cSql += SetTabela("tctr002") + " a,"
   cSql += SetTabela("tfin030") + " b,"
   cSql += SetTabela("tctr011") + " c "
   cSql += " where  b.RECNO  = a.COD_CP    "
   cSql += "   and  a.COD_CP > 0           "
   cSql += "   and  c.RECNO  = a.COD_CTR11 "
   cSql += "   and  b.DP >= '"+UsData2(d1)+"'"
   cSql += "   and  b.DP <= '"+UsData2(d2)+"'"
   if pChave > 0
      cSql += " and c.COD_CTR1="+str(pChave)
   endif
   AbreRS(cSql,"tmp")
//   sLog += "### Qry (3):"+cSql+" / "+if(uai,"OK","NOK")+chr(10)
   if tmp->(eof()) .and. !p0
      //mens(maxrow()-1,maxrow(),"Nada ha relacionar (creditos A-I CP)...")
   endif
   while !tmp->(eof()) .and. uai
      uai = fCTRIncCC(tmp->COD_CTR1,tmp->COD_CTR11,0,0,tmp->COD_CP,tmp->DP,tmp->DP,tmp->VALOR,0,4,tmp->TIPO_REGRA,tmp->TIPO_EXEC,tmp->TIPO_BASE,0,0,0,0,0,0,0,0,0,0,0,tmp->DOC)
      tmp->(dbskip())
   end
   FechaRS("tmp")
endif
sLog += "### END FASE (3):"+time()+" / "+if(uai,"OK","NOK")+chr(10)
RETURN(uai)

***********************************
FUNCTION fCTRProc4(d1,d2,p0,pChave)  // Processo que calcula CTR para NF Devolucao
***********************************
sLog += "### START FASE (4):"+time()+chr(10)

// Range / Carga default de valores para procesamento
//
// (Re)processa debitos das regras A/F:
//
// Processar todos os debitos provenientes de regras de negocio automaticas do tipo A/F.
// Processar todos os creditos provenientes de regras de negocio automaticas do tipo A/F das NF CANCELADAS.
// Execucao em processo noturno atraves da cron.						*

if !p0
   //mens(maxrow()-1,maxrow(),"Processo 4/4 - (Re)processando creditos de devolucoes do TP A/F ... ")
endif

local i
local uai       	:= .t.
local aArray    	:= {}
local cSql      	:= ""
local nCOD_CTR1		:= 0
local nCOD_CTR11	:= 0
local nCOD_NF		:= 0
local nNUM_NF           := 0
local dDATA		:= ctod("  /  /  ")
local dDTBASE		:= ctod("  /  /  ") 
local nTIPO_REGRA	:= 0
local nTIPO_EXEC	:= 0
local nTIPO_BASE	:= 0
local nPORC_A		:= 0
local nPORC_F		:= 0
local xTVLCNF		:= 0
local xVLC404		:= 0
local xTVLBC		:= 0
local xVLBC		:= 0

// * Processar debitos provenientes de RN automaticas do tipo A/F

if uai		// Excluir movimentos do tipo (A/F) automatico
   cSql = " select RECNO from " + SetTabela("tctr012")
//   cSql += " where ((DTBASE >= '"+UsData2(d1)+"' and DTBASE <= '"+UsData2(d2)+"') or DTBASE is null) "
   cSql += " where DATA >= '"+UsData2(d1)+"' and DATA <= '"+UsData2(d2)+"' "
   cSql += "   and TIPO_REGRA in (1,6) and ORIGEM = 5 " 
   if pChave > 0
     cSql += " and COD_CTR1="+str(pChave)
   endif
   aArray = rdd_cursor(cSql)
   for i=1 to len(aArray)
      uai = rdd_delete("delete from "+SetTabela("tctr012")+" where RECNO="+str(aArray[i]))
      if uai
         uai = rdd_delete("delete from "+SetTabela("tctr015")+" where COD_CTR12="+str(aArray[i]))
      endif
      if !uai 
         exit
      endif
   next
endif

// Loop nos contratos em vigencia

cSql  = " select NUMERO,DESCRICAO,V_D1,V_D2,ABRAN,TIPO_DBASE,lItem,RECNO "
cSql += " from " + SetTabela("tctr001")	// Capa do Contrato
//cSql += " where V_D1 <= '"+UsData2(d1)+"'"
//cSql += "   and V_D2 >= '"+UsData2(d2)+"'"
if pChave > 0
   cSql += " where RECNO="+str(pChave)
endif
AbreRS(cSql,"ctr001")
if ctr001->(eof()) .and. !p0
   //mens(maxrow()-1,maxrow(),"Nada ha relacionar (devolucoes A/F-cont)...")
endif
while !ctr001->(eof()) .and. uai

   // Query Principal
   
   cSql  = " select b.CODIGO RNCOD			      ,"
   cSql += "	    b.DESCRICAO RNDESC			      ,"
   cSql += "	    b.TIPO_REGRA			      ,"
   cSql += "	    b.TIPO_EXEC				      ,"
   cSql += "	    b.TIPO_COBR				      ,"
   cSql += "	    b.TIPO_CALC				      ,"
   cSql += "	    b.TIPO_BASE				      ,"
   cSql += "	    b.PORC				PORC_A," 
   cSql += "        b.RECNO                           COD_CR11," // RN
   cSql += "	    c.COD_CLI				      ," // CLIENTE ?
   cSql += "	    c.PORC				PORC_F,"
   cSql += "	    c.LT				      ,"
   cSql += "        g.D_EMISSAO                               ,"
   cSql += "        g.D_INPUT                                 ,"
   cSql += "        g.NUM_NF                                  ,"
   cSql += "        g.RECNO                             COD_NF," // NF
   cSql += "        h.COD_PRO              		      ,"
   cSql += "        h.RECNO                            COD_NFV," // PRODUTO NA 404
//   cSql += "        sum(h.QT*h.PRU/(1+h.ALI_ICM/100))  	  VEXI,"  // sum ex-impostos  (Compos da Base / Tipo de Calculo)
//   cSql += "        sum(h.QT*h.PRU) 		       	  VICM,"  // sum c/icms
//   cSql += "        sum(h.QT*h.PRU*(1+h.ALI_IPI/100))  	  VIPI,"  // sum c/icms+ipi
//   cSql += "        avg(h.QT*h.PRU/(1+h.ALI_ICM/100))  	  MEXI,"  // med ex-impostos
//   cSql += "        avg(h.QT*h.PRU) 		     	  MICM,"  // med c/icms
//   cSql += "        avg(h.QT*h.PRU*(1+h.ALI_IPI/100)) 	  MIPI,"  // med c/icms+ipi	--> local imposto unico
   cSql += "        sum(h.QT*h.PRU-h.VAL_ICM)	  	  VEXI,"  // sum ex-impostos  (Compos da Base / Tipo de Calculo)
   cSql += "        sum(h.QT*h.PRU) 		       	  VICM,"  // sum c/icms
   cSql += "        sum(h.QT*h.PRU+h.VAL_IPI)  		  VIPI,"  // sum c/icms+ipi
   cSql += "        avg(h.QT*h.PRU-h.VAL_ICM)	  	  MEXI,"  // med ex-impostos
   cSql += "        avg(h.QT*h.PRU) 		     	  MICM,"  // med c/icms
   cSql += "        avg(h.QT*h.PRU+h.VAL_IPI) 		  MIPI,"  // med c/icms+ipi	--> local imposto unico
   cSql += "        g.RECNO                           	       " 
   cSql += " from " + SetTabela("tctr011") + " b,"	// RN 
   cSql +=            SetTabela("tctr111") + " c,"	// Clientes p/ Contrato
   if lItem
      cSql +=            SetTabela("tctr112") + " d,"	// Produtos p/ Contrato
   endif
   cSql +=            SetTabela("tsls019") + " e,"	// Clientes
   cSql +=            SetTabela("titm002") + " f,"	// Itens 
   cSql +=            SetTabela("tsls403") + " g,"	// Capa NF
   cSql +=            SetTabela("tsls404") + " h "	// Linha NF
   cSql += " where b.INATIVO     = 0                  "
   cSql += "   and b.TIPO_REGRA  in (1,6) 	      "		// RN tipo (A/F) auto
   cSql += "   and b.TIPO_EXEC   = 1                  "		// Somente as Automaticas
   cSql += "   and b.COD_CTR1    = " + str(ctr001->(RECNO()))
   cSql += "   and c.COD_CTR1    = b.COD_CTR1         "
   if lItem
      cSql += "   and d.COD_CTR1    = b.COD_CTR1         "
      cSql += "   and d.COD_PRO     = f.RECNO            "		// Filtro Produto
   endif
   cSql += "   and c.COD_CLI     = e.RECNO            "		// Filtro Cliente
   cSql += "   and h.COD_NFD     = g.RECNO            "
   cSql += "   and g.COD_CLI     = e.RECNO            "
   cSql += "   and h.COD_PRO     = f.RECNO            "
//   cSql += "   and g.FECHADO     = 1                  "
   cSql += "   and g.D_INPUT >='"+UsData2(d1)+"' and g.D_INPUT  <='"+UsData2(d2)+"' "
   cSql += "   and g.D_INPUT >='"+UsData2(ctr001->V_D1)+"' and g.D_INPUT  <='"+UsData2(ctr001->V_D2)+"' "

   cSql += " group by b.CODIGO,b.DESCRICAO,b.TIPO_REGRA,b.TIPO_EXEC,b.TIPO_COBR,b.TIPO_CALC,b.TIPO_BASE,b.PORC,b.RECNO,c.COD_CLI,c.PORC,c.LT,g.D_EMISSAO,g.D_INPUT,g.NUM_NF,g.RECNO,h.COD_PRO,h.RECNO,g.RECNO"
   cSql += "  order by g.RECNO,b.RECNO "
//   sLog += "### Qry (4):"+cSql+" / "+if(uai,"OK","NOK")+chr(10)
   AbreRS(cSql,"tmp")
   nCOD_NF = tmp->(RECNO())
   if tmp->(eof()) .and. !p0
      //mens(maxrow()-1,maxrow(),"Nada ha relacionar (devolucoes A/F-nf)...")
   endif
   while !tmp->(eof()) .and. uai
      // debito    = previsto
      // credito   = realizado

      // ICM/ICMS+IPI/ExImpostos
      do case; case tmp->TIPO_BASE=1; do case; case tmp->TIPO_REGRA=1 
                                                  xTVLCNF += (tmp->VICM*tmp->PORC_A)/100   //(A)/(F)
                                                  xVLC404  = (tmp->VICM*tmp->PORC_A)/100   //(A)/(F) 
                                               case tmp->TIPO_REGRA=6
                                                  xTVLCNF += (tmp->VICM*tmp->PORC_F)/100
                                                  xVLC404  = (tmp->VICM*tmp->PORC_F)/100; endcase 
               case tmp->TIPO_BASE=2; do case; case tmp->TIPO_REGRA=1
                                                  xTVLCNF += (tmp->VIPI*tmp->PORC_A)/100   //(A)/(F)
                                                  xVLC404  = (tmp->VIPI*tmp->PORC_A)/100   //(A)/(F)
                                               case tmp->TIPO_REGRA=6
                                                  xTVLCNF += (tmp->VIPI*tmp->PORC_F)/100
                                                  xVLC404  = (tmp->VIPI*tmp->PORC_F)/100; endcase
               case tmp->TIPO_BASE=3; do case; case tmp->TIPO_REGRA=1
                                                  xTVLCNF += (tmp->VEXI*tmp->PORC_A)/100   //(A)/(F)
                                                  xVLC404  = (tmp->VEXI*tmp->PORC_A)/100   //(A)/(F)
                                               case tmp->TIPO_REGRA=6
                                                  xTVLCNF += (tmp->VEXI*tmp->PORC_F)/100
                                                  xVLC404  = (tmp->VEXI*tmp->PORC_F)/100; endcase
        // case tmp->TIPOBASE=4	// Imposto Unico

/*

  1 * 1,85 =  1,85 / 100 = 0,0185 * 1 = 0,0185
 10 * 0,75 =  7,50 / 100 = 0,0750 * 1 = 0,0750 0.07500
 15 * 0,75 = 11,25 / 100 = 0,1125 * 1 = 0,1125 0.11250
  3 * 2,38 =  7,14 / 100 = 0,0714 * 1 = 0,0714 
 14 * 0,75 = 10,50 / 100 = 0,1050 * 1 = 0,1050 0.10500
 19 * 0,75 = 14,25 / 100 = 0,1425 * 1 = 0,1425 0.14250
  2 * 1,00 =  2,00 / 100 = 0,0200 * 1 = 0,0200 0.02000
  1 * 1,00 =  1,00 / 100 = 0,0100 * 1 = 0,0100 0.01000
  4 * 2,07 =  8,28 / 100 = 0,0828 * 1 = 0,0828 0.08280
 11 * 2,31 = 25,41 / 100 = 0,2541 * 1 = 0,2541 0.25410
                                      + 0,8918
             89,18 
*/

      endcase

      do case; case tmp->TIPO_BASE=1; xTVLBC += tmp->VICM; xVLBC = tmp->VICM			// c/ ICMS
               case tmp->TIPO_BASE=2; xTVLBC += tmp->VIPI; xVLBC = tmp->VIPI			// c/ ICMS+IPI
               case tmp->TIPO_BASE=3; xTVLBC += tmp->VEXI; xVLBC = tmp->VEXI			// s/ ICMS s/ IPI
      endcase

      cSql  = "insert into "+SetTabela("tctr015")+" (COD_404,COD_CTR11,COD_403,VALOR,BC,ORIGEM) values ("
      cSql += str(tmp->COD_NFV)		+ ","
      cSql += str(tmp->COD_CR11)        + ","
      cSql += str(tmp->(RECNO()))	+ ","
      cSql += str(xVLC404,15,5)		+ ","
      cSql += str(xVLBC,15,5)		+ ",5)"
      uai = rdd_insert(cSql)

      
//      if tmp->COD_CR11 = 54 .and. tmp->NUM_NF = 94390
//          Alert(str(tmp->VIPI)+"*"+str(tmp->PORC_A)+"="+str(tmp->VIPI*tmp->PORC_A)+"/100="+str(xTVLCNF))
//      endif


      xVLBC   = 0
      xVLC404 = 0
      nNUM_NF           = tmp->NUM_NF
      nCOD_CTR1		= ctr001->(RECNO()) 
      nCOD_CTR11	= tmp->COD_CR11 
      nCOD_NF		= tmp->(RECNO())	// Chave do Processo
      dDATA		= tmp->D_INPUT
      dDTBASE           = tmp->D_EMISSAO   	// Data Base  =	(1) Emissao NF
      nTIPO_REGRA	= tmp->TIPO_REGRA 
      nTIPO_EXEC	= tmp->TIPO_EXEC
      nTIPO_BASE	= tmp->TIPO_BASE 
      if tmp->TIPO_REGRA=1
         nPORC_A	= tmp->PORC_A 
         nPORC_F        = 0 
      endif
      if tmp->TIPO_REGRA=6
         nPORC_A	= 0 
         nPORC_F	= tmp->PORC_F
      endif

      tmp->(dbskip())

      if (tmp->(EOF()) .or. (tmp->(RECNO()) <> nCOD_NF .or. tmp->COD_CR11 <> nCOD_CTR11)) .and. uai
         uai = fCTRIncCC(nCOD_CTR1,nCOD_CTR11,0,0,0,dDATA,dDTBASE,xTVLCNF,0,5,nTIPO_REGRA,nTIPO_EXEC,nTIPO_BASE,nPORC_A,nPORC_F,xTVLBC,0,nCOD_NF,0,0,0,0,0,0,str(nNUM_NF))
         if uai
            aArray = rdd_cursor("select max(RECNO) from "+SetTabela("tctr012")+" where COD_403= "+str(nCOD_NF))
            cSql="update "+SetTabela("tctr015")+" set COD_CTR12="+str(aArray[1])+" where COD_CTR12=0 and COD_403="+str(nCOD_NF)
            uai = rdd_update(cSql)
         endif
         xTVLCNF 	= 0
         xTVLBC  	= 0
      endif
    
   end
   FechaRS("tmp")
   ctr001->(dbskip())
end
FechaRS("ctr001")
sLog += "### END FASE (4):"+time()+" / "+if(uai,"OK","NOK")+chr(10)
RETURN(uai)

***********************************
FUNCTION fCTRProc5(d1,d2,p0,pChave)	// Processo que distribui nos itens valores auto de contrato.
***********************************
sLog += "### START FASE (5):"+time()+chr(10)

local nCOD_NF := 0
local nVlCTR  := 0
local uai     := .t.
cSql  = " select b.COD_NF,b.RECNO "
cSql += " from "+SetTabela("tsls401")+" a,"
cSql +=          SetTabela("tsls402")+" b "
cSql += " where b.COD_NF = a.RECNO "
cSql += "   and (b.VLCTR <> 0 or a.VLCTR <> 0 or b.VLCTRMAN <> 0)"
cSql += "   and a.D_EMISSAO >= '"+UsData2(d1)+"'"
cSql += "   and a.D_EMISSAO <= '"+UsData2(d2)+"'"
//   sLog += "### Qry (5):"+cSql+" / "+if(uai,"OK","NOK")+chr(10)
AbreRS(cSql,"tmp")
while !tmp->(EOF()) .and. uai
   nCOD_NF = tmp->COD_NF
   uai = rdd_update("update "+SetTabela("tsls402")+" set VLCTR=0 where RECNO="+str(tmp->(RECNO())))
   tmp->(dbskip())
   if nCOD_NF <> tmp->COD_NF .or. tmp->(eof()) .and. uai
      uai=rdd_update("update "+SetTabela("tsls401")+" set VLCTR=0 where RECNO="+str(nCOD_NF))
   endif
end
FechaRS("tmp")
nCod_NF = 0

cSql  = " select b.COD_NF,a.COD_402,sum(a.VALOR) VL,sum(a.VALOR) XXX "
cSql += " from "+SetTabela("tctr015")+" a,"
cSql +=          SetTabela("tctr012")+" b "
cSql += " where a.COD_CTR12 = b.RECNO "
cSql += "   and b.ORIGEM    = 2       "		// Automatico A/F e Cancelamento
cSql += "   and b.COD_NF    > 0       "
cSql += "   and b.DATA      >= '"+UsData2(d1)+"'"
cSql += "   and b.DATA      <= '"+UsData2(d2)+"'"
cSql += " group by b.COD_NF,a.COD_402 "
cSql += " order by b.COD_NF,a.COD_402 "
AbreRS(cSql,"tmp")
//   sLog += "### Qry (6):"+cSql+" / "+if(uai,"OK","NOK")+chr(10)
while !tmp->(eof()) .and. uai
   uai=rdd_update("update "+SetTabela("tsls402")+" set VLCTR="+str(tmp->VL)+" where RECNO="+str(tmp->COD_402))
   nCOD_NF  = tmp->COD_NF
   nVlCTR  += tmp->VL
   tmp->(dbskip())
   if nCOD_NF <> tmp->COD_NF .or. tmp->(eof()) .and. uai
      uai=rdd_update("update "+SetTabela("tsls401")+" set VLCTR="+str(nVlCTR)+" where RECNO="+str(nCOD_NF))
      nVlCTR = 0
   endif
   
end
FechaRS("tmp")

nVlCTR  = 0
nCOD_NF = 0

cSql  = " select COD_403,COD_404,sum(VALOR) VL,sum(VALOR) XXX "
cSql += " from "+SetTabela("tctr015")
cSql += " where ORIGEM    = 5  "		// Devolucoes 
cSql += "   and COD_403   > 0  "
cSql += " group by COD_403,COD_404 "
cSql += " order by COD_403,COD_404 "
//sLog += "### Qry (7):"+cSql+" / "+if(uai,"OK","NOK")+chr(10)
AbreRS(cSql,"tmp")
while !tmp->(eof()) .and. uai
   uai=rdd_update("update "+SetTabela("tsls404")+" set VLCTR="+str(tmp->VL)+" where RECNO="+str(tmp->COD_404))
   nCOD_NF  = tmp->COD_403
   nVlCTR  += tmp->VL
   tmp->(dbskip())
   if nCOD_NF <> tmp->COD_403 .or. tmp->(eof()) .and. uai
      uai=rdd_update("update "+SetTabela("tsls403")+" set VLCTR="+str(nVlCTR)+" where RECNO="+str(nCOD_NF))
      nVlCTR = 0
   endif
end
FechaRS("tmp")
fSQLCommit(uai,.f.,.f.)
sLog += "### END FASE (5):"+time()+" / "+if(uai,"OK","NOK")+chr(10)
RETURN(.t.)

///////////////////////////////////
FUNCTION fCTRProc6(d1,d2,p0,pChave)	// Processo que distribui nos itens os manuais de contrato.
///////////////////////////////////
sLog += "### START FASE (6):"+time()+chr(10)

// a) selecionar os contratos em vigencia
// b) selecionar sumarizando (qt*preco unitrio), somente as nfs nao canceladas, do periodo (dt emissao), com itens/clientes constantes no contrato em questo.
// c) selecionar sumarizando (so debitos pontuais) (Checar se atual regra esta abatendo devolucoes e cancelamentos.)
//
// 1-Manual A-I         (Debito)  * prc6
// 2-Automatico A/F     (Debito)  * prc1
// 3-Credito & Cobranca (Credito) * no soma, crditos de pgmtos via desconto em duplicata.
// 4-Contas a Pagar     (Credito) * no soma, crditos de pgmtos via ttulos recebidos.
// 5-Devolucao      	(Credito) *
// 6-Cancelamento       (Credito) * pcr1 (verificar se est tratando)
//* Para Bater a inquirio com contratos utilizar o relatrio Semi-Sinttico III utilizando a coluna dbito-cancelados. 

// pChave = COD_CTR1
//
if !p0
   //mens(maxrow()-1,maxrow(),"Processo 6/6 - Distribuindo valores manuais entre as NF's ponderado por qt*pru...")
endif
local uai       	:= .t.
local cSql      	:= ""
local iTVlDist  := 0
local iTVlMerc  := 0
local iIndice   := 0
local iVlCtrMan := 0

// Loop nos contratos em vigencia
cSql  = " select NUMERO,DESCRICAO,V_D1,V_D2,ABRAN,TIPO_DBASE,RECNO "
cSql += " from " + SetTabela("tctr001")					// Capa do Contrato
if pChave > 0
   cSql += " where RECNO="+str(pChave)
endif
AbreRS(cSql,"ctr001")
if ctr001->(eof()) .and. !p0
   //mens(maxrow()-1,maxrow(),"nenhum contrato relacionado... proc 06/06")
endif
while !ctr001->(eof()) .and. uai
   // seleciona o valor a ser distribuido (lancamentos manuais/pontuais).
   iTVlDist = 0
   iTVlMerc = 0
   iIndice  = 0
   iVlCtrMan= 0
   cSql  = " select sum(DEBITO-CREDITO) "
   cSql += " from "+SetTabela("tctr012")
   cSql += " where COD_CTR1  = "+str(ctr001->(RECNO()))
   cSql += "   and ORIGEM    in (1,5) "
   cSql += "   and DATA      >= '"+UsData2(d1)+"'"
   cSql += "   and DATA      <= '"+UsData2(d2)+"'"
//   sLog += "### Qry (8):"+cSql+" / "+if(uai,"OK","NOK")+chr(10)
   aArray = rdd_select(cSql)
   if !empty(aArray[1])
      iTVlDist = aArray[1]
      cSql  = " select sum(b.QT*b.PRU) "
      cSql += " from "+  SetTabela("tsls401") + " a,"	// Capa NF
      cSql +=            SetTabela("tsls402") + " b,"	// Linha NF
      cSql +=            SetTabela("tctr111") + " c,"	// Clientes p/ Contrato
      cSql +=            SetTabela("tctr112") + " d,"	// Produtos p/ Contrato
      cSql +=            SetTabela("tsls056") + " e "   // Tipo de Ordem
      cSql += " where b.COD_NF       =  a.RECNO 			"
      cSql += "   and a.COD_CLI      =  c.COD_CLI 		"
      cSql += "   and c.COD_CTR1     =  "+str(ctr001->(RECNO()))
      cSql += "   and b.COD_PRO      =  d.COD_PRO 		"
      cSql += "   and d.COD_CTR1     =  "+str(ctr001->(RECNO()))
      cSql += "   and a.COD_TOV      =  e.RECNO  			"
      cSql += "   and a.E_ENTRADA    =  0                  	"
      cSql += "   and e.E_BONIFICA   =  0                  	"
      cSql += "   and e.E_DEVOLUCA   =  0                  	"
      cSql += "   and e.E_TRANREM    =  0                  	"
      cSql += "   and e.GERA_CPCR    =  1                  	"
      cSql += "   and (a.D_EMISSAO >= '"+UsData2(d1)		+"'"
      cSql += "   and  a.D_EMISSAO <= '"+UsData2(d2)		+"'"
      cSql += "   and  a.D_EMISSAO >= '"+UsData2(ctr001->V_D1)	+"'"
      cSql += "   and  a.D_EMISSAO <= '"+UsData2(ctr001->V_D2)	+"')"
//      sLog += "### Qry (9):"+cSql+" / "+if(uai,"OK","NOK")+chr(10)
      aArray = rdd_select(cSql)
      if !empty(aArray[1])
         iTVlMerc = aArray[1]
         iIndice = iTVlDist/iTVlMerc
         if iIndice <> 0
            cSql  = " select b.QT,b.PRU,b.RECNO "
            cSql += " from "+  SetTabela("tsls401") + " a,"	// Capa NF
            cSql +=            SetTabela("tsls402") + " b,"	// Linha NF
            cSql +=            SetTabela("tctr111") + " c,"	// Clientes p/ Contrato
            cSql +=            SetTabela("tctr112") + " d,"	// Produtos p/ Contrato
            cSql +=            SetTabela("tsls056") + " e "   	// Tipo de Ordem
            cSql += " where b.COD_NF      = a.RECNO 	"
            cSql += "   and a.COD_CLI     = c.COD_CLI 	"
            cSql += "   and c.COD_CTR1    = "+str(ctr001->(RECNO()))
            cSql += "   and b.COD_PRO     = d.COD_PRO 	"
            cSql += "   and d.COD_CTR1    = "+str(ctr001->(RECNO()))
            cSql += "   and a.COD_TOV     = e.RECNO  	"
            cSql += "   and a.E_ENTRADA   = 0              "
            cSql += "   and e.E_BONIFICA  = 0              "
            cSql += "   and e.E_DEVOLUCA  = 0              "
            cSql += "   and e.E_TRANREM   = 0              "
            cSql += "   and e.GERA_CPCR   = 1              "
            cSql += "   and (a.D_EMISSAO >= '"+UsData2(d1)			+"'"
            cSql += "   and  a.D_EMISSAO <= '"+UsData2(d2)			+"'"
            cSql += "   and  a.D_EMISSAO >= '"+UsData2(ctr001->V_D1)	+"'"
            cSql += "   and  a.D_EMISSAO <= '"+UsData2(ctr001->V_D2)	+"')"
//            sLog += "### Qry (10):"+cSql+" / "+if(uai,"OK","NOK")+chr(10)
            AbreRS(cSql,"tmp")
            while !tmp->(EOF()) .and. uai
               iVlCtrMan = (tmp->QT*tmp->PRU)*iIndice
               cSql  = " update "+SetTabela("tsls402")
               cSql += " set VLCTRMAN="+str(iVlCtrMan)
               cSql += " where RECNO="+str(tmp->(RECNO()))
//               sLog += "### Qry (11):"+cSql+" / "+if(uai,"OK","NOK")+chr(10)
               uai = rdd_update(cSql)
               if tmp->(RECNO()) = 5777144
                  sLog += "CTR:"+str(ctr001->(RECNO()))+chr(10)
               endif
               tmp->(dbskip())
            end
            FechaRS("tmp")
         endif
      endif
   endif 
   ctr001->(dbskip())
end
FechaRS("ctr001")
sLog += "### END FASE (6):"+time()+" / "+if(uai,"OK","NOK")+chr(10)
RETURN(uai)

************************************************************************************************************
FUNCTION fCTRIncCC(p1,p2,p3,p4,p5,d1,d2,p6,p7,p8,p9,p10,p11,p12,p13,p14,p15,p16,p17,p18,p19,p20,p21,p22,p23)
************************************************************************************************************
* p1    = COD_CTR1
* p2    = COD_CTR11
* p3    = COD_NF
* p4    = COD_CR
* p5    = COD_CP
* d1    = DATA
* d2    = DTBASE
* p6    = CREDITO
* p7    = DEBITO
* p8    = ORIGEM
* p9    = TIPO_REGRA
* p10   = TIPO_EXEC
* p11   = TIPO_BASE
* p12   = PORC_A
* p13   = PORC_F
* p14   = BC
* p15   = SDOTRAN
* p16   = COD_403
* p17   = COD_CTR113
* p18   = COD_CTR114
* p19   = COD_CTR115
* p20   = COD_CTR116
* p21   = COD_CTR117
* p22   = COD_CTR118
* p23   = DOC
local uai := .t.
local cSql := " insert into " + SetTabela("tctr012") + " ("
      cSql += " COD_CTR1   , "
      cSql += " COD_CTR11  , "
      cSql += " COD_NF     , "
      cSql += " COD_CR     , "
      cSql += " COD_CP     , "
      cSql += " DATA       , "
      cSql += " DTBASE     , "
      cSql += " CREDITO    , "
      cSql += " DEBITO     , "
      cSql += " ORIGEM     , "
      cSql += " TIPO_REGRA , "
      cSql += " TIPO_EXEC  , "
      cSql += " TIPO_BASE  , "
      cSql += " PORC_A     , "
      cSql += " PORC_F     , "
      cSql += " BC         , "
      cSql += " SDOTRAN    , "
      cSql += " COD_403    , "
      cSql += " COD_CTR113 , "
      cSql += " COD_CTR114 , "
      cSql += " COD_CTR115 , "
      cSql += " COD_CTR116 , "
      cSql += " COD_CTR117 , "
      cSql += " COD_CTR118 , "
      cSql += " DOC        , "
      cSql += " P1         , "
      cSql += " P2         , "
      cSql += " P3         , "
      cSql += " P4         , "
      cSql += " P5         , "
      cSql += " P6         ) values ( "
      cSql += str(p1)    	+ ","
      cSql += str(p2)     	+ ","
      cSql += str(p3)     	+ ","
      cSql += str(p4)     	+ ","
      cSql += str(p5)     	+ ",'"
      cSql += UsData(d1)  	+ "',"
      cSql += if(empty(d2),"null,","'"+UsData2(d2)+"',")
      cSql += str(p6,15,5)     	+ ","
      cSql += str(p7,15,5)     	+ ","
      cSql += str(p8)     	+ ","
      cSql += str(p9)     	+ ","
      cSql += str(p10)    	+ ","
      cSql += str(p11)    	+ ","
      cSql += str(p12,15,5)    	+ ","
      cSql += str(p13,15,5)    	+ ","
      cSql += str(p14,15,5)    	+ ","
      cSql += str(p15,15,5)    	+ ","
      cSql += str(p16)    	+ ","
      cSql += str(p17)    	+ ","
      cSql += str(p18)    	+ ","
      cSql += str(p19)    	+ ","
      cSql += str(p20)    	+ ","
      cSql += str(p21)    	+ ","
      cSql += str(p22)    	+ ",'"
      cSql += alltrim(p23)	+ "',"
      cSql += if(p8=1,"1","0")  + ","
      cSql += if(p8=2,"1","0")  + ","
      cSql += if(p8=3,"1","0")  + ","
      cSql += if(p8=4,"1","0")  + ","
      cSql += if(p8=5,"1","0")  + ","
      cSql += if(p8=6,"1","0")  + ")"
uai = rdd_insert(cSql)
RETURN(uai)

*************************************************
FUNCTION fLOGCRON(cPROC,dDTI,xHRI,dDTF,xHRF,lUAI)
*************************************************
// Usar esta funcao aps o fSQLCommit do processo
local uai := rdd_insert("insert into "+SetTabela("tsis200")+" (PROCESSO,DTI,HRI,DTF,HRF,UAI) values ('"+alltrim(cPROC)+"','"+UsData(dDTI)+"','"+xHRI+"','"+UsData(dDTF)+"','"+xHRF+"',"+if(lUai,"1","0")+")")
rdd_commit()
RETURN(.t.)

**********************************************

********************
FUNCTION Variaveis()
********************
PUBLIC      p_COLOR                  :=  if( pcount() >= 1 , upper(p_COLOR) , "COLOR")
PUBLIC      rest_D                   := { | |  restscreen(0,0,maxrow(),maxcol(),D()),.f.}
PUBLIC      v_inc_box                := ""
PUBLIC      cns_cod_fir              := 2
PUBLIC      cns_menu                 := ""
PUBLIC      sns_menu                 := ""              
PUBLIC      cns_lin                  := 0               
PUBLIC      cns_alt                  := 0              
PUBLIC      mChaveAtual              := 0
PUBLIC      cns_chave                := ""              
PUBLIC      cns_c_chave              := ""              
PUBLIC      cns_len_variavel         := 30        
PUBLIC      cns_nrcp                 := 0
PUBLIC      cns_vNrCp[15]
PUBLIC      cns_LenVetor[10]
afill(cns_LenVetor,0)
PUBLIC      cns_CCSql                := ""
PUBLIC      cns_rddnrcp              := 0
PUBLIC      cns_m_nrop               := 0           
PUBLIC      cns_msg                  := ""           
PUBLIC      cns_marcacao             := .f.         
PUBLIC      cns_strmarcados[10]
PUBLIC      cns_quem                 := ""         
PUBLIC      cns_VQuem[10]
PUBLIC      cns_Col1Ordenada         := 0
PUBLIC      cns_Col2Ordenada         := 0
PUBLIC      cns_Col3Ordenada         := 0
PUBLIC      cns_rddSql               := ""
PUBLIC      cns_AtualIndice          := 0
PUBLIC      cns_rddEdicaoSql         := ""
PUBLIC      cns_Esc                  := .f.
PUBLIC      cns_Inc                  := .f.
PUBLIC      cns_IncNr0               := .f.
PUBLIC      cns_kVetor[10]
afill(cns_kVetor,0)
PUBLIC      cns_nVetor               := 33
PUBLIC      cns_BG[10]
afill(cns_BG,.f.)
PUBLIC      cns_rddindicevetor       := 1
PUBLIC      xns_rddindicevetor[10]
PUBLIC      cns_rddnr                := 0
PUBLIC      cns_order                := 0
PUBLIC      cns_old_order            := 0
PUBLIC      cns_tela                 := .f.       
PUBLIC      cns_mneumonico           := ""
PUBLIC      cns_gets                 := 0     
PUBLIC      cns_exc_at               := ""   
PUBLIC      cns_txt                  := .t. 
PUBLIC      cns_lx                   := 0
PUBLIC      cns_ly                   := 0             
PUBLIC      cns_D_X                  := 0             
PUBLIC      cns_D_Y                  := 0             
PUBLIC      cns_sub_menu             := 0             
PUBLIC      cns_sub_main             := 0             
PUBLIC      pre_tit                  := ""             
PUBLIC      pre_Nr0                  := ""            
PUBLIC      pre_MENSNr0              := ""            
PUBLIC      pre_CHEIA                := .t.
PUBLIC      cns_Tabela               := ""
PUBLIC      cns_FraseMenu            := ""
PUBLIC      cns_cCoringa             := ""
PUBLIC      cns_dCoringa             := ctod("  /  /  ")
PUBLIC      cns_iCoringa             := 0
PUBLIC      cns_TMP1
PUBLIC      cns_TMP2
PUBLIC      cns_TMP3
PUBLIC      cns_TMP4
PUBLIC      cns_TMP5
PUBLIC      cns_TMP6
PUBLIC      cns_TMP7
PUBLIC      mn                       := 1            
PUBLIC      mn_main                  := 1            
PUBLIC      main_x                   := 0            
PUBLIC      main_y                   := 0            
PUBLIC      primeiro_reg_da_pagina   := 1
PUBLIC      m_cns_t                  := 0
PUBLIC      m_linha_do_cursor        := 1
PUBLIC      m_cns_sele               :=.f.
PUBLIC      l_l                      := 0
PUBLIC      quem_chama               := ""
PUBLIC      p_quem_chama             := ""
PUBLIC      x_FIRMA                  := ""
PUBLIC      x_COD_FIR                := ""
PUBLIC      x_TEL                    := ""
PUBLIC      x_FAX                    := ""
PUBLIC      x_END                    := ""
PUBLIC      x_CIDADE                 := ""
PUBLIC      x_UF                     := ""
PUBLIC      x_IE                     := ""
PUBLIC      x_CGC                    := ""
PUBLIC      x_SEG_IMP                := .f.
PUBLIC      zoo_status               := "EA"
PUBLIC      dData1                   := date()+1461
PUBLIC      dData2                   := date()+1461
PUBLIC      w_VLR1                   := 0
PUBLIC      w_VLR2                   := 0
PUBLIC      esc_original             := ""
PUBLIC      senha_quem_e             := space(6)
PUBLIC      quem_e                   := ""
PUBLIC      cod_quem_e               := 0
PUBLIC      m_NETUNO                 := "NETUNO"
PUBLIC      _23_rodape               := ""
PUBLIC      _24_rodape               := ""
PUBLIC      cot                      := 0
PUBLIC      OldCot                   := 0
PUBLIC      CotTempoEstimado         := 0
PUBLIC      CotTempoInicial          := ""
PUBLIC      auto_sair                := .f.
PUBLIC      coluna_da_regua          := 15
PUBLIC      chamada_a_tela           := ""
PUBLIC      ZOO_ALT                  := ""
PUBLIC      ZOO_NAVEGANDO            := .f.
PUBLIC      gc                       := 0
PUBLIC      iTotalTelas              := 0
PUBLIC      iTelaAtual               := 0
PUBLIC      oiTelaAtual              := 0
PUBLIC      lConfigMenu              := .f.
PUBLIC      cDBT                     := ""
PUBLIC      d_ESP                    :=   "E s p e r e"
PUBLIC      d_IMP                    :=   "I m p r i m i n d o"
PUBLIC      d_GRA                    :=   "G r a v a n d o"
PUBLIC      m_NAO_CONTAS             :=   "Nao ha' Contas no periodo ..."
PUBLIC      m_NAO_VENDAS             :=   "Nao ha' Vendas no periodo ..."
PUBLIC      m_IMP_CANC               :=   "Impressao cancelada pelo usuario ..."
PUBLIC      d_FICHA                  := "<Enter> e <"+chr(25)+"> prox. campo, <"+chr(24)+"> anterior, <-"+chr(16)+chr(17)+"-> dentro do campo, <Esc> desiste"
PUBLIC      d_FICHAEDICAO            := "<PgUP> e <PgDn> Navega, <F3> Exclui, <F4> Altera, <Esc> Encerra"
PUBLIC      xov_ovctrl               := .f.
PUBLIC      m_COD_G_U                := 0
PUBLIC      m_COD_USU                := 0
PUBLIC      LocAconselha             := 1
PUBLIC      LocDevolucao             := 2
PUBLIC      LocInspecao              := 3
PUBLIC      LocRecebimento           := 4
PUBLIC      LocRejeito               := 5
PUBLIC      LocPerda                 := 6
PUBLIC      UA                       := ""
PUBLIC      vChaveAtual[10]
afill(vChaveAtual,0)
PUBLIC      vCns_Inc[10]
afill(vCns_Inc,.f.)
PUBLIC     cns_TabelaCopCol          := ""
PUBLIC     cns_RecnoCopCol           := 0
RETURN(0)

*****************
FUNCTION Pilhas()
*****************
PUBLIC   CNS_PILHA[240]
PUBLIC   CNS_TOPO_PILHA  := 0
PUBLIC   V_PILHA[300]
PUBLIC   TOPO_PILHA      := 0
RETURN(0)


*********************
FUNCTION SetTabela(s)
*********************
local aArray := {}
local uai    := ""
s = alltrim(s)
if !empty(at("TSYS",upper(s)))
   uai = "01"
else
   aArray      = rdd_select("select CIA,RECNO from tbas00501 where COD_FIR = " + str(cns_cod_fir) + " and TABELA = '" + alltrim(upper(s)) + "'")
   if empty(aArray)
      alert("erro do SetTabela - " + s)   
      uai = aArray[1]
   else
      uai = aArray[1]
   endif
*   last_Tabela = s
*   last_CIA    = uai
endif
RETURN(s+uai)

*************************************************
FUNCTION fSQLCommit(uai,lOkMensagem,lNokMensagem)
*************************************************
if pcount()<2
*   lOkMensagem=.t.
   lOkMensagem=.f.
endif
if pcount()<3
   lNokMensagem=.t.
endif
if uai
   rdd_commit()

   *** ATENCAO
   if lOkMensagem; Tat("Processo executado com sucesso ...",.t.); endif

else
   rdd_rollbck()
   if lNokMensagem; Tat("Problemas na execucao do processo ...",.t.); endif
endif
RETURN(.t.)

***************
*
FUNCTION D1aD2()
****************
local a
E(setcolor(cor_rodape))
@ maxrow()-1,0 clear
a = "Qual o Intervalo de Datas ?"
@ maxrow()-1,(maxcol()+1-len(a))/2 say a
dData1 = m->Hoje
dData2 = m->Hoje
@ maxrow(),28 get dData1  
@ maxrow(),43 get dData2 valid if(lastkey()=5,.t.,dData2 >= dData1 .or. !tat("Intervalo de datas invalido ..."))
a = Pega()
setcolor(D())
RETURN(a)

************************************************
FUNCTION Mens(pLinhaClear,pLinhaMens,pMens,pCor)
************************************************
E(setcolor())
if pcount() >= 4
   setcolor(pCor)
else
   setcolor(cor_rodape)
endif
@ pLinhaClear,0 clear
@ pLinhaMens ,(maxcol()+1-len(pMens))/2 say pMens
setcolor(D())
RETURN(.t.)


*******************
FUNCTION UsData(d_)
*******************
local uai
if empty(d_)
   uai = "null"
else
   uai = substr(dtos(d_),5,2) + "/" + right(dtos(d_),2) + "/" + left(dtos(d_),4)
endif   
Return(uai)

********************
FUNCTION UsData2(d_)
********************
local uai
if empty(d_)
   uai = "null"
else
   uai = alltrim(right(dtos(d_),2)) + "-" + left(upper(cmonth(d_)),3) + "-" + left(dtos(d_),4)
   if left(uai,1) = "0"
      uai = right(uai,len(uai)-1)
   endif      
endif   
Return(alltrim(uai))

****************************
FUNCTION AbreRS(pSql,pAlias)
****************************
E(select())
ResultSet(pSql,pAlias)
Return(.t.)

************************
FUNCTION FechaRS(pAlias)
************************
sele &pAlias
use
select(D())
Return(.t.)

**************************
FUNCTION tat(p_mens,p_box)
    && p_box = .t. -> centro da dela, .f. -> rodape = default
**************************
local a,i
p_box = if(pcount() <= 1,.f.,p_box)
E(setcolor(cor_rodape))
if !p_box 
   E(savescreen(maxrow()-1,0,maxrow(),maxcol()))
   Mens(maxrow()-1,maxrow(),p_MENS+" tecle alguma tecla")
   inkey(0)
   restscreen(maxrow()-1,0,maxrow(),maxcol(),D())
else
   E(savescreen(0,0,maxrow(),maxcol()))
   setcolor(cor_janela)
   @ 01,00,maxrow(),maxcol() BOX chr(176)+chr(176)+chr(176)+chr(176)+chr(176)+chr(176)+CHR(176)+CHR(176)+chr(176)
   setcolor(cor_rodape)
   i = at("^",p_mens) 
   if !empty(i)
      @ 10,5 clear to 16,74
      @ 10,5 to 16,74
      a = left(p_mens,i-1)
      @ 12,(maxcol()+1-len(a))/2 say a
      a = right(p_mens,len(p_mens)-i)
      @ 13,(maxcol()+1-len(a))/2 say a
      a = "Tecle alguma tecla para continuar"
      @ 15,(maxcol()+1-len(a))/2 say a
   else
      @ 10,5 clear to 15,74
      @ 10,5 to 15,74
      a = p_mens
      @ 12,(maxcol()+1-len(a))/2 say a
      a = "Tecle alguma tecla para continuar"
      @ 14,(maxcol()+1-len(a))/2 say a
   endif
   a = inkey(0)
   restscreen(0,0,maxrow(),maxcol(),D())
endif
keyboard chr(32)
inkey()
setcolor(D())
RETURN(.t.)

***************************
FUNCTION Truncar2D(rNumero)
***************************
local uai := 0
if rNumero > 0
   uai = round(rNumero-0.0049,2)
endif   
RETURN(uai)

*******************
**********************************************************************************
FUNCTION E(p_1COISA,p_2COISA,p_3COISA,p_4COISA,p_5COISA,p_6COISA,p_7COISA,p_8COISA,p_9COISA,p_10COISA)
*******************
**********************************************************************************
local a,i
V_PILHA[++topo_pilha] = p_1COISA
if pcount() > 1
   V_PILHA[++topo_pilha] = p_2COISA
endif
if pcount() > 2
   V_PILHA[++topo_pilha] = p_3COISA
endif
if pcount() > 3
   V_PILHA[++topo_pilha] = p_4COISA
endif
if pcount() > 4
   V_PILHA[++topo_pilha] = p_5COISA
endif
if pcount() > 5
   V_PILHA[++topo_pilha] = p_6COISA
endif
if pcount() > 6
   V_PILHA[++topo_pilha] = p_7COISA
endif
if pcount() > 7
   V_PILHA[++topo_pilha] = p_8COISA
endif
if pcount() > 8
   V_PILHA[++topo_pilha] = p_9COISA
endif
if pcount() > 9
   V_PILHA[++topo_pilha] = p_10COISA
endif
RETURN(.t.)

************
FUNCTION D
()


**********
**
RETURN(V_PILHA[topo_pilha--])

*****************
FUNCTION Pega(p_)
*****************
   p_ = if(pcount()=0,.t.,p_)
   readinsert(.f.)
*   set key 22 to InsereOnOff
   if p_
      set esca on
   endif
   set conf on
   set curs on
   read
   set esca off
   set conf off
   set curs off
   set key 22 to
RETURN(!lastkey()=27)

*******************************
FUNCTION ResultSet(pSql,pAlias)
******************
*************
local lReturn
if pcount() < 2
   pAlias = "CNS"
endif
ExecSql(pSql) Alias pAlias New Get lReturn
RETURN(.t.)

*******************
FUNCTION BrData(d_)
*******************
local uai
if empty(d_)
   uai = "  /  /  "
elseif valtype(d_) = "C"
   uai = right(d_,2) + "/" + substr(d_,6,2) + "/" + substr(d_,3,2)
else
   uai = dtoc(d_)
endif
Return(uai)

*********************
FUNCTION CURSESINIT()
*********************
RETURN

////////////////////////////////
FUNCTION GerarTXT(cString,cFile)
////////////////////////////////
if pcount() < 2; cFile="alo.alo" ; endif
memowrit(cFile,cString)
RETURN(.t.)



