/////////////////////////
// FUNCOES DA COMISSO //
/////////////////////////
//FlagShip jobComPol.prg -ojobComPol.x -lrddib -Mmain
// ABAIXO, ESTATICO.
//FlagShip jobComPol.prg -ojobComPol.x -lrddib -Mmain -DRDD -DIB

*******************
FUNCTION main(sCia,lAnt)
*******************

FS_SET("escdelay",3)
set decimals to 6
set date to british


Variaveis()
Pilhas()
m->Hoje = date()+1461

PUBLIC spCia := sCia
PUBLIC lPAnt := .f.

if pcount()>1
   lPAnt = .t.
else
   lPAnt = .f.
endif


flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log","PreConnect Processo (Modelo 2 AG)..."+UsData(m->Hoje)+"   "+time())

//rdd_connect("192.168.1.110:/qtux/database/cias/DBNFe/ibtotal.gdb","sysdba","masterkey")
//rdd_connect("192.168.1.110:/qtux/database/cias/producao/ibtotal.gdb","sysdba","masterkey") 
do case
   case sCia = "totalquimica" .or. empty(sCia)
      rdd_connect("192.168.1.110:/qtux/database/cias/producao/ibtotal.gdb","sysdba","masterkey")
   case sCia = "santarita"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBSRita/ibtotal.gdb","sysdba","masterkey")
   case sCia = "sanpet"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBSanpet/ibtotal.gdb","sysdba","masterkey")
   case sCia = "sancare"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBSancare/ibsancare.gdb","sysdba","masterkey")
   case sCia = "log"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBLog/iblog.gdb","sysdba","masterkey")
   case sCia = "cdi"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBCDI/ibcdi.gdb","sysdba","masterkey")
   case sCia = "rio"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBRio/ibrio.gdb","sysdba","masterkey")
   case sCia = "arte"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBArte/ibarte.gdb","sysdba","masterkey")
   case sCia = "tgel"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBTGel/ibtgel.gdb","sysdba","masterkey")
   case sCia = "rk"
      //rdd_connect("192.168.1.112:/qtux/database/cias/DBRK/ibrk.gdb","sysdba","200360")
      rdd_connect("192.168.1.110:/qtux/database/cias/DBRK/ibrk.gdb","sysdba","masterkey")
   case sCia = "sd"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBSD/ibsd.gdb","sysdba","masterkey")
   case sCia = "sign"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBSIgn/ibsign.gdb","sysdba","masterkey")
endcase


fProcComissao(.t.)
RELEASE spCia

RETURN(.t.)

////////////////////////////
FUNCTION fProcComissao()
////////////////////////////
// p2=.f. = Processo Manual
//
// 1) Gerao da nota fiscal (crdito)
//
// 2) Cancelamento de Notas Fiscais
//    	- (dbito) Comisso referente  NF de venda
//   	- (dbito) Abatimento Valor do Frete (quando parametrizado o motivo)
//
// 3) Notas fiscais de devoluo (dbito)
//
// 4) Lanamento Manual (dbito/crdito)
//
//
// Fazer carga na NF do desconto financeiro
// Fazer carga na NFLinha do desconto no Item

// lCompara realizado do perodo anterior com o calculado simulado por processo com poltica por MAG no mesmo perodo.
// lCompara = .t. no modifica ambiente de produo e cria ambiente igual ao da produo para comparao/relatrio
// Relatrio
// Representante / VComissaoRealizada / ValorComissaoSimuladoMAG

sRprt = ""
lCompara = .f.

//iModelo  = 1        // Determina se comissao por Lista de Precos 
  iModelo  = 2        // Determina se comissao por AG

pSls040 = 0
dData1  = ctod()
dData2  = ctod()

uai = .t.

local dDTI := m->Hoje
local xHRI := Time()

aMB     = {}
aMBCReg = {}
aVrbRRC = {}
aBonRRC = {}

nPDVrb = 0

aPAV = rdd_select("select PAVCom from "+SetTabela("tsis003"))
if len(aPAV)>0 .and. valtype(aPAV[1])="N" .and. aPAV[1]>0
   nPDVrb = aPAV[1]
endif

flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log","Iniciando Processo (Modelo 2 AG)..."+UsData(m->Hoje)+"   "+time())


   dDtSearch = ctod("01/"+strzero(month(M->Hoje),2)+"/"+right(str(year(M->Hoje)),2)) - 1   
   cSql := " select DI,DF,RECNO "
   cSql += " from "+SetTabela("tsls040")
   cSql += " where DF = '"+UsData2(dDtSearch)+"'"
   AbreRS(cSql,"tmp")
   aPeriodo  = array()
   if !tmp->(eof())
      aadd(aPeriodo,tmp->DI)            // Data Inicial
      aadd(aPeriodo,tmp->DF)            // Data Final
   else
      uai = .f.
      flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log","ERRO[Periodo nao encontrado]... em:"+UsData2(m->Hoje)+" as:"+time())
   endif
   FechaRS("tmp")

//   dData1 = ctod("01/05/14")
//   dData2 = ctod("31/05/14")
   if lPAnt
      dData1=aPeriodo[1]
      dData2=aPeriodo[2]
   else
      dData1=ctod("01/"+strzero(month(M->Hoje-1),2)+"/"+right(str(year(M->Hoje-1)),2))
      dData2=m->Hoje
   endif

   cSql  = " select RECNO "
   cSql += " from "+SetTabela("tsls040")
   cSql += " where DI = '"+UsData2(dData1)+"'"
   aArray = rdd_select(cSql)
   if ValType(aArray[1])="N".and.len(aArray)>0.and.aArray[1]>0
      pSls040 = aArray[1]
   endif

   sRprt += dtoc(dData1)+" ate "+dtoc(dData2)+chr(10)

   flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log","Iniciando Processo (MultiRegraComissao)..."+UsData(dData1)+"   "+UsData(dData2)+"  "+alltrim(pSls040))
   
   sRprt += "Apurando/Carregando Margem Bruta por Periodo/Representante/Regio."+chr(10)

   if uai; uai = fCOMVrb(); endif

   aMB     = faMBRepReg() 	// Apurando/Carregando Margem Bruta por Periodo/Representante/Regio.
   faMBComReg(pSls040)// Carregando os Parametros %MB e %Com por Periodo/Regiao
   flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log","(a)"+time())

   // Debito proveniente da %Abatimento sobre o valor total das Verbas

   // Crditos/Debitos de comissao para as NFSaida/Canceladas de Venda/Bonificacao
   if uai; uai = fCOMPrc1(); endif 	
   flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log","(b)"+time())
   
   // Debitos de Comissao paras NF de Devolucao
   if uai; uai = fCOMPrc2(); endif
   flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log","(c)"+time())

   // Atualizacao dos Saldos de comissao do vendedor
   if uai .and. !lCompara; uai = fCOMprc3(); endif
   flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log","(d)"+time())

   
   fSQLCommit(uai,.f.,.f.)

   flBAS_GravaLog("/qtux/logs/jobs/comexec.log",sRprt)
   flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log","Fim Processo (Modelo 2 AG)...uai:"+if(uai,"OK ","NOK ")+UsData(m->Hoje)+"  "+time()+"hr")
RETURN(uai)

//////////////////
FUNCTION fCOMVrb()
//////////////////
local uai := .t.
local aArray
local i   := 0

// Excluir Movimentos de Origem (5) do Conta corrente de comisses Ref a Verbas

if !lCompara
   cSql  = " select RECNO from "+SetTabela("tsls450")   // produo
else
   cSql  = " select RECNO from "+SetTabela("tsls491")   // p/ comparacao
endif
cSql += " where DATA   >= '"+UsData2(dData1)+"'"
cSql += "   and DATA   <= '"+UsData2(dData2)+"'"
//cSql += "   and COD_VEN in (26) "	// AQUI			
cSql += "   and FECHADO = 0 "
cSql += "   and ORIGEM  = 5 "
aArray = rdd_select(cSql)
for i=1 to len(aArray)
   uai = rdd_delete("delete from "+if(lCompara,SetTabela("tsls491"),SetTabela("tsls450"))+" where RECNO="+str(aArray[i]))
   if !uai
      exit
   endif
next

// AQUI


i=0

cSql  = " select a.COD_VEN,"
cSql += "        d.DP, "
cSql += "    sum(a.VALOR) VALOR,"
cSql += "        a.RECNO "
cSql += " from "+SetTabela("tsls090")+" a, "
cSql +=          SetTabela("tsls019")+" b, "
cSql +=          SetTabela("tsls018")+" c, "
cSql +=          SetTabela("tfin030")+" d  "
cSql += " where a.cod_cli = b.recno "
cSql += "   and d.COD_VBA = a.RECNO "
cSql += "   and a.cod_ven = c.recno "
cSql += "   and a.status  > 0 "
cSql += "   and d.DP      >= '"+UsData2(dData1)+"'"
cSql += "   and d.DP      <= '"+UsData2(dData2)+"'"
//cSql += "   and a.COD_VEN in (26) "	// AQUI
cSql += " group by a.COD_VEN,d.DP,a.RECNO "
cSql += " order by a.COD_VEN "
aArray = rdd_select(cSql)
for i=1 to len(aArray) step 4
   // Origem (2) Cancelamento NF de Saida (Venda/Bonificacao)
   // Venda = Debito (+)
   // Bonificacao = Debito (-)
   pVen = aArray[i]
   dPg  = ctod(BrData(aArray[i+1]))
   nVlr = aArray[i+2]
   pVrb = aArray[i+3]
   nVlrAbt = round(nVlr*nPDVrb/100,2)
   
   if lCompara
      cSql  = "insert into " + SetTabela("tsls491") + " ("
   else
      cSql  = "insert into " + SetTabela("tsls450") + " ("
   endif
   cSql += "DATA,COD_VEN,COD_NF,HIST,CODFORM,NUM_NF,DEBITO,ORIGEM) values ('"
   cSql += UsData(dPg)              + "',"
   cSql += alltrim(pVen)             + ",0,'"
   cSql += "VRB "+alltrim(pVrb)+" "+alltrim(transform(nPDVrb,"@e 999.99"))+"% BC "+alltrim(transform(nVlr,"@e 999,999,999.99"))                 + "','',0,"
   cSql += str(nVlrAbt,15,5)      + ",5)"
   uai = rdd_insert(cSql)
   if !uai
      cMsg = "[FALHOU] insert na tsls450 do prc(1) verificar querie:"+cSql
      flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log",cMsg)
      exit
   endif
next

cSql  = " select k.RECNO,k.COD_REG,sum(b.VP) VALOR "
cSql += " from "+SetTabela("tsls090") + " a ,"  // Verbas
cSql +=          SetTabela("tfin030") + " b ,"  // Contas a Pagar
cSql +=          SetTabela("tsls019") + " c ,"  // Clientes
cSql +=          SetTabela("tsls022") + " d ,"  // Grupo de Clientes
cSql +=          SetTabela("tbas011") + " e ,"  // Regies
cSql +=          SetTabela("tsls018") + " k "   // Representante
cSql += " where b.COD_VBA = a.RECNO "
cSql += "   and a.COD_CLI = c.RECNO "
cSql += "   and c.COD_GCL = d.RECNO "
cSql += "   and a.COD_VEN = k.RECNO "
cSql += "   and k.COD_REG = e.RECNO "
cSql += "   and b.DP     >= '"+UsData2(dData1)+"'"
cSql += "   and b.DP     <= '"+UsData2(dData2)+"'"
//cSql += "   and a.COD_VEN in (26) "	// AQUI
cSql += " group by k.RECNO,k.COD_REG "
aArray = rdd_select(cSql)
for o=1 to len(aArray) step 3
   aadd(aVrbRRC,aArray[o])	//pRepresentante
   aadd(aVrbRRC,aArray[o+1])	//pRegioComercial
   aadd(aVrbRRC,aArray[o+2])	//nValorVerba
next
// AQUI
RETURN(uai)

FUNCTION fVrbRRC(pRep,pRC)
//////////////////////////
local nVB := 0
local o   :=0
for o=1 to len(aVrbRRC) step 3
   if aVrbRRC[o]=pRep .and. aVrbRRC[o+1]=pRC
      nVB = aVrbRRC[o+2]
      exit
   endif
next

RETURN(nVB)

FUNCTION fBonMedRRC(pRep,pRC)
//////////////////////////
local nBonMed := 0
local o       :=0
for o=1 to len(aBonRRC) step 3
   if aBonRRC[o]=pRep .and. aBonRRC[o+1]=pRC
      nBonMed = aBonRRC[o+2]
      exit
   endif
next
RETURN(nBonMed)

/////////////////////
FUNCTION faMBRepReg()
/////////////////////
local i     := 0
local cSql  := "" 
local pVen  := 0
local pReg  := 0 
local iVFat := 0
local iQFat := 0
local iVCtr := 0
local iVMed := 0 
local iVMedBon := 0
local iVB   := 0
local aTMP1 := {}
local aTMP2 := {}


sRprt += " considere: iVCtr = sum(a.VLCTR+a.VLCTRMAN),"+chr(10)
sRprt += "            iVMed = sum(a.qt*f.C_IPIMEDIO)"+chr(10)
sRprt += "            iMB   = ((iVFat-(iVCtr+iVB))-(iVMed+iVMedBon))/(iVFat-(iVCtr+iVB))*100*-1 "+chr(10)
sRprt += " Representante/Regiao/iVFat/iQFat/iVCtr/iVMed/iVMedBon/iMB"+chr(10)

cSql  = " select k.RECNO 							COD_VEN	,"
cSql += "        e.RECNO							COD_REG	,"
cSql += "        sum(a.qt*f.C_IPIMEDIO) 					VL_MEDIO "
cSql += " from "+SetTabela("tsls402")+" a,"
cSql +=          SetTabela("tsls401")+" b,"
cSql +=          SetTabela("tsls019")+" c,"
cSql +=          SetTabela("tsls022")+" d,"
cSql +=          SetTabela("tbas011")+" e,"
cSql +=          SetTabela("titm002")+" f,"
cSql +=          SetTabela("titm012")+" g,"
cSql +=          SetTabela("titm011")+" h,"
cSql +=          SetTabela("titm010")+" i,"
cSql +=          SetTabela("tsls018")+" k,"
cSql +=          SetTabela("tsls056")+" l,"
cSql +=          SetTabela("titm013")+" j,"
cSql +=          SetTabela("tsls015")+" m  "
cSql += " where  b.d_emissao >= '"+UsData2(dData1)+"'"
cSql += "   and  b.d_emissao <= '"+UsData2(dData2)+"'"
cSql += "   and  b.canc       = 0         "
cSql += "   and  b.e_entrada  = 0         "
cSql += "   and  b.e_devolucao= 0         "
cSql += "   and  l.e_bonifica = 1         "
cSql += "   and  l.recno      = b.cod_tov "
cSql += "   and  b.recno      = a.cod_nf  "
cSql += "   and  k.recno      = b.cod_ven "
cSql += "   and  c.recno      = b.cod_cli "
cSql += "   and  d.recno      = c.cod_gcl "
cSql += "   and  e.recno      = k.cod_reg "
cSql += "   and  f.recno      = a.cod_pro "
cSql += "   and  g.recno      = f.cod_ag  "
cSql += "   and  h.recno      = g.cod_mag "
cSql += "   and  i.recno      = g.cod_bu  "
cSql += "   and  m.recno      = b.cod_pgm "
cSql += "   and  j.recno      = a.cod_alm "
cSql += "   and  l.TDEFAULT   = '1'       "
cSql += "   and  b.VENPRCUS   = '0'       "
//cSql += "   and  b.COD_VEN in (26) "		// AQUI
cSql += " group by k.RECNO,e.RECNO "
aTMPBon = rdd_select(cSql)
for i=1 to len(aTMPBon) step 3
   aadd(aBonRRC,aTMPBon[i])
   aadd(aBonRRC,aTMPBon[i+1])
   aadd(aBonRRC,aTMPBon[i+2])
next


cSql  = " select k.RECNO 							COD_VEN	,"
cSql += "        e.RECNO							COD_REG	,"
cSql += "        sum(a.v1-a.ICMZFRANCA-(l.ZFRANCA*(a.PISVALOR+a.CONVALOR))) 	VL_FAT	,"
cSql += "        sum(a.qt) 							QT_FAT	,"
cSql += "        sum(a.VLCTR+a.VLCTRMAN) 					VLCTR   ," 
cSql += "        sum(a.qt*f.C_IPIMEDIO) 					VL_MEDIO,"
cSql += "        k.VENDEDOR								,"
cSql += "        e.REGIAO "
cSql += " from "+SetTabela("tsls402")+" a,"
cSql +=          SetTabela("tsls401")+" b,"
cSql +=          SetTabela("tsls019")+" c,"
cSql +=          SetTabela("tsls022")+" d,"
cSql +=          SetTabela("tbas011")+" e,"
cSql +=          SetTabela("titm002")+" f,"
cSql +=          SetTabela("titm012")+" g,"
cSql +=          SetTabela("titm011")+" h,"
cSql +=          SetTabela("titm010")+" i,"
cSql +=          SetTabela("tsls018")+" k,"
cSql +=          SetTabela("tsls056")+" l,"
cSql +=          SetTabela("titm013")+" j,"
cSql +=          SetTabela("tsls015")+" m  "
cSql += " where  b.d_emissao >= '"+UsData2(dData1)+"'"
cSql += "   and  b.d_emissao <= '"+UsData2(dData2)+"'"
cSql += "   and  b.canc       = 0         "
cSql += "   and  b.e_entrada  = 0         "
cSql += "   and  b.e_devolucao= 0         "
cSql += "   and  l.e_bonifica = 0         "
cSql += "   and  l.recno      = b.cod_tov "
cSql += "   and  b.recno      = a.cod_nf  "
cSql += "   and  k.recno      = b.cod_ven "
cSql += "   and  c.recno      = b.cod_cli "
cSql += "   and  d.recno      = c.cod_gcl "
cSql += "   and  e.recno      = k.cod_reg "
cSql += "   and  f.recno      = a.cod_pro "
cSql += "   and  g.recno      = f.cod_ag  "
cSql += "   and  h.recno      = g.cod_mag "
cSql += "   and  i.recno      = g.cod_bu  "
cSql += "   and  m.recno      = b.cod_pgm "
cSql += "   and  j.recno      = a.cod_alm "
cSql += "   and  l.TDEFAULT   = '1'       "
cSql += "   and  b.VENPRCUS   = '0'       "
//cSql += "   and  b.COD_VEN in (26) "	// AQUI
cSql += " group by k.RECNO,e.RECNO,k.VENDEDOR,e.REGIAO "
cSql += " order by k.VENDEDOR,e.REGIAO "
aTMP1 = rdd_select(cSql)
for i=1 to len(aTMP1) step 8
   pVen  = aTMP1[i]
   pReg  = aTMP1[i+1] 
   iVFat = aTMP1[i+2] 
   iQFat = aTMP1[i+3] 
   iVCtr = aTMP1[i+4] 
   iVMed = aTMP1[i+5]
   iVMedBon = fBonMedRRC(pVen,pReg)
   iVB      = fVrbRRC(pVen,pReg)
   if (iVFat-(iVCtr+iVB))-(iVMed+iVMedBon) < 0 .and. (iVFat-(iVCtr+iVB)) < 0
      iMB = ((iVFat-(iVCtr+iVB))-(iVMed+iVMedBon))/(iVFat-(iVCtr+iVB))*100*-1
   else
      iMB = ((iVFat-(iVCtr+iVB))-(iVMed+iVMedBon))/(iVFat-(iVCtr+iVB))*100
   endif
   //Alert("iVFat:"+alltrim(iVFat))	//// RETIRAR
   //Alert("iVCtr:"+alltrim(iVCtr))
   //Alert("iVB:"+alltrim(iVB))
   //Alert("iVMed:"+alltrim(iVMed))
   //Alert("iVMedBon:"+alltrim(iVMedBon))
   //Alert("iVFat:"+alltrim(iVFat))
   //Alert("iVCtr:"+alltrim(iVCtr))
   //Alert("iVB:"+alltrim(iVB))
   //Alert("iMB:"+alltrim(iMB))
   aadd(aTMP2,pVen)
   aadd(aTMP2,pReg)
   aadd(aTMP2,iMB)
   sRprt += left(aTMP1[i+6]+space(40),15)+" | "+;
            left(aTMP1[i+7]+space(30),10)+" | "+;
            transform(iVFat   ,"@e 9,999,999.9")+" | "+;
            transform(iQFat   ,"@e   999,999.9")+" | "+;
            transform(iVCtr   ,"@e   999,999.9")+" | "+;
            transform(iVB     ,"@e   999,999.9")+" | "+;
            transform(iVMed   ,"@e 9,999,999.9")+" | "+;
            transform(iVMedBon,"@e 9,999,999.9")+" | "+;
            transform(iMB     ,"@e      9999.999")+chr(10)
/*
Alert("aTMP1[i+7]+space(40):"+aTMP1[i+7]+space(40))
Alert("aTMP1[i+8]:"+aTMP1[i+8]+space(30))
Alert("iVFat:"+transform(iVFat   ,"@e 9,999,999.9"))
Alert("iQFat:"+transform(iQFat   ,"@e   999,999.9"))
Alert("VCtr:"+transform(iVCtr   ,"@e   999,999.9"))
Alert("iVB:"+transform(iVB     ,"@e   999,999,9"))
Alert("iVMed:"+transform(iVMed   ,"@e 9,999,999.9"))
Alert("iVMedBon:"+transform(iVMedBon,"@e 9,999,999.9"))
Alert("iMB:"+transform(iMB     ,"@e      9999.9"))    
*/
   // if (VL_FAT-(VLCTR+VERBA))-((QT_FAT+QT_BON)*(VL_MEDIO/QT_FAT)) < 0 .and. (VL_FAT-(VLCTR+VERBA)) < 0
   // ((((VL_FAT-(VLCTR+VERBA))-((QT_FAT+QT_BON)*(VL_MEDIO/QT_FAT)))/(VL_FAT-(VLCTR+VERBA)))*100)*-1
   // else
   // (((VL_FAT-(VLCTR+VERBA))-((QT_FAT+QT_BON)*(VL_MEDIO/QT_FAT)))/(VL_FAT-(VLCTR+VERBA)))*100

   //((((VL_FAT-VLCTR)-(QT_FAT*(VL_MEDIO/QT_FAT)))/(VL_FAT-VLCTR))*100)*-1  MB_INQ
next
RETURN(aTMP2)

////////////////////////////////
FUNCTION GerarTXT(cString,cFile)
////////////////////////////////
if pcount() < 2; cFile="alo.alo" ; endif
memowrit(cFile,cString)
RETURN(.t.)


////////////////////////////////
FUNCTION fGetMBRepReg(pVen,pReg)
////////////////////////////////
local i   := 0
local iMB := 0
for i=1 to len(aMB) step 3
   if pVen=aMB[i] .and. pReg=aMB[i+1]
      iMB = aMB[i+2]
      exit
   endif
next
RETURN(round(iMB,2))

////////////////////////////
FUNCTION faMBComReg(pSls040)
////////////////////////////
local cSql := ""
local aArray
local h    := 1
//cmb.o cSql  = " select pMet,pRC,nMB,nCom,nMB1De,nMB1Ate,nCom1,nMB2De,nMB2Ate,nCom2,nMB3De,nMB3Ate,nCom3 "
cSql  = " select pMet,pRC,nMB,nCom,nMB1De,nMB1Ate,nCom1,nMB2De,nMB2Ate,nCom2,nMB3De,nMB3Ate,nCom3,nMB4De,nMB4Ate,nCom4 "
cSql += " from "+SetTabela("tbas011a")
cSql += " where pMet = "+alltrim(pSls040)
aArray = rdd_select(cSql)
//cmb.ofor h=1 to len(aArray) step 13
 for h=1 to len(aArray) step 16	//cmb.n
   aadd(aMBCReg,aArray[h])	// pMet
   aadd(aMBCReg,aArray[h+1])	// pRC
   aadd(aMBCReg,aArray[h+2])	// nMB
   aadd(aMBCReg,aArray[h+3])	// nCom
   aadd(aMBCReg,aArray[h+4])	// nMB1De 
   aadd(aMBCReg,aArray[h+5])	// nMB1Ate
   aadd(aMBCReg,aArray[h+6])	// nCom1
   aadd(aMBCReg,aArray[h+7])	// nMB2De
   aadd(aMBCReg,aArray[h+8])	// nMB2Ate
   aadd(aMBCReg,aArray[h+9])	// nCom2  
   aadd(aMBCReg,aArray[h+10])	// nMB3De
   aadd(aMBCReg,aArray[h+11])	// nMB3Ate
   aadd(aMBCReg,aArray[h+12])	// nCom3
   aadd(aMBCReg,aArray[h+13])	// nMB4De //cmb.n
   aadd(aMBCReg,aArray[h+14])	// nMB4Ate //cmb.n
   aadd(aMBCReg,aArray[h+15])	// nCom4 //cmb.n
next
RETURN(.t.)

/////////////////////////////
FUNCTION fGMBComReg(pMet,pRC)
/////////////////////////////
local i    := 0
local aTmp := {}
aadd(aTmp,0)
aadd(aTmp,0)
aadd(aTmp,0)
aadd(aTmp,0)
aadd(aTmp,0)
aadd(aTmp,0)
aadd(aTmp,0)
aadd(aTmp,0)
aadd(aTmp,0)
aadd(aTmp,0)
aadd(aTmp,0)
aadd(aTmp,0) //cmb.n
aadd(aTmp,0) //cmb.n
aadd(aTmp,0) //cmb.n
//for i=1 to len(aMBCReg) step 13 //cmb.o
for i=1 to len(aMBCReg) step 16 //cmb.n
   if pMet=aMBCReg[i] .and. pRC=aMBCReg[i+1]
      aTmp[1]  = aMBCReg[i+2]	
      aTmp[2]  = aMBCReg[i+3]
      aTmp[3]  = aMBCReg[i+4]
      aTmp[4]  = aMBCReg[i+5]
      aTmp[5]  = aMBCReg[i+6]
      aTmp[6]  = aMBCReg[i+7]
      aTmp[7]  = aMBCReg[i+8]
      aTmp[8]  = aMBCReg[i+9]
      aTmp[9]  = aMBCReg[i+10]
      aTmp[10] = aMBCReg[i+11]
      aTmp[11] = aMBCReg[i+12]
      aTmp[12] = aMBCReg[i+13] //cmb.n
      aTmp[13] = aMBCReg[i+14] //cmb.n
      aTmp[14] = aMBCReg[i+15] //cmb.n
      exit
   endif
next
RETURN(aTmp)

//////////////////////////////////////
FUNCTION fiPComM2(pMet,pRCom,pVen,pAG)
//////////////////////////////////////
// MODELO 2-MBruta (RegCom/RegCom+AG)
local uai       := .t.
local cSql      := ""

local nPCom     := 0

local aMBRC     := {}
local nMBRC     := 0 // Margem Bruta por Regiao comercial (parametro)
local nPComRC   := 0 // Porcentagem Comissao por Regiao Comercial

local nMBARRC   := 0 // Margem Bruta Apurada por Representante/Regio Comercial (Apurada no perodo)

local nPComRCAG := 0 // Porcentagem de Comissao por Regio Comercial/AG

// Buscar %MB e %COM por Periodo/Regiao Comercial
aMBRC     = fGMBComReg(pMet,pRCom)
nMBRC     = aMBRC[1]
nPComRC   = aMBRC[2]
nRCMB1De  = aMBRC[3]
nRCMB1Ate = aMBRC[4]
nRCCom1   = aMBRC[5]
nRCMB2De  = aMBRC[6]
nRCMB2Ate = aMBRC[7]
nRCCom2   = aMBRC[8]
nRCMB3De  = aMBRC[9]
nRCMB3Ate = aMBRC[10]
nRCCom3   = aMBRC[11]
nRCMB4De  = aMBRC[12] //cmb.n
nRCMB4Ate = aMBRC[13] //cmb.n
nRCCom4   = aMBRC[14] //cmb.n
/*if pVen = 35
   sRprt += "pMet:"+alltrim(pMet)+" | "
   sRprt += "pRCom:"+alltrim(pRCom)+" | "
   sRprt += "nRCCom1:"+alltrim(nRCCom1)+" | "
   sRprt += "nRCCom2:"+alltrim(nRCCom2)+" | "

//cmb.o   sRprt += "nRCCom3:"+alltrim(nRCCom3)+" | "+chr(10) // cmb.n
   sRprt += "nRCCom3:"+alltrim(nRCCom3)+" | "
   sRprt += "nRCCom4:"+alltrim(nRCCom4)+" | "+chr(10)
endif*/
 

// Buscar a %MB apurada para o representante na Regio Comercial
nMBARRC = fGetMBRepReg(pVen,pRCom)

// Buscar %COM por Perodo/Regio Comercial/AG
nPComRCAG = fiPComRCAG(pMet,pAG,pRCom)

/* rbm.02Fev2012.o
if nMBARRC < nMBRC
   nPCom = nPComRC
else
   nPCom = nPComRCAG
endif
*/

// rbm.02Fev2012.n
//cmb.o if ((nRCMB3Ate <> 0 .and. nMBARRC <= nRCMB3Ate) .or.;
//cmb.o    (empty(nRCMB3Ate) .and. nRCMB2Ate <> 0 .and. nMBARRC <= nRCMB2Ate) .or. ;
//cmb.o    (empty(nRCMB2Ate) .and. empty(nRCMB3Ate) .and. nRCMB1Ate <> 0 .and. nMBARRC <= nRCMB1Ate))

if ((nRCMB4Ate <> 0 .and. nMBARRC <= nRCMB4Ate) .or.; //cmb.n
     (empty(nRCMB4Ate) .and. nRCMB3Ate <> 0 .and. nMBARRC <= nRCMB3Ate) .or.; //cmb.n
     (empty(nRCMB3Ate) .and. empty(nRCMB4Ate) .and. nRCMB2Ate <> 0 .and. nMBARRC <= nRCMB2Ate) .or. ; //cmb.n
     (empty(nRCMB2Ate) .and. empty(nRCMB3Ate) .and. empty(nRCMB4Ate) .and. nRCMB1Ate <> 0 .and. nMBARRC <= nRCMB1Ate)) //cmb.n
/*   if pVen = 35
      sRprt += "ENTROU: nRCMB1Ate >= nMBARRC:"+alltrim(nRCMB1Ate)+" >= "+alltrim(nMBARRC)+"|"+chr(10)
      sRprt += "ENTROU: nRCMB2De  <= nMBARRC .and. nRCMB2Ate >= nMBARRC:"+alltrim(nRCMB2De)+" <= "+alltrim(nMBARRC)+" .and. "+alltrim(nRCMB2Ate)+" >= "+alltrim(nMBARRC)+"|"+chr(10)
      sRprt += "ENTROU: nRCMB3De <= nMBARRC .and. nRCMB3Ate >= nMBARRC:"+alltrim(nRCMB3De)+" <= "+alltrim(nMBARRC)+" .and. "+alltrim(nRCMB3Ate)+" >= "+alltrim(nMBARRC)+"|"+chr(10)
   endif*/
   if nRCMB1Ate >= nMBARRC
      nPCom = nRCCom1
      sRprt += "1) nPCom:"+alltrim(nPCom)+"|"+chr(10)
   endif
   if nRCMB2De  <= nMBARRC .and. nRCMB2Ate >= nMBARRC
      nPCom = nRCCom2
      sRprt += "2) nPCom:"+alltrim(nPCom)+"|"+chr(10)
   endif
   if nRCMB3De <= nMBARRC .and. nRCMB3Ate >= nMBARRC
      nPCom = nRCCom3
      sRprt += "3) nPCom:"+alltrim(nPCom)+"|"+chr(10)
   endif
   if nRCMB4De <= nMBARRC .and. nRCMB4Ate >= nMBARRC //cmb.n
      nPCom = nRCCom4 //cmb.n
      sRprt += "4) nPCom:"+alltrim(nPCom)+"|"+chr(10) //cmb.n
   endif //cmb.n

else
   nPCom = nPComRCAG
endif

/*if pVen= 35
   sRprt += "nMBRC:"+alltrim(nMBRC)+" | "
   sRprt += "nPComRC:"+alltrim(nPComRC)+" | "
   sRprt += "nMBARRC:"+alltrim(nMBARRC)+" | "
   sRprt += "nPComRCAG:"+alltrim(nPComRCAG)+" | "
   sRprt += "nPCom:"+alltrim(nPCom)+" | "
endif*/
RETURN(nPCom)

//////////////////////////////////////
FUNCTION fiPComM3(pMet,pRCom,pVen,pAG)
//////////////////////////////////////
//MODELO 3-MBruta (RegCom/Representante+AG)
local uai       := .t.
local cSql      := ""
local nPCom     := 0

local aMBRC     := {}
local nMBRC     := 0 // Margem Bruta por Regiao comercial (parametro)
local nPComRC   := 0 // Porcentagem Comissao por Regiao Comercial
local nMBARRC   := 0 // Margem Bruta Apurada por Representante/Regio Comercial (Apurada no perodo)
local nPComRAG  := 0 // Porcentagem de Comissao por Representante/AG
// Buscar %MB e %COM por Periodo/Regiao Comercial
aMBRC     = fGMBComReg(pMet,pRCom)
nMBRC     = aMBRC[1]
nPComRC   = aMBRC[2]
nRCMB1De  = aMBRC[3]
nRCMB1Ate = aMBRC[4]
nRCCom1   = aMBRC[5]
nRCMB2De  = aMBRC[6]
nRCMB2Ate = aMBRC[7]
nRCCom2   = aMBRC[8]
nRCMB3De  = aMBRC[9]
nRCMB3Ate = aMBRC[10]
nRCCom3   = aMBRC[11]
nRCMB4De  = aMBRC[12] //cmb.n
nRCMB4Ate = aMBRC[13] //cmb.n
nRCCom4   = aMBRC[14] //cmb.n

// Buscar a %MB realizado para o representante na Regio Comercial
nMBARRC = fGetMBRepReg(pVen,pRCom)

// Buscar %COM por Perodo/Representante/AG
nPComRAG = fiPComRAG(pMet,pAG,pVen)

//if nMBARRC < nMBRC
		// rbm.02Fev2012.o
//   nPCom = nPComRC
//else
//   nPCom = nPComRAG
//endif
// rbm.02Fev2012.n

// RBM/FHP 04Sep2013
//if ((nRCMB3Ate <> 0 .and. nMBARRC <= nRCMB3Ate) .or.;
//    (empty(nRCMB3Ate) .and. nRCMB2Ate <> 0 .and. nMBARRC <= nRCMB2Ate) .or. ;
//    (empty(nRCMB2Ate) .and. empty(nRCMB3Ate) .and. nRCMB1Ate <> 0 .and. nMBARRC <= nRCMB1Ate))  
//   if nRCMB1Ate >= nMBARRC 
//      nPCom = nRCCom1  
//   endif
//   if nRCMB2De  <= nMBARRC .and. nRCMB2Ate >= nMBARRC
//      nPCom = nRCCom2  
//   endif
//   if nRCMB3De <= nMBARRC .and. nRCMB3Ate >= nMBARRC
//      nPCom = nRCCom3  
//   endif
//else
*/
   nPCom = nPComRAG
//endif
RETURN(nPCom)



*******************
FUNCTION BrData(d_)
*******************
local uai
if empty(d_)
   uai = "  /  /  "
elseif valtype(d_) = "C"
   uai = right(d_,2) + "/" + substr(d_,6,2) + "/" + substr(d_,3,2)
else
   uai = dtoc(d_)
endif   
Return(uai)



*******************
FUNCTION fCOMPrc1()
*******************
local i
local vCTRDescFin := 0	//Lembrar de zerar no processo
local vDescFin    := 0  //Lembrar de zerar no processo
local xVlComissao := 0
local xSdo 	  := 0
local nCOD_NF	  := 0
local nCOD_VEN    := 0
local cRAZAO      := ""
local cCODFORM    := ""			// Descricao do Formulario
local nNUM_NF     := 0			// Numero da Nota fiscal
local lE_BON      := .f.		// Nota fiscal de Bonificacao (inverte valores)
local xTVLCom     := 0 			// Valor total da comissao
local xVlCTR      := 0			// Valor Contrato para a linha da NF
local dEMISSAO    := ctod("  /  /  ")
local dCanc       := ctod("  /  /  ")
local cMOTIVO
local lMTVCOM     := 0
local lAbtFrt     := 0
local nVLFRETE    := 0
      iTotal       = 0

// Excluir Movimentos de Origem (1,2) do Conta corrente de comisses

if !lCompara
   cSql  = " select RECNO from "+SetTabela("tsls450")   // produo
else
   cSql  = " select RECNO from "+SetTabela("tsls491")   // p/ comparacao
endif
cSql += " where DATA >= '"+UsData2(dData1)+"'"
cSql += "   and DATA <= '"+UsData2(dData2)+"'"
cSql += "   and FECHADO = 0 "
//cSql += "   and COD_VEN in (26) "	// AQUI
cSql += "   and ORIGEM in (1,2,4) "
aArray = rdd_select(cSql)
for i=1 to len(aArray)
   uai = rdd_delete("delete from "+if(lCompara,SetTabela("tsls492"),SetTabela("tsls451"))+" where "+if(lCompara,"COD_491=","COD_450=")+str(aArray[i]))
   if uai
      uai = rdd_delete("delete from "+if(lCompara,SetTabela("tsls491"),SetTabela("tsls450"))+" where RECNO="+str(aArray[i]))
   endif
   if !uai
      exit
   endif
next

/// AQUI



i=0

if !uai
   cMsg = "[FALHOU] delete(s) do prc(1)"
   flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log",cMsg)
endif


if uai
//if .f.

cSql  = " select count(*) "
cSql += " from "+  SetTabela("tsls401") + " b,"
cSql +=            SetTabela("tsls056") + " c,"
cSql +=            SetTabela("tsls018") + " d,"
cSql +=            SetTabela("tsls001") + " e "
cSql += " where c.RECNO      = b.COD_TOV "
cSql += "   and e.RECNO      = b.COD_OV  "
cSql += "   and d.RECNO      = b.COD_VEN "
cSql += "   and b.EMANUAL    = 0         "
cSql += "   and b.E_ENTRADA  = 0         "
cSql += "   and c.COMISSAO   = 1         "
cSql += "   and d.COMISSAO   = 1         "
cSql += "   and b.VENPRCUS   = 0         "
//cSql += "   and b.COD_VEN in (26) "	// AQUI
cSql += "   and ((b.D_EMISSAO >= '"+UsData2(dData1)+"' and b.D_EMISSAO <= '"+UsData2(dData2)+"') or "
cSql += "        (b.DT_CANC   >= '"+UsData2(dData1)+"' and b.DT_CANC   <= '"+UsData2(dData2)+"'))   "
aArray = rdd_cursor(cSql)
iTotal = aArray[1]

// Selecao principal das NF de Saida cujo Tipo padrao de Ordem e/Representante calcula Comissao
cSql  = " select a.COD_LIP,a.COMISSAO,a.NUMERACAO,a.DESCONTO,a.COD_PRO,a.PROCODIGO,a.PRODESC,a.QT,a.PRU,a.DESCESP,a.COD_NF,b.CODFORM,b.COD_VEN,b.DESCFIN,b.RAZAO,b.COD_CLI,b.NUM_NF,b.CANC,b.D_EMISSAO,b.DT_CANC,b.COD_MTV,b.VL_FRETE,d.DCTR,c.E_BONIFICA,f.DESCRICAO MOTIVO,f.COMISSAO MTVCOM,f.FRETEVEN ABTFRT,d.COD_REG,g.COD_AG,d.TCOM,a.RECNO"
cSql += " from " + SetTabela("tsls402") + " a,"
cSql +=            SetTabela("tsls401") + " b left join "+SetTabela("tsls037")+" f on f.RECNO = b.COD_MTV,"
cSql +=            SetTabela("tsls056") + " c,"
cSql +=            SetTabela("tsls018") + " d,"
cSql +=            SetTabela("tsls001") + " e,"
cSql +=            SetTabela("titm002") + " g "
cSql += " where b.RECNO      = a.COD_NF  "
cSql += "   and g.RECNO      = a.COD_PRO "
cSql += "   and c.RECNO      = b.COD_TOV "
cSql += "   and e.RECNO      = b.COD_OV  "
cSql += "   and d.RECNO      = b.COD_VEN "
cSql += "   and b.EMANUAL    = 0         "
cSql += "   and c.COMISSAO   = 1         "
//cSql += "   and b.COD_VEN in (26)  " // AQUI
cSql += "   and d.COMISSAO   = 1         "
cSql += "   and b.VENPRCUS   = 0         "
cSql += "   and b.E_ENTRADA  = 0         "
cSql += "   and ((b.D_EMISSAO >= '"+UsData2(dData1)+"' and b.D_EMISSAO <= '"+UsData2(dData2)+"') or "
cSql += "        (b.DT_CANC   >= '"+UsData2(dData1)+"' and b.DT_CANC   <= '"+UsData2(dData2)+"'))   "
cSql += " order by a.COD_NF "

AbreRS(cSql,"tmp")
nCOD_NF = tmp->COD_NF
sRprt += "NUM_NF|PROCODIGO|pSls040|COD_REG|COD_VEN|COD_AG|E_BONIF|PRU|QT|xVlCTR|DESCESP|iPComissao|DESCFIN|xVlComissao"+chr(10)
while !tmp->(EOF()) .and. uai
   iModelo = tmp->TCOM

   // Abater os Valores de contrato do tipo A/F automatico (fora desconto financeiro)
   cSql  = " select sum(b.VALOR) "
   cSql += " from " + SetTabela("tctr012")+" a,"
   cSql +=            SetTabela("tctr015")+" b,"
   cSql +=            SetTabela("tctr011")+" c "
   cSql += " where a.RECNO     = b.COD_CTR12 "
   cSql += "   and c.RECNO     = b.COD_CTR11 "
   cSql += "   and a.COD_NF    = "+str(tmp->COD_NF)
   cSql += "   and b.COD_402   = "+str(tmp->(RECNO()))
//   cSql += "   and c.TIPO_COBR <> 3 "	// Tira o desconto financeiro do contrato p/ no abater 2X
   cSql += "   and a.ORIGEM    =  2 "
   if tmp->DCTR
      aArray = rdd_cursor(cSql)
      xVlCTR = if(!empty(aArray[1]),aArray[1],0)
   else
      xVlCTR=0
   endif
   cSqlCTR = cSql

   iPComissao  = 0
   xVlComissao = 0
   //1-RegCom/AG                       
   //2-MBruta (RegCom/RegCom+AG)       
   //3-MBruta (RegCom/Representante+AG)
   //4-Por lista de Preco

   //if tmp->COD_VEN = 394
   //   sRprt += "iMd:"+alltrim(iModelo)
   //endif

   if iModelo = 1 	// RegCom/AG
     // if tmp->COD_VEN = 394
     //    sRprt += "iMd:"+alltrim(iModelo)
     // endif
      iPComissao  = fiPComRCAG(pSls040,tmp->COD_AG,tmp->COD_REG)
      xVlComissao = round((tmp->PRU*tmp->QT)*iPComissao/100,2)
      //if tmp->COD_VEN = 394
      //   sRprt += "pSls040:"+alltrim(pSls040)+" | "
      //   sRprt += "pAg:"+alltrim(tmp->COD_AG)+" | "
      //   sRprt += "pReg:"+alltrim(tmp->COD_REG)+" | "
      //   sRprt += "iPComissao:"+alltrim(iPComissao)+" | "
      //   sRprt += "xVlComissao:"+alltrim(xVlComissao)+chr(10)
      //endif
   elseif iModelo = 2 	// MBruta (RegCom/RegCom+AG)
      iPComissao  = fiPComM2(pSls040,tmp->COD_REG,tmp->COD_VEN,tmp->COD_AG) 
      if !tmp->E_BONIFICA
         xVlComissao = round(((tmp->PRU*tmp->QT-(xVlCTR+tmp->DESCESP))*iPComissao/100),2) //*(1-tmp->DESCFIN/100),2)
      else
         xVlComissao = round(((tmp->PRU*tmp->QT)*iPComissao/100),2) //*(1-tmp->DESCFIN/100),2)
      endif
/*      if tmp->COD_VEN = 35
         sRprt += "NUM_NF:|"+alltrim(tmp->NUM_NF)+" | "
         sRprt += "PROCODIGO:|"+alltrim(tmp->PROCODIGO)+" | "
         sRprt += "pSls040:|"+alltrim(pSls040)+" | "
         sRprt += "COD_REG:|"+alltrim(tmp->COD_REG)+" | "
         sRprt += "COD_VEN:|"+alltrim(tmp->COD_VEN)+" | "
         sRprt += "COD_AG:|"+alltrim(tmp->COD_AG)+" | "
         sRprt += "E_BONIFICA:|"+alltrim(tmp->E_BONIFICA)+" | "
         sRprt += "PRU:|"+transform(tmp->PRU,"@e 999999999.99")+" | "
         sRprt += "QT:|"+transform(tmp->QT,"@e 999999")+" | "
         sRprt += "xVlCTR:|"+transform(xVlCTR,"@e 999999999.99")+" | "
         sRprt += "DESCESP:|"+transform(tmp->DESCESP,"@e 999999999.99")+" | "
         sRprt += "iPComissao:|"+transform(iPComissao,"@e 999999999.99")+" | "
         sRprt += "DESCFIN:|"+transform(tmp->DESCFIN,"@e 999999999.99")+" | "
         sRprt += "xVlComissao:|"+transform(xVlComissao,"@e 999999999.99")+"|"+cSqlCTR+chr(10)

         //sRprt += "Num_NF:"+alltrim(tmp->NUM_NF)+" / "
         //sRprt += "PROCODIGO:"+alltrim(tmp->PROCODIGO)+" / "
         //sRprt += "pSls040:"+alltrim(pSls040)+" / "
         //sRprt += "pReg:"+alltrim(tmp->COD_REG)+" / "
         //sRprt += "pVen:"+alltrim(tmp->COD_VEN)+" / "
         //sRprt += "pAg:"+alltrim(tmp->COD_AG)+" / "
         //sRprt += "iPComissao:"+alltrim(iPComissao)+" / "
         //sRprt += "xVlComissao:"+alltrim(xVlComissao)+chr(10)

      endif*/
   elseif iModelo = 3 	// MBruta (RegCom/Representante+AG) 
      iPComissao  = fiPComM3(pSls040,tmp->COD_REG,tmp->COD_VEN,tmp->COD_AG) 
      xVlComissao = round(((tmp->PRU*tmp->QT-(xVlCTR+tmp->DESCESP))*iPComissao/100),2) //*(1-tmp->DESCFIN/100),2) RBM08Nov2010
   elseif iModelo = 4 	// por Lista de Preo
     //   iPComissao  = tmp->COMISSAO
     //   xVlComissao = round((tmp->PRU*tmp->QT)*iPComissao/100,2)
   endif

   // Pypado em 09/Feb/2009 Jandira
   //xVlComissao    = Truncar2D((Truncar2D(tmp->PRU)*tmp->QT-(xVlCTR+tmp->DESCESP))*iPComissao/100)
   //xVlComissao    = Truncar2D(xVlComissao*(1-tmp->DESCFIN/100)) 	     // (-) Desconto Financeiro

   // novo clculo 02/Feb/2009 (Base Cheia)
   //xVlComissao = Truncar2D((Truncar2D(tmp->PRU)*tmp->QT)*iPComissao/100)

//   Desconto Incondicional
//      xVlComissao1  = ((PRU*QT-xVlCTR)*PORC_COMISSAO/100)*(1-PORC_DESCFIN/100)	// Calculo Atual
//      xVlComissao1  =	((10 *20-   0  )*     7[%]/100        )*(1-5[%]/100)
//      xVlComissao1  = ((200)*7[%]/100)*(0.95)
//      xVlComissao1  = (14*0.95)
//      xVlComissao1  = 13.30 R$ de comissao No considerado desconto Incondicional
//
//      xVlComissao2  = ((PRU*QT-(xVlCTR+xVlDESCINCOND))*PORC_COMISSAO/100)*(1-DESCFIN/100) // Calculo Desconto Incondicional
//      xVlComissao2  = ((10 *20-(    0 +      5      ))*      7      /100)*(1-  5[%] /100)
//      xVlComissao2  = ((200-5)*7/100)*0.95
//      xVlComissao2  = 195*7/100*0.95
//      xVlComissao2  = 12.96

   if tmp->D_EMISSAO >= dData1 .and. tmp->D_EMISSAO <= dData2 .and. uai
      // Origem (1) NF de Saida (Venda/Bonificacao)
      // Venda = Credito (+)
      // Bonificacao = Credito (-) 
      if lCompara
         cSql  = "insert into " + SetTabela("tsls492") + " ("
      else
         cSql  = "insert into " + SetTabela("tsls451") + " ("
      endif
      cSql += "NUM_NF      ,"
      cSql += "NUMERACAO   ,"
      cSql += "COD_PRO     ,"
      cSql += "PROCOD      ,"
      cSql += "PRODESC     ,"
      cSql += "QT          ,"
      cSql += "PRECO       ,"
      cSql += "DESC_DUP    ,"
      cSql += "VLCONTRATO  ,"
      cSql += "COMISSAO    ,"
      cSql += "VLCOMISSAO  ,"
      cSql += "VLORIGINAL  ,"
      cSql += "COD_LIP     ,"
      cSql += "ORIGEM) values ("
      cSql += str(tmp->NUM_NF)					+ ","
      cSql += str(tmp->NUMERACAO)				+ ","
      cSql += str(tmp->COD_PRO)					+ ",'"
      cSql += alltrim(tmp->PROCODIGO)				+ "','"
      cSql += alltrim(left(tmp->PRODESC,48))			+ "',"
      cSql += str(tmp->QT)					+ ","
      cSql += str(tmp->PRU*tmp->QT,15,5)			+ ","
      cSql += str(tmp->DESCFIN,15,5)				+ ","
      cSql += str(xVlCTR*-1)					+ ","
      cSql += str(iPComissao,15,5)				+ ","
      cSql += str(if(tmp->E_BONIFICA,-1,1)*xVlComissao,15,5)	+ ","
      cSql += str(if(tmp->E_BONIFICA,-1,1)*xVlComissao,15,5)	+ ","
      cSql += str(tmp->COD_LIP)					+ ",1)"
      uai  = rdd_insert(cSql)
      //if !uai; alert(cSql); endif
      if !uai
         cMsg = "[FALHOU] insert Origem(1) do prc(1) verificar querie:"+cSql
         flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log",cMsg)
      endif
   endif

   if tmp->CANC .and. tmp->DT_CANC >= dData1 .and. tmp->DT_CANC <= dData2 .and. uai
      // Origem (2) Cancelamento NF de Saida (Venda/Bonificacao)
      // Venda = Debito (+)
      // Bonificacao = Debito (-)
      if tmp->MTVCOM  // Parametro de abatimento da comissao pelo motivo
         if lCompara
            cSql  = "insert into " + SetTabela("tsls492") + " ("
         else
            cSql  = "insert into " + SetTabela("tsls451") + " ("
         endif
         cSql += "NUM_NF      ,"
         cSql += "NUMERACAO   ,"
         cSql += "COD_PRO     ,"
         cSql += "PROCOD      ,"
         cSql += "PRODESC     ,"
         cSql += "QT          ,"
         cSql += "PRECO       ,"
         cSql += "DESC_DUP    ,"
         cSql += "VLCONTRATO  ,"
         cSql += "COMISSAO    ,"
         cSql += "VLCOMISSAO  ,"
         cSql += "VLORIGINAL  ,"
         cSql += "COD_LIP     ,"
         cSql += "ORIGEM) values ("
         cSql += str(tmp->NUM_NF)				+ ","
         cSql += str(tmp->NUMERACAO)				+ ","
         cSql += str(tmp->COD_PRO)				+ ",'"
         cSql += alltrim(tmp->PROCODIGO)			+ "','"
         cSql += alltrim(left(tmp->PRODESC,48))			+ "',"
         cSql += str(tmp->QT)					+ ","
         cSql += str(tmp->PRU*tmp->QT,15,5)			+ ","
         cSql += str(tmp->DESCFIN,15,5)				+ ","
         cSql += str(xVlCTR)					+ ","
         cSql += str(iPComissao,15,5)				+ ","
         cSql += str(if(tmp->E_BONIFICA,1,-1)*xVlComissao,15,5)	+ ","
         cSql += str(if(tmp->E_BONIFICA,1,-1)*xVlComissao,15,5)	+ ","
         cSql += str(tmp->COD_LIP)				+ ",2)"
         uai = rdd_insert(cSql)
         if !uai
            cMsg = "[FALHOU] insert Origem(2) do prc(1) verificar querie:"+cSql
            flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log",cMsg)
         endif
      endif
   endif

   nCOD_NF   = tmp->COD_NF
   nCOD_VEN  = tmp->COD_VEN
   cRAZAO    = tmp->RAZAO
   cCODFORM  = tmp->CODFORM
   nNUM_NF   = tmp->NUM_NF
   lE_BON    = tmp->E_BONIFICA			// Nota Bonificao *-1
   xCANC     = tmp->CANC			// Nota fiscal Cancelada (debito)
   dCanc     = tmp->DT_CANC			// Data do Cancelamento	 (credito cancelamento)
   dEMISSAO  = tmp->D_EMISSAO			// Data de Emissao da NF (credito)
   cMOTIVO   = tmp->MOTIVO
   lMTVCOM   = if(tmp->CANC.and.tmp->MTVCOM,tmp->MTVCOM,0)
   lABTFRT   = if(tmp->CANC.and.tmp->ABTFRT,tmp->ABTFRT,0)
   nVLFRETE  = tmp->VL_FRETE
   
   xTVLCom  += xVlComissao

   tmp->(dbskip())




   if (dEMISSAO >= dData1 .and. dEMISSAO <= dData2) .and. (tmp->(EOF()) .or. tmp->COD_NF <> nCOD_NF) .and. uai
      flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log","(b.1)"+time()+alltrim(nCOD_NF))
      // Origem (1) NF de Saida (Venda/Bonificacao)
      // Venda = Credito (+)
      // Bonificacao = Credito (-) 
      if lCompara
         cSql  = "insert into " + SetTabela("tsls491") + " ("
      else
         cSql  = "insert into " + SetTabela("tsls450") + " ("
      endif
      cSql += "DATA,COD_VEN,COD_NF,HIST,CODFORM,NUM_NF,CREDITO,ORIGEM) values ('"
      cSql += UsData(dEMISSAO)					+ "',"
      cSql += str(nCOD_VEN)					+ ","
      cSql += str(nCOD_NF)					+ ",'"
      cSql += if(lE_BON,"BONIF:","NFV  :")+left(cRAZAO,44)	+ "','"
      cSql += cCODFORM						+ "',"
      cSql += str(nNUM_NF)					+ ","
      cSql += str(if(lE_BON,-1,1)*xTVLCom,15,5)			+ ",1)"
      uai = rdd_insert(cSql)
      //if !uai; alert(cSql); endif
      if !uai
         cMsg = "[FALHOU] insert na tsls450 do prc(1) verificar querie:"+cSql
         flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log",cMsg)
      endif
      if uai .and. lCompara
         aArray = rdd_cursor("select max(RECNO) from "+SetTabela("tsls491")+" where COD_NF="+str(nCOD_NF)+" and ORIGEM=1")
         xCod491 = aArray[1]

         cSql  = " update "+SetTabela("tsls492")
         cSql += " set COD_491="+str(xCod491)
	 cSql += " where NUM_NF  = "+str(nNUM_NF)
         cSql += "   and COD_491 = 0"
         cSql += "   and ORIGEM  = 1"
         uai = rdd_update(cSql)
         if !uai
            cMsg = "[FALHOU] update na tsls492 do prc(1) verificar querie:"+cSql
            flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log",cMsg)
         endif
      else
         aArray = rdd_cursor("select max(RECNO) from "+SetTabela("tsls450")+" where COD_NF="+str(nCOD_NF)+" and ORIGEM=1")
         xCod450 = aArray[1]

         cSql  = " update "+SetTabela("tsls451")
         cSql += " set COD_450="+str(xCod450)
	 cSql += " where NUM_NF  = "+str(nNUM_NF)
         cSql += "   and COD_450 = 0"
         cSql += "   and ORIGEM  = 1"
         uai = rdd_update(cSql)





      endif
   endif
   if xCANC .and. (dCanc >= dData1 .and. dCanc <= dData2) .and. (tmp->(EOF()) .or. tmp->COD_NF <> nCOD_NF) .and. uai
      // Insere lancamento com data do cancelamento
      if lMTVCOM	// Parametro para abatimento da comissao de acordo com o motivo
         // Origem (2) Cancelamento NF de Saida (Venda/Bonificacao)
         // Venda = Debito (+)
         // Bonificacao = Debito (-)
         if lCompara
            cSql  = "insert into " + SetTabela("tsls491") + " ("
         else
            cSql  = "insert into " + SetTabela("tsls450") + " ("
         endif
         cSql += "DATA,COD_VEN,COD_NF,HIST,CODFORM,NUM_NF,DEBITO,ORIGEM) values ('"
         cSql += UsData(dCanc)					+ "',"
         cSql += str(nCOD_VEN)					+ ","
         cSql += str(nCOD_NF)					+ ",'"
         if month(dEMISSAO) <> month(dData1)
            cSql += "C.MA :"+left(alltrim(cMOTIVO),34)      	+ "-RefMesAnt','"
         else
            cSql += "CANC :"+left(alltrim(cMOTIVO),44)      	+ "','"
         endif            
         cSql += cCODFORM				+ "',"
         cSql += str(nNUM_NF)			+ ","
         //cSql += str(if(lE_BON,-1,1)*xTVLCom,15,5)	+ ",2)"
         cSql += str(if(lE_BON,-1,1)*xTVLCom,15,5)	+ ",2)"
         uai = rdd_insert(cSql)
         if !uai
            cMsg = "[FALHOU] insert na tsls450 do prc(1) verificar querie:"+cSql
            flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log",cMsg)
         endif
         //if !uai; alert(cSql); endif
         if uai .and. lCompara
            aArray = rdd_cursor("select max(RECNO) from "+SetTabela("tsls491")+" where COD_NF="+str(nCOD_NF)+" and ORIGEM=2")
            xCod491 = aArray[1]
            cSql  = " update "+SetTabela("tsls492")
            cSql += " set COD_491="+str(xCod491)
            cSql += " where NUM_NF  = "+str(nNUM_NF)
            cSql += "   and COD_491 = 0 and ORIGEM=2"
            uai = rdd_update(cSql)
            //if !uai; alert(cSql); endif
            if !uai
               cMsg = "[FALHOU] update na tsls492 do prc(1) verificar querie:"+cSql
               flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log",cMsg)
            endif
         else
            aArray = rdd_cursor("select max(RECNO) from "+SetTabela("tsls450")+" where COD_NF="+str(nCOD_NF)+" and ORIGEM=2")
            xCod450 = aArray[1]
            cSql  = " update "+SetTabela("tsls451")
            cSql += " set COD_450="+str(xCod450)
            cSql += " where NUM_NF  = "+str(nNUM_NF)
            cSql += "   and COD_450 = 0 and ORIGEM=2"
            uai = rdd_update(cSql)
            //if !uai; alert(cSql); endif
            if !uai
               cMsg = "[FALHOU] update na tsls451 do prc(1) verificar querie:"+cSql
               flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log",cMsg)
            endif
         endif
      endif
      if lABTFRT
        // Origem (4) Abatimento do Frete da NF devido ao motivo de Cancelamento 
         if lCompara
            cSql  = "insert into " + SetTabela("tsls491") + " ("
         else
            cSql  = "insert into " + SetTabela("tsls450") + " ("
         endif
         cSql += "DATA,COD_VEN,COD_NF,HIST,CODFORM,NUM_NF,DEBITO,ORIGEM) values ('"
         cSql += UsData(dCanc)			+ "',"
         cSql += str(nCOD_VEN)			+ ","
         cSql += str(nCOD_NF)			+ ",'"
         if month(dEMISSAO) <> month(M->Hoje)
            cSql += "FRTMA:"+left(alltrim(cMOTIVO),44)	+ "','"
         else
            cSql += "FRT  :"+left(alltrim(cMOTIVO),44)  + "','"
         endif            
         cSql += cCODFORM				+ "',"
         cSql += str(nNUM_NF)			+ ","
         cSql += str(nVLFRETE,15,5)	+ ",4)"
         uai = rdd_insert(cSql)
         if !uai
            cMsg = "[FALHOU] insert na tsls450 do prc(1) verificar querie:"+cSql
            flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log",cMsg)
         endif
         //if !uai; alert(cSql); endif
      endif
   endif
   if ((dEMISSAO >= dData1 .and. dEMISSAO <= dData2) .and. (tmp->(EOF()) .or. tmp->COD_NF <> nCOD_NF)) .or. (xCANC .and. (dCanc >= dData1 .and. dCanc <= dData2) .and. (tmp->(EOF()) .or. tmp->COD_NF <> nCOD_NF)) .and. uai
      xTVLCom = 0 			// Zerar valor da comissao
   endif
end
FechaRS("tmp")
endif


/// AQUI
RETURN(uai)

////////////////////////////////////
FUNCTION fiPComRCAG(pSls040,pAg,pRC)
////////////////////////////////////
local cSql    := ""
local aArray  := {}
local nPorc   := 0

cSql  = " select nPorc "
cSql += "   from "+SetTabela("tsls490")
cSql += "  where pMet = "+alltrim(pSls040)
cSql += "    and pAg  = "+alltrim(pAg)
cSql += "    and pRC  = "+alltrim(pRC)
aArray = rdd_select(cSql)
if len(aArray)>0 .and. valtype(aArray[1])="N".and. aArray[1]>0
   nPorc = aArray[1]
endif
RETURN(nPorc)

////////////////////////////////////
FUNCTION fiPComRAG(pSls040,pAg,pRep)
////////////////////////////////////
local cSql    := ""
local aArray  := {}
local nPorc   := 0

cSql  = " select nPorc "
cSql += "   from "+SetTabela("tsls490")
cSql += "  where pMet = "+alltrim(pSls040)
cSql += "    and pAg  = "+alltrim(pAg)
cSql += "    and pRep = "+alltrim(pRep)
aArray = rdd_select(cSql)
if len(aArray)>0 .and. valtype(aArray[1])="N".and. aArray[1]>0
   nPorc = aArray[1]
endif
RETURN(nPorc)

*******************
FUNCTION fCOMPrc2()
*******************
local i
local xVlComissao := 0
local xSdo 	  := 0
local nCOD_NF	  := 0
local nCOD_VEN    := 0
local cRAZAO      := ""
local nNUM_NF     := 0			// Numero da Nota fiscal
local xTVLCom     := 0 			// Valor total da comissao
local xVlCTR      := 0			// Valor Contrato para a linha da NF
local dINPUT      := ctod("  /  /  ")


// Excluir Movimentos de Origem (1,2) do Conta corrente de comisses
if lCompara
   cSql  = " select RECNO from "+SetTabela("tsls491")
else
   cSql  = " select RECNO from "+SetTabela("tsls450")
endif
cSql += " where DATA >= '"+UsData2(dData1)+"'"
cSql += "   and DATA <= '"+UsData2(dData2)+"'"
//cSql += "   and COD_VEN in (26)  "	// AQUI
cSql += "   and FECHADO = 0 "
cSql += "   and ORIGEM = 3 "
//cSql += "   and COD_ven in (167,145,68) "
aArray = rdd_select(cSql)
for i=1 to len(aArray)
   if uai
      uai = rdd_delete("delete from "+if(lCompara,Settabela("tsls492"),Settabela("tsls451"))+" where "+if(lCompara,"COD_491=","COD_450=")+str(aArray[i]))
   uai = rdd_delete("delete from "+if(lCompara,SetTabela("tsls492"),SetTabela("tsls451"))+" where "+if(lCompara,"COD_491=","COD_450=")+str(aArray[i]))
   endif
   if uai
      uai = rdd_delete("delete from "+if(lCompara,Settabela("tsls491"),Settabela("tsls450"))+" where RECNO="+str(aArray[i]))
   endif
   if !uai
      exit
   endif
next

/// AQUI



if !uai
   cMsg = "[FALHOU] delete do prc(2) verificar querie:"+cSql
   flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log",cMsg)
endif
i=0
if uai
//if .f.

cSql  = " select count(*) "
cSql += " from "+SetTabela("tsls403")+" a,"
cSql +=          SetTabela("tsls019")+" c,"
cSql +=          SetTabela("tsls018")+" e "
cSql += " where c.RECNO = a.COD_CLI "
cSql += "   and e.RECNO = a.COD_VEN "
//cSql += "   and a.COD_VEN in (26)  "	// AQUI
cSql += "   and a.FECHADO = 1 "
cSql += "   and a.D_INPUT >= '"+UsData2(dData1)+"' and a.D_INPUT <= '"+UsData2(dData2)+"'"
aArray = rdd_cursor(cSql)
iTotal = aArray[1]

// Selecao principal das NF de Saida cujo Tipo padrao de Ordem e/Representante calcula Comissao
cSql  = " select a.D_INPUT,a.NUM_NF,a.COD_VEN,e.DCTR,c.CLIENTE,b.COD_PRO,b.QT,b.PRU,b.PCOMISSAO,d.CODIGO,d.PRODUTO,b.COD_NFD,d.COD_AG,e.COD_REG,e.TCOM,b.RECNO"
cSql += " from "+SetTabela("tsls403")+" a,"
cSql +=          SetTabela("tsls404")+" b,"
cSql +=          SetTabela("tsls019")+" c,"
cSql +=          SetTabela("titm002")+" d,"
cSql +=          SetTabela("tsls018")+" e "
cSql += " where a.RECNO = b.COD_NFD "
cSql += "   and c.RECNO = a.COD_CLI "
cSql += "   and d.RECNO = b.COD_PRO "
cSql += "   and e.RECNO = a.COD_VEN "
//cSql += "   and a.COD_VEN in (26) "	// AQUI
cSql += "   and a.FECHADO = 1 "
cSql += "   and a.D_INPUT >= '"+UsData2(dData1)+"' and a.D_INPUT <= '"+UsData2(dData2)+"'"
cSql += "  order by b.COD_NFD "
AbreRS(cSql,"tmp")
nCOD_NF = tmp->COD_NFD

while !tmp->(EOF()) .and. uai
   iModelo = tmp->TCOM

   // Abater os Valores de contrato do tipo A/F automatico (fora desconto financeiro)
   cSql  = " select sum(b.VALOR) "
   cSql += " from " + SetTabela("tctr012")+" a,"
   cSql +=            SetTabela("tctr015")+" b,"
   cSql +=            SetTabela("tctr011")+" c "
   cSql += " where a.RECNO     = b.COD_CTR12 "
   cSql += "   and c.RECNO     = b.COD_CTR11 "
   cSql += "   and a.COD_403   = "+str(tmp->COD_NFD)
   cSql += "   and b.COD_404   = "+str(tmp->(RECNO()))
//   cSql += "   and c.TIPO_COBR <> 3 "		// rbm.05Nov2010
   cSql += "   and a.ORIGEM    =  5 "
   if tmp->DCTR
      aArray = rdd_cursor(cSql)
      xVlCTR = if(!empty(aArray[1]),aArray[1],0)
   else
      xVlCTR=0
   endif
   
   //iPComissao = 0
   //if iModelo = 1 // por Lista de Preco
   //   iPComissao = tmp->PCOMISSAO
   //elseif iModelo = 2 // por MAG
   //   iPComissao = fiPComRCAG(pSls040,tmp->COD_AG,tmp->COD_REG)
   //endif

   iPComissao  = 0
   xVlComissao = 0
   //1-RegCom/AG
   //2-MBruta (RegCom/RegCom+AG)
   //3-MBruta (RegCom/Representante+AG)
   //4-Por lista de Preco
   if iModelo = 1       // RegCom/AG
      iPComissao  = fiPComRCAG(pSls040,tmp->COD_AG,tmp->COD_REG)
      xVlComissao = round((tmp->PRU*tmp->QT)*iPComissao/100,2)
   elseif iModelo = 2   // MBruta (RegCom/RegCom+AG)
      iPComissao  = fiPComM2(pSls040,tmp->COD_REG,tmp->COD_VEN,tmp->COD_AG)
      xVlComissao = round(((tmp->PRU*tmp->QT-(xVlCTR))*iPComissao/100),2)
   elseif iModelo = 3   // MBruta (RegCom/Representante+AG)
      iPComissao  = fiPComM3(pSls040,tmp->COD_REG,tmp->COD_VEN,tmp->COD_AG)
      xVlComissao = round(((tmp->PRU*tmp->QT-(xVlCTR))*iPComissao/100),2)
   elseif iModelo = 4   // por Lista de Preo
     //   iPComissao  = tmp->COMISSAO
     //   xVlComissao = round((tmp->PRU*tmp->QT)*iPComissao/100,2)
   endif

   // Pypado em 09/Feb/2009
   //xVlComissao    = Truncar2D((Truncar2D(tmp->PRU)*tmp->QT-xVlCTR)*iPComissao/100) // (-) CTR RN tp A/F auto (fora dfin)

   // 09/Feb/2009
   //xVlComissao    = Truncar2D((Truncar2D(tmp->PRU)*tmp->QT)*iPComissao/100) // (-) CTR RN tp A/F auto (fora dfin)

   // Origem (3) Devolucoes de Vendas
  // Devolucoes - Saida (debito) (+)

   if lCompara
      cSql  = "insert into " + SetTabela("tsls492") + " ("
   else
      cSql  = "insert into " + SetTabela("tsls451") + " ("
   endif
   cSql += "NUM_NF      ,"
   cSql += "NUMERACAO   ,"
   cSql += "COD_PRO     ,"
   cSql += "PROCOD      ,"
   cSql += "PRODESC     ,"
   cSql += "QT          ,"
   cSql += "PRECO       ,"
   cSql += "DESC_DUP    ,"
   cSql += "VLCONTRATO  ,"
   cSql += "COMISSAO    ,"
   cSql += "VLCOMISSAO  ,"
   cSql += "VLORIGINAL  ,"
   cSql += "ORIGEM) values ("
   cSql += str(tmp->NUM_NF)		        + ",0,"
   cSql += str(tmp->COD_PRO)		        + ",'"
   cSql += alltrim(tmp->CODIGO)			+ "','"
   cSql += alltrim(left(tmp->PRODUTO,48))	+ "',"
   cSql += str(tmp->QT)				+ ","
   cSql += str(tmp->PRU*tmp->QT,15,5)		+ ",0,"
   cSql += str(xVlCTR)				+ ","
   cSql += str(iPComissao,15,5)	                + ","
	//RBM/FHP 04/Sep/2013
   cSql += str(xVlComissao*-1,15,5)	        + ","
   cSql += str(xVlComissao*-1,15,5)	        + ",3)"
   uai  = rdd_insert(cSql)
   if !uai
      cMsg = "[FALHOU] insert do prc(2) verificar querie:"+cSql
      flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log",cMsg)
   endif
   //if !uai; alert(cSql); endif

   nCOD_NF   = tmp->COD_NFD
   nCOD_VEN  = tmp->COD_VEN
   cRAZAO    = tmp->CLIENTE
   nNUM_NF   = tmp->NUM_NF
   dINPUT    = tmp->D_INPUT			// Data da entrada da NF
   
   xTVLCom  += xVlComissao

   tmp->(dbskip())





   if (tmp->(EOF()) .or. tmp->COD_NFD <> nCOD_NF) .and. uai
     // Origem (1) NF de Saida (Venda/Bonificacao)
    // Devolucao de Saidas = Debito (+)
      if lCompara
         cSql  = "insert into " + SetTabela("tsls491") + " ("
      else
         cSql  = "insert into " + SetTabela("tsls450") + " ("
      endif
      cSql    += "DATA,COD_VEN,COD_NFD,HIST,NUM_NF,DEBITO,ORIGEM) values ('"
      cSql    += UsData(dINPUT)                  + "',"
      cSql    += str(nCOD_VEN)                   + ","
      cSql    += str(nCOD_NF)	                 + ",'"
      cSql    += "DEV  :" + left(cRAZAO,44)      + "',"
      cSql    += str(nNUM_NF)                    + ","
      cSql    += str(xTVLCom)	                 + ",3)"
      uai      = rdd_insert(cSql)
      if !uai
         cMsg = "[FALHOU] insert do prc(2) verificar querie:"+cSql
         flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log",cMsg)
      endif
      //if !uai; alert(cSql); endif
      if uai
         if lCompara
            aArray = rdd_cursor("select max(RECNO) from "+SetTabela("tsls491")+" where COD_NFD="+str(nCOD_NF)+" and ORIGEM=3")
            xCod491 = aArray[1]

            cSql  = " update "+SetTabela("tsls492")
            cSql += " set COD_491="+str(xCod491)
            cSql += " where NUM_NF  = "+str(nNUM_NF)
            cSql += "   and COD_491 = 0"
            cSql += "   and ORIGEM  = 3"
            uai = rdd_update(cSql)
         else
            aArray = rdd_cursor("select max(RECNO) from "+SetTabela("tsls450")+" where COD_NFD="+str(nCOD_NF)+" and ORIGEM=3")
            xCod450 = aArray[1]

            cSql  = " update "+SetTabela("tsls451")
            cSql += " set COD_450="+str(xCod450)
            cSql += " where NUM_NF  = "+str(nNUM_NF)
            cSql += "   and COD_450 = 0"
            cSql += "   and ORIGEM  = 3"
            uai = rdd_update(cSql)
         endif
      endif
      xTVLCom = 0 			// Zerar valor da comissao
   endif
end
FechaRS("tmp")
endif


RETURN(uai)

*******************
FUNCTION fCOMPrc3()
*******************
if uai

   cSql  = " select COD_VEN,sum(CREDITO-DEBITO) "
   cSql += " from " + SetTabela("tsls450")
   cSql += " where FECHADO = 0 "
   cSql += " group by COD_VEN "
   local aArray := rdd_cursor(cSql)
   for i=1 to len(aArray) step 2
      xSdo = aArray[i+1]
      cSql = "update " + SetTabela("tsls018") + " set SALDO = " + str(aArray[i+1]) + " where RECNO = " + str(aArray[i])
      uai  = rdd_update(cSql)
      //if !uai; alert(cSql); endif
      if !uai
         cMsg = "[FALHOU] update do prc(3) verificar querie:"+cSql
         flBAS_GravaLog("/qtux/logs/jobs/comissao"+alltrim(spCia)+".log",cMsg)
      endif
      if !uai
         exit
      endif
   next
endif
RETURN(uai)

*************************************************
FUNCTION fLOGCRON(cPROC,dDTI,xHRI,dDTF,xHRF,lUAI)
*************************************************
// Usar esta funcao aps o fSQLCommit do processo
local uai := rdd_insert("insert into "+SetTabela("tsis200")+" (PROCESSO,DTI,HRI,DTF,HRF,UAI) values ('"+alltrim(cPROC)+"','"+UsData(dDTI)+"','"+xHRI+"','"+UsData(dDTF)+"','"+xHRF+"',"+if(lUai,"1","0")+")")
//rdd_commit()
RETURN(.t.)

FUNCTION flBAS_GravaLog(psFile,psMsg)
/////////////////////////////////////
local iFile
if file(psFile)
   while .t.
      iFile=fopen(psFile,2)
      if iFile>=0
         fseek(iFile,0,2)
         exit
      endif
   end
else
   iFile=fcreate(psFile,666)
endif
fwrite(iFile,psMsg+chr(10))
fclose(iFile)
RETURN(.t.)


**********************************************

********************
FUNCTION Variaveis()
********************
PUBLIC      p_COLOR                  :=  if( pcount() >= 1 , upper(p_COLOR) , "COLOR")
PUBLIC      rest_D                   := { | |  restscreen(0,0,maxrow(),maxcol(),D()),.f.}
PUBLIC      v_inc_box                := ""
PUBLIC      cns_cod_fir              := 2
PUBLIC      cns_menu                 := ""
PUBLIC      sns_menu                 := ""              
PUBLIC      cns_lin                  := 0               
PUBLIC      cns_alt                  := 0              
PUBLIC      mChaveAtual              := 0
PUBLIC      cns_chave                := ""              
PUBLIC      cns_c_chave              := ""              
PUBLIC      cns_len_variavel         := 30        
PUBLIC      cns_nrcp                 := 0
PUBLIC      cns_vNrCp[15]
PUBLIC      cns_LenVetor[10]
afill(cns_LenVetor,0)
PUBLIC      cns_CCSql                := ""
PUBLIC      cns_rddnrcp              := 0
PUBLIC      cns_m_nrop               := 0           
PUBLIC      cns_msg                  := ""           
PUBLIC      cns_marcacao             := .f.         
PUBLIC      cns_strmarcados[10]
PUBLIC      cns_quem                 := ""         
PUBLIC      cns_VQuem[10]
PUBLIC      cns_Col1Ordenada         := 0
PUBLIC      cns_Col2Ordenada         := 0
PUBLIC      cns_Col3Ordenada         := 0
PUBLIC      cns_rddSql               := ""
PUBLIC      cns_AtualIndice          := 0
PUBLIC      cns_rddEdicaoSql         := ""
PUBLIC      cns_Esc                  := .f.
PUBLIC      cns_Inc                  := .f.
PUBLIC      cns_IncNr0               := .f.
PUBLIC      cns_kVetor[10]
afill(cns_kVetor,0)
PUBLIC      cns_nVetor               := 33
PUBLIC      cns_BG[10]
afill(cns_BG,.f.)
PUBLIC      cns_rddindicevetor       := 1
PUBLIC      xns_rddindicevetor[10]
PUBLIC      cns_rddnr                := 0
PUBLIC      cns_order                := 0
PUBLIC      cns_old_order            := 0
PUBLIC      cns_tela                 := .f.       
PUBLIC      cns_mneumonico           := ""
PUBLIC      cns_gets                 := 0     
PUBLIC      cns_exc_at               := ""   
PUBLIC      cns_txt                  := .t. 
PUBLIC      cns_lx                   := 0
PUBLIC      cns_ly                   := 0             
PUBLIC      cns_D_X                  := 0             
PUBLIC      cns_D_Y                  := 0             
PUBLIC      cns_sub_menu             := 0             
PUBLIC      cns_sub_main             := 0             
PUBLIC      pre_tit                  := ""             
PUBLIC      pre_Nr0                  := ""            
PUBLIC      pre_MENSNr0              := ""            
PUBLIC      pre_CHEIA                := .t.
PUBLIC      cns_Tabela               := ""
PUBLIC      cns_FraseMenu            := ""
PUBLIC      cns_cCoringa             := ""
PUBLIC      cns_dCoringa             := ctod("  /  /  ")
PUBLIC      cns_iCoringa             := 0
PUBLIC      cns_TMP1
PUBLIC      cns_TMP2
PUBLIC      cns_TMP3
PUBLIC      cns_TMP4
PUBLIC      cns_TMP5
PUBLIC      cns_TMP6
PUBLIC      cns_TMP7
PUBLIC      mn                       := 1            
PUBLIC      mn_main                  := 1            
PUBLIC      main_x                   := 0            
PUBLIC      main_y                   := 0            
PUBLIC      primeiro_reg_da_pagina   := 1
PUBLIC      m_cns_t                  := 0
PUBLIC      m_linha_do_cursor        := 1
PUBLIC      m_cns_sele               :=.f.
PUBLIC      l_l                      := 0
PUBLIC      quem_chama               := ""
PUBLIC      p_quem_chama             := ""
PUBLIC      x_FIRMA                  := ""
PUBLIC      x_COD_FIR                := ""
PUBLIC      x_TEL                    := ""
PUBLIC      x_FAX                    := ""
PUBLIC      x_END                    := ""
PUBLIC      x_CIDADE                 := ""
PUBLIC      x_UF                     := ""
PUBLIC      x_IE                     := ""
PUBLIC      x_CGC                    := ""
PUBLIC      x_SEG_IMP                := .f.
PUBLIC      zoo_status               := "EA"
PUBLIC      dData1                   := date()+1461
PUBLIC      dData2                   := date()+1461
PUBLIC      w_VLR1                   := 0
PUBLIC      w_VLR2                   := 0
PUBLIC      esc_original             := ""
PUBLIC      senha_quem_e             := space(6)
PUBLIC      quem_e                   := ""
PUBLIC      cod_quem_e               := 0
PUBLIC      m_NETUNO                 := "NETUNO"
PUBLIC      _23_rodape               := ""
PUBLIC      _24_rodape               := ""
PUBLIC      cot                      := 0
PUBLIC      OldCot                   := 0
PUBLIC      CotTempoEstimado         := 0
PUBLIC      CotTempoInicial          := ""
PUBLIC      auto_sair                := .f.
PUBLIC      coluna_da_regua          := 15
PUBLIC      chamada_a_tela           := ""
PUBLIC      ZOO_ALT                  := ""
PUBLIC      ZOO_NAVEGANDO            := .f.
PUBLIC      gc                       := 0
PUBLIC      iTotalTelas              := 0
PUBLIC      iTelaAtual               := 0
PUBLIC      oiTelaAtual              := 0
PUBLIC      lConfigMenu              := .f.
PUBLIC      cDBT                     := ""
PUBLIC      d_ESP                    :=   "E s p e r e"
PUBLIC      d_IMP                    :=   "I m p r i m i n d o"
PUBLIC      d_GRA                    :=   "G r a v a n d o"
PUBLIC      m_NAO_CONTAS             :=   "Nao ha' Contas no periodo ..."
PUBLIC      m_NAO_VENDAS             :=   "Nao ha' Vendas no periodo ..."
PUBLIC      m_IMP_CANC               :=   "Impressao cancelada pelo usuario ..."
PUBLIC      d_FICHA                  := "<Enter> e <"+chr(25)+"> prox. campo, <"+chr(24)+"> anterior, <-"+chr(16)+chr(17)+"-> dentro do campo, <Esc> desiste"
PUBLIC      d_FICHAEDICAO            := "<PgUP> e <PgDn> Navega, <F3> Exclui, <F4> Altera, <Esc> Encerra"
PUBLIC      xov_ovctrl               := .f.
PUBLIC      m_COD_G_U                := 0
PUBLIC      m_COD_USU                := 0
PUBLIC      LocAconselha             := 1
PUBLIC      LocDevolucao             := 2
PUBLIC      LocInspecao              := 3
PUBLIC      LocRecebimento           := 4
PUBLIC      LocRejeito               := 5
PUBLIC      LocPerda                 := 6
PUBLIC      UA                       := ""
PUBLIC      vChaveAtual[10]
afill(vChaveAtual,0)
PUBLIC      vCns_Inc[10]
afill(vCns_Inc,.f.)
PUBLIC     cns_TabelaCopCol          := ""
PUBLIC     cns_RecnoCopCol           := 0
RETURN(0)

*****************
FUNCTION Pilhas()
*****************
PUBLIC   CNS_PILHA[240]
PUBLIC   CNS_TOPO_PILHA  := 0
PUBLIC   V_PILHA[300]
PUBLIC   TOPO_PILHA      := 0
RETURN(0)


*********************
FUNCTION SetTabela(s)
*********************
local aArray := {}
local uai    := ""
s = alltrim(s)
if !empty(at("TSYS",upper(s)))
   uai = "01"
else
   aArray      = rdd_select("select CIA,RECNO from tbas00501 where COD_FIR = " + str(cns_cod_fir) + " and TABELA = '" + alltrim(upper(s)) + "'")
   if empty(aArray)
      alert("erro do SetTabela - " + s)   
      uai = aArray[1]
   else
      uai = aArray[1]
   endif
*   last_Tabela = s
*   last_CIA    = uai
endif
RETURN(s+uai)

*************************************************
FUNCTION fSQLCommit(uai,lOkMensagem,lNokMensagem)
*************************************************
if pcount()<2
*   lOkMensagem=.t.
   lOkMensagem=.f.
endif
if pcount()<3
   lNokMensagem=.t.
endif
if uai
   rdd_commit()
   //rdd_rollbck() // AQUI
   *** ATENCAO
   if lOkMensagem; Tat("Processo executado com sucesso ...",.t.); endif

else
   rdd_rollbck()
   if lNokMensagem; Tat("Problemas na execucao do processo ...",.t.); endif
endif
RETURN(.t.)

***************
*
FUNCTION D1aD2()
****************
local a
E(setcolor(cor_rodape))
@ maxrow()-1,0 clear
a = "Qual o Intervalo de Datas ?"
@ maxrow()-1,(maxcol()+1-len(a))/2 say a
dData1 = m->Hoje
dData2 = m->Hoje
@ maxrow(),28 get dData1  
@ maxrow(),43 get dData2 valid if(lastkey()=5,.t.,dData2 >= dData1 .or. !tat("Intervalo de datas invalido ..."))
a = Pega()
setcolor(D())
RETURN(a)

************************************************
FUNCTION Mens(pLinhaClear,pLinhaMens,pMens,pCor)
************************************************
E(setcolor())
if pcount() >= 4
   setcolor(pCor)
else
   setcolor(cor_rodape)
endif
@ pLinhaClear,0 clear
@ pLinhaMens ,(maxcol()+1-len(pMens))/2 say pMens
setcolor(D())
RETURN(.t.)


*******************
FUNCTION UsData(d_)
*******************
local uai
if empty(d_)
   uai = "null"
else
   uai = substr(dtos(d_),5,2) + "/" + right(dtos(d_),2) + "/" + left(dtos(d_),4)
endif   
Return(uai)

********************
FUNCTION UsData2(d_)
********************
local uai
if empty(d_)
   uai = "null"
else
   uai = alltrim(right(dtos(d_),2)) + "-" + left(upper(cmonth(d_)),3) + "-" + left(dtos(d_),4)
   if left(uai,1) = "0"
      uai = right(uai,len(uai)-1)
   endif      
endif   
Return(alltrim(uai))

****************************
FUNCTION AbreRS(pSql,pAlias)
****************************
E(select())
ResultSet(pSql,pAlias)
Return(.t.)

************************
FUNCTION FechaRS(pAlias)
************************
sele &pAlias
use
select(D())
Return(.t.)

**************************
FUNCTION tat(p_mens,p_box)
    && p_box = .t. -> centro da dela, .f. -> rodape = default
**************************
local a,i
p_box = if(pcount() <= 1,.f.,p_box)
E(setcolor(cor_rodape))
if !p_box 
   E(savescreen(maxrow()-1,0,maxrow(),maxcol()))
   Mens(maxrow()-1,maxrow(),p_MENS+" tecle alguma tecla")
   inkey(0)
   restscreen(maxrow()-1,0,maxrow(),maxcol(),D())
else
   E(savescreen(0,0,maxrow(),maxcol()))
   setcolor(cor_janela)
   @ 01,00,maxrow(),maxcol() BOX chr(176)+chr(176)+chr(176)+chr(176)+chr(176)+chr(176)+CHR(176)+CHR(176)+chr(176)
   setcolor(cor_rodape)
   i = at("^",p_mens) 
   if !empty(i)
      @ 10,5 clear to 16,74
      @ 10,5 to 16,74
      a = left(p_mens,i-1)
      @ 12,(maxcol()+1-len(a))/2 say a
      a = right(p_mens,len(p_mens)-i)
      @ 13,(maxcol()+1-len(a))/2 say a
      a = "Tecle alguma tecla para continuar"
      @ 15,(maxcol()+1-len(a))/2 say a
   else
      @ 10,5 clear to 15,74
      @ 10,5 to 15,74
      a = p_mens
      @ 12,(maxcol()+1-len(a))/2 say a
      a = "Tecle alguma tecla para continuar"
      @ 14,(maxcol()+1-len(a))/2 say a
   endif
   a = inkey(0)
   restscreen(0,0,maxrow(),maxcol(),D())
endif
keyboard chr(32)
inkey()
setcolor(D())
RETURN(.t.)

***************************
FUNCTION Truncar2D(rNumero)
***************************
local uai := 0
if rNumero > 0
   uai = round(rNumero-0.0049,2)
endif   
RETURN(uai)

*******************
**********************************************************************************
FUNCTION E(p_1COISA,p_2COISA,p_3COISA,p_4COISA,p_5COISA,p_6COISA,p_7COISA,p_8COISA,p_9COISA,p_10COISA)
*******************
**********************************************************************************
local a,i
V_PILHA[++topo_pilha] = p_1COISA
if pcount() > 1
   V_PILHA[++topo_pilha] = p_2COISA
endif
if pcount() > 2
   V_PILHA[++topo_pilha] = p_3COISA
endif
if pcount() > 3
   V_PILHA[++topo_pilha] = p_4COISA
endif
if pcount() > 4
   V_PILHA[++topo_pilha] = p_5COISA
endif
if pcount() > 5
   V_PILHA[++topo_pilha] = p_6COISA
endif
if pcount() > 6
   V_PILHA[++topo_pilha] = p_7COISA
endif
if pcount() > 7
   V_PILHA[++topo_pilha] = p_8COISA
endif
if pcount() > 8
   V_PILHA[++topo_pilha] = p_9COISA
endif
if pcount() > 9
   V_PILHA[++topo_pilha] = p_10COISA
endif
RETURN(.t.)

************
FUNCTION D
()


**********
**
RETURN(V_PILHA[topo_pilha--])

*****************
FUNCTION Pega(p_)
*****************
   p_ = if(pcount()=0,.t.,p_)
   readinsert(.f.)
*   set key 22 to InsereOnOff
   if p_
      set esca on
   endif
   set conf on
   set curs on
   read
   set esca off
   set conf off
   set curs off
   set key 22 to
RETURN(!lastkey()=27)

*******************************
FUNCTION ResultSet(pSql,pAlias)
******************
*************
local lReturn
if pcount() < 2
   pAlias = "CNS"
endif
ExecSql(pSql) Alias pAlias New Get lReturn
RETURN(.t.)

*********************
FUNCTION CURSESINIT()
*********************
call fgsUse4html
RETURN
