function fLRCalcSimFrt(pSls017,pRot009,iORot004,iRot004,cRange,iTipo,aCli,iCodOC)
/////////////////////////////////////////////////////////////////////////////////
// iTipo = 1 (Entrega), iTipo = 2 (Reentrega), iTipo = 3 (Devolucao)
if pCount() > 7 .and. iTipo <> 2 .and.iCodOC > 0
   iTipo = 3
endif

local iRot005    := 0
local iRot007    := 0
local iRot008    := 0
local aFrete     := {}
local aArray     := {}
local iPRTon     := 0			// Preo Range Tonelagem
local iPorcNF    := 0			// Valor da Porcentagem sobre o valor da NF/Mercadoria
local iTaxEnt    := 0			// Tax.Entrega
local iPedagio   := 0			// Pedagio
local iSecCat    := 0 			// SecCat
local iPFechado  := 0			// Preco Fechado
local iAdValorem := 0
local iGris      := 0
local iTarMinima := 0
local iPrKM      := 0
local iPrEnt     := 0
local iPrRangeKm := 0
local iDespacho  := 0
local iITR       := 0
local iPrMin     := 0
local iPdgKg     := 0
local iPrKg      := 0
local iVlFracao  := 0
local iIcms      := 0
local iFrete     := 0
local iFretePM   := 0
local iIcmsPM    := 0
local sCep       := ""
local iVol       := 0
local iPeso      := 0
local iVLib      := 0
local iVol2      := 0
local iPeso2     := 0
local iVLib2     := 0
local iKm        := 0
local iEntregas  := 0
local iBC        := 0

local iCalcR := 0
local lCalcR := .t.
local aO     := {}
local aC     := {}


//  1 iVol	  - Volumes Transportados
//  2 iPeso	  - Peso Transportado
//  3 iVLib	  - Valor Liberado
//  4 iEntregas	  - Nmero de Entregas
//  5 iPRTon	  - Valor por range de Tonelada
//  6 iPorcNF	  - Valor da Porcentagem sobre o valor da NF (iVLib/100*frete->nPorcNF)
//  7 ipPorcNF	  - Parametro [%] da NF frete->nPorcNF
//  8 iTaxEnt	  - Valor da Taxa de Entrega
//  9 iPedagio	  - Valor do Pedagio
// 10 iPdgKg      - Valor do Pedagio por Kg (frete->nPdgKG*iPeso)
// 11 ipPdgKg     - Parametro Valor do Pedagio por KG frete->nPdgKG
// 12 iSecCat	  - Valor do SecCat
// 13 iPFechado	  - Valor do Preco de Fechado
// 14 iAdValorem  - Valor da Ad Valorem (iVLib/100*frete->nAdValor)
// 15 ipAdValorem - Parametro [%] Porcentagem do AdValores frete->nAdValor
// 16 iGris	  - Valor do iGris se menor do que a Tarifa Minina (iVLib/100*frete->nGris)
// 17 ipGris	  - Parametro [%] Porcentagem do Gris frete->nGris
// 18 iTarMinima  - Valor da Tarifa Minima se maior do que o gris
// 19 iPrKM	  - Valor do Preco por Km (frete->nPrKM*iKm)
// 20 ipPrKM	  - Parametro [$] Valor do Preo por Km frete->nPrKm
// 21 iPrEnt	  - Valor da(s) Entregas (frete->nPrEnt*iEntregas)
// 22 ipPrEnt     - Parametro [$] Valor por Entrega
// 23 iPrRangeKm  - Valor por range de Km

// 24 iDespacho	  - Valor do Despacho
// 25 iITR	  - Valor do ITR
// 26 iPrKg	  - Valor por Kg	(frete->nPrKg*iPeso)
// 27 ipPrKg	  - Parametro Preco por Kg frete->nPrKg
// 28 IPFRACAO    - Parametro Fracao
// 29 IPVLFRACAO  - Parametro Valor por Fracao
// 30 IVLFRACAO   - Valor por fracao
// 31 iIcms	  - Valor do ICMS calculado sobre a soma dos valores subtraido pedagio
// 32 ipIcms	  - Porcentagem de ICMS frete->nIcms
// 33 iFrete	  - Soma dos valores + ICMS

// 34 iFretePM	  - Valor do Frete quando iFrete < frete->nPrMin. Se refere ao Preco minimo acrescido do ICMS.
// 35 inPrMin	  - Valor do preco Mnimo frete->nPrMin
// 36 iIcmsPM	  - Valor do ICMS sobre o Preo Minimo (iFretePM/100*frete->nIcms)
// 37 ipIcmsPM	  - frete->nIcms

// 38 iFrtSim     - Se iFretePM > 0 , iFretePM, se no, iFrete. Valor Final do Frete simulado.

// 39 ijtpOper    - tipode Operacao
// 40 pRot008     - Chave da Tabela (se em branco  pq foi editada)
// 41 iKm	  - Km por Cep

local iQtCli  := len(aCli)
local sCli    := ""
if len(aCli)>0 // Pode ser tabela por cliente.
   sCli = "("
   for i=1 to len(aCli)
      sCli += alltrim(aCli[i])+","
   next
   sCli = left(sCli,len(sCli)-1)+")"
   cSql  = " select a.RECNO "
   cSql += " from "+SetTabela("trot008")+" a,"
   cSql +=          SetTabela("trot007")+" b "
   cSql += "   where b.pORot004 = "+alltrim(iORot004)		// por Rota de Origem
   cSql += "     and b.pDRot004 = "+alltrim(iRot004)		// por Rota Destino
   cSql += "     and a.pRot007  = b.recno"
   cSql += "     and a.pRot009  = "+alltrim(pRot009)		// Por Tipo de Veculo (Agregado)
   cSql += "     and a.jTpOper  = "+alltrim(if(iTipo=3,1,iTipo)) /// Por Tipo de Operacao (Entrega/Reentrega)
   AbreRS(cSql,"tabcli")
   while !tabcli->(eof())
      cSql  = " select count(*) "
      cSql += " from "+SetTabela("trot025")
      cSql += " where pRot008="+alltrim(tabcli->(RECNO()))
      cSql += " and pSls019 in "+sCli
      aArray=rdd_cursor(cSql)
      if iQtCli = aArray[1] // todos os clientes estao presentes na lista em questao.
         iRot008 = tabcli->(RECNO())
         exit
      endif
      tabcli->(dbskip())
   end
   FechaRS("tabcli")
endif

// Busca tabela para o tipo de veculo ou transportadora.
cSql  = "select a.nPorcNF	,"
cSql +=       " a.nTaxEnt	,"
cSql +=       " a.nPedagio	,"
cSql +=       " a.nSecCat	,"
cSql +=       " a.nPrFec	,"
cSql +=       " a.nAdValor	,"
cSql +=       " a.nGris		,"
cSql +=       " a.nTarMin	,"
cSql +=       " a.nPrKM		,"
cSql +=       " a.nPrEnt	,"
cSql +=       " a.nDespacho	,"
cSql +=       " a.nITR		,"
cSql +=       " a.nPrMin	,"
cSql +=       " a.nPdgKg	,"
cSql +=       " a.nPrKg     	," 
cSql +=       " a.nIcms		," 
cSql +=       " a.nFracao       ,"	// Testar com Adriana o Algortimo.
cSql +=       " a.nVlFracao     ,"
cSql +=       " a.recno	iRot008	,"
cSql +=       " b.recno iRot007 ,"
cSql +=       " a.recno          "
cSql += " from "+SetTabela("trot008")+" a,"
cSql +=          SetTabela("trot007")+" b "
cSql += "   where b.pORot004 = "+alltrim(iORot004)		// por Rota de Origem
cSql += "     and b.pDRot004 = "+alltrim(iRot004)		// por Rota Destino
cSql += "     and a.pRot007  = b.recno"
if pRot009>0 .and. pSls017>0					// por Tipo de Veculo e Transportadora
   cSql += "     and a.pRot009  = "+alltrim(pRot009)
   cSql += "     and a.pSls017  = "+alltrim(pSls017)		
elseif pRot009=0 .and. pSls017>0				// por Transportadora
   cSql += "     and a.pSls017  =  "+alltrim(pSls017)
   cSql += "     and a.pRot009  = 0"
elseif pRot009>0 .and. pSls017=0 .and. iRot008 = 0		// Por Tipo de Veculo (Agregado) 
   cSql += "     and a.pRot009  =   "+alltrim(pRot009)
   cSql += "     and a.pSls017  = 0 "
   cSql += "     and a.RECNO not in (select c.pRot008 from "+SetTabela("trot025")+" c "
   cSql += "                         where c.pRot008 = a.RECNO) "
elseif pRot009>0 .and. pSls017=0 .and. iRot008 > 0		// Por tipo de Veculo (Agregado)/Cliente
   cSql += "     and a.RECNO = "+alltrim(iRot008)
endif
cSql += "     and a.jTpOper  = "+alltrim(if(iTipo=3,1,iTipo))			// Por Tipo de Operacao (Entrega/Reentrega)
//GerarTXT(cSql)
//Alert(cSql)

AbreRS(cSql,"frete")
if !frete->(eof())
   iRot008 = frete->iRot008
   iRot007 = frete->iRot007


   do case
   case iTipo = 1 						// Entrega
      cSql  = " select  a.pOV			     	,"
      cSql += "         i.Cep                   sCep    ,"
      cSql += "         sum(h.iQTAloc)          iVolume ,"
      cSql += "         sum(h.iQTAloc*h.iPeso)  iPeso   ,"
      cSql += "         sum(h.iQTAloc*h.iVlLib) iVLib    "
      cSql += " from   "+SetTabela("trot016")+" a,"
      cSql +=            SetTabela("trot017")+" h,"
      cSql +=            SetTabela("tsls021")+" i "
      cSql += " where a.pOV in "+cRange 
      cSql += "   and a.iProc = "+alltrim(iProcPre)
      cSql += "   and h.iProc = "+alltrim(iProcPre)
      cSql += "   and h.pOV   = a.pOV  "
      cSql += "   and i.RECNO = a.pEnd "
      cSql += " group by a.pOV,i.Cep "
      aArray = rdd_select(cSql)
      for j=1 to len(aArray) step 5
         iCalcR++
         sCep       = strtran(aArray[j+1],"-","")
         iVol       += aArray[j+2] 
         iPeso      += aArray[j+3]
         //Alert("a:"+alltrim(iPeso))
         iVLib      += aArray[j+4]

         // Busca Kilometragem Percorrida atraves do cep
         cSql  = " select recno "
         cSql += " from "+SetTabela("trot005")
         cSql += " where pRot004 = "+alltrim(iRot004)
         cSql += "   and '"+alltrim(sCEP) + "' >= sCEP1"
         cSql += "   and '"+alltrim(sCEP) + "' <= sCEP2"
         aTmp = rdd_select(cSql)
         if len(aTmp)>0
            iRot005 = aTmp[1]
            cSql  = " select iKM "
            cSql += " from "+SetTabela("trot012")
            cSql += " where pRot005="+alltrim(iRot005)
            cSql += "   and pRot007="+alltrim(iRot007)
            aTmp    = rdd_select(cSql)    
            if len(aTmp)>0
               iKM  = max(iKm,aTmp[1])
               iMKm = iKm
            endif
         endif
      next

      // Buscando numero de entregas
      cSql  = " select  a.pEnd "
      cSql += " from   "+SetTabela("trot016")+" a,"
      cSql +=            SetTabela("tsls021")+" i "
      cSql += " where a.pOV in "+cRange 
      cSql += "   and a.iProc = "+alltrim(iProcPre)
      cSql += "   and i.RECNO = a.pEnd "
      cSql += " group by a.pEnd "
      aArray = rdd_select(cSql)
      iEntregas  = len(aArray)
      iMEntregas = iEntregas
      iMPeso     = iPeso
      iMVol      = iVol
      iMVLib     = iVLib


   case iTipo = 2					// REENTREGA
      cSql  = " select  a.NUM_NF                        ,"
      cSql += "         a.Cep1                  sCep    ,"
      cSql += "         a.QT                    iVolume ,"
      cSql += "         a.PB                    iPB     ,"
      cSql += "         a.VL_TOTALNF            iVLNF   ,"
      cSql += "         a.RECNO				 "
      cSql += " from   "+SetTabela("tsls401")+" a "
      cSql += " where a.RECNO in "+cRange
      aArray = rdd_select(cSql)
      lCalcR  = .t.
      iCalcR  = 0
      iNCalcR = 0
      for j=1 to len(aArray) step 6
         // Que reentrega que ? 1 ou 2
         // Segundo a Ocorrencia, calcula a reentrega correspondente?
         lCalcR = .t.
         cSql  = " select count(*) "
         cSql += " from "+SetTabela("trot019")
         cSql += " where pCodNF = "+alltrim(aArray[j+5])
         cSql += "   and iJTpOper = 2"
         aC = rdd_cursor(cSql)

         cSql  = " select LPG_R1,LPG_R2 "
         cSql += " from "+SetTabela("tsls430")
         cSql += " where pCODNF = "+alltrim(aArray[j+5])
         aO = rdd_select(cSql)
         if len(aO)>0
            // lCalcR  igual a: se for a 1o.ou 2a.reentrega, verificar se a flag da ocorrencia permite Calcular.
            lCalcR = if(1+aC[1]=1,aO[1]="1",aO[2]="1")
            //lCalcR = .t. // Alert Retirar em seguida
         else
            lCalcR = .t.
         endif 

         if lCalcR
            iCalcR++
            sCep       = strtran(aArray[j+1],"-","")
            iVol       += aArray[j+2] 
            iPeso      += aArray[j+3]
            //Alert("b:"+alltrim(iPeso))
            iVLib      += aArray[j+4]

            // Busca Kilometragem Percorrida atraves do cep
            cSql  = " select recno "
            cSql += " from "+SetTabela("trot005")
            cSql += " where pRot004 = "+alltrim(iRot004)
            cSql += "   and '"+alltrim(sCEP) + "' >= sCEP1"
            cSql += "   and '"+alltrim(sCEP) + "' <= sCEP2"
            aTmp = rdd_select(cSql)
            if len(aTmp)>0
               iRot005 = aTmp[1]
               cSql  = " select iKM "
               cSql += " from "+SetTabela("trot012")
               cSql += " where pRot005="+alltrim(iRot005)
               cSql += "   and pRot007="+alltrim(iRot007)
               aTmp    = rdd_select(cSql)    
               if len(aTmp)>0
                  iKM  = max(iKm,aTmp[1])
                  iRKm = iKm
               endif
            endif
         else
            iNCalcR++
         endif
      next
      if iNCalcR = 0 .and. iCalcR > 0 
         // Buscando numero de reentregas
         cSql  = " select  b.COD1END "
         cSql += " from "+SetTabela("tsls401")+" a,"
         cSql +=          SetTabela("tsls001")+" b "
         cSql += " where a.COD_OV = b.RECNO " 
         cSql += "   and a.RECNO in "+cRange
         cSql += " group by b.COD1END"
         /*
         cSql  = " select  d.RECNO "
         cSql += " from   "+SetTabela("tsls401")+" a,"
         cSql +=            SetTabela("tsls019")+" c,"
         cSql +=            SetTabela("tsls021")+" d "
         cSql += " where a.COD_CLI = c.RECNO "
         cSql += "   and a.COD_CLI = d.COD_CLI "
         cSql += "   and d.PCE like '__S' "
         cSql += "   and a.RECNO in "+cRange
         cSql += " group by d.RECNO "
         */
         aArray = rdd_select(cSql)
         iEntregas = len(aArray)
      else
         iEntregas = iCalcR
      endif

      iREntregas = iEntregas
      iRPeso     = iPeso
      iRVol      = iVol
      iRVLib     = iVLib
   case iTipo = 3                                               // Entrega
      cSql  = " select  a.COD_OV                    pOV     ,"
      cSql += "         i.Cep                       sCep    ,"
//      cSql += "         sum(h.QT_CLI)               iVolume ,"
//      cSql += "         sum(h.QT_CLI*h.PB)          iPeso   ,"
//      cSql += "         sum(((a.v3/a.qt)*h.QT_CLI)) iVLib   ,"
      cSql += "         sum(h.QT)                   iVolume,"
      cSql += "         sum(h.QT*h.PB)              iPeso  ,"
      cSql += "         sum(((a.v3/a.qt)*h.QT))     iVLib   "
      cSql += " from   "+SetTabela("tsls002")+" a,"
      cSql +=            SetTabela("tsls110")+" h,"
      cSql +=            SetTabela("tsls021")+" i "
      cSql += " where h.COD_OV in "+cRange
      cSql += "   and h.COD_OC  = "+alltrim(iCodOC)
      cSql += "   and a.RECNO   = h.COD_POV "
      cSql += "   and a.COD_OV  = h.COD_OV  "
      cSql += "   and i.RECNO   = h.COD_END "
      cSql += " group by a.COD_OV,i.Cep "
      aArray = rdd_select(cSql)
      for j=1 to len(aArray) step 5 
         iCalcR++
         sCep       = strtran(aArray[j+1],"-","")
         iVol       += aArray[j+2]
         iPeso      += aArray[j+3]
         iVLib      += aArray[j+4]

/*
         iVol2      += aArray[j+5]
         iPeso2     += aArray[j+6]
         iVLib2     += aArray[j+7]
         if empty(iVol)
            iVol   = iVol2 
            iPeso  = iPeso2
            iVLib  = iVLib2
         endif
*/

         //Alert("iPeso:"+alltrim(iPeso))
         // Busca Kilometragem Percorrida atraves do cep
         cSql  = " select recno "
         cSql += " from "+SetTabela("trot005")
         cSql += " where pRot004 = "+alltrim(iRot004)
         cSql += "   and '"+alltrim(sCEP) + "' >= sCEP1"
         cSql += "   and '"+alltrim(sCEP) + "' <= sCEP2"
         aTmp = rdd_select(cSql)
         if len(aTmp)>0
            iRot005 = aTmp[1]
            cSql  = " select iKM "
            cSql += " from "+SetTabela("trot012")
            cSql += " where pRot005="+alltrim(iRot005)
            cSql += "   and pRot007="+alltrim(iRot007)
            aTmp    = rdd_select(cSql)
            if len(aTmp)>0
               iKM  = max(iKm,aTmp[1])
               iMKm = iKm
            endif
         endif
      next

      cSql = "select PESO,VOLUME,RECNO from "+SetTabela("tsls111")+" where COD_OC = "+alltrim(iCodOC)
      aS111 = rdd_select(cSql)
      if len(aS111)>0 .and. Valtype(aS111[1])="N" .and. aS111[1] > iPeso
         iPeso = aS111[1]
      endif

      // Buscando numero de entregas
      cSql  = " select  a.COD_END  "
      cSql += " from   "+SetTabela("tsls110")+" a,"
      cSql +=            SetTabela("tsls021")+" i "
      cSql += " where a.COD_OV in "+cRange
      cSql += "   and a.COD_OC = "+alltrim(iCodOC)
      cSql += "   and i.RECNO = a.COD_END "
      cSql += " group by a.COD_END "
      aArray = rdd_select(cSql)
      iEntregas  = len(aArray)
      iMEntregas = iEntregas
      iMPeso     = iPeso
      iMVol      = iVol
      iMVLib     = iVLib
      iTipo = 1 // somente quando itipo = 3
   endcase

   if empty(iCalcR)
      aadd(aFrete,0)	// Volumes Transportados
      aadd(aFrete,0)	// Peso Transportado
      aadd(aFrete,0)	// Valor Liberado
      aadd(aFrete,0)	// Nmero de Entregas
      aadd(aFrete,0)	// Valor por range de Tonelada
      aadd(aFrete,0)	// Valor da Porcentagem sobre o valor da NF (iVLib/100*frete->nPorcNF)
      aadd(aFrete,0)	// Parametro [%] da NF frete->nPorcNF
      aadd(aFrete,0)	// Valor da Taxa de Entrega
      aadd(aFrete,0)	// Valor do Pedagio
      aadd(aFrete,0)	// Valor do Pedagio por Kg (frete->nPdgKG*iPeso)
      aadd(aFrete,0)	// Parametro Valor do Pedagio por KG frete->nPdgKG
      aadd(aFrete,0)	// Valor do SecCat
      aadd(aFrete,0)	// Valor do Preco de Fechado
      aadd(aFrete,0)	// Valor da Ad Valorem (iVLib/100*frete->nAdValor)
      aadd(aFrete,0)	// Parametro [%] Porcentagem do AdValores frete->nAdValor
      aadd(aFrete,0)	// Valor do iGris se menor do que a Tarifa Minina (iVLib/100*frete->nGris)
      aadd(aFrete,0)	// Parametro [%] Porcentagem do Gris frete->nGris
      aadd(aFrete,0)	// Valor da Tarifa Minima se maior do que o gris
      aadd(aFrete,0)	// Valor do Preco por Km (frete->nPrKM*iKm)
      aadd(aFrete,0)	// Parametro [$] Valor do Preo por Km frete->nPrKm
      aadd(aFrete,0)	// Valor da(s) Entregas (frete->nPrEnt*iEntregas)
      aadd(aFrete,0)	// Parametro [$] Valor por Entrega
      aadd(aFrete,0)	// Valor por range de Km
      aadd(aFrete,0)	// Valor do Despacho
      aadd(aFrete,0)	// Valor do ITR
      aadd(aFrete,0)	// Valor por Kg (frete->nPrKg*iPeso)
      aadd(aFrete,0)	// Parametro Preco por Kg frete->nPrKg
      aadd(aFrete,0)	// Parametro nFracao
      aadd(aFrete,0)	// Parametro Valor por Fracao
      aadd(aFrete,0)	// Valor do Pedagio por Fracao
      aadd(aFrete,0)	// Valor do ICMS calculado sobre a soma dos valores subtraido pedagio
      aadd(aFrete,0)	// Porcentagem de ICMS frete->nIcms 
      aadd(aFrete,0)	// Soma dos valores + ICMS
      aadd(aFrete,0)	// Valor do Frete quando iFrete < frete->nPrMin. Se refere ao Preco min + ICMS. 
      aadd(aFrete,0)	// Parametro [$] do preco Mnimo frete->nPrMin
      aadd(aFrete,0)  	// Valor do ICMS sobre o Preo Minimo (iFretePM/100*frete->nIcms)
      aadd(aFrete,0)	// frete->nIcms
      aadd(aFrete,0)	// Valor do Frete Simulado
      aadd(aFrete,iTipo)// iTipo - ijtpoper
      aadd(aFrete,0)	// Chave Tabela de Precos
      aadd(aFrete,0)	// Kilometros por CEP
   else

      aadd(aFrete,iVol)				// Volumes Transportados
      aadd(aFrete,iPeso)			// Peso Transportado
      aadd(aFrete,iVLib)			// Valor Liberado
      aadd(aFrete,iEntregas)			// Nmero de Entregas

      if pSls017 > 0 // Somente para transportadoras
         // Preo Range Tonelagem
         cSql  = " select nPreco "
         cSql += " from "+SetTabela("trot011")
         cSql += " where pRot008 = "+alltrim(iRot008)
         cSql += "   and "+alltrim(iPeso)+" >= iTonDe "
         cSql += "   and "+alltrim(iPeso)+" <= iTonAte"
         aTmp = rdd_select(cSql)
         if len(aTmp)>0
            iPRTon = aTmp[1]
         endif
         aadd(aFrete,iPRTon)                    // Valor por range de Tonelada

         // Valor da Porcentagem sobre a NF
         iPorcNF  = iVLib/100*frete->nPorcNF
         aadd(aFrete,iPorcNF)                   // Valor da Porcentagem sobre o valor da NF (iVLib/100*frete->nPorcNF)
         aadd(aFrete,frete->nPorcNF)            // Parametro [%] da NF frete->nPorcNF

         // Tax.Entrega
         iTaxEnt  = frete->nTaxEnt*iEntregas
         aadd(aFrete,iTaxEnt)                   // Valor da Taxa de Entrega

         // Pedagio
         iPedagio = frete->nPedagio*iEntregas
         aadd(aFrete,iPedagio)                  // Valor do Pedagio

         // Valor Pedagio por KG transportado
         iPdgKg = frete->nPdgKG*iPeso
         aadd(aFrete,iPdgKg)                    // Valor do Pedagio por Kg (frete->nPdgKG*iPeso)
         aadd(aFrete,frete->nPdgKG)             // Parametro Valor do Pedagio por KG frete->nPdgKG

         // Sec/Cat
         iSecCat  = frete->nSecCat*iEntregas
         aadd(aFrete,iSecCat)                   // Valor do SecCat

         // Preco Fechado
         iPFechado = frete->nPrFec		//*iEntregas
         aadd(aFrete,iPFechado)                 // Valor do Preco de Fechado

         // Ad Valorem
         iAdValorem = iVLib/100*frete->nAdValor
         aadd(aFrete,iAdValorem)                // Valor da Ad Valorem (iVLib/100*frete->nAdValor)
         aadd(aFrete,frete->nAdValor)           // Parametro [%] Porcentagem do AdValores frete->nAdValor

         // Gris ou Tarifa Minima
         iGris      = iVLib/100*frete->nGris
         iTarMinima = (frete->nTarMin*iEntregas)
         aadd(aFrete,iGris)                     // Valor do iGris se menor do que a Tarifa Minina (iVLib/100*frete->nGris)
         aadd(aFrete,frete->nGris)              // Parametro [%] Porcentagem do Gris frete->nGris
         aadd(aFrete,iTarMinima)                // Valor da Tarifa Minima se maior do que o gris

         // Preco Km
         iPrKM = frete->nPrKM*iKm
         aadd(aFrete,iPrKm)                     // Valor do Preco por Km (frete->nPrKM*iKm)
         aadd(aFrete,frete->nPrKM)              // Parametro [$] Valor do Preo por Km frete->nPrKm

         // Preco por Entrega                   // Desabilitado pq Tx de Entrega faz este papel
         iPrEnt = frete->nPrEnt*iEntregas
         aadd(aFrete,iPrEnt)                    // Valor da(s) Entregas (frete->nPrEnt*iEntregas)
         aadd(aFrete,frete->nPrEnt)             // Parametro [$] Valor por Entrega

         // Preco Range Km:
         cSql  = " select nPreco "
         cSql += " from "+SetTabela("trot010")
         cSql += " where pRot008 = "+alltrim(iRot008)
         cSql += "   and "+alltrim(iKM)+" >= iKMDe "
         cSql += "   and "+alltrim(iKM)+" <= iKMAte"

         aTmp = rdd_select(cSql)
         if len(aTmp)>0
            iPrRangeKm = aTmp[1]
         endif
         aadd(aFrete,iPrRangeKm )                       // Valor por range de Km

         // Despacho
         iDespacho = frete->nDespacho*iEntregas
         aadd(aFrete,iDespacho)                 // Valor do Despacho

         // ITR
         iITR      = frete->nITR*iEntregas
         aadd(aFrete,iITR)                              // Valor do ITR


         // Valor por KG transportado
         iPrKg  = frete->nPrKg*iPeso
         aadd(aFrete,iPrKg)                     // Valor por Kg (frete->nPrKg*iPeso)
         aadd(aFrete,frete->nPrKg)                      // Parametro Preco por Kg frete->nPrKg

         // Valor Pedagio por fracao
         if frete->nFracao > 0
            iVlFracao = int(iPeso/frete->nFracao)*frete->nVlFracao
         else
            iVlFracao = 0
         endif
         aadd(aFrete,frete->nFracao)  
         aadd(aFrete,frete->nVlFracao)  
         aadd(aFrete,iVlFracao)  

         //Alert("iPRTon:"+alltrim(iPRTon))
         //Alert("iPorcNF:"+alltrim(iPorcNF))
         //Alert("iTaxEnt:"+alltrim(iTaxEnt))
         //Alert("iPedagio:"+alltrim(iPedagio))
         //Alert("iSecCat:"+alltrim(iSecCat))
         //Alert("iPFechado:"+alltrim(iPFechado))
         //Alert("iAdValorem:"+alltrim(iAdValorem))
         //Alert("if(iTarMinima>iGris,iTarminima,iGris):"+alltrim(if(iTarMinima>iGris,iTarminima,iGris)))
         //Alert("iPrKM:"+alltrim(iPrKM))
         //Alert("iPrEnt:"+alltrim(iPrEnt))
         //Alert("iPrRangeKm:"+alltrim(iPrRangeKm))
         //Alert("iDespacho:"+alltrim(iDespacho))
         //Alert("iItr:"+alltrim(iItr))
         //Alert("iPdgKg:"+alltrim(iPdgKg))
         //Alert("iPrKg:"+alltrim(iPrKg))
         //Alert("iVlFracao:"+alltrim(iVlFracao))

         // Valor do ICMS
         iBC   =  iPRTon+iPorcNF+iTaxEnt+iPedagio+iSecCat+iPFechado+iAdValorem+if(iTarMinima>iGris,iTarminima,iGris)+iPrKM+iPrEnt+iPrRangeKm+iDespacho+iItr+iPdgKg+iPrKg+iVlFracao

         iIcms = (iBC/((100-frete->nIcms)/100))-iBC
         aadd(aFrete,iIcms)                     // Valor do ICMS calculado sobre a soma dos valores subtraido pedagio
         aadd(aFrete,frete->nIcms)                      // Porcentagem de ICMS frete->nIcms

         // Valor composto do Frete
         iFrete = iBC+iIcms
         
         aadd(aFrete,iFrete)                    // Soma dos valores + ICMS

         // iPrMin
         iPrecoMin = frete->nPrMin*iEntregas
         iIcmsPM  = (iPrecoMin/((100-frete->nIcms)/100))-iPrecoMin
         iFretePM = iPrecoMin+iIcmsPM
         if iFrete > iFretePM
            iFretePM = 0
         endif
         aadd(aFrete,iFretePM)                  // Valor do Frete quando iFrete < frete->nPrMin. Se refere ao Preco min + ICMS.
         aadd(aFrete,iPrecoMin)                 // Parametro [$] do preco Mnimo frete->nPrMin
         aadd(aFrete,iIcmsPM)                   // Valor do ICMS sobre o Preo Minimo (iFretePM/100*frete->nIcms)
         aadd(aFrete,frete->nIcms)                      // frete->nIcms
         aadd(aFrete,if(iFretePM>0,iFretePM,iFrete))    // Valor do Frete Simulado
         aadd(aFrete,iTipo)                     // iTipo - ijtpoper
         aadd(aFrete,iRot008)                   // Chave Tabela de Precos
         aadd(aFrete,iKm)                               // Kilometros por CEP

      else      // para MOTORISTAS

         // Preo Range Tonelagem
         cSql  = " select nPreco "
         cSql += " from "+SetTabela("trot011")
         cSql += " where pRot008 = "+alltrim(iRot008)
         cSql += "   and "+alltrim(iPeso)+" >= iTonDe "
         cSql += "   and "+alltrim(iPeso)+" <= iTonAte"
         aTmp = rdd_select(cSql)
         if len(aTmp)>0
            iPRTon = aTmp[1]
         endif
         aadd(aFrete,iPRTon)                    // Valor por range de Tonelada

         // Valor da Porcentagem sobre a NF
         iPorcNF  = iVLib/100*frete->nPorcNF
         aadd(aFrete,iPorcNF)                   // Valor da Porcentagem sobre o valor da NF (iVLib/100*frete->nPorcNF)
         aadd(aFrete,frete->nPorcNF)            // Parametro [%] da NF frete->nPorcNF

         // Tax.Entrega
         iTaxEnt  = frete->nTaxEnt
         aadd(aFrete,iTaxEnt)                   // Valor da Taxa de Entrega

         // Pedagio
         iPedagio = frete->nPedagio
         aadd(aFrete,iPedagio)                  // Valor do Pedagio

         // Valor Pedagio por KG transportado
         iPdgKg = frete->nPdgKG*iPeso
         aadd(aFrete,iPdgKg)                    // Valor do Pedagio por Kg (frete->nPdgKG*iPeso)
         aadd(aFrete,frete->nPdgKG)             // Parametro Valor do Pedagio por KG frete->nPdgKG

         // Sec/Cat
         iSecCat  = frete->nSecCat
         aadd(aFrete,iSecCat)                   // Valor do SecCat

         // Preco Fechado
         iPFechado = frete->nPrFec
         aadd(aFrete,iPFechado)                 // Valor do Preco de Fechado

         // Ad Valorem
         iAdValorem = iVLib/100*frete->nAdValor
         aadd(aFrete,iAdValorem)                        // Valor da Ad Valorem (iVLib/100*frete->nAdValor)
         aadd(aFrete,frete->nAdValor)           // Parametro [%] Porcentagem do AdValores frete->nAdValor

         // Gris ou Tarifa Minima
         iGris      = iVLib/100*frete->nGris
         iTarminima = frete->nTarMin
         aadd(aFrete,iGris)                     // Valor do iGris se menor do que a Tarifa Minina (iVLib/100*frete->nGris)
         aadd(aFrete,frete->nGris)                      // Parametro [%] Porcentagem do Gris frete->nGris
         aadd(aFrete,iTarMinima)                        // Valor da Tarifa Minima se maior do que o gris


         // Preco Km
         iPrKM = frete->nPrKM*iKm
         aadd(aFrete,iPrKm)                     // Valor do Preco por Km (frete->nPrKM*iKm)
         aadd(aFrete,frete->nPrKM)             // Parametro [$] Valor do Preo por Km frete->nPrKm

         // Preco por Entrega                   // Desabilitado pois o campo Tx de Entrega faz o mesmo.
         iPrEnt = frete->nPrEnt*iEntregas
         aadd(aFrete,iPrEnt)                    // Valor da(s) Entregas (frete->nPrEnt*iEntregas)
         aadd(aFrete,frete->nPrEnt)             // Parametro [$] Valor por Entrega

         // Preco Range Km:
         cSql  = " select nPreco "
         cSql += " from "+SetTabela("trot010")
         cSql += " where pRot008 = "+alltrim(iRot008)
         cSql += "   and "+alltrim(iKM)+" >= iKMDe "
         cSql += "   and "+alltrim(iKM)+" <= iKMAte"

         aTmp = rdd_select(cSql)
         if len(aTmp)>0
            iPrRangeKm = aTmp[1]
         endif
         aadd(aFrete,iPrRangeKm )                       // Valor por range de Km

         // Despacho
         iDespacho = frete->nDespacho
         aadd(aFrete,iDespacho)                 // Valor do Despacho

         // ITR
         iITR      = frete->nITR
         aadd(aFrete,iITR)                              // Valor do ITR


         // Valor por KG transportado
         iPrKg  = frete->nPrKg*iPeso
         aadd(aFrete,iPrKg)                     // Valor por Kg (frete->nPrKg*iPeso)
         aadd(aFrete,frete->nPrKg)                      // Parametro Preco por Kg frete->nPrKg

//         Alert("frete->nPrKg:"+alltrim(frete->nPrKg))
//         Alert("iPeso:"+alltrim(iPeso))
//         Alert("iPrKg:"+alltrim(iPrKg))
      

         // Valor Pedagio por fracao
         if frete->nFracao > 0
            iVlFracao = int(iPeso/frete->nFracao)*frete->nVlFracao
         else
            iVlFracao = 0
         endif
         aadd(aFrete,frete->nFracao)  
         aadd(aFrete,frete->nVlFracao)  
         aadd(aFrete,iVlFracao)  

         //Alert("iPRTon:"+alltrim(iPRTon))
         //Alert("iPorcNF:"+alltrim(iPorcNF))
         //Alert("iTaxEnt:"+alltrim(iTaxEnt))
         //Alert("iPedagio:"+alltrim(iPedagio))
         //Alert("iSecCat:"+alltrim(iSecCat))
         //Alert("iPFechado:"+alltrim(iPFechado))
         //Alert("iAdValorem:"+alltrim(iAdValorem))
         //Alert("if(iTarMinima>iGris,iTarminima,iGris):"+alltrim(if(iTarMinima>iGris,iTarminima,iGris)))
         //Alert("iPrKM:"+alltrim(iPrKM))
         //Alert("iPrEnt:"+alltrim(iPrEnt))
         //Alert("iPrRangeKm:"+alltrim(iPrRangeKm))
         //Alert("iDespacho:"+alltrim(iDespacho))
         //Alert("iItr:"+alltrim(iItr))
         //Alert("iPdgKg:"+alltrim(iPdgKg))
         //Alert("iPrKg:"+alltrim(iPrKg))
         //Alert("iVlFracao:"+alltrim(iVlFracao))

         // Valor do ICMS
         iBC   =  iPRTon+iPorcNF+iTaxEnt+iPedagio+iSecCat+iPFechado+iAdValorem+if(iTarMinima>iGris,iTarMinima,iGris)+iPrKM+iPrEnt+iPrRangeKm+iDespacho+iItr+iPdgKg+iPrKg+iVlFracao
         iIcms = (iBC/((100-frete->nIcms)/100))-iBC
         aadd(aFrete,iIcms)                     // Valor do ICMS calculado sobre a soma dos valores subtraido pedagio
         aadd(aFrete,frete->nIcms)              // Porcentagem de ICMS frete->nIcms

         // Valor composto do Frete
         iFrete = iBC+iIcms
         aadd(aFrete,iFrete)                    // Soma dos valores + ICMS

         // iPrMin
         iPrecoMin = frete->nPrMin
         iIcmsPM  = (iPrecoMin/((100-frete->nIcms)/100))-iPrecoMin
         iFretePM = iPrecoMin+iIcmsPM
         if iFrete > iFretePM
            iFretePM = 0
         endif
         //Alert("iFrete:"+alltrim(iFrete))
         //Alert("iFretePM:"+alltrim(iFretePM))
         aadd(aFrete,iFretePM)                  // Valor do Frete quando iFrete < frete->nPrMin. Se refere ao Preco min + ICMS.
         aadd(aFrete,frete->nPrMin)             // Parametro [$] do preco Mnimo frete->nPrMin
         aadd(aFrete,iIcmsPM)                   // Valor do ICMS sobre o Preo Minimo (iFretePM/100*frete->nIcms)
         aadd(aFrete,frete->nIcms)              // frete->nIcms
         aadd(aFrete,if(iFretePM>0,iFretePM,iFrete))    // Valor do Frete Simulado
         aadd(aFrete,iTipo)                     // iTipo - ijtpoper
         aadd(aFrete,iRot008)                   // Chave Tabela de Precos
         aadd(aFrete,iKm)                               // Kilometros por CEP

      endif
   endif
endif
FechaRS("frete")
RETURN(aFrete)
