<?php
/////////////////////////////////////////////////////////////////
// FUNES
/////////////////////////////////////////////////////////////////
function fFormatar($sDocumento) {
/////////////////////////////////
   $sDocumento = preg_replace('/[^0-9]/', '', $sDocumento);
   if (strlen($sDocumento) == 14) { // CNPJ
       return substr($sDocumento, 0, 2) . '.' . substr($sDocumento, 2, 3) . '.' . substr($sDocumento, 5, 3) . '/' . substr($sDocumento, 8, 4) . '-' . substr($sDocumento, 12, 2);
   } elseif(strlen($sDocumento) == 11) { // CPF
       return substr($sDocumento, 0, 3) . '.' . substr($sDocumento, 3, 3) . '.' . substr($sDocumento, 6, 3) . '-' . substr($sDocumento, 9, 2);
   }
} //function fFormatar($sDocumento) {
//
function fFormatarNr($sFone) {
//////////////////////////////
   $sFone = preg_replace('/[^0-9]/', '', $sFone);
   if (strlen($sFone) == 10) { // Fixo
      return '(' . substr($sFone, 0, 2) . ') ' . substr($sFone, 2, 4) . '-' . substr($sFone, 6, 4);

   } elseif(strlen($sFone) == 11) { // Celular
      return '(' . substr($sFone, 0, 2) . ') ' . substr($sFone, 2, 5) . '-' . substr($sFone, 7, 4);
   }
} // function fFormatar($sFone)
//
function fFormatarCEP($sCEP) {
//////////////////////////////
   return (strlen($sCEP) == 8) ? substr($sCEP, 0, 5) . '-' . substr($sCEP, 5, 3) : $sCEP;
} // function fFormatarCEP($sCEP)
//
function fFormatarValor($nValor) {
//////////////////////////////////
   return is_numeric($nValor) ? number_format($nValor, 2, ',', '.') : $nValor;
} // function fFormatarValor($nValor)
//
function fsCabecalho0($psEmit_xNome,$piIde_serie,$piIde_nNF) {
//////////////////////////////////////////////////////////////
   $piIde_nNF = fsEDILimitadorTipo($piIde_nNF,9,'N');
   $piIde_nNF = chunk_split($piIde_nNF,3,'.');
   $piIde_serie = fsEDILimitadorTipo($piIde_serie,3,'N');

   return "
         <!-- /Header -->

         <!-- Recebimentos -->
         <table cellpadding='0' cellspacing='0' style='font-size: 5pt; border-collapse: collapse; width: 100%;'>
               <tr>
                  <td colspan='2' style='text-transform: uppercase; padding: 5px; height: 20px; border: 1px solid #000; padding: 5px; height: 20px;'>Recebemos de $psEmit_xNome os produtos e servios constantes na nota fiscal indicada ao lado</td>
                  <td rowspan='2' style='width: 140px; vertical-align: middle; font-size: 10pt; text-align: center; line-height: 1.2; border: 1px solid #000;'>
                     <span style='font-size: 10pt;'>NF-e</span>
                     <br />
                     <span style='font-size:  8pt; font-weight: bold;'>N $piIde_nNF</span>
                     <br />
                     <span style='font-size:  8pt;'>SRIE $piIde_serie</span>
                  </td>
               </tr>
               <tr>
                  <td style='width: 50px; padding: 5px; height: 40px; vertical-align: top; border: 1px solid #000;'>
                     <span style='text-transform: uppercase; margin-bottom: 3px; display: block;'>Data de recebimento</span>
                  </td>
                  <td style='width: 130px; padding: 5px; height: 30px; vertical-align: top; border: 1px solid #000;'>
                     <span style='text-transform: uppercase; margin-bottom: 3px; display: block;'>Identificao e assinatura do Recebedor</span>
                  </td>
               </tr>
         </table>

         <hr style='border: none; border-top: 1px dashed #444; margin: 5px 0;' />
   ";
} // function fsCabecalho0
//
function fsCabecalho1($psIde_natOp,$piIde_nNF,$piIde_serie,$psEmit_CNPJ,$psEnderEmit_IE,$piEnderEmit_fone,$psEnderEmit_UF,$psEnderEmit_xMun,$piEnderEmit_CEP,$psEnderEmit_xBairro,$psEnderEmit_xCpl,$psEnderEmit_nro,$psEnderEmit_xLgr,$psEmit_xNome,$psImagem,$psInfNFe_Id,$pjIde_tpNF,$psNFeProt,$psFolha,$psEnderDest_IE, $psEnderEmit_IEST) {
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   $psInfNFe_Id = chunk_split($psInfNFe_Id, 4, ' ');
   $piIde_nNF = fsEDILimitadorTipo($piIde_nNF,9,'N');
   $piIde_nNF = chunk_split($piIde_nNF,3,'.');
   $piIde_serie = fsEDILimitadorTipo($piIde_serie,3,'N');

   return "
   <!-- Emitente -->

      <table cellpadding='0' cellspacing='0' style='font-family: Times New Roman, serif; font-size: 5pt; border-collapse: collapse; width: 100%;'>
         <tr>
            <td rowspan='3' style='width: 40%; padding: 5px; vertical-align: top; border: 1px solid #000;'>
               <span style='text-transform: uppercase; xargin-bottom: 3px; display: block; font-size: 5pt'>IDENTIFICAO DO EMITENTE</span>
               <br/>
               <br/>
               <span style='font-weight: bold; padding: 80px; font-size: 7pt'>$psEmit_xNome</span>
               <br/>
               <span style='font-size: 7pt'>$psEnderEmit_xLgr, $psEnderEmit_nro $psEnderEmit_xCpl</span>
               <br/>
               <span style='font-size: 7pt'>$psEnderEmit_xBairro - CEP: $piEnderEmit_CEP - $psEnderEmit_xMun - $psEnderEmit_UF</span>
               <br/>
               <span style='font-size: 7pt'>TEL: $piEnderEmit_fone</span>
            </td>

            <td rowspan='3' style='width: 20%; text-transform: uppercase; text-align: center; padding: 5px; border: 1px solid #000;'>
               <h3 style='font-size: 13pt; font-weight: bold;'>DANFE</h3>
               <p style='margin: 1mm 0; font-size: 7pt;'>Documento auxiliar da Nota Fiscal Eletrnica</p>

               <table style='width: 100%; padding-top: -10px;'>
                  <tr>
                     <td style='font-size: 7pt;'>0 - ENTRADA</td>
                        <td style='text-align: right;'>
                        <table style='width: 20px; height: 20px; border: 1px solid black; text-align: center; margin-top: 15px; margin-right: 20px; margin-left: 20px'>
                           <tr>
                              <td style='font-size: 10pt; font-weight: bold;'>$pjIde_tpNF</td>
                           </tr>
                        </table>
                     </td>
                  </tr>
                  <tr>
                     <td colspan='2' style='font-size: 7pt; padding-top: -15px;'>1 - SADA</td>
                  </tr>
               </table>

               <span style='font-size: 9pt;'><strong>N $piIde_nNF</strong> FL. $psFolha </span>
               <br/>
               <span style='margin: 5px 0 0 0; font-size: 9pt;'>SRIE $piIde_serie</span>
            </td>

            <td style='width: 10%; text-transform: uppercase; text-align: left; word-wrap: break-word; border: 1px solid #000;'>
               <center><img src='$psImagem'/> </center><!-- ' -->
            </td>
         </tr>

         <tr>
            <td style='vertical-align: top; padding-top: 3px; padding-left: 5px; border: 1px solid #000; font-size: 4pt'>
               <span style='text-transform: uppercase; display: block;'>Chave de Acesso</span>
               <br/>
               &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style='display: block; font-size: 6pt;'>$psInfNFe_Id</span>
            </td>
         </tr>
         <tr>
            <td style='text-align: center; border: 1px solid #000; font-size: 5pt'>
               <span style='text-transform: display: block;'>Consulta de autenticidade no portal nacional da NF-e <br/>www.nfe.fazenda.gov.br/portal <br/>ou no site da Sefaz Autorizada.
            </td>
         </tr>
      </table>

      <!-- Natureza da Operao -->
      <table cellpadding='0' cellspacing='0' style='font-family: Times New Roman, serif; font-size: 5pt; width: 100%;'>
         <tr>
            <td style='width: 60%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-left: 1px solid #000; border-right: 1px solid #000; border-bottom: 1px solid #000;'>
               <table cellpadding='0' cellspacing='0' style='font-family: Times New Roman, serif; font-size: 5pt; width: 100%;'>
                  <tr>
                     <td>
                        <span style='text-transform: uppercase; display: block; font-size: 5pt;'>NATUREZA DA OPERAO</span>
                     </td>
                  </tr>
                  <tr>
                     <td style='padding-top: 3px;'>
                        <span style='font-size: 7pt; display: block;'>$psIde_natOp</span>
                     </td>
                  </tr>
               </table>
            </td>

            <td style='width: 40%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
               <table cellpadding='0' cellspacing='0' style='font-family: Times New Roman, serif; font-size: 5pt; width: 100%;'>
                  <tr>
                     <td>
                        <span style='text-transform: uppercase; display: block; font-size: 5pt;'>PROTOCOLO DE AUTORIZAO</span>
                     </td>
                  </tr>
                  <tr>
                     <td style='padding-top: 3px;'>
                        <span style='font-size: 7pt; display: block;'>$psNFeProt</span>
                     </td>
                  </tr>
               </table>
            </td>

         </tr>
      </table>

      <!--Inscrio-->
      <table cellpadding='0' cellspacing='0' style='font-size: 5pt; width: 100%;'>
         <tr>
            <td style='width: 30%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-left: 1px solid #000; border-right: 1px solid #000;'>
               <table>
                  <tr>
                     <td>
                        <span style='text-transform: uppercase; display: block;'>INSCRIO ESTADUAL</span>
                     </td>
                  </tr>

                  <tr>
                     <td style='padding-top: 3px;'>
                        <span style='font-size: 7pt; display: block;'>$psEnderEmit_IE</span>
                     </td>
                  </tr>
               </table>
            </td>

            <td style='width: 35%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000;'>
               <table>
                  <tr>
                     <td>
                        <span style='text-transform: uppercase; display: block;'>INSCRIO ESTADUAL DO SUBST. TRIB.</span>
                     </td>
                  </tr>

                  <tr>
                     <td style='padding-top: 3px;'>
                        <span style='font-size: 7pt; display: block;'>$psEnderEmit_IEST</span>
                     </td>
                  </tr>
               </table>
            </td>

            <td style='width: 35%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-left: 1px solid #000; border-right: 1px solid #000; border-bottom: 1px solid #000;'>
               <table>
                  <tr>
                     <td>
                        <span style='text-transform: uppercase; display: block;'>CNPJ/CPF</span>
                     </td>
                  </tr>
                  <tr>
                     <td style='padding-top: 3px;'>
                        <span style='font-size: 7pt; display: block;'>$psEmit_CNPJ</span>
                     </td>
                  </tr>
               </table>
            </td>
         </tr>
      </table>
    ";
} // function fsCabecalho1
//
function fsCabecalho2($psDest_xNome,$psDest_CNPJ,$psDest_CPF,$ptIde_Emi,$psEnderDest_xLgr,$psEnderDest_nro,$psEnderDest_xBairro,$piEnderDest_CEP,$pdSaiEnt,$psEnderDest_xMun,$piEnderDest_fone,$psEnderDest_UF,$psEnderDest_IE,$psHoraSai,$psEntrega_xNome,$psEntrega_CNPJ,$psEntrega_CPF,$psEntrega_IE,$psEntrega_xLgr,$psEntrega_xBairro,$psEntrega_CEP,$psEntrega_xMun,$psEntrega_UF,$psEntrega_fone,$psfat_nF,$pnfat_vOrig,$pnfat_vDesc,$pnfat_vLiq,$pnTot_vBC,$pnTot_vICMS,$pnTot_vBCST,$pnTot_vProd,$pnTot_vFrete,$pnTot_vSeg,$pnTot_vDesc,$pnTot_vOutro,$pnTot_vIPI,$pnTot_vNF,$psTransp_xNome,$psTransp_modFrete,$psVeicTransp_placa,$psTransp_CNPJ,$psTransp_CPF,$psTransp_xEnder,$psTransp_xMun,$psTransp_UF,$psTransp_IE,$piVol_qVol,$psVol_marca,$psVol_nVOL,$pnVol_pesoB,$pnVol_pesoL,$psDuplicatas,$pnTot_vST,$piNFPrest) {
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   return "
         <!--Destinatrio/Remetente-->
         <div style='text-transform: uppercase; display: block; font-size: 6pt; padding-top: 6px;'>Destinatrio/Remetente</div>

         <table cellpadding='0' cellspacing='0' border='1' style='width: 100%; font-family: Times New Roman, serif; color: #000; font-size: 6pt; border-collapse: collapse;'>
            <tbody>
               <tr>
                  <td>
                     <table cellpadding='0' cellspacing='0' style='width: 100%; font-family: Times New Roman, serif; color: #000; border-collapse: collapse;'>
                        <tbody>
                           <tr>
                              <td style='width: 590px; vertical-align: top; padding-left: 5px; padding-top: 3px;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block; font-size: 6pt;'>NOME/RAZO SOCIAL</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'> <!-- Espaamento de 3px -->
                                          <span style='font-size: 9pt; display: block;'>$psDest_xNome</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>

                              <td style='width: 220px; vertical-align: top; padding-left: 5px; padding-top: 3px;  border-left: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block; font-size: 6pt;'>CNPJ/CPF</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'> <!-- Espaamento de 3px -->
                                          <span style='font-size: 9pt; display: block;'>$psDest_CNPJ$psDest_CPF</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>

                              <td style='width: 120px; vertical-align: top; padding-left: 5px; padding-top: 3px;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block; font-size: 6pt;'>DATA DE EMISSO</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'> <!-- Espaamento de 3px -->
                                          <span style='font-size: 9pt; display: block;'>$ptIde_Emi</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>

                           </tr>
                        </tbody>
                     </table>
                  </td>
               </tr>

               <tr>
                  <td>
                     <table cellpadding='0' cellspacing='0' style='width: 100%; font-family: Times New Roman, serif; color: #000; border-collapse: collapse;'>
                        <tbody>
                           <tr>
                              <td style='width: 500px; vertical-align: top; padding-left: 5px; border-left: 1px solid #000; border-right: 1px solid #000; border-bottom: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block;'>ENDEREO</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'> <!-- Espaamento de 3px -->
                                          <span style='font-size: 9pt; display: block;'>$psEnderDest_xLgr, $psEnderDest_nro</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>

                              <td style='width: 205px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block;'>BAIRRO/DISTRITO</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'> <!-- Espaamento de 3px -->
                                          <span style='font-size: 9pt; display: block;'>$psEnderDest_xBairro</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>

                              <td style='width: 105px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block;'>CEP</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'> <!-- Espaamento de 3px -->
                                          <span style='font-size: 9pt; display: block;'>$piEnderDest_CEP</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>


                              <td style='width: 120px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block;'>DATA SADA / ENTRADA</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'> <!-- Espaamento de 3px -->
                                          <span style='font-size: 8pt; display: block;'>$pdSaiEnt</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>

                           </tr>
                        </tbody>
                     </table>
                  </td>

               </tr>

               <tr>
                  <td>
                     <table cellpadding='0' cellspacing='0' style='font-family: Times New Roman, serif; border-collapse: collapse; width: 100%;'>
                        <tbody>
                           <tr>
                              <td style='width: 400px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-left: 1px solid #000; border-right: 1px solid #000; border-bottom: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block;'>MUNICPIO</span>
                                       </td>
                                    </tr>
                                       <tr>
                                       <td style='padding-top: 3px;'> <!-- Espaamento de 3px -->
                                          <span style='font-size: 9pt; display: block;'>$psEnderDest_xMun</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>

                              <td style='width: 200px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block;'>FONE/FAX</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'> <!-- Espaamento de 3px -->
                                          <span style='font-size: 9pt; display: block;'>$piEnderDest_fone</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>

                              <td style='width: 50px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block;'>UF</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'> <!-- Espaamento de 3px -->
                                          <span style='font-size: 9pt; display: block;'>$psEnderDest_UF</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>

                              <td style='width: 160px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block;'>INSCRIO ESTADUAL</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'> <!-- Espaamento de 3px -->
                                          <span style='font-size: 9pt; display: block;'>$psEnderDest_IE</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>


                              <td style='width: 120px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block;'>HORA DA SADA</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'> <!-- Espaamento de 3px -->
                                          <span id='info' style='font-size: 9pt; display: block;'>$psHoraSai</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>

                           </tr>
                        </tbody>
                     </table>
                  </td>

               </tr>
            </tbody>
         </table>

         <!-- Local de Entrega -->
         <div style='text-transform: uppercase; display: block; font-size: 6pt; padding-top: 6px;'>INFORMAES DO LOCAL DE ENTREGA</div>
         <table cellpadding='0' cellspacing='0' border='0' style='width: 100%; font-family: Times New Roman, serif; color: #000; font-size: 6pt; border-collapse: collapse;'>
            <tbody>
               <tr>
                  <td>
                     <table cellpadding='0' cellspacing='0' style='width: 100%; font-family: Times New Roman, serif; color: #000; border-collapse: collapse;'>
                        <tbody>
                           <tr>
                              <td style='width: 590px; vertical-align: top; padding-left: 5px; padding-top: 3px; border: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block; font-size: 6pt;'>NOME/RAZO SOCIAL</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'>
                                          <span style='font-size: 9pt; display: block;'>$psEntrega_xNome</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>
                              <td style='width: 180px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-top: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block; font-size: 6pt;'>CNPJ/CPF</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'>
                                          <span style='font-size: 9pt; display: block;'>$psEntrega_CNPJ$psEntrega_CPF</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>
                              <td style='width: 120px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-top: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block; font-size: 6pt;'>INSCRIO ESTADUAL</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'>
                                          <span style='font-size: 9pt; display: block;'>$psEntrega_IE</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>
                           </tr>
                        </tbody>
                     </table>
                  </td>
               </tr>

               <tr>
                  <td>
                     <table cellpadding='0' cellspacing='0' style='width: 100%; font-family: Times New Roman, serif; color: #000; border-collapse: collapse;'>
                        <tbody>
                           <tr>
                              <td style='width: 590px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-left: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block; font-size: 6pt;'>ENDEREO</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'>
                                          <span style='font-size: 9pt; display: block;'>$psEntrega_xLgr</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>
                              <td style='width: 180px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block; font-size: 6pt;'>BAIRRO/DISTRITO</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'>
                                          <span style='font-size: 9pt; display: block;'>$psEntrega_xBairro</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>
                              <td style='width: 120px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block;'>CEP</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'>
                                          <span style='font-size: 9pt; display: block;'>$psEntrega_CEP</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>
                           </tr>
                        </tbody>
                     </table>
                  </td>
               </tr>

               <tr>
                  <td>
                     <table cellpadding='0' cellspacing='0' style='width: 100%; font-family: Times New Roman, serif; color: #000; border-collapse: collapse;'>
                        <tbody>
                           <tr>
                              <td style='width: 590px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-left: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block; font-size: 6pt;'>MUNICPIO</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'>
                                          <span style='font-size: 9pt; display: block;'>$psEntrega_xMun</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>
                              <td style='width: 50px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block; font-size: 6pt;'>UF</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'>
                                          <span style='font-size: 9pt; display: block;'>$psEntrega_UF</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>
                              <td style='width: 120px; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                                 <table>
                                    <tr>
                                       <td>
                                          <span style='text-transform: uppercase; display: block; font-size: 6pt;'>FONE/FAX</span>
                                       </td>
                                    </tr>
                                    <tr>
                                       <td style='padding-top: 3px;'>
                                          <span style='font-size: 9pt; display: block;'>$psEntrega_fone</span>
                                       </td>
                                    </tr>
                                 </table>
                              </td>
                           </tr>
                        </tbody>
                     </table>
                  </td>
               </tr>
            </tbody>
         </table> ".($piNFPrest==0 ? '' : "
         <!-- Fatura -->
         <div style='text-transform: uppercase; display: block; font-size: 6pt; padding-top: 6px;'>FATURA</div>
         <table cellpadding='0' cellspacing='0' border='1' style='font-family: Times New Roman, serif; color: #000; font-size: 5pt; border-collapse: collapse; width: 100%; border-color: #000;'>
            <thead>
               <tr>
                  <th style='border-right: none; background-color:#eeeeee; width: 25%; text-transform: uppercase; padding: 3px 0; text-align: center; font-weight: normal'></th>
                  <th style='border-right: none; border-left: none; background-color:#eeeeee; width: 25%; text-transform: uppercase; padding: 3px 0; text-align: center; font-weight: normal'>Nmero</th>
                  <th style='border-right: none; border-left: none; background-color:#eeeeee; width: 25%; text-transform: uppercase; padding: 3px 0; text-align: center; font-weight: normal'>Valor Original</th>
                  <th style='border-right: none; border-left: none; background-color:#eeeeee; width: 25%; text-transform: uppercase; padding: 3px 0; text-align: center; font-weight: normal'>Valor Desconto</th>
                  <th style='border-left: none; background-color:#eeeeee; width: 25%; text-transform: uppercase; padding: 3px 0; text-align: center; font-weight: normal'>Valor Lquido</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td style='border-right: none; text-align: center; padding: 1px; font-size: 7pt;'>DADOS DA FATURA</td>
<!--              <td style='border-right: none; border-left: none; text-align: center; padding: 1px; font-size: 7pt;'>$psfat_nF</td>  -->
                  <td style='border-right: none; border-left: none; text-align: center; padding: 1px; font-size: 7pt;'>001      </td>
                  <td style='border-right: none; border-left: none; text-align: center; padding: 1px; font-size: 7pt;'>$pnfat_vOrig</td>
                  <td style='border-right: none; border-left: none; text-align: center; padding: 1px; font-size: 7pt;'>$pnfat_vDesc</td>
                  <td style='border-left: none; text-align: center; padding: 1px; font-size: 7pt;'>$pnfat_vLiq</td>
               </tr>
            </tbody>
         </table>

         <!-- Duplicatas -->
         <div style='text-transform: uppercase; display: block; font-size: 6pt; padding-top: 6px;'>DUPLICATAS</div>
         $psDuplicatas
         ")."
         <!-- Clculo do Imposto -->
         <div style='text-transform: uppercase; display: block; font-size: 6pt; padding-top: 6px;'>Clculo do Imposto</div>
         <table cellpadding='0' cellspacing='0' style='font-family: Times New Roman, serif; color: #000; font-size: 5pt; border-collapse: collapse; width: 100%;'>
            <tbody>
               <tr>
                  <td style='width: 12%; vertical-align: top; padding-left: 5px; padding-top: 3px; border: 1px solid #000;'>
                     <table>
                        <tr>
                           <td><span style='text-transform: uppercase; display: block;'>Base de Clculo do ICMS</span></td>
                        </tr>
                        <tr>
                           <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$pnTot_vBC</span></td>
                        </tr>
                     </table>
                  </td>
                  <td style='width: 12%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-left: 1px solid #000; border-bottom: 1px solid #000; border-top: 1px solid #000; border-right: 1px solid #000;'>
                     <table>
                        <tr>
                           <td><span style='text-transform: uppercase; display: block;'>Valor do ICMS</span></td>
                        </tr>
                        <tr>
                           <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$pnTot_vICMS</span></td>
                        </tr>
                     </table>
                  </td>
                  <td style='width: 12%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-top: 1px solid #000; border-right: 1px solid #000;'>
                     <table>
                        <tr>
                           <td><span style='text-transform: uppercase; display: block;'>Base Calc. ICMS Subst.</span></td>
                        </tr>
                        <tr>
                           <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$pnTot_vBCST</span></td>
                        </tr>
                     </table>
                  </td>
                  <td style='width: 12%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-top: 1px solid #000; border-right: 1px solid #000;'>
                     <table>
                         <tr>
                            <td><span style='text-transform: uppercase; display: block;'>Valor do ICMS Subst.</span></td>
                         </tr>
                         <tr>
                            <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$pnTot_vST</span></td>
                         </tr>
                      </table>
                   </td>
                   <td style='width: 12%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-top: 1px solid #000; border-right: 1px solid #000;'>
                      <table>
                         <tr>
                            <td><span style='text-transform: uppercase; display: block;'>Valor Total dos Produtos</span></td>
                         </tr>
                         <tr>
                            <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$pnTot_vProd</span></td>
                         </tr>
                      </table>
                   </td>
                </tr>
             </tbody>
          </table>

          <table cellpadding='0' cellspacing='0' style='font-family: Times New Roman, serif; color: #000; font-size: 6pt; border-collapse: collapse; width: 100%;'>
             <tbody>
                <tr>
                   <td style='width: 12%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-left: 1px solid #000; border-right: 1px solid #000;'>
                      <table>
                         <tr>
                            <td><span style='text-transform: uppercase; display: block;'>Valor do Frete</span></td>
                         </tr>
                         <tr>
                            <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$pnTot_vFrete</span></td>
                         </tr>
                      </table>
                   </td>
                   <td style='width: 12%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                      <table>
                         <tr>
                            <td><span style='text-transform: uppercase; display: block;'>Valor do Seguro</span></td>
                         </tr>
                         <tr>
                            <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$pnTot_vSeg</span></td>
                         </tr>
                      </table>
                   </td>
                   <td style='width: 12%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                      <table>
                         <tr>
                            <td><span style='text-transform: uppercase; display: block;'>Desconto</span></td>
                         </tr>
                         <tr>
                            <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$pnTot_vDesc</span></td>
                         </tr>
                      </table>
                   </td>
                   <td style='width: 12%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                      <table>
                         <tr>
                            <td><span style='text-transform: uppercase; display: block;'>Outras Desp.</span></td>
                         </tr>
                         <tr>
                            <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$pnTot_vOutro</span></td>
                         </tr>
                      </table>
                   </td>
                   <td style='width: 11.9%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                      <table>
                         <tr>
                            <td><span style='text-transform: uppercase; display: block;'>Valor do IPI</span></td>
                         </tr>
                         <tr>
                            <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$pnTot_vIPI</span></td>
                         </tr>
                      </table>
                   </td>
                   <td style='width: 15.6%; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                      <table>
                          <tr>
                             <td><span style='text-transform: uppercase; display: block;'>Valor Total da Nota</span></td>
                          </tr>
                          <tr>
                             <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$pnTot_vNF</span></td>
                          </tr>
                       </table>
                    </td>
                 </tr>
              </tbody>
           </table>

           <!-- Transportador/Volumes transportados -->
           <div style='text-transform: uppercase; display: block; font-size: 6pt; padding-top: 6px;'>Transportador/volumes transportados</div>
           <table cellpadding='0' cellspacing='0' style='font-family: Times New Roman, serif; color: #000; font-size: 5pt; border-collapse: collapse; width: 100%;'>
               <tbody>
                  <tr>
                     <td style='vertical-align: top; padding-left: 5px; padding-top: 3px; border: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>RAZO SOCIAL</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$psTransp_xNome</span></td>
                           </tr>
                        </table>
                     </td>
                     <td style='width: 28mm; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-top: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>FRETE POR CONTA</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$psTransp_modFrete</span></td>
                           </tr>
                        </table>
                     </td>
                     <td style='width: 17.3mm; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-top: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>CDIGO ANTT</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'></span></td>
                           </tr>
                        </table>
                     </td>
                     <td style='width: 22mm; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-top: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>PLACA</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$psVeicTransp_placa</span></td>
                           </tr>
                        </table>
                     </td>
                     <td style='width: 13mm; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-top: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>UF</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$psTransp_UF</span></td>
                           </tr>
                        </table>
                     </td>
                     <td style='width: 29.5mm; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-top: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>CNPJ/CPF</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$psTransp_CNPJ$psTransp_CPF</span></td>
                           </tr>
                        </table>
                     </td>
                  </tr>
               </tbody>
            </table>

            <table cellpadding='0' cellspacing='0' style='font-family: Times New Roman, serif; color: #000; font-size: 6pt; border-collapse: collapse; width: 100%;'>
               <tbody>
                  <tr>
                     <td style='vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-left: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>ENDEREO</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$psTransp_xEnder</span></td>
                           </tr>
                        </table>
                     </td>
                     <td style='width: 56mm; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>MUNICPIO</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$psTransp_xMun</span></td>
                           </tr>
                        </table>
                     </td>
                     <td style='width: 13mm; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>UF</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$psTransp_UF</span></td>
                           </tr>
                        </table>
                     </td>
                     <td style='width: 29.5mm; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>INSC. ESTADUAL</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$psTransp_IE</span></td>
                           </tr>
                        </table>
                     </td>
                  </tr>
               </tbody>
            </table>




            <table cellpadding='0' cellspacing='0' style='font-family: Times New Roman, serif; color: #000; font-size: 6pt; border-collapse: collapse; width: 100%;'>
               <tbody>
                  <tr>
                     <td style='vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-left: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>QUANTIDADE</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block;'>$piVol_qVol</span></td>
                           </tr>
                        </table>
                     </td>
                     <td style='width: 56mm; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>ESPCIE</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block; line-height: 1em;'>$piVol_qVol</span></td>
                           </tr>
                        </table>
                     </td>
                     <td style='width: 13mm; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>MARCA</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block; line-height: 1em;'>$psVol_marca</span></td>
                           </tr>
                        </table>
                     </td>
                     <td style='width: 29.5mm; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>NUMERAO</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block; line-height: 1em;'>$psVol_nVOL</span></td>
                           </tr>
                        </table>
                     </td>

                     <td style='width: 29.5mm; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>PESO BRUTO</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block; line-height: 1em;'>$pnVol_pesoB</span></td>
                           </tr>
                        </table>
                     </td>
                     <td style='width: 29.5mm; vertical-align: top; padding-left: 5px; padding-top: 3px; border-bottom: 1px solid #000; border-right: 1px solid #000;'>
                        <table>
                           <tr>
                              <td><span style='text-transform: uppercase; display: block;'>PESO LIQUIDO</span></td>
                           </tr>
                           <tr>
                              <td style='padding-top: 3px;'><span style='font-size: 7pt; display: block; line-height: 1em;'>$pnVol_pesoL</span></td>
                           </tr>
                        </table>
                     </td>

                  </tr>
               </tbody>
            </table>
          ";
} // function fsCabecalho2
//
function fsRodape($psInfAdic_Cpl,$psInfAdic_Fisco) {
/////////////////////////////////////
   return "<div style='position: absolute; bottom: 0; width: 100%;'>
              <!-- Dados adicionais -->
              <div style='text-transform: uppercase; display: block; font-size: 6pt; padding-top: 6px;'>Dados adicionais</div>
              <table border='1' cellpadding='5' cellspacing='0' style='font-family: Times New Roman, serif; color: #000; font-size: 6pt; border-collapse: collapse; width: 100%; border-color: #000;'>
                 <tbody>
                    <tr>
                       <td style='width: 500px; vertical-align: top; padding-left: 5px; padding-top: 3px;'>
                          <span style='text-transform: uppercase; display: block;'>Informaes Complementares</span>
                          <br/>
                          <span style='font-size: 8pt; display: block; line-height: 1em;'>$psInfAdic_Cpl</span>
                       </td>
                       <td style='width: 500px; height: 24mm; vertical-align: top; padding-left: 5px; padding-top: 3px;'>
                          <span style='text-transform: uppercase; display: block;'>Reservado ao Fisco</span>
                          <br/>
                          <span style='font-size: 8pt; display: block;'>$psInfAdic_Fisco</span>
                       </td>
                    </tr>
                 </tbody>
              </table>
            </div>
   
<!--
            <footer>
               <table cellpadding='0' cellspacing='0' style='width: 100%; font-family: Times New Roman, serif; color: #000;'>
                  <tbody>
                     <tr>
                        <td style='text-align: right;'>
                           <strong></strong>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </footer>
-->    
   ";
} // function fsRodape($psInfAdic_Fisco)
//
function fsImprimeCabItens() {
//////////////////////////////
   return "
    <thead>
                     <tr>
                        <th rowspan='2' style='background-color:#eeeeee; width: 05%; border: 1px solid #000; padding: 2px; font-weight: normal;'>CDIGO</th>
                        <th rowspan='2' style='background-color:#eeeeee; width: 15%; border: 1px solid #000; padding: 2px; font-weight: normal;'>DESCRIO</th>
                        <th rowspan='2' style='background-color:#eeeeee; width: 06%; border: 1px solid #000; padding: 2px; font-weight: normal;'>NCM/SH</th>
                        <th rowspan='2' style='background-color:#eeeeee; width: 05%; border: 1px solid #000; padding: 2px; font-weight: normal;'>CST</th>
                        <th rowspan='2' style='background-color:#eeeeee; width: 05%; border: 1px solid #000; padding: 2px; font-weight: normal;'>CFOP</th>
                        <th rowspan='2' style='background-color:#eeeeee; width: 05%; border: 1px solid #000; padding: 2px; font-weight: normal;'>UNID.</th>
                        <th rowspan='2' style='background-color:#eeeeee; width: 05%; border: 1px solid #000; padding: 2px; font-weight: normal;'>QUANT.</th>
                        <th rowspan='2' style='background-color:#eeeeee; width: 05%; border: 1px solid #000; padding: 2px; font-weight: normal;'>VALOR UNITRIO</th>
                        <th rowspan='2' style='background-color:#eeeeee; width: 05%; border: 1px solid #000; padding: 2px; font-weight: normal;'>VALOR TOTAL</th>
                        <th rowspan='2' style='background-color:#eeeeee; width: 05%; border: 1px solid #000; padding: 2px; font-weight: normal;'>DESCONTO</th>
                        <th colspan='2' style='background-color:#eeeeee; width: 10%; border: 1px solid #000; padding: 2px; font-weight: normal;'>BASE CLCULO</th>
                        <th colspan='3' style='background-color:#eeeeee; width: 10%; border: 1px solid #000; padding: 2px; font-weight: normal;'>VALOR</th>
                        <th colspan='2' style='background-color:#eeeeee; width: 10%; border: 1px solid #000; padding: 2px; font-weight: normal;'>ALIQUOTA</th>
                     </tr>
                     <tr>
                        <th style='background-color:#eeeeee; width: 5%; border: 1px solid #000; padding: 2px; font-weight: normal;'>ICMS</th>
                        <th style='background-color:#eeeeee; width: 5%; border: 1px solid #000; padding: 2px; font-weight: normal;'>ICMS ST</th>
                        <th style='background-color:#eeeeee; width: 5%; border: 1px solid #000; padding: 2px; font-weight: normal;'>ICMS</th>
                        <th style='background-color:#eeeeee; width: 5%; border: 1px solid #000; padding: 2px; font-weight: normal;'>ICMS ST</th>
                        <th style='background-color:#eeeeee; width: 5%; border: 1px solid #000; padding: 2px; font-weight: normal;'>IPI</th>
                        <th style='background-color:#eeeeee; width: 5%; border: 1px solid #000; padding: 2px; font-weight: normal;'>ICMS</th>
                        <th style='background-color:#eeeeee; width: 5%; border: 1px solid #000; padding: 2px; font-weight: normal;'>IPI</th>
                     </tr>
   </thead>
   ";
} // function fsImprimeCabItens()
//
function fsImprimeItens($paLin) {
/////////////////////////////////
   global $hDb;
   global $sEcoTxtPDF;
   global $aICMS_GrupoTribCSTDanfe;

   $sProd_cProd   = $paLin[0];
   $sProd_xProd   = $paLin[1];
   $sProd_NCM     = $paLin[2];
   $iCEST         = $paLin[3];
   $iProd_CFOP    = $paLin[4];
   $sProd_uCom    = $paLin[5];

   $nProd_qCom    = fFormatarValor($paLin[ 6]>0?$paLin[ 6]:0);
   $nProd_vUnCom  = fFormatarValor($paLin[ 7]>0?$paLin[ 7]:0);
   $nProd_vDesc   = fFormatarValor($paLin[ 8]>0?$paLin[ 8]:0);
   $nProd_vProd   = fFormatarValor($paLin[ 9]>0?$paLin[ 9]:0);
   $nICMS_vBC     = fFormatarValor($paLin[10]>0?$paLin[10]:0);
   $nICMS_vBCST   = fFormatarValor($paLin[11]>0?$paLin[11]:0);
   $nICMS_vICMS   = fFormatarValor($paLin[12]>0?$paLin[12]:0);
   $nICMS_vICMSST = fFormatarValor($paLin[13]>0?$paLin[13]:0);
   $nICMS_pICMS   = fFormatarValor($paLin[14]>0?$paLin[14]:0);
   $nIPITrib_pIPI = fFormatarValor($paLin[15]>0?$paLin[15]:0);
   $nIPITrib_vIPI = fFormatarValor($paLin[16]>0?$paLin[16]:0);

   $jICMS_GrupoTrib = $paLin[17];
   $pNFLinha = $paLin[18];

   $sICMS_GrupoTribCSTDanfe = fsEDILimitadorTipo($aICMS_GrupoTribCSTDanfe[$jICMS_GrupoTrib],3,'N');
   fpc_append($sEcoTxtPDF,"sProd_cProd=$sProd_cProd, sProd_xProd=$sProd_xProd, sProd_NCM=$sProd_NCM");
   fpc_append($sEcoTxtPDF,"iCEST=$iCEST, iProd_CFOP=$iProd_CFOP, sProd_uCom=$sProd_uCom");
   fpc_append($sEcoTxtPDF,"nProd_qCom=$nProd_qCom, nProd_vUnCom=$nProd_vUnCom, nProd_vDesc=$nProd_vDesc");
   fpc_append($sEcoTxtPDF,"nProd_vProd=$nProd_vProd, nICMS_vBC=$nICMS_vBC, nICMS_vBCST=$nICMS_vBCST");
   fpc_append($sEcoTxtPDF,"nICMS_vICMS=$nICMS_vICMS, nICMS_vICMSST=$nICMS_vICMSST, nICMS_pICMS=$nICMS_pICMS");
   fpc_append($sEcoTxtPDF,"nIPITrib_pIPI=$nIPITrib_pIPI, nIPITrib_vIPI=$nIPITrib_vIPI");
   fpc_append($sEcoTxtPDF,"sICMS_GrupoTribCSTDanfe=$sICMS_GrupoTribCSTDanfe");
   fpc_append($sEcoTxtPDF,"pNFLinha=$pNFLinha");

   $sSql = "select a.sRastro_nLote,
                   a.nRastro_qLote,
                   a.tRastro_dFab,
                   a.tRastro_dVal
              from NFLinha_RastroLotes a
             where a.lExc = 0 and a.iVer = a.iVAt
               and a.pNFLinha = $pNFLinha
               order by 1";
   $aDb = faDbSelect($hDb,$sSql);
   $sRastro = '';
   foreach ($aDb as $aLin) {
      $sRastro_nLote = trim($aLin[0]);
      $nRastro_qLote = number_format($aLin[1],2,',','.');
      $tRastro_dFab  = date('d/m/Y',strtotime($aLin[2]));
      $tRastro_dVal  = date('d/m/Y',strtotime($aLin[3]));
      fpc_append($sEcoTxtPDF,"sRastro_nLote=$sRastro_nLote, nRastro_qLote=$nRastro_qLote, tRastro_dFab=$tRastro_dFab, tRastro_dVal=$tRastro_dVal");
      $sRastro .= " - LOTE: $sRastro_nLote - QTD: $nRastro_qLote - FAB: $tRastro_dFab - VAL: $tRastro_dVal";
   } // foreach ($aDb as $aLin)

   $sProd_xProd = $sProd_xProd.$sRastro;

   return "
                  <tr>
                     <td style='border: 1px solid #000; padding: 3px; font-size: 5pt; vertical-align: top; text-align: left;'>$sProd_cProd</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: left;   font-size: 5pt;'>$sProd_xProd</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$sProd_NCM</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$sICMS_GrupoTribCSTDanfe</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$iProd_CFOP</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$sProd_uCom</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$nProd_qCom</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$nProd_vUnCom</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$nProd_vProd</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$nProd_vDesc</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$nICMS_vBC</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$nICMS_vBCST</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$nICMS_vICMS</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$nICMS_vICMSST</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$nIPITrib_vIPI</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$nICMS_pICMS</td>
                     <td style='border: 1px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>$nIPITrib_pIPI</td>
                  </tr>
   
   
   ";
} // function fsImprimeItens($paLin)
//
function fsImprimeItensVazios() {
/////////////////////////////////
   return "<tr>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: left;   font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
              <td style='border: 0px solid #000; padding: 3px; text-align: center; font-size: 5pt;'>&nbsp;</td>
           </tr>";
} // function fsImprimeItensVazios($paLin)

//
function fsDuplicatas($paHTMLPrest) {
/////////////////////////////////////
   global $sEcoTxtPDF;
   $iHTMLPrest = count($paHTMLPrest);
   fpc_append($sEcoTxtPDF,"iHTMLPrest=$iHTMLPrest");
   $sRet = "
            <table cellpadding='0' cellspacing='0' border='0' style='width: 100%; font-family: Times New Roman, serif; font-size: 5pt; border-collapse: collapse; border-color: #000;'>
               <thead>
                  <tr>
                     <th style='width:8.3%; text-align: center; padding: 5px; font-weight: normal; border-left: 1px solid #000; border-bottom: 1px solid #000; border-top: 1px solid #000;'>N DUPLICATA</th>
                     <th style='width:8.3%; text-align: center; padding: 5px; font-weight: normal;                              border-bottom: 1px solid #000; border-top: 1px solid #000;'>VENC.</th>
                     <th style='width:8.3%; text-align: center; padding: 5px; font-weight: normal;                              border-bottom: 1px solid #000; border-top: 1px solid #000;'>VALOR</th>
                     <th style='width:8.3%; text-align: center; padding: 5px; font-weight: normal; border-left: 1px solid #000; border-bottom: 1px solid #000; border-top: 1px solid #000;'>N DUPLICATA</th>
                     <th style='width:8.3%; text-align: center; padding: 5px; font-weight: normal;                              border-bottom: 1px solid #000; border-top: 1px solid #000;'>VENC.</th>
                     <th style='width:8.3%; text-align: center; padding: 5px; font-weight: normal;                              border-bottom: 1px solid #000; border-top: 1px solid #000;'>VALOR</th>
                     <th style='width:8.3%; text-align: center; padding: 5px; font-weight: normal; border-left: 1px solid #000; border-bottom: 1px solid #000; border-top: 1px solid #000;'>N DUPLICATA</th>
                     <th style='width:8.3%; text-align: center; padding: 5px; font-weight: normal;                              border-bottom: 1px solid #000; border-top: 1px solid #000;'>VENC.</th>
                     <th style='width:8.3%; text-align: center; padding: 5px; font-weight: normal;                              border-bottom: 1px solid #000; border-top: 1px solid #000;'>VALOR</th>
                     <th style='width:8.3%; text-align: center; padding: 5px; font-weight: normal; border-left: 1px solid #000; border-bottom: 1px solid #000; border-top: 1px solid #000;'>N DUPLICATA</th>
                     <th style='width:8.3%; text-align: center; padding: 5px; font-weight: normal;                              border-bottom: 1px solid #000; border-top: 1px solid #000;'>VENC.</th>
                     <th style='            text-align: center; padding: 5px; font-weight: normal;                              border-bottom: 1px solid #000; border-top: 1px solid #000; border-right: 1px solid #000;'>VALOR</th>
                  </tr>
               </thead>
               <tbody>";
               for ($i=0; $i<$iHTMLPrest; $i+=4) {
                  $s1 = isset($paHTMLPrest[$i  ]) ? $paHTMLPrest[$i  ][0] : '';
                  $s2 = isset($paHTMLPrest[$i  ]) ? $paHTMLPrest[$i  ][1] : '';
                  $s3 = isset($paHTMLPrest[$i  ]) ? $paHTMLPrest[$i  ][2] : '';
                  $s4 = isset($paHTMLPrest[$i+1]) ? $paHTMLPrest[$i+1][0] : '';
                  $s5 = isset($paHTMLPrest[$i+1]) ? $paHTMLPrest[$i+1][1] : '';
                  $s6 = isset($paHTMLPrest[$i+1]) ? $paHTMLPrest[$i+1][2] : '';
                  $s7 = isset($paHTMLPrest[$i+2]) ? $paHTMLPrest[$i+2][0] : '';
                  $s8 = isset($paHTMLPrest[$i+2]) ? $paHTMLPrest[$i+2][1] : '';
                  $s9 = isset($paHTMLPrest[$i+2]) ? $paHTMLPrest[$i+2][2] : '';
                  $sA = isset($paHTMLPrest[$i+3]) ? $paHTMLPrest[$i+3][0] : '';
                  $sB = isset($paHTMLPrest[$i+3]) ? $paHTMLPrest[$i+3][1] : '';
                  $sC = isset($paHTMLPrest[$i+3]) ? $paHTMLPrest[$i+3][2] : '';
                  $sRet .= "<tr>
                             <td style='width:8.3%; text-align: center; padding: 1px; font-size: 7pt; border-left: 1px solid #000; border-bottom: 1px solid #000; border-top: 1px solid #000;'>$s1</td>
                             <td style='width:8.3%; text-align: center; padding: 1px; font-size: 7pt;                              border-bottom: 1px solid #000; border-top: 1px solid #000;'>$s2</td>
                             <td style='width:8.3%; text-align: center; padding: 1px; font-size: 7pt;                              border-bottom: 1px solid #000; border-top: 1px solid #000;'>$s3</td>
                             <td style='width:8.3%; text-align: center; padding: 1px; font-size: 7pt; border-left: 1px solid #000; border-bottom: 1px solid #000; border-top: 1px solid #000;'>$s4</td>
                             <td style='width:8.3%; text-align: center; padding: 1px; font-size: 7pt;                              border-bottom: 1px solid #000; border-top: 1px solid #000;'>$s5</td>
                             <td style='width:8.3%; text-align: center; padding: 1px; font-size: 7pt;                              border-bottom: 1px solid #000; border-top: 1px solid #000;'>$s6</td>
                             <td style='width:8.3%; text-align: center; padding: 1px; font-size: 7pt; border-left: 1px solid #000; border-bottom: 1px solid #000; border-top: 1px solid #000;'>$s7</td>
                             <td style='width:8.3%; text-align: center; padding: 1px; font-size: 7pt;                              border-bottom: 1px solid #000; border-top: 1px solid #000;'>$s8</td>
                             <td style='width:8.3%; text-align: center; padding: 1px; font-size: 7pt;                              border-bottom: 1px solid #000; border-top: 1px solid #000;'>$s9</td>
                             <td style='width:8.3%; text-align: center; padding: 1px; font-size: 7pt; border-left: 1px solid #000; border-bottom: 1px solid #000; border-top: 1px solid #000;'>$sA</td>
                             <td style='width:8.3%; text-align: center; padding: 1px; font-size: 7pt;                              border-bottom: 1px solid #000; border-top: 1px solid #000;'>$sB</td>
                             <td style='            text-align: center; padding: 1px; font-size: 7pt;                              border-bottom: 1px solid #000; border-top: 1px solid #000; border-right: 1px solid #000;'>$sC</td>
                         </tr>
                        ";
               }
   $sRet .=  "</tbody></table>";
   //fpc_append($sEcoTxtPDF,"sRet=$sRet");
   return ($sRet);
} // function fsDuplicatas($paHTMLPrest)
//
function fiTotPag($piT,$pi1,$pi2) {
///////////////////////////////////
    if ($piT <= $pi1) {
        // Se o nmero de itens for menor ou igual  capacidade da primeira pgina, 1 pgina  suficiente
        return 1;
    } else {
        // Subtrai os itens da primeira pgina
        $piTensRestantes = $piT - $pi1;
        
        // Calcula o nmero de pginas adicionais para os itens restantes
        $paginasRestantes = ceil($piTensRestantes / $pi2);
        
        // O total de pginas  1 (primeira pgina) + pginas restantes
        return 1 + $paginasRestantes;
    }
} // function fiTotPag($piT,$pi1,$pi2)
// 
