<?php
// file:///C:/Users/fredy/Downloads/GUIA%20PR%C3%81TICO%20DA%20ESCRITURA%C3%87%C3%83O%20FISCAL%20DIGITAL%20-%20EFD-2.pdf

/*
//
// 0200 - REGISTRO 0200: TABELA DE IDENTIFICAO DO ITEM (PRODUTO E SERVIOS)
//
// K001 - REGISTRO K001: ABERTURA DO BLOCO K - 
          Este registro deve ser gerado para abertura do bloco K, indicando se h registros de informaes no bloco
// K010 - REGISTRO K010: INFORMAO SOBRE O TIPO DE LEIAUTE (SIMPLIFICADO /COMPLETO) - 
          Este registro indica o tipo de leiaute que o contribuinte adotou na informao do bloco K
// K100 - REGISTRO K100: PERODO DE APURAO DO ICMS/IPI - 
          Este registro tem o objetivo de informar o perodo de apurao do ICMS ou do IPI, prevalecendo os perodos mais curtos
// K200 - REGISTRO K200: ESTOQUE ESCRITURADO - 
          Este registro tem o objetivo de informar o estoque final escriturado do perodo de apurao informado no Registro K100,
// K210 - REGISTRO K210: DESMONTAGEM DE MERCADORIAS . ITEM DE ORIGEM - 
          Este registro tem o objetivo de escriturar a desmontagem de mercadorias
// K215 - REGISTRO K215: DESMONTAGEM DE MERCADORIAS . ITENS DE DESTINO - 
          Este registro tem o objetivo de escriturar a desmontagem (com ou sem ordem de servio) de mercadoria
// K220 - REGISTRO K220: OUTRAS MOVIMENTAES INTERNAS ENTRE MERCADORIAS - 
          Este registro tem o objetivo de informar a movimentao interna entre mercadorias
// K230 - REGISTRO K230: ITENS PRODUZIDOS - 
          Este registro tem o objetivo de informar a produo acabada de produto
// K235 - REGISTRO K235: INSUMOS CONSUMIDOS - 
          Este registro tem o objetivo de informar o consumo de mercadoria no processo produtivo, vinculado ao produto resultante informado no campo COD_ITEM do Registro K230 . Itens Produzidos
// K250 - REGISTRO K250: INDUSTRIALIZAO EFETUADA POR TERCEIROS . ITENS PRODUZIDOS - (CDI/TQ ?)
          Este registro tem o objetivo de informar os produtos que foram industrializados por terceiros por encomenda e sua quantidade, exceto produo conjunta
// K255 - REGISTRO K255: INDUSTRIALIZAO EM TERCEIROS . INSUMOS CONSUMIDOS - 
          Este registro tem o objetivo de informar a quantidade de consumo do insumo que foi remetido para ser industrializado em terceiro, 
          vinculado ao produto resultante informado no campo COD_ITEM do Registro K250
// K260 - REGISTRO K260: REPROCESSAMENTO/REPARO DE PRODUTO/INSUMO - 
          Este registro tem o objetivo de informar a sada do estoque de um produto/insumo para ser reprocessado no perodo de apurao do Registro K100, 
          em que o produto/insumo reprocessado/reparado permanea com o mesmo cdigo aps o reprocessamento no prprio estabelecimento do informante
// K265 - REGISTRO K265: REPROCESSAMENTO/REPARO . MERCADORIAS CONSUMIDAS E/OU RETORNADAS - 
          Este registro tem o objetivo de informar o consumo de mercadoria e/ou o retorno de mercadoria ao estoque, 
          ocorridos no reprocessamento/reparo de produto/insumo informado no Registro K260
// K270 - REGISTRO K270: CORREO DE APONTAMENTO DOS REGISTROS K210, K220, K230, K250, K260, K291, K292, K301 E K302 - 
          Este registro tem o objetivo de escriturar correo de apontamento de perodo de apurao anterior...
// K275 - REGISTRO K275: CORREO DE APONTAMENTO E RETORNO DE INSUMOS DOS REGISTROS K215, K220, K235, K255 E K265. - 
          Este registro tem o objetivo de escriturar correo de apontamento de perodo de apurao anterior...
// K280 - REGISTRO K280: CORREO DE APONTAMENTO . ESTOQUE ESCRITURADO - 
          Este registro tem o objetivo de escriturar correo de apontamento de estoque escriturado de perodo de apurao anterior, escriturado no Registro K200
// K290 - REGISTRO K290: PRODUO CONJUNTA . ORDEM DE PRODUO - (Manuf 1 : N PAs) - 
          Este registro tem o objetivo de informar a ordem de produo relativa  produo conjunta. 
          Entenda-se por produo conjunta a produo de mais de um produto resultante a partir do consumo de um ou mais insumos em um fluxo produtivo comum, 
          onde no seja possvel apontar o consumo de insumos diretos aos produtos resultantes, que podem ser classificados, conforme a relevncia nas vendas do contribuinte, 
          como coprodutos ou subprodutos.
// K291 - REGISTRO K291: PRODUO CONJUNTA . ITENS PRODUZIDOS - 
          Este registro tem o objetivo de informar a produo acabada de produto em processo (tipo 03 . campo TIPO_ITEM  do registro 0200) e 
          produto acabado (tipo 04 . campo TIPO_ITEM do registro 0200), originados de produo conjunta, inclusive daquele industrializado para terceiro por encomenda. 
          O produto resultante  classificado como tipo 03 . produto em processo, quando no estiver pronto para ser comercializado, mas estiver pronto para ser consumido 
          em outra fase de produo. O produto resultante  classificado como tipo 04 . produto acabado, quando estiver pronto para ser comercializado.
// K292 - REGISTRO K292: PRODUO CONJUNTA . INSUMOS CONSUMIDOS - Este registro tem o objetivo de informar o consumo de insumo/componente no processo produtivo, relativo  produo conjunta. 
          Na industrializao efetuada para terceiro por encomenda devem ser considerados os insumos recebidos do encomendante e os insumos prprios do industrializador. 
          O consumo de insumo componente cujo controle no permita um apontamento direto no precisa ser escriturado neste Registro.
// K300 - REGISTRO K300: PRODUO CONJUNTA . INDUSTRIALIZAO EFETUADA POR TERCEIROS - 
          Este registro tem o objetivo de informar a data de reconhecimento da produo ocorrida em terceiro, relativa  produo conjunta. 
          Entenda-se por produo conjunta a produo de mais de um produto resultante a partir do consumo de um ou mais insumos em um mesmo processo.
// K301 - REGISTRO K301: PRODUO CONJUNTA . INDUSTRIALIZAO EFETUADA POR TERCEIROS . ITENS PRODUZIDOS - 
          Este registro tem o objetivo de informar os produtos que foram industrializados por terceiros por encomenda e sua quantidade, originados de produo conjunta
// K302 - REGISTRO K302: PRODUO CONJUNTA . INDUSTRIALIZAO EFETUADA POR TERCEIROS . INSUMOS CONSUMIDOS - 
          Este registro tem o objetivo de informar a quantidade de consumo do insumo que foi remetido para ser industrializado em terceiro, relativo a produo conjunta.

// K990 - REGISTRO K990: ENCERRAMENTO DO BLOCO K




Bloco H

REGISTRO H001: ABERTURA DO BLOCO H 
---------------------------------- 
   REG           - Texto fixo contendo "H001"
   IND_MOV       - Indicador de movimento: 0- Bloco com dados informados, 1 - Bloco sem dados informados

Obrigatoriamente dever ser informado .0. no campo IND_MOV no perodo de referncia FEVEREIRO de cada ano
Contribuinte que apresente inventrio com periodicidade anual ou trimestral, caso apresente o inventrio de 31/12 na EFD ICMS IPI de dezembro ou janeiro, deve repetir a informao na escriturao de fevereiro.




REGISTRO H005: TOTAIS DO INVENTRIO
-----------------------------------
   REG           - Texto fixo contendo "H005" 
   DT_INV        - Data do inventrio 
   VL_INV        - Valor total do estoque
   MOT_INV       - Informe o motivo do Inventrio: 01 . No final no perodo, 
                                                   02 . Na mudana de forma de tributao da mercadoria (ICMS), 
                                                   03 . Na solicitao da baixa cadastral, paralisao temporria e outras situaes
                                                   04 . Na alterao de regime de pagamento . condio do contribuinte
                                                   05 . Por determinao dos fiscos
                                                   06 . Para controle das mercadorias sujeitas ao regime de substituio tributria . restituio/ ressarcimento/ complementao
REGISTRO H010: INVENTRIO
-------------------------
   REG           - Texto fixo contendo "H010"
   COD_ITEM      - Cdigo do item (campo 02 do Registro 0200)
   UNID          - Unidade do item 
   QTD           - Quantidade do item
   VL_UNIT       - Valor unitrio do item
   VL_ITEM       - Valor do item 
   IND_PROP      - Indicador de propriedade/posse do item: 0 - Item de propriedade do informante e em seu poder
                                                           1 - Item de propriedade do informante em posse de terceiros
                                                           2 - Item de propriedade de terceiros em posse do informante
   COD_PART      - Cdigo do participante (campo 02 do Registro 0150): - proprietrio/possuidor que no seja o informante do arquivo
   TXT_COMPL     - Descrio complementar. 
   COD_CTA       - Cdigo da conta analtica contbil debitada/creditada
   VL_ITEM_IR    - Valor do item para efeitos do Imposto de Renda. 

REGISTRO H020: INFORMAO COMPLEMENTAR DO INVENTRIO
 Este registro deve ser preenchido para complementar as informaes do inventrio, quando o campo MOT_INV do
 registro H005 for de .02. a .05.. No informar se o campo 03 (VL_INV) do registro H005 for igual a .0. (zero).
----------------------------------------------------
   REG           - Texto fixo contendo "H020" 
   CST_ICMS      - Cdigo da Situao Tributria referente ao ICMS, conforme a Tabela indicada no item 4.3.1
   BC_ICMS       - Informe a base de clculo do ICMS
   VL_ICMS       - Informe o valor do ICMS a ser debitado ou creditado 

REGISTRO H030: INFORMAES COMPLEMENTARES DO INVENTRIO DAS MERCADORIAS SUJEITAS AO REGIME DE SUBSTITUIO TRIBUTRIA

---------------------------------------------------------------------------------------------------------------------
   REG           - Texto fixo contendo "H030" 
   VL_ICMS_OP    - Valor mdio unitrio do ICMS OP 
   VL_BC_ICMS_ST - Valor mdio unitrio da base de clculo do ICMS ST
   VL_ICMS_ST    - Valor mdio unitrio do ICMS ST 
   VL_FCP        - Valor mdio unitrio do FCP

REGISTRO H990: ENCERRAMENTO DO BLOCO H
--------------------------------------
   REG           - Texto fixo contendo "H990" 
   QTD_LIN_H     - Quantidade total de linhas do Bloco H



*/
//
// 0200 - REGISTRO 0200: TABELA DE IDENTIFICAO DO ITEM (PRODUTO E SERVIOS)
//
// K001 - REGISTRO K001: ABERTURA DO BLOCO K - Este registro deve ser gerado para abertura do bloco K, indicando se h registros de informaes no bloco
// K010 - REGISTRO K010: INFORMAO SOBRE O TIPO DE LEIAUTE (SIMPLIFICADO /COMPLETO) - Este registro indica o tipo de leiaute que o contribuinte adotou na informao do bloco K
// K100 - REGISTRO K100: PERODO DE APURAO DO ICMS/IPI - Este registro tem o objetivo de informar o perodo de apurao do ICMS ou do IPI, prevalecendo os perodos mais curtos

// K200 - REGISTRO K200: ESTOQUE ESCRITURADO - Este registro tem o objetivo de informar o estoque final escriturado do perodo de apurao informado no Registro K100,
/*
if ($lOk==true) {
   $sSql = "select sum(b.nSdo),
                   c.sCodigo,
                   c.pUNeg,
                   c.jProp,
                   b.pItem,
                   d.lSdoFiscalI,
                   c.nSdoFiscal
   
           from EST_RegDepositos b join Itens c on b.pItem   = c.pPId and c.iVer=c.iVAt and c.lExc=0 and c.lImprod=0 and c.pUNeg=$pUNeg
                                   join CUP   d on c.pUNeg   = d.pPId and d.iVer=d.iVAt 
             where b.lExc = 0
               and b.iVer = b.iVAt
             --and b.nSdo > 0
   
               $sWhr
               $sWhrDep
              
            group by c.sCodigo,c.pUNeg,c.jProp,b.pItem, d.lSdoFiscalI, c.nSdoFiscal
            order by c.sCodigo
           ";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aK200 = faDBSelect($hDb,$sSql);
   $iK200 = count($aK200);
   fpc_append($sEcoTxt,"iK200=$iK200");
   
   $sTab = 'BlocoK200';
   $aIns   = array();
   $aIns[] = 'pInc';
   $aIns[] = 'pBlocoKProc';
   $aIns[] = 'pItem';
   $aIns[] = 'nSdo';


   foreach ($aK200 as $aLin) {
      $nSdo      = $aLin[0];
      $sCodItem  = $aLin[1];
      $pUNeg     = $aLin[2];
      $jProp     = $aLin[3];
      $pItem     = $aLin[4];
      fpc_append($sEcoTxt,"pItem=$pItem,sCodItem=$sCodItem,pUNeg=$pUNeg,nSdo=$nSdo,jProp=$jProp");

      if ($lOk==true) {
         // insert BLOCO K 200
         $aVal = array();
         $aVal[] = $psLogin;
         $aVal[] = $pMaxBlocoKProc;
         $aVal[] = $pItem;
         $aVal[] = $nSdo;

         if ($lOk) {
            $aTmpSql = array();
            for ($iIns=0; $iIns<$iCountIns; $iIns++) $aTmpSql[] = array($aIns[$iIns],$aVal[$iIns]);
            $sTmpSql = fsArrToInsert($sTab,$aTmpSql);
            fpc_append($sEcoTxt,"sTmpSql=$sTmpSql");

            $lOk = flDBExecute($hSql,$aVal);
            fpc_append($sEcoTxt,"lOk=$lOk");
         }
      }   // lOk
   }   // foreach
}   // lOk
*/
// K210 - REGISTRO K210: DESMONTAGEM DE MERCADORIAS . ITEM DE ORIGEM - Este registro tem o objetivo de escriturar a desmontagem de mercadorias
// K215 - REGISTRO K215: DESMONTAGEM DE MERCADORIAS . ITENS DE DESTINO - Este registro tem o objetivo de escriturar a desmontagem (com ou sem ordem de servio) de mercadoria
// K220 - REGISTRO K220: OUTRAS MOVIMENTAES INTERNAS ENTRE MERCADORIAS - Este registro tem o objetivo de informar a movimentao interna entre mercadorias
/*
if ($lOk==true) {
   $sSql="select 'K220',  
                 cast (a.tIn0 as date),
                 sum(a.nQtSdo),
                 b.pItem
          from EST_MovSaldos a join EST_RegDepositos b on a.pRegDep = b.pPId and b.iVer = b.iVAt
                               join Itens            c on b.pItem   = c.pPId and c.iVer = c.iVAt and c.lExc=0 and c.lImprod=0 and c.pUNeg=$pUNeg
          
          where a.jLcmto in (17,18,38,39,40,42,43,44,45,46,47)   -- 
            and a.tIn0 between '$tBlocoKDe' and '$tBlocoKAte'
            and a.iVer=a.iVAt
            and a.lExc=0   -- ??
       
            $sWhr
            $sWhrDep
       
          group by cast (a.tIn0 as date),b.pItem
          having sum(a.nQtSdo)<>0
          ";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aK220 = faDBSelect($hDb,$sSql);
   $iK220 = count($aK220);
   fpc_append($sEcoTxt,"iK220=$iK220");

   $sTab = 'BlocoK220';
   $aIns   = array();
   $aIns[] = 'pInc';
   $aIns[] = 'pBlocoKProc';
   $aIns[] = 'sReg';
   $aIns[] = 'tMov';          
   $aIns[] = 'pItemO';
   $aIns[] = 'pItemD';
   $aIns[] = 'nQtOri';
   $aIns[] = 'nQtDest';
   $iCountIns = count($aIns);
   fpc_append($sEcoTxt,"iCountIns=$iCountIns");

   // Criar CodItem_TRANS
   // Qdo nQt>0 sai do DISP  ent no TRANS
   // Qdo nQt<0 sai do TRANS ent no DISP
   foreach ($aK220 as $aLin) {
      $sBlocoK   = $aLin[0];
      $dDt       = $aLin[1];
      $nQt       = abs(round($aLin[2],6));
      $pItem     = $aLin[3];

      fpc_append($sEcoTxt,"sBlocoK=$sBlocoK, dDt=$dDt, nQt=$nQt, pItem=$pItem");

      $hSql   = fhPrepareArrToInsert($hDb,$sTab,$aIns);
      if ($lOk==true) {
         // insert BLOCO K 220
         $aVal = array();
         $aVal[] = $psLogin;
         $aVal[] = $pMaxBlocoKProc;
         $aVal[] = $sBlocoK;
         $aVal[] = $dDt;
         $aVal[] = $pItem;
         $aVal[] = $pItem;
         $aVal[] = $nQt;  
         $aVal[] = $nQt;  

         if ($lOk==true) {
            $aTmpSql = array();
            for ($iIns=0; $iIns<$iCountIns; $iIns++) $aTmpSql[] = array($aIns[$iIns],$aVal[$iIns]);
            $sTmpSql = fsArrToInsert($sTab,$aTmpSql);
            fpc_append($sEcoTxt,"sTmpSql=$sTmpSql");
            //$lOk = flDbInsert($hDb,$sTmpSql);
            //fpc_append($sEcoTxt,".lOk=$lOk");

            $lOk = flDBExecute($hSql,$aVal);
            fpc_append($sEcoTxt,"lOk=$lOk");
         }
      }   // lOk
      if ($lOk==false) break;
   }   // foreach
}   // lOk
*/

// K230 - REGISTRO K230: ITENS PRODUZIDOS - Este registro tem o objetivo de informar a produo acabada de produto
if ($lOk==true) {

   $sSql = "select a.pOP,
                   min(a.tIn0),
                   max(a.tIn0)
            from EST_MovSaldos a join EST_RegDepositos b on a.pRegDep = b.pPId and b.iVer = b.iVAt
                                 join Itens            c on b.pItem   = c.pPId and c.iVer = c.iVAt and c.lExc=0 and c.lImprod=0 and c.pUNeg=$pUNeg
            where a.jLcmto in (14)   -- Insumos
              and a.tIn0 between '$tBlocoKDe' and '$tBlocoKAte'
              and a.iVer=a.iVAt
              and a.lExc=0

              $sWhr
              $sWhrDep

            group by a.pOP
           ";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aTmp = faDBSelect($hDb,$sSql);
   $iTmp = count($aTmp);
   fpc_append($sEcoTxt,"iTmp=$iTmp");
   $aMinMax = array();
   foreach ($aTmp as $aLin) {
      $pOP  = $aLin[0];
      $tMin = $aLin[1];
      $tMax = $aLin[2];
      fpc_append($sEcoTxt,"pOP=$pOP, tMin=$tMin, tMax=$tMax");
      $aMinMax[$pOP] = array($tMin,$tMax);
   }

   $sSql = "select 'K230',  
                   a.pOP,
                   c.sCodigo,
                   sum(a.nQtSdo),
                   d.sCodigo,
                   c.pUNeg,
                   b.pItem,
                   e.tRealIni,
                   e.tRealFim
            from EST_MovSaldos a join EST_RegDepositos b on a.pRegDep = b.pPId and b.iVer = b.iVAt
                                 join Itens            c on b.pItem   = c.pPId and c.iVer = c.iVAt and c.lExc=0 and c.lImprod=0 and c.pUNeg=$pUNeg
                                 join UnidadeMedida    d on a.pUniSdo = d.pPId and d.iVer = d.iVAt
                                 join OP               e on a.pOP     = e.pPId and e.iVer = e.iVAt
            where a.jLcmto in (15,48,51)   -- Entrada do PA
              and a.tIn0 between '$tBlocoKDe' and '$tBlocoKAte'
              and a.iVer=a.iVAt
              and a.lExc=0   -- ??
       
              $sWhr
              $sWhrDep
       
            group by a.pOP, 
                     c.sCodigo, 
                     d.sCodigo,
                     c.pUNeg,
                     b.pItem,
                     e.tRealIni,
                     e.tRealFim
  
          having sum(abs(a.nQtSdo))>0
          ";
   

   fpc_append($sEcoTxt,"sSql=$sSql");
   $aK230 = faDBSelect($hDb,$sSql);
   $iK230 = count($aK230);
   fpc_append($sEcoTxt,"iK230=$iK230");

   $sTab = 'BlocoK230';
   $aIns   = array();
   $aIns[] = 'pInc';
   $aIns[] = 'pBlocoKProc';
   $aIns[] = 'sReg';
   $aIns[] = 'tIOP';          
   $aIns[] = 'tFOP';        
   $aIns[] = 'pOP';
   $aIns[] = 'pItem';
   $aIns[] = 'nQt';
   $aIns[] = 'tMinLcmto';          
   $aIns[] = 'tMaxLcmto';        

   $hSql   = fhPrepareArrToInsert($hDb,$sTab,$aIns);
   $iCountIns = count($aIns);
   fpc_append($sEcoTxt,"iCountIns=$iCountIns");

   foreach ($aK230 as $aLin) {
      $sBlocoK   = $aLin[0];
      $pOP       = $aLin[1];
      $sCodI     = $aLin[2];
      $nQt       = abs(round($aLin[3],6));
      $sCodU     = $aLin[4];
      $pUNeg     = $aLin[5];
      $pItem     = $aLin[6];
      $dDtIni    = $aLin[7];
      $sDtFim    = $aLin[8];   // = $dDtIni
      $dMinLcmto = $aMinMax[$pOP][0];
      $dMaxLcmto = $aMinMax[$pOP][1];
      fpc_append($sEcoTxt,"sBlocoK=$sBlocoK, dDtEntMov=$dDtEntMov, dDtIni=$dDtIni, sDtFim=$sDtFim, pOP=$pOP, sCodI=$sCodI, nQt=$nQt, sCodU=$sCodU, pUNeg=$pUNeg, pItem=$pItem, dMinLcmto=$dMinLcmto, dMaxLcmto=$dMaxLcmto");
      if (isset($aItensDoK200[$pItem])==false) {
         if (in_array($pItem,$aItensNaoContemplados)==false) $aItensNaoContemplados[] = $pItem;      
         fpc_append($sEcoTxt,"pItem=$pItem");
      }

      if ($lOk==true) {
         // insert BLOCO K 230
         $aVal = array();
         $aVal[] = $psLogin;
         $aVal[] = $pMaxBlocoKProc;
         $aVal[] = $sBlocoK;
         $aVal[] = $dDtIni;
         $aVal[] = $sDtFim;
         $aVal[] = $pOP;
         $aVal[] = $pItem;
         $aVal[] = $nQt;  
         $aVal[] = $dMinLcmto;
         $aVal[] = $dMaxLcmto;

         if ($lOk) {
            $aTmpSql = array();
            for ($iIns=0; $iIns<$iCountIns; $iIns++) $aTmpSql[] = array($aIns[$iIns],$aVal[$iIns]);
            $sTmpSql = fsArrToInsert($sTab,$aTmpSql);
            fpc_append($sEcoTxt,"sTmpSql=$sTmpSql");

            $lOk = flDBExecute($hSql,$aVal);
            fpc_append($sEcoTxt,"lOk=$lOk");
         }
      }   // lOk
      if ($lOk==false) break;
   }   // foreach
}   // lOk


// K235 - REGISTRO K235: INSUMOS CONSUMIDOS - Este registro tem o objetivo de informar o consumo de mercadoria no processo produtivo, vinculado ao produto resultante informado no campo COD_ITEM do Registro K230 . Itens Produzidos
if ($lOk==true) {
   $sSql="select 'K235',  -- PA - Insumos
                 cast (a.tIn0 as date),
                 sum(abs(a.nQtSdo)),
                 b.pItem,
                 a.pOP
          from EST_MovSaldos a join EST_RegDepositos b on a.pRegDep = b.pPId and b.iVer = b.iVAt
                               join Itens            c on b.pItem   = c.pPId and c.iVer = c.iVAt and c.lExc=0 and c.lImprod=0 and c.pUNeg=$pUNeg
          where a.jLcmto = 14   -- Saida do Insumo
            and a.tIn0 between '$tBlocoKDe' and '$tBlocoKAte'
            and a.iVer=a.iVAt
            and a.lExc=0   -- ??

            $sWhr
            $sWhrDep

          group by 
                   cast (a.tIn0 as date),
                   b.pItem,
                   a.pOP
          having sum(abs(a.nQtSdo))>0
         ";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aK235 = faDBSelect($hDb,$sSql);
   $iK235 = count($aK235);
   fpc_append($sEcoTxt,"iK235=$iK235");


   $sTab = 'BlocoK235';
   $aIns   = array();
   $aIns[] = 'pInc';
   $aIns[] = 'pBlocoKProc';
   $aIns[] = 'sReg';   
   $aIns[] = 'tSai';          
   $aIns[] = 'pItem';
   $aIns[] = 'nQt';
   $aIns[] = 'pOP';

   $hSql   = fhPrepareArrToInsert($hDb,$sTab,$aIns);
   $iCountIns = count($aIns);
   fpc_append($sEcoTxt,"iCountIns=$iCountIns");

   foreach ($aK235 as $aLin) {
      $sBlocoK   = $aLin[0];
      $dDtSai    = $aLin[1];
      $nQt       = abs(round($aLin[2],6));
      $pItem     = $aLin[3];
      $pOP       = $aLin[4];
      fpc_append($sEcoTxt,"sBlocoK=$sBlocoK, dDtSai=$dDtSai, nQt=$nQt, pItem=$pItem, pOP=$pOP");
      if (isset($aItensDoK200[$pItem])==false) {
         if (in_array($pItem,$aItensNaoContemplados)==false) $aItensNaoContemplados[] = $pItem;      
         fpc_append($sEcoTxt,"pItem=$pItem");
      }

      if ($lOk==true) {
         // insert BLOCO K 235
         $aVal = array();
         $aVal[] = $psLogin;
         $aVal[] = $pMaxBlocoKProc;
         $aVal[] = $sBlocoK;
         $aVal[] = $dDtSai;
         $aVal[] = $pItem;
         $aVal[] = $nQt;  
         $aVal[] = $pOP;

         if ($lOk) {
            $aTmpSql = array();
            for ($iIns=0; $iIns<$iCountIns; $iIns++) $aTmpSql[] = array($aIns[$iIns],$aVal[$iIns]);
            $sTmpSql = fsArrToInsert($sTab,$aTmpSql);
            fpc_append($sEcoTxt,"sTmpSql=$sTmpSql");

            $lOk = flDBExecute($hSql,$aVal);
            fpc_append($sEcoTxt,"lOk=$lOk");
         }
      }   // lOk
      if ($lOk==false) break;
   }   // foreach
}   // lOk


//----
// Caso CDI/TQ
// K250 - REGISTRO K250: INDUSTRIALIZAO EFETUADA POR TERCEIROS . ITENS PRODUZIDOS - Este registro tem o objetivo de informar os produtos que foram industrializados por terceiros por encomenda e sua quantidade, exceto produo conjunta
/*
$sSql="select 'K250',   -- PA
              cast (a.tIn0 as date),
              c.sCodigo||'-'||c.sDescricao,
              sum(a.nQtSdo),
              d.sCodigo,
              '',
              0
       from EST_MovSaldos a join EST_RegDepositos b on a.pRegDep = b.pPId and b.iVer = b.iVAt
                               join Itens            c on b.pItem   = c.pPId and c.iVer = c.iVAt and c.lExc=0 and c.lImprod=0 and c.pUNeg=$pUNeg
                            join UnidadeMedida    d on a.pUniSdo = d.pPId and d.iVer = d.iVAt
       where a.jLcmto = 51   -- Entrada do PA
         and a.tIn0 between '$tBlocoKDe' and '$tBlocoKAte'
         and a.iVer=a.iVAt
         and a.lExc=0   -- ??

         $sWhr
         $sWhrDep

       group by cast (a.tIn0 as date),
                c.sCodigo, 
                c.sDescricao,
                d.sCodigo
       ";
fpc_append($sEcoTxt,"sSql=$sSql");
$aK250 = faDBSelect($hDb,$sSql);
$iK250 = count($aK250);
fpc_append($sEcoTxt,"iK250=$iK250");

// K255 - REGISTRO K255: INDUSTRIALIZAO EM TERCEIROS . INSUMOS CONSUMIDOS - Este registro tem o objetivo de informar a quantidade de consumo do insumo que foi remetido para ser industrializado em terceiro, vinculado ao produto resultante informado no campo COD_ITEM do Registro K250
$sSql="select 'K255',  -- INSUMOS
              cast (a.tIn0 as date),
              c.sCodigo||'-'||c.sDescricao,
              sum(abs(a.nQtSdo)),
              d.sCodigo,
              '',
              0
       from EST_MovSaldos a join EST_RegDepositos b on a.pRegDep = b.pPId and b.iVer = b.iVAt
                            join Itens            c on b.pItem   = c.pPId and c.iVer = c.iVAt and c.lExc=0 and c.lImprod=0 and c.pUNeg=$pUNeg
                            join UnidadeMedida    d on a.pUniSdo = d.pPId and d.iVer = d.iVAt
       where a.jLcmto = 50   -- Saida do Dep3o
         and a.tIn0 between '$tBlocoKDe' and '$tBlocoKAte'
         and a.iVer=a.iVAt
         and a.lExc=0   -- ??

         $sWhr
         $sWhrDep

       group by cast (a.tIn0 as date),
                c.sCodigo, 
                c.sDescricao,
                d.sCodigo
       ";
fpc_append($sEcoTxt,"sSql=$sSql");
$aK255 = faDBSelect($hDb,$sSql);
$iK255 = count($aK255);
fpc_append($sEcoTxt,"iK255=$iK255");
*/
// K260 - REGISTRO K260: REPROCESSAMENTO/REPARO DE PRODUTO/INSUMO - Este registro tem o objetivo de informar a sada do estoque de um produto/insumo para ser reprocessado no perodo de apurao do Registro K100, em que o produto/insumo reprocessado/reparado permanea com o mesmo cdigo aps o reprocessamento no prprio estabelecimento do informante
// K265 - REGISTRO K265: REPROCESSAMENTO/REPARO . MERCADORIAS CONSUMIDAS E/OU RETORNADAS - Este registro tem o objetivo de informar o consumo de mercadoria e/ou o retorno de mercadoria ao estoque, ocorridos no reprocessamento/reparo de produto/insumo informado no Registro K260
// K270 - REGISTRO K270: CORREO DE APONTAMENTO DOS REGISTROS K210, K220, K230, K250, K260, K291, K292, K301 E K302 - Este registro tem o objetivo de escriturar correo de apontamento de perodo de apurao anterior...
// K275 - REGISTRO K275: CORREO DE APONTAMENTO E RETORNO DE INSUMOS DOS REGISTROS K215, K220, K235, K255 E K265. - Este registro tem o objetivo de escriturar correo de apontamento de perodo de apurao anterior...
// K280 - REGISTRO K280: CORREO DE APONTAMENTO . ESTOQUE ESCRITURADO - Este registro tem o objetivo de escriturar correo de apontamento de estoque escriturado de perodo de apurao anterior, escriturado no Registro K200

// K290 - REGISTRO K290: PRODUO CONJUNTA . ORDEM DE PRODUO - (Manuf 1: N PA) - Este registro tem o objetivo de informar a ordem de produo relativa  produo conjunta. Entenda-se por produo conjunta a produo de mais de um produto resultante a partir do consumo de um ou mais insumos em um fluxo produtivo comum, onde no seja possvel apontar o consumo de insumos diretos aos produtos resultantes, que podem ser classificados, conforme a relevncia nas vendas do contribuinte, como coprodutos ou subprodutos.
/*
$sSql="select 'K290',   -- Manuf
              cast (d.tRealIni as date),
              cast (d.tRealFim as date),
              a.pOP,
              a.pOP
       from EST_MovSaldos a join EST_RegDepositos b on a.pRegDep = b.pPId and b.iVer = b.iVAt
                            join Itens            c on b.pItem   = c.pPId and c.iVer = c.iVAt and c.lExc=0 and c.lImprod=0 and c.pUNeg=$pUNeg
                            join OP               d on a.pOP     = d.pPId and d.iVer = d.iVAt
       where a.jLcmto = 15   -- Entrada do PA
         and a.tIn0 between '$tBlocoKDe' and '$tBlocoKAte'
         and a.iVer=a.iVAt
         and a.lExc=0   -- ??

         $sWhr
         $sWhrDep

       group by cast (d.tRealIni as date),
                cast (d.tRealFim as date),
                a.pOP, 
                c.sCodigo
       ";
fpc_append($sEcoTxt,"sSql=$sSql");
$aK290 = faDBSelect($hDb,$sSql);
$iK290 = count($aK290);
fpc_append($sEcoTxt,"iK290=$iK290");

// K291 - REGISTRO K291: PRODUO CONJUNTA . ITENS PRODUZIDOS - Este registro tem o objetivo de informar a produo acabada de produto em processo (tipo 03 . campo TIPO_ITEM  do registro 0200) e produto acabado (tipo 04 . campo TIPO_ITEM do registro 0200), originados de produo conjunta, inclusive daquele industrializado para terceiro por encomenda. O produto resultante  classificado como tipo 03 . produto em processo, quando no estiver pronto para ser comercializado, mas estiver pronto para ser consumido em outra fase de produo. O produto resultante  classificado como tipo 04 . produto acabado, quando estiver pronto para ser comercializado.
$sSql="select 'K291',   -- Manuf
              c.sCodigo||'-'||c.sDescricao,
              sum(a.nQtSdo),
              d.sCodigo,
              a.pOP
       from EST_MovSaldos a join EST_RegDepositos b on a.pRegDep = b.pPId and b.iVer = b.iVAt
                            join Itens            c on b.pItem   = c.pPId and c.iVer = c.iVAt and c.lExc=0 and c.lImprod=0 and c.pUNeg=$pUNeg
                            join UnidadeMedida    d on a.pUniSdo = d.pPId and d.iVer = d.iVAt
       where a.jLcmto = 15   -- Entrada do PA
         and a.tIn0 between '$tBlocoKDe' and '$tBlocoKAte'
         and a.iVer=a.iVAt
         and a.lExc=0   -- ??

         $sWhr
         $sWhrDep

       group by 
                a.pOP, 
                c.sCodigo, 
                c.sDescricao,
                d.sCodigo
       ";
fpc_append($sEcoTxt,"sSql=$sSql");
$aK291 = faDBSelect($hDb,$sSql);
$iK291 = count($aK291);
fpc_append($sEcoTxt,"iK291=$iK291");

// K292 - REGISTRO K292: PRODUO CONJUNTA . INSUMOS CONSUMIDOS - Este registro tem o objetivo de informar o consumo de insumo/componente no processo produtivo, relativo  produo conjunta. Na industrializao efetuada para terceiro por encomenda devem ser considerados os insumos recebidos do encomendante e os insumos prprios do industrializador. O consumo de insumo componente cujo controle no permita um apontamento direto no precisa ser escriturado neste Registro.
$sSql="select 'K292',   -- Manuf
              c.sCodigo||'-'||c.sDescricao,
              sum(a.nQtSdo),
              f.sCodigo,
              a.pOP
       from EST_MovSaldos a join EST_RegDepositos b on a.pRegDep = b.pPId and b.iVer = b.iVAt
                            join Itens            c on b.pItem   = c.pPId and c.iVer = c.iVAt and c.lExc=0 and c.lImprod=0 and c.pUNeg=$pUNeg
                            join OP               d on a.pOP     = d.pPId and d.iVer = d.iVAt
                            join Itens            e on d.pItem   = e.pPId and e.iVer = e.iVAt and c.lImprod=0  and e.lAcabado=0 and e.lManuf=1
                            join UnidadeMedida    f on a.pUniSdo = f.pPId and f.iVer = f.iVAt
       where a.jLcmto = 14   -- Saida do Insumo
         and a.tIn0 between '$tBlocoKDe' and '$tBlocoKAte'
         and a.iVer=a.iVAt
         and a.lExc=0   -- ??

         $sWhr
         $sWhrDep

       group by 
                a.pOP, 
                c.sCodigo, 
                c.sDescricao,
                f.sCodigo
       ";
fpc_append($sEcoTxt,"sSql=$sSql");
$aK292 = faDBSelect($hDb,$sSql);
$iK292 = count($aK292);
fpc_append($sEcoTxt,"iK292=$iK292");
*/
// K300 - REGISTRO K300: PRODUO CONJUNTA . INDUSTRIALIZAO EFETUADA POR TERCEIROS - Este registro tem o objetivo de informar a data de reconhecimento da produo ocorrida em terceiro, relativa  produo conjunta. Entenda-se por produo conjunta a produo de mais de um produto resultante a partir do consumo de um ou mais insumos em um mesmo processo.
// K301 - REGISTRO K301: PRODUO CONJUNTA . INDUSTRIALIZAO EFETUADA POR TERCEIROS . ITENS PRODUZIDOS - Este registro tem o objetivo de informar os produtos que foram industrializados por terceiros por encomenda e sua quantidade, originados de produo conjunta
// K302 - REGISTRO K302: PRODUO CONJUNTA . INDUSTRIALIZAO EFETUADA POR TERCEIROS . INSUMOS CONSUMIDOS - Este registro tem o objetivo de informar a quantidade de consumo do insumo que foi remetido para ser industrializado em terceiro, relativo a produo conjunta.
// K990 - REGISTRO K990: ENCERRAMENTO DO BLOCO K
/*

jLcmto	Processo	Mensagem
1	OEnt_Confirmar_RFisico_TQ.php	Rec.Fsico: pRFis  - [sSCNPJCPF] sFor
2	OEnt_Confirmar_RFisico_TQ.php	Rec.Fsico Inspeo: pRFis  - [sSCNPJCPF] sFor
3	OEnt_Desconfirmar_RFisico_TQ.php	Cancelamento Rec.Fsico: pRFis  - [sSCNPJCPF] sFor
4	OEnt_Desconfirmar_RFisico_TQ.php	Cancelamento Rec.Fsico Inspeo: pRFis  - [sSCNPJCPF] sFor
5	OEnt_Inspec_Processar.php	Inspecionado: pInspecao, Rec.Fsico: pPreNF
6	OEnt_Inspec_Processar.php	Inspecionado Aprovado: pInspecao, Rec.Fsico: pPreNF
7	OEnt_Inspec_Processar.php	Inspecionado Rejeitado: pInspecao, Rec.Fsico: pPreNF
8	OEnt_Inspec_Cancelar.php	Inspecionado Aprovado  Cancelado: pInspecao, Rec.Fsico: pPreNF
9	OEnt_Inspec_Cancelar.php	Inspecionado Rejeitado  Cancelado: pInspecao, Rec.Fsico: pPreNF
10	OEnt_Inspec_Cancelar.php	Inspecionado Cancelado: pInspecao, Rec.Fsico: pPreNF
11	OEnt_InspecForaEspec_Processar.php	Inspecionado Fora da Especificao: pInspecao, Rec.Fsico: pPreNF
12	OEnt_InspecForaEspec_Processar.php	Inspecionado Fora da Especificao Aprovado: pInspecao, Rec.Fsico: pPreNF
13	OEnt_InspecForaEspec_Processar.php	Inspecionado Fora da Especificao Rejeitado: pInspecao, Rec.Fsico: pPreNF
14	OP_08_Baixar_TQ.php (2 vezes)	Consumo Produo OP: pOP
15	OP_08_Baixar_TQ.php (2 vezes)	Entrada Produo OP: pOP - Lote 1 (*ou 2)
16	OP_08_Baixar_TQ.php (2 vezes)	Perda Produo OP: pOP
17	EST_SOTransf_Confirma.php	Ordem de Simples Transferencia Origem: pDoc
18	EST_SOTransf_Confirma.php	Ordem de Simples Transferencia Destino: pDoc
19	EST_Transf_IComp_Confirma.php	Transferencia InterCompany Origem: pDoc
20	EST_Transf_IComp_Confirma.php	Transferencia InterCompany Destino: pDoc
21	EST_Transf_IComp_Itens_Lotes_Confirma.php	Transferencia InterCompany Origem: pSOT - linha ID: pEST_TIC_ILote
22	EST_Transf_IComp_Itens_Lotes_Confirma.php	Transferencia InterCompany Destino: pSOT - linha ID: pEST_TIC_ILote
23	OSa_1Reservar_TQ.php (perf)	Transferencia Automtica Processo de Reserva Origem: piId
24	OSa_1Reservar_TQ.php (perf)	Transferencia Automtica Processo de Reserva Destino: piId
25	OSa_1Reservar_TQ.php (perf)	Transferencia Automtica Processo de Reserva Retorno do Destino: piId
26	OSa_1Reservar_TQ.php (perf)	Transferencia Automtica Processo de Reserva Retorno para Origemo: piId
27	OSa_2Desreservar_TQ.php	Processo de Retorno Saldos Destino: piId
28	OSa_2Desreservar_TQ.php	Processo de Retorno Saldos Origem: piId
29	OSa_5RetornoSdo_TQ.php	Processo de Retorno Saldos Destino: pDoc
30	OSa_5RetornoSdo_TQ.php	Processo de Retorno Saldos Origem: pDoc
31	PreNF_NFCapa_SAIDA.php	Ordem: ppOrdem, PreNF: ppPreNF, Nfe: piIde_nNF
32	PreNF_NFCapa_SAIDA.php	Estorno Ordem: pOrdemDaVez, PreNF: pPreNFDaVez, NFe: iIde_nNF
33	PreNF_NFCapa_SAIDA.php	Ordem: ppOrdemDaVez, PreNF: ppPreNFDaVez, NFe: iIde_nNF - Nota de Entrada
34	PreNF_NFCapa_SAIDA.php	Ordem: ppOrdem, PreNF: ppPreNF, NFe: piIde_nNF - Transferencia Deposito de Terceiros Sada
35	PreNF_NFCapa_SAIDA.php	Ordem ppOrdem, PreNF ppPreNF, NFe piIde_nNF - Transferencia Deposito de Terceiros - Entrada
36	PreNF_NFCapa_SAIDA.php	Ordem: ppOrdem, PreNF: ppPreNF, NFe: piIde_nNF - Cancelamento Transferencia Deposito de Terceiros Entrada
37	PreNF_NFCapa_SAIDA.php	Ordem: ppOrdem, PreNF: ppPreNF, NFe: piIde_nNF - Cancelamento Transferencia Deposito de Terceiros Sada
38	OnSave(25)	Transferencia de Depsito Origem: pOperEst
39	OnSave(25)	Transferencia de Depsito Destino: pOperEst
40	OnSave(26)	Ajuste de Depsito: pOperEst
41	EST_Requisicoes_Confirmar.php (erro)	Requisio de Insumos Improdutivos: pDoc
42	EST_SOTransf_Itens_Lotes_Confirma.php	Ordem de Simples Transferencia Origem: pSOT - linha ID: pDoc
43	EST_SOTransf_Itens_Lotes_Confirma.php	Ordem de Simples Transferencia Destino: pSOT - linha ID: pDoc
44	EST_SOTransf_Itens_Lotes_Confirma.php	Ordem de Simples Transferencia Origem: pSOT - linha ID: pDoc - devoluo diferena
45	EST_SOTransf_Itens_Lotes_Confirma.php	Ordem de Simples Transferencia Destino: pSOT - linha ID: pDoc - devoluo diferena
46	OP_13_Finalizar_Transito.php	OP Transferencia de Depsito Origem: pOperTra
47	OP_13_Finalizar_Transito.php	OP Transferencia de Depsito Destino: pOperTra
48	OnSave(49)	Entrada Parcial Produo OP: piId
49	PreNF_NFCapa_SAIDA.php	Entrada Dep 3o
50	PreNF_NFCapa_SAIDA.php	Sada do Dep 3o
51 Retorno PA TQ->CDI


 jLcmto Processo Mensagem

*+14 OP_08_Baixar_TQ.php (2 vezes) Consumo Produo OP: pOP - 235 jLcmto(14-16)
*+15 OP_08_Baixar_TQ.php (2 vezes) Entrada Produo OP: pOP - Lote 1 (*ou 2) - 230
 x16 OP_08_Baixar_TQ.php (2 vezes) Perda Produo OP: pOP - j(16) Ndisp

 +17/43 EST_SOTransf_Confirma.php Ordem de Simples Transferencia Origem: pDoc - 220
 x18 EST_SOTransf_Confirma.php Ordem de Simples Transferencia Destino: pDoc

 !19 EST_Transf_IComp_Confirma.php Transferencia InterCompany Origem: pDoc
 x20 EST_Transf_IComp_Confirma.php Transferencia InterCompany Destino: pDoc
 x21 EST_Transf_IComp_Itens_Lotes_Confirma.php Transferencia InterCompany Origem: pSOT - linha ID: pEST_TIC_ILote
 !22 EST_Transf_IComp_Itens_Lotes_Confirma.php Transferencia InterCompany Destino: pSOT - linha ID: pEST_TIC_ILote

 +38 OnSave(25) Transferencia de Depsito Origem: pOperEst - 220 / 270
 +39 OnSave(25) Transferencia de Depsito Destino: pOperEst - 220 / 275
 .40 OnSave(26) Ajuste de Depsito: pOperEst

 x41 EST_Requisicoes_Confirmar.php (erro) Requisio de Insumos Improdutivos: pDoc
 x42 EST_SOTransf_Itens_Lotes_Confirma.php Ordem de Simples Transferencia Origem: pSOT - linha ID: pDoc
 +43/17 EST_SOTransf_Itens_Lotes_Confirma.php Ordem de Simples Transferencia Destino: pSOT - linha ID: pDoc - 220
 x44 EST_SOTransf_Itens_Lotes_Confirma.php Ordem de Simples Transferencia Origem: pSOT - linha ID: pDoc - devoluo diferena
 x45 EST_SOTransf_Itens_Lotes_Confirma.php Ordem de Simples Transferencia Destino: pSOT - linha ID: pDoc - devoluo diferena

 .46 OP_13_Finalizar_Transito.php OP Transferencia de Depsito Origem: pOperTra
 .47 OP_13_Finalizar_Transito.php OP Transferencia de Depsito Destino: pOperTra

*+48 OnSave(49) Entrada Parcial Produo OP: piId - 230
 ?49 PreNF_NFCapa_SAIDA.php Entrada Dep 3o
 ?50 PreNF_NFCapa_SAIDA.php Sada do Dep 3o
 ?51 ...








jLcmto	Processo	Mensagem
1	OEnt_Confirmar_RFisico_TQ.php	Rec.Fsico: pRFis  - [sSCNPJCPF] sFor
2	OEnt_Confirmar_RFisico_TQ.php	Rec.Fsico Inspeo: pRFis  - [sSCNPJCPF] sFor
3	OEnt_Desconfirmar_RFisico_TQ.php	Cancelamento Rec.Fsico: pRFis  - [sSCNPJCPF] sFor
4	OEnt_Desconfirmar_RFisico_TQ.php	Cancelamento Rec.Fsico Inspeo: pRFis  - [sSCNPJCPF] sFor
5	OEnt_Inspec_Processar.php	Inspecionado: pInspecao, Rec.Fsico: pPreNF
6	OEnt_Inspec_Processar.php	Inspecionado Aprovado: pInspecao, Rec.Fsico: pPreNF
7	OEnt_Inspec_Processar.php	Inspecionado Rejeitado: pInspecao, Rec.Fsico: pPreNF
8	OEnt_Inspec_Cancelar.php	Inspecionado Aprovado  Cancelado: pInspecao, Rec.Fsico: pPreNF
9	OEnt_Inspec_Cancelar.php	Inspecionado Rejeitado  Cancelado: pInspecao, Rec.Fsico: pPreNF
10	OEnt_Inspec_Cancelar.php	Inspecionado Cancelado: pInspecao, Rec.Fsico: pPreNF
11	OEnt_InspecForaEspec_Processar.php	Inspecionado Fora da Especificao: pInspecao, Rec.Fsico: pPreNF
12	OEnt_InspecForaEspec_Processar.php	Inspecionado Fora da Especificao Aprovado: pInspecao, Rec.Fsico: pPreNF
13	OEnt_InspecForaEspec_Processar.php	Inspecionado Fora da Especificao Rejeitado: pInspecao, Rec.Fsico: pPreNF
14	OP_08_Baixar_TQ.php (2 vezes)	Consumo Produo OP: pOP
15.     OP_08_Baixar_TQ.php (2 vezes)	Entrada Produo OP: pOP - Lote 1 (*ou 2)
16	OP_08_Baixar_TQ.php (2 vezes)	Perda Produo OP: pOP
17.     EST_SOTransf_Confirma.php	Ordem de Simples Transferencia Origem: pDoc  -> sai da tq 
18	EST_SOTransf_Confirma.php	Ordem de Simples Transferencia Destino: pDoc -> entra na tq
19.     EST_Transf_IComp_Confirma.php	Transferencia InterCompany Origem: pDoc  -> sai disp tq
20	EST_Transf_IComp_Confirma.php	Transferencia InterCompany Destino: pDoc -> ent trans arte
21	EST_Transf_IComp_Itens_Lotes_Confirma.php	Transferencia InterCompany Origem: pSOT - linha ID: pEST_TIC_ILote
22-     EST_Transf_IComp_Itens_Lotes_Confirma.php	Transferencia InterCompany Destino: pSOT - linha ID: pEST_TIC_ILote
23.	OSa_1Reservar_TQ.php (perf)	Transferencia Automtica Processo de Reserva Origem: piId
24	OSa_1Reservar_TQ.php (perf)	Transferencia Automtica Processo de Reserva Destino: piId
25	OSa_1Reservar_TQ.php (perf)	Transferencia Automtica Processo de Reserva Retorno do Destino: piId
26.	OSa_1Reservar_TQ.php (perf)	Transferencia Automtica Processo de Reserva Retorno para Origemo: piId
27	OSa_2Desreservar_TQ.php	Processo de Retorno Saldos Destino: piId
28.	OSa_2Desreservar_TQ.php	Processo de Retorno Saldos Origem: piId
29	OSa_5RetornoSdo_TQ.php	Processo de Retorno Saldos Destino: pDoc
30.     OSa_5RetornoSdo_TQ.php	Processo de Retorno Saldos Origem: pDoc
31.	PreNF_NFCapa_SAIDA.php	Ordem: ppOrdem, PreNF: ppPreNF, Nfe: piIde_nNF
32.	PreNF_NFCapa_SAIDA.php	Estorno Ordem: pOrdemDaVez, PreNF: pPreNFDaVez, NFe: iIde_nNF
33	PreNF_NFCapa_SAIDA.php	Ordem: ppOrdemDaVez, PreNF: ppPreNFDaVez, NFe: iIde_nNF - Nota de Entrada
34	PreNF_NFCapa_SAIDA.php	Ordem: ppOrdem, PreNF: ppPreNF, NFe: piIde_nNF - Transferencia Deposito de Terceiros Sada
35	PreNF_NFCapa_SAIDA.php	Ordem ppOrdem, PreNF ppPreNF, NFe piIde_nNF - Transferencia Deposito de Terceiros - Entrada
36	PreNF_NFCapa_SAIDA.php	Ordem: ppOrdem, PreNF: ppPreNF, NFe: piIde_nNF - Cancelamento Transferencia Deposito de Terceiros Entrada
37	PreNF_NFCapa_SAIDA.php	Ordem: ppOrdem, PreNF: ppPreNF, NFe: piIde_nNF - Cancelamento Transferencia Deposito de Terceiros Sada
38.	OnSave(25)	Transferencia de Depsito Origem: pOperEst
39.	OnSave(25)	Transferencia de Depsito Destino: pOperEst
40.	OnSave(26)	Ajuste de Depsito: pOperEst
41	EST_Requisicoes_Confirmar.php (erro)	Requisio de Insumos Improdutivos: pDoc
42	EST_SOTransf_Itens_Lotes_Confirma.php	Ordem de Simples Transferencia Origem: pSOT - linha ID: pDoc - .
43.	EST_SOTransf_Itens_Lotes_Confirma.php	Ordem de Simples Transferencia Destino: pSOT - linha ID: pDoc
44	EST_SOTransf_Itens_Lotes_Confirma.php	Ordem de Simples Transferencia Origem: pSOT - linha ID: pDoc - devoluo diferena
45	EST_SOTransf_Itens_Lotes_Confirma.php	Ordem de Simples Transferencia Destino: pSOT - linha ID: pDoc - devoluo diferena
46	OP_13_Finalizar_Transito.php	OP Transferencia de Depsito Origem: pOperTra
47	OP_13_Finalizar_Transito.php	OP Transferencia de Depsito Destino: pOperTra
48.	OnSave(49)	Entrada Parcial Produo OP: piId
49	PreNF_NFCapa_SAIDA.php	Entrada Dep 3o
50	PreNF_NFCapa_SAIDA.php	Sada do Dep 3o
51      Retorno PA TQ->CDI
*/

//////////////////////////////////////////////////
// INICIO DE LEITURA DAS IRFOMAES PARA O BLOCO H
//////////////////////////////////////////////////

/*
if ($lOk==true) {
   $sSql="select 'H005',
                 sum(e.nSdo*c.nUC1ExImp)
          from EST_RegDepositos b      join Itens           c on b.pItem   = c.pPId and c.iVer=c.iVAt and c.lExc=0
                                       join UnidadeMedida   d on b.pUni    = d.pPId and d.iVer=d.iVAt and d.lExc=0  
                                  left join EST_RegDepSdo   e on e.pRegDep = b.pPId and e.iVer=e.iVAt and e.lExc=0 and cast(e.tIn0 as date) = '$tBlocoKAte'
            where b.lExc = 0
              and b.iVer = b.iVAt
              and c.lImprod = 0
              and c.pUNeg = $pUNeg
           group by 'H005'";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aH005 = faDBSelect($hDb,$sSql);
   $iH005 = count($aH005);
   fpc_append($sEcoTxt,"iH005=$iH005");

   $sTab = 'BlocoH005';
   $aIns   = array();
   $aIns[] = 'pInc';
   $aIns[] = 'pBlocoHProc';
   $aIns[] = 'sReg';
   $aIns[] = 'tDtInv';  // Data do inventrio 
   $aIns[] = 'nVlInv';  // Valor total do estoque
   $aIns[] = 'jMotInv'; // Informe o motivo do Inventrio

   $iCountIns = count($aIns);
   fpc_append($sEcoTxt,"iCountIns=$iCountIns");

   foreach ($aH005 as $aLin) {
      $sBlocoH    = $aLin[0];
      $sCodItem   = $aLin[1];
      $tDtInv     = $tBlocoKAte;
      $nVlInv     = $aLin[3];
      $jMotInv    = $aLin[4];

      fpc_append($sEcoTxt,"sBlocoH=$sBlocoH,sCodItem=$sCodItem,tDtInv=$tDtInv,nVlInv=$nVlInv,jMotInv=$jMotInv");

      $hSql   = fhPrepareArrToInsert($hDb,$sTab,$aIns);
      if ($lOk==true) {
         $aVal = array();
         $aVal[] = $psLogin;
         $aVal[] = $pMaxBlocoKProc;
         $aVal[] = $sBlocoH;
         $aVal[] = $tDtInv;
         $aVal[] = $nVlInv;
         $aVal[] = $jMotInv;

         if ($lOk==true) {
            $aTmpSql = array();
            for ($iIns=0; $iIns<$iCountIns; $iIns++) $aTmpSql[] = array($aIns[$iIns],$aVal[$iIns]);
            $sTmpSql = fsArrToInsert($sTab,$aTmpSql);
            fpc_append($sEcoTxt,"sTmpSql=$sTmpSql");
            //$lOk = flDbInsert($hDb,$sTmpSql);
            //fpc_append($sEcoTxt,".lOk=$lOk");

            $lOk = flDBExecute($hSql,$aVal);
            fpc_append($sEcoTxt,"lOk=$lOk");
         }
      }   // lOk
      if ($lOk==false) break;
   }   // foreach
}   // lOk

if ($lOk==true) {
   $sSql="select 'H010',
                 sum(e.nSdo),
                 c.sCodigo sCodItem,
                 c.pUNeg,
                 c.jProp,
                 b.pItem, 
                 c.sCodigo sUni, 
                 c.nUC1ExImp,  
                 '01' --  Informe o motivo do Inventrio: 01 . No final no perodo,02 . Na mudana de forma de tributao da mercadoria (ICMS),03 . Na solicitao da baixa cadastral, paralisao temporria e outras situaes,04 . Na alterao de regime de pagamento . condio do contribuinte,05 . Por determinao dos fiscos,06 . Para controle das mercadorias sujeitas ao regime de substituio tributria . restituio/ ressarcimento/ complementao
          from EST_RegDepositos b      join Itens           c on b.pItem   = c.pPId and c.iVer=c.iVAt and c.lExc=0
                                       join UnidadeMedida   d on b.pUni    = d.pPId and d.iVer=d.iVAt and d.lExc=0  
                                  left join EST_RegDepSdo   e on e.pRegDep = b.pPId and e.iVer=e.iVAt and e.lExc=0 and cast(e.tIn0 as date) = '$tBlocoKAte'
            where b.lExc = 0
              and b.iVer = b.iVAt
            --and d.nSdo > 0
              and c.lImprod = 0
              and c.pUNeg = $pUNeg
           group by 'H010',c.sCodigo,c.pUNeg,c.jProp,b.pItem,c.sCodigo,c.sCodigo,c.nUC1ExImp,c.jProp,'01'
           order by c.sCodigo";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aH010 = faDBSelect($hDb,$sSql);
   $iH010 = count($aH010);
   fpc_append($sEcoTxt,"iH010=$iH010");

   $sTab = 'BlocoH010';
   $aIns   = array();
   $aIns[] = 'pInc';
   $aIns[] = 'pBlocoHProc';
   $aIns[] = 'sReg';
   $aIns[] = 'sCodItem';  // Cdigo do item (campo 02 do Registro 0200)
   $aIns[] = 'sUni';      // Unidade do item
   $aIns[] = 'nQt';       // Quantidade do item
   $aIns[] = 'jProp';     // Indicador de propriedade/posse do item
   $aIns[] = 'nVlItem';   // Valor do item
   $aIns[] = 'nVlUnit';   // Valor unitrio do item
   $aIns[] = 'pCodPart';  // Cdigo do participante (campo 02 do Registro 0150)
   $aIns[] = 'sTxtCompl'; // Descrio complementar
   $aIns[] = 'sCodCTA';   // Cdigo da conta analtica contbil debitada/creditada
   $aIns[] = 'nVlItemIR'; // Valor do item para efeitos do Imposto de Renda

   $iCountIns = count($aIns);
   fpc_append($sEcoTxt,"iCountIns=$iCountIns");

   foreach ($aH010 as $aLin) {
      $sBlocoH    = $aLin[0];
      $sCodItem   = $aLin[2];
      $sUni       = $aLin[6];
      $nQt        = $aLin[1];
      $jProp      = $aLin[4];
      $nVlItem    = $aLin[1]*$aLin[7];
      $nVlUnit    = $aLin[8];
      $pCodPart   = 0;
      $sTxtCompl  = '';
      $sCodCTA    = '';
      $nVlItemIR  = 0;

      fpc_append($sEcoTxt,"sBlocoH=$sBlocoH,sCodItem=$sCodItem,sUni=$sUni,nQt=$nQt, jProp=$jProp,nVlItem=$nVlItem, nVlUnit=$nVlUnit,pCodPart=$pCodPart,sTxtCompl=$sTxtCompl,sCodCTA=$sCodCTA,nVlItemIR=$nVlItemIR");

      $hSql   = fhPrepareArrToInsert($hDb,$sTab,$aIns);
      if ($lOk==true) {
         $aVal = array();
         $aVal[] = $psLogin;
         $aVal[] = $pMaxBlocoKProc;
         $aVal[] = $sBlocoH;
         $aVal[] = $sCodItem;
         $aVal[] = $sUni;
         $aVal[] = $nQt;
         $aVal[] = $jProp;
         $aVal[] = $nVlItem;
         $aVal[] = $nVlUnit;
         $aVal[] = $pCodPart;
         $aVal[] = $sTxtCompl;
         $aVal[] = $sCodCTA;
         $aVal[] = $nVlItemIR;

         if ($lOk==true) {
            $aTmpSql = array();
            for ($iIns=0; $iIns<$iCountIns; $iIns++) $aTmpSql[] = array($aIns[$iIns],$aVal[$iIns]);
            $sTmpSql = fsArrToInsert($sTab,$aTmpSql);
            fpc_append($sEcoTxt,"sTmpSql=$sTmpSql");
            //$lOk = flDbInsert($hDb,$sTmpSql);
            //fpc_append($sEcoTxt,".lOk=$lOk");

            $lOk = flDBExecute($hSql,$aVal);
            fpc_append($sEcoTxt,"lOk=$lOk");
         }
      }   // lOk
      if ($lOk==false) break;
   }   // foreach
}   // lOk

if ($lOk==true) {
   $sSql="select 'H020'
                 b.jICMS_GrupoTrib,
                 sum(b.nICMS_vBC),
                 sum(b.nICMS_vICMS)
          from EST_MovSaldos a   join PreNF              b on a.pPreNF = b.pPId and b.iVer=b.iVAt and b.lExc=0 and b.tNFCapaCapa is null and b.tNFCapa is null
                                 join PreNF_Itens        c on c.pPreNF = b.pPId and c.iVer=c.iVAt and c.lExc=0
          where a.iVAt = a.iVAt
            and a.lExc=0
            and cast(a.tIn0) >= '$tBlocoKDe'
            and cast(a.tIn0) <= '$tBlocoKAte'
            and c.pUNeg = $pUNeg
          group by 'H020',b.jICMS_GrupoTrib";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aH020 = faDBSelect($hDb,$sSql);
   $iH020 = count($aH020);
   fpc_append($sEcoTxt,"iH020=$iH020");

   $sTab = 'BlocoH020';
   $aIns   = array();
   $aIns[] = 'pInc';
   $aIns[] = 'pBlocoHProc';
   $aIns[] = 'sReg';
   $aIns[] = 'sCSTICMS';
   $aIns[] = 'nBCICMS';
   $aIns[] = 'nVLICMS';

   $iCountIns = count($aIns);
   fpc_append($sEcoTxt,"iCountIns=$iCountIns");

   foreach ($aH020 as $aLin) {
      $sBlocoH    = $aLin[0];
      $sCSTICMS   = $aLin[1];
      $nBCICMS    = $aLin[2];
      $nVLICMS    = $aLin[3];
      fpc_append($sEcoTxt,"sBlocoH=$sBlocoH,sCSTICMS=$sCSTICMS,nBCICMS=$nBCICMS,nVLICMS=$nVLICMS");

      $hSql   = fhPrepareArrToInsert($hDb,$sTab,$aIns);
      if ($lOk==true) {
         // insert BLOCO K 220
         $aVal = array();
         $aVal[] = $psLogin;
         $aVal[] = $pMaxBlocoKProc;
         $aVal[] = $sBlocoH;
         $aVal[] = $sCSTICMS;
         $aVal[] = $nBCICMS;
         $aVal[] = $nVLICMS;

         if ($lOk==true) {
            $aTmpSql = array();
            for ($iIns=0; $iIns<$iCountIns; $iIns++) $aTmpSql[] = array($aIns[$iIns],$aVal[$iIns]);
            $sTmpSql = fsArrToInsert($sTab,$aTmpSql);
            fpc_append($sEcoTxt,"sTmpSql=$sTmpSql");
            //$lOk = flDbInsert($hDb,$sTmpSql);
            //fpc_append($sEcoTxt,".lOk=$lOk");

            $lOk = flDBExecute($hSql,$aVal);
            fpc_append($sEcoTxt,"lOk=$lOk");
         }
      }   // lOk
      if ($lOk==false) break;
   }   // foreach
}   // lOk


if ($lOk==true) {
   $sSql="select 'H020'
          from EST_RegDepositos b      join Itens           c on b.pItem   = c.pPId and c.iVer=c.iVAt and c.lExc=0
                                       join UnidadeMedida   d on b.pUni    = d.pPId and d.iVer=d.iVAt and d.lExc=0  
                                  left join EST_RegDepSdo   e on e.pRegDep = b.pPId and e.iVer=e.iVAt and e.lExc=0 and cast(e.tIn0 as date) = '$tBlocoKAte'
            where b.lExc = 0
              and b.iVer = b.iVAt
            --and d.nSdo > 0
              and c.lImprod = 0
              and c.pUNeg = $pUNeg
           group by 'H020'
           order by c.sCodigo";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aH020 = faDBSelect($hDb,$sSql);
   $iH020 = count($aH020);
   fpc_append($sEcoTxt,"iH010=$iH010");

   $sTab = 'BlocoH020';
   $aIns   = array();
   $aIns[] = 'pInc';
   $aIns[] = 'pBlocoHProc';
   $aIns[] = 'sReg';
   $aIns[] = 'sCSTICMS';
   $aIns[] = 'nBCICMS';
   $aIns[] = 'nVLICMS';

   $iCountIns = count($aIns);
   fpc_append($sEcoTxt,"iCountIns=$iCountIns");

   foreach ($aH020 as $aLin) {
      $sBlocoH    = $aLin[0];
      $sCSTICMS   = $aLin[1];
      $nBCICMS    = $aLin[2];
      $nVLICMS    = $aLin[3];
      fpc_append($sEcoTxt,"sBlocoH=$sBlocoH,sCSTICMS=$sCSTICMS,nBCICMS=$nBCICMS,nVLICMS=$nVLICMS");

      $hSql   = fhPrepareArrToInsert($hDb,$sTab,$aIns);
      if ($lOk==true) {
         $aVal = array();
         $aVal[] = $psLogin;
         $aVal[] = $pMaxBlocoKProc;
         $aVal[] = $sBlocoH;
         $aVal[] = $sCSTICMS;
         $aVal[] = $nBCICMS;
         $aVal[] = $nVLICMS;

         if ($lOk==true) {
            $aTmpSql = array();
            for ($iIns=0; $iIns<$iCountIns; $iIns++) $aTmpSql[] = array($aIns[$iIns],$aVal[$iIns]);
            $sTmpSql = fsArrToInsert($sTab,$aTmpSql);
            fpc_append($sEcoTxt,"sTmpSql=$sTmpSql");
            //$lOk = flDbInsert($hDb,$sTmpSql);
            //fpc_append($sEcoTxt,".lOk=$lOk");

            $lOk = flDBExecute($hSql,$aVal);
            fpc_append($sEcoTxt,"lOk=$lOk");
         }
      }   // lOk
      if ($lOk==false) break;
   }   // foreach
}   // lOk

if ($lOk==true) {
   $sSql="select 'H030'
          from EST_RegDepositos b      join Itens           c on b.pItem   = c.pPId and c.iVer=c.iVAt and c.lExc=0
                                       join UnidadeMedida   d on b.pUni    = d.pPId and d.iVer=d.iVAt and d.lExc=0  
                                  left join EST_RegDepSdo   e on e.pRegDep = b.pPId and e.iVer=e.iVAt and e.lExc=0 and cast(e.tIn0 as date) = '$tBlocoKAte'
            where b.lExc = 0
              and b.iVer = b.iVAt
            --and d.nSdo > 0
              and c.lImprod = 0
              and c.pUNeg = $pUNeg
           group by 'H030'
           order by c.sCodigo";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aH030 = faDBSelect($hDb,$sSql);
   $iH030 = count($aH030);
   fpc_append($sEcoTxt,"iH030=$iH030");

   $sTab = 'BlocoH030';
   $aIns   = array();
   $aIns[] = 'pInc';
   $aIns[] = 'pBlocoHProc';
   $aIns[] = 'sReg';
   $aIns[] = 'nVlICMSOP';
   $aIns[] = 'nVlBCICMSST';
   $aIns[] = 'nVlICMSST';
   $aIns[] = 'nVlFCP';

   $iCountIns = count($aIns);
   fpc_append($sEcoTxt,"iCountIns=$iCountIns");

   foreach ($aH030 as $aLin) {
      $sBlocoH     = $aLin[0];
      $nVlICMSOP   = $aLin[1];
      $nVlBCICMSST = $aLin[2];
      $nVlICMSST   = $aLin[3];
      $nVlFCP      = $aLin[4];
      fpc_append($sEcoTxt,"sBlocoH=$sBlocoH,nVlICMSOP=$nVlICMSOP,nVlBCICMSST=$nVlBCICMSST,nVlICMSST=$nVlICMSST,nVlFCP=$nVlFCP");

      $hSql   = fhPrepareArrToInsert($hDb,$sTab,$aIns);
      if ($lOk==true) {
         $aVal = array();
         $aVal[] = $psLogin;
         $aVal[] = $pMaxBlocoKProc;
         $aVal[] = $sBlocoH;
         $aVal[] = $nVlICMSOP;
         $aVal[] = $nVlBCICMSST;
         $aVal[] = $nVlICMSST;
         $aVal[] = $nVlFCP;

         if ($lOk==true) {
            $aTmpSql = array();
            for ($iIns=0; $iIns<$iCountIns; $iIns++) $aTmpSql[] = array($aIns[$iIns],$aVal[$iIns]);
            $sTmpSql = fsArrToInsert($sTab,$aTmpSql);
            fpc_append($sEcoTxt,"sTmpSql=$sTmpSql");
            //$lOk = flDbInsert($hDb,$sTmpSql);
            //fpc_append($sEcoTxt,".lOk=$lOk");

            $lOk = flDBExecute($hSql,$aVal);
            fpc_append($sEcoTxt,"lOk=$lOk");
         }
      }   // lOk
      if ($lOk==false) break;
   }   // foreach
}   // lOk
*/


?>