<?php
set_time_limit(3600);
require_once('/qtux/www/FullPlat/pFuncoes1.php');
require_once('/qtux/www/FullPlat/pPublics1.php');
require_once('/qtux/library/PHPMailer-master/PHPMailerAutoload.php');
require_once('/qtux/www/FullPlat/pPublicMail.php');

list($sUsec, $sSec) = explode(' ', microtime());
$tScript_Start = (float) $sSec + (float) $sUsec;

//$psCliPasta = 'TQ'; // DEV,TQ,HOMOLOG
//$sHOST = $_SERVER["HOSTNAME"];
$sHOST = exec('hostname');
if (strpos($sHOST,'sanol.com.br')) {
   $psCliPasta = 'total';
} else {
   $psCliPasta = 'desenvolvimento';
}

$tJobStart = time();
$sProc     = basename(__FILE__);

$sLogFile = str_replace('.','_',$sProc).'-'.$tJobStart.'.log';

$sEcoTxt = '/qtux/www/FullPlat/processos/logs/'.str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = fsDirEcoTxt($sEcoTxt);

$iProcID = getmypid();

fpc($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));

$lOk  = true;
$lGo = false;

$lDebugEmail = false;

$sDia = date('Ymd',time());
fpc_append($sEcoTxt,"sDia=$sDia");
$sFileJaRodou = '/qtux/www/FullPlat/processos/controlproc/Control_FIN_CalcularJurosDiario.txt';

$sFileConfig = "/qtux/www/$psCliPasta/dd_files/Business.ddini";
fpc_append($sEcoTxt,"Arquivo ddini ($sFileConfig)");

if (file_exists($sFileConfig)) {
   //
   // Lendo parametros do arquivo de config
   //
   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLen_sLin = strlen($sLin);
      if ($iLen_sLin>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iCount_aLin = count($aLin);
         if ($iCount_aLin>1) $s2 = trim($aLin[1]);
         else                $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);   // criando uma var
         $sVarsTxt .= $s . chr(10);
      }
   }

   if ($lDebugEmail==false) {

      if (file_exists($sFileJaRodou)) {
         $sFileConteudo = fgc($sFileJaRodou);
         fpc_append($sEcoTxt,"sFileConteudo=$sFileConteudo");
         if ($sFileConteudo==$sDia) {
            $lGo=false;
            fpc_append($sEcoTxt,"Datas iguais, provavelmente o processo j rodou e no ir rodar novamente");
         } else {
            fpc($sFileJaRodou,"$sDia");
            fpc_append($sEcoTxt,"Datas diferentes, processo ir rodar");
            $lGo=true;
         }
      } else {
         fpc($sFileJaRodou,"$sDia");
         $lGo=true;
      }
      
      fpc_append($sEcoTxt,"lGo=$lGo");
      
      if ($lGo==true) {
      
         //$sDSN = '/qtux/database/tq/gps_01.gdb';
         //$sDSN = 'localhost:/qtux/database/tq/gps_01.gdb';
         //$sDSN = 'localhost:/qtux/database/total/gps_01.gdb';
      
         //if ($psCliPasta=='TQ')  $sDSN = '192.168.1.109:/qtux/database/total/gps_01.gdb';
         //if ($psCliPasta=='DEV') $sDSN = 'localhost:/qtux/database/tq/gps_01.gdb';
         //if ($psCliPasta=='HOMOLOG') $sDSN = 'localhost:/qtux/database/total/gps_01.gdb';
      
         $sDSN = "$sHost:$sPathDB/$sDB";
      
         $hDb  = fhDbConnect($sDSN);
         
         $sSql = "select a.pPId,
                         a.tVenc, 
                         b.jBanco,
                         b.n1Juros1Dia, -- jBanco==0
                         b.nBradJur1D,  -- jBanco==1 || jBanco==2
                         b.n2Juros1Dia, -- jBanco==3
                         e.pCid,
                         e.pUF,
                         a.nVenc,
                         a.nBruto,
                         a.nDescCTR,
                         a.nDesc,
                         a.nAbat, -- Est aqui apenas para talvez use em um futuro prox
                         a.nAcr,
                         a.nMora,
                         a.nJur,
                         a.nMulta,
                         a.nIOF
         
                  from Fin_Titulos    a   join  Tipo_Cobrancas b on a.pTipoCob = b.pPId    and b.iVer = b.iVAt
                                          join  Enderecos      d on d.pCup     = a.pSacado and d.iVer = d.iVAt and d.lCliCob=1 and d.lExc=0
                                          join  CEPs           e on d.pCep     = e.pPid    and e.iVer = e.iVAt
                  where a.lExc=0 
                    and a.iVer = a.iVAt
                    and cast(a.tVenc as date) < cast('today' as date) -- '2017-12-20' --cast('today' as date)
                    and a.lPrevisao = 0
                    --and a.pPId = 1834476
                    and a.jTipo = 0
                    and a.tCanc  is null
                    and a.tPgmto is null";
         
         $sDateIni = date('d/m/Y H:i:s',time());
         fpc_append($sEcoTxt,"Inicio Query $sDateIni");
         
         fpc_append($sEcoTxt,"1) sSql = $sSql");
         $aDb = faDbSelect($hDb,$sSql);
         
         $sDateFim = date('d/m/Y H:i:s',time());
         fpc_append($sEcoTxt,"Final Query $sDateFim");
         
         $iCount = count($aDb);
         fpc_append($sEcoTxt,"1) iCount=$iCount");
         
         list($sUsec, $sSec) = explode(' ', microtime());
         $tScript_StartLoop = (float) $sSec + (float) $sUsec;
         $sDateIniLoop = date('d/m/Y H:i:s',time());
         fpc_append($sEcoTxt,"Inicio Loop $sDateIniLoop");
         
         foreach ($aDb as $aLin) {
            $pTFin     = $aLin[0];
            $dVenc    = date('Y-m-d',strtotime($aLin[1]));
            //$dVenc    = '2018-11-23';
            $jBanco   = $aLin[2];
            $nPJur1   = $aLin[3]; // ITA
            $nPJur2   = $aLin[4]; // BRADESCO E BANCO DO BRASIL
            $nPJur3   = $aLin[5]; // SANTANDER
            $pCid     = $aLin[6];
            $pUF      = $aLin[7];
            //$nVenc    = $aLin[8];
            $nBruto   = $aLin[9];
            $nDescCTR = $aLin[10];
            $nDesc    = $aLin[11];
            $nAbat    = $aLin[12]; 
            $nAcr     = $aLin[13];
            $nMora    = $aLin[14];
            $nJurA    = $aLin[15];
            $nMulta   = $aLin[16];
            $nIOF     = $aLin[17];
         
            $nVenc    = $nBruto-$nDesc+$nAcr+$nMora+$nMulta+$nIOF-$nDescCTR; // Frmula em pTela2.js function FIN_Titulos_versaoA_dda, No uso o Juros nessa formula, para manter o valor nVenc Original
         
            $dNow   = date('Y-m-d',time());
            //$dNow   = '2019-07-18';
            fpc_append($sEcoTxt,"-----------------------------------------------------");
            fpc_append($sEcoTxt,"2) pTFin=$pTFin, dVenc=$dVenc, dNow=$dNow, nPJur1=$nPJur1,nPJur2=$nPJur2,nPJur3=$nPJur3,pCid=$pCid,pUF=$pUF,nVenc=$nVenc");
         
            $iDUtil  = fiQtosDiasUteisEntreDatas($dVenc,$dNow,$pUF,$pCid); // Verificando se tem dias teis ou no 
            fpc_append($sEcoTxt,"2) iDUtil=$iDUtil");
         
            $sSqlFeriados = "select jTipo,pMun,pUF,jAno,iDia,iMes,iAno
                               from Feriados
                              where lExc=0
                                and iVer=iVAt
                                and (
                                         jTipo=0
                                     or (jTipo=1 and pUF  = $pUF)
                                     or (jTipo=2 and pMun = $pCid)                                   
                                    )
                              order by iAno,iMes,iDia";
         
            $aFeriados = faDbSelect($hDb,$sSqlFeriados);
         
            $iCountFeriados = count($aFeriados);
         
            fpc_append($sEcoTxt,"2) iCountFeriados=$iCountFeriados, sSqlFeriados=$sSqlFeriados");
         
            if (flEh_DiaUtil($dVenc,$aFeriados,$pUF,$pCid)==false) {
               $iDUtil  = $iDUtil-1; // Subtraindo um dia, porque o prximo dia util apos o vencimento est contando na soma dos dias uteis, e nesse caso  calulado o juros aps o dia util q foi transferido o vencimento.
                                     // Exemplo: (Vencimento Dia 25, Sbado. 
                                     //           Prximo dia Util, Dia 27, Segunda Feira. (Porm no posso calcular o juros nesse dia, porque ainda est cabvel para pagamento) 
                                     //           O prximo dia util real para ser determinado se o titulo est ou no em atraso  a partir do Dia 28.   
            } 
         
            fpc_append($sEcoTxt,"2) iDUtil=$iDUtil");
         
            if ($iDUtil>0) { // Se o dia util for > 0,  porque est atrasado e no foi pago no proximo dia util aps o vencimento.
               $iDAtr  = fiQtosDiasEntreD1eD2($dVenc,$dNow); // Conforme no foi pago no prximo dia util, est sendo calculado em dias corridos a partir da data de vencimento. 
                                                             // Exemplo: (25,26,27,28)
               fpc_append($sEcoTxt,"3) iDAtr=$iDAtr, dVenc=$dVenc, dNow=$dNow");
             
               if (($nPJur1>0) || ($nPJur2>0) || ($nPJur3>0)) { 
                  if ($jBanco==0) {                       // ITA
                    $nJur = round(($nVenc/100*$nPJur1)*$iDAtr,2);
                    fpc_append($sEcoTxt,"4) jBanco=$jBanco,nVenc=$nVenc,nPJur1=$nPJur1,iDAtr=$iDAtr,nJur=$nJur");
                  } elseif (($jBanco==1)||($jBanco==2)) { // BRADESCO E BANCO DO BRASIL 
                    $nJur = round(($nVenc/100*$nPJur2)*$iDAtr,2);
                    fpc_append($sEcoTxt,"4) jBanco=$jBanco,nVenc=$nVenc,nPJur2=$nPJur2,iDAtr=$iDAtr,nJur=$nJur");
                  } elseif ($jBanco==4) {                 // SANTANDER
                    $nJur = round(($nVenc/100*$nPJur3)*$iDAtr,2);
                    fpc_append($sEcoTxt,"4) jBanco=$jBanco,nVenc=$nVenc,nPJur3=$nPJur3,iDAtr=$iDAtr,nJur=$nJur");
                  }
         
                  if  ($nJur>0) {  // Pode ter alguma porcentagem zerada e no preciso fazer o update nesse caso 
                     $nJurD = $nJur-$nJurA;
                     $nJurD = sprintf('%.2f',$nJurD); // tratar erro de valores de um centavo, exemplo: nJur=2.84,nJurA=2.83,nJurD=0.0099999999999998
         
                     $nVenc = $nBruto-$nDesc+$nAcr+$nMora+$nJur+$nMulta+$nIOF-$nDescCTR; // Frmula em pTela2.js function FIN_Titulos_versaoA_dda
         
                     fpc_append($sEcoTxt,"5) nJur=$nJur,nJurA=$nJurA,nJurD=$nJurD");
                     if ($lOk==true) { // Atualizando o juros no titulo financeiro 
                        $sSql = "update Fin_Titulos set nJur=$nJur,nVenc=$nVenc where iVer=iVAt and pPId=$pTFin";
                        $lOk  = flDbUpdate($hDb,$sSql);
                        fpc_append($sEcoTxt,"5) lOk=$lOk, sSql=$sSql");
                        if (!$lOk) {
                           $sErrorCode = ibase_errcode();
                           $sErrorText = ibase_errmsg();
                           fpc_append($sEcoTxt,"5) sErrorCode=$sErrorCode, sErrorText=$sErrorText");
                        }
                     }
         
                     if ($lOk==true) {
                        $sSql     = "select a.pPId from FIN_Detalhamento_Desc_Acresc a where a.iVer=a.iVAt and a.lExc=0 and a.pFin=$pTFin and a.jNat=1";
                        fpc_append($sEcoTxt,"6) sSql=$sSql");
                        $aDb      = faDbSelect($hDb,$sSql);
                        $iCountDb = count($aDb);
                        if ($iCountDb>0) {
                           $pDetDA      = $aDb[0][0]; 
                           fpc_append($sEcoTxt,"7) pDetDA=$pDetDA");
            
                           $lOk = flNovaVersaoRegistro($hDb,'FIN_Detalhamento_Desc_Acresc',$pDetDA);
                           if (!$lOk) {
                              $sErrorCode = ibase_errcode();
                              $sErrorText = ibase_errmsg();
                              fpc_append($sEcoTxt,"7) sErrorCode=$sErrorCode, sErrorText=$sErrorText");
                           }
         
                           if ($lOk==true) {
                              $sSql = "update FIN_Detalhamento_Desc_Acresc set sVer='$sEcoTxt',nValor=$nJur, sObs='Juros Calculado entre o perodo De $dVenc / At $dNow - Dias de Atraso $iDAtr' where iver=ivat and pPId=$pDetDA and jNat=1";
                              $lOk  = flDbUpdate($hDb,$sSql);
                              fpc_append($sEcoTxt,"7) lOk=$lOk, sSql=$sSql");
                              if (!$lOk) {
                                 $sErrorCode = ibase_errcode();
                                 $sErrorText = ibase_errmsg();
                                 fpc_append($sEcoTxt,"7) sErrorCode=$sErrorCode, sErrorText=$sErrorText");
                              }
                           }
         
                        } else {
                           // Lancar em FIN_Titulos_Detalhes
                           // aTipo       = Desconto,Acrscimo
                           // aNat        = Mora,Juros,Multa,IOF,(a)Contrato,(b)Devoluo,(c)Verba,(d)Outros
                           $aIns    = array();
                           $aIns[]  = array('pInc'     ,1);
                           $aIns[]  = array('sVer'     ,"$sEcoTxt");
                           $aIns[]  = array('pFin'     ,$pTFin);
                           $aIns[]  = array('jTipo'    ,1);   // ascrecimo 
                           $aIns[]  = array('jNat'     ,1);   // juros
                           $aIns[]  = array('nValor'   ,$nJur);
                           $aIns[]  = array('sObs'     ,"Juros Calculado entre o perodo De $dVenc / At $dNow - Dias de Atraso $iDAtr");
                           $sSql   = fsArrToInsert('FIN_Detalhamento_Desc_Acresc',$aIns);
                           $lOk = flDbInsert($hDb,$sSql);
                           fpc_append($sEcoTxt,"8) lOk=$lOk, sSql=$sSql");
                           if (!$lOk) {
                              $sErrorCode = ibase_errcode();
                              $sErrorText = ibase_errmsg();
                              fpc_append($sEcoTxt,"8) sErrorCode=$sErrorCode, sErrorText=$sErrorText");
                           }
                        }
                     }
                  } //  if  ($nJur>0) {
               } // if (($nPJur1>0) || (($nPJur2>0) || (($nPJur3>0))
            }
         }
         
         $sDateFimLoop = date('d/m/Y H:i:s',time());
         fpc_append($sEcoTxt,"Final Loop $sDateFimLoop");
         list($sUsec, $sSec) = explode(' ', microtime());
         $tScript_EndLoop = (float) $sSec + (float) $sUsec;
         $tElapsed_TimeLoop = round($tScript_EndLoop - $tScript_StartLoop, 5);
         fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_TimeLoop).', Secs: '.$tElapsed_TimeLoop.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");
         
         if ($lOk==true) {
            flDbCommit($hDb);
            fpc_append($sEcoTxt,"9) lOk=$lOk, commit");
         } else {
            flDbRollBack($hDb);
            fpc_append($sEcoTxt,"9) lOk=$lOk, rollback");
         }

         flDbDisconnect($hDb);

         $tJobEnd = time();

         fpc_append($sEcoTxt,'Final: '.date('d/m/Y H:i:s',$tJobEnd));

         list($sUsec, $sSec) = explode(' ', microtime());
         $tScript_End = (float) $sSec + (float) $sUsec;
         $tElapsed_Time = round($tScript_End - $tScript_Start, 5);
         fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");

      } //if ($lGo==true)

   } // if ($lDebugEmail==false)
       
   if (($lGo==true) || ($lDebugEmail==true) ) { 
      $oMail = new PHPMailer();
   
      $oMail->IsSMTP(); // Define que a mensagem ser SMTP
      $oMail->Host       = $sStmp; // Endereo do servidor SMTP (caso queira utilizar a autenticao, utilize o host smtp.seudomnio.com.br)
      $oMail->SMTPAuth   = true; // Usar autenticao SMTP (obrigatrio para smtp.seudomnio.com.br)
      $oMail->Username   = $sConta; // Usurio do servidor SMTP
      $oMail->Password   = $sSenha; // Senha do servidor SMTP
      $oMail->SMTPSecure = $sTipoSeguranca; //autenticao ssl, precisa ver se o servidor precisa para autenticaros tipos so: "", "ssl" ou "tls"
      $oMail->Port       = $iPorta;
      $oMail->CharSet    = 'ISO-8859-1';
      $oMail->SetLanguage("br", "libs/");
   
      $oMail->From     = $sConta; // Seu e-mail
      $oMail->Sender   = $sConta; // Seu e-mail
      $oMail->FromName = fsTiraAcento($sNomeEnv); // Seu nome
   
      $oMail->addReplyTo($sConta,$sConta);
      $oMail->AddAddress('ricardo@qtux.com.br','Ricardo');

//      if ($lDebugEmail==false) $oMail->AddCC('fredy@qtux.com.br','Fredy');
//      if ($lDebugEmail==false) $oMail->AddCC('henrique@qtux.com.br','Herique');
//      if ($lDebugEmail==false) $oMail->AddCC('rafaelbmoreira@qtux.com.br','Rafael');
   
      $oMail->IsHTML(true);

      $sDir = str_replace($sLogFile,'',$sEcoTxt);
      $sFileName = str_replace('.log','',$sLogFile);
      $sFileTar = $sFileName.'.tar';
      $sFileTarGz = $sFileName.'.tar.gz';
      /*
      **Ser usado 3 comandos na mesma linha para criar o tar, cada comando esta separado por ;
      **1) Direciono o processo para ir ao diretorio onde esto as logs
      **2)  criado um tar sem zipar pois a compresso do comando gzip  melhor que a compresso do tar
      **3) Por fim  gerado um gzip do arquivo .tar
      */
      exec("cd $sDir ; tar -cf $sDir$sFileTar $sLogFile ; gzip -9 $sFileTar");

      $oMail->AddAttachment($sDir.$sFileTarGz,$sFileTarGz);

      $sMailTitle1  = "Sistema QTUX";

      if ($lOk==false) {
         $sMailTitle2 = 'ERRO ao executar o processo Calcular Juros Dirio - Financeiro';
      } else {
         $sMailTitle2 = 'Sucesso ao executar o processo Calcular Juros Dirio - Financeiro';
      }

      $oMail->AddEmbeddedImage('/qtux/www/FullPlat/erpImages/logo-qtx-branco.png', 'my-attach-logo', 'logo-qtx-branco.png');
      $oMail->Subject  = fsTiraAcento($sMailTitle2);

      $sHTML  = '<html><head>';
      $sHTML .= '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" /></head>';
      $sHTML .= '<body style="background-color: #06334b;">';
      $sHTML .= '<center>';
      $sHTML .= '<h2><b><font color="white">'.$sMailTitle1.'</font></b></h2>';
      $sHTML .= '<h2><b><font color="white">'.$sMailTitle2.'</font></b></h2>';
      $sHTML .= '</center>';
      $sHTML .= '<table style="background-color:#FFFFE0; border-collapse:collapse; color:#000; font-size:16px; width:100%; ">';
      $sHTML .= '<tr>';
      $sHTML .= '<th style="background-color:#BDB76B; color:white; padding:5px; border:0;">INCIO</th>';
      $sHTML .= '<th style="background-color:#BDB76B; color:white; padding:5px; border:0;">FINAL</th>';
      $sHTML .= '<th style="background-color:#BDB76B; color:white; padding:5px; border:0;">LOG</th>';
      $sHTML .= '</tr>';
      $sHTML .= '<tr>';
      $sHTML .= '<th style="border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; padding:5px; border:0;">'.date('d/m/Y H:i:s',$tJobStart).'</th>';
      $sHTML .= '<th style="border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; padding:5px; border:0;">'.date('d/m/Y H:i:s',time()).'</th>';
      $sHTML .= '<th style="border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; padding:5px; border:0;">'.$sLogFile.'</th>';
      $sHTML .= '</tr>';      
      $sHTML .= '</table>';
      $sHTML .= '<center>';
      $sHTML .= '<font color="white">Para maiores detalhes, por favor entre em contato com o Administrador de Sistemas.</font><br>';
      $sHTML .= '<img alt="QTUX" src="cid:my-attach-logo"><br>';
      $sHTML .= '<font color="white"><b>&nbsp;Segue ao anexo a log do processo</b></font>.';
      $sHTML .= '</center>';
      $sHTML .= '</body></html>';

      fpc_append($sEcoTxt,"sHTML=$sHTML");

      $oMail->Body = $sHTML;

      $lOk = $oMail->Send();
      fpc_append($sEcoTxt,"Envio do Email lOk=$lOk ");
      $oMail->ClearAllRecipients();
      $oMail->ClearAttachments();
      unlink($sDir.$sFileTarGz);
   }   
}

$tJobEnd = time();
fpc_append($sEcoTxt,'Final: '.date('d/m/Y H:i:s',$tJobEnd));