<?php
set_time_limit(300);

fpc_append($sEcoTxt,"INICIO EMBARQUE $sEmbarque");
      
$aEmbarque = array();
$aEmbarque['embarque']  = $sEmbarque; // Long | Facultativo* | Nmero de identificao(oid) do embarque, retornado pelo mtodo /embarque/buscarRegistrosParaIntegracao
//$aEmbarque['protocolo'] = $aDb[0][0]; // Long | Facultativo* | Nmero do protocolo de importao do embarque
//$aEmbarque["numero"]    = $sEmbarque; // Long | Facultativo* | Nmero do embarque que deseja-se recuperar 
// *  obrigatrio informar pelo menos um dos campos.

fpc_append($sEcoTxt,'INICIO JSON QTUX A SER ENVIADO');
fpc_append($sEcoTxt,json_encode($aEmbarque, JSON_PRETTY_PRINT));
fpc_append($sEcoTxt,'FINAL JSON QTUX A SER ENVIADO');

$json_aEmbarque = json_encode($aEmbarque);

$lOk = true;
$iWhile = 0;
while (true) {
   $iWhile++;
   fpc_append($sEcoTxt,"REQUISIO QTUX - $sUrlRecuperarDados");
   $oRet = file_get_contents($sUrlRecuperarDados,null,stream_context_create(array(
                                 'http' => array('method'  => 'POST',
                                                 'header'  => "Authorization: Bearer $sToken\r\n".
                                                              "Content-type: application/json\r\n".
                                                              "Connection: close\r\n".
                                                              "Content-length: ".strlen($json_aEmbarque)."\r\n",
                                                 'content' => $json_aEmbarque,
                                                ),
                                )));
   $oRet = json_decode($oRet);
   $sTipo = gettype($oRet);
   fpc_append($sEcoTxt,'RETORNO JSON LINCROS');
   $sJsonRet = json_encode($oRet, JSON_PRETTY_PRINT);
   fpc_append($sEcoTxt,utf8_decode($sJsonRet));
   fpc_append($sEcoTxt,'gettype='.$sTipo);

   if (!empty($oRet->mensagem)) {
      $sMensagem = strtoupper(utf8_decode($oRet->mensagem));
      fpc_append($sEcoTxt,"sMensagem=$sMensagem");
   }

   $sStatus = '';
   if (!empty($oRet->status)) {
      $sStatus = strtoupper(utf8_decode($oRet->status));
      fpc_append($sEcoTxt,"sStatus=$sStatus");
   }

   if ($sTipo=='NULL') {
      sleep(5);
   } else if ($sTipo<>'NULL') {
      break;
   } else if ($iWhile==4) {
      fpc_append($sEcoTxt,'SEM RESPOSTA DA LINCROS');
      $lOk = false;
      break;
   }
} // while(true)   

$lErro          = false;
$lSalvarRetorno = true;

if ( ($sStatus=='CONFIRMADO') && ($lOk==true) ) {
   
   $lUpdate = false;
   $aErro = array();

   $sJson = 'wsEmbarque_recuperarDados_'.$sEmbarque.'_'.time().'.json';
   //fpc('/qtux/samba/edi/Lincros/Recebidos/'.$sJson,json_encode($oRet, JSON_PRETTY_PRINT));
   $sDirWS = '/qtux/samba/edi/Lincros/Recebidos/wsEmbarque/wsEmbarque_recuperarDados/';
   $sDirRecebidos = fsCriarDirAnoMesDia($sDirWS);
   fpc($sDirRecebidos.$sJson,json_encode($oRet, JSON_PRETTY_PRINT));

   $pTpVeiculo = 0;
   $pTransp = 0;
   $pVeic = 0;

   $pEmbarque = 0;   

   //
   // INICIO CAPA EMBARQUE
   //   
   $aEmbarque   = array();
   $oEmbarque = $oRet->embarque;
   if (!empty($oEmbarque->oidEmbarque)) {
      $sOidEmbarque = strtoupper(utf8_decode($oEmbarque->oidEmbarque)); // Long | Identificador do objeto (oid) embarque
      fpc_append($sEcoTxt,"sOidEmbarque=$sOidEmbarque");
      $aEmbarque[] = array('sOidEmbarque', $sOidEmbarque);
   }

   //if (!empty($oEmbarque->numeroEmbarque)) {
   if (!empty($oEmbarque->numero)) {
      $sNumeroEmbarque = strtoupper(utf8_decode($oEmbarque->numero)); // Long | Nmero do embarque.
      fpc_append($sEcoTxt,"sNumeroEmbarque=$sNumeroEmbarque");
      $aEmbarque[] = array('sNumeroEmbarque', $sNumeroEmbarque);
   }

   if (!empty($oEmbarque->protocolo)) {
      $sProtocolo = '';
      $oEmbarqueProtocolo = $oEmbarque->protocolo; // List<Long> Lista com os protocolos de importao do embarque. Campo visvel somente se estiver populado
      foreach ($oEmbarqueProtocolo as $oValue) { 
         if (!empty($oValue->protocolo)) {
            $sProtocolo .= strtoupper(utf8_decode($oValue->protocolo)).', ';
         }
      } // foreach ($oEmbarqueProtocolo as $oValue)
      fpc_append($sEcoTxt,"sProtocolo=$sProtocolo");
      $aEmbarque[] = array('sProtocolo', $sProtocolo);
   } // if (!empty($oEmbarque->protocolo)) 

   if (!empty($oEmbarque->dataCriacao)) {
      $sDataCriacao = strtoupper(utf8_decode($oEmbarque->dataCriacao)); // String | Data de criao do embarque. YYYY-MM-DD HH:MM:SS
      fpc_append($sEcoTxt,"sDataCriacao=$sDataCriacao");
      $aEmbarque[] = array('tDataCriacao', $sDataCriacao);
   }

   if (!empty($oEmbarque->dataEmbarque)) {
      $sDataEmbarque = strtoupper(utf8_decode($oEmbarque->dataEmbarque)); // String | Data de embarque. YYYY-MM-DD HH:MM:SS
      fpc_append($sEcoTxt,"sDataEmbarque=$sDataEmbarque");
      $aEmbarque[] = array('tDataEmbarque', $sDataEmbarque);
   }

   if (!empty($oEmbarque->usuarioGravacao)) {
      $sUsuarioGravacao = strtoupper(utf8_decode($oEmbarque->usuarioGravacao)); // String | Nome do usurio de gravao do embarque.
      fpc_append($sEcoTxt,"sUsuarioGravacao=$sUsuarioGravacao");
      $aEmbarque[] = array('sUsuarioGravacao', $sUsuarioGravacao);
   }

   if (!empty($oEmbarque->tipoLancamento)) {
      $iTipoLancamento = strtoupper(utf8_decode($oEmbarque->tipoLancamento)); // Integer| Tipo de lanamento do embarque. 0=Manual, 1=Transportador 
      fpc_append($sEcoTxt,"iTipoLancamento=$iTipoLancamento");
      $aEmbarque[] = array('jTipoLancamento', $iTipoLancamento);
   }

   if (!empty($oEmbarque->situacao)) {
      $iSituacao = strtoupper(utf8_decode($oEmbarque->situacao)); // Integer| Situao do Embarque 0=Criado, 1=Em transporte, 2=Transportado, 3=Cancelado, 4=Aguardando empresa, 5=Confirmado
      fpc_append($sEcoTxt,"iSituacao=$iSituacao");
      $aEmbarque[] = array('jSituacao', $iSituacao);
   }

   if (!empty($oEmbarque->modal)) {
      $sModal = strtoupper(utf8_decode($oEmbarque->modal)); // String | Descrio do modal do embarque Campo visvel somente se estiver populado
      fpc_append($sEcoTxt,"sModal=$sModal");
      $aEmbarque[] = array('sModal', $sModal);
   }

   if (!empty($oEmbarque->formaNegociacao)) {
      $iFormaNegociacao = strtoupper(utf8_decode($oEmbarque->formaNegociacao)); // Integer| Forma de negociao do embarque. 0=CIF, 1=FOB, 2=EXW, 3=FCA,4=CPT, 5=CIP, 6=DAT, 7=DAP,8=DDP, 9=FAZ, 10=CFR
      fpc_append($sEcoTxt,"iFormaNegociacao=$iFormaNegociacao");
      $aEmbarque[] = array('jFormaNegociacao', $iFormaNegociacao);
   }

   if (!empty($oEmbarque->cnpjPessoaResponsavel)) {
      $sCnpjPessoaResponsavel = strtoupper(utf8_decode($oEmbarque->cnpjPessoaResponsavel)); // String | Nmero do documento (CNPJ) do responsvel pelo embarque. Sem formatao.
      fpc_append($sEcoTxt,"sCnpjPessoaResponsavel=$sCnpjPessoaResponsavel");
      $aEmbarque[] = array('sCnpjPessoaResponsavel', $sCnpjPessoaResponsavel);
   }

   if (!empty($oEmbarque->cepOrigem)) {
      $sCepOrigem = strtoupper(utf8_decode($oEmbarque->cepOrigem)); // String | Nmero do CEP da localizao de origem do embarque. Sem formatao.
      fpc_append($sEcoTxt,"sCepOrigem=$sCepOrigem");
      $aEmbarque[] = array('sCepOrigem', $sCepOrigem);
   }

   if (!empty($oEmbarque->cdIbgeOrigem)) {
      $iCdIbgeOrigem = strtoupper(utf8_decode($oEmbarque->cdIbgeOrigem)); // Integer| Nmero do cdigo do IBGE da cidade de origem.
      fpc_append($sEcoTxt,"iCdIbgeOrigem=$iCdIbgeOrigem");
      $aEmbarque[] = array('iCdIbgeOrigem', $iCdIbgeOrigem);
   }

   if (!empty($oEmbarque->cepDestino)) {
      $sCepDestino = strtoupper(utf8_decode($oEmbarque->cepDestino)); // String | Nmero do CEP da localizao de destino do embarque. Sem formatao.
      fpc_append($sEcoTxt,"sCepDestino=$sCepDestino");
      $aEmbarque[] = array('sCepDestino', $sCepDestino);
   }

   if (!empty($oEmbarque->cdIbgeDestino)) {
      $iCdIbgeDestino = strtoupper(utf8_decode($oEmbarque->cdIbgeDestino)); // Integer| Nmero do cdigo do IBGE da cidade de destino.
      fpc_append($sEcoTxt,"iCdIbgeDestino=$iCdIbgeDestino");
      $aEmbarque[] = array('iCdIbgeDestino', $iCdIbgeDestino);
   }

   if (!empty($oEmbarque->kmRodado)) {
      $nKmRodado = strtoupper(utf8_decode($oEmbarque->kmRodado)); // Double | Quantidade de quilmetros rodados.
      fpc_append($sEcoTxt,"nKmRodado=$nKmRodado");
      $aEmbarque[] = array('nKmRodado', $nKmRodado);
   }

   if (!empty($oEmbarque->kmTotal)) {
      $nKmTotal = strtoupper(utf8_decode($oEmbarque->kmTotal)); // Double | Quantidade total de quilmetros do trecho.
      fpc_append($sEcoTxt,"nKmTotal=$nKmTotal");
      $aEmbarque[] = array('nKmTotal', $nKmTotal);
   }

   if (!empty($oEmbarque->cdCodigoDistribuicao)) {
      $sCdCodigoDistribuicao = strtoupper(utf8_decode($oEmbarque->cdCodigoDistribuicao)); // String | Cdigo do canal de distribuio. Campo visvel somente se estiver populado
      fpc_append($sEcoTxt,"sCdCodigoDistribuicao=$sCdCodigoDistribuicao");
      $aEmbarque[] = array('sCdCodigoDistribuicao', $sCdCodigoDistribuicao);
   }

   if (!empty($oEmbarque->numeroCotacao)) {
      $sNumeroCotacao = strtoupper(utf8_decode($oEmbarque->numeroCotacao)); // Long   | Numero da cotao spot. Campo visvel somente se houver uma cotao ativa. (ABERTA, FECHADA, EM_CONTRAPROPOSTA, CONFIRMADA ou APROVADA.
      fpc_append($sEcoTxt,"sNumeroCotacao=$sNumeroCotacao");
      $aEmbarque[] = array('sNumeroCotacao', $sNumeroCotacao);
   }

   if (!empty($oEmbarque->fluxoTransporte)) {
      $sFluxoTransporte = strtoupper(utf8_decode($oEmbarque->fluxoTransporte)); // String | Cdigo do fluxo de transporte. Campo visvel somente se estiver populado
      fpc_append($sEcoTxt,"sFluxoTransporte=$sFluxoTransporte");
      $aEmbarque[] = array('sFluxoTransporte', $sFluxoTransporte);
   }

   if (!empty($oEmbarque->tipoViagem)) {
      $sTipoViagem = strtoupper(utf8_decode($oEmbarque->tipoViagem)); // String | Cdigo do tipo de viagem. Campo visvel somente se estiver populado
      fpc_append($sEcoTxt,"sTipoViagem=$sTipoViagem");
      $aEmbarque[] = array('sTipoViagem', $sTipoViagem);
   }

   if (!empty($oEmbarque->placa)) {
      $sPlaca = strtoupper(utf8_decode($oEmbarque->placa)); // String | Placa.
      fpc_append($sEcoTxt,"sPlaca=$sPlaca");

      //$sPlaca = 'AAA0001';

      $aEmbarque[] = array('sPlaca', $sPlaca);

      $sSql = "select first 1 pPId, pMot  from Veiculos where iVer = iVAt and sPlaca = '$sPlaca'";
      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDb = faDbSelect($hDb,$sSql);
      $iCount_aDb = count($aDb);
      fpc_append($sEcoTxt,"iCount_aDb=$iCount_aDb");
      if ($iCount_aDb>0) {
         $pVeic          = $aDb[0][0];
         $pMot           = $aDb[0][1];
         fpc_append($sEcoTxt,"pVeic=$pVeic, pMot=$pMot");
         $aEmbarque[] = array('pVeic', $pVeic);
         $aEmbarque[] = array('pMot', $pMot);
      } else {
         //$lErro = true;
         //$aErro[] = "No foi encontrado Veiculo com a placa $sPlaca no ERP";
      }
   } 

   if (!empty($oEmbarque->grupoVeiculo)) {
      $sGrupoVeiculo = strtoupper(fsTiraAcento(utf8_decode($oEmbarque->grupoVeiculo))); // String | Descrio do grupo de veiculo. Campo visvel somente se estiver populado
      fpc_append($sEcoTxt,"sGrupoVeiculo=$sGrupoVeiculo");
      $aEmbarque[] = array('sGrupoVeiculo', $sGrupoVeiculo);
      
      $sSql = "select pPId from Tipo_Veiculos where iVer = iVAt and sDescricao = '$sGrupoVeiculo'";
      $aDb = faDbSelect($hDb,$sSql);
      $iCount_aDb = count($aDb);
      if ($iCount_aDb==0) {
         $lErro = true;
         $aErro[] = "No foi encontrado o grupo do veiculo $sGrupoVeiculo";
      } else {
         $pTpVeiculo = $aDb[0][0];
         $aEmbarque[] = array('pTpVeiculo', $pTpVeiculo);
      }
      
   } else {
      $lErro = true;
      $aErro[] = "No foi informando o grupo do veiculo";
   }

   if (!empty($oEmbarque->idRoteirizacao)) {
      $sIdRoteirizacao = strtoupper(utf8_decode($oEmbarque->idRoteirizacao)); // Long   | Id da simulao de roteirizao. Campo visvel somente se estiver populado
      fpc_append($sEcoTxt,"sIdRoteirizacao=$sIdRoteirizacao");
      $aEmbarque[] = array('sIdRoteirizacao', $sIdRoteirizacao);
   }

   if (!empty($oEmbarque->cnpjTransportadoraFilial)) { 
      $sCnpjTransportadoraFilial = strtoupper(utf8_decode($oEmbarque->cnpjTransportadoraFilial)); // String Nmero do CNPJ da filial da transportadora. Campo visvel somente se estiver populado
      fpc_append($sEcoTxt,"sCnpjTransportadoraFilial=$sCnpjTransportadoraFilial");
      $aEmbarque[] = array('sCnpjTransportadoraFilial', $sCnpjTransportadoraFilial);
      $sSql = "select pPId from CUP where iVer = iVAt and lExc = 0 and sCNPJ = '$sCnpjTransportadoraFilial'";
      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDb = faDbSelect($hDb,$sSql);
      $iCount_aDb = count($aDb);
      fpc_append($sEcoTxt,"iCount_aDb=$iCount_aDb");
      if ($iCount_aDb>0) {
         $pTransp = $aDb[0][0];
         fpc_append($sEcoTxt,"pTransp=$pTransp");
         $aEmbarque[] = array('pTransp', $pTransp);
      } else {
         $lErro  = true;
         $aErro[] = "Transportadora com CNPJ $sCnpjTransportadoraFilial no encontrada no ERP.";
      }
   } else {
      $lErro  = true;
      $aErro[] = "A Transportadora no foi informada.";
   } // if (!empty($oEmbarque->cnpjTransportadoraFilial))

   if (!empty($oEmbarque->tabela)) {
      $sTabela = strtoupper(utf8_decode($oEmbarque->tabela)); // String Tabela de frete vinculado ao embarque. (ID - Descrio) Campo visvel somente se estiver populado
      fpc_append($sEcoTxt,"sTabela=$sTabela");
      $aEmbarque[] = array('sTabela', $sTabela);
   }

   if (!empty($oEmbarque->marcadoresTabelaFrete)) {
      $sMarcadoresTabelaFrete = '';
      $oEmbarqueMarcadoresTabelaFrete = $oEmbarque->marcadoresTabelaFrete; // List<String> Lista de cdigo dos marcadores da tabela de frete
      foreach ($oEmbarqueMarcadoresTabelaFrete as $oValue) { 
         if (!empty($oValue->marcadoresTabelaFrete)) {
            $sMarcadoresTabelaFrete .= strtoupper(utf8_decode($oValue->marcadoresTabelaFrete)).', ';
         }
      } // foreach ($oEmbarqueMarcadoresTabelaFrete as $oValue)
      fpc_append($sEcoTxt,"sMarcadoresTabelaFrete=$sMarcadoresTabelaFrete");
      $aEmbarque[] = array('sMarcadoresTabelaFrete', $sMarcadoresTabelaFrete);
   } // if (!empty($oEmbarque->marcadoresTabelaFrete))

   if (!empty($oEmbarque->marcadores)) {
      $sMarcadores = '';
      $oEmbarqueMarcadores = $oEmbarque->marcadores;
      foreach ($oEmbarqueMarcadores as $oValue) { // marcadores List<String> Lista com o cdigo dos marcadores do embarque
         if (!empty($oValue)) {
            $sMarcadores .= strtoupper(utf8_decode($oValue)).' ,';
         }
      } // foreach ($oEmbarqueMarcadores as $oValue)
      fpc_append($sEcoTxt,"sMarcadores=$sMarcadores");
      $aEmbarque[] = array('sMarcadores', $sMarcadores);
   } // if (!empty($oEmbarque->marcadores))

   if ( ($pTpVeiculo>0) && ($pTransp>0) && ($pVeic==0) ){
      $sSql = "select pPId from Veiculos where pMot = $pTransp and pTipoVeic = $pTpVeiculo";
      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDb  = faDbSelect($hDb,$sSql);
      $iCount_aDb = count($aDb);
      fpc_append($sEcoTxt,"iCount_aDb=$iCount_aDb");
      if ($iCount_aDb>0) {
         $pVeic = $aDb[0][0];
         fpc_append($sEcoTxt,"pVeic=$pVeic");
         $aEmbarque[] = array('pVeic', $pVeic);
      }
   }

   $iCount_aEmbarque = count($aEmbarque);
   fpc_append($sEcoTxt,"iCount_aEmbarque=$iCount_aEmbarque");
   if ( ($iCount_aEmbarque>0) && ($lOk==true) ) {
      $aEmbarque[] = array('pInc'  ,$psLogin);
      $aEmbarque[] = array('tInc'  ,'now'   );
      $aEmbarque[] = array('pReceb',$psLogin);
      $aEmbarque[] = array('tReceb','now'   );
      $aEmbarque[] = array('sJson' ,$sJson  );

      $sSql = "select a.pPId,
                      a.pOCa,
                      b.tConf

                 from Lincros_Embarques a left join OCa b on a.pOCa = b.pPId and b.iVer = b.iVAt and b.lExc = 0

                where a.iVer = a.iVAt 
                  and a.lExc = 0 
                  --and a.sNumeroEmbarque = '$sEmbarque'
                  and a.sOidEmbarque = '$sEmbarque'";

      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDb  = faDbSelect($hDb,$sSql);
      $iCount_aDb = count($aDb);
      fpc_append($sEcoTxt,"iCount_aDb=$iCount_aDb");
      if ($iCount_aDb>0) {
         $pEmbarque = $aDb[0][0];
         $pOCa      = $aDb[0][1];
         $tConf_OCa = $aDb[0][2];
         fpc_append($sEcoTxt,"pEmbarque=$pEmbarque");

         // 1 Verificar se ordem de carregamento j existe para o embarque que est recebendo.
         // 2 Se j existir, verificar se ela est confirmada.
         // 3 Se ela j estiver confirmada, tem que descobrir as PreNFs que foi gerada para a ordem de carregamento existente. 
         if ( $pOCa>0 ) {
            if ($tConf_OCa<>'') {
               // 4 Verificar se alguma das PreNFs j est confirmada.
               $sSql = "select count(*) from PreNF where iVer = iVAt and lExc = 0 and pOCa=$pOCa and tNFCapa is not null";
               fpc_append($sEcoTxt,"sSql=$sSql");
               $aDb  = faDbSelect($hDb,$sSql);
               $iCount_aDb = $aDb[0][0];
               fpc_append($sEcoTxt,"iCount_aDb=$iCount_aDb");
               if ($iCount_aDb>0) {
                  // 5 Se algumas das PReNFs estiverem confirmadas, travar o processo e no receber mais o embarque. 
                  $lGo   = false;
                  $lErro = true;
                  $aErro[] = 'Esse embarque no pode ser integrado, j existe um ou mais pedidos faturados';
               } else {
                  // 6 Se nenhuma das PreNFs tiver confirmada, tem que excluir a Ordem existente e as PReNFs amarradas a ela.
                  if ($lOk==true) {
                     $sSql = "delete from OCa where pPId=$pOCa";
                     fpc_append($sEcoTxt,"sSql=$sSql");
                     $lOk = $lLigaQry==true ? flDbDelete($hDb,$sSql) : true;
                     fpc_append($sEcoTxt,"lOk=$lOk");
                  } // if ($lOk==true) 
   
                  if ($lOk==true) {
                     $sSql = "delete from PreNF where pOCa=$pOCa";
                     fpc_append($sEcoTxt,"sSql=$sSql");
                     $lOk = $lLigaQry==true ? flDbDelete($hDb,$sSql) : true;
                     fpc_append($sEcoTxt,"lOk=$lOk");
                  } // if ($lOk==true) 
   
                  if ($lOk==true) {
                     $lGo = true;
                  } else {
                     $lGo = false;
                  } // if ($lOk==true)
               } // if ($iCount_aDb>0)
            } else {
               if ($lOk==true) {
                  $sSql = "delete from OCa where pPId=$pOCa";
                  fpc_append($sEcoTxt,"sSql=$sSql");
                  $lOk = $lLigaQry==true ? flDbDelete($hDb,$sSql) : true;
                  fpc_append($sEcoTxt,"lOk=$lOk");
               } // if ($lOk==true)

               if ($lOk==true) {
                  $lGo = true;
               } else {
                  $lGo = false;
               } // if ($lOk==true)
            } // if ($tConf_OCa<>'') )
         } else {
            $lGo = true;
         } // if ( ($pOCa>0) && ($tConf_OCa<>'') )

         fpc_append($sEcoTxt,"lGo=$lGo");

         if ($lGo==true) {
            $lUpdate = true;
            $lOk = $lLigaQry==true ? flNovaVersaoRegistro($hDb,'Lincros_Embarques',$pEmbarque) : true;
            fpc_append($sEcoTxt,"lOk=$lOk");
            if ($lOk==true) {
               $sSql = fsArrToUpdate('Lincros_Embarques',$aEmbarque,"iVer=iVAt and pPId=$pEmbarque");
               fpc_append($sEcoTxt,"sSql=$sSql");
               $lOk = $lLigaQry==true ? flDbUpdate($hDb,$sSql) : true;
               fpc_append($sEcoTxt,"lOk=$lOk");
            } // if ($lOk==true)
         } // if ($lGo == true)

      } else {
         $sSql = 'select GEN_ID(Lincros_Embarques, 0) from RDB$DATABASE';
         fpc_append($sEcoTxt,"Query (3) = $sSql");
         $aDb  = faDbSelect($hDb,$sSql);
         $pMaxEmbarque = $aDb[0][0]-100;
         fpc_append($sEcoTxt,"pMaxEmbarque=$pMaxEmbarque");
   
         $sSql = fsArrToInsert('Lincros_Embarques',$aEmbarque);
         fpc_append($sEcoTxt,"insert Lincros_Embarques = $sSql");
         $lOk  = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
         fpc_append($sEcoTxt,"lOk=$lOk");
         if ( ($lOk==true) && ($lLigaQry==true) ) {
            $sSql = "select max(pPId) from Lincros_Embarques where pIn0=$psLogin and iVer=iVAt and pPId>=$pMaxEmbarque";
            fpc_append($sEcoTxt,"Query (3) = $sSql");
            $aDb  = faDbSelect($hDb,$sSql);
            $pEmbarque = $aDb[0][0];
            fpc_append($sEcoTxt,"pEmbarque=$pEmbarque");
         }
      
         if ($lOk==false) {
            fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques");
         }
      } // if ($iCount_aDb>0)
   } // if ( ($iCount_aUpdEmbarque>0) && ($lOk==true) ) 
   //
   // FINAL CAPA EMBARQUE
   //

   //
   // INICIO ORDENS COLETA
   //
   if ( ($lOk==true) && ($lGo==true) ) {
      if (!empty($oEmbarque->nrOrdemColeta)) {
         $oEmbarqueNrOrdemColeta = $oEmbarque->nrOrdemColeta; // List<String> Lista com os nmeros de ordens de coleta. Nmero separado por vrgula
         foreach ($oEmbarqueNrOrdemColeta as $oValue) {
            $aOrdensColeta = array();
            if (!empty($oValue->nrOrdemColeta)) {
               $sNrOrdemColeta = strtoupper(utf8_decode($oValue->nrOrdemColeta));
               fpc_append($sEcoTxt,"sNrOrdemColeta=$sNrOrdemColeta");
               $aOrdensColeta[] = array('sNrOrdemColeta',$sNrOrdemColeta);
            }
            $aOrdensColeta[] = array('pInc'     ,$psLogin  );
            $aOrdensColeta[] = array('tInc'     ,'now'     );
            $aOrdensColeta[] = array('pEmbarque',$pEmbarque);
            if ($lUpdate==true) {
               $sSql = "select pPId from Lincros_Embarques_OrdensColeta where iVer = iVAt and lExc = 0 and pEmbarque=$pEmbarque and sNrOrdemColeta='$sNrOrdemColeta'";
               $aDb = faDbSelect($hDb,$sSql);
               $iCount_aDb = count($aDb);
               fpc_append($sEcoTxt,"iCount_aDb=$iCount_aDb");
               if ($iCount_aDb>0) {
                  $pLincrosEmbarqueOrdensColeta = $aDb[0][0];
                  $lOk = $lLigaQry==true ? flNovaVersaoRegistro($hDb,'Lincros_Embarques_OrdensColeta',$pLincrosEmbarqueOrdensColeta) : true;
                  fpc_append($sEcoTxt,"lOk=$lOk");
                  if ($lOk==true) {
                     $sSql = fsArrToUpdate('Lincros_Embarques_OrdensColeta',$aOrdensColeta,"iVer=iVAt and pPId = $pLincrosEmbarqueOrdensColeta");
                     fpc_append($sEcoTxt,"sSql=$sSql");
                     $lOk = $lLigaQry==true ? flDbUpdate($hDb,$sSql) : true;
                     fpc_append($sEcoTxt,"lOk=$lOk");
                  }
                  if ($lOk==false) {
                     fpc_append($sEcoTxt,"ERRO UPDATE Lincros_Embarques_OrdensColeta");
                     break;
                  }
               } else {
                  $sSql = fsArrToInsert('Lincros_Embarques_OrdensColeta',$aOrdensColeta);
                  fpc_append($sEcoTxt,"sSql=$sSql");
                  $lOk = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
                  fpc_append($sEcoTxt,"lOk=$lOk");
                  if ($lOk==false) {
                     fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_OrdensColeta");
                     break;
                  }               
               }
            } else {
               $sSql = fsArrToInsert('Lincros_Embarques_OrdensColeta',$aOrdensColeta);
               fpc_append($sEcoTxt,"sSql=$sSql");
               $lOk = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
               fpc_append($sEcoTxt,"lOk=$lOk");
               if ($lOk==false) {
                  fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_OrdensColeta");
                  break;
               }
            }
         } // foreach ($oEmbarqueNrOrdemColeta as $oValue)
      } // if (!empty($oEmbarque->nrOrdemColeta))
   } // if ( ($lOk==true) && ($lGo==true) ) 
   //
   // FIM ORDENS COLETA
   //

   //
   // INICIO MOVIMENTOS
   //
   if ( ($lOk==true) && ($lGo==true) ) {
      $oEmbarqueMovimentos = $oEmbarque->movimentos; // movimentos List<Movimento> Lista de movimentos do embarque.
      //fpc_append($sEcoTxt,chr(10).'var_dump Movimentos CAPA = '.fsVarDumpToString($oEmbarqueMovimentos).chr(10));
      if (!empty($oEmbarqueMovimentos)) {   
         foreach ($oEmbarqueMovimentos as $oValue) {
            $aInsEmbarqueMovimentos = array();
      
            if (!empty($oValue->codigo)) {         
               $sCodigo = strtoupper(utf8_decode($oValue->codigo)); // String  | Cdigo do componente de frete
               fpc_append($sEcoTxt,"sCodigo=$sCodigo");
               $aInsEmbarqueMovimentos[] = array('sCodigo', $sCodigo);
            } else {
               $lErro = true;
               $aErro[] = "No foi informado o cdigo nos Movimentos na Capa";
            } // if (!empty($oValue->codigo))
      
            if (!empty($oValue->observacao)) {
               $sObservacao = strtoupper(utf8_decode($oValue->observacao)); // String  | Campo observao do componente
               fpc_append($sEcoTxt,"sObservacao=$sObservacao");
               $aInsEmbarqueMovimentos[] = array('sObservacao', $sObservacao);
            } // if (!empty($oValue->observacao))
      
            if (!empty($oValue->valorCalculado)) { 
               $nValorCalculado = strtoupper(utf8_decode($oValue->valorCalculado)); // Double  | Valor calculado do movimento
               fpc_append($sEcoTxt,"nValorCalculado=$nValorCalculado");
               $aInsEmbarqueMovimentos[] = array('nValorCalculado', $nValorCalculado);
            } else {
//               $lErro = true;
//               $aErro[] = "No foi informado o Valor Calculado nos Movimentos na Capa";
            } // if (!empty($oValue->valorCalculado))
      
            if (!empty($oValue->valor)) {
               $nValor = strtoupper(utf8_decode($oValue->valor)); // Double  | Valor realizado do movimento
               fpc_append($sEcoTxt,"nValor=$nValor");
               $aInsEmbarqueMovimentos[] = array('nValor', $nValor);
            } // if (!empty($oValue->valor))
      
            if (!empty($oValue->icms)) {
               $lIcms = strtoupper(utf8_decode($oValue->icms)); // Boolean | Indicador se o componente considera ICMS no clculo
               fpc_append($sEcoTxt,"lIcms=$lIcms");
               $aInsEmbarqueMovimentos[] = array('lIcms', $lIcms);
            } // if (!empty($oValue->icms))
      
            $iCount_aInsEmbarqueMovimentos = count($aInsEmbarqueMovimentos);
            if ($iCount_aInsEmbarqueMovimentos>0) {
               $aInsEmbarqueMovimentos[] = array('pInc'     , $psLogin  );
               $aInsEmbarqueMovimentos[] = array('tInc'     ,'now'      );
               $aInsEmbarqueMovimentos[] = array('pEmbarque', $pEmbarque);

               if ($lUpdate==true) {
                  $sSql = "select pPId from Lincros_Embarques_Movimentos where iVer = iVAt and lExc = 0 and pEmbarque=$pEmbarque and sCodigo='$sCodigo'";
                  fpc_append($sEcoTxt,"sSql=$sSql");
                  $aDb = faDbSelect($hDb,$sSql);
                  $iCount_aDb = count($aDb);
                  fpc_append($sEcoTxt,"iCount_aDb=$iCount_aDb");
                  if ($iCount_aDb>0) {
                     $pLincrosEmbarquesMovimentos = $aDb[0][0];
                     fpc_append($sEcoTxt,"pLincrosEmbarquesMovimentos=$pLincrosEmbarquesMovimentos");
                     $lOk = $lLigaQry==true ? flNovaVersaoRegistro($hDb,'Lincros_Embarques_Movimentos',$pLincrosEmbarquesMovimentos) : true;
                     fpc_append($sEcoTxt,"lOk=$lOk");
                     if ($lOk==true) {
                        $sSql = fsArrToUpdate('Lincros_Embarques_Movimentos',$aInsEmbarqueMovimentos,"iVer=iVAt and pPId = $pLincrosEmbarquesMovimentos");
                        fpc_append($sEcoTxt,"sSql=$sSql");
                        $lOk = $lLigaQry==true ? flDbUpdate($hDb,$sSql) : true;
                        fpc_append($sEcoTxt,"lOk=$lOk");
                        if ($lOk==false) {
                           fpc_append($sEcoTxt,"ERRO UPDATE Lincros_Embarques_Movimentos");
                           break;
                        }
                     }
                  } else {
                     $sSql = fsArrToInsert('Lincros_Embarques_Movimentos',$aInsEmbarqueMovimentos);
                     fpc_append($sEcoTxt,"sSql=$sSql");
                     $lOk = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
                     fpc_append($sEcoTxt,"lOk=$lOk");
   
                     if ($lOk==false) {
                        fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_Movimentos");
                        break;
                     }
                  }
               } else {         
                  $sSql = fsArrToInsert('Lincros_Embarques_Movimentos',$aInsEmbarqueMovimentos);
                  fpc_append($sEcoTxt,"sSql=$sSql");
                  $lOk = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
                  fpc_append($sEcoTxt,"lOk=$lOk");
      
                  if ($lOk==false) {
                     fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_Movimentos");
                     break;
                  }
               }
            }
         } // foreach ($oEmbarqueMovimentos as $oValue)
      } else {
         $lErro = true;
         $aErro[] = "No foi informado os Movimentos na Capa";
      } // if (!empty($oEmbarqueMovimentos))
   } // if ( ($lOk==true) && ($lGo==true) ) 
   //
   // FINAL MOVIMENTOS
   //

   //
   // INICIO DOCUMENTOS
   //
   if ( ($lOk==true) && ($lGo==true) ) {
      //
      // INICIO CAPA DOCUMENTOS
      //
      $oEmbarqueDocumentos = $oEmbarque->documentos; // Documento Lista de documentos vinculados ao embarque. Pr-nota e Nota
      foreach ($oEmbarqueDocumentos as $oValue) {
         $aEmbarqueDocumentos = array();
         if (!empty($oValue->chave)) {
            $sChave = $oValue->chave; // String | Valor da chave da nota fiscal Somente para Nota Fiscal.
            fpc_append($sEcoTxt,"sChave=$sChave");
            $aEmbarqueDocumentos[] = array('sChave', $sChave);
         }
   
         if (!empty($oValue->cnpjEmissor)) {
            $sCnpjEmissor = strtoupper(utf8_decode($oValue->cnpjEmissor)); // String | Nmero do CNPJ do emissor do documento Sem formatao
            fpc_append($sEcoTxt,"sCnpjEmissor=$sCnpjEmissor");
            $aEmbarqueDocumentos[] = array('sCnpjEmissor', $sCnpjEmissor);
         }
   
         if (!empty($oValue->cnpjUnidade)) {
            $sCnpjUnidade = strtoupper(utf8_decode($oValue->cnpjUnidade)); // String | Nmero do CNPJ da unidade do embarcador Sem formatao
            fpc_append($sEcoTxt,"sCnpjUnidade=$sCnpjUnidade");
            $aEmbarqueDocumentos[] = array('sCnpjUnidade', $sCnpjUnidade);
         }
   
         if (!empty($oValue->dataEmissao)) {
            $sDataEmissao = strtoupper(utf8_decode($oValue->dataEmissao)); // String | Data de emisso do documento. YYYY-MM-DD HH:MM:SS
            fpc_append($sEcoTxt,"sDataEmissao=$sDataEmissao");
            $aEmbarqueDocumentos[] = array('tDataEmissao', $sDataEmissao);
         }
   
         if (!empty($oValue->naturezaOperacao)) { // Natureza de operao Detalhe da natureza de operao do documento. Campo visvel somente se estiver populado
            $oEmbarqueDocumentosNaturezaOperacao = $oValue->naturezaOperacao;
            if (!empty($oEmbarqueDocumentosNaturezaOperacao->codigo)) {
               $sNaturezaOperacaoCodigo = strtoupper(utf8_decode($oEmbarqueDocumentosNaturezaOperacao->codigo)); // String | Cdigo da natureza de operao.
               fpc_append($sEcoTxt,"sNaturezaOperacaoCodigo=$sNaturezaOperacaoCodigo");
               $aEmbarqueDocumentos[] = array('sNaturezaOperacaoCodigo', $sNaturezaOperacaoCodigo);
            }
   
            if ($oEmbarqueDocumentosNaturezaOperacao->nome) {
               $sNaturezaOperacaoNome = strtoupper(utf8_decode($oEmbarqueDocumentosNaturezaOperacao->nome)); // String | Descrio da natureza de operao.
               fpc_append($sEcoTxt,"sNaturezaOperacaoNome=$sNaturezaOperacaoNome");
               $aEmbarqueDocumentos[] = array('sNaturezaOperacaoNome', $sNaturezaOperacaoNome);
            }
         }
   
         if (!empty($oValue->numero)) {
            $sNumero = strtoupper(utf8_decode($oValue->numero)); // Long   | Nmero do documento fiscal
            fpc_append($sEcoTxt,"sNumero=$sNumero");
            $iLen = strlen($sNumero);
            $sNumero = substr($sNumero,0,$iLen-2);
            $aEmbarqueDocumentos[] = array('sNumero', $sNumero);
         }
   
         if (!empty($oValue->sequencia)) {
            $iSequencia     = strtoupper(utf8_decode($oValue->sequencia));     // Integer | Ordem do documento dentro do embarque.
            fpc_append($sEcoTxt,"iSequencia=$iSequencia");
            $aEmbarqueDocumentos[] = array('iSequencia', $iSequencia);
         }
         if (!empty($oValue->serie)) {
            $sSerie         = strtoupper(utf8_decode($oValue->serie));         // String  | Srie do documento fiscal
            fpc_append($sEcoTxt,"sSerie=$sSerie");
            $aEmbarqueDocumentos[] = array('sSerie', $sSerie);
         }
         if (!empty($oValue->tipoDocumento)) {
            $iTipoDocumento = $oValue->tipoDocumento; // Integer Tipo do documento fiscal 0=Nota fiscal, 1=Pr-nota Fiscal, 2 =Pedido, 3 = Autorizao postagem, 4= Coleta Domiciliar, 5 = Invoice
            fpc_append($sEcoTxt,"iTipoDocumento=$iTipoDocumento");
            $aEmbarqueDocumentos[] = array('jTipoDocumento', $iTipoDocumento);
         }
   
         $iCount_aUpdEmbarqueDocumentos = count($aEmbarqueDocumentos);
         if ($iCount_aUpdEmbarqueDocumentos>0) {
            $aEmbarqueDocumentos[] = array('pInc'     ,$psLogin  );
            $aEmbarqueDocumentos[] = array('tInc'     ,'now'     );
            $aEmbarqueDocumentos[] = array('pEmbarque',$pEmbarque);

            if ($lUpdate==true) {
               $sSql = "select pPId from Lincros_Embarques_Documentos where iVer = iVAt and lExc = 0 and pEmbarque=$pEmbarque and sNumero='$sNumero' and sSerie='$sSerie'";
               fpc_append($sEcoTxt,"sSql=$sSql");
               $aDb = faDbSelect($hDb,$sSql);
               $iCount_aDb = count($aDb);
               fpc_append($sEcoTxt,"iCount_aDb=$iCount_aDb");
               if ($iCount_aDb>0) {
                  $pEmbarqueDoc = $aDb[0][0];
                  fpc_append($sEcoTxt,"pEmbarqueDoc=$pEmbarqueDoc");
                  $lOk = $lLigaQry==true ? flNovaVersaoRegistro($hDb,'Lincros_Embarques_Documentos',$pEmbarqueDoc) : true;
                  fpc_append($sEcoTxt,"lOk=$lOk");
                  if ($lOk==true) {
                     $sSql = fsArrToUpdate('Lincros_Embarques_Documentos',$aEmbarqueDocumentos,"iVer=iVAt and pPId=$pEmbarqueDoc");
                     fpc_append($sEcoTxt,"sSql=$sSql");
                     $lOk = $lLigaQry==true ? flDbUpdate($hDb,$sSql) : true;
                     fpc_append($sEcoTxt,"lOk=$lOk");
         
                     if ($lOk==false) {
                        fpc_append($sEcoTxt,"ERRO UPDATE Lincros_Embarques_Documentos");
                        break;
                     }
                  }
               } else {
                  $sSql = 'select GEN_ID(Lincros_Embarques_Documentos, 0) from RDB$DATABASE';
                  fpc_append($sEcoTxt,"Query Lincros_Embarques_Documentos = $sSql");
                  $aDb  = faDbSelect($hDb,$sSql);
                  $pMaxEmbarqueDoc = $aDb[0][0]-100;
                  fpc_append($sEcoTxt,"pMaxEmbarqueDoc=$pMaxEmbarqueDoc");

                  $sSql = fsArrToInsert('Lincros_Embarques_Documentos',$aEmbarqueDocumentos);
                  fpc_append($sEcoTxt,"insert Lincros_Embarques_Documentos = $sSql");
                  $lOk  = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
                  fpc_append($sEcoTxt,"lOk=$lOk");
         
                  if ( ($lOk==true) && ($lLigaQry==true) ) {
            
                     $sSql = "select max(pPId) from Lincros_Embarques_Documentos where pIn0=$psLogin and iVer=iVAt and pPId>=$pMaxEmbarqueDoc";
                     fpc_append($sEcoTxt,"sSql=$sSql");
                     $aDb  = faDbSelect($hDb,$sSql);
                     $pEmbarqueDoc = $aDb[0][0];
                     fpc_append($sEcoTxt,"pEmbarqueDoc=$pEmbarqueDoc");
                  } else {
                     fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_Documentos");
                     break;
                  }
               }
            } else {
               $sSql = 'select GEN_ID(Lincros_Embarques_Documentos, 0) from RDB$DATABASE';
               fpc_append($sEcoTxt,"Query Lincros_Embarques_Documentos = $sSql");
               $aDb  = faDbSelect($hDb,$sSql);
               $pMaxEmbarqueDoc = $aDb[0][0]-100;
               fpc_append($sEcoTxt,"pMaxEmbarqueDoc=$pMaxEmbarqueDoc");

               $sSql = fsArrToInsert('Lincros_Embarques_Documentos',$aEmbarqueDocumentos);
               fpc_append($sEcoTxt,"insert Lincros_Embarques_Documentos = $sSql");
               $lOk  = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
               fpc_append($sEcoTxt,"lOk=$lOk");
      
               if ( ($lOk==true) && ($lLigaQry==true) ) {
         
                  $sSql = "select max(pPId) from Lincros_Embarques_Documentos where pIn0=$psLogin and iVer=iVAt and pPId>=$pMaxEmbarqueDoc";
                  fpc_append($sEcoTxt,"sSql=$sSql");
                  $aDb  = faDbSelect($hDb,$sSql);
                  $pEmbarqueDoc = $aDb[0][0];
                  fpc_append($sEcoTxt,"pEmbarqueDoc=$pEmbarqueDoc");
               } else {
                  fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_Documentos");
                  break;
               }
            } // if ($lUpdate==true)
         } // if ($iCount_aUpdEmbarqueDocumentos>0)
         //
         // FINAL CAPA DOCUMENTOS
         //

         //
         // INICIO DOCUMENTOS PRE CONHECIMENTOS
         //      
         if ($lOk==true) {
            //
            // INICIO DETALHE DOS CONHECIMENTOS DO DOCUMENTO FISCAL
            //
            $oEmbarqueDocumentosPreConhecimentos = $oValue->preConhecimentos; // List<Conhecimento> Detalhe dos conhecimentos do documento fiscal
            foreach ($oEmbarqueDocumentosPreConhecimentos as $oValue2) {
               $pEmbarqueDocPreCon = 0;
               $aEmbarqueDocumentosPreConhecimentos = array();
               if (!empty($oValue2->oidConhecimento)) {
                  $sOidConhecimento  = strtoupper(utf8_decode($oValue2->oidConhecimento)); // Long    | Identificador do objeto (oid) do conhecimento.
                  fpc_append($sEcoTxt,"sOidConhecimento=$sOidConhecimento");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sOidConhecimento', $sOidConhecimento);
               }
               if (!empty($oValue2->sequencia)) {
                  $iSequencia = strtoupper(utf8_decode($oValue2->sequencia)); // Integer | Ordem do conhecimento dentro do documento. Campo visvel somente se estiver populado
                  fpc_append($sEcoTxt,"iSequencia=$iSequencia");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('iSequencia', $iSequencia);
               }
               if (!empty($oValue2->tipoConhecimento)) { 
                  $iTipoConhecimento = strtoupper(utf8_decode($oValue2->tipoConhecimento)); // Integer | Tipo do conhecimento. 0=Redespacho, 1=Normal,2=Cortesia, 3=Devoluo,4=Reentrega, 5=Exportao,6=Refaturamento, 7=Paletizao,8=Carga fechada, 9=Importao,10=ICMS antecipado, 11=Reembolso,12=ICMS complementar,3=Descarga, 14=Estadia, 15=Diria,16=Complementar, 17=Veculo,18=Escolta
                  fpc_append($sEcoTxt,"iTipoConhecimento=$iTipoConhecimento");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('jTipoConhecimento', $iTipoConhecimento);
               }
               if (!empty($oValue2->previsaoEntrega)) {
                  $sPrevisaoEntrega = strtoupper(utf8_decode($oValue2->previsaoEntrega)); // String  | Data de previso de entrega. YYYY-MM-DD HH:MM:SS
                  fpc_append($sEcoTxt,"sPrevisaoEntrega=$sPrevisaoEntrega");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('tPrevisaoEntrega', $sPrevisaoEntrega);
               }
               if (!empty($oValue2->diasEntrega)) {
                  $iDiasEntrega = strtoupper(utf8_decode($oValue2->diasEntrega)); // Integer | Prazo em quantidade de dias para a entrega
                  fpc_append($sEcoTxt,"iDiasEntrega=$iDiasEntrega");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('iDiasEntrega', $iDiasEntrega);
               }
               if (!empty($oValue2->cepOrigem)) {
                  $sCepOrigem = strtoupper(utf8_decode($oValue2->cepOrigem)); // String  | Nmero do CEP da localizao de origem Sem formatao
                  fpc_append($sEcoTxt,"sCepOrigem=$sCepOrigem");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sCepOrigem', $sCepOrigem);
               }
               if (!empty($oValue2->cdIbgeOrigem)) {
                  $iCdIbgeOrigem = strtoupper(utf8_decode($oValue2->cdIbgeOrigem)); // Integer | Cdigo IBGE do municpio de origem.
                  fpc_append($sEcoTxt,"iCdIbgeOrigem=$iCdIbgeOrigem");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('iCdIbgeOrigem', $iCdIbgeOrigem);
               }
               if (!empty($oValue2->cepDestino)) {
                  $sCepDestino = strtoupper(utf8_decode($oValue2->cepDestino)); // String  | Nmero do CEP da localizao de destino Sem formatao
                  fpc_append($sEcoTxt,"sCepDestino=$sCepDestino");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sCepDestino', $sCepDestino);
               }
               if (!empty($oValue2->cdIbgeDestino)) {
                  $iCdIbgeDestino = strtoupper(utf8_decode($oValue2->cdIbgeDestino)); // Integer | Cdigo IBGE do municpio de destino.
                  fpc_append($sEcoTxt,"iCdIbgeDestino=$iCdIbgeDestino");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('iCdIbgeDestino', $iCdIbgeDestino);
               }
      
               $oEmbarqueDocumentosRemetente = $oValue2->remetente; // Pessoa  | Detalhes do remetente
               if (!empty($oEmbarqueDocumentosRemetente->oid)) { 
                  $sOidRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->oid)); // Long Identificador do objeto (oid) da pessoa.
                  fpc_append($sEcoTxt,"sOidRemet=$sOidRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sOidRemet', $sOidRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->numeroDocumento)) { 
                  $sNumeroDocumentoRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->numeroDocumento)); // String Nmero do CNPJ ou CPF da pessoa (Sem formatao)
                  fpc_append($sEcoTxt,"sNumeroDocumentoRemet=$sNumeroDocumentoRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sNumeroDocumentoRemet', $sNumeroDocumentoRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->nome)) { 
                  $sNomeRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->nome)); //  String Razo social ou nome da pessoa
                  fpc_append($sEcoTxt,"sNomeRemet=$sNomeRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sNomeRemet', $sNomeRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->nomeFantasia)) { 
                  $sNomeFantasiaRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->nomeFantasia)); //  String Nome fantasia da pessoa
                  fpc_append($sEcoTxt,"sNomeFantasiaRemet=$sNomeFantasiaRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sNomeFantasiaRemet', $sNomeFantasiaRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->site)) { 
                  $sSiteRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->site)); //  String Endereo do site
                  fpc_append($sEcoTxt,"sSiteRemet=$sSiteRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sSiteRemet', $sSiteRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->telefone)) { 
                  $sTelefoneRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->telefone)); //  String Nmero do telefone
                  fpc_append($sEcoTxt,"sTelefoneRemet=$sTelefoneRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sTelefoneRemet', $sTelefoneRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->logradouro)) { 
                  $sLogradouroRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->logradouro)); //  String Descrio do logradouro do endereo
                  fpc_append($sEcoTxt,"sLogradouroRemet=$sLogradouroRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sLogradouroRemet', $sLogradouroRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->cep)) { 
                  $iCepRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->cep)); //  Integer Cdigo do endereamento postal (Sem formatao)
                  fpc_append($sEcoTxt,"iCepRemet=$iCepRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sCepRemet', $iCepRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->bairro)) { 
                  $sBairroRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->bairro)); //  String Nome do bairro do endereo
                  fpc_append($sEcoTxt,"sBairroRemet=$sBairroRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sBairroRemet', $sBairroRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->contato)) { 
                  $sContatoRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->contato)); //  String Informaes adicionais do contato
                  fpc_append($sEcoTxt,"sContatoRemet=$sContatoRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sContatoRemet', $sContatoRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->beneficiarioINSS)) { 
                  $lBeneficiarioINSSRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->beneficiarioINSS)); //  Boolean Indicador se a pessoa  beneficiria do INSS
                  fpc_append($sEcoTxt,"lBeneficiarioINSSRemet=$lBeneficiarioINSSRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('lBeneficiarioINSSRemet', $lBeneficiarioINSSRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->numeroPis)) { 
                  $sNumeroPisRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->numeroPis)); //  String Nmero do PIS.
                  fpc_append($sEcoTxt,"sNumeroPisRemet=$sNumeroPisRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sNumeroPisRemet', $sNumeroPisRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->ativo)) { 
                  $lAtivoRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->ativo)); //  Boolean Indicador de cadastro ativo
                  fpc_append($sEcoTxt,"lAtivoRemet=$lAtivoRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('lAtivoRemet', $lAtivoRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->inscricaoEstadual)) { 
                  $sInscricaoEstadualRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->inscricaoEstadual)); //  String Nmero inscrio estadual (Sem formatao)
                  fpc_append($sEcoTxt,"sInscricaoEstadualRemet=$sInscricaoEstadualRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sInscricaoEstadualRemet', $sInscricaoEstadualRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->cidade)) { 
                  $sCidadeRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->cidade)); //  String Nome da cidade.
                  fpc_append($sEcoTxt,"sCidadeRemet=$sCidadeRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sCidadeRemet', $sCidadeRemet);
               }
               if (!empty($oEmbarqueDocumentosRemetente->numeroLogradouro)) { 
                  $sNumeroLogradouroRemet = strtoupper(utf8_decode($oEmbarqueDocumentosRemetente->numeroLogradouro)); //  String Nmero do endereo.
                  fpc_append($sEcoTxt,"sNumeroLogradouroRemet=$sNumeroLogradouroRemet");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sNumeroLogradouroRemet', $sNumeroLogradouroRemet);
               }
      
               $oEmbarqueDocumentosDestinatario = $oValue2->destinatario; // Pessoa  | Detalhes do destinatrio
               if (!empty($oEmbarqueDocumentosDestinatario->oid)) { 
                  $sOidDest = $oEmbarqueDocumentosDestinatario->oid; // Long Identificador do objeto (oid) da pessoa.
                  fpc_append($sEcoTxt,"sOidDest=$sOidDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sOidDest', $sOidDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->numeroDocumento)) { 
                  $sNumeroDocumentoDest = $oEmbarqueDocumentosDestinatario->numeroDocumento; // String Nmero do CNPJ ou CPF da pessoa (Sem formatao)
                  fpc_append($sEcoTxt,"sNumeroDocumentoDest=$sNumeroDocumentoDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sNumeroDocumentoDest', $sNumeroDocumentoDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->nome)) { 
                  $sNomeDest = $oEmbarqueDocumentosDestinatario->nome; //  String Razo social ou nome da pessoa
                  fpc_append($sEcoTxt,"sNomeDest=$sNomeDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sNomeDest', $sNomeDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->nomeFantasia)) { 
                  $sNomeFantasiaDest = $oEmbarqueDocumentosDestinatario->nomeFantasia; //  String Nome fantasia da pessoa
                  fpc_append($sEcoTxt,"sNomeFantasiaDest=$sNomeFantasiaDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sNomeFantasiaDest', $sNomeFantasiaDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->site)) { 
                  $sSiteDest = $oEmbarqueDocumentosDestinatario->site; //  String Endereo do site
                  fpc_append($sEcoTxt,"sSiteDest=$sSiteDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sSiteDest', $sSiteDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->telefone)) { 
                  $sTelefoneDest = $oEmbarqueDocumentosDestinatario->telefone; //  String Nmero do telefone
                  fpc_append($sEcoTxt,"sTelefoneDest=$sTelefoneDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sTelefoneDest', $sTelefoneDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->logradouro)) { 
                  $sLogradouroDest = $oEmbarqueDocumentosDestinatario->logradouro; //  String Descrio do logradouro do endereo
                  fpc_append($sEcoTxt,"sLogradouroDest=$sLogradouroDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sLogradouroDest', $sLogradouroDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->cep)) { 
                  $iCepDest = $oEmbarqueDocumentosDestinatario->cep; //  Integer Cdigo do endereamento postal (Sem formatao)
                  fpc_append($sEcoTxt,"iCepDest=$iCepDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sCepDest', $iCepDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->bairro)) { 
                  $sBairroDest = $oEmbarqueDocumentosDestinatario->bairro; //  String Nome do bairro do endereo
                  fpc_append($sEcoTxt,"sBairroDest=$sBairroDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sBairroDest', $sBairroDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->contato)) { 
                  $sContatoDest = $oEmbarqueDocumentosDestinatario->contato; //  String Informaes adicionais do contato
                  fpc_append($sEcoTxt,"sContatoDest=$sContatoDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sContatoDest', $sContatoDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->beneficiarioINSS)) { 
                  $lBeneficiarioINSSDest = $oEmbarqueDocumentosDestinatario->beneficiarioINSS; //  Boolean Indicador se a pessoa  beneficiria do INSS
                  fpc_append($sEcoTxt,"lBeneficiarioINSSDest=$lBeneficiarioINSSDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('lBeneficiarioINSSDest', $lBeneficiarioINSSDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->numeroPis)) { 
                  $sNumeroPisDest = $oEmbarqueDocumentosDestinatario->numeroPis; //  String Nmero do PIS.
                  fpc_append($sEcoTxt,"sNumeroPisDest=$sNumeroPisDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sNumeroPisDest', $sNumeroPisDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->ativo)) { 
                  $lAtivoDest = $oEmbarqueDocumentosDestinatario->ativo; //  Boolean Indicador de cadastro ativo
                  fpc_append($sEcoTxt,"lAtivoDest=$lAtivoDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('lAtivoDest', $lAtivoDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->inscricaoEstadual)) { 
                  $sInscricaoEstadualDest = $oEmbarqueDocumentosDestinatario->inscricaoEstadual; //  String Nmero inscrio estadual (Sem formatao)
                  fpc_append($sEcoTxt,"sInscricaoEstadualDest=$sInscricaoEstadualDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sInscricaoEstadualDest', $sInscricaoEstadualDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->cidade)) { 
                  $sCidadeDest = $oEmbarqueDocumentosDestinatario->cidade; //  String Nome da cidade.
                  fpc_append($sEcoTxt,"sCidadeDest=$sCidadeDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sCidadeDest', $sCidadeDest);
               }
               if (!empty($oEmbarqueDocumentosDestinatario->numeroLogradouro)) { 
                  $sNumeroLogradouroDest = $oEmbarqueDocumentosDestinatario->numeroLogradouro; //  String Nmero do endereo.
                  fpc_append($sEcoTxt,"sNumeroLogradouroDest=$sNumeroLogradouroDest");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sNumeroLogradouroDest', $sNumeroLogradouroDest);
               }
               
               $sMarcadores = '';
               $oEmbarqueDocumentosPreConhecimentoMarcadores = $oValue2->marcadores; // List<String> Lista de cdigo dos marcadores do conhecimento
               foreach ($oEmbarqueDocumentosPreConhecimentoMarcadores as $oValue3) {
                  if (!empty($oValue3)) {
                     $sMarcadorores .= strtoupper(utf8_decode($oValue3)).', ';
                  }
                  fpc_append($sEcoTxt,"sMarcadores=$sMarcadores");
                  $aEmbarqueDocumentosPreConhecimentos[] = array('sMarcadorores', $sMarcadorores);
               } // foreach ($oEmbarqueDocumentosPreConhecimentoMarcadores as $oValue3)

               $iCount_aUpdEmbarqueDocumentosPreConhecimentos = count($aEmbarqueDocumentosPreConhecimentos);
               if ($iCount_aUpdEmbarqueDocumentosPreConhecimentos>0) {
                  $aEmbarqueDocumentosPreConhecimentos[] = array('pInc'        ,$psLogin     );
                  $aEmbarqueDocumentosPreConhecimentos[] = array('tInc'        ,'now'        );
                  $aEmbarqueDocumentosPreConhecimentos[] = array('pEmbarque'   ,$pEmbarque   );
                  $aEmbarqueDocumentosPreConhecimentos[] = array('pEmbarqueDoc',$pEmbarqueDoc);

                  if ($lUpdate==true) {
                     $sSql = "select pPId from Lincros_Embarques_Docs_PreCon where iVer = iVAt and lExc = 0 and pEmbarqueDoc=$pEmbarqueDoc and sOidConhecimento='$sOidConhecimento'";
                     fpc_append($sEcoTxt,"sSql=$sSql");
                     $aDb = faDbSelect($hDb,$sSql);
                     $iCount_aDb = count($aDb);
                     fpc_append($sEcoTxt,"iCount_aDb=$iCount_aDb");
                     if ($iCount_aDb>0) {
                        $pEmbarqueDocsPreCon = $aDb[0][0];
                        fpc_append($sEcoTxt,"pEmbarqueDocsPreCon=$pEmbarqueDocsPreCon");
                        $lOk = $lLigaQry==true ? flNovaVersaoRegistro($hDb,'Lincros_Embarques_Docs_PreCon',$pEmbarqueDocsPreCon) : true;
                        fpc_append($sEcoTxt,"lOk=$lOk");
   
                        if ($lOk==true) {
                           $sSql = fsArrToUpdate('Lincros_Embarques_Docs_PreCon',$aEmbarqueDocumentosPreConhecimentos,"iVer=iVAt and pPId=$pEmbarqueDocsPreCon");
                           fpc_append($sEcoTxt,"sSql=$sSql");
                           $lOk = $lLigaQry==true ? flDbUpdate($hDb,$sSql) : true;
                           fpc_append($sEcoTxt,"lOk=$lOk");
                           if ($lOk==false) {
                              fpc_append($sEcoTxt,"ERRO UPDATE Lincros_Embarques_Docs_PreCon");
                              break;
                           }
                        }
                     } else {
                        $sSql = fsArrToInsert('Lincros_Embarques_Docs_PreCon',$aEmbarqueDocumentosPreConhecimentos);
                        fpc_append($sEcoTxt,"sSql = $sSql");
                        $lOk  = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
                        fpc_append($sEcoTxt,"lOk=$lOk");
                        if ($lOk==false) {
                           fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_Docs_PreCon");
                           break;
                        }
                     }
                  } else {
                     $sSql = fsArrToInsert('Lincros_Embarques_Docs_PreCon',$aEmbarqueDocumentosPreConhecimentos);
                     fpc_append($sEcoTxt,"sSql = $sSql");
                     $lOk  = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
                     fpc_append($sEcoTxt,"lOk=$lOk");
                     if ($lOk==false) {
                        fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_Docs_PreCon");
                        break;
                     }
                  } // if ($lUpdate==true)
               } // if ($iCount_aUpdEmbarqueDocumentosPreConhecimentos>0) 
               //
               // FINAL DETALHE DOS CONHECIMENTOS DO DOCUMENTO FISCAL
               //


               if ($lOk==true) {
                  //
                  // INICIO MOVIMENTOS
                  //
                  if (!empty($oValue2->movimentos)) {
                     $oEmbarqueDocumentosPreConhecimentoMovimentos = $oValue2->movimentos; // List<Movimento> Lista de movimentos.
                     foreach ($oEmbarqueDocumentosPreConhecimentoMovimentos as $oValue3) {
                        $aInsEmbarqueDocumentosPreConhecimentoMovimentos = array();
                        if (!empty($oValue3->codigo)) {         
                           $sCodigo = strtoupper(utf8_decode($oValue3->codigo)); // String  | Cdigo do componente de frete
                           fpc_append($sEcoTxt,"sCodigo=$sCodigo");
                           $aInsEmbarqueDocumentosPreConhecimentoMovimentos[] = array('sCodigo', $sCodigo);
                        }
                        if (!empty($oValue3->observacao)) {
                           $sObservacao = strtoupper(utf8_decode($oValue3->observacao)); // String  | Campo observao do componente
                           fpc_append($sEcoTxt,"sObservacao=$sObservacao");
                           $aInsEmbarqueDocumentosPreConhecimentoMovimentos[] = array('sObservacao', $sObservacao);
                        }
                        if (!empty($oValue3->valorCalculado)) { 
                           $nValorCalculado = strtoupper(utf8_decode($oValue3->valorCalculado)); // Double  | Valor calculado do movimento
                           fpc_append($sEcoTxt,"nValorCalculado=$nValorCalculado");
                           $aInsEmbarqueDocumentosPreConhecimentoMovimentos[] = array('nValorCalculado', $nValorCalculado);
                        }
                        if (!empty($oValue3->valor)) {
                           $nValor = strtoupper(utf8_decode($oValue3->valor)); // Double  | Valor realizado do movimento
                           fpc_append($sEcoTxt,"nValor=$nValor");
                           $aInsEmbarqueDocumentosPreConhecimentoMovimentos[] = array('nValor', $nValor);
                        }
                        if (!empty($oValue3->icms)) {
                           $lIcms = strtoupper(utf8_decode($oValue3->icms)); // Boolean | Indicador se o componente considera ICMS no clculo
                           fpc_append($sEcoTxt,"lIcms=$lIcms");
                           $aInsEmbarqueDocumentosPreConhecimentoMovimentos[] = array('lIcms', $lIcms);
                        }
                        $iCount_aInsEmbarqueDocumentosPreConhecimentoMovimentos = count($aInsEmbarqueDocumentosPreConhecimentoMovimentos);
                        if ($iCount_aInsEmbarqueDocumentosPreConhecimentoMovimentos>0) {
                           $aInsEmbarqueDocumentosPreConhecimentoMovimentos[] = array('pInc'              ,$psLogin           );
                           $aInsEmbarqueDocumentosPreConhecimentoMovimentos[] = array('tInc'              ,'now'              );
                           $aInsEmbarqueDocumentosPreConhecimentoMovimentos[] = array('pEmbarque'         ,$pEmbarque         );
                           $aInsEmbarqueDocumentosPreConhecimentoMovimentos[] = array('pEmbarqueDoc'      ,$pEmbarqueDoc      );
                           $aInsEmbarqueDocumentosPreConhecimentoMovimentos[] = array('pEmbarqueDocPreCon',$pEmbarqueDocPreCon);

                           if ($lUpdate==true) {
                              $sSql = "select pPId from Lincros_Embarques_DocsPreConMov where iVer = iVAt and lExc = 0 and pEmbarqueDocPreCon=$pEmbarqueDocPreCon and sCodigo='$sCodigo'";
                              fpc_append($sEcoTxt,"sSql=$sSql");
                              $aDb = faDbSelect($hDb,$sSql);
                              $iCount_aDb = count($aDb);
                              fpc_append($sEcoTxt,"iCount_aDb=$iCount_aDb");
                              if ($iCount_aDb>0) {
                                 $pEmbarqueDocsPreConMov = $aDb[0][0];
                                 fpc_append($sEcoTxt,"pEmbarqueDocsPreConMov=$pEmbarqueDocsPreConMov");
                                 $lOk = $lLigaQry==true ? flNovaVersaoRegistro($hDb,'Lincros_Embarques_DocsPreConMov',$pEmbarqueDocsPreConMov) : true;
                                 fpc_append($sEcoTxt,"lOk=$lOk");

                                 if ($lOk==true) {
                                    $sSql = fsArrToUpdate('Lincros_Embarques_DocsPreConMov',$aInsEmbarqueDocumentosPreConhecimentoMovimentos,"iVer=iVAt and pPId=$pEmbarqueDocsPreConMov");
                                    fpc_append($sEcoTxt,"sSql=$sSql");
                                    $lOk = $lLigaQry==true ? flDbUpdate($hDb,$sSql) : true;
                                    fpc_append($sEcoTxt,"lOk=$lOk");
   
                                    if ($lOk==false) {
                                       fpc_append($sEcoTxt,"ERRO UPDATE Lincros_Embarques_DocsPreConMov");
                                       break;
                                    }
                                 } // if ($lOk==true)
                              } else {
                                 $sSql = fsArrToInsert('Lincros_Embarques_DocsPreConMov',$aInsEmbarqueDocumentosPreConhecimentoMovimentos);
                                 fpc_append($sEcoTxt,"sSql=$sSql");
                                 $lOk = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
                                 fpc_append($sEcoTxt,"lOk=$lOk");
         
                                 if ($lOk==false) {
                                    fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_DocsPreConMov");
                                    break;
                                 }
                              }
                           } else {
                              $sSql = fsArrToInsert('Lincros_Embarques_DocsPreConMov',$aInsEmbarqueDocumentosPreConhecimentoMovimentos);
                              fpc_append($sEcoTxt,"sSql=$sSql");
                              $lOk = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
                              fpc_append($sEcoTxt,"lOk=$lOk");
         
                              if ($lOk==false) {
                                 fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_DocsPreConMov");
                                 break;
                              }
                           }
                        } // if ($iCount_aInsEmbarqueDocumentosPreConhecimentoMovimentos>0)
                     } // foreach ($oEmbarqueDocumentosPreConhecimentoMovimentos as $oValue3)
                  } // if (!empty($oValue2-->movimentos))
                  //
                  // FNAL MOVIMENTOS
                  //
               } //
                  
               if ($lOk==true) {
                  //
                  // INICIO REDESPACHO
                  //       
                  if (!empty($oValue2->redespacho)) {
                     $oEmbarqueDocumentosPreConhecimentoRedespacho = $oValue2->redespacho; // Redespacho Informaes detalhadas do redespacho
                     foreach ($oEmbarqueDocumentosPreConhecimentoRedespacho  as $oValue3) {
                        $aInsEmbarqueDocumentosPreConhecimentoRedespacho = array();
                        if (!empty($oValue3->oidRedespacho)) { 
                           $sOidRedespacho = strtoupper(utf8_decode($oValue3->oidRedespacho)); // Long | Identificador do objeto (oid) do redespacho
                           fpc_append($sEcoTxt,"sOidRedespacho=$sOidRedespacho");
                           $aInsEmbarqueDocumentosPreConhecimentoRedespacho[] = array('sOidRedespacho', $sOidRedespacho);
                        }
                        if (!empty($oValue3->tabela)) {
                           $sTabela = strtoupper(utf8_decode($oValue3->tabela));// String | Cdigo + Nome da tabela de Frete do Redespacho
                           fpc_append($sEcoTxt,"sTabela=$sTabela");
                           $aInsEmbarqueDocumentosPreConhecimentoRedespacho[] = array('sTabela', $sTabela);
                        }
         
                        if (!empty($oValue3->marcadoresTabelaFrete)) {
                           $oEmbarqueDocumentosPreConhecimentoRedespachoMarcadoresTabelaFrete = $oValue3->marcadoresTabelaFrete; // List<String> | Lista de cdigo dos marcadores da tabela de frete utilizada no clculo do redespacho
                           $sMarcadoresTabelaFrete = '';
                           foreach ($oEmbarqueDocumentosPreConhecimentoRedespachoMarcadoresTabelaFrete as $oValue4) {
                              $sMarcadoresTabelaFrete .= strtoupper(utf8_decode($oValue4)).', ';
                           } // foreach ($oEmbarqueDocumentosPreConhecimentoRedespachoMarcadoresTabelaFrete as $oValue4)
                           fpc_append($sEcoTxt,"sMarcadoresTabelaFrete=$sMarcadoresTabelaFrete");
                           $aInsEmbarqueDocumentosPreConhecimentoRedespacho[] = array('sMarcadoresTabelaFrete', $sMarcadoresTabelaFrete);
                        } // if (!empty($oValue3->marcadoresTabelaFrete)
         
                        if (!empty($oValue3->transportadora)) { // Transportadora | Informaes detalhadas da transportadora utilizada no redespacho
                           $oEmbarqueDocumentosPreConhecimentoRedespachoTransportadora = $oValue3->transportadora;
                           if (!empty($oEmbarqueDocumentosPreConhecimentoRedespachoTransportadora->cnpj)) {
                              $sCnpjTransp = strtoupper(utf8_decode($oEmbarqueDocumentosPreConhecimentoRedespachoTransportadora->cnpj)); // String | Nmero do CNPJ da transportadora Sem formatao
                              fpc_append($sEcoTxt,"sCnpjTransp=$sCnpjTransp");
                           }
                           if (!empty($oEmbarqueDocumentosPreConhecimentoRedespachoTransportadora->nome)) {
                              $sNomeTransp = strtoupper(utf8_decode($oEmbarqueDocumentosPreConhecimentoRedespachoTransportadora->nome)); // String Nome da transportadora
                              fpc_append($sEcoTxt,"sNomeTransp=$sNomeTransp");
                              $aInsEmbarqueDocumentosPreConhecimentoRedespacho[] = array('sNomeTransp', $sNomeTransp);
                           }
                        }
         
                        if (!empty($oValue3->marcadores)) {
                           $sMarcadores = '';
                           $oEmbarqueDocumentosPreConhecimentoRedespachoMarcadores = $oValue3->marcadores; // List<String> | Lista de nome dos marcadores do conhecimento
                           foreach ($oEmbarqueDocumentosPreConhecimentoRedespachoMarcadores as $oValue4) {
                              $sMarcadores .= strtoupper(utf8_decode($oValue4)).', ';
                           } // foreach ($oEmbarqueDocumentosPreConhecimentoRedespachoMarcadores as $oValue4)
                           fpc_append($sEcoTxt,"sMarcadores=$sMarcadores");
                           $aInsEmbarqueDocumentosPreConhecimentoRedespacho[] = array('sMarcadores', $sMarcadores);
                        } // if (!empty($oValue3->marcadores)
         
                        $iCount_aInsEmbarqueDocumentosPreConhecimentoRedespacho = count($aInsEmbarqueDocumentosPreConhecimentoRedespacho);
                        if ($iCount_aInsEmbarqueDocumentosPreConhecimentoRedespacho>0) {
                           $aInsEmbarqueDocumentosPreConhecimentoRedespacho[] = array('pInc'              ,$psLogin           );
                           $aInsEmbarqueDocumentosPreConhecimentoRedespacho[] = array('tInc'              ,'now'              );
                           $aInsEmbarqueDocumentosPreConhecimentoRedespacho[] = array('pEmbarque'         ,$pEmbarque         );
                           $aInsEmbarqueDocumentosPreConhecimentoRedespacho[] = array('pEmbarqueDoc'      ,$pEmbarqueDoc      );
                           $aInsEmbarqueDocumentosPreConhecimentoRedespacho[] = array('pEmbarqueDocPreCon',$pEmbarqueDocPreCon);

                           if ($lUpdate==true) {
                              $sSql = "select pPId from Lincros_Embarques_DocsPreConMov where iVer = iVAt and lExc = 0 and pEmbarque=$pEmbarque and sCodigo='$sCodigo'";
                              fpc_append($sEcoTxt,"sSql=$sSql");
                              $aDb = faDbSelect($hDb,$sSql);
                              $iCount_aDb = count($aDb);
                              fpc_append($sEcoTxt,"iCount_aDb=$iCount_aDb");
                              if ($iCount_aDb>0) {
                                 $pEmbarqueDocsPreConRed = $aDb[0][0];
                                 fpc_append($sEcoTxt,"pEmbarqueDocsPreConRed=$pEmbarqueDocsPreConRed");
                                 $lOk = $lLigaQry==true ? flNovaVersaoRegistro($hDb,'Lincros_Embarques_DocsPreConMov',$pEmbarqueDocsPreConRed) : true;
                                 fpc_append($sEcoTxt,"lOk=$lOk");

                                 if ($lOk==true) {
                                    $sSql = fsArrToUpdate('Lincros_Embarques_DocsPreConRed',$aInsEmbarqueDocumentosPreConhecimentoRedespacho,"iVer=iVAt and pPId=$pEmbarqueDocsPreConRed");
                                    fpc_append($sEcoTxt,"sSql=$sSql");
                                    $lOk = $lLigaQry==true ? flDbUpdate($hDb,$sSql) : true;
                                    fpc_append($sEcoTxt,"lOk=$lOk");

                                    if ($lOk==false) {
                                       fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_DocsPreConRed");
                                       break;
                                    }
                                 } // if ($lOk==true)
                              } else {
                                 $sSql = fsArrToInsert('Lincros_Embarques_DocsPreConRed',$aInsEmbarqueDocumentosPreConhecimentoRedespacho);
                                 fpc_append($sEcoTxt,"sSql=$sSql");
                                 $lOk = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
                                 fpc_append($sEcoTxt,"lOk=$lOk");
                           
                                 if ($lOk==false) {
                                    fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_DocsPreConRed");
                                    break;
                                 }
                              }
                           } else {
                              $sSql = fsArrToInsert('Lincros_Embarques_DocsPreConRed',$aInsEmbarqueDocumentosPreConhecimentoRedespacho);
                              fpc_append($sEcoTxt,"sSql=$sSql");
                              $lOk = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
                              fpc_append($sEcoTxt,"lOk=$lOk");
                        
                              if ($lOk==false) {
                                 fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_DocsPreConRed");
                                 break;
                              }
                           } // if ($lUpdate==true)
                        } // if ($iCount_aInsEmbarqueDocumentosPreConhecimentoRedespacho>0)
                     } // foreach ($oEmbarqueDocumentosPreConhecimentoRedespacho  as $oValue3)
                  } //if (!empty($oValue2->redespacho))
                  //
                  // FIM REDESPACHO
                  //
               } // if ($lOk==true)
            } // foreach ($oEmbarqueDocumentosPreConhecimentos as $oValue2)
         } // if ($lOk==true)
         //
         // FIM DOCUMENTOS PRE CONHECIMENTOS
         //
      } // foreach ($oEmbarqueDocumentos as $oValue)
   } // if ( ($lOk==true) && ($lGo==true) ) 
   //
   // FINAL DOCUMENTOS PRE CONHECIMENTOS
   //      

   //
   // INICIO MOTORISTAS
   //
   if ( ($lOk==true) && ($lGo==true) ) { 
      $oEmbarqueMotoristas = $oEmbarque->motoristas;// Motorista Lista de motoristas.
      foreach ($oEmbarqueMotoristas as $oValue) {
         $aInsEmbarqueMotoristas = array();
         if (!empty($oValue->codigo)) {
            $sCodigo = strtoupper(utf8_decode($oValue->codigo)); // Long Identificador do objeto (oid) do motorista
            fpc_append($sEcoTxt,"sCodigo=$sCodigo");
            $aInsEmbarqueMotoristas[] = array('sCodigo', $sCodigo);
         }
         if (!empty($oValue->numeroDocumento)) {
            $sNumeroDocumento = strtoupper(utf8_decode($oValue->numeroDocumento)); // String Nmero do documento da pessoa
            fpc_append($sEcoTxt,"sNumeroDocumento=$sNumeroDocumento");
            $aInsEmbarqueMotoristas[] = array('sNumeroDocumento', $sNumeroDocumento);
         }
         if (!empty($oValue->nome)) {
            $sNome = strtoupper(utf8_decode($oValue->nome)); // String Nome da pessoa
            fpc_append($sEcoTxt,"sNome=$sNome");
            $aInsEmbarqueMotoristas[] = array('sNome', $sNome);
         }
         if (!empty($oValue->fantasia)) {
            $sFantasia = strtoupper(utf8_decode($oValue->fantasia)); // String Nome fantasia da pessoa
            fpc_append($sEcoTxt,"sFantasia=$sFantasia");
            $aInsEmbarqueMotoristas[] = array('sFantasia', $sFantasia);
         }
         if (!empty($oValue->inscricaoEstadual)) {
            $sInscricaoEstadual = strtoupper(utf8_decode($oValue->inscricaoEstadual)); // String Nmero da inscrio estadual da pessoa
            fpc_append($sEcoTxt,"sInscricaoEstadual=$sInscricaoEstadual");
            $aInsEmbarqueMotoristas[] = array('sInscricaoEstadual', $sInscricaoEstadual);
         }
         if (!empty($oValue->cep)) {
            $iCep = strtoupper(utf8_decode($oValue->cep)); // Integer Cdigo do endereamento postal (Sem formatao)
            fpc_append($sEcoTxt,"iCep=$iCep");
            $aInsEmbarqueMotoristas[] = array('sCep', $iCep);
         }
         if (!empty($oValue->endereco)) {
            $sEndereco = strtoupper(utf8_decode($oValue->endereco)); // String Informaes do logradouro da pessoa
            fpc_append($sEcoTxt,"sEndereco=$sEndereco");
            $aInsEmbarqueMotoristas[] = array('sEndereco', $sEndereco);
         }
         if (!empty($oValue->numero)) {
            $sNumero = strtoupper(utf8_decode($oValue->numero)); // String Nmero do endereo da pessoa
            fpc_append($sEcoTxt,"sNumero=$sNumero");
            $aInsEmbarqueMotoristas[] = array('sNumero', $sNumero);
         }
         if (!empty($oValue->bairro)) {
            $sBairro = strtoupper(utf8_decode($oValue->bairro)); // String Nome do bairro do endereo
            fpc_append($sEcoTxt,"sBairro=$sBairro");
            $aInsEmbarqueMotoristas[] = array('sBairro', $sBairro);
         }
         if (!empty($oValue->latitude)) {
            $nLatitude = strtoupper(utf8_decode($oValue->latitude)); // Double Cdigo da latitude da localizao
            fpc_append($sEcoTxt,"nLatitude=$nLatitude");
            $aInsEmbarqueMotoristas[] = array('nLatitude', $nLatitude);
         }
         if (!empty($oValue->longitude)) {
            $nLongitude = strtoupper(utf8_decode($oValue->longitude)); // Double Cdigo da longitude da localizao.
            fpc_append($sEcoTxt,"nLongitude=$nLongitude");
            $aInsEmbarqueMotoristas[] = array('nLongitude', $nLongitude);
         }
         if (!empty($oValue->telefone)) {
            $sTelefone = strtoupper(utf8_decode($oValue->telefone)); // String Nmero do telefone da pessoa
            fpc_append($sEcoTxt,"sTelefone=$sTelefone");
            $aInsEmbarqueMotoristas[] = array('sTelefone', $sTelefone);
         }
         if (!empty($oValue->emails)) { 
            $sEmails='';
            $oEmabrqueMotoristasEmails = $oValue->emails; // List<String> Lista com e-mails cadastrados da pessoa
            foreach ($oEmabrqueMotoristasEmails as $oValue1) {
               $sEmails .= strtoupper(utf8_decode($oValue1)).', ';
            }
            fpc_append($sEcoTxt,"sEmails=$sEmails");
            $aInsEmbarqueMotoristas[] = array('sEmails', $sEmails);
         }
         if (!empty($oValue->site)) {
            $sSite = strtoupper(utf8_decode($oValue->site)); // String Endereo do site
            fpc_append($sEcoTxt,"sSite=$sSite");
            $aInsEmbarqueMotoristas[] = array('sSite', $sSite);
         }
         if (!empty($oValue->contato)) {
            $sContato = strtoupper(utf8_decode($oValue->contato)); // String Informaes adicionais do contato
            fpc_append($sEcoTxt,"sContato=$sContato");
            $aInsEmbarqueMotoristas[] = array('sContato', $sContato);
         }
         if (!empty($oValue->beneficiarioINSS)) {  
            $lBeneficiarioINSS = strtoupper(utf8_decode($oValue->beneficiarioINSS)); // Boolean Indicador se a pessoa  beneficiria do INSS
            fpc_append($sEcoTxt,"lBeneficiarioINSS=$lBeneficiarioINSS");
            $aInsEmbarqueMotoristas[] = array('lBeneficiarioINSS', $lBeneficiarioINSS);
         }
         if (!empty($oValue->numeroPIS)) {
            $sNumeroPIS = strtoupper(utf8_decode($oValue->numeroPIS)); // String Nmero do PIS
            fpc_append($sEcoTxt,"sNumeroPIS=$sNumeroPIS");
            $aInsEmbarqueMotoristas[] = array('sNumeroPIS', $sNumeroPIS);
         }
   
         if (!empty($oValue->marcadores)) {
            $sMarcadores = '';
            $oEmbarqueMotoristasMarcadores = $oValue->marcadores; // List<String> Lista de cdigo dos marcadores da pessoa Campo visvel somente se estiver populado
            foreach ($oEmbarqueMotoristasMarcadores as $oValue2) {
               if (!empty($oValue2)) {
                  $sMarcadores .= strtoupper(utf8_decode($oValue2)).', ';
                  fpc_append($sEcoTxt,"sMarcadores=$sMarcadores");
               } // if (!empty($oValue2))
            } // foreach ($oEmbarqueMotoristasMarcadores as $oValue2)
            $aInsEmbarqueMotoristas[] = array('sMarcadores', $sMarcadores);
         } // if (!empty($oValue->marcadores))

         if (!empty($oValue->segmentos)) {
            $sSegmentos = '';
            $oEmbarqueMotoristasSegmentos = $oValue->segmentos; // List<String> Lista de cdigos dos segmentos da pessoa Campo visvel somente se estiver populado
            foreach ($oEmbarqueMotoristasSegmentos as $oValue2) {
               if (!empty($oValue2)) {
                  $sSegmentos .= strtoupper(utf8_decode($oValue2)).', ';
                  fpc_append($sEcoTxt,"sSegmentos=$sSegmentos");
               } // if (!empty($oValue2))
            } // foreach ($oEmbarqueMotoristasSegmentos as $oValue2)
            $aInsEmbarqueMotoristas[] = array('sSegmentos', $sSegmentos);
         } // if (!empty($oValue->segmentos))

         $iCount_aInsEmbarqueMotoristas = count($aInsEmbarqueMotoristas);
         if ($iCount_aInsEmbarqueMotoristas > 0) {
            $aInsEmbarqueMotoristas[] = array('pInc'     ,$psLogin  );
            $aInsEmbarqueMotoristas[] = array('tInc'     ,'now'     );
            $aInsEmbarqueMotoristas[] = array('pEmbarque',$pEmbarque);
            if ($lUpdate==true) {
               $sSql = "select pPId from Lincros_Embarques_Motoristas where iVer = iVAt and lExc = 0 and pEmbarque=$pEmbarque and sCodigo='$sCodigo'";
               fpc_append($sEcoTxt,"sSql=$sSql");
               $aDb = faDbSelect($hDb,$sSql);
               $iCount_aDb = count($aDb);
               fpc_append($sEcoTxt,"iCount_aDb=$iCount_aDb");
               if ($iCount_aDb>0) {
                  $pEmbarqueMotorista = $aDb[0][0];
                  fpc_append($sEcoTxt,"pEmbarqueMotorista=$pEmbarqueMotorista");
                  $lOk = $lLigaQry==true ? flNovaVersaoRegistro($hDb,'Lincros_Embarques_Motoristas',$pEmbarqueMotorista) : true;
                  fpc_append($sEcoTxt,"lOk=$lOk");
   
                  if ($lOk==true) {
                     $sSql = fsArrToUpdate('Lincros_Embarques_Motoristas',$aInsEmbarqueMotoristas,"iVer=iVAt and pPId=$pEmbarqueMotorista");
                     fpc_append($sEcoTxt,"sSql=$sSql");
                     $lOk = $lLigaQry==true ? flDbUpdate($hDb,$sSql) : true;
                     fpc_append($sEcoTxt,"lOk=$lOk");
   
                     if ($lOk==false) {
                        fpc_append($sEcoTxt,"ERRO Update Lincros_Embarques_Motoristas");
                        break;
                     }
                  } // if ($lOk==true)
               } else {
                  $sSql = fsArrToInsert('Lincros_Embarques_Motoristas',$aInsEmbarqueMotoristas);
                  fpc_append($sEcoTxt,"sSql=$sSql");
                  $lOk = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
                  fpc_append($sEcoTxt,"lOk=$lOk");
   
                  if ($lOk==false) {
                     fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_Motoristas");
                     break;
                  } // if ($lOk==false)
               }
            } else {
               $sSql = fsArrToInsert('Lincros_Embarques_Motoristas',$aInsEmbarqueMotoristas);
               fpc_append($sEcoTxt,"sSql=$sSql");
               $lOk = $lLigaQry==true ? flDbInsert($hDb,$sSql) : true;
               fpc_append($sEcoTxt,"lOk=$lOk");
   
               if ($lOk==false) {
                  fpc_append($sEcoTxt,"ERRO INSERT Lincros_Embarques_Motoristas");
                  break;
               } // if ($lOk==false)
            } // if ($lUpdate==true)
         } // if ($iCount_aInsEmbarqueMotoristas > 0)
      } // foreach ($oEmbarqueMotoristas as $oValue)
      //
      // FIM MOTORISTAS
      //
   } // if ( ($lOk==true) && ($lGo==true) ) 
   //
   // FINAL MOTORISTAS
   //
   

   if ($lOk==true) {
      $sMsgSucesso = '';
      $aUpdEmbarque = array();

      if ( ($lOk==true) && ($lGo==true) && ($lErro==false) ) {
         fpc_append($sEcoTxt,"VAI FAZER O INCLUDE DO PROCESSO lincros_wsEmbarque_OCa_Gerar.php");
         include('lincros_wsEmbarque_OCa_Gerar.php');
         fpc_append($sEcoTxt,"lOk=$lOk");
         if ($lOk==true) {            
            $aUpdEmbarque[] = array('pOCa', $pOCa);
            $sMsgSucesso = "Embarque integrado com sucesso, Ordem de Carregamento [ $pOCa ] gerada com sucesso no ERP.";
         } else {
            flDbRollBack($hDb);
            fpc_append($sEcoTxt, "rollback");
         }
      } // if ($lErro==false)

      $sErro = implode(chr(10),$aErro);
      fpc_append($sEcoTxt,"sErro=$sErro");

      $aJsonEmbarque = array();
      $aJsonEmbarque['oid'] = $sEmbarque; // Long Obrigatrio Identificador do objeto (oid) retornado pelo mtodo /embarque/buscarRegistrosParaIntegracao

      if ($lErro==true) {
         $jStatusInt = 2;
         $aJsonEmbarque['statusIntegracao'] = $jStatusInt; // Integer Obrigatrio - 0 = Integrado- 1 = No Integrado- 2 = Erro integrao- 3 = Aguardando Integrao- 4 = Enviar Publicao- 5 = Estorno ERP
         $aJsonEmbarque['mensagem']         = utf8_decode($sErro); // String Opcional Corpo da mensagem a ser adicionada
      } else {
         $jStatusInt = 0;
         $aJsonEmbarque['statusIntegracao'] = $jStatusInt; //Integer Obrigatrio - 0 = Integrado- 1 = No Integrado- 2 = Erro integrao- 3 = Aguardando Integrao- 4 = Enviar Publicao- 5 = Estorno ERP
         $aJsonEmbarque['mensagem']         = utf8_decode($sMsgSucesso); // String Opcional Corpo da mensagem a ser adicionada
      } // if ($lErro==true)

      fpc_append($sEcoTxt,'INICIO JSON QTUX A SER ENVIADO');
      fpc_append($sEcoTxt,json_encode($aJsonEmbarque, JSON_PRETTY_PRINT));
      fpc_append($sEcoTxt,'FINAL JSON QTUX A SER ENVIADO');

      //fpc('/qtux/samba/edi/Lincros/Enviados/wsEmbarque_salvarRetornoEmbarque_'.$sEmbarque.'.json',json_encode($aJsonEmbarque, JSON_PRETTY_PRINT));
      $sDirWS = '/qtux/samba/edi/Lincros/Enviados/wsEmbarque/wsEmbarque_salvarRetornoEmbarque/';
      $sDir = fsCriarDirAnoMesDia($sDirWS);
      fpc($sDir.'wsEmbarque_salvarRetornoEmbarque_'.$sEmbarque.'.json',json_encode($aJsonEmbarque, JSON_PRETTY_PRINT));

      $json_aJsonEmbarque = json_encode($aJsonEmbarque);

      if ( ($lSalvarRetorno==true) && ($lOk==true) ) {

         $iWhile = 0;
         while (true) {
            $iWhile++;         
            $oRet = file_get_contents($sUrlSalvarRetorno,null,stream_context_create(array(
                                          'http' => array('method'  => 'POST',
                                                          'header'  => "Authorization: Bearer $sToken\r\n".
                                                                       "Content-type: application/json\r\n".
                                                                       "Connection: close\r\n".
                                                                       "Content-length: ".strlen($json_aJsonEmbarque)."\r\n",
                                                          'content' => $json_aJsonEmbarque,
                                                         ),
                                         )));

            fpc_append($sEcoTxt,'JSON QTUX ENVIADO');

            $oRet = json_decode($oRet);
            $sTipo = gettype($oRet);
            fpc_append($sEcoTxt,'RETORNO JSON LINCROS');
            fpc_append($sEcoTxt,'gettype='.$sTipo);
            fpc_append($sEcoTxt,json_encode($oRet, JSON_PRETTY_PRINT));
            fpc_append($sEcoTxt,'FINAL RETORNO JSON LINCROS');            
            $sStatus = '';
            if (!empty($oRet->status)) {
               $sStatus = strtoupper(utf8_decode($oRet->status));
               fpc_append($sEcoTxt,"sStatus=$sStatus");
            } //if (!empty($oRet->status))

            if ($sTipo=='NULL') {
               sleep(5);
            } else if ($sTipo<>'NULL') {
               break;
            } else if ($iWhile==4) {
               fpc_append($sEcoTxt,'SEM RESPOSTA DA LINCROS');
               $lOk = false;
               break;
            } // if ($sTipo=='NULL')

         } // while(true)
      } else {
         $sStatus = 'CONFIRMADO';
      } // if ( (($lSalvarRetorno==true) && ($lOk==true)) || ($lErroCritico==true) )

      if ($lOk==true) {
         $aUpdEmbarque[] = array('jStatusInt', $jStatusInt);
         $aUpdEmbarque[] = array('sMsgInt'   , $sErro     );

         $sSql = fsArrToUpdate('Lincros_Embarques',$aUpdEmbarque,"iVer=iVAt and pPId=$pEmbarque");
         fpc_append($sEcoTxt,"sSql=$sSql");

         if ($sStatus=='CONFIRMADO') {
            $lOk = $lLigaQry==true ? flDbUpdate($hDb,$sSql) : true;
            fpc_append($sEcoTxt,"lOk=$lOk");
         } else {
            fpc_append($sEcoTxt,"sStatus=$sStatus  diferente de CONFIRMADO");
            $lOk = $lLigaQry==true ? flDbUpdate($hDb,$sSql) : true;
            fpc_append($sEcoTxt,"lOk=$lOk");
         } // if ($sStatus=='CONFIRMADO') {
      }

      if ($lOk==true) {
         fpc_append($sEcoTxt, "commit");
         flDbCommit($hDb);
      } else {
         flDbRollBack($hDb);
         fpc_append($sEcoTxt, "rollback");
      }

   } // if ( ($lOk==true) && ($lSalvarRetorno==true) )
   
   if ($lErro==true) {
      $sErro = implode(chr(10),$aErro);
      fpc_append($sEcoTxt,"sErro=$sErro");
   } // if ($lErro==true)
} // if ( ($sStatus=='CONFIRMADO') && ($lOk==true) )

//
// STATUS DE ERRO DA LINCROS
//
if ($sStatus=='ERRO') {
   $sMensagem = utf8_decode($oRet->mensagem);
   fpc_append($sEcoTxt,$sMensagem);
   $lOk   = false;
   $lErro = true;

   $aJsonEmbarque = array();
   $aJsonEmbarque['oid'] = $sEmbarque; // Long Obrigatrio Identificador do objeto (oid) retornado pelo mtodo /embarque/buscarRegistrosParaIntegracao

   $jStatusInt = 2;
   $aJsonEmbarque['statusIntegracao'] = $jStatusInt; // Integer Obrigatrio - 0 = Integrado- 1 = No Integrado- 2 = Erro integrao- 3 = Aguardando Integrao- 4 = Enviar Publicao- 5 = Estorno ERP
   $aJsonEmbarque['mensagem']         = utf8_encode($sMensagem); // String Opcional Corpo da mensagem a ser adicionada

   fpc_append($sEcoTxt,json_encode($aJsonEmbarque, JSON_PRETTY_PRINT));
   
   //fpc('/qtux/samba/edi/Lincros/Enviados/wsEmbarque_salvarRetornoEmbarque_'.$sEmbarque.'_ERRO.json',json_encode($aJsonEmbarque, JSON_PRETTY_PRINT));
   $sDirWS = '/qtux/samba/edi/Lincros/Enviados/wsEmbarque/wsEmbarque_salvarRetornoEmbarque/';
   $sDir = fsCriarDirAnoMesDia($sDirWS);
   fpc($sDir.'wsEmbarque_salvarRetornoEmbarque_'.$sEmbarque.'_ERRO.json',json_encode($aJsonEmbarque, JSON_PRETTY_PRINT));

   $json_aJsonEmbarque = json_encode($aJsonEmbarque);

   if ($lSalvarRetorno==true) {
      $oRet = file_get_contents($sUrlSalvarRetorno,null,stream_context_create(array(
                                    'http' => array('method'  => 'POST',
                                                    'header'  => "Authorization: Bearer $sToken\r\n".
                                                                 "Content-type: application/json\r\n".
                                                                 "Connection: close\r\n".
                                                                 "Content-length: ".strlen($json_aJsonEmbarque)."\r\n",
                                                    'content' => $json_aJsonEmbarque,
                                                   ),
                                   )));
      
      $oRet = json_decode($oRet);
      fpc_append($sEcoTxt,'JSON RETORNO');
      fpc_append($sEcoTxt,json_encode($oRet, JSON_PRETTY_PRINT));
      
      fpc_append($sEcoTxt,'gettype='.gettype($oRet));
      fpc_append($sEcoTxt,'count '.count($oRet));
      fpc_append($sEcoTxt,'status='.$oRet->status);
   
      $sStatusErro = '';
      if (!empty($oRet->status)) {
         $sStatusErro = strtoupper(utf8_decode($oRet->status));
         fpc_append($sEcoTxt,"sStatusErro=$sStatusErro");
      } //if (!empty($oRet->status))
   }
}
fpc_append($sEcoTxt,"FIM EMBARQUE $sEmbarque");
fpc_append($sEcoTxt,"------------------------------------------");