<?php
set_time_limit(1800);

require_once("/qtux/www/FullPlat/pFuncoes1.php");
require_once("/qtux/www/FullPlat/pPublics1.php");

$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoTxt = '/qtux/www/FullPlat/processos/logs/'.str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = fsDirEcoTxt($sEcoTxt);
fpc($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));

$lOk  = true;

//$sDSN = '/qtux/database/tq/gps_01.gdb';
$sDSN = 'localhost:/qtux/database/tq/gps_01.gdb';
$hDb  = fhDbConnect($sDSN);

$sSql = "select a.pPId,
                a.tVenc, 
                b.jBanco,
                b.n1Juros1Dia, -- jBanco==0
                b.nBradJur1D,  -- jBanco==1 || jBanco==2
                b.n2Juros1Dia, -- jBanco==3
                e.pCid,
                e.pUF,
                a.nVenc,
                a.nBruto,
                a.nDescCTR,
                a.nDesc,
                a.nAbat, -- Est aqui apenas para talvez use em um futuro prox
                a.nAcr,
                a.nMora,
                a.nJur,
                a.nMulta,
                a.nIOF

         from Fin_Titulos    a   join  Tipo_Cobrancas b on a.pTipoCob = b.pPId    and b.iVer = b.iVAt
                                 join  Enderecos      d on d.pCup     = a.pSacado and d.iVer = d.iVAt and d.lCliCob=1 and d.lExc=0
                                 join  CEPs           e on d.pCep     = e.pPid    and e.iVer = e.iVAt
         where a.lExc=0 
           and a.iVer = a.iVAt
           and cast(a.tVenc as date) < cast('today' as date) -- '2017-12-20' --cast('today' as date)
           and a.lPrevisao = 0
           and a.pPId = 1834476
           and a.tCanc  is null
           and a.tPgmto is null";

fpc_append($sEcoTxt,"1) sSql = $sSql");
$aDb = faDbSelect($hDb,$sSql);
$iCount = count($aDb);
fpc_append($sEcoTxt,"1) iCount=$iCount");

foreach ($aDb as $aLin) {
   $pTFin     = $aLin[0];
   $dVenc    = date('Y-m-d',strtotime($aLin[1]));
//   $dVenc    = '2018-11-23';
   $jBanco   = $aLin[2];
   $nPJur1   = $aLin[3]; // ITA
   $nPJur2   = $aLin[4]; // BRADESCO E BANCO DO BRASIL
   $nPJur3   = $aLin[5]; // SANTANDER
   $pCid     = $aLin[6];
   $pUF      = $aLin[7];
//   $nVenc    = $aLin[8];
   $nBruto   = $aLin[9];
   $nDescCTR = $aLin[10];
   $nDesc    = $aLin[11];
   $nAbat    = $aLin[12]; 
   $nAcr     = $aLin[13];
   $nMora    = $aLin[14];
   $nJurA    = $aLin[15];
   $nMulta   = $aLin[16];
   $nIOF     = $aLin[17];

   $nVenc    = $nBruto-$nDesc+$nAcr+$nMora+$nMulta+$nIOF-$nDescCTR; // Frmula em pTela2.js function FIN_Titulos_versaoA_dda, No uso o Juros nessa formula, para manter o valor nVenc Original

//   $dNow   = date('Y-m-d',time());
   $dNow   = '2019-07-18';
   fpc_append($sEcoTxt,"-----------------------------------------------------");
   fpc_append($sEcoTxt,"2) pTFin=$pTFin, dVenc=$dVenc, dNow=$dNow, nPJur1=$nPJur1,nPJur2=$nPJur2,nPJur3=$nPJur3,pCid=$pCid,pUF=$pUF,nVenc=$nVenc");

   $iDUtil  = fiQtosDiasUteisEntreDatas($dVenc,$dNow,$pUF,$pCid); // Verificando se tem dias teis ou no 
   fpc_append($sEcoTxt,"2) iDUtil=$iDUtil");

   $sSqlFeriados = "select jTipo,pMun,pUF,jAno,iDia,iMes,iAno
                      from Feriados
                     where lExc=0
                       and iVer=iVAt
                       and (
                                jTipo=0
                            or (jTipo=1 and pUF  = $pUF)
                            or (jTipo=2 and pMun = $pCid)                                   
                           )
                     order by iAno,iMes,iDia";

   $aFeriados = faDbSelect($hDb,$sSqlFeriados);

   $iCountFeriados = count($aFeriados);

   fpc_append($sEcoTxt,"2) iCountFeriados=$iCountFeriados, sSqlFeriados=$sSqlFeriados");

   if (flEh_DiaUtil($dVenc,$aFeriados,$pUF,$pCid)==false) {
      $iDUtil  = $iDUtil-1; // Subtraindo um dia, porque o prximo dia util apos o vencimento est contando na soma dos dias uteis, e nesse caso  calulado o juros aps o dia util q foi transferido o vencimento.
                            // Exemplo: (Vencimento Dia 25, Sbado. 
                            //           Prximo dia Util, Dia 27, Segunda Feira. (Porm no posso calcular o juros nesse dia, porque ainda est cabvel para pagamento) 
                            //           O prximo dia util real para ser determinado se o titulo est ou no em atraso  a partir do Dia 28.   
   } 

   fpc_append($sEcoTxt,"2) iDUtil=$iDUtil");

   if ($iDUtil>0) { // Se o dia util for > 0,  porque est atrasado e no foi pago no proximo dia util aps o vencimento.
      $iDAtr  = fiQtosDiasEntreD1eD2($dVenc,$dNow); // Conforme no foi pago no prximo dia util, est sendo calculado em dias corridos a partir da data de vencimento. 
                                                    // Exemplo: (25,26,27,28)
      fpc_append($sEcoTxt,"3) iDAtr=$iDAtr, dVenc=$dVenc, dNow=$dNow");
    
      if (($nPJur1>0) || ($nPJur2>0) || ($nPJur3>0)) { 
         if ($jBanco==0) {                       // ITA
           $nJur = round(($nVenc/100*$nPJur1)*$iDAtr,2);
           fpc_append($sEcoTxt,"4) jBanco=$jBanco,nVenc=$nVenc,nPJur1=$nPJur1,iDAtr=$iDAtr,nJur=$nJur");
         } elseif (($jBanco==1)||($jBanco==2)) { // BRADESCO E BANCO DO BRASIL 
           $nJur = round(($nVenc/100*$nPJur2)*$iDAtr,2);
           fpc_append($sEcoTxt,"4) jBanco=$jBanco,nVenc=$nVenc,nPJur2=$nPJur2,iDAtr=$iDAtr,nJur=$nJur");
         } elseif ($jBanco==4) {                 // SANTANDER
           $nJur = round(($nVenc/100*$nPJur3)*$iDAtr,2);
           fpc_append($sEcoTxt,"4) jBanco=$jBanco,nVenc=$nVenc,nPJur3=$nPJur3,iDAtr=$iDAtr,nJur=$nJur");
         }

         if  ($nJur>0) {  // Pode ter alguma porcentagem zerada e no preciso fazer o update nesse caso 
            $nJurD = $nJur-$nJurA;
            $nJurD = sprintf('%.2f',$nJurD); // tratar erro de valores de um centavo, exemplo: nJur=2.84,nJurA=2.83,nJurD=0.0099999999999998

            $nVenc = $nBruto-$nDesc+$nAcr+$nMora+$nJur+$nMulta+$nIOF-$nDescCTR; // Frmula em pTela2.js function FIN_Titulos_versaoA_dda

            fpc_append($sEcoTxt,"5) nJur=$nJur,nJurA=$nJurA,nJurD=$nJurD");
            if ($lOk==true) { // Atualizando o juros no titulo financeiro 
               $sSql = "update Fin_Titulos set nJur=$nJur,nVenc=$nVenc where iVer=iVAt and pPId=$pTFin";
               $lOk  = flDbUpdate($hDb,$sSql);
               fpc_append($sEcoTxt,"5) lOk=$lOk, sSql=$sSql");
               if (!$lOk) {
                  $sErrorCode = ibase_errcode();
                  $sErrorText = ibase_errmsg();
                  fpc_append($sEcoTxt,"5) sErrorCode=$sErrorCode, sErrorText=$sErrorText");
               }
            }

            if ($lOk==true) {
               $sSql     = "select a.pPId from FIN_Detalhamento_Desc_Acresc a where a.iVer=a.iVAt and a.lExc=0 and a.pFin=$pTFin and a.jNat=1";
               fpc_append($sEcoTxt,"6) sSql=$sSql");
               $aDb      = faDbSelect($hDb,$sSql);
               $iCountDb = count($aDb);
               if ($iCountDb>0) {
                  $pDetDA      = $aDb[0][0]; 
                  fpc_append($sEcoTxt,"7) pDetDA=$pDetDA");
   
                  $lOk = flNovaVersaoRegistro($hDb,'FIN_Detalhamento_Desc_Acresc',$pDetDA);
                  if (!$lOk) {
                     $sErrorCode = ibase_errcode();
                     $sErrorText = ibase_errmsg();
                     fpc_append($sEcoTxt,"7) sErrorCode=$sErrorCode, sErrorText=$sErrorText");
                  }

                  if ($lOk==true) {
                     $sSql = "update FIN_Detalhamento_Desc_Acresc set sVer='$sEcoTxt',nValor=$nJur, sObs='Juros Calculado entre o perodo De $dVenc / At $dNow - Dias de Atraso $iDAtr' where iver=ivat and pPId=$pDetDA and jNat=1";
                     $lOk  = flDbUpdate($hDb,$sSql);
                     fpc_append($sEcoTxt,"7) lOk=$lOk, sSql=$sSql");
                     if (!$lOk) {
                        $sErrorCode = ibase_errcode();
                        $sErrorText = ibase_errmsg();
                        fpc_append($sEcoTxt,"7) sErrorCode=$sErrorCode, sErrorText=$sErrorText");
                     }
                  }

               } else {
                  // Lancar em FIN_Titulos_Detalhes
                  // aTipo       = Desconto,Acrscimo
                  // aNat        = Mora,Juros,Multa,IOF,(a)Contrato,(b)Devoluo,(c)Verba,(d)Outros
                  $aIns    = array();
                  $aIns[]  = array('pInc'     ,1);
                  $aIns[]  = array('sVer'     ,"$sEcoTxt");
                  $aIns[]  = array('pFin'     ,$pTFin);
                  $aIns[]  = array('jTipo'    ,1);   // ascrecimo 
                  $aIns[]  = array('jNat'     ,1);   // juros
                  $aIns[]  = array('nValor'   ,$nJur);
                  $aIns[]  = array('sObs'     ,"Juros Calculado entre o perodo De $dVenc / At $dNow - Dias de Atraso $iDAtr");
                  $sSql   = fsArrToInsert('FIN_Detalhamento_Desc_Acresc',$aIns);
                  $lOk = flDbInsert($hDb,$sSql);
                  fpc_append($sEcoTxt,"8) lOk=$lOk, sSql=$sSql");
                  if (!$lOk) {
                     $sErrorCode = ibase_errcode();
                     $sErrorText = ibase_errmsg();
                     fpc_append($sEcoTxt,"8) sErrorCode=$sErrorCode, sErrorText=$sErrorText");
                  }
               }
            }
         } //  if  ($nJur>0) {
      } // if (($nPJur1>0) || (($nPJur2>0) || (($nPJur3>0))
   }
}

if ($lOk==true) {
   flDbCommit($hDb);
   fpc_append($sEcoTxt,"9) lOk=$lOk, commit");
} else {
   flDbRollBack($hDb);
   fpc_append($sEcoTxt,"9) lOk=$lOk, rollback");
}

flDbDisconnect($hDb);
$tJobEnd = time();

fpc_append($sEcoTxt,'Final: '.date('d/m/Y H:i:s',$tJobEnd));