<?php
/*
" 1" ,'PCTIPO '   ,$jPCTIPO                                                            ,"  01" ,"N"                    ,"Identif. {1-CNPJ,2-CPF,3-RG,4-Export.,5-Insc.Prod.,9-Outros}    "
" 2" ,'PCCASS '   ,$sPCCASS                                                            ,"  04" ,"ZZZZ"                 ,"Codigo do Associado                                             "
" 3" ,'PCCCLI '   ,str_pad($sPCCCLI,20,"0",STR_PAD_LEFT)                               ,"  20" ,"NNNNNNNNNNNNNNNNNNNN" ,"Identificacao. (CNPJ/CPF/RG/Export./Insc.Prod./Outros)          "
" 4" ,'PCDDAT '   ,fsCISPEnviaData($tPCDDAT)                                           ,"  08" ,"AAAAMMDD"             ,"Data da Informacao                                              "
" 5" ,'PCDCDD '   ,fsCISPEnviaData($tPCDCDD)                                           ,"  08" ,"AAAAMMDD"             ,"Data Cadastramento do Cliente                                   "
" 6" ,'PCDUCM '   ,fsCISPEnviaData($tPCDUCM)                                           ,"  08" ,"AAAAMMDD"             ,"Data da ultima Compra                                           "
" 7" ,'PCVULC '   ,str_pad(100*number_format($nPCVULC,2,".",""),15,"0",STR_PAD_LEFT)   ,"13,2" ,"ZZZZZZZZZZZZZZZ"      ,"Valor da ultima Compra                                          "
" 8" ,'PCDMAC '   ,fsCISPEnviaData($tPCDMAC)                                           ,"  08" ,"AAAAMMDD"             ,"Data do Maior Acumulo                                           "
" 9" ,'PCVMAC '   ,str_pad(100*number_format($nPCVMAC,2,".",""),15,"0",STR_PAD_LEFT)   ,"13,2" ,"NNNNNNNNNNNNNNN"      ,"Valor Maior Acumulo                                             "
"10" ,'PCVSAT '   ,str_pad(100*number_format($nPCVSAT,2,".",""),15,"0",STR_PAD_LEFT)   ,"13,2" ,"ZZZZZZZZZZZZZZZ"      ,"Valor Debito Atual Total                                        "
"11" ,'PCVLCR '   ,str_pad(100*number_format($nPCVLCR,2,".",""),15,"0",STR_PAD_LEFT)   ,"13,2" ,"NNNNNNNNNNNNNNN"      ,"Valor Limite de Credito                                         "
"12" ,'PCQPAG '   ,str_pad(number_format($nPCQPAG*100,0,".",""),6,"0",STR_PAD_LEFT)    ,"04,2" ,"ZZZZZZ"               ,"Media Ponderada de Atraso nos Pagamentos (Titulos Pagos)        "
"13" ,'PCQDAP '   ,str_pad(number_format($nPCQDAP*100,0,".",""),6,"0",STR_PAD_LEFT)    ,"04,2" ,"NNNNNN"               ,"Media Aritmetica Dias de Atraso Pagamento                       "
"14" ,'PCVDAV '   ,str_pad(100*number_format($nPCVDAV,2,".",""),15,"0",STR_PAD_LEFT)   ,"13,2" ,"ZZZZZZZZZZZZZZZ"      ,"Valor Debito Atual a Vencer                                     "
"15" ,'PCMDAV '   ,str_pad(number_format($nPCMDAV*100,0,".",""),6,"0",STR_PAD_LEFT)    ,"04,2" ,"NNNNNN"               ,"Media Ponderada de Titulos a Vencer                             "
"16" ,'PCMPMV '   ,str_pad(number_format($nPCMPMV*100,0,".",""),6,"0",STR_PAD_LEFT)    ,"04,2" ,"ZZZZZZ"               ,"Prazo Medio de Vendas                                           "
"17" ,'PCDATV '   ,str_pad(100*number_format($nPCDATV,2,".",""),15,"0",STR_PAD_LEFT)   ,"13,2" ,"NNNNNNNNNNNNNNN"      ,"Valor Debito Atual Vencido + 5 Dias                             "
"18" ,'PCMPTV '   ,str_pad(number_format($nPCMPTV,0,".",""),4,"0",STR_PAD_LEFT)        ,"  04" ,"ZZZZ"                 ,"Media Ponderada de Atraso Titulos Vencidos e nao Pagos + 5 Dias "
"19" ,'PCV+15D'   ,str_pad(100*number_format($nPCV_15D,2,".",""),15,"0",STR_PAD_LEFT)  ,"13,2" ,"NNNNNNNNNNNNNNN"      ,"Valor Debito Atual Vencido + 15 Dias                            "
"20" ,'PCM+15D'   ,str_pad(number_format($nPCM_15D,0,".",""),4,"0",STR_PAD_LEFT)       ,"  04" ,"ZZZZ"                 ,"Media Ponderada de Atraso Titulos Vencidos e nao Pagos + 15 Dias"
"21" ,'PCV+30D'   ,str_pad(100*number_format($nPCV_30D,2,".",""),15,"0",STR_PAD_LEFT)  ,"13,2" ,"NNNNNNNNNNNNNNN"      ,"Valor Debito Atual Vencido + 30 Dias                            "
"22" ,'PCM+30D'   ,str_pad(number_format($nPCM_30D,0,".",""),4,"0",STR_PAD_LEFT)       ,"  04" ,"ZZZZ"                 ,"Media Ponderada de Atraso Titulos Vencidos e nao Pagos + 30 Dias"
"23" ,'PCDTPC '   ,fsCISPEnviaData($tPCDTPC)                                           ,"  08" ,"AAAAMMDD"             ,"Data da Penultima Compra                                        "
"24" ,'PCVPCO '   ,str_pad(100*number_format($nPCVPCO,2,".",""),15,"0",STR_PAD_LEFT)   ,"13,2" ,"NNNNNNNNNNNNNNN"      ,"Valor da Penultima Compra                                       "
"25" ,'PCVSIT '   ,$sPCVSIT                                                            ,"  01" ,"Z"                    ,"Situacao do Calculo Limite de Credito                           "
"26" ,'PCTIPG '   ,$sPCTIPG                                                            ,"  01" ,"N"                    ,"Tipo de Garantia                                                "
"27" ,'PCGGA  '   ,$sPCGGA                                                             ,"  02" ,"ZZ"                   ,"Grau da Garantia Hipoteca                                       "
"28" ,'PCDTG  '   ,fsCISPEnviaData($tPCDTG)                                            ,"  08" ,"AAAAMMDD"             ,"Data Validade da Garantia                                       "
"29" ,'PCVLG  '   ,str_pad(100*number_format($nPCVLG,2,".",""),15,"0",STR_PAD_LEFT)    ,"13,2" ,"NNNNNNNNNNNNNNN"      ,"Valor da Garantia                                               "
"30" ,'PCVPA  '   ,str_pad(100*number_format($nPCVPA,2,".",""),15,"0",STR_PAD_LEFT)    ,"13,2" ,"ZZZZZZZZZZZZZZZ"      ,"Valor da Venda Pagamento Antecipado                             "
"31" ,'PCSVV  '   ,str_pad(100*number_format($nPCSVV,2,".",""),15,"0",STR_PAD_LEFT)    ,"  02" ,"BB"                   ,"Venda sem Credito (ANTECIPADO)                                  "
*/

ini_set('memory_limit','1024M');
set_time_limit(7200);   // 120 minutos
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoTxt = "/qtux/www/FullPlat/processos/logs/".str_replace('.','_',$sProc)."_".time().".log";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);
$sEcoTxt2 = "/qtux/www/FullPlat/processos/logs/".str_replace('.','_',$sProc)."_".time()."_2.log";
$sEcoTxt2 = fsDirEcoTxt($sEcoTxt2);

fpc($sEcoTxt,'Incio em ' . date('d/M/y G:i:s',$tJobStart));

if (isset($_GET['sCliPasta'])) {
   $psCliPasta = $_GET['sCliPasta'];
   $psLogin    = $_GET['sLogin'];
   $pDoc      = $_GET['sId'];
   $psFileProcessName = $_GET['sFileProcessName'];
   $plRunViaMenu = true;
} else {
//   $psCliPasta = 'total';
   $psCliPasta = 'desenvolvimento';
   $psLogin    = 1;
   $pDoc      = 154;
   $psFileProcessName = $sEcoTxt2;
   $plRunViaMenu = false;
}

$aUserLog = array();

$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";

if (file_exists($sFileConfig)) {

   //$iCompany = $_GET["iCompany"];

   $sTxt = fsTXTFiltrar($sFileConfig);
   //$sTxt = fsTXTCompany($sTxt,$iCompany);
   $aArr = explode(chr(10),$sTxt);

   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      if (strlen($sLin)>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         if (count($aLin)>1) $s2 = trim($aLin[1]);
         else                $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);   // criando uma var
         $sVarsTxt .= $s . chr(10);
      }
   }

   $sDSN = "$sHost:$sPathDB/$sDB";
   $lOk  = true;
   $lGo  = true;
   $hDb  = fhDbConnect($sDSN);

   $lLigaQry = true;

   $tDe  = '2017-05-01';
   $iDif = time()-strtotime($tDe);
   $iMeses = floor($iDif/(60*60*24*30));
   if ($iMeses>=12) {
      $sTmpDe = mktime(0,0,0,date("m"),date("d"),date("Y")-1); // Data atual menos 1 ano
      $tDe = date('Y-m-d',$sTmpDe);
   }
   $sTmpAte = mktime(0,0,0,date("m"),date("d")-4,date("Y")); // Data atual menos 4 dias
   $tAte = date('Y-m-d',$sTmpAte); // '2017-11-01';

   fpc_append($sEcoTxt,"psLogin=$psLogin, psFileProcessName=$psFileProcessName, lGo=$lGo, tDe=$tDe, tAte=$tAte");

   $sPathArquivo = "/qtux/samba/CISP/CISP.elay";
   $sPathHistory = "/qtux/samba/CISP/CISP".time().".hist";
   $sPathContent = "/qtux/samba/CISP/CISP".time().".histdata";
   fpc($sPathArquivo,'');
   fpc($sPathHistory,'');
   fpc($sPathContent,'');

   if ($lGo==true) {
      $dHoje = date('Y-m-d');
      $tHoje = $dHoje . ' 23:59:59';
   
      $dHoje_5  = date('Y-m-d',strtotime($dHoje)- 5*24*60*60);   // - 5 dias em segundos
      $dHoje_15 = date('Y-m-d',strtotime($dHoje)-15*24*60*60);   // -15 dias em segundos
      $dHoje_30 = date('Y-m-d',strtotime($dHoje)-30*24*60*60);   // -30 dias em segundos
      $dHoje_1a = date('Y-m-d',mktime(0,0,0,date("m"),date("d"),date("Y")-1)); // - 1 ano
      fpc_append($sEcoTxt,"dHoje=$dHoje, tHoje=$tHoje, dHoje_5=$dHoje_5, dHoje_15=$dHoje_15, dHoje_30=$dHoje_30,dHoje_1a=$dHoje_1a");



      $pDoc = 0;   // lida da Esttica
      $sSql = "select jPCTIPO, 
                      sPCCASS, 
                      sPCCCLI, 
                      cast(tPCDDAT as date), 
                      cast(tPCDCDD as date), 
                      cast(tPCDUCM as date), 
                      nPCVULC, 
                      cast(tPCDMAC as date),     
                      nPCVMAC, 
                      nPCVSAT, 
                      nPCVLCR, 
                      nPCQPAG, 
                      nPCQDAP, 
                      nPCVDAV, 
                      nPCMDAV, 
                      nPCMPMV, 
                      nPCDATV, 
                      nPCMPTV, 
                      nPCV_15D,
                      nPCM_15D, 
                      nPCV_30D, 
                      nPCM_30D,
                      cast(tPCDTPC as date), 
                      nPCVPCO, 
                      sPCVSIT, 
                      sPCTIPG, 
                      sPCGGA,  
                      cast(tPCDTG as date),  
                      nPCVLG,  
                      nPCVPA,  
                      nPCSVV  
               from CISP_LINHA
               where iVer=iVat and lExc = 0 and lEnviar=1
                 and pCISP  = $pDoc";
      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDb      = faDbSelect($hDb,$sSql);
      $iCountDb = count($aDb);
      fpc_append($sEcoTxt,"iCountDb=$iCountDb");

      if ($iCountDb>0) { 
         $iLoop=0;
         foreach ($aDb as $aLin) {
            $iPorc = round($iLoop++*100/$iCountDb,0);
            if ($plRunViaMenu==false) echo "$iPorc %".chr(10);
            fpc($psFileProcessName,"1/2 $iPorc %");
          
            $jPCTIPO    = $aLin[0];    //  1 Identif. {1-CNPJ,2-CPF,3-RG,4-Export.,5-Insc.Prod.,9-Outros}
            $sPCCASS    = $aLin[1];    //  2 Codigo do Associado
            $sPCCCLI    = $aLin[2];    //  3 Identificacao. (CNPJ/CPF/RG/Export./Insc.Prod./Outros)
            $tPCDDAT    = $aLin[3];    //  4 Data da Informacao
            $tPCDCDD    = $aLin[4];    //  5 Data Cadastramento do Cliente 
            $tPCDUCM    = $aLin[5];    //  6 Data da ultima Compra
            $nPCVULC    = $aLin[6];    //  7 Valor da ultima Compra
            $tPCDMAC    = $aLin[7];    //  8 Data do Maior Acmulo                                               
            $nPCVMAC    = $aLin[8];    //  9 Valor Maior Acmulo                                                 
            $nPCVSAT    = $aLin[9];    // 10 Valor Debito Atual Total
            $nPCVLCR    = $aLin[10];   // 11 Valor Limite de Credito
            $nPCQPAG    = $aLin[11];   // 12 Mdia Ponderada de Atraso nos Pagamentos (Ttulos Pagos)
            $nPCQDAP    = $aLin[12];   // 13 Mdia Aritm.Dias de Atraso Pagamento
            $nPCVDAV    = $aLin[13];   // 14 Valor Debito Atual a Vencer
            $nPCMDAV    = $aLin[14];   // 15 Mdia Ponderada de Ttulos a Vencer
            $nPCMPMV    = $aLin[15];   // 16 Prazo Mdio de Vendas
            $nPCDATV    = $aLin[16];   // 17 Valor Debito Atual Vencido + 5 Dias
            $nPCMPTV    = $aLin[17];   // 18 Mdia Ponderada de Atraso Ttulos Vencidos e no Pagos + 5 Dias
            $nPCV_15D   = $aLin[18];   // 19 Valor Debito Atual Vencido + 15 Dias
            $nPCM_15D   = $aLin[19];   // 20 Mdia Ponderada de Atraso Ttulos Vencidos e no Pagos + 15 Dias
            $nPCV_30D   = $aLin[20];   // 21 Valor Debito Atual Vencido + 30 Dias
            $nPCM_30D   = $aLin[21];   // 22 Mdia Ponderada de Atraso Ttulos Vencidos e no Pagos + 30 Dias
            $tPCDTPC    = $aLin[22];   // 23 Data da Penultima Compra
            $nPCVPCO    = $aLin[23];   // 24 Valor da Penultima Compra
            $sPCVSIT    = $aLin[24];   // 25 Situacao do Calculo Limite de Credito
            $sPCTIPG    = $aLin[25];   // 26 Tipo de Garantia
            $sPCGGA     = $aLin[26];   // 27 Grau da Garantia Hipoteca
            $tPCDTG     = $aLin[27];   // 28 Data Validade da Garantia
            $nPCVLG     = $aLin[28];   // 29 Valor da Garantia
            $nPCVPA     = $aLin[29];   // 30 Valor da Venda Pagamento Antecipado
            $nPCSVV     = $aLin[30];   // 31 Venda sem Credito (ANTECIPADO)                                   

            fpc_append($sEcoTxt," 1-PCTIPO    = $jPCTIPO   Identif. {1-CNPJ,2-CPF,3-RG,4-Export.,5-Insc.Prod.,9-Outros}    ");
            fpc_append($sEcoTxt," 2-PCCASS    = $sPCCASS   Codigo do Associado                                             ");
            fpc_append($sEcoTxt," 3-PCCCLI    = $sPCCCLI   Identificacao. (CNPJ/CPF/RG/Export./Insc.Prod./Outros)          ");
            fpc_append($sEcoTxt," 4-PCDDAT    = $tPCDDAT   Data da Informacao                                              ");
            fpc_append($sEcoTxt," 5-PCDCDD    = $tPCDCDD   Data Cadastramento do Cliente                                   ");
            fpc_append($sEcoTxt," 6-PCDUCM    = $tPCDUCM   Data da ultima Compra                                           ");
            fpc_append($sEcoTxt," 7-PCVULC    = $nPCVULC   Valor da ultima Compra                                          ");
            fpc_append($sEcoTxt," 8-PCDMAC    = $tPCDMAC   Data do Maior Acmulo                                           ");                                               
            fpc_append($sEcoTxt," 9-PCVMAC    = $nPCVMAC   Valor Maior Acmulo                                             ");                                               
            fpc_append($sEcoTxt,"10-PCVSAT    = $nPCVSAT   Valor Debito Atual Total                                        ");
            fpc_append($sEcoTxt,"11-PCVLCR    = $nPCVLCR   Valor Limite de Credito                                         ");
            fpc_append($sEcoTxt,"12-PCQPAG    = $nPCQPAG   Media Ponderada de Atraso nos Pagamentos (Titulos Pagos)        ");
            fpc_append($sEcoTxt,"13-PCQDAP    = $nPCQDAP   Media Aritmetica Dias de Atraso Pagamento                       ");
            fpc_append($sEcoTxt,"14-PCVDAV    = $nPCVDAV   Valor Debito Atual a Vencer                                     ");
            fpc_append($sEcoTxt,"15-PCMDAV    = $nPCMDAV   Media Ponderada de Titulos a Vencer                             ");
            fpc_append($sEcoTxt,"16-PCMPMV    = $nPCMPMV   Prazo Medio de Vendas                                           ");
            fpc_append($sEcoTxt,"17-PCDATV    = $nPCDATV   Valor Debito Atual Vencido + 5 Dias                             ");
            fpc_append($sEcoTxt,"18-PCMPTV    = $nPCMPTV   Media Ponderada de Atraso Titulos Vencidos e nao Pagos + 5 Dias ");
            fpc_append($sEcoTxt,"19-PCV+15D   = $nPCV_15D  Valor Debito Atual Vencido + 15 Dias                            ");
            fpc_append($sEcoTxt,"20-PCM+15D   = $nPCM_15D  Media Ponderada de Atraso Titulos Vencidos e nao Pagos + 15 Dias");
            fpc_append($sEcoTxt,"21-PCV+30D   = $nPCV_30D  Valor Debito Atual Vencido + 30 Dias                            ");
            fpc_append($sEcoTxt,"22-PCM+30D   = $nPCM_30D  Media Ponderada de Atraso Titulos Vencidos e nao Pagos + 30 Dias");
            fpc_append($sEcoTxt,"23-PCDTPC    = $tPCDTPC   Data da Penultima Compra                                        ");
            fpc_append($sEcoTxt,"24-PCVPCO    = $nPCVPCO   Valor da Penultima Compra                                       ");
            fpc_append($sEcoTxt,"25-PCVSIT    = $sPCVSIT   Situacao do Calculo Limite de Credito                           ");
            fpc_append($sEcoTxt,"26-PCTIPG    = $sPCTIPG   Tipo de Garantia                                                ");
            fpc_append($sEcoTxt,"27-PCGGA     = $sPCGGA    Grau da Garantia Hipoteca                                       ");
            fpc_append($sEcoTxt,"28-PCDTG     = $tPCDTG    Data Validade da Garantia                                       ");
            fpc_append($sEcoTxt,"29-PCVLG     = $nPCVLG    Valor da Garantia                                               ");
            fpc_append($sEcoTxt,"30-PCVPA     = $nPCVPA    Valor da Venda Pagamento Antecipado                             ");
            fpc_append($sEcoTxt,"31-PCSVV     = $nPCSVV    Venda sem Credito (ANTECIPADO)                                  ");

            fpc_append($sPathContent," -----------------------------------------------------------------------------------------");
            fpc_append($sPathContent," 1-PCTIPO    = $jPCTIPO   Identif. {1-CNPJ,2-CPF,3-RG,4-Export.,5-Insc.Prod.,9-Outros}    ");
            fpc_append($sPathContent," 2-PCCASS    = $sPCCASS   Codigo do Associado                                             ");
            fpc_append($sPathContent," 3-PCCCLI    = $sPCCCLI   Identificacao. (CNPJ/CPF/RG/Export./Insc.Prod./Outros)          ");
            fpc_append($sPathContent," 4-PCDDAT    = $tPCDDAT   Data da Informacao                                              ");
            fpc_append($sPathContent," 5-PCDCDD    = $tPCDCDD   Data Cadastramento do Cliente                                   ");
            fpc_append($sPathContent," 6-PCDUCM    = $tPCDUCM   Data da ultima Compra                                           ");
            fpc_append($sPathContent," 7-PCVULC    = $nPCVULC   Valor da ultima Compra                                          ");
            fpc_append($sPathContent," 8-PCDMAC    = $tPCDMAC   Data do Maior Acmulo                                           ");                                               
            fpc_append($sPathContent," 9-PCVMAC    = $nPCVMAC   Valor Maior Acmulo                                             ");                                               
            fpc_append($sPathContent,"10-PCVSAT    = $nPCVSAT   Valor Debito Atual Total                                        ");
            fpc_append($sPathContent,"11-PCVLCR    = $nPCVLCR   Valor Limite de Credito                                         ");
            fpc_append($sPathContent,"12-PCQPAG    = $nPCQPAG   Media Ponderada de Atraso nos Pagamentos (Titulos Pagos)        ");
            fpc_append($sPathContent,"13-PCQDAP    = $nPCQDAP   Media Aritmetica Dias de Atraso Pagamento                       ");
            fpc_append($sPathContent,"14-PCVDAV    = $nPCVDAV   Valor Debito Atual a Vencer                                     ");
            fpc_append($sPathContent,"15-PCMDAV    = $nPCMDAV   Media Ponderada de Titulos a Vencer                             ");
            fpc_append($sPathContent,"16-PCMPMV    = $nPCMPMV   Prazo Medio de Vendas                                           ");
            fpc_append($sPathContent,"17-PCDATV    = $nPCDATV   Valor Debito Atual Vencido + 5 Dias                             ");
            fpc_append($sPathContent,"18-PCMPTV    = $nPCMPTV   Media Ponderada de Atraso Titulos Vencidos e nao Pagos + 5 Dias ");
            fpc_append($sPathContent,"19-PCV+15D   = $nPCV_15D  Valor Debito Atual Vencido + 15 Dias                            ");
            fpc_append($sPathContent,"20-PCM+15D   = $nPCM_15D  Media Ponderada de Atraso Titulos Vencidos e nao Pagos + 15 Dias");
            fpc_append($sPathContent,"21-PCV+30D   = $nPCV_30D  Valor Debito Atual Vencido + 30 Dias                            ");
            fpc_append($sPathContent,"22-PCM+30D   = $nPCM_30D  Media Ponderada de Atraso Titulos Vencidos e nao Pagos + 30 Dias");
            fpc_append($sPathContent,"23-PCDTPC    = $tPCDTPC   Data da Penultima Compra                                        ");
            fpc_append($sPathContent,"24-PCVPCO    = $nPCVPCO   Valor da Penultima Compra                                       ");
            fpc_append($sPathContent,"25-PCVSIT    = $sPCVSIT   Situacao do Calculo Limite de Credito                           ");
            fpc_append($sPathContent,"26-PCTIPG    = $sPCTIPG   Tipo de Garantia                                                ");
            fpc_append($sPathContent,"27-PCGGA     = $sPCGGA    Grau da Garantia Hipoteca                                       ");
            fpc_append($sPathContent,"28-PCDTG     = $tPCDTG    Data Validade da Garantia                                       ");
            fpc_append($sPathContent,"29-PCVLG     = $nPCVLG    Valor da Garantia                                               ");
            fpc_append($sPathContent,"30-PCVPA     = $nPCVPA    Valor da Venda Pagamento Antecipado                             ");
            fpc_append($sPathContent,"31-PCSVV     = $nPCSVV    Venda sem Credito (ANTECIPADO)                                  ");

            $aCISP    = array();
            $aCISP[]  = $jPCTIPO                                                            ;
            $aCISP[]  = $sPCCASS                                                            ;
            $aCISP[]  = str_pad($sPCCCLI,20,"0",STR_PAD_LEFT)                               ;
            $aCISP[]  = fsCISPEnviaData($tPCDDAT)                                           ;
            $aCISP[]  = fsCISPEnviaData($tPCDCDD)                                           ;
            $aCISP[]  = fsCISPEnviaData($tPCDUCM)                                           ;
            $aCISP[]  = str_pad(100*number_format($nPCVULC,2,".",""),15,"0",STR_PAD_LEFT)   ;
            $aCISP[]  = fsCISPEnviaData($tPCDMAC)                                           ;
            $aCISP[]  = str_pad(100*number_format($nPCVMAC,2,".",""),15,"0",STR_PAD_LEFT)   ;
            $aCISP[]  = str_pad(100*number_format($nPCVSAT,2,".",""),15,"0",STR_PAD_LEFT)   ;
            $aCISP[]  = str_pad(100*number_format($nPCVLCR,2,".",""),15,"0",STR_PAD_LEFT)   ;
            $aCISP[]  = str_pad(number_format($nPCQPAG*100,0,".",""),6,"0",STR_PAD_LEFT)    ;
            $aCISP[]  = str_pad(number_format($nPCQDAP*100,0,".",""),6,"0",STR_PAD_LEFT)    ;
            $aCISP[]  = str_pad(100*number_format($nPCVDAV,2,".",""),15,"0",STR_PAD_LEFT)   ;
            $aCISP[]  = str_pad(number_format($nPCMDAV*100,0,".",""),6,"0",STR_PAD_LEFT)    ;
            $aCISP[]  = str_pad(number_format($nPCMPMV*100,0,".",""),6,"0",STR_PAD_LEFT)    ;
            $aCISP[]  = str_pad(100*number_format($nPCDATV,2,".",""),15,"0",STR_PAD_LEFT)   ;
            $aCISP[]  = str_pad(number_format($nPCMPTV,0,".",""),4,"0",STR_PAD_LEFT)        ;
            $aCISP[]  = str_pad(100*number_format($nPCV_15D,2,".",""),15,"0",STR_PAD_LEFT)  ;
            $aCISP[]  = str_pad(number_format($nPCM_15D,0,".",""),4,"0",STR_PAD_LEFT)       ;
            $aCISP[]  = str_pad(100*number_format($nPCV_30D,2,".",""),15,"0",STR_PAD_LEFT)  ;
            $aCISP[]  = str_pad(number_format($nPCM_30D,0,".",""),4,"0",STR_PAD_LEFT)       ;
            $aCISP[]  = fsCISPEnviaData($tPCDTPC)                                           ;
            $aCISP[]  = str_pad(100*number_format($nPCVPCO,2,".",""),15,"0",STR_PAD_LEFT)   ;
            $aCISP[]  = $sPCVSIT                                                            ;
            $aCISP[]  = $sPCTIPG                                                            ;
            $aCISP[]  = $sPCGGA                                                             ;
            $aCISP[]  = fsCISPEnviaData($tPCDTG)                                            ;
            $aCISP[]  = str_pad(100*number_format($nPCVLG,2,".",""),15,"0",STR_PAD_LEFT)    ;
            $aCISP[]  = str_pad(100*number_format($nPCVPA,2,".",""),15,"0",STR_PAD_LEFT)    ;
            $aCISP[]  = '  '; //str_pad(100*number_format($nPCSVV,2,".",""),15,"0",STR_PAD_LEFT)    ;



            $sCISP = implode('',$aCISP);              
            if ($iLoop==1) fpc($sPathArquivo,$sCISP);   // para nao ir com a 1a linha em branco
            else           fpc_append($sPathArquivo,$sCISP);

            $sCISP = implode('|',$aCISP);              

            if ($iLoop==1) fpc($sPathHistory,$sCISP);   // para nao ir com a 1a linha em branco
            else           fpc_append($sPathHistory,$sCISP);

            

         } // foreach ($aDb as $aLin)
      } // if ($iCountDb>0) {
   } // $lGo==true

   if ($lOk==true) {
     fpc_append($sEcoTxt,'commit');
     flDbCommit($hDb);
     $aUserLog[] = "Processo realizado, arquivo [$sPathArquivo] criado com sucesso";
   } else {
     fpc_append($sEcoTxt,'rollback');
     flDbRollBack($hDb);
     $aUserLog[] = "ERRO na execucao do processo...";
     unlink($sPathArquivo);
     unlink($sPathEDI);
     unlink($sCISP_Hist);
   }

   flDbDisconnect($hDb);

} else {
   $aUserLog[] = "O arquivo de configuraes ($sFileConfig) no foi encontrado.";
   fpc_append($sEcoTxt,"O arquivo de configuraes ($sFileConfig) no foi encontrado.");
}
   
$sUserLog = implode(chr(10),$aUserLog);
fpc_append($sEcoTxt,"--//--");
fpc_append($sEcoTxt,"Log do usurio");
fpc_append($sEcoTxt,"$sUserLog");
$tJobEnd  = time();
$iJobElap = $tJobEnd-$tJobStart;
fpc_append($sEcoTxt,"--//--");
fpc_append($sEcoTxt,'Encerrado em '.date('d/m/Y h:i:s',$tJobEnd));
fpc_append($sEcoTxt,"Durao do processo em milisegundos = $iJobElap");
echo $sUserLog=='' ? 1 : $sUserLog;

fpc($psFileProcessName,'eop');

$tJobEnd  = time();
$iJobElap = $tJobEnd-$tJobStart;

$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];

$flSysJobs = flSysJobs($sProc,$nTopIni,$nTopFin,$tJobStart,$tJobEnd,$iJobElap,$psCliPasta,$psLogin);

function ftDataHoraToTimestamp($psDataHora) {   // yyyy-mm-dd hh:mm:ss
/////////////////////////////////////////////
// essa funcao substitui a strtotime
// echo "psDataHora=$psDataHora".chr(10);
$sDataHora = str_replace('/','-',$psDataHora);
// echo "sDataHora=$sDataHora".chr(10);
$aTmp  = explode(' ',$sDataHora);
$sData = $aTmp[0];
$sHora = (count($aTmp)>1) ? $aTmp[1] : '00:00:00';
// echo "sData=$sData".chr(10);
// echo "sHora=$sHora".chr(10);

$aTmp = explode('-',$sData);
$iAno = $aTmp[0];
$iMes = $aTmp[1];
$iDia = $aTmp[2];

$aTmp = explode(':',$sHora);
$iHor = $aTmp[0];
$iMin = $aTmp[1];
$iSeg = $aTmp[2];
// echo "$iHor, $iMin, $iSeg, $iMes, $iDia, $iAno".chr(10);
$tRet = mktime($iHor, $iMin, $iSeg, $iMes, $iDia, $iAno);
return $tRet;
}

function fsCISPEnviaData($psDataHora) {
///////////////////////////////////////
if ($psDataHora=='') $sRet = '00000000';
else                 $sRet = date('Ymd',ftDataHoraToTimestamp($psDataHora));
//echo "psDataHora=$psDataHora, sRet=$sRet".chr(10);
return $sRet;
}