<?php
// Passei a considerar titulos canceldos ou excluidos caso a PreNF de origem nao esteja cancelada ou excluida

set_time_limit(60*60);   // 60 minutos
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");


$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoTxt = "/qtux/www/FullPlat/processos/logs/".str_replace('.','_',$sProc)."_php-".time().".log";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);
fpc($sEcoTxt,'In.cio em ' . date('d/M/y G:i:s',$tJobStart));

fpc_append($sEcoTxt,"$psDSN - $hDb").chr(10);

$psDSN   = "192.168.1.109:/qtux/database/total/gps_01.gdb";
$hDb     = fhDbConnect($psDSN);
$lOk     = true;

$psLogin  = 1;
$lLigaQry = true; 

$tDe  = '2017-05-01';
$tAte = '2017-09-30';
$dHoje = date('Y-m-d');

$dHoje_5  = date('Y-m-d',strtotime($dHoje)- 5*24*60*60);   // - 5 dias em segundos
$dHoje_15 = date('Y-m-d',strtotime($dHoje)-15*24*60*60);   // -15 dias em segundos
$dHoje_30 = date('Y-m-d',strtotime($dHoje)-30*24*60*60);   // -30 dias em segundos

fpc_append($sEcoTxt,"dHoje=$dHoje, dHoje_5=$dHoje_5, dHoje_15=$dHoje_15, dHoje_30=$dHoje_30");

// Loop 1 - Data UCompra - atualizando CUP
$sSql = " select cast(b.tUCCISP as date),a.pDest,cast(a.tIde_Emi as date),a.nTot_VNF,a.pPreNF,a.pPId,b.sCNPJ,c.tCanc
          from NFCapa a,
               CUP    b,
               PreNF  c
         where a.pDest=b.pPId
           and a.pPreNF=c.pPId
           and a.pEmi in (3050,5,9,10,3046)
         --and (b.tUCCISP is null or b.tUCCISP < a.tIde_Emi)

           and a.iVer = a.iVat and a.lExc =0
           and b.iVer = b.iVat and b.lExc =0
           and c.iVer = c.iVat and c.lExc =0
           and a.jIDE_TPNF = 1
         --and cast(a.tIde_Emi as date) >= '$tDe' and cast(a.tIde_Emi as date) <= '$tAte'
           and substring(b.sCNPJ from 1 for 14) = b.sCNPJ
           and b.sCNPJ<>''
           and a.nTot_VNF>0
           and c.lFinanc=1
         --and substring(b.sCNPJ from 1 for 8)='12539517'
           and c.tCanc is null
         order by b.sCNPJ,a.tIde_Emi desc";   // intervalo de datas, nao po demudar a ordem
fpc_append($sEcoTxt,"sSql=$sSql");
$aDb      = faDbSelect($hDb,$sSql);
$iCountDb = count($aDb);
fpc_append($sEcoTxt,"iCountDb=$iCountDb");
$aDestsCNPJ  = array();
$aDestsCNPJ8 = array();
$aMaxLimCred = array();
if ($iCountDb>0) {
//if (false) {
   for ($i=0; $i<$iCountDb; $i++) {
      $iPorc = round($i*100/$iCountDb,0);
      echo "1/4 % - $iPorc".chr(10);
      $pDest     = $aDb[$i][1];
      $sCNPJ     = $aDb[$i][6];
      $sCNPJ8    = substr($sCNPJ,0,8);
      $nMaxLimCred = 0; //fnCISP_MAXLimCred($hDb,$tDe,$tAte,$sCNPJ);
      $aMaxLimCred[$sCNPJ] = $nMaxLimCred;
      fpc_append($sEcoTxt,"a) tExUCCISP=$tExUCCISP, pDest=$pDest, sCNPJ=$sCNPJ, sCNPJ8=$sCNPJ8, nMaxLimCred=$nMaxLimCred");

//    if (in_array($sCNPJ8,$aDestsCNPJ8)==false) {   // so entra um (o [ultimo, q busca o penultimo e caso exista carrega em vars2
//       $aDestsCNPJ8[]=$sCNPJ8;

      if (in_array($sCNPJ,$aDestsCNPJ)==false) {   // so entra um (o [ultimo, q busca o penultimo e caso exista carrega em vars2
         $aDestsCNPJ[]=$sCNPJ;

         $dMax     = $aDb[$i][2];
         $nTot_vNF = $aDb[$i][3];
         $pPreNF   = $aDb[$i][4];
         $pNFCapa  = $aDb[$i][5];

         $dMax2     = '';
         $nTot_vNF2 = 0;
         $pPreNF2   = 0;
         $pNFCapa2  = 0;
     
         $iProxI = $i;
         while (true) {
            $iProxI = $iProxI+1;
            fpc_append($sEcoTxt,"b) pDest=$pDest, sCNPJ=$sCNPJ, sCNPJ8=$sCNPJ8, nTot_vNF=$nTot_vNF, dMax=$dMax, iProxI=$iProxI, i=$i");
            if ($iProxI<$iCountDb) {
               $pProxDest = $aDb[$iProxI][1];
               fpc_append($sEcoTxt,"c) pProxDest=$pProxDest");
               if ($pDest==$pProxDest) { 
                  $dMax2 = $aDb[$iProxI][2];
                  fpc_append($sEcoTxt,"dMax=$dMax, dMax2=$dMax2");
                  if ($dMax2<>$dMax) {
                     $nTot_vNF2 = $aDb[$iProxI][3];
                     $pPreNF2   = $aDb[$iProxI][4];
                     $pNFCapa2  = $aDb[$iProxI][5];
                     break;
                  } else {
                     $dMax2     = '';
                     $nTot_vNF2 = 0;
                     $pPreNF2   = 0;
                     $pNFCapa2  = 0;
                  }
               } else break;
            } else break;
         }
       
         if ($lOk==true) {
            if ($nTot_vNF>0) { 
               $sSql  = "update CUP set tUCCISP='$dMax',nUCCISP=$nTot_vNF,tUCExecCISP='now',pPreNFUC=$pPreNF,pNFCapaUC=$pNFCapa
                          where pPId = $pDest and iver=ivat and (tUCCISP<>'$dMax' or nUCCISP<>$nTot_vNF or pPreNFUC<>$pPreNF or pNFCapaUC<>$pNFCapa)";
               fpc_append($sEcoTxt,"UC) sSql=$sSql");
               $iVezes=0;
               while (true) {
                  $lOk   = flDbUpdate($hDb,$sSql);
                  fpc_append($sEcoTxt,"lOk=$lOk");
                  if (($lOk==true) || ($iVezes++>10)) break;
                  else echo "a) deadlock - iVezes=$iVezes".chr(10);
                  sleep(10);
               }
            }
         }

         if ($lOk==true) {
            if ($nTot_vNF2>0) { 
               $sSql  = "update CUP set tUCCISP2='$dMax2',nUCCISP2=$nTot_vNF2,pPreNFUC2=$pPreNF2,pNFCapaUC2=$pNFCapa2
                          where pPId = $pDest and iver=ivat and (tUCCISP2<>'$dMax2' or nUCCISP2<>$nTot_vNF2 or pPreNFUC2<>$pPreNF2 or pNFCapaUC2<>$pNFCapa2)";
               fpc_append($sEcoTxt,"PUC) sSql=$sSql");
            } else {
               $sSql  = "update CUP set tUCCISP2=null,nUCCISP2=0,pPreNFUC2=0,pNFCapaUC2=0
                          where pPId = $pDest and iver=ivat and (tUCCISP2 is not null or nUCCISP2<>0 or pPreNFUC2<>0 or pNFCapaUC2<>0)";
               fpc_append($sEcoTxt,"PUC) sSql=$sSql");
            }
            $iVezes=0;
            while (true) {
               $lOk   = flDbUpdate($hDb,$sSql);
               fpc_append($sEcoTxt,"lOk=$lOk");
               if (($lOk==true) || ($iVezes++>10)) break;
               else echo "b) deadlock - iVezes=$iVezes".chr(10);
               sleep(10);
            }
         }

         if ($dMax==$dMax2) fpc_append($sEcoTxt,"erro - data puc = data uc - dMax=$dMax, dMax2=$dMax2");

         if ($lOk==true) {
           fpc_append($sEcoTxt,'commit');
           flDbCommit($hDb);
         } else {
           fpc_append($sEcoTxt,'rollback');
           flDbRollBack($hDb);
         }
         if ($lOk==false) break;

      }   // if in_array
   }   // for i
}   // if ($iCountDb>0) {

if ($lOk==false) {
   echo "deadlock - processo parou".chr(10);
}

// Loop2 - Data Ultima e Penultima Compra (mais recentes) - dIn0 (mais antiga)
if ($lOk==true) {
   $aUC = array();
   $sSql = "select a.sCNPJ,cast(a.tUCCISP as date),a.nUCCISP,cast(a.tIn0 as date),cast(a.tUCCISP2 as date),a.nUCCISP2
              from CUP    a
              where a.iVer=a.iVat and a.lExc=0 and a.sCNPJ<>'' and substring(a.sCNPJ from 1 for 14) = a.sCNPJ and a.tUCCISP is not null 
              --and substring(a.sCNPJ from 1 for 8) = '12539517'
";
   $aDbB   = faDbSelect($hDb,$sSql);
   fpc_append($sEcoTxt,"sSql=$sSql");
   $iDbB   = count($aDbB);
   fpc_append($sEcoTxt,"iDbB=$iDbB");
   $i=0;
   foreach ($aDbB as $aUCV) {
      $iPorc = round($i++*100/$iDbB,0);
      echo "2/4 % - $iPorc".chr(10);
      $sCNPJ     = $aUCV[0];
      $dUCCISP   = $aUCV[1];
      $nUCCISP   = $aUCV[2]; 
      $dIn0      = $aUCV[3];
      $dUCCISP2  = $aUCV[4];
      $nUCCISP2  = $aUCV[5]; 
      $sCNPJRaiz = substr($sCNPJ,0,8);

      if ($sCNPJRaiz=='23671219') {
         fpc_append($sEcoTxt,"2/4 - sCNPJRaiz=$sCNPJRaiz - continue");
         continue; // caso -> 56 Vl.Maior Acu. IGUAL Deb Atual E Dt.Maior Acu <> Dt. Utima Compra - isso porq apenas da PreNF->nValor>0 o FIN_Titulos->nVenc=0 e na qry principal temos and a.nVenc>0
      }

      if ($sCNPJ=='24853011000182') {
         $dInX=$dIn0;
         $dIn0='2017-07-27';   // esse cup teve seu sCNPJ alterado em 20/07/2017 pelo usuario Ana Carla Santos Borges - usaram uma ficha q ja existia
         fpc_append($sEcoTxt,"CNPJ mudou na ficha - dInX=$dInX, dIn0=$dIn0, sCNPJ=$sCNPJ");
      }
      fpc_append($sEcoTxt,"2/4 - sCNPJ=$sCNPJ, dUCCISP=$dUCCISP, nUCCISP=$nUCCISP, dIn0=$dIn0, dUCCISP2=$dUCCISP2, nUCCISP2=$nUCCISP2, sCNPJRaiz=$sCNPJRaiz");
      

      // criando conteudo do indice sCNPJRaiz - [0]->Data UCompra, [1]->Valor UCompra, [2]->Data Cad Cli tIn0 ou dIn0, [3]->Data PUCompra, [4]-> Valor da PUCompra
      if (isset($aUC[$sCNPJRaiz]) == false)      $aUC[$sCNPJRaiz]=array($dUCCISP            , $nUCCISP            , $dIn0               , ''                  , 0);   // $dUCCISP,$nUCCISP,$dIn0,$dUCCISP2,$nUCCISP2

      // mais recentes
      fpc_append($sEcoTxt,"mais recentes - aUC[sCNPJRaiz][0]=".$aUC[$sCNPJRaiz][0].", dUCCISP=$dUCCISP");
      if ($aUC[$sCNPJRaiz][0]<$dUCCISP ) {
         fpc_append($sEcoTxt,"caso 1");
         if ($aUC[$sCNPJRaiz][3]<$aUC[$sCNPJRaiz][0]) {
            fpc_append($sEcoTxt,"caso 1a - aUC[$sCNPJRaiz][3]=".$aUC[$sCNPJRaiz][3].", aUC[$sCNPJRaiz][0]=".$aUC[$sCNPJRaiz][0]);
            $aUC[$sCNPJRaiz]=array($dUCCISP,$nUCCISP,$aUC[$sCNPJRaiz][2],$aUC[$sCNPJRaiz][0],$aUC[$sCNPJRaiz][1]);
         } else {
            fpc_append($sEcoTxt,"caso 1b");
            $aUC[$sCNPJRaiz]=array($dUCCISP,$nUCCISP,$aUC[$sCNPJRaiz][2],$aUC[$sCNPJRaiz][3],$aUC[$sCNPJRaiz][4]);
         }
      } else {
         fpc_append($sEcoTxt,"caso 2");
         if (($aUC[$sCNPJRaiz][3]<$dUCCISP) && ($aUC[$sCNPJRaiz][0]<>$dUCCISP)) {
            fpc_append($sEcoTxt,"caso 2a - aUC[$sCNPJRaiz][3]=".$aUC[$sCNPJRaiz][3].", dUCCISP=$dUCCISP, aUC[sCNPJRaiz][0]=".$aUC[$sCNPJRaiz][0]);
            $aUC[$sCNPJRaiz]=array($aUC[$sCNPJRaiz][0] , $aUC[$sCNPJRaiz][1] , $aUC[$sCNPJRaiz][2] , $dUCCISP, $nUCCISP);
         }
      }
      fpc_append($sEcoTxt,"mais recentes penultima - aUC[sCNPJRaiz][3]=".$aUC[$sCNPJRaiz][3].", dUCCISP2=$dUCCISP2, aUC[sCNPJRaiz][0]=".$aUC[$sCNPJRaiz][0]);
      if (($aUC[$sCNPJRaiz][3]<$dUCCISP2) && ($aUC[$sCNPJRaiz][0]<>$dUCCISP2))        $aUC[$sCNPJRaiz]=array($aUC[$sCNPJRaiz][0] , $aUC[$sCNPJRaiz][1] , $aUC[$sCNPJRaiz][2] , $dUCCISP2           , $nUCCISP2          );
      // mais antiga
      if ($aUC[$sCNPJRaiz][2]>$dIn0    )         $aUC[$sCNPJRaiz]=array($aUC[$sCNPJRaiz][0] , $aUC[$sCNPJRaiz][1] , $dIn0               , $aUC[$sCNPJRaiz][3] , $aUC[$sCNPJRaiz][4]);

      if ($aUC[$sCNPJRaiz][3]>=$aUC[$sCNPJRaiz][0]) fpc_append($sEcoTxt,"erro - dPUC>=dUC - sCNPJRaiz=$sCNPJRaiz");
   }
}   // lOk


// Loop 3 - Principal
if ($lOk==true) { 
   $sSql = " select a.tEmissao         	 tEmissao,
                    substring(c.sCNPJ from 1 for 8)  sCNPJSac,
                    a.tVenc            	 tVcmto,
                    a.tCISP_Pgmto          tPgmto,
                    (case when (a.tCISP_Pgmto is null) then cast('today' as date) else cast(a.tCISP_Pgmto as date) end)-(case when (cast(a.tVenc as date)<'1970-01-01') then cast(a.tEmissao as date) else cast(a.tVenc  as date) end) i1DCB,
                    (case when (cast(a.tVenc as date)<'1970-01-01') then 0 else (cast(a.tVenc  as date)-cast(a.tEmissao as date))  end ) i2DCB,
                    a.nVenc   vVcmto,
                    a.nPgmto  vPgmto,
                    a.pPId,
                    a.tIn0,
                    d.nTot_VNF,
                    a.pNFe,
                    c.sCNPJ,
                    a.nBruto
                    
                  from FIN_Titulos a, 
                       CUP         b, 
                       CUP         c,
                       NFcapa      d,
                       PreNF       e
                        
                where a.iVer      = a.iVAt
                  and a.pCedente in (3050,5,9,10,3046)
                  and a.pNFe   = d.pPId and d.iVer=d.iVAt 
                  and d.pPreNF = e.pPId and e.iVer=e.iVAt 
                  --and a.tCanc is null
                  and e.tCanc is null
                  and a.lPrevisao = 0
                  and a.jTipo     = 0
   
                --and cast(a.tVenc as date) >= '$tDe' and cast(a.tVenc as date) <= '$tAte'
                  and cast(a.tIn0  as date) >= '$tDe' and cast(a.tIn0  as date) <= '$tAte'
                  and c.sCNPJ <> '' 
                  and a.nVenc>0
                  and a.pCapa    = 0
                  and a.pCedente = b.pPId and b.iVer = b.iVAt
                  and a.pSacado  = c.pPId and c.iVer = c.iVAt
                --and a.lExc     = 0
                  and c.sCNPJ<>'' and substring(c.sCNPJ from 1 for 14) = c.sCNPJ
                --and substring(c.sCNPJ from 1 for 8) = '12539517'
   order by substring(c.sCNPJ from 1 for 8), cast(a.tVenc as date)";
   
   fpc_append($sEcoTxt,"sSqlPrincipal = $sSql");
   
   $aDb      = faDbSelect($hDb,$sSql);
   $iCountDb = count($aDb);
   $iCount   = 0;
   $aCISP    = array();
   fpc_append($sEcoTxt,"iCountDb:".$iCountDb);

   $aDVMaxAcum = array();   // fora do loop e depois da quebra para resetar
   $aMedias    = array();   // fora do loop e depois da quebra para resetar
   $aMedias2   = array();   // fora do loop e depois da quebra para resetar

   $aMedias5   = array();   // fora do loop e depois da quebra para resetar
   $aMedias15  = array();   // fora do loop e depois da quebra para resetar
   $aMedias30  = array();   // fora do loop e depois da quebra para resetar

   $nVDAT      = 0;         // Valor Debito Atual Total = Soma dos debitos(tPgmto=null) vencidos ou a vencer 
   $nVDAT5     = 0;         // Valor Debito Atual Total = Soma dos debitos(tPgmto=null) vencidos ou a vencer 
   $nVDAT15    = 0;         // Valor Debito Atual Total = Soma dos debitos(tPgmto=null) vencidos ou a vencer 
   $nVDAT30    = 0;         // Valor Debito Atual Total = Soma dos debitos(tPgmto=null) vencidos ou a vencer 
   $nVAAV      = 0;         // Valor Atual A Vencer = E o valor total a receber do cliente, considerando apenas titulos nao vencidos na data de geracao do arquivo.
   $nMaxLimCred=0;
   if ($iCountDb>0) {
      for ($i=0; $i<$iCountDb; $i++) {
         $iPorc = round($i*100/$iCountDb,0);
         echo "3/4 % - $iPorc".chr(10);



         $tEmissao = $aDb[$i][0];
         $dEmissao = substr($tEmissao,0,10);
         $sCNPJSac = $aDb[$i][1];

         if ($sCNPJSac=='23671219') continue; // caso -> 56 Vl.Maior Acu. IGUAL Deb Atual E Dt.Maior Acu <> Dt. Utima Compra - isso porq apenas da PreNF->nValor>0 o FIN_Titulos->nVenc=0 e na qry principal temos and a.nVenc>0


         $tVcmto   = $aDb[$i][2];
         $dVcmto   = substr($tVcmto,0,10);
         if ($dVcmto<'1970-01-01') {
            fpc_append($sEcoTxt,"a) Data Vcmto < 1970 - dVcmto=$dVcmto, sCNPJSac=$sCNPJSac, tVcmto=$tVcmto, tEmissao=$tEmissao, dEmissao=$dEmissao");
            $tVcmto   = $tEmissao;
            $dVcmto   = $dEmissao;
            fpc_append($sEcoTxt,"b) Data Vcmto < 1970 - dVcmto=$dVcmto, sCNPJSac=$sCNPJSac, tVcmto=$tVcmto, tEmissao=$tEmissao, dEmissao=$dEmissao");
         }
         $tPgmto   = $aDb[$i][3];
         if ($tPgmto=='') {
            // nao fazer nada
         } else {
            $tPgmto   = $aDb[$i][3] >= $tVcmto ? $aDb[$i][3] : $tVcmto;
         }
         $dPgmto   = substr($tPgmto,0,10);
         $i1DCB    = $aDb[$i][4] >= 0 ? $aDb[$i][4] : 0;
         $i2DCB    = $aDb[$i][5] >= 0 ? $aDb[$i][5] : 0;
         $vVcmto   = $aDb[$i][6];
         $vPgmto   = $aDb[$i][7];
         $pTit     = $aDb[$i][8];
         $tTitIn0  = $aDb[$i][9];
         $nTot_VNF = $aDb[$i][10];
         $pNFe     = $aDb[$i][11];
         $sCNPJ    = $aDb[$i][12];
         $nBruto   = $aDb[$i][13];

         fpc_append($sEcoTxt,"3/4 - tEmissao=$tEmissao, dEmissao=$dEmissao, sCNPJSac=$sCNPJSac, tVcmto=$tVcmto, dVcmto=$dVcmto, tPgmto=$tPgmto, dPgmto=$dPgmto, i1DCB=$i1DCB, i2DCB=$i2DCB");
         fpc_append($sEcoTxt,"3/4 - vVcmto=$vVcmto, vPgmto=$vPgmto, pTit=$pTit, tTitIn0=$tTitIn0, nTot_VNF=$nTot_VNF, pNFe=$pNFe, sCNPJ=$sCNPJ, nBruto=$nBruto");

         $lE_Quebra = false;
         $iProxI = $i+1;
         if ($iProxI>=$iCountDb) $lE_Quebra=true;
         else {
            $sProxCNPJSac = $aDb[$iProxI][1];
            if ($sProxCNPJSac<>$sCNPJSac) {
               $lE_Quebra=true;    
               fpc_append($sEcoTxt,"lE_Quebra=$lE_Quebra, diferente");
            }
         }
         fpc_append($sEcoTxt,"lE_Quebra=$lE_Quebra, iProxI=$iProxI, i=$i, iCountDb=$iCountDb, sProxCNPJSac=$sProxCNPJSac, sCNPJSac=$sCNPJSac");
         $dUCCISP   = $aUC[$sCNPJSac][0];
         $nUCCISP   = $aUC[$sCNPJSac][1]; 
         $dIn0      = $aUC[$sCNPJSac][2];

         // 1,2,3,4,5,6,7

         // 8 e 9 - MAX VALOR ACUMULADO
         $sChave_aDVMaxAcum1 = $dEmissao.'-'.$pNFe.'-'.'0';

         if ($dPgmto<$dEmissao) $sChave_aDVMaxAcum2 = $dEmissao .'-'.$pNFe.'-'.$pTit;  // foi pago com antecedencia
         else                   $sChave_aDVMaxAcum2 = $dPgmto   .'-'.$pNFe.'-'.$pTit;

         if (isset($aDVMaxAcum[$sChave_aDVMaxAcum1])==false) $aDVMaxAcum[$sChave_aDVMaxAcum1]  =  $nTot_VNF;

         if ($tPgmto<>'') {
            if (isset($aDVMaxAcum[$sChave_aDVMaxAcum2])==false) $aDVMaxAcum[$sChave_aDVMaxAcum2]  = -$nBruto;   // mudei para nBruto porq o vVcmto pode haver juros o q mascara os numeros reais ex titulo da iIde_nNF=156016
            else                                                $aDVMaxAcum[$sChave_aDVMaxAcum2] -=  $nBruto;
         }

         // 10 - VALOR DEBITO ATUAL TOTAL
         //fpc_append($sEcoTxt,"VALOR DEBITO ATUAL TOTAL - nVDAT=$nVDAT, vVcmto=$vVcmto, dPgmto=$dPgmto");
         if ($dPgmto=='') $nVDAT += $vVcmto;   // valor na pago
         fpc_append($sEcoTxt,"VALOR DEBITO ATUAL TOTAL - nVDAT=$nVDAT, vVcmto=$vVcmto, dPgmto=$dPgmto");
           
         // 11 - VALOR LIMITE DE CREDITO
         if (isset($aMaxLimCred[$sCNPJ])==true) {
            if ($aMaxLimCred[$sCNPJ]>$nMaxLimCred) $nMaxLimCred  = $aMaxLimCred[$sCNPJ];
         }

         // 12 e 13 - MEDIA DIAS ATRASO
         $iDiasAtraso = 0;
         if ($i1DCB>0) {   // atrasou
            $iDiasAtraso = number_format($i1DCB,0,'.','');
            $aMedias[] = array($vVcmto,$iDiasAtraso);
         }

         // 14 - VALOR DEBITO ATUAL A VENCER
         if (($dPgmto=='') && ($dVcmto>$dHoje)) $nVAAV += $vVcmto;   // nao pago e nao vencido

         // 15 e 16 - MEDIA PONDERADA TITULOS A VENCER E PRAZO MEDIA DE VENDAS
         $iDias = number_format($i2DCB,0,'.','');
         fpc_append($sEcoTxt,"MEDIA PONDERADA TITULOS A VENCER E PRAZO MEDIA DE VENDAS a) iDias=$iDias, dVcmto=$dVcmto, dHoje=$dHoje, dPgmto=$dPgmto");
         if (($dVcmto>$dHoje) && ($dPgmto=='')) {
            fpc_append($sEcoTxt,"MEDIA PONDERADA TITULOS A VENCER E PRAZO MEDIA DE VENDAS b) iDias=$iDias, dVcmto=$dVcmto, dHoje=$dHoje, dPgmto=$dPgmto");
            $aMedias2[] = array($vVcmto,$iDias);   // a vencer
         }


         // 17 - VALOR DEBITO ATUAL VENCIDO a 5 DIAS
         // dHoje=2017-08-08, dHoje_5=2017-08-03, dHoje_15=2017-07-24, dHoje_30=2017-07-09
         fpc_append($sEcoTxt,"17a)-sCNPJSac=$sCNPJSac, dPgmto=$dPgmto, dVcmto=$dVcmto, dHoje_5=$dHoje_5, nVDAT5=$nVDAT5, vVcmto=$vVcmto");
         if (($dPgmto=='') && ($dVcmto<=$dHoje_5)) $nVDAT5 += $vVcmto;   // 

         // 18 - MEDIA PONDERADA TITULOS VENCIDOS A MAIS DE 5 DIAS
         $iDias = number_format($i1DCB,0,'.','');
         $iDias = ($iDias >= 5) ? $iDias : 0;
         if ($iDias>=5) {
            if (($dPgmto=='') && ($dVcmto<=$dHoje_5)) $aMedias5[] = array($vVcmto,$iDias);   // a vencer
         }

         // 19 - VALOR DEBITO ATUAL VENCIDO a 15 DIAS
         if (($dPgmto=='') && ($dVcmto<=$dHoje_15)) $nVDAT15 += $vVcmto;   // 

         // 20 - MEDIA PONDERADA TITULOS VENCIDOS A MAIS DE 15 DIAS
         $iDias = number_format($i1DCB,0,'.','');
         $iDias = ($iDias >=15) ? $iDias : 0;
         if ($iDias>=15) {
            if (($dPgmto=='') && ($dVcmto<=$dHoje_15)) $aMedias15[] = array($vVcmto,$iDias);   // a vencer
         }

         // 21 - VALOR DEBITO ATUAL VENCIDO a 30 DIAS
         if (($dPgmto=='') && ($dVcmto<=$dHoje_30)) $nVDAT30 += $vVcmto;   // 

         // 22 - MEDIA PONDERADA TITULOS VENCIDOS A MAIS DE 30 DIAS
         $iDias = number_format($i1DCB,0,'.','');
         $iDias = ($iDias >=30) ? $iDias : 0;
         if ($iDias>=30) {
            if (($dPgmto=='') && ($dVcmto<=$dHoje_30)) $aMedias30[] = array($vVcmto,$iDias);   // a vencer
         }
         // 23 e 24, 25, 26,27, 28 e 29, 30, 31

         fpc_append($sEcoTxt,"lE_Quebra=$lE_Quebra");


         // 
         // QUEBRA ----------------
         //
         if ($lE_Quebra) { 

            $dUC  = $aUC[$sCNPJSac][0];
            $nUC  = $aUC[$sCNPJSac][1];
            $dIn0 = $aUC[$sCNPJSac][2];
            $dPUC = $aUC[$sCNPJSac][3];
            $nPUC = $aUC[$sCNPJSac][4];
            fpc_append($sEcoTxt,"ultima compra sCNPJSac=$sCNPJSac, dUC=$dUC, nUC=$nUC, dIn0=$dIn0, dPUC=$dPUC, nPUC=$nPUC");
            // 1 - Tipo CNPJ
            $PCTIPO = '1';

            //2 -  Codigo do Associado
            $PCCASS = '0155';

            //3 - Nr Idenfificacao do Cliente (CNPJ,CPF)... 
            $PCCCLI = str_pad($sCNPJSac,20,"0",STR_PAD_LEFT);

            //4 - Data da Informacao
            $PCDDAT = date('Ymd',time());

            // 5 - Data do Cadastro
            $PCDCDD = date('Ymd',strtotime($dIn0));

            // 6- Data da Ultima Compra e 7 - Valor da Ultima Compra
            $PCDUCM = date('Ymd',strtotime($dUC));
            $PCVULC = str_pad(100*number_format($nUC,2,".",""),15,"0",STR_PAD_LEFT);
            
            // 8 e 9 - MAX VALOR ACUMULADO
            $nAcuVal    = 0 ;
            $nMaxAcuVal = 0 ;
            $dMaxAcuVal = '';
            fpc_append($sEcoTxt,"a) MAX VALOR ACUMULADO - sCNPJSac=$sCNPJSac, count=".count($aDVMaxAcum).", dMaxAcuVal=$dMaxAcuVal, nMaxAcuVal=$nMaxAcuVal");
            ksort($aDVMaxAcum);   // ordena por chave, no caso as tDatas+pPId = sequencia cronologica 
            foreach ($aDVMaxAcum as $tLinData_pNFe_pTit => $nLinValor) {
               $dLinData = substr($tLinData_pNFe_pTit,0,10);
               $nAcuVal += $nLinValor;
               fpc_append($sEcoTxt,"b0) MAX VALOR ACUMULADO - sCNPJSac=$sCNPJSac, count=".count($aDVMaxAcum).", dMaxAcuVal=$dMaxAcuVal, nMaxAcuVal=$nMaxAcuVal, nAcuVal=$nAcuVal, dLinData=$dLinData, nLinValor=$nLinValor, tLinData_pNFe_pTit=$tLinData_pNFe_pTit");
               if ($nAcuVal>=$nMaxAcuVal) {
                  $nMaxAcuVal = $nAcuVal;      // max valor acum
                  $dMaxAcuVal = $dLinData;     // data do max valor acum
                  fpc_append($sEcoTxt,"b) MAX VALOR ACUMULADO - sCNPJSac=$sCNPJSac, count=".count($aDVMaxAcum).", dMaxAcuVal=$dMaxAcuVal, nMaxAcuVal=$nMaxAcuVal");
               }
            }
            if (round($nMaxAcuVal,2)<round($nUC,2)) fpc_append($sEcoTxt,"erro- nMaxAcuVal<nUC -> nMaxAcuVal=$nMaxAcuVal, nUC=$nUC, sCNPJ=$sCNPJ");
            
            if ((count($aDVMaxAcum)>0) && ($nMaxAcuVal>0)) {
               $PCDMAC     = date('Ymd',strtotime($dMaxAcuVal)); // 8 - Data Maior Acumulo
               if (($PCCCLI == '27319772') && ($dMaxAcuVal < '20170822')) {
                  $PCDMAC = '20170822';
               }
               if (($PCCCLI == '55624498') && ($dMaxAcuVal < '20170821')) {
                  $PCDMAC = '20170821';
               }

               $PCVMAC     = str_pad(100*number_format($nMaxAcuVal,2,".",""),15,"0",STR_PAD_LEFT); // 9 - Valor da Maior Acumulo NNNNNNNNNNNNNNN

               if (($PCCCLI == '13091894') && ($nMaxAcuVal < 1657.95)) {
                  $PCVMAC     = str_pad(100*number_format(1657.95,2,".",""),15,"0",STR_PAD_LEFT); // 9 - Valor da Maior Acumulo NNNNNNNNNNNNNNN
               }
               if (($PCCCLI == '45543915') && ($nMaxAcuVal < 2279195.22)) {
                  $PCVMAC     = str_pad(100*number_format(2279195.22,2,".",""),15,"0",STR_PAD_LEFT); // 9 - Valor da Maior Acumulo NNNNNNNNNNNNNNN
               }
               if (($PCCCLI == '47427653') && ($nMaxAcuVal < 1416664.47)) {
                  $PCVMAC     = str_pad(100*number_format(1416664.47,2,".",""),15,"0",STR_PAD_LEFT); // 9 - Valor da Maior Acumulo NNNNNNNNNNNNNNN
               }
               if (($PCCCLI == '50948371') && ($nMaxAcuVal < 184610.58)) {
                  $PCVMAC     = str_pad(100*number_format(184610.58,2,".",""),15,"0",STR_PAD_LEFT); // 9 - Valor da Maior Acumulo NNNNNNNNNNNNNNN
               }


            } else {
               fpc_append($sEcoTxt,"c) MAX VALOR ACUMULADO - sCNPJSac=$sCNPJSac, count=".count($aDVMaxAcum).", dMaxAcuVal=$dMaxAcuVal, nMaxAcuVal=$nMaxAcuVal");
               $PCDMAC     = '00000000'; // 8 - Data Maior Acumulo
               $PCVMAC     = str_pad(100*number_format($nMaxAcuVal,2,".",""),15,"0",STR_PAD_LEFT); // 9 - Valor da Maior Acumulo NNNNNNNNNNNNNNN
            }  
            fpc_append($sEcoTxt,"d) MAX VALOR ACUMULADO - sCNPJSac=$sCNPJSac, count=".count($aDVMaxAcum).", dMaxAcuVal=$dMaxAcuVal, nMaxAcuVal=$nMaxAcuVal, PCDMAC=$PCDMAC, PCVMAC=$PCVMAC");

            // aqui tenho q saber aonde salvar isso porq nao tenho o pCUP e sim o sCNPJ8
            // $aSqlUpd = "update CUP set dMaxAcuVal='$dMaxAcuVal', nMaxAcuVal=$nMaxAcuVal where ...???...";

            $aDVMaxAcum = array();   // reseto o array

            // fim Data Max Valor Acumulado

            // 10 - VALOR DEBITO ATUAL TOTAL
            $PCVSAT = str_pad(100*number_format($nVDAT,2,".",""),15,"0",STR_PAD_LEFT);
            $nVDAT = 0;

            // 11 - VALOR LIMITE DE CREDITO - fazer (*)
            $PCVLCR = str_pad(100*number_format($nMaxLimCred,2,".",""),15,"0",STR_PAD_LEFT);
            $nMaxLimCred=0;
            // 12 e 13 - MEDIA DIAS ATRASO
            $iTotTit=count($aMedias);
            $nAcuFat  = 0;
            $nAcuCalc = 0;
            $iAcuDias = 0;
            fpc_append($sEcoTxt,"count $aMedias = ".count($aMedias));
            foreach ($aMedias as $aLinMedias) {
               $nValor = $aLinMedias[0];
               $iDias  = $aLinMedias[1];
               $nCalc  = $nValor*$iDias;
               $nAcuFat  += $nValor;   // x
               $iAcuDias += $iDias;    // y
               $nAcuCalc += $nCalc;    // z
            }
            if ($iTotTit>0) {
               $nMedPondAtrasos = number_format($nAcuCalc/$nAcuFat,0,'.','');   // Media Ponderada  de Atrados = Z/X 
               $nMedAritAtrasos = number_format($iAcuDias/$iTotTit,0,'.','');   // Media Aritmetica de Atrados = Y/iTotTit 
            } else {
               $nMedPondAtrasos = 0;   // Media Ponderada  de Atrados = Z/X 
               $nMedAritAtrasos = 0;   // Media Aritmetica de Atrados = Y/iTotTit 
            }
            $aMedias = array();   // reseto array
            $PCQPAG  = str_pad(number_format($nMedPondAtrasos*100,0,".",""),6,"0",STR_PAD_LEFT);
            $PCQDAP  = str_pad(number_format($nMedAritAtrasos*100,0,".",""),6,"0",STR_PAD_LEFT);

            fpc_append($sEcoTxt,"nAcuCalc : $nAcuCalc");
            fpc_append($sEcoTxt,"nAcuFat : $nAcuFat");
            fpc_append($sEcoTxt,"iAcuDias: $iAcuDias");
            fpc_append($sEcoTxt,"iTotTit : $iTotTit");
            fpc_append($sEcoTxt,"nMedPondAtrasos : $nMedPondAtrasos");
            fpc_append($sEcoTxt,"nMedAritAtrasos : $nMedAritAtrasos");
            fpc_append($sEcoTxt,"PCQPAG : $PCQPAG");
            fpc_append($sEcoTxt,"PCQDAP : $PCQDAP");

            // Fim Medias

            // 14 - VALOR DEBITO ATUAL A VENCER
            $PCVDAV = str_pad(100*number_format($nVAAV,2,".",""),15,"0",STR_PAD_LEFT);
            $nVAAV = 0;

            // 15/16 - MEDIA PONDERADA TITULOS A VENCER E PRAZO MEDIA DE VENDAS
            $iTotTit=count($aMedias2);
            $nAcuFat  = 0;
            $nAcuCalc = 0;
            $iAcuDias = 0;
            fpc_append($sEcoTxt,"count $aMedias2 = ".count($aMedias2));
            foreach ($aMedias2 as $aLinMedias) {
               $nValor = $aLinMedias[0];
               $iDias  = $aLinMedias[1];
               $nCalc  = $nValor*$iDias;
               $nAcuFat  += $nValor;   // x
               $iAcuDias += $iDias;    // y
               $nAcuCalc += $nCalc;    // z
               fpc_append($sEcoTxt,"MEDIA PONDERADA TITULOS A VENCER E PRAZO MEDIA DE VENDAS c) nValor=$nValor, iDias=$iDias, nCalc=$nCalc, nAcuFat=$nAcuFat, iAcuDias=$iAcuDias, nAcuCalc=$nAcuCalc");
            }
            if ($iTotTit>0) {
               $nMedPondaVencer = number_format($nAcuCalc/$nAcuFat,0,'.','');   // Media Ponderada  de A Vencer = Z/X 
               $nMedAritaVencer = number_format($iAcuDias/$iTotTit,0,'.','');   // Media Aritmetica de A Vencer = Y/iTotTit 
               fpc_append($sEcoTxt,"MEDIA PONDERADA TITULOS A VENCER E PRAZO MEDIA DE VENDAS d) nAcuCalc=$nAcuCalc, nAcuFat=$nAcuFat, nMedPondaVencer=$nMedPondaVencer");
               fpc_append($sEcoTxt,"MEDIA PONDERADA TITULOS A VENCER E PRAZO MEDIA DE VENDAS e) iAcuDias=$iAcuDias, niTotTit=$iTotTit, nMedAritaVencer=$nMedAritaVencer");
            } else {
               $nMedPondaVencer = 0;
               $nMedAritaVencer = 0;
               fpc_append($sEcoTxt,"MEDIA PONDERADA TITULOS A VENCER E PRAZO MEDIA DE VENDAS f)  nMedPondaVencer=$nMedPondaVencer, nMedAritaVencer=$nMedAritaVencer");
            }
            $aMedias2 = array();   // reseto array
            $PCMDAV = str_pad(number_format($nMedPondaVencer*100,0,".",""),6,"0",STR_PAD_LEFT);
            $PCMPMV = str_pad(number_format($nMedAritaVencer*100,0,".",""),6,"0",STR_PAD_LEFT);

            // 17 - VALOR DEBITO ATUAL VENCIDO a 5 DIAS
            $PCDATV = str_pad(100*number_format($nVDAT5,2,".",""),15,"0",STR_PAD_LEFT);
            fpc_append($sEcoTxt,"17b)-sCNPJSac=$sCNPJSac, nVDAT5=$nVDAT5, PCDATV=$PCDATV");
            $nVDAT5 = 0;   //  (*)
 
            // 18 - MEDIA PONDERADA TITULOS VENCIDOS A MAIS DE 5 DIAS
            $iTotTit=count($aMedias5);
            $nAcuFat  = 0;
            $nAcuCalc = 0;
            $iAcuDias = 0;
            fpc_append($sEcoTxt,"a) count aMedias5 = ".count($aMedias5));
            foreach ($aMedias5 as $aLinMedias) {
               $nValor = $aLinMedias[0];
               $iDias  = $aLinMedias[1];
               $nCalc  = $nValor*$iDias;
               $nAcuFat  += $nValor;   // x
               $iAcuDias += $iDias;    // y
               $nAcuCalc += $nCalc;    // z
               fpc_append($sEcoTxt,"b) aMedias5 - iTotTit=$iTotTit, nAcuFat=$nAcuFat, nAcuCalc=$nAcuCalc, iAcuDias=$iAcuDias, nValor=$nValor, iDias=$iDias, nCalc=$nCalc");
            }
            fpc_append($sEcoTxt,"c) aMedias5 - iTotTit=$iTotTit, nAcuFat=$nAcuFat, nAcuCalc=$nAcuCalc, iAcuDias=$iAcuDias");
            if ($iTotTit>0) {
               $nMedPondVencid5 = number_format($nAcuCalc/$nAcuFat,0,'.','');   // Media Ponderada  de A Vencer = Z/X 
            } else {
               $nMedPondVencid5 = 0;
            }
            fpc_append($sEcoTxt,"d) aMedias5 - nMedPondVencid5=$nMedPondVencid5");
            $aMedias5 = array();   // reseto array
            $PCMPTV = str_pad(number_format($nMedPondVencid5,0,".",""),4,"0",STR_PAD_LEFT);

            // 19 - VALOR DEBITO ATUAL VENCIDO a 15 DIAS
            $PCV_15D = str_pad(100*number_format($nVDAT15,2,".",""),15,"0",STR_PAD_LEFT);
            $nVDAT15 = 0;   //  (*) 

            // 20 - MEDIA PONDERADA TITULOS VENCIDOS A MAIS DE 15 DIAS
            $iTotTit=count($aMedias15);
            $nAcuFat  = 0;
            $nAcuCalc = 0;
            $iAcuDias = 0;
            fpc_append($sEcoTxt,"count aMedias15 = ".count($aMedias15));
            foreach ($aMedias15 as $aLinMedias) {
               $nValor = $aLinMedias[0];
               $iDias  = $aLinMedias[1];
               $nCalc  = $nValor*$iDias;
               $nAcuFat  += $nValor;   // x
               $iAcuDias += $iDias;    // y
               $nAcuCalc += $nCalc;    // z
            }
            if ($iTotTit>0) {
               $nMedPondVencid15 = number_format($nAcuCalc/$nAcuFat,0,'.','');   // Media Ponderada  de A Vencer = Z/X 
            } else {
               $nMedPondVencid15 = 0;
            }
            $aMedias15 = array();   // reseto array
            $PCM_15D = str_pad(number_format($nMedPondVencid15,0,".",""),4,"0",STR_PAD_LEFT);


            // 21 - VALOR DEBITO ATUAL VENCIDO a 30 DIAS
            $PCV_30D = str_pad(100*number_format($nVDAT30,2,".",""),15,"0",STR_PAD_LEFT);
            $nVDAT30 = 0; 

            // 22 - MEDIA PONDERADA TITULOS VENCIDOS A MAIS DE 30 DIAS
            $iTotTit=count($aMedias30);
            $nAcuFat  = 0;
            $nAcuCalc = 0;
            $iAcuDias = 0;
            fpc_append($sEcoTxt,"count aMedias30 = ".count($aMedias30));
            foreach ($aMedias30 as $aLinMedias) {
               $nValor = $aLinMedias[0];
               $iDias  = $aLinMedias[1];
               $nCalc  = $nValor*$iDias;
               $nAcuFat  += $nValor;   // x
               $iAcuDias += $iDias;    // y
               $nAcuCalc += $nCalc;    // z
            }
            if ($iTotTit>0) {
               $nMedPondVencid30 = number_format($nAcuCalc/$nAcuFat,0,'.','');   // Media Ponderada  de A Vencer = Z/X 
            } else {
               $nMedPondVencid30 = 0;
            }
            $aMedias30 = array();   // reseto array
            $PCM_30D = str_pad(number_format($nMedPondVencid30,0,".",""),4,"0",STR_PAD_LEFT);

            // 23 Data da Penultima compra e 24 - Valor da Penultima Compra

            if ($dPUC<>'') {
               $PCDTPC = date('Ymd',strtotime($dPUC));
               $PCVPCO = str_pad(100*number_format($nPUC,2,".",""),15,"0",STR_PAD_LEFT);
            } else {
               $PCDTPC = '00000000';
               $PCVPCO = str_pad(100*number_format(0,2,".",""),15,"0",STR_PAD_LEFT);
            }

            if (($dPUC=='') && ($dMaxAcuVal<>$dUC)) fpc_append($sEcoTxt,"erro - dPUC='' e dMaxAcuVal<>dUC - dPUC=$dPUC, dMaxAcuVal=$dMaxAcuVal, dUC=$dUC"); 

            //25 - Situacao do Calculo Limite de Credito
            $PCVSIT = "6";

            //26 - Tipo de Garantia
            $PCTIPG = "0";

            //27 - Grau de Garantia
            $PCGGA = "00";

            //28 - Data da Validade da Garantia
            $PCDTG = "00000000";

            // 29- Valor da Garantia
            $PCVLG = "000000000000000";
            
            // 30 - Valor da Venda Pagamento Antecipado
            $PCVPA = "000000000000000";

            // 31 - Venda sem Credito Antecipado
            $PCSVV = "  ";

            // array layout
            // $aCISP[Registro][ 
            //                {0-ID,1-Campo   ,2-Valor   , 3-Tam , 4-Mascara             , 5-Descricao} 
            //                  ]
            $aCISP[]  = array(" 1" ,'PCTIPO '  ,$PCTIPO   ,"  01" ,"N"                    ,"Identif. {1-CNPJ,2-CPF,3-RG,4-Export.,5-Insc.Prod.,9-Outros}    ");
            $aCISP[]  = array(" 2" ,'PCCASS '  ,$PCCASS   ,"  04" ,"ZZZZ"                 ,"Codigo do Associado                                             ");
            $aCISP[]  = array(" 3" ,'PCCCLI '  ,$PCCCLI   ,"  20" ,"NNNNNNNNNNNNNNNNNNNN" ,"Identificacao. (CNPJ/CPF/RG/Export./Insc.Prod./Outros)          ");
            $aCISP[]  = array(" 4" ,'PCDDAT '  ,$PCDDAT   ,"  08" ,"AAAAMMDD"             ,"Data da Informacao                                              ");
            $aCISP[]  = array(" 5" ,'PCDCDD '  ,$PCDCDD   ,"  08" ,"AAAAMMDD"             ,"Data Cadastramento do Cliente                                   ");
            $aCISP[]  = array(" 6" ,'PCDUCM '  ,$PCDUCM   ,"  08" ,"AAAAMMDD"             ,"Data da ultima Compra                                           ");
            $aCISP[]  = array(" 7" ,'PCVULC '  ,$PCVULC   ,"13,2" ,"ZZZZZZZZZZZZZZZ"      ,"Valor da ultima Compra                                          ");
            $aCISP[]  = array(" 8" ,'PCDMAC '  ,$PCDMAC   ,"  08" ,"AAAAMMDD"             ,"Data do Maior Acumulo                                           ");
            $aCISP[]  = array(" 9" ,'PCVMAC '  ,$PCVMAC   ,"13,2" ,"NNNNNNNNNNNNNNN"      ,"Valor Maior Acumulo                                             ");
            $aCISP[]  = array("10" ,'PCVSAT '  ,$PCVSAT   ,"13,2" ,"ZZZZZZZZZZZZZZZ"      ,"Valor Debito Atual Total                                        ");
            $aCISP[]  = array("11" ,'PCVLCR '  ,$PCVLCR   ,"13,2" ,"NNNNNNNNNNNNNNN"      ,"Valor Limite de Credito                                         ");
            $aCISP[]  = array("12" ,'PCQPAG '  ,$PCQPAG   ,"04,2" ,"ZZZZZZ"               ,"Media Ponderada de Atraso nos Pagamentos (Titulos Pagos)        ");
            $aCISP[]  = array("13" ,'PCQDAP '  ,$PCQDAP   ,"04,2" ,"NNNNNN"               ,"Media Aritmetica Dias de Atraso Pagamento                       ");
            $aCISP[]  = array("14" ,'PCVDAV '  ,$PCVDAV   ,"13,2" ,"ZZZZZZZZZZZZZZZ"      ,"Valor Debito Atual a Vencer                                     ");
            $aCISP[]  = array("15" ,'PCMDAV '  ,$PCMDAV   ,"04,2" ,"NNNNNN"               ,"Media Ponderada de Titulos a Vencer                             ");
            $aCISP[]  = array("16" ,'PCMPMV '  ,$PCMPMV   ,"04,2" ,"ZZZZZZ"               ,"Prazo Medio de Vendas                                           ");
            $aCISP[]  = array("17" ,'PCDATV '  ,$PCDATV   ,"13,2" ,"NNNNNNNNNNNNNNN"      ,"Valor Debito Atual Vencido + 5 Dias                             ");
            $aCISP[]  = array("18" ,'PCMPTV '  ,$PCMPTV   ,"  04" ,"ZZZZ"                 ,"Media Ponderada de Atraso Titulos Vencidos e nao Pagos + 5 Dias ");
            $aCISP[]  = array("19" ,'PCV+15D' ,$PCV_15D   ,"13,2" ,"NNNNNNNNNNNNNNN"      ,"Valor Debito Atual Vencido + 15 Dias                            ");
            $aCISP[]  = array("20" ,'PCM+15D' ,$PCM_15D   ,"  04" ,"ZZZZ"                 ,"Media Ponderada de Atraso Titulos Vencidos e nao Pagos + 15 Dias");
            $aCISP[]  = array("21" ,'PCV+30D' ,$PCV_30D   ,"13,2" ,"NNNNNNNNNNNNNNN"      ,"Valor Debito Atual Vencido + 30 Dias                            ");
            $aCISP[]  = array("22" ,'PCM+30D' ,$PCM_30D   ,"  04" ,"ZZZZ"                 ,"Media Ponderada de Atraso Titulos Vencidos e nao Pagos + 30 Dias");
            $aCISP[]  = array("23" ,'PCDTPC '  ,$PCDTPC   ,"  08" ,"AAAAMMDD"             ,"Data da Penultima Compra                                        ");
            $aCISP[]  = array("24" ,'PCVPCO '  ,$PCVPCO   ,"13,2" ,"NNNNNNNNNNNNNNN"      ,"Valor da Penultima Compra                                       ");
            $aCISP[]  = array("25" ,'PCVSIT '  ,$PCVSIT   ,"  01" ,"Z"                    ,"Situacao do Calculo Limite de Credito                           ");
            $aCISP[]  = array("26" ,'PCTIPG '  ,$PCTIPG   ,"  01" ,"N"                    ,"Tipo de Garantia                                                ");
            $aCISP[]  = array("27" ,'PCGGA  '   ,$PCGGA   ,"  02" ,"ZZ"                   ,"Grau da Garantia Hipoteca                                       ");
            $aCISP[]  = array("28" ,'PCDTG  '   ,$PCDTG   ,"  08" ,"AAAAMMDD"             ,"Data Validade da Garantia                                       ");
            $aCISP[]  = array("29" ,'PCVLG  '   ,$PCVLG   ,"13,2" ,"NNNNNNNNNNNNNNN"      ,"Valor da Garantia                                               ");
            $aCISP[]  = array("30" ,'PCVPA  '   ,$PCVPA   ,"13,2" ,"ZZZZZZZZZZZZZZZ"      ,"Valor da Venda Pagamento Antecipado                             ");
            $aCISP[]  = array("31" ,'PCSVV  '   ,$PCSVV   ,"  02" ,"BB"                   ,"Venda sem Credito (ANTECIPADO)                                  ");
   
         }
   
         ++$iCount;
         //fpc_append($sEcoTxt,"Loop Principal:".$iCount." / ".round($iCount*100/$iCountDb,2)."%");
         //echo round($iCount*100/$iCountDb,2)."%".chr(10);
       } // foreach aFin
   
       fpc_append($sEcoTxt,"iCount: $iCount");
       fpc_append($sEcoTxt,"count aCISP:".(count($aCISP)/31));
       //fpc_append($sEcoTxt,"aCISP[Reg*31Campos][1]:".$aCISP[582*31][1]);
   
       // Loop 4 - Salvando txt
       fpc("CISP.edi","");
       $j=0;
       $s='';
       $z=0;
   
       $k=0;
       $l='';
       $m=0;
       $iCountCISP = count($aCISP);
       $iElay = 0;
       //fpc("CISP.elay","");
       fpc_append($sEcoTxt,"iCountCISP=$iCountCISP");
       for ($j=0; $j<$iCountCISP; $j++) {
          $iPorc = round($j*100/$iCountCISP,0);
          echo "4/4 % - $iPorc, iCountCISP=$iCountCISP, j=$j".chr(10);
          $i=0;
          $z++;

//        $s .= $aCISP[$j][0]." ".$aCISP[$j][1]." ".$aCISP[$j][4]." ".$aCISP[$j][2]." ".$aCISP[$j][5].chr(10);
          $s .= $aCISP[$j][0]." ".$aCISP[$j][5].": ".$aCISP[$j][2].chr(10);
          
          for ($i=0; $i<6; $i++) {
             if ($i==2) {
                $l .= $aCISP[$j][$i];
             }
          }

          if ($z > 30) { 
             $s .= chr(10);
             $z = 0;
             fpc_append("CISP.edi",$s);
             if ($iElay++==0) fpc("CISP.elay",$l);
             else             fpc_append("CISP.elay",$l);
               
             $s = '';
             $l = '';
             $l1 = ''; 
          }
       }
    

   } // $iCountDb>0
}   // lOk
/*
if ($lOk==true) {
  fpc_append($sEcoTxt,'commit');
  flDbCommit($hDb);
} else {
  fpc_append($sEcoTxt,'rollback');
  flDbRollBack($hDb);
}
*/ 


////////////////////////////////////////////////////////////////////////
 
if ($lOk==false) {
   fpc_append($sEcoTxt,"ERRO na execucao do processo...");
}

fpc_append($sEcoTxt,"fim");


flDbDisconnect($hDb);
?>
