<?php
set_time_limit(300);   // 5 min
//error_reporting(E_ALL);

$psCliPasta = 'desenvolvimento';   // 'total'

require_once("../../pFuncoes1.php");
require_once("../../pPublics1.php");	

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoNome  = str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt   = "/qtux/www/FullPlat/processos/logs/$sEcoNome";
$sEcoTxt   = fsDirEcoTxt($sEcoTxt);

$iProcID   = getmypid();
$lProducao = false;
$aUserLog  = array();

fpc($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));
fpc_append($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,"psCliPasta=$psCliPasta");

$sFileConfig = "../../../$psCliPasta/dd_files/Business.ddini";
fpc_append($sEcoTxt,"sFileConfig=$sFileConfig");

if (file_exists($sFileConfig)) {

   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLen = strlen($sLin);
      if ($iLen>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iCountaLin = count($aLin);
         if ($iCountaLin>1) $s2 = trim($aLin[1]);
         else               $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);
         $sVarsTxt .= $s . chr(10);
      }
   }

   $lGo      = true;
   $lOk      = true;
   $lLigaQry = true;
   $psLogin  = 1;
   fpc_append($sEcoTxt,"psLogin=$psLogin");
 
   $sDSN     = "$sHost:$sPathDB/$sDB";
   $sPathFS  = $sPathFileSys;



   // Declarao da varivel $sTab com o nome da tabela
   $sTab = 'CPgmto';
   fpc_append($sEcoTxt,"sTab=$sTab");

   // Configuraes de paginao
   $iLimit  = isset($_GET['limit' ]) ? (int)$_GET['limit' ] : 15;
   $iOffset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
   fpc_append($sEcoTxt,"iLimit=$iLimit, iOffset=$iOffset");
   
   // Verifica se o parmetro 'atualizado_desde' est presente na query string
   if (isset($_GET['atualizado_desde'])) {
       // Obtm o valor do parmetro 'atualizado_desde'
       $sAtualizadoDesde = $_GET['atualizado_desde'];
       fpc_append($sEcoTxt,"sAtualizadoDesde=$sAtualizadoDesde");     
       
       // Valida o formato da data
       if (strtotime($sAtualizadoDesde) !== false) {
           // Conecta ao banco de dados
           $hDb = fhDbConnect($sDSN);
           
           // Consulta para obter o total de registros
           $sSql   = "select count(*) iTotal from $sTab where iVer=iVAt and tInc >= ?";
           fpc_append($sEcoTxt,"sSql=$sSql");
           $hPrep  = ibase_prepare($hDb, $sSql);
           $hRes   = ibase_execute($hPrep, $sAtualizadoDesde);
           $aRes   = ibase_fetch_assoc($hRes);
           $iTotal = $iCount[strtoupper('iTotal')];
           fpc_append($sEcoTxt,"iTotal=$iTotal");         
           
           // Consulta para obter os registros paginados
           $sSql = "select first ? skip ? a.pPId    Codigo            , 
                                          a.sCPgmto Descricao         , 
                                          a.nDMed   PrazoMedio        , 
                                          null      IndiceCondPagto   , 
                                          a.sSintax                   , 
                                          a.lExc    FlagUso 
                    from $sTab a 
                    where a.iVer=a.iVAt 
                      and a.tInc >= ?";
           $hPrep = ibase_prepare($hDb, $sSql);
           fpc_append($sEcoTxt,"sSql=$sSql");
           $hRes = ibase_execute($hPrep, $iLimit, $iOffset, $sAtualizadoDesde);
           
           // Obtm os resultados
           $aTab = [];
           while ($aRow = ibase_fetch_assoc($hRes)) {
               // Calcula QtdeParcela a partir de sSintax
               $aRow['QtdeParcela'] = count(explode(',', $aRow['sSintax']));
               // Remove sSintax do resultado, se no quiser retorn-lo
               unset($aRow['sSintax']);
               // Adiciona o resultado processado ao array
               $aTab[] = $aRow;
           }
        
           // Desconecta do banco de dados
           flDbDisconnect($hDb);
        
           // Calcular URLs de paginao
           $sBaseUrl  = "https://api.xxx.com.br/v1/condpagto/?atualizado_desde=" . urlencode($sAtualizadoDesde);
           $sNext     = ($iOffset + $iLimit < $iTotalCount) ? $sBaseUrl . "&limit=$iLimit&offset=" . ($iOffset + $iLimit) : null;
           $sPrevious = ($iOffset > 0) ? $sBaseUrl . "&limit=$iLimit&offset=" . ($iOffset - $iLimit) : null;
        
           // Retorna os resultados em formato JSON com metadados de paginao
           $aResponse = [
               'meta' => [
                   'limit'       => $iLimit,
                   'next'        => $sNext,
                   'offset'      => $iOffset,
                   'previous'    => $sPrevious,
                   'total_count' => $iTotalCount,
               ],
               'data' => $aTab
           ];
        
           header('Content-Type: application/json');
           echo json_encode($aResponse);
       } else {
           // Data invlida, retorna um erro
           http_response_code(400);
           echo json_encode(['error' => 'Formato de data invlido para o parmetro atualizado_desde.']);
       }
   } else {
       // Parmetro 'atualizado_desde' no foi fornecido
       http_response_code(400);
       echo json_encode(['error' => 'O parmetro atualizado_desde  obrigatrio.']);
   }


} else {
   //echo 'Arquivo de configurao no foi encontrado.';
   echo json_encode(['error' => 'Arquivo de configurao no foi encontrado.']);
}

$sUserLog = implode(chr(10),$aUserLog);
fpc_append($sEcoTxt,"--//--");
fpc_append($sEcoTxt,"Log do usurio");
fpc_append($sEcoTxt,"sUserLog=$sUserLog");
$tJobEnd  = time();
$iJobElap = $tJobEnd-$tJobStart;
fpc_append($sEcoTxt,"--//--");
fpc_append($sEcoTxt,'Encerrado em '.date('d/m/Y H:i:s',$tJobEnd));
fpc_append($sEcoTxt,"Durao do processo em milisegundos = $iJobElap");
//fpc_append($sEcoTxt,"sOrdemMarcadas=$sOrdemMarcadas");
//fpc_append($sEcoTxt,"sUserLog=$sUserLog");

//if (count($aUserLog)==0) $sEcho = 1;
//else                     $sEcho = $sUserLog;
//fpc_append($sEcoTxt,"sEcho=$sEcho");
//echo $sEcho;

$tJobEnd  = time();
$iJobElap = $tJobEnd-$tJobStart;
$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];
$flSysJobs = flSysJobs($sProc,$nTopIni,$nTopFin,$tJobStart,$tJobEnd,$iJobElap,$psCliPasta,$psLogin);

/*
{
    "meta": {
        "limit": 15,
        "next": "https://api.xxx.com.br/v1/condpagto/?atualizado_desde=2023-06-01T08:30:22&limit=15&offset=15",
        "offset": 0,
        "previous": null,
        "total_count": 2
    },
    "data": [
        {
            "Codigo": 123,
            "Descricao": "Pagamento  vista",
            "PrazoMedio": 0,
            "IndiceCondPagto": null,
            "QtdeParcela": 1,
            "FlagUso": true
        },
        {
            "Codigo": 124,
            "Descricao": "Pagamento parcelado",
            "PrazoMedio": 30,
            "IndiceCondPagto": null,
            "QtdeParcela": 3,
            "FlagUso": true
        }
    ]
}

*/

