SET SQL dialect 3;
CONNECT 'localhost:/qtux/database/tq/gps_01.gdb';


drop view TE_TITULO;
create view TE_TITULO as

select a.pSacado                   CodigoCliente       ,
       a.sDoc                      NroDocumento        ,
       a.iPrest                    NroParcela          ,
       0                           CodigoTipoDocumento ,
       cast(a.tEmissao as date)    DataEmissao         ,
       cast(a.tVenc    as date)    DataVencimento      ,
       a.nVenc                     ValorOriginal       ,
       a.nVenc                     SaldoTitulo         ,
       a.iIde_nNF                  NroNotaFiscal       ,
       a.nJur                      TaxaJuros           ,
       0                           ValorPago           ,
       null                        DataPago            ,
       ''                          Complemento         ,
       null                        CodigoVendedorEsp


  from FIN_Titulos a join PED b on a.pSacado=b.pDest and a.pCedente=b.pEmi and b.jTipo=1   -- 0-Compra (Ent), 1-Venda (Sada)
 where a.lExc=0
   and a.iVer=a.iVAt
   and a.jTipo=0   -- 0-Cred, 1-Deb
   and a.pCedente in (3050,10,3158,5,67101)
   and (case when (a.tPgmto is null) then 0 else 1 end ) = 0

;

select CodigoCliente,NroDocumento from TE_TITULO;


