SET SQL dialect 3;
CONNECT 'localhost:/qtux/database/tq/gps_01.gdb';


drop view TE_METAGERAL;
create view TE_METAGERAL as

   select 
          cast(a.tDe as date)||' ate '||cast(a.tAte as date)                         Descricao           ,
          lpad(extract (month from a.tDe),2,'0')||'/'||extract (year from a.tDe)     MesReferencia       ,
          null                                                                       QtdePlanejada       ,
          sum(b.nValor)                                                              ValorPlanejado      ,
          null                                                                       QtdeRealizada       ,
          null                                                                       ValorRealizado      ,
          b.pRep                                                                     CodigoVendedorEsp

   from MET_Periodo a join MET_Valores b on a.pPId = b.pMET_Periodo and b.iVer=b.iVAt and b.lExc=0
   where a.iVer = a.iVAt
     and a.lExc = 0
   group by a.pPId,cast(a.tDe as date)||' ate '||cast(a.tAte as date), lpad(extract (month from a.tDe),2,'0')||'/'||extract (year from a.tDe), b.pRep

;

select first 50 MesReferencia, CodigoVendedorEsp from TE_METAGERAL;


