SET SQL dialect 3;
CONNECT 'localhost:/qtux/database/tq/gps_01.gdb';


drop view TE_HISTPEDIDOITEM;
create view TE_HISTPEDIDOITEM as

select 
       a.pPId                      NumeroPedidoEmp     ,
       b.pItem                     CodigoProduto       ,
       c.sDescricao                DescricaoProduto    ,
       b.nQt                       QtdeVenda           ,
       0                           QtdeBonificada      ,
       b.nCorte                    QtdeCortada         ,
       b.nProd_vDesc               Desconto            ,
       b.nProd_vProd               ValorVenda          ,
       b.jCorte                    MotivoCorte         ,
       null                        TotalPeso           ,
       null                        SaldoQtdeVenda      ,
       null                        Complemento         ,
       null                        FlagGerarVerba

  from Ordens a join Ordens_Itens b on a.pPId  = b.pOrdem and b.iVer=b.iVAt and b.lExc=0
                join Itens        c on b.pItem = c.pPId   and c.iVer=c.iVAt and c.lExc=0

 where a.lExc=0
   and a.iVer=a.iVAt
   and a.jTipo=1
   and cast (a.tEmissao as date) >= '2024-01-01'
   and a.pEmi in (3050,10,3158,5,67101)
   and a.tConf is not null

;

select first 50 NumeroPedidoEmp from TE_HISTPEDIDOITEM;


