SET SQL dialect 3;
CONNECT 'localhost:/qtux/database/tq/gps_01.gdb';


drop view TE_HISTPEDIDO;
create view TE_HISTPEDIDO as

select 
       a.pPId                      NumeroPedidoEmp     ,
       ''                          NumPedidoAFV        ,
       a.pDest                     CodigoCliente       ,
       a.jFase                     StatusPedido        ,
       a.nTot_vNF                  ValorPedido         ,
       null                        ValorFaturado       ,
       cast(a.tEmissao as date)    DataPedido          ,
       cast(a.tEntPla  as date)    DataPrevistaEntrega ,
       null                        DataFaturamento     ,
       a.jOrigem                   OrigemPedido        ,
       ''                          CodigoTipoPedido    ,
       ''                          CodigoFormaPagto    ,
       a.pCPgmto                   CodigoCondPagto     ,
       a.pEmi                      CodigoUnidFat       ,
       ''                          CodigoFrete         ,
       null                        NUMPEDIDOAFVSERVER  ,
       ''                          FlagStatus          ,
       ''                          Complemento         ,
       a.pRepCom                   CodigoVendedorEsp

  from Ordens a

 where a.lExc=0
   and a.iVer=a.iVAt
   and a.jTipo=1
   and cast (a.tEmissao as date) >= '2024-01-01'
   and a.pEmi in (3050,10,3158,5,67101)
   and a.tConf is not null

;

select first 50 NumeroPedidoEmp from TE_HISTPEDIDO;


