SET SQL dialect 3;
CONNECT 'localhost:/qtux/database/tq/gps_01.gdb';


drop view TE_CLIENTE;
create view TE_CLIENTE as

/*
select a.pDest                          Codigo,
       b.sCoringa                       RazaoSocial,
       iif (b.jTipo=1, b.sCPF, b.sCNPJ) CNPJCPF,
       b.sIE                            InscrEstadual
  from PED a join CUP b on a.pDest=b.pPId and b.iVer=b.iVAt
 where a.pEmi in (3050,10,3158,5,67101) 
   and a.iVer=a.iVAt
   and a.lExc=0
   and a.jTipo=1
group by a.pDest,b.sCoringa,iif (b.jTipo=1, b.sCPF, b.sCNPJ),b.sIE
;
*/


select 
       a.pDest                          Codigo,
       b.sCoringa                       RazaoSocial,
       iif (b.jTipo=1, b.sCPF, b.sCNPJ) CNPJCPF,
       b.sIE                            InscrEstadual,
      (select first 1 bb.sLog 
         from Enderecos aa join CEPs    bb on aa.pCEP = bb.pPId and bb.iVer=bb.iVAt
                           join Cidades  cc on bb.pCid = cc.pPId and cc.iVer=cc.iVAt
                           join UFs      dd on cc.pUF  = dd.pPId and dd.iVer=dd.iVAt
         where aa.lExc=0
           and aa.iVer=aa.iVAt
           and aa.pCUP=a.pDest
      ) Endereco,

      (select first 1 aa.sNr
         from Enderecos aa join CEPs    bb on aa.pCEP = bb.pPId and bb.iVer=bb.iVAt
                           join Cidades  cc on bb.pCid = cc.pPId and cc.iVer=cc.iVAt
                           join UFs      dd on cc.pUF  = dd.pPId and dd.iVer=dd.iVAt
         where aa.lExc=0
           and aa.iVer=aa.iVAt
           and aa.pCUP=a.pDest
      ) Numero,

      (select first 1 aa.sComp
         from Enderecos aa join CEPs    bb on aa.pCEP = bb.pPId and bb.iVer=bb.iVAt
                           join Cidades  cc on bb.pCid = cc.pPId and cc.iVer=cc.iVAt
                           join UFs      dd on cc.pUF  = dd.pPId and dd.iVer=dd.iVAt
         where aa.lExc=0
           and aa.iVer=aa.iVAt
           and aa.pCUP=a.pDest
      ) Complemento,

      (select first 1 cc.iIBGE
         from Enderecos aa join CEPs    bb on aa.pCEP = bb.pPId and bb.iVer=bb.iVAt
                           join Cidades  cc on bb.pCid = cc.pPId and cc.iVer=cc.iVAt
                           join UFs      dd on cc.pUF  = dd.pPId and dd.iVer=dd.iVAt
         where aa.lExc=0
           and aa.iVer=aa.iVAt
           and aa.pCUP=a.pDest
      ) CodigoNomeCidade,
       
      (select first 1 dd.sUF
         from Enderecos aa join CEPs    bb on aa.pCEP = bb.pPId and bb.iVer=bb.iVAt
                           join Cidades  cc on bb.pCid = cc.pPId and cc.iVer=cc.iVAt
                           join UFs      dd on cc.pUF  = dd.pPId and dd.iVer=dd.iVAt
         where aa.lExc=0
           and aa.iVer=aa.iVAt
           and aa.pCUP=a.pDest
      ) Estado,

      (select first 1 bb.sBai
         from Enderecos aa join CEPs    bb on aa.pCEP = bb.pPId and bb.iVer=bb.iVAt
                           join Cidades  cc on bb.pCid = cc.pPId and cc.iVer=cc.iVAt
                           join UFs      dd on cc.pUF  = dd.pPId and dd.iVer=dd.iVAt
         where aa.lExc=0
           and aa.iVer=aa.iVAt
           and aa.pCUP=a.pDest
      ) Bairro,

      b.sTel11 Telefone,
      ''       Fax     ,

      (select first 1 bb.sCEP
         from Enderecos aa join CEPs    bb on aa.pCEP = bb.pPId and bb.iVer=bb.iVAt
                           join Cidades  cc on bb.pCid = cc.pPId and cc.iVer=cc.iVAt
                           join UFs      dd on cc.pUF  = dd.pPId and dd.iVer=dd.iVAt
         where aa.lExc=0
           and aa.iVer=aa.iVAt
           and aa.pCUP=a.pDest
      ) Cep,

      b.sFanta     NomeFantasia,
      b.tIn0       DataCadastro,
      b.pRAtiv     CodigoCanalCliente,
      b.pCliRegCom CodigoRegiao
      



  from PED a join CUP b on a.pDest=b.pPId and b.iVer=b.iVAt
 where a.pEmi in (3050,10,3158,5,67101)
   and a.iVer=a.iVAt
   and a.lExc=0
   and a.jTipo=1
group by a.pDest,b.sCoringa,iif (b.jTipo=1, b.sCPF, b.sCNPJ),b.sIE,b.sTel11,b.sFanta,b.tIn0,b.pRAtiv,b.pCliRegCom


;

select first 50 Codigo from TE_CLIENTE;


