SET SQL dialect 3;
CONNECT 'localhost:/qtux/database/tq/gps_01.gdb';


drop view TE_CABTABPRECO;
create view TE_CABTABPRECO as
/*
select a.pPId                     Codigo            ,
       a.sDescricao               Descricao         ,
       a.tDe                      DataInicio        ,
       a.tAte                     DataFim


  from TabPrecos a
 where a.lExc=0
   and a.iVer=a.iVAt
   and a.lPromo = 0
   and cast(a.tDe  as date) <= 'now'
   and cast(a.tAte as date) >= 'now'

;
*/
select a.pPId                     Codigo            ,
       a.sDescricao               Descricao         ,
       a.tDe                      DataInicio        ,
       a.tAte                     DataFim


  from TabPrecos a join TabPrecos_Itens b on a.pPId  = b.pTab and b.iVer=b.iVAt and b.lExc=0
                   join Itens           c on b.pItem = c.pPId and c.iVer=c.iVAt and c.lExc=0 and c.pUNeg in (3050,10,3158,5,67101)
 where a.lExc=0
   and a.iVer=a.iVAt
   and a.lPromo = 0
   and cast(a.tDe  as date) <= 'now'
   and cast(a.tAte as date) >= 'now'

group by a.pPId,a.sDescricao,a.tDe,a.tAte
;


select first 50 Codigo from TE_CABTABPRECO;


