<?php
require_once '/qtux/www/FullPlat/lib/autoload.php'; // Carrega o autoload do Composer

// Configurao do Mercado Pago
MercadoPago\SDK::setAccessToken('TEST-8284266150865072-060608-98f43fd940864b37d13e878fcfcaa059-48846741');

try {
    // Cria uma preferncia de pagamento
    $oPreference = new MercadoPago\Preference();

    // Item do pagamento
    $oItem = new MercadoPago\Item();
    $oItem->title       = 'Produto Teste';
    $oItem->quantity    = 1;
    $oItem->unit_price  = 10.00;
    $oItem->currency_id = 'BRL'; // Moeda: Real brasileiro
    $oItem->id          = 'PAG10';
    //$oItem->picture_url = "https://dev.qtux.com.br/FullPlat/erpImages/login_cadeado.png";

    // Adiciona o item  preferncia
    $oPreference->items = array($oItem);

    $oPreference->external_reference = "PAG10-12345"; // ID do pedido no seu sistema

    $oPayer = new MercadoPago\Payer();
    $oPayer->name    = utf8_encode("Ricardo");
    $oPayer->surname = utf8_encode("Gomes Frana");
    $oPayer->email   = "ricardo@qtux.com.br";
    $oPayer->address     = array(
        "street_name"   => utf8_encode("Rua Pedro Molinari"),
        "street_number" => 65,
        "zip_code"      => "13218674"
    );

    $oPreference->payer = $oPayer;

  // URLs de redirecionamento
//    $oPreference->back_urls = array(
//        "success" => "https://dev.qtux.com.br/FullPlat/processos/WAPP/Sucesso/1",
        // "failure" => "https://seusite.com/erro.php",
        // "pending" => "https://seusite.com/pendente.php"
//    );
//    $oPreference->auto_return = "approved"; // Redireciona automaticamente aps aprovao

    // Salva a preferncia
    $oPreference->save();

    // Obtm o link de pagamento
    //$sPaymentLink = $oPreference->init_point;
    //echo $sPaymentLink.chr(10);
    //echo "Link de Pagamento: <a href='$sPaymentLink'>$sPaymentLink</a>";
    $sSandboxLink = $oPreference->sandbox_init_point; // Use sandbox_init_point
    echo $sSandboxLink.chr(10);

} catch (Exception $e) {
    echo "Erro: " . $e->getMessage();
}

