<?php

// Incio do script
fpc_append($sEcoTxt, "Inicio - ecosmosWAPP_IADialogos.php -> sStatus=$sStatus, sMessageBody=$sMessageBody");
//http_response_code(200);
//echo 'OK'; // Resposta rpida para evitar retentativas
http_response_code(202);
header('Content-Type: application/json'); // .. Sempre defina o Content-Type!
echo json_encode([
    'status'  => 'processing',
    'message' => 'Sua requisio est em processamento',
    'request_id' => uniqid() // Para rastreamento
]);


if (function_exists('fastcgi_finish_request')) { 
    fastcgi_finish_request(); // Libera a conexo (PHP-FPM)
} else {
    ignore_user_abort(true); // Permite continuar o script aps a resposta
    ob_end_flush(); // Envia o buffer de sada
    flush();
}

set_time_limit(10*60);

if ($sFluxo=='') $sFluxo = 'ia dialogos';
$sNovoStatus = '';

// Preciso ler o contexto desse 'telefone'
// Isso est em outro DB
// preciso aqui salvar o telefone $sFrom, as 'perguntas' e 'respostas' em banco de dados para criar uma histria desse usurio
$sDSN2 = 'localhost:/qtux/database/ecosmos/ecosmos_01.gdb';
fpc_append($sEcoTxt,"a-sDSN2=$sDSN2");
$hDb2  = fhDbConnectECosmos($sDSN2);
fpc_append($sEcoTxt,"a-hDb2=$hDb2");
$sSql2 = "select jDialogo,sTxt from WAPP_IA_Dialogos where sTelOrig='$sFrom' and sTelDest='$sTelTQ' and iVer=iVAt and lExc=0 order by pPId";
fpc_append($sEcoTxt,"sSql2=$sSql2");
$aDb2  = faDbSelect($hDb2,$sSql2);
$iDb2  = count($aDb2);
fpc_append($sEcoTxt,"iDb2=$iDb2");
foreach ($aDb2 as $aLin2) {
   $jDialogo = $aLin2[0];
   $sTxt     = $aLin2[1];
   fpc_append($sEcoTxt,"jDialogo=$jDialogo, sTxt-$sTxt");
}


flDbDisconnectECosmos($hDb2);
fpc_append($sEcoTxt,"a-flDbDiconnectECosmos");



// (1) - Sem status - primeira resposta depois de um 'ol' do usurio
if ($sStatus == 'sem status') {   // talvez no seja usado nunca, j entra esperando mensagem

   $sMsg = "Oi amado(a), que gostaria de saber?";
   enviarMensagemWhatsApp($sFrom,$sMsg);

   $sNovoStatus = "esperando mensagem";
   $sContxt = '';
   fpc_append($sEcoTxt,"sMsg=$sMsg, sFrom=$sFrom, sNovoStatus=$sNovoStatus, sFluxo=$sFluxo, sContxt=$sContxt");
   flWAPP_InserirMensagens($sFrom,$sTelTQ,$sFluxo,$sMsg,$sNovoStatus,$sContxt,$sMessageBody);


} else if ($sStatus == 'esperando mensagem') {

   $sMessageBody0 =             $sMessageBody ;   // est com acentos
   $sMessageBody  = utf8_encode($sMessageBody);   // acentos codificados

   $sNovoStatus = "processando dialogo";
   $sContxt = '';
   fpc_append($sEcoTxt,"sMsg=$sMsg, sFrom=$sFrom, sNovoStatus=$sNovoStatus, sFluxo=$sFluxo, sContxt=$sContxt");
   flWAPP_InserirMensagens($sFrom,$sTelTQ,$sFluxo,$sMsg,$sNovoStatus,$sContxt,$sMessageBody);
   flDbCommit($hDb);   // pro prox webhook no disparar em loop


   $sMsg = "Ok amado(a), estou avaliando e j retorno.";
   enviarMensagemWhatsApp($sFrom,$sMsg);


   $sInter = fsResponderAoUsuario('/qtux/www/ecosmos/ecosmosIA_Dialogos.php',$sFrom,$sMessageBody);
   fpc_append($sEcoTxt, "1sInter=$sInter");
   $sInter = utf8_decode($sInter);   // voltou a ter acentos
   fpc_append($sEcoTxt, "2sInter=$sInter");
   $iInterLen = strlen($sInter);
   fpc_append($sEcoTxt, "iInterLen=$iInterLen");
   if ($iInterLen>4000) {
      $sInter = substr($sInter,0,4000);
      fpc_append($sEcoTxt, "truncou a interpretao");
   }
   $iInterLen = strlen($sInter);
   fpc_append($sEcoTxt, "iInterLen=$iInterLen");
   enviarMensagemWhatsApp($sFrom,$sInter);

   fpc_append($sEcoTxt,"sMessageBody0=$sMessageBody0");
   $sEmb0 = fsGetEmbedding($sMessageBody0);
   $sEmb1 = fsGetEmbedding($sInter       );

   fpc_append($sEcoTxt,"sEmb0=$sEmb0");
   fpc_append($sEcoTxt,"sEmb1=$sEmb1");

   // Isso est em outro DB
   // preciso aqui salvar o telefone $sFrom, as 'perguntas' e 'respostas' em banco de dados para criar uma histria desse usurio
   $sDSN2 = 'localhost:/qtux/database/ecosmos/ecosmos_01.gdb';
   fpc_append($sEcoTxt,"sDSN2=$sDSN2");
   $hDb2 = fhDBConnectECosmos($sDSN2);
   fpc_append($sEcoTxt,"hDb2=$hDb2");

   $sSql2 = "insert into WAPP_IA_Dialogos (pInc,sTelOri,sTelDest,jDialogo,sTxt,sEmbedding) values ($psLogin,'$sFrom','$sTelTQ',0,'$sMessageBody0','$sEmb0')";
   fpc_append($sEcoTxt,"sSql2=$sSql2");
   $lOk2  = flDbUpdate($hDb2,$sSql2);
   fpc_append($sEcoTxt,"lOk2=$lOk2");

   $sSql2 = "insert into WAPP_IA_Dialogos (pInc,sTelOri,sTelDest,jDialogo,sTxt,sEmbedding) values ($psLogin,'$sFrom','$sTelTQ',1,'$sInter','$sEmb1')";
   fpc_append($sEcoTxt,"sSql2=$sSql2");
   $lOk2  = flDbUpdate($hDb2,$sSql2);
   fpc_append($sEcoTxt,"lOk2=$lOk2");

   if ($lOk2==true) {
      fpc_append($sEcoTxt,"commit hDb2");
      flDbCommit($hDb2);
   } else {
      fpc_append($sEcoTxt,"rollback hDb2");
      flDbRollback($hDb2);
   }
   flDbDisconnectECosmos($hDb2);
   fpc_append($sEcoTxt,"flDbDiconnectECosmos");
   //

   $sMsg = "Espero que tenha ajudado.\nVou encerrar essa conversa, mas pode me chamar quando quiser,  s dar um 'oi'.";
   enviarMensagemWhatsApp($sFrom,$sMsg);

   flMovPontosDeCredito('Sesso com IA',5,1);

 //$sNovoStatus = "esperando mensagem";
   $sNovoStatus = "sem status";
   $sContxt = '';
   fpc_append($sEcoTxt,"sMsg=$sMsg, sFrom=$sFrom, sNovoStatus=$sNovoStatus, sFluxo=$sFluxo, sContxt=$sContxt");
   flWAPP_InserirMensagens($sFrom,$sTelTQ,$sFluxo,$sMsg,$sNovoStatus,$sContxt,$sMessageBody);
   
   $sFluxo  = '';
   $sStatus = "sem status";


}   // else if estado de espera

fpc_append($sEcoTxt,"lOk=$lOk");
if ($lOk==true) {
   if ($sNovoStatus=="sem status") {
      $sSql = "delete from WAPP_Mensagens where sTelOrig = '$sFrom' and sTelDest = '$sTelTQ'";
      fpc_append($sEcoTxt,"sSql=$sSql");
      $lOk = flDbDelete($hDb,$sSql);
      fpc_append($sEcoTxt,"lOk=$lOk");
   }
}

// Fim do script
fpc_append($sEcoTxt, "Final - ecosmosWAPP_IADialogos.php");

/*
$sEmbeddingJson = fsGetEmbedding("Texto para embedar");
if (!empty($sEmbeddingJson)) {
    $aEmbedding = json_decode($sEmbeddingJson, true);
    // ... processar
}
*/

function fsResponderAoUsuario($psScriptDestino,$psTelOri,$psMessageBody) {
//////////////////////////////////////////////////////////////////////////
    global $sEcoTxt;
    fpc_append($sEcoTxt, "fsResponderAoUsuario incio. Script: $psScriptDestino, psTelOri=$psTelOri, psMessageBody=$psMessageBody");

    // Monta o comando para execuo via shell
    $sComando = "php $psScriptDestino $psTelOri '$psMessageBody'";
    fpc_append($sEcoTxt, "Comando executado: $sComando");

    // Executa o script e obtm a resposta
    $sResposta = shell_exec($sComando);
    fpc_append($sEcoTxt, "Resposta recebida: $sResposta");

    // Tenta decodificar a resposta JSON
    $aResposta = json_decode($sResposta, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        fpc_append($sEcoTxt, "4) Erro ao decodificar JSON: " . json_last_error_msg());
        return null;
    }

    $sInter    = $aResposta['resposta'];
    fpc_append($sEcoTxt, "sInter=$sInter");
    fpc_append($sEcoTxt, "fsResponderAoUsuario fim");
    return $sInter; // Ex: ['texto_interpretado' => '...', ...]
}



/**
 * Obtm embedding vetorial para um texto usando API OpenAI
 * @param string $psTexto Texto para gerar embedding
 * @return string JSON com o vetor de embedding ou string vazia em caso de erro
 */
function fsGetEmbedding($psTexto) {
///////////////////////////////////
    global $sApiKeyOpenAI;
    global $sEcoTxt;;

    fpc_append($sEcoTxt,"fsGetEmbedding inicio");
  //fpc_append($sEcoTxt,"fsGetEmbedding inicio - psTexto=$psTexto");

    // Handles e configuraes
    $hCurl = null;
    $sApiKey = $sApiKeyOpenAI; // s-prefix para string config
    $sUrl = 'https://api.openai.com/v1/embeddings'; // s-prefix para string URL
    
    // Dados da requisio (o-prefix para objeto/array)
    $sTexto = utf8_encode($psTexto);   // acentos codificados
    $oData  = [
        'input' => $sTexto,
        'model' => 'text-embedding-ada-002'
    ];
    
    try {
        // Inicializa cURL (h-prefix para handle)
        $hCurl = curl_init($sUrl);
        
        // Configuraes do cURL
        curl_setopt_array($hCurl, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode($oData),
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $sApiKey
            ],
            CURLOPT_TIMEOUT => 30
        ]);
        
        // Executa requisio (s-prefix para string response)
        $sResponse = curl_exec($hCurl);
        fpc_append($sEcoTxt,"sResponse=$sResponse");
        $iHttpCode = curl_getinfo($hCurl, CURLINFO_HTTP_CODE); // i-prefix para integer
        
        // Valida resposta
        if ($sResponse === false || $iHttpCode !== 200) {
            fpc_append($sEcoTxt,"API Error: " . curl_error($hCurl));
            throw new Exception("API Error: " . curl_error($hCurl));
        }
        
        // Decodifica resposta (o-prefix para objeto/array)
        $oResponse = json_decode($sResponse, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            fpc_append($sEcoTxt,"JSON decode error");
            throw new Exception("JSON decode error");
        }
        
        // Extrai embedding (a-prefix para array)
        $aEmbedding = $oResponse['data'][0]['embedding'] ?? [];
        if (empty($aEmbedding)) {
            fpc_append($sEcoTxt,"Embedding vazio");
            throw new Exception("Embedding vazio");
        }
        
        // Retorna JSON (s-prefix para string de retorno)
        $sEmbedding = json_encode($aEmbedding);
        fpc_append($sEcoTxt,"sEmbedding=$sEmbedding");
        return $sEmbedding;
        
    } catch (Exception $xErr) { // x-prefix para exceo
        error_log("fsGetEmbedding error: " . $xErr->getMessage());
        fpc_append($sEcoTxt,"fsGetEmbedding error: " . $xErr->getMessage());
        return '';
    } finally {
        if ($hCurl !== null) {
            fpc_append($sEcoTxt,"curl_close");
            curl_close($hCurl);
        }
    }
    fpc_append($sEcoTxt,"fsGetEmbedding fim");
}

/**
 * Obtm mensagens relevantes para o contexto baseado na similaridade do embedding
 * @param string $psNovaPergunta - Texto da nova pergunta (VARCHAR)
 * @param resource $phDb - Handle da conexo Firebird
 * @param int $piLimit - Limite de resultados (default 5)
 * @return array - Mensagens relevantes no formato [ ['role'=>..., 'content'=>...] ]
 */
function faGetContextoRelevante($psNovaPergunta, $phDb, $piLimit = 5) {
///////////////////////////////////////////////////////////////////////
    // Variveis com prefixos conforme regras
    $sEmbeddingJson = '';
    $aEmbeddingPergunta = [];
    $aMensagensRelevantes = [];
    $hStmt = null;
    $iSimilaridadeMinima = 70; // j-prefix (enumerador/percentual)
    
    try {
        // 1. Gera embedding da nova pergunta
        $sEmbeddingJson = fsGetEmbedding($psNovaPergunta);
        if (empty($sEmbeddingJson)) {
            throw new Exception("Falha ao gerar embedding");
        }
        $aEmbeddingPergunta = json_decode($sEmbeddingJson, true);
        
        // 2. Busca mensagens histricas no Firebird
        $hStmt = ibase_prepare($phDb, 
            "SELECT FIRST ? sRole, sContent, sEmbedding 
             FROM mensagens 
             ORDER BY tRegistro DESC", 
            $piLimit
        );
        $rResult = ibase_execute($hStmt);
        
        // 3. Compara similaridade para cada mensagem
        while ($aRow = ibase_fetch_assoc($rResult)) {
            $aEmbeddingMensagem = json_decode($aRow['SEMBEDDING'], true);
            $nSimilaridade = fnSimilaridadeCosseno($aEmbeddingPergunta, $aEmbeddingMensagem);
            
            if ($nSimilaridade * 100 >= $iSimilaridadeMinima) {
                $aMensagensRelevantes[] = [
                    'sRole'    => $aRow['SROLE'],
                    'sContent' => $aRow['SCONTENT']
                ];
            }
        }
        
        return $aMensagensRelevantes;
        
    } catch (Exception $xErro) {
        error_log("faGetContextoRelevante: " . $xErro->getMessage());
        return [];
    } finally {
        if ($hStmt) ibase_free_result($hStmt);
    }
}

/**
 * Calcula similaridade de cosseno entre dois vetores
 * @param array $paVecA - Vetor de floats
 * @param array $paVecB - Vetor de floats
 * @return float - Similaridade (0 a 1)
 */
function fnSimilaridadeCosseno($paVecA, $paVecB) {
//////////////////////////////////////////////////
    $nDotProduct = 0;
    $nNormA = 0;
    $nNormB = 0;
    $iCount = count($paVecA);
    for ($i = 0; $i < $iCount; $i++) {
        $nDotProduct += $paVecA[$i] * $paVecB[$i];
        $nNormA += $paVecA[$i] * $paVecA[$i];
        $nNormB += $paVecB[$i] * $paVecB[$i];
    }
    
    return ($nNormA && $nNormB) ? $nDotProduct / (sqrt($nNormA) * sqrt($nNormB)) : 0;
}