<?php

// Incio do script

//http_response_code(200);
//echo 'OK'; // Resposta rpida para evitar retentativas
http_response_code(202);
header('Content-Type: application/json'); // .. Sempre defina o Content-Type!
echo json_encode([
    'status'  => 'processing',
    'message' => 'Sua requisio est em processamento',
    'request_id' => uniqid() // Para rastreamento
]);


if (function_exists('fastcgi_finish_request')) { 
    fastcgi_finish_request(); // Libera a conexo (PHP-FPM)
} else {
    ignore_user_abort(true); // Permite continuar o script aps a resposta
    ob_end_flush(); // Envia o buffer de sada
    flush();
}

set_time_limit(10*60);

fpc_append($sEcoTxt, "Inicio - ecosmosWAPPDadosMapaPDF.php -> sStatus=$sStatus, sMessageBody=$sMessageBody");
if ($sFluxo=='') $sFluxo = 'pdf gestacional';
$sNovoStatus = '';



// (1) - Sem status - primeira resposta depois de um 'ol' do usurio
if ($sStatus == 'sem status') {

     $sMsg = fsSaudacaoPeriodo().", para dar sequencia preciso.\n*Nome da pessoa*\n*Data*\n*Hora*\n*Local de nascimento*.\nAteno, se vc no nasceu de 9 meses  importante informar a provvel data de nascimento.";
   //enviarMensagemWhatsApp($sFrom,$sMsg);

   $aFlow = [
      'messaging_product' => 'whatsapp',
      'to' => $sFrom,
      'type' => 'interactive',
      'interactive' => [
         'type' => 'button',
         'header' => [
            'type' => 'text',
            'text' => 'Oi'
         ],

         'body' => [
            'text' => $sMsg
         ],

         'footer' => [
            'text' => 'Est pronto?'
         ],

         'action' => [
            'buttons' => [
               [
                  'type' => 'reply',
                  'reply' => [
                     'id' => 'sim',
                     'title' => 'Sim'
                  ]
               ],
               [
                  'type' => 'reply',
                  'reply' => [
                     'id' => 'nao',
                     'title' => 'No'
                  ]
               ]
            ]
         ]
      ]
   ];
   enviarFlowInterativo($sFrom,$aFlow);

 //$sNovoStatus = "esperando nome data hora e cidade do nascimento";
   $sNovoStatus = "esperando confirmao se esta pronto";
   $sContxt = '';
   fpc_append($sEcoTxt,"sMsg=$sMsg, sFrom=$sFrom, sNovoStatus=$sNovoStatus, sFluxo=$sFluxo, sContxt=$sContxt");
   flWAPP_InserirMensagens($sFrom,$sTelTQ,$sFluxo,$sMsg,$sNovoStatus,$sContxt,$sMessageBody);


} else if ($sStatus == 'esperando confirmao se esta pronto') {

   $aInteractive = $aMessages['interactive'];
   $sId    = $aInteractive['button_reply']['id'];
   $sTitle = $aInteractive['button_reply']['title'];
   fpc_append($sEcoTxt,"sId=$sId, sTitle=$sTitle");

   $sMessageBody = $sId=='sim'?'s':'n';

   if ((strtolower($sMessageBody)=='sim')||(strtolower($sMessageBody)=='s')) {

      $sMsg = "timo.\nPode digitar esses dados da forma como preferir, em uma nica mensagem.";
      enviarMensagemWhatsApp($sFrom, $sMsg);

      $sNovoStatus = "esperando nome data hora e cidade do nascimento";
      $sContxt = '';
      fpc_append($sEcoTxt,"sMsg=$sMsg, sFrom=$sFrom, sNovoStatus=$sNovoStatus, sFluxo=$sFluxo, sContxt=$sContxt");
      flWAPP_InserirMensagens($sFrom,$sTelTQ,$sFluxo,$sMsg,$sNovoStatus,$sContxt,$sMessageBody);

   } else {

      $sMsg = "Oi, entendi.\nVou encerrar a conversa.\nPode me chamar quando tiver com esses dados.";
      enviarMensagemWhatsApp($sFrom, $sMsg);

      $sNovoStatus = "sem status";
      $sContxt = '';
      fpc_append($sEcoTxt,"sMsg=$sMsg, sFrom=$sFrom, sNovoStatus=$sNovoStatus, sFluxo=$sFluxo, sContxt=$sContxt");
      flWAPP_InserirMensagens($sFrom,$sTelTQ,$sFluxo,$sMsg,$sNovoStatus,$sContxt,$sMessageBody);
   }

} else if ($sStatus == 'esperando nome data hora e cidade do nascimento') {

   if (isset($aMessages["audio"]["id"])==true) {

      $sMsg = 'Oi, recebi seu udio.';
      enviarMensagemWhatsApp($sFrom, $sMsg);

      $sIdAudio = $aMessages["audio"]["id"];
      fpc_append($sEcoTxt, "sIdAudio=$sIdAudio");

      // URL para obter JSON do udio
      $sUrlJsonAudio = "https://graph.facebook.com/v22.0/{$sIdAudio}?access_token=$sTokenWAPP";
      fpc_append($sEcoTxt, "sUrlJsonAudio=$sUrlJsonAudio");

      // Baixa o udio do WhatsApp
      $sArquivoOgg = fsBaixarAudioWhatsApp($sUrlJsonAudio, $sTokenWAPP);

      if ($sArquivoOgg) {

         //$sMsg = 'Estou processando, aguarde um momento pfv.';
         //enviarMensagemWhatsApp($sFrom, $sMsg);

         // Converte para MP3
         $sArquivoMp3 = fsConverterParaMP3($sArquivoOgg);

         if ($sArquivoMp3) {
            // Transcreve o udio usando OpenAI
            fpc_append($sEcoTxt, "1 time=".time());
            $sTextoTranscrito = fsTranscreverAudio($sArquivoMp3);
            fpc_append($sEcoTxt, "2 time=".time());
            fpc_append($sEcoTxt, "sTextoTranscrito=$sTextoTranscrito");
         }
      }
      unlink($sArquivoMp3);
      unlink($sArquivoOgg);
   
      $sTudo = $sTextoTranscrito;
   } else {
      $sTudo = $sMessageBody;
   }

   $sMsg  = "Perfeito, aguarde alguns minutos estou analisando os dados.";
   enviarMensagemWhatsApp($sFrom,$sMsg);



   $sNovoStatus = "processando mapa";
   $sContxt = '';
   fpc_append($sEcoTxt,"sMsg=$sMsg, sFrom=$sFrom, sNovoStatus=$sNovoStatus, sFluxo=$sFluxo, sContxt=$sContxt");
   flWAPP_InserirMensagens($sFrom,$sTelTQ,$sFluxo,$sMsg,$sNovoStatus,$sContxt,$sMessageBody);
   flDbCommit($hDb);   // pro prox webhook no disparar em loop




   $aNDHLLF  = faExtrairDados($sTudo);
   $lSucesso = $aNDHLLF[0]['lSucesso'];
   $sMotivo  = $aNDHLLF[0]['sMotivo' ];
   fpc_append($sEcoTxt,"lSucesso=$lSucesso");
   fpc_append($sEcoTxt,"sMotivo=$sMotivo");

   if ($lSucesso==false) {

      $sMsg  = "Hum... no consegui extrair da sua mensagem os dados que preciso para dar prosseguimento.\nVou encerrar a ligao, pode me chamar quando quiser.";
      enviarMensagemWhatsApp($sFrom,$sMsg);


      $sNovoStatus = "sem status";
      $sContxt = '';
      fpc_append($sEcoTxt,"sMsg=$sMsg, sFrom=$sFrom, sNovoStatus=$sNovoStatus, sFluxo=$sFluxo, sContxt=$sContxt");
      flWAPP_InserirMensagens($sFrom,$sTelTQ,$sFluxo,$sMsg,$sNovoStatus,$sContxt,$sMessageBody);


   } else {

      $sNome    = utf8_decode($aNDHLLF[0]['sNome'   ]);
      $sDHNas   =             $aNDHLLF[0]['sDHNas'  ];
      $sDPNas   =             $aNDHLLF[0]['sDPNas'  ];
      $nLat     =             $aNDHLLF[0]['nLat'    ];
      $nLong    =             $aNDHLLF[0]['nLong'   ];
      $nFuso    =             $aNDHLLF[0]['nFuso'   ];
      $sCidade  = utf8_decode($aNDHLLF[0]['sCidade' ]);
      fpc_append($sEcoTxt,"sNome=$sNome, sDHNas=$sDHNas, sDPNas=$sDPNas, nLat=$nLat, nLong=$nLong, nFuso=$nFuso, sCidade=$sCidade, lSucesso=$lSucesso");


      $sD = explode(' ',$sDHNas)[0];
      $sH = explode(' ',$sDHNas)[1];

      $sDiaN = trim(explode('/',$sD)[0]);
      $sMesN = trim(explode('/',$sD)[1]);
      $sAnoN = trim(explode('/',$sD)[2]);
                                    
      $sHorN = trim(explode(':',$sH)[0]);
      $sMinN = trim(explode(':',$sH)[1]);

      fpc_append($sEcoTxt,"sD=$sD, sH=$sH, sDiaN=$sDiaN, sMesN=$sMesN, sAnoN=$sAnoN, sHorN=$sHorN, sMinN=$sMinN");

      //
      $sDiaPN = '';
      $sMesPN = '';
      $sAnoPN = '';
      if (strlen(trim($sDPNas))==10) {   // dd/mm/aaaa
         $sDiaPN = trim(explode('/',$sDPNas)[0]);
         $sMesPN = trim(explode('/',$sDPNas)[1]);
         $sAnoPN = trim(explode('/',$sDPNas)[2]);
         fpc_append($sEcoTxt,"sDiaPN=$sDiaPN, sMesPN=$sMesPN, sAnoPN=$sAnoPN");
      }

      $aContxt = array();
      $aContxt[] = $sNome;
      $aContxt[] = $sDHNas;
      $aContxt[] = $sDPNas;
      $aContxt[] = $nLat;
      $aContxt[] = $nLong;
      $aContxt[] = $nFuso;
      $aContxt[] = $sCidade;
      $aContxt[] = $sDiaN;
      $aContxt[] = $sMesN;
      $aContxt[] = $sAnoN;
      $aContxt[] = $sHorN;
      $aContxt[] = $sMinN;
      $aContxt[] = $sDiaPN;
      $aContxt[] = $sMesPN;
      $aContxt[] = $sAnoPN;
      
      $aResPed = array();
      $aResPed[] = $sNome;
      $aResPed[] = $sDHNas;
      if (strlen(trim($sDPNas))==10) {   // dd/mm/aaaa
         $aResPed[] = 'Provvel nascimento: '.$sDPNas;
      }
    //$aResPed[] = $nLat;
    //$aResPed[] = $nLong;
    //$aResPed[] = $nFuso;
      $aResPed[] = $sCidade;

      $sMsg = implode(chr(10),$aResPed);
      //enviarMensagemWhatsApp($sFrom,$sMsg);


      $aFlow = [
         'messaging_product' => 'whatsapp',
         'to' => $sFrom,
         'type' => 'interactive',
         'interactive' => [
            'type' => 'button',
            'header' => [
               'type' => 'text',
               'text' => 'Oi'
            ],

            'body' => [
               'text' => $sMsg
            ],

            'footer' => [
               'text' => 'Confirma esses dados?'
            ],

            'action' => [
               'buttons' => [
                  [
                     'type' => 'reply',
                     'reply' => [
                        'id' => 'sim',
                        'title' => 'Sim'
                     ]
                  ],
                  [
                     'type' => 'reply',
                     'reply' => [
                        'id' => 'nao',
                        'title' => 'No'
                     ]
                  ]
               ]
            ]
         ]
      ];
      enviarFlowInterativo($sFrom,$aFlow);


      //$sMsg  = "Aguarde mais alguns minutos estou calculando seu mapa.";
      //enviarMensagemWhatsApp($sFrom,$sMsg);


      $sNovoStatus = "esperando confirmao dados para o mapa";
      $sContxt = implode('~',$aContxt);
      fpc_append($sEcoTxt,"sMsg=$sMsg, sFrom=$sFrom, sNovoStatus=$sNovoStatus, sFluxo=$sFluxo, sContxt=$sContxt");
      flWAPP_InserirMensagens($sFrom,$sTelTQ,$sFluxo,$sMsg,$sNovoStatus,$sContxt,$sMessageBody);
   }


} else if ($sStatus == 'esperando confirmao dados para o mapa') {


   $aInteractive = $aMessages['interactive'];
   $sId    = $aInteractive['button_reply']['id'];
   $sTitle = $aInteractive['button_reply']['title'];
   fpc_append($sEcoTxt,"sId=$sId, sTitle=$sTitle");

   $sMessageBody = $sId=='sim'?'s':'n';

   if ((strtolower($sMessageBody)=='sim')||(strtolower($sMessageBody)=='s')) {

      $aContxt = explode('~',$sContxt);

      $sNome    =  $aContxt[ 0];
      $sDHNas   =  $aContxt[ 1];
      $sDPNas   =  $aContxt[ 2];
      $nLat     =  $aContxt[ 3];
      $nLong    =  $aContxt[ 4];
      $nFuso    =  $aContxt[ 5];
      $sCidade  =  $aContxt[ 6];
      $sDiaN    =  $aContxt[ 7];
      $sMesN    =  $aContxt[ 8];
      $sAnoN    =  $aContxt[ 9];
      $sHorN    =  $aContxt[10];
      $sMinN    =  $aContxt[11];
      $sDiaPN   =  $aContxt[12];
      $sMesPN   =  $aContxt[13];
      $sAnoPN   =  $aContxt[14];

      $pLogin      = $psLogin           ;
      $sCoringa    = $sNome             ;
      $jGemeos     = 0                  ;
      $jAnos       = $sAnoN*1-1800      ;
      $jMeses      = $sMesN*1-1         ;
      $jDias       = $sDiaN*1-1         ;
      $jHoras      = $sHorN*1           ;
      $jMinutos    = $sMinN*1           ;

      if (strlen(trim($sDPNas))==10) {   // dd/mm/aaaa
         $jPAnos      = $sAnoPN*1-1800  ;
         $jPMeses     = $sMesPN*1-1     ;
         $jPDias      = $sDiaPN*1-1     ;
         $lN9Meses    = 1               ;
      } else {
         $jPAnos      = 0               ;
         $jPMeses     = 0               ;
         $jPDias      = 0               ;
         $lN9Meses    = 0               ;
      }

      $lHrVerao    = 0                  ;
      $pCidNas     = 0                  ;
      $nLatNas     = $nLat              ;
      $nLonNas     = $nLong             ;
      $nFusoNas    = $nFuso             ;
      $pCid6oM     = 0                  ;
      $nLat6oM     = $nLat              ;
      $nLon6oM     = $nLong             ;
      $nFuso6oM    = $nFuso             ;
      $pCid3oM     = 0                  ;
      $nLat3oM     = $nLat              ;
      $nLon3oM     = $nLong             ;
      $nFuso3oM    = $nFuso             ;
      $pCid0oM     = 0                  ;
      $nLat0oM     = $nLat              ;
      $nLon0oM     = $nLong             ;
      $nFuso0oM    = $nFuso             ;
      $sCidNas     = $sCidade           ;
      $sCid6oM     = $sCidade           ;
      $sCid3oM     = $sCidade           ;
      $sCid0oM     = $sCidade           ;

      // Chamada url
      $aDados = [
                 'pLogin'   => $pLogin   ,
                 'sCoringa' => utf8_encode($sCoringa) ,
                 'jGemeos'  => $jGemeos  ,
                 'jAnos'    => $jAnos    ,
                 'jMeses'   => $jMeses   ,
                 'jDias'    => $jDias    ,
                 'jHoras'   => $jHoras   ,
                 'jMinutos' => $jMinutos ,
                 'jPAnos'   => $jPAnos   ,
                 'jPMeses'  => $jPMeses  ,
                 'jPDias'   => $jPDias   ,
                 'lN9Meses' => $lN9Meses ,
                 'lHrVerao' => $lHrVerao ,
                 'pCidNas'  => $pCidNas  ,
                 'nLatNas'  => $nLatNas  ,
                 'nLonNas'  => $nLonNas  ,
                 'nFusoNas' => $nFusoNas ,
                 'pCid6oM'  => $pCid6oM  ,
                 'nLat6oM'  => $nLat6oM  ,
                 'nLon6oM'  => $nLon6oM  ,
                 'nFuso6oM' => $nFuso6oM ,
                 'pCid3oM'  => $pCid3oM  ,
                 'nLat3oM'  => $nLat3oM  ,
                 'nLon3oM'  => $nLon3oM  ,
                 'nFuso3oM' => $nFuso3oM ,
                 'pCid0oM'  => $pCid0oM  ,
                 'nLat0oM'  => $nLat0oM  ,
                 'nLon0oM'  => $nLon0oM  ,
                 'nFuso0oM' => $nFuso0oM ,
                 'sCidNas'  => utf8_encode($sCidNas)  ,
                 'sCid6oM'  => utf8_encode($sCid6oM)  ,
                 'sCid3oM'  => utf8_encode($sCid3oM)  ,
                 'sCid0oM'  => utf8_encode($sCid0oM)  
      ];

      // Caminho absoluto ou relativo para o outro script PHP
      $sScript = "/qtux/www/ecosmos/ecosmosRedeMapaNovoSalvar.php";
      fpc_append($sEcoTxt, "sScript=$sScript");
      $sResposta = fsExecutarScriptIsolado($sScript, $aDados);
      fpc_append($sEcoTxt, "Resposta do script isolado: $sResposta");
      $pMapa = $sResposta>0?$sResposta:0;
      fpc_append($sEcoTxt, "pMapa=$pMapa");

      $sMsg  = "Estou gerando o PDF do seu mapa, vai demorar um pouquinho... uns 5 minutinhos!";
      enviarMensagemWhatsApp($sFrom,$sMsg);

      $sNovoStatus = "processando mapa";
      $sContxt = '';
      fpc_append($sEcoTxt,"sMsg=$sMsg, sFrom=$sFrom, sNovoStatus=$sNovoStatus, sFluxo=$sFluxo, sContxt=$sContxt");
      flWAPP_InserirMensagens($sFrom,$sTelTQ,$sFluxo,$sMsg,$sNovoStatus,$sContxt,$sMessageBody);
      flDbCommit($hDb);   // pro prox webhook no disparar em loop


      //---
      // +- 5 minutos
      fpc_append($sEcoTxt, "ini exec - /qtux/www/ecosmos/literatura/introducao/proc_literatura_pt.sh $pMapa - " . date('H:i'));
      $sShell = shell_exec('/qtux/www/ecosmos/literatura/introducao/proc_literatura_pt.sh ' . $pMapa . ' 2>&1'); // Captura stdout + stderr);
      
      fpc_append($sEcoTxt, "fim exec - /qtux/www/ecosmos/literatura/introducao/proc_literatura_pt.sh $pMapa - " . date('H:i').chr(10)."sShell=$sShell");

      $sEco = '/qtux/www/ecosmos/mapas_inter/'.$pMapa.'.pdf';   // 
      if (file_exists($sEco)) {

         $sMsg  = "Pronto, misso cumprida.\nObrigada por esperar, segue a interpretao em PDF do seu mapa.";
         enviarMensagemWhatsApp($sFrom,$sMsg);

         $aFlow = [
             'messaging_product' => 'whatsapp',
             'to' => $sFrom, // Nmero do destinatrio (j definido no seu cdigo)
             'type' => 'document',
             'document' => [
                 'link' => 'https://dev.qtux.com.br/ecosmos/mapas_inter/'.$pMapa.'.pdf', // URL pblica do PDF
                 'caption' => 'Segue o mapa solicitado:', // Legenda opcional
                 'filename' => 'mapa_'.$pMapa.'.pdf' // Nome do arquivo para o usurio (opcional)
             ]
         ];

         // Envia o fluxo interativo
         enviarFlowInterativo($sFrom, $aFlow);

         sleep(3);         
         $sMsg = "Espero que tenha ajudado.\nVou encerrar essa conversa, mas pode me chamar quando quiser,  s dar um 'oi'.";
         enviarMensagemWhatsApp($sFrom,$sMsg);

         flMovPontosDeCredito("Mapa PDF $pMapa",50,1);




      } else {

       //$sMsg = 'Oi, desculpas. Algo deu errado, vamos entrar em contato em breve';
         $sMsg = 'Ops! Desculpas, o mapa no pde ser gerado corretamente. Nossa equipe j foi notificada e em breve entrar em contato.';
         enviarMensagemWhatsApp($sFrom,$sMsg);

      }
      //---

      $sMsg  = "Obrigado.\nEssa conversa ser encerrada.\nQq coisa d um alo.";
      enviarMensagemWhatsApp($sFrom,$sMsg);

      $sNovoStatus = "sem status";
      $sContxt = '';
      fpc_append($sEcoTxt,"sMsg=$sMsg, sFrom=$sFrom, sNovoStatus=$sNovoStatus, sFluxo=$sFluxo, sContxt=$sContxt");
      flWAPP_InserirMensagens($sFrom,$sTelTQ,$sFluxo,$sMsg,$sNovoStatus,$sContxt,$sMessageBody);

/*
      // Isso est em outro DB
      // preciso aqui salvar o telefone $sFrom, as 'perguntas' e 'respostas' em banco de dados para criar uma histria desse usurio
      $sDSN2 = 'localhost:/qtux/database/ecosmos/ecosmos_01.gdb';
      fpc_append($sEcoTxt,"sDSN2=$sDSN2");
      $hDb2 = fhDbConnectECosmos($sDSN2);
      fpc_append($sEcoTxt,"hDb2=$hDb2");
      $sSql2 = "update CUP_Mapas set sTelOrig='$sFrom', sTelDest='$sTelTQ', sFInter='$sEco' where pPId=$pMapa and iVer=iVAt";
      fpc_append($sEcoTxt,"sSql2=$sSql2");
      $lOk2  = flDbUpdate($hDb2,$sSql2);
      fpc_append($sEcoTxt,"lOk2=$lOk2");
      if ($lOk2==true) {
         fpc_append($sEcoTxt,"commit hDb2");
         flDbCommit($hDb2);
      } else {
         fpc_append($sEcoTxt,"rollback hDb2");
         flDbRollback($hDb2);
      }
      flDbDisconnectECosmos($hDb2);
      fpc_append($sEcoTxt,"flDbDiconnectECosmos");
      //
*/

   } else {

      $sMsg  = "Hum... entendi.\nBom = essa conversa ser encerrada.\nQuando tiver com os dados corretos pode me chamar.";
      enviarMensagemWhatsApp($sFrom,$sMsg);


      $sNovoStatus = "sem status";
      $sContxt = '';
      fpc_append($sEcoTxt,"sMsg=$sMsg, sFrom=$sFrom, sNovoStatus=$sNovoStatus, sFluxo=$sFluxo, sContxt=$sContxt");
      flWAPP_InserirMensagens($sFrom,$sTelTQ,$sFluxo,$sMsg,$sNovoStatus,$sContxt,$sMessageBody);

   }


}   // else if estado de espera

fpc_append($sEcoTxt,"lOk=$lOk");
if ($lOk==true) {
   if ($sNovoStatus=="sem status") {
      $sSql = "delete from WAPP_Mensagens where sTelOrig = '$sFrom' and sTelDest = '$sTelTQ'";
      fpc_append($sEcoTxt,"sSql=$sSql");
      $lOk = flDbDelete($hDb,$sSql);
      fpc_append($sEcoTxt,"lOk=$lOk");
   }
}

// Fim do script
fpc_append($sEcoTxt, "Final - ecosmosWAPPDadosMapaPDF.php");

function faDividirStringLatin1($psTexto, $piTamanhoMaximo = 4000) {
///////////////////////////////////////////////////////////////////
    $aPacotes = [];
    $iComprimentoTotal = strlen($psTexto);
    
    while ($iComprimentoTotal > 0) {
        $sPedaco = substr($psTexto, 0, $piTamanhoMaximo);
        
        // Se no for o ltimo pedao e cortou uma palavra
        if ($iComprimentoTotal > $piTamanhoMaximo) {
            $iUltimoEspaco = strrpos($sPedaco, ' ');
            
            if ($iUltimoEspaco !== false) {
                $sPedaco = substr($sPedaco, 0, $iUltimoEspaco);
            }
        }
        
        $aPacotes[] = trim($sPedaco);
        $psTexto = substr($psTexto, strlen($sPedaco));
        $iComprimentoTotal = strlen($psTexto);
    }
    
    return $aPacotes;
}

function faExtrairLatLogFuso($psTexto) {
////////////////////////////////////////
    global $sApiKeyOpenAI, $sEcoTxt;
    global $sUrlDeepSk, $sApiKeyDeepSk;

    fpc_append($sEcoTxt, "Incio faExtrairLatLogFuso");

    // Define o prompt para extrair os dados estruturados
    $sPrompt = "Extraia a cidade do seguinte texto, e sabendo a cidade descubra qual sua latitude, longitude e fuso horrio, e me retorne um JSON com a estrutura [{\"sCidade\": \"nome da cidade\", \"nLat\": \"latitude da cidade\", \"nLong\": \"longitude da cidade\", \"nFuso\": \"fuso horario da cidade numero inteiro positivo ou negativo\"}]. Texto: \"$psTexto\"";
    fpc_append($sEcoTxt, "sPrompt=$sPrompt");
    $sPrompt = utf8_encode($sPrompt);
    fpc_append($sEcoTxt, "sPrompt=$sPrompt");


    $sContent = "Voc  um assistente especializado em extrao de informaes e geolocalizao.";
    fpc_append($sEcoTxt, "sContent=$sContent");
    $sContent = utf8_encode($sContent);
    fpc_append($sEcoTxt, "sContent=$sContent");

    // Monta o payload corretamente formatado
    $aPostData = [
        "model" => "deepseek-chat",   // "gpt-4-turbo",
        "messages" => [
            ["role" => "system", "content" => $sContent],
            ["role" => "user", "content" => $sPrompt]
        ],
        "temperature" => 0.2
    ];

    // Converte os dados corretamente para JSON
    $sPostFields = json_encode($aPostData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    fpc_append($sEcoTxt, "sPostFields=$sPostFields");
    if ($sPostFields === false) {
       fpc_append($sEcoTxt, "Erro ao codificar JSON: " . json_last_error_msg());
    }

    // Configurao da requisio cURL
    $oCurl = curl_init();
    curl_setopt($oCurl, CURLOPT_URL, $sUrlDeepSk);
    curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($oCurl, CURLOPT_POST, true);
    curl_setopt($oCurl, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $sApiKeyDeepSk",
        "Content-Type: application/json; charset=utf-8",
        "Content-Length: " . strlen($sPostFields)
    ]);
    curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sPostFields);
    fpc_append($sEcoTxt, "sUrlDeepSk=$sUrlDeepSk");
    fpc_append($sEcoTxt, "sApiKeyDeepSk=$sApiKeyDeepSk");

    // Executa a requisio
    $sResposta = curl_exec($oCurl);
    curl_close($oCurl);
    fpc_append($sEcoTxt, "Resposta da DeepSeek: $sResposta");
    //$sResposta = utf8_decode($sResposta);
    //fpc_append($sEcoTxt, "sResposta=$sResposta");

    // Decodifica a resposta JSON
    $oResposta = json_decode($sResposta, true);

    if (!isset($oResposta["choices"][0]["message"]["content"])) {
        fpc_append($sEcoTxt, "Erro na resposta da DeepSeek");
        return [];
    }

    $sTextoGerado = $oResposta["choices"][0]["message"]["content"];
    fpc_append($sEcoTxt, "JSON extrado da resposta: $sTextoGerado");
    // Remove delimitadores de cdigo se existirem
    $sTextoGerado = trim($sTextoGerado);
    $sTextoGerado = preg_replace('/^```json/', '', $sTextoGerado); // Remove o incio
    $sTextoGerado = preg_replace('/```$/', '', $sTextoGerado); // Remove o fim

    fpc_append($sEcoTxt, "JSON extrado da resposta: $sTextoGerado");
    //$sTextoGerado = utf8_decode($sTextoGerado);

    // Converte a resposta para array PHP
    $aItensPedido = json_decode($sTextoGerado, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        fpc_append($sEcoTxt, "1) Erro ao decodificar JSON: " . json_last_error_msg());
        return [];
    }

    fpc_append($sEcoTxt, "faExtrairLatLogFuso fim - Itens Extrados: " . json_encode($aItensPedido));

    return $aItensPedido;
}

function faExtrairDados($psTexto) {
////////////////////////////////////////
    global $sApiKeyOpenAI, $sEcoTxt;
    global $sUrlDeepSk, $sApiKeyDeepSk;

    fpc_append($sEcoTxt, "Incio faExtrairDados");

    // Define o prompt para extrair os dados estruturados
    $sPrompt  = "Extraia o nome da pessoa, sua data e hora de nascimento a cidade do seguinte texto, e sabendo a cidade descubra qual sua latitude, longitude e fuso horrio.";
    $sPrompt .= " possivel mas no obrigatrio que alm da data de nascimento exista na mensagem uma segunda data, chamada data provvel de nascimento.";
    $sPrompt .= "A data provvel de nascimento pode vir como uma data, ou a quantidade de meses que a gestao durou, exemplo: 8 meses, indica que a pessoa nasceu de 8 meses, ficou faltando 1 mes para os 9 meses considerados o normal para uma gestao humana.";
    $sPrompt .= "Nesse caso vc vai entender que a data provvel de nascimento seria a data de nascimento, campo obrigatrio, somados 1 ms, porque nasceu 1 mes antes da hora.";
    $sPrompt .= "O mesmo racicnio se aplica quando estiver na mensagem: 7 meses, 6 meses, 10 meses. Para cada um vc vai ver quantos meses o nascimento desviou da data provavel.";
    $sPrompt .= "E calcular a data provvel considerando a data do 9o ms de gestao. Ex: nasceu de 7 meses, significa que a data provvel seria 2 meses pra frente, ou nasceu de 10 meses, ento a data provvel seria 1 ms atrs. Quando nasceu de 9 meses a a data provvel  a data real de nascimento, e a vc deve devolver o campo da data provvel como vazio,conforme est na estrutura o jsno abaixo.";
    $sPrompt .= "Me retorne um JSON com a estrutura [{\"lSucesso\":\"true or false, se conseguiu ou no extrair os dados pedidos no texto recebido\", \"sMotivo\": \"caso lSucesso==false, qual o motivo\", \"sNome\": \"qual o nome da pessoa\", \"sDHNas\": \"data de nascimento e hora, como dia/mes/ano hh:mm ex: 05/07/1997 07:15\", \"sDPNas\": \"data provvel de nascimento, como dia/mes/ano ex: 02/08/1997, default string vazia\", \"sCidade\": \"nome da cidade + nome do estado (se possvel) + nome do pas (se possvel)\", \"nLat\": \"latitude da cidade\", \"nLong\": \"longitude da cidade\", \"nFuso\": \"fuso horario da cidade numero inteiro positivo ou negativo\"}]. Texto: \"$psTexto\"";

    fpc_append($sEcoTxt, "sPrompt=$sPrompt");
    $sPrompt = utf8_encode($sPrompt);
    fpc_append($sEcoTxt, "sPrompt=$sPrompt");

    $sContent = "Voc  um assistente especializado em extrao de informaes e geolocalizao.";
    fpc_append($sEcoTxt, "sContent=$sContent");
    $sContent = utf8_encode($sContent);
    fpc_append($sEcoTxt, "sContent=$sContent");

    // Monta o payload corretamente formatado
    $aPostData = [
        "model" => "deepseek-chat",   // "gpt-4-turbo",
        "messages" => [
            ["role" => "system", "content" => $sContent],
            ["role" => "user", "content" => $sPrompt]
        ],
        "temperature" => 0.2
    ];

    // Converte os dados corretamente para JSON
    $sPostFields = json_encode($aPostData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    fpc_append($sEcoTxt, "sPostFields=$sPostFields");
    if ($sPostFields === false) {
       fpc_append($sEcoTxt, "Erro ao codificar JSON: " . json_last_error_msg());
    }

    // Configurao da requisio cURL
    $oCurl = curl_init();
    curl_setopt($oCurl, CURLOPT_URL, $sUrlDeepSk);
    curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($oCurl, CURLOPT_POST, true);
    curl_setopt($oCurl, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $sApiKeyDeepSk",
        "Content-Type: application/json; charset=utf-8",
        "Content-Length: " . strlen($sPostFields)
    ]);
    curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sPostFields);
    fpc_append($sEcoTxt, "sUrlDeepSk=$sUrlDeepSk");
    fpc_append($sEcoTxt, "sApiKeyDeepSk=$sApiKeyDeepSk");

    // Executa a requisio
    $sResposta = curl_exec($oCurl);
    curl_close($oCurl);
    fpc_append($sEcoTxt, "Resposta da DeepSeek: $sResposta");
    //$sResposta = utf8_decode($sResposta);
    //fpc_append($sEcoTxt, "sResposta=$sResposta");

    // Decodifica a resposta JSON
    $oResposta = json_decode($sResposta, true);

    if (!isset($oResposta["choices"][0]["message"]["content"])) {
        fpc_append($sEcoTxt, "Erro na resposta da DeepSeek");
        return [];
    }

    $sTextoGerado = $oResposta["choices"][0]["message"]["content"];
    fpc_append($sEcoTxt, "JSON extrado da resposta: $sTextoGerado");
    // Remove delimitadores de cdigo se existirem
    $sTextoGerado = trim($sTextoGerado);
    $sTextoGerado = preg_replace('/^```json/', '', $sTextoGerado); // Remove o incio
    $sTextoGerado = preg_replace('/```$/', '', $sTextoGerado); // Remove o fim

    preg_match('/\{(?:[^{}]|(?R))*\}/', $sTextoGerado, $aMatches);
    $sJsonLimpo = '['.($aMatches[0] ?? '').']';
    fpc_append($sEcoTxt, "sJsonLimpo=$sJsonLimpo");

    //fpc_append($sEcoTxt, "JSON extrado da resposta: $sTextoGerado");
    //$sTextoGerado = utf8_decode($sTextoGerado);

    // Converte a resposta para array PHP
    $aItensPedido = json_decode($sJsonLimpo, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        fpc_append($sEcoTxt, "2) Erro ao decodificar JSON: " . json_last_error_msg());
        return [];
    }

    fpc_append($sEcoTxt, "faExtrairDados fim - Itens Extrados: " . json_encode($aItensPedido));

    return $aItensPedido;
}

function fsExecutarScriptIsolado($psScriptDestino, $paDados) {
//////////////////////////////////////////////////////////////
    global $sEcoTxt;
    fpc_append($sEcoTxt, "fsExecutarScriptIsolado inicio psScriptDestino=$psScriptDestino");
    fpc_append($sEcoTxt, "paDados=".print_r($paDados, true));
    // Gera um arquivo temporrio com os dados
    $sArquivoTemp = tempnam('/qtux/www/ecosmos/tmp', 'req_') . '.json';
    fpc_append($sEcoTxt, "Arquivo temporrio criado: $sArquivoTemp");
    $sDados = json_encode($paDados, JSON_UNESCAPED_UNICODE);
    fpc_append($sEcoTxt, "sDados=$sDados");
    if ($sDados === false) {
       fpc_append($sEcoTxt, "Erro no JSON: " . json_last_error_msg());
    } else {
       fpc_append($sEcoTxt, "JSON gerado: " . $sDados);
    }    
    //fpc_append($sEcoTxt, "sDados=$sDados");
    $lSalvo = file_put_contents($sArquivoTemp, $sDados);
    fpc_append($sEcoTxt, "lSalvo=$lSalvo");
    $s = fgc($sArquivoTemp);
    fpc_append($sEcoTxt, "s=$s");
    // Monta o comando para executar o script
    $sComando = "php $psScriptDestino $sArquivoTemp";
    fpc_append($sEcoTxt, "Comando sendo executado: $sComando");

    // Executa o comando e captura a resposta
    $sResposta = shell_exec($sComando);

    // Remove o arquivo temporrio
    unlink($sArquivoTemp);
    fpc_append($sEcoTxt, "fsExecutarScriptIsolado - fim. Arquivo temporrio removido: $sArquivoTemp");
    
    // Tenta decodificar como JSON
    $aJson = json_decode($sResposta, true);

    if (json_last_error() === JSON_ERROR_NONE && isset($aJson[1])) {
        $pMapa = $aJson[1];
        fpc_append($sEcoTxt, "pMapa=$pMapa extrado com sucesso");
        return $pMapa;
    } else {
        //fpc_append($sEcoTxt, "Erro JSON: " . json_last_error_msg() . ", JSON recebido: " . $psJson);
        fpc_append($sEcoTxt, "3) Erro ao decodificar JSON ou pMapa ausente: " . json_last_error_msg());
        return null;
    }


//    return $sResposta;
}




