<?php
require_once('StripeConfig.php');

// Capturar os parmetros da URL amigvel
$sEmail       = urldecode($_GET['email']);
$nAmount      = floatval($_GET['amount']); // Valor padro R$ 10,00
$sDescription = urldecode($_GET['description']);

// Converte para centavos (Stripe exige em centavos)
$nAmountCents = intval($nAmount * 100);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pagamento Seguro com Stripe</title>
    <script src="https://js.stripe.com/v3/"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }
        .container {
            text-align: center;
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
            max-width: 400px;
        }
        #card-element {
            border: 1px solid #ced4da;
            padding: 10px;
            border-radius: 5px;
            background: white;
        }
        #payment-button {
            width: 100%;
        }
        .loading {
            display: none;
            margin-top: 10px;
            text-align: center;
        }
    </style>
</head>
<body>

    <div class="container">
        <h4 class="mb-4">Pagamento Seguro</h4>
        <form id="payment-form">
            <div class="mb-3">
                <label for="name" class="form-label">Nome no Carto</label>
                <input type="text" id="name" class="form-control" placeholder="Nome completo" required>
            </div>
            <div class="mb-3">
                <label for="email" class="form-label">E-mail</label>
                <input type="email" id="email" class="form-control" value="<?= htmlspecialchars($sEmail) ?>" placeholder="Seu e-mail" required>
            </div>
            <div class="mb-3">
                <label for="amount" class="form-label">Valor</label>
                <input type="text" id="amount" class="form-control" value="R$ <?= number_format($nAmount, 2, ',', '.') ?>" readonly>
            </div>
            <div class="mb-3">
                <label for="card-element" class="form-label">Detalhes do Carto</label>
                <div id="card-element"></div>
                <div id="card-errors" class="text-danger mt-2" role="alert"></div>
            </div>
            <button id="payment-button" class="btn btn-primary mt-3">Pagar</button>
        </form>
        <div class="loading">
            <div class="spinner-border text-primary"></div>
            <p>Processando pagamento...</p>
        </div>
    </div>

    <script>
        var stripe = Stripe("<?= $sPublicKeyStripe ?>");
        var elements = stripe.elements();
        var card = elements.create("card", { hidePostalCode: true });
        card.mount("#card-element");

        var form = document.getElementById("payment-form");
        var paymentButton = document.getElementById("payment-button");
        var loadingIndicator = document.querySelector(".loading");
        var cardErrors = document.getElementById("card-errors");

        form.addEventListener("submit", function(event) {
            event.preventDefault();
            paymentButton.disabled = true;
            loadingIndicator.style.display = "block";

            let formData = new FormData();
            formData.append("amount", "<?= $nAmountCents ?>");
            formData.append("currency", "brl");
            formData.append("email", document.getElementById("email").value);
            formData.append("description", "<?= htmlspecialchars($sDescription) ?>");

            fetch("StripeCheckout.php", {
                method: "POST",
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.error) {
                    alert("Erro: " + data.error);
                    paymentButton.disabled = false;
                    loadingIndicator.style.display = "none";
                } else {
                    stripe.confirmCardPayment(data.clientSecret, {
                        payment_method: {
                            card: card,
                            billing_details: { name: document.getElementById("name").value }
                        }
                    }).then(result => {
                        if (result.error) {
                            cardErrors.textContent = result.error.message;
                            paymentButton.disabled = false;
                            loadingIndicator.style.display = "none";
                        } else {
                            alert("Pagamento realizado com sucesso!");
                            window.location.href = "StripeSucesso.php";
                        }
                    });
                }
            })
            .catch(error => {
                console.error(error);
                cardErrors.textContent = "Erro ao processar pagamento.";
                paymentButton.disabled = false;
                loadingIndicator.style.display = "none";
            });
        });
    </script>

</body>
</html>
