<?php
//require_once('StripeConfig.php');

//require_once('StripeCheckout.php');

?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pagamento Seguro com Stripe</title>
    <script src="https://js.stripe.com/v3/"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .container {
            max-width: 400px;
            margin-top: 50px;
            padding: 20px;
            background: white;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        }
        #card-element {
            border: 1px solid #ced4da;
            padding: 10px;
            border-radius: 5px;
            background: white;
        }
        #payment-button {
            width: 100%;
        }
        .loading {
            display: none;
            margin-top: 10px;
            text-align: center;
        }
    </style>
</head>
<body>

    <div class="container">
        <h4 class="text-center">Pagamento Seguro</h4>
        <form id="payment-form">
            <div class="mb-3">
                <label for="name" class="form-label">Nome no Carto</label>
                <input type="text" id="name" class="form-control" placeholder="Nome completo" required>
            </div>
            <div class="mb-3">
                <label for="card-element" class="form-label">Detalhes do Carto</label>
                <div id="card-element"></div>
                <div id="card-errors" class="text-danger mt-2" role="alert"></div>
            </div>
            <button id="payment-button" class="btn btn-primary mt-3">Pagar R$ 10,00</button>
        </form>
        <div class="loading">
            <div class="spinner-border text-primary"></div>
            <p>Processando pagamento...</p>
        </div>
    </div>

    <script>
        var stripe = Stripe("pk_test_51R05J9ERXoFi81Bz8GPCcAucNqvH6l8sJzFplrlJIZiCQFH8pgbybzxCaK18F9jrQIjtaZmjrxc5cuQqHe9g6Cyb00PVuO85z0"); // Substitua pela sua chave pblica
        var elements = stripe.elements();
        var card = elements.create("card", { hidePostalCode: true });
        card.mount("#card-element");

        var form = document.getElementById("payment-form");
        var paymentButton = document.getElementById("payment-button");
        var loadingIndicator = document.querySelector(".loading");
        var cardErrors = document.getElementById("card-errors");

        form.addEventListener("submit", function(event) {
            event.preventDefault();
            paymentButton.disabled = true;
            loadingIndicator.style.display = "block";

            fetch("StripeCheckout.php", { method: "POST" })
                .then(response => response.json())
                .then(data => {
                    stripe.confirmCardPayment(data.clientSecret, {
                        payment_method: {
                            card: card,
                            billing_details: { name: document.getElementById("name").value }
                        }
                    }).then(result => {
                        if (result.error) {
                            cardErrors.textContent = result.error.message;
                            paymentButton.disabled = false;
                            loadingIndicator.style.display = "none";
                        } else {
                            alert("Pagamento realizado com sucesso!");
                            window.location.href = "StripeSucesso.php"; // Redirecionar aps sucesso
                        }
                    });
                })
                .catch(error => {
                    console.error(error);
                    cardErrors.textContent = "Erro ao processar pagamento.";
                    paymentButton.disabled = false;
                    loadingIndicator.style.display = "none";
                });
        });
    </script>

</body>
</html>
