<?php
require_once('StripeConfig.php');

?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pagamento com Stripe</title>
    <script src="https://js.stripe.com/v3/"></script>
</head>
<body>
    <h2>Pagamento Seguro</h2>
    <form id="payment-form">
        <div id="card-element"></div>
        <button type="submit">Pagar</button>
    </form>

    <script>
        var stripe = Stripe("<?=$sPublicKeyStripe?>"); // Substitua pela sua chave pblica
        var elements = stripe.elements();
        var card = elements.create("card");
        card.mount("#card-element");

        var form = document.getElementById("payment-form");
        form.addEventListener("submit", function(event) {
            event.preventDefault();

            fetch("checkout.php", { method: "POST" })
                .then(response => response.json())
                .then(data => {
                    stripe.confirmCardPayment(data.clientSecret, {
                        payment_method: { card: card }
                    }).then(result => {
                        if (result.error) {
                            alert(result.error.message);
                        } else {
                            alert("Pagamento realizado com sucesso!");
                        }
                    });
                });
        });
    </script>
</body>
</html>
