<?php

// Incio do script
fpc_append($sEcoTxt, "Inicio - WOSa_Incluir_Imagem.php -> sStatus=$sStatus, sMessageBody=$sMessageBody");
$sNovoStatus = '';

// (1) - Sem status - primeira resposta depois de um 'ol' do usurio
if ($sStatus == 'sem status') {
    if (isset($aMessages["image"]["id"])) {
        $sIdImagem = $aMessages["image"]["id"];
        fpc_append($sEcoTxt, "Imagem recebida: sIdImagem=$sIdImagem");


        $sMsg = 'Oi, vi que enviou uma imagem. Estou dando uma olhada, aguarde um pouco pfv.';
        enviarMensagemWhatsApp($sFrom, $sMsg);


        // URL para obter a imagem
        $sCaminhoImagem = fsBaixarImagemWhatsApp($sIdImagem, $sTokenWAPP);


        if ($sCaminhoImagem) {
            // Extrai o texto da imagem usando OpenAI
            $sTextoExtraido = utf8_decode(fsExtrairTextoImagem($sCaminhoImagem));
            fpc_append($sEcoTxt, "sTextoExtraido=" . $sTextoExtraido);
            enviarMensagemWhatsApp($sFrom,$sTextoExtraido);

/*
            $sMsg = 'S mais um momento, pfv.';
            enviarMensagemWhatsApp($sFrom, $sMsg);

            $sTextoTranscrito = $sTextoExtraido;
            $aResultado = faExtrairPedido($sTextoTranscrito);
            $aMsg       = array();
            $sCNPJPed   = $aResultado['sCNPJPed'];
            $aMsg[]     = 'Cliente: '.$sCNPJPed;
            $aMsg[]     = 'Itens do Pedido';
            $aItensPed  = $aResultado['aItensPed'];
            foreach ($aItensPed as $aLinItensPed) {
               $sCodigo = utf8_decode($aLinItensPed['sItem']);
               $iQt     = $aLinItensPed['iQuantidade'];
               $sUn     = utf8_decode($aLinItensPed['sUnidade']);
               $nPrU    = $aLinItensPed['nPreco'];
               fpc_append($sEcoTxt, "sCodigo=$sCodigo, iQt=$iQt, sUn=$sUn, nPrU=$nPrU");
               $aMsg[] = "$sCodigo, $iQt, $sUn";
            }
            $sMsg = implode(chr(10),$aMsg);
            fpc_append($sEcoTxt, "sMsg=$sMsg");
            enviarMensagemWhatsApp($sFrom, $sMsg);

            $sMsg = 'Confirma os dados?';
            enviarMensagemWhatsApp($sFrom, $sMsg);
*/
          

/*
            // Processa e estrutura os itens do pedido
            $aItensPedido = faExtrairPedidoImagem($sTextoExtraido);
            fpc_append($sEcoTxt, "Itens extrados=" . utf8_encode(fsVarDumpToString($aItensPedido)));

            // Envia a estrutura do pedido pelo WhatsApp
            enviarMensagemWhatsApp($sFrom, json_encode($aItensPedido, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
*/


        }
    }
}

// Fim do script
fpc_append($sEcoTxt, "sCaminhoImagem=$sCaminhoImagem");
unlink($sCaminhoImagem);
fpc_append($sEcoTxt, "Final - WOSa_Incluir_Imagem.php");

///////////////////////////////////////////////////////////////////////////////////////////////////
// .. Funo para obter a URL real da imagem no WhatsApp
///////////////////////////////////////////////////////////////////////////////////////////////////
function fsObterUrlImagemWhatsApp($psIdImagem, $psToken) {
    global $sEcoTxt;

    $sUrlApi = "https://graph.facebook.com/v19.0/{$psIdImagem}?access_token={$psToken}";

    $oCurl = curl_init();
    curl_setopt($oCurl, CURLOPT_URL, $sUrlApi);
    curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($oCurl, CURLOPT_HTTPHEADER, ["Authorization: Bearer $psToken"]);

    $sResposta = curl_exec($oCurl);
    curl_close($oCurl);

    fpc_append($sEcoTxt, "Resposta fsObterUrlImagemWhatsApp: $sResposta");

    $aDados = json_decode($sResposta, true);

    if (!isset($aDados["url"])) {
        fpc_append($sEcoTxt, "Erro ao obter URL da imagem do WhatsApp");
        return false;
    }

    return $aDados["url"];
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// .. Funo para baixar a imagem do WhatsApp
///////////////////////////////////////////////////////////////////////////////////////////////////
function fsBaixarImagemWhatsApp($psIdImagem, $psToken) {
    global $sEcoTxt;

    $sUrlImagem = fsObterUrlImagemWhatsApp($psIdImagem, $psToken);
    fpc_append($sEcoTxt, "sUrlImagem=$sUrlImagem");

    if (!$sUrlImagem) return false;

    $sCaminhoImagem = "imagens/whatsapp_{$psIdImagem}.png";

    $oCurl = curl_init();
    curl_setopt($oCurl, CURLOPT_URL, $sUrlImagem);
    curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($oCurl, CURLOPT_FOLLOWLOCATION, true); // <- importante
    curl_setopt($oCurl, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $psToken",
        "User-Agent: WhatsAppBot/1.0" // <- importante tambm
    ]);

    $xConteudoImagem = curl_exec($oCurl);

    $iHttpCode = curl_getinfo($oCurl, CURLINFO_HTTP_CODE);
    fpc_append($sEcoTxt, "HTTP Code: $iHttpCode");

    if (curl_errno($oCurl)) {
        fpc_append($sEcoTxt, "Erro cURL: " . curl_error($oCurl));
    }

    curl_close($oCurl);

    if (!$xConteudoImagem || $iHttpCode !== 200) {
        fpc_append($sEcoTxt, "Erro ao baixar imagem do WhatsApp.");
        return false;
    }

    file_put_contents($sCaminhoImagem, $xConteudoImagem);
    fpc_append($sEcoTxt, "Imagem salva em: $sCaminhoImagem");

    return $sCaminhoImagem;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// .. Funo para extrair texto da imagem usando OpenAI
///////////////////////////////////////////////////////////////////////////////////////////////////
function fsExtrairTextoImagem($psArquivoImagem) {
    global $sEcoTxt, $sApiKeyOpenAI;

    fpc_append($sEcoTxt, "Inicio fsExtrairTextoImagem");

    // Detecta MIME type
    $sMimeType = mime_content_type($psArquivoImagem);
    fpc_append($sEcoTxt, "MIME type detectado: $sMimeType");

    // L e converte a imagem para base64
    $sBase64Imagem = base64_encode(file_get_contents($psArquivoImagem));

    $sContent = "Voc  um assistente OCR especializado em extrao de pedidos.";
    fpc_append($sEcoTxt, "sContent=$sContent");
    $sContent = utf8_encode($sContent);
    fpc_append($sEcoTxt, "sContent=$sContent");

    // Monta o payload corretamente
    $aPayload = [
        "model" => "gpt-4-turbo",
        "messages" => [
            [
                "role" => "system",
                "content" => $sContent
            ],
            [
                "role" => "user",
                "content" => [
                    [
                        "type" => "image_url",
                        "image_url" => [
                            "url" => "data:{$sMimeType};base64,{$sBase64Imagem}"
                        ]
                    ]
                ]
            ]
        ],
        "max_tokens" => 1000
    ];

    $sPostFields = json_encode($aPayload, JSON_UNESCAPED_UNICODE);

    if ($sPostFields === false) {
        fpc_append($sEcoTxt, "Erro ao gerar JSON: " . json_last_error_msg());
        fpc_append($sEcoTxt, "Payload problemtico: " . print_r($aPayload, true));
        return '';
    }

    // Faz a requisio para OpenAI
    $oCurl = curl_init();
    curl_setopt($oCurl, CURLOPT_URL, "https://api.openai.com/v1/chat/completions");
    curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($oCurl, CURLOPT_POST, true);
    curl_setopt($oCurl, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $sApiKeyOpenAI",
        "Content-Type: application/json"
    ]);
    curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sPostFields);

    $sResposta = curl_exec($oCurl);
    curl_close($oCurl);

    fpc_append($sEcoTxt, "Resposta da OpenAI: " . utf8_encode($sResposta));

    $oResposta = json_decode($sResposta, true);

    if (!isset($oResposta["choices"][0]["message"]["content"])) {
        fpc_append($sEcoTxt, "Erro na resposta da OpenAI");
        return "";
    }

    return trim($oResposta["choices"][0]["message"]["content"]);
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// .. Funo para processar e estruturar os itens do pedido
///////////////////////////////////////////////////////////////////////////////////////////////////
function faExtrairPedidoImagem($psTextoExtraido) {
    global $sEcoTxt;

    fpc_append($sEcoTxt, "Inicio faExtrairPedidoImagem");

    $aItensPedido = [];

    // Expresso regular para capturar nome do item, quantidade e unidade opcional
    preg_match_all('/(?:itens\s+|item\s+)?([\w-\d\s]+?)\s+quantidade\s+(\d+)(?:\s+([\w-]+))?/ui', $psTextoExtraido, $aMatchesItens, PREG_SET_ORDER);

    foreach ($aMatchesItens as $aItem) {
        $sNomeItem = trim($aItem[1]);
        $iQuantidade = (int)$aItem[2];
        $sUnidade = isset($aItem[3]) ? trim($aItem[3]) : '';

        $aItensPedido[] = [
            "item" => utf8_encode($sNomeItem),
            "quantidade" => $iQuantidade,
            "unidade" => utf8_encode($sUnidade)
        ];

        fpc_append($sEcoTxt, "Item identificado: Cdigo/Nome = $sNomeItem, Quantidade = $iQuantidade, Unidade = $sUnidade");
    }

    return $aItensPedido;
}


function faExtrairPedido($psTextoTranscrito) {
    //////////////////////////////////////////
    global $sEcoTxt;

    fpc_append($sEcoTxt, "Incio faExtrairPedido");

    // Inicializa as variveis
    $sCNPJPed = "";
    $aItensPed = [];

    // Remove caracteres indesejados e normaliza espaos
    fpc_append($sEcoTxt, "psTextoTranscrito=$psTextoTranscrito");
    $sTextoTranscrito = $psTextoTranscrito;
  //$sTextoTranscrito = fsTiraAcento(strtolower($psTextoTranscrito));
  //fpc_append($sEcoTxt, "sTextoTranscrito=$sTextoTranscrito");
    $sTextoLimpo = preg_replace('/[^\d\w\s]/', ' ', $sTextoTranscrito); // Remove tudo que no for nmero, letra ou espao
    fpc_append($sEcoTxt, "Texto Limpo: $sTextoLimpo");
    $sTextoLimpo = preg_replace('/\s+/', ' ', trim($sTextoLimpo)); // Remove mltiplos espaos extras
    fpc_append($sEcoTxt, "Texto Limpo: $sTextoLimpo");

    // Junta possveis CPF/CNPJ fragmentados
    preg_match('/\b\d{3}\s?\d{3}\s?\d{3}\s?\d{2}\b|\b\d{2}\s?\d{3}\s?\d{3}\s?\d{4}\s?\d{2}\b/', $sTextoLimpo, $aMatchesCPF_CNPJ);

    if (!empty($aMatchesCPF_CNPJ)) {
        // Armazena o CPF/CNPJ corretamente e remove os espaos internos
        $sCNPJPed = preg_replace('/\s+/', '', $aMatchesCPF_CNPJ[0]);
        fpc_append($sEcoTxt, "CNPJ/CPF identificado: $sCNPJPed");

        // Remove CPF/CNPJ do texto limpo
        $sTextoLimpo = str_replace($aMatchesCPF_CNPJ[0], '', $sTextoLimpo);
    }
    fpc_append($sEcoTxt, "sCNPJPed=$sCNPJPed, sTextoLimpo=$sTextoLimpo");

    $aItensPedido = faExtrairPedidoIA($sTextoLimpo);
    fpc_append($sEcoTxt, "aItensPedido=".fsVarDumpToString($aItensPedido));

/*
    $sTextoLimpo = trim(preg_replace('/\s+/', ' ', $sTextoLimpo));
    

    // Regex para capturar cdigo do item OU nome do item + quantidade
  //preg_match_all('/(?:item\s+)?([\w-\s\d]+)\s+(\d+)\b/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);
  //preg_match_all('/(?:item\s+)?([\w-\s\d]+)\s+quantidade\s+(\d+)\b/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);
  //preg_match_all('/(?:itens\s+|item\s+)?([\w-\d\s]+?)\s+quantidade\s+(\d+)\b/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);
  //preg_match_all('/(?:itens\s+|item\s+)?([\w-\d\s]+?)\s+quantidade\s+(\d+)/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);
  //preg_match_all('/(?:itens\s+|item\s+)?(\d+|\p{L}[\p{L}\s\d]*)\s+quantidade\s+(\d+)/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);
  //preg_match_all('/(?:itens\s+|item\s+)?([\w-\d]+(?:\s[\w-\d]+)*)\s+quantidade\s+(\d+)/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);
  //preg_match_all('/(?:itens\s+|item\s+)?([\w-\d]+(?:\s[\w-\d]+)*)\s+quantidade\s+(\d+)/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);
    preg_match_all('/(?:itens\s+|item\s+)?([\w-\d\s]+?)\s+quantidade\s+(\d+)/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);

    fpc_append($sEcoTxt, "aMatchesItens=".fsVarDumpToString($aMatchesItens));


    //fpc_append($sEcoTxt, "aMatchesItens=".fsVarDumpToString($aMatchesItens));
    foreach ($aMatchesItens as $aItem) {
        $sCodigoOuNome = trim($aItem[1]); // Pode ser cdigo numrico ou nome do item
        $iQuantidade = intval($aItem[2]); // Sempre numrico
        
        $aItensPed[] = [
            "sItem" => $sCodigoOuNome,
            "iQuantidade" => $iQuantidade
        ];
        fpc_append($sEcoTxt, "Item identificado: Cdigo/Nome = {$sCodigoOuNome}, Quantidade = {$iQuantidade}");
    }
*/
    fpc_append($sEcoTxt, "Fim faExtrairPedido");

    // Retorna os dados extrados
    return [
        "sCNPJPed" => $sCNPJPed,
        "aItensPed" => $aItensPedido
    ];
}


function faExtrairPedidoIA($psTextoPedido) {
//////////////////////////////////////////
    global $sApiKeyOpenAI, $sEcoTxt;

    fpc_append($sEcoTxt, "Incio faExtrairPedidoIA");

    // Define o prompt para extrair os dados estruturados
    $sPrompt = "Extraia os itens da seguinte lista de pedidos. Retorne um JSON com a estrutura [{\"sItem\": \"nome do item\", \"iQuantidade\": nmero, \"sUnidade\": \"se houver\", \"nPreco\": nmero opcional}]. Texto: \"$psTextoPedido\"";
    fpc_append($sEcoTxt, "sPrompt=$sPrompt");
    $sPrompt = utf8_encode($sPrompt);
    fpc_append($sEcoTxt, "sPrompt=$sPrompt");

    //$sPrompt = "Preciso que avalie uma string e me retorne em um json o conjunto de itens, quantidades, unidade e preos. O item e a quantidade  obrigatrio, a unidade (exemplo caixas) pode aparecer ou no, e o preo tb pode aparecer o no.";
    //$sPrompt .= "a string  essa: ".$psTextoPedido;
    //fpc_append($sEcoTxt, "sPrompt=$sPrompt");
    //$sPrompt = utf8_encode($sPrompt);
    //fpc_append($sEcoTxt, "sPrompt=$sPrompt");

    $sContent = "Voc  um assistente especializado em extrao de pedidos.";
    fpc_append($sEcoTxt, "sContent=$sContent");
    $sContent = utf8_encode($sContent);
    fpc_append($sEcoTxt, "sContent=$sContent");

    // Monta o payload corretamente formatado
    $aPostData = [
        "model" => "gpt-4-turbo",
        "messages" => [
            ["role" => "system", "content" => $sContent],
            ["role" => "user", "content" => $sPrompt]
        ],
        "temperature" => 0.2
    ];

    // Converte os dados corretamente para JSON
    $sPostFields = json_encode($aPostData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    fpc_append($sEcoTxt, "sPostFields=$sPostFields");
    if ($sPostFields === false) {
       fpc_append($sEcoTxt, "Erro ao codificar JSON: " . json_last_error_msg());
    }

    // Configurao da requisio cURL
    $oCurl = curl_init();
    curl_setopt($oCurl, CURLOPT_URL, "https://api.openai.com/v1/chat/completions");
    curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($oCurl, CURLOPT_POST, true);
    curl_setopt($oCurl, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $sApiKeyOpenAI",
        "Content-Type: application/json; charset=utf-8",
        "Content-Length: " . strlen($sPostFields)
    ]);
    curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sPostFields);

    // Executa a requisio
    $sResposta = curl_exec($oCurl);
    curl_close($oCurl);
    fpc_append($sEcoTxt, "Resposta da OpenAI: $sResposta");
    //$sResposta = utf8_decode($sResposta);
    //fpc_append($sEcoTxt, "sResposta=$sResposta");

    // Decodifica a resposta JSON
    $oResposta = json_decode($sResposta, true);

    if (!isset($oResposta["choices"][0]["message"]["content"])) {
        fpc_append($sEcoTxt, "Erro na resposta da OpenAI");
        return [];
    }

    $sTextoGerado = $oResposta["choices"][0]["message"]["content"];
    // Remove delimitadores de cdigo se existirem
    $sTextoGerado = trim($sTextoGerado);
    $sTextoGerado = preg_replace('/^```json/', '', $sTextoGerado); // Remove o incio
    $sTextoGerado = preg_replace('/```$/', '', $sTextoGerado); // Remove o fim

    fpc_append($sEcoTxt, "JSON extrado da resposta: $sTextoGerado");
    //$sTextoGerado = utf8_decode($sTextoGerado);

    // Converte a resposta para array PHP
    $aItensPedido = json_decode($sTextoGerado, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        fpc_append($sEcoTxt, "Erro ao decodificar JSON: " . json_last_error_msg());
        return [];
    }

    fpc_append($sEcoTxt, "faExtrairPedidoIA fim - Itens Extrados: " . json_encode($aItensPedido));

    return $aItensPedido;
}


?>
