<?php
// Incio do script

//http_response_code(200);
//echo 'OK'; // Resposta rpida para evitar retentativas
http_response_code(202);
header('Content-Type: application/json'); // .. Sempre defina o Content-Type!
echo json_encode([
    'status'  => 'processing',
    'message' => 'Sua requisio est em processamento',
    'request_id' => uniqid() // Para rastreamento
]);


if (function_exists('fastcgi_finish_request')) {
    fastcgi_finish_request(); // Libera a conexo (PHP-FPM)
} else {
    ignore_user_abort(true); // Permite continuar o script aps a resposta
    ob_end_flush(); // Envia o buffer de sada
    flush();
}

set_time_limit(10*60);


// Incio do script
fpc_append($sEcoTxt, "Inicio - WOSa_Incluir_Audio.php -> sStatus=$sStatus, sMessageBody=$sMessageBody");
$sNovoStatus = '';


// (1) - Sem status - primeira resposta depois de um 'ol' do usurio
if ($sStatus=='sem status') {


} else if ($sStatus=='esperando audio pedido') {

    $sMsg = 'Oi, recebi seu udio, aguarde um instante.';
    enviarMensagemWhatsApp($sFrom, $sMsg);

    $sNovoStatus = "processando";
    fpc_append($sEcoTxt,"sMsg=$sMsg, sFrom=$sFrom, sNovoStatus=$sNovoStatus, sFluxo=$sFluxo");
    $sContxt = '';
    fpc_append($sEcoTxt,"sContxt=$sContxt");
    flWAPP_InserirMensagens($sFrom,$sTelTQ,$sFluxo,$sMsg,$sNovoStatus,$sContxt,$sMessageBody);


    $sIdAudio = $aMessages["audio"]["id"];
    fpc_append($sEcoTxt, "sIdAudio=$sIdAudio");

    // URL para obter JSON do udio
    $sUrlJsonAudio = "https://graph.facebook.com/v22.0/{$sIdAudio}?access_token=$sTokenWAPP";
    fpc_append($sEcoTxt, "sUrlJsonAudio=$sUrlJsonAudio");

    // Baixa o udio do WhatsApp
    $sArquivoOgg = fsBaixarAudioWhatsApp($sUrlJsonAudio, $sTokenWAPP);

    if ($sArquivoOgg) {

        $sMsg = 'Estou processando, aguarde um momento pfv.';
        enviarMensagemWhatsApp($sFrom, $sMsg);

        // Converte para MP3
        $sArquivoMp3 = fsConverterParaMP3($sArquivoOgg);

        if ($sArquivoMp3) {
            // Transcreve o udio usando OpenAI
            fpc_append($sEcoTxt, "1 time=".time());
            $sTextoTranscrito = fsTranscreverAudio($sArquivoMp3);
            fpc_append($sEcoTxt, "2 time=".time());
            fpc_append($sEcoTxt, "sTextoTranscrito=$sTextoTranscrito");

            // Envia a transcrio via WhatsApp
            //enviarMensagemWhatsApp($sFrom, $sTextoTranscrito);

            $aResultado = faExtrairPedido($sTextoTranscrito);
            $aMsg       = array();
            $sCNPJPed   = $aResultado['sCNPJPed'];
            $aMsg[]     = 'Cliente: '.$sCNPJPed;
            $aMsg[]     = 'Itens do Pedido';
            $aItensPed  = $aResultado['aItensPed'];
            $aCItens    = array();
            foreach ($aItensPed as $aLinItensPed) {
               $sCodigo = utf8_decode($aLinItensPed['sItem']);
               $iQt     = $aLinItensPed['iQuantidade'];
               $sUn     = utf8_decode($aLinItensPed['sUnidade']);
               $nPrU    = $aLinItensPed['nPreco'];
               fpc_append($sEcoTxt, "sCodigo=$sCodigo, iQt=$iQt, sUn=$sUn, nPrU=$nPrU");
               $aMsg[] = "$sCodigo, $iQt, $sUn";
               $aCItens[] = "'".$sCodigo."'";
            }
            $sMsg = implode(chr(10),$aMsg);
            fpc_append($sEcoTxt, "sMsg=$sMsg");
            enviarMensagemWhatsApp($sFrom, $sMsg);

/*
            if (strlen($sCNPJPed)==14) {
               $sSql = "select pPId,sCoringa from CUP where sCNPJ='$sCNPJPed' and jTipo=1";
            } else {
               $sSql = "select pPId,sCoringa from CUP where sCPF ='$sCNPJPed' and jTipo=0";
            }
            $aDb = faDbSelect($hDb,$sSql);
            fpc_append($sEcoTxt,"sSql=$sSql");
            $iDb = count($aDb);
            fpc_append($sEcoTxt,"iDb=$iDb");
            if ($iDb>0) {
               $pDest = $aDb[0][0];
               $sDest = $aDb[0][1];
               $sInCodigo = implode(',',$aCItens);
               $sSql = "select pPId,sCodigo,sItem from Itens where pUNeg=$pUNeg and sCodigo in ($InsCodigo) and iVer=iVAt and lExc=0";
               fpc_append($sEcoTxt,"sSql=$sSql");
               $aDb = faDbSelect($hDb,$sSql);
               $iDb = count($aDb);
               $iDb = count($aDb);
               if ($iDb>0) {
               
               foreach ($aItensPed as $aLinItensPed) {
                  $sCodigo = utf8_decode($aLinItensPed['sItem']);
                  $iQt     = $aLinItensPed['iQuantidade'];
                  $sUn     = utf8_decode($aLinItensPed['sUnidade']);
                  $nPrU    = $aLinItensPed['nPreco'];
                  //fpc_append($sEcoTxt, "sCodigo=$sCodigo, iQt=$iQt, sUn=$sUn, nPrU=$nPrU");
                  //$aMsg[] = "$sCodigo, $iQt, $sUn";
               }



            }
*/


          //$sMsg = 'Confirma os dados?';
            $sMsg = 'Obrigado, essa conversa ser encerrada.';
            enviarMensagemWhatsApp($sFrom, $sMsg);
         }
    }
    $sNovoStatus = "sem status";
    fpc_append($sEcoTxt,"sMsg=$sMsg, sFrom=$sFrom, sNovoStatus=$sNovoStatus, sFluxo=$sFluxo");
    $sContxt = '';
    fpc_append($sEcoTxt,"sContxt=$sContxt");
    flWAPP_InserirMensagens($sFrom,$sTelTQ,$sFluxo,$sMsg,$sNovoStatus,$sContxt,$sMessageBody);
}

if ($lOk==true) {
   if ($sNovoStatus=="sem status") {
      $sSql = "delete from WAPP_Mensagens where sTelOrig = '$sFrom' and sTelDest = '$sTelTQ'";
      fpc_append($sEcoTxt,"sSql=$sSql");
      $lOk = flDbDelete($hDb,$sSql);
      fpc_append($sEcoTxt,"lOk=$lOk");
   }
}

if ($lOk==true) {
   flDbCommit($hDb);
   fpc_append($sEcoTxt,"commit");
} else {
   flDbRollBack($hDb);
   fpc_append($sEcoTxt,"rollback");}


// Fim do script
fpc_append($sEcoTxt, "sArquivoOgg=$sArquivoOgg, sArquivoMp3=$sArquivoMp3");
unlink($sArquivoMp3);
unlink($sArquivoOgg);
fpc_append($sEcoTxt, "Final - WOSa_Incluir_Audio.php");


function faExtrairPedido($psTextoTranscrito) {
    //////////////////////////////////////////
    global $sEcoTxt;

    fpc_append($sEcoTxt, "Incio faExtrairPedido");

    // Inicializa as variveis
    $sCNPJPed = "";
    $aItensPed = [];

    // Remove caracteres indesejados e normaliza espaos
    fpc_append($sEcoTxt, "psTextoTranscrito=$psTextoTranscrito");
    $sTextoTranscrito = $psTextoTranscrito;
  //$sTextoTranscrito = fsTiraAcento(strtolower($psTextoTranscrito));
  //fpc_append($sEcoTxt, "sTextoTranscrito=$sTextoTranscrito");
    $sTextoLimpo = preg_replace('/[^\d\w\s]/', ' ', $sTextoTranscrito); // Remove tudo que no for nmero, letra ou espao
    fpc_append($sEcoTxt, "Texto Limpo: $sTextoLimpo");
    $sTextoLimpo = preg_replace('/\s+/', ' ', trim($sTextoLimpo)); // Remove mltiplos espaos extras
    fpc_append($sEcoTxt, "Texto Limpo: $sTextoLimpo");

    // Junta possveis CPF/CNPJ fragmentados
    preg_match('/\b\d{3}\s?\d{3}\s?\d{3}\s?\d{2}\b|\b\d{2}\s?\d{3}\s?\d{3}\s?\d{4}\s?\d{2}\b/', $sTextoLimpo, $aMatchesCPF_CNPJ);

    if (!empty($aMatchesCPF_CNPJ)) {
        // Armazena o CPF/CNPJ corretamente e remove os espaos internos
        $sCNPJPed = preg_replace('/\s+/', '', $aMatchesCPF_CNPJ[0]);
        fpc_append($sEcoTxt, "CNPJ/CPF identificado: $sCNPJPed");

        // Remove CPF/CNPJ do texto limpo
        $sTextoLimpo = str_replace($aMatchesCPF_CNPJ[0], '', $sTextoLimpo);
    }
    fpc_append($sEcoTxt, "sCNPJPed=$sCNPJPed, sTextoLimpo=$sTextoLimpo");

    $aItensPedido = faExtrairPedidoIA($sTextoLimpo);
    fpc_append($sEcoTxt, "aItensPedido=".fsVarDumpToString($aItensPedido));

/*
    $sTextoLimpo = trim(preg_replace('/\s+/', ' ', $sTextoLimpo));
    

    // Regex para capturar cdigo do item OU nome do item + quantidade
  //preg_match_all('/(?:item\s+)?([\w-\s\d]+)\s+(\d+)\b/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);
  //preg_match_all('/(?:item\s+)?([\w-\s\d]+)\s+quantidade\s+(\d+)\b/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);
  //preg_match_all('/(?:itens\s+|item\s+)?([\w-\d\s]+?)\s+quantidade\s+(\d+)\b/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);
  //preg_match_all('/(?:itens\s+|item\s+)?([\w-\d\s]+?)\s+quantidade\s+(\d+)/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);
  //preg_match_all('/(?:itens\s+|item\s+)?(\d+|\p{L}[\p{L}\s\d]*)\s+quantidade\s+(\d+)/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);
  //preg_match_all('/(?:itens\s+|item\s+)?([\w-\d]+(?:\s[\w-\d]+)*)\s+quantidade\s+(\d+)/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);
  //preg_match_all('/(?:itens\s+|item\s+)?([\w-\d]+(?:\s[\w-\d]+)*)\s+quantidade\s+(\d+)/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);
    preg_match_all('/(?:itens\s+|item\s+)?([\w-\d\s]+?)\s+quantidade\s+(\d+)/ui', $sTextoLimpo, $aMatchesItens, PREG_SET_ORDER);

    fpc_append($sEcoTxt, "aMatchesItens=".fsVarDumpToString($aMatchesItens));


    //fpc_append($sEcoTxt, "aMatchesItens=".fsVarDumpToString($aMatchesItens));
    foreach ($aMatchesItens as $aItem) {
        $sCodigoOuNome = trim($aItem[1]); // Pode ser cdigo numrico ou nome do item
        $iQuantidade = intval($aItem[2]); // Sempre numrico
        
        $aItensPed[] = [
            "sItem" => $sCodigoOuNome,
            "iQuantidade" => $iQuantidade
        ];
        fpc_append($sEcoTxt, "Item identificado: Cdigo/Nome = {$sCodigoOuNome}, Quantidade = {$iQuantidade}");
    }
*/
    fpc_append($sEcoTxt, "Fim faExtrairPedido");

    // Retorna os dados extrados
    return [
        "sCNPJPed" => $sCNPJPed,
        "aItensPed" => $aItensPedido
    ];
}


function faExtrairPedidoIA($psTextoPedido) {
//////////////////////////////////////////
    global $sApiKeyOpenAI, $sEcoTxt;

    fpc_append($sEcoTxt, "Incio faExtrairPedidoIA");

    // Define o prompt para extrair os dados estruturados
    $sPrompt = "Extraia os itens da seguinte lista de pedidos. Retorne um JSON com a estrutura [{\"sItem\": \"nome do item\", \"iQuantidade\": nmero, \"sUnidade\": \"se houver\", \"nPreco\": nmero opcional}]. Texto: \"$psTextoPedido\"";
    fpc_append($sEcoTxt, "sPrompt=$sPrompt");
    $sPrompt = utf8_encode($sPrompt);
    fpc_append($sEcoTxt, "sPrompt=$sPrompt");

    //$sPrompt = "Preciso que avalie uma string e me retorne em um json o conjunto de itens, quantidades, unidade e preos. O item e a quantidade  obrigatrio, a unidade (exemplo caixas) pode aparecer ou no, e o preo tb pode aparecer o no.";
    //$sPrompt .= "a string  essa: ".$psTextoPedido;
    //fpc_append($sEcoTxt, "sPrompt=$sPrompt");
    //$sPrompt = utf8_encode($sPrompt);
    //fpc_append($sEcoTxt, "sPrompt=$sPrompt");

    $sContent = "Voc  um assistente especializado em extrao de pedidos.";
    fpc_append($sEcoTxt, "sContent=$sContent");
    $sContent = utf8_encode($sContent);
    fpc_append($sEcoTxt, "sContent=$sContent");

    // Monta o payload corretamente formatado
    $aPostData = [
        "model" => "gpt-4-turbo",
        "messages" => [
            ["role" => "system", "content" => $sContent],
            ["role" => "user", "content" => $sPrompt]
        ],
        "temperature" => 0.2
    ];

    // Converte os dados corretamente para JSON
    $sPostFields = json_encode($aPostData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    fpc_append($sEcoTxt, "sPostFields=$sPostFields");
    if ($sPostFields === false) {
       fpc_append($sEcoTxt, "Erro ao codificar JSON: " . json_last_error_msg());
    }

    // Configurao da requisio cURL
    $oCurl = curl_init();
    curl_setopt($oCurl, CURLOPT_URL, "https://api.openai.com/v1/chat/completions");
    curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($oCurl, CURLOPT_POST, true);
    curl_setopt($oCurl, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $sApiKeyOpenAI",
        "Content-Type: application/json; charset=utf-8",
        "Content-Length: " . strlen($sPostFields)
    ]);
    curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sPostFields);

    // Executa a requisio
    $sResposta = curl_exec($oCurl);
    curl_close($oCurl);
    fpc_append($sEcoTxt, "Resposta da OpenAI: $sResposta");
    //$sResposta = utf8_decode($sResposta);
    //fpc_append($sEcoTxt, "sResposta=$sResposta");

    // Decodifica a resposta JSON
    $oResposta = json_decode($sResposta, true);

    if (!isset($oResposta["choices"][0]["message"]["content"])) {
        fpc_append($sEcoTxt, "Erro na resposta da OpenAI");
        return [];
    }

    $sTextoGerado = $oResposta["choices"][0]["message"]["content"];
    // Remove delimitadores de cdigo se existirem
    $sTextoGerado = trim($sTextoGerado);
    $sTextoGerado = preg_replace('/^```json/', '', $sTextoGerado); // Remove o incio
    $sTextoGerado = preg_replace('/```$/', '', $sTextoGerado); // Remove o fim

    fpc_append($sEcoTxt, "JSON extrado da resposta: $sTextoGerado");
    //$sTextoGerado = utf8_decode($sTextoGerado);

    // Converte a resposta para array PHP
    $aItensPedido = json_decode($sTextoGerado, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        fpc_append($sEcoTxt, "Erro ao decodificar JSON: " . json_last_error_msg());
        return [];
    }

    fpc_append($sEcoTxt, "faExtrairPedidoIA fim - Itens Extrados: " . json_encode($aItensPedido));

    return $aItensPedido;
}
