<?php

// Incio do script
fpc_append($sEcoTxt, "Inicio - WOSa_Audio.php -> sStatus=$sStatus, sMessageBody=$sMessageBody");
$sNovoStatus = '';


// (1) - Sem status - primeira resposta depois de um 'ol' do usurio
if ($sStatus == 'sem status') {  
    $sIdAudio = $aMessages["audio"]["id"];
    fpc_append($sEcoTxt, "sIdAudio=$sIdAudio");

    // URL para obter JSON do udio
    $sUrlJsonAudio = "https://graph.facebook.com/v22.0/{$sIdAudio}?access_token=$sTokenWAPP";
    fpc_append($sEcoTxt, "sUrlJsonAudio=$sUrlJsonAudio");

    // Baixa o udio do WhatsApp
    $sArquivoOgg = fsBaixarAudioWhatsApp($sUrlJsonAudio, $sTokenWAPP);

    if ($sArquivoOgg) {
        // Converte para MP3
        $sArquivoMp3 = fsConverterParaMP3($sArquivoOgg);

        if ($sArquivoMp3) {
            // Transcreve o udio usando OpenAI
            $sTextoTranscrito = fsTranscreverAudio($sArquivoMp3);
            fpc_append($sEcoTxt, "sTextoTranscrito=$sTextoTranscrito");

            // Envia a transcrio via WhatsApp
            enviarMensagemWhatsApp($sFrom, $sTextoTranscrito);
        }
    }
}

// Rollback se necessrio
if ($lOk == true) {
    if ($sNovoStatus == "sem status") {
        $sSql = "DELETE FROM WAPP_Mensagens WHERE sTelOrig = '$sFrom' AND sTelDest = '$sTelTQ'";
        fpc_append($sEcoTxt, "sSql=$sSql");
        $lOk = flDbDelete($hDb, $sSql);
        fpc_append($sEcoTxt, "lOk=$lOk");
    }
}

// Fim do script
unlink('audios/audio_whatsapp.mp3');
unlink('audios/audio_whatsapp.ogg');
fpc_append($sEcoTxt, "Final - WOSa_Audio.php");


// ----------------------------------------
// .. Funo para baixar udio do WhatsApp
// ----------------------------------------
function fsBaixarAudioWhatsApp($psUrlJsonAudio, $psTokenWAPP) {
    global $sEcoTxt;

    fpc_append($sEcoTxt, "Baixando JSON do udio do WhatsApp: $psUrlJsonAudio");

    // Baixa o JSON que contm a URL real do udio
    $xJsonAudio = file_get_contents($psUrlJsonAudio);
    $aJsonAudio = json_decode($xJsonAudio, true);

    if (!isset($aJsonAudio["url"])) {
        fpc_append($sEcoTxt, "Erro: JSON no contm URL vlida.");
        return false;
    }

    $sUrlAudio = $aJsonAudio["url"];
    fpc_append($sEcoTxt, "URL real do udio: $sUrlAudio");

    // Define o nome do arquivo temporrio
    $sArquivoOgg = "audios/audio_whatsapp.ogg";

    // Faz o download do udio real
    $sComando = "curl -L -o $sArquivoOgg -H \"Authorization: Bearer $psTokenWAPP\" \"$sUrlAudio\"";
    exec($sComando, $aSaida, $iRetorno);

    fpc_append($sEcoTxt, "Comando executado: $sComando");
    fpc_append($sEcoTxt, "Cdigo de retorno: $iRetorno");

    if ($iRetorno !== 0) {
        fpc_append($sEcoTxt, "Erro ao baixar udio do WhatsApp.");
        return false;
    }

    return $sArquivoOgg;
}


// ----------------------------------------
// .. Funo para converter OGG para MP3
// ----------------------------------------
function fsConverterParaMP3($psArquivoOgg) {
    global $sEcoTxt;

    $sArquivoMp3 = str_replace(".ogg", ".mp3", $psArquivoOgg);
    $sComando = "ffmpeg -i $psArquivoOgg -ac 1 -ar 16000 -b:a 128k -f mp3 $sArquivoMp3";
    
    exec($sComando, $aSaida, $iRetorno);
    fpc_append($sEcoTxt, "Convertendo udio: $sComando");
    fpc_append($sEcoTxt, "Cdigo de retorno: $iRetorno");

    if ($iRetorno !== 0) {
        fpc_append($sEcoTxt, "Erro ao converter para MP3.");
        return false;
    }

    return $sArquivoMp3;
}


// ----------------------------------------
// .. Funo para transcrever udio com OpenAI
// ----------------------------------------
function fsTranscreverAudio($psArquivoMp3) {
    global $sEcoTxt, $sApiKeyOpenAI;

    fpc_append($sEcoTxt, "Inicio fsTranscreverAudio");

    // Configurao da requisio
    $oCurl = curl_init();
    curl_setopt($oCurl, CURLOPT_URL, "https://api.openai.com/v1/audio/transcriptions");
    curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($oCurl, CURLOPT_POST, true);
    curl_setopt($oCurl, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $sApiKeyOpenAI",
        "Content-Type: multipart/form-data"
    ]);
    curl_setopt($oCurl, CURLOPT_POSTFIELDS, [
        "file" => new CURLFile($psArquivoMp3),
        "model" => "whisper-1"
    ]);

    // Executa a requisio
    $sResposta = curl_exec($oCurl);
    fpc_append($sEcoTxt, "sResposta=$sResposta");
    curl_close($oCurl);

    // Converte a resposta para array
    $aResposta = json_decode($sResposta, true);

    fpc_append($sEcoTxt, "Fim fsTranscreverAudio");

    // Retorna o texto transcrito ou erro
    return $aResposta["text"] ?? "Erro na transcrio.";
}

?>
