<?php

// LOG de debug
fpc_append($sEcoTxt, "Incio - WOSa_Audio.php -> sStatus=$sStatus, sMessageBody=$sMessageBody");

$sNovoStatus = '';

// (1) - Sem status . Primeira resposta aps um "ol" do usurio
if ($sStatus == 'sem status') {  
    $sPIdAudio = $aMessages["audio"]["id"];
    fpc_append($sEcoTxt, "sPIdAudio=$sPIdAudio");

    // Baixa o udio do WhatsApp
    $sArquivoOGG = fsBaixarAudioWhatsApp($sPIdAudio, $sTokenWAPP);
    fpc_append($sEcoTxt, "sArquivoOGG=$sArquivoOGG");

    // Converte para MP3
    $sArquivoMP3 = "audios/audio_whatsapp.mp3";
    if (flConverterAudioParaMP3($sArquivoOGG, $sArquivoMP3)) {
        fpc_append($sEcoTxt, "Converso bem-sucedida: $sArquivoMP3");

        // Transcreve o udio
        $sTextoTranscrito = fsTranscreverAudio($sArquivoMP3);
        fpc_append($sEcoTxt, "Texto transcrito: $sTextoTranscrito");

        // Envia resposta para o usurio
        fEnviarMensagemWhatsApp($sFrom, $sTextoTranscrito);
    } else {
        fpc_append($sEcoTxt, "Erro na converso do udio!");
    }
}

// (2) - Se necessrio, resetar status e apagar mensagens antigas
if ($lOk == true) {
    if ($sNovoStatus == "sem status") {
        $sSql = "DELETE FROM WAPP_Mensagens WHERE sTelOrig = '$sFrom' AND sTelDest = '$sTelTQ'";
        fpc_append($sEcoTxt, "sSql=$sSql");
        $lOk = flDbDelete($hDb, $sSql);
        fpc_append($sEcoTxt, "lOk=$lOk");
    }
}

fpc_append($sEcoTxt, "Final - WOSa_Audio.php");

//
// ============================ FUNES AUXILIARES ============================
//

// .. **1.. Baixar udio do WhatsApp**
function fsBaixarAudioWhatsApp($psPIdAudio, $psTokenWAPP) {
    global $sEcoTxt;

    $sUrlAudio = "https://graph.facebook.com/v17.0/{$psPIdAudio}?access_token={$psTokenWAPP}";
    fpc_append($sEcoTxt, "Baixando udio de: $sUrlAudio");

    // Faz download do udio
    $xAudio = file_get_contents($sUrlAudio);
    fpc_append($sEcoTxt,"1 xAudio=$xAudio");
    fpc_append($sEcoTxt,"2 xAudio=" . json_encode($xAudio));
    // Verifica se o arquivo foi baixado corretamente
    if ($xAudio === false || strlen($xAudio) < 1000) {
        fpc_append($sEcoTxt, "Erro: Arquivo de udio invlido ou no baixado.");
        die("Erro: Arquivo de udio invlido ou no baixado.");
    }

    // Salva como OGG (Opus)
    $sArquivoOGG = "audios/audio_whatsapp.ogg";
    file_put_contents($sArquivoOGG, $xAudio);
    fpc_append($sEcoTxt, "Arquivo de udio salvo com sucesso: $sArquivoOGG");

    return $sArquivoOGG;
}

// .. **2.. Converter de OGG para MP3 usando FFmpeg**
function flConverterAudioParaMP3($psArquivoOrigem, $psArquivoMP3) {
    global $sEcoTxt;

    $sCaminhoFFmpeg = "/usr/bin/ffmpeg"; // Verifique se este  o caminho correto!

    if (!file_exists($psArquivoOrigem)) {
        fpc_append($sEcoTxt, "Erro: Arquivo de origem no encontrado: $psArquivoOrigem");
        return false;
    }

    // Comando FFmpeg para converso
    $sComando = "$sCaminhoFFmpeg -i $psArquivoOrigem -ac 1 -ar 16000 -ab 128k -c:a libmp3lame $psArquivoMP3";
    
    exec($sComando . " 2>&1", $aSaida, $iRetorno);
    fpc_append($sEcoTxt, "Comando executado: $sComando");
    fpc_append($sEcoTxt, "Sada FFmpeg: " . implode("\n", $aSaida));
    fpc_append($sEcoTxt, "Cdigo de retorno: $iRetorno");

    return $iRetorno === 0;
}

// .. **3.. Transcrever udio com Whisper (OpenAI)**
function fsTranscreverAudio($psArquivoMP3) {
    global $sEcoTxt, $sApiKeyOpenAI;

    fpc_append($sEcoTxt, "Incio fsTranscreverAudio");

    // Configurao da requisio para Whisper-1
    $oCurl = curl_init();
    curl_setopt($oCurl, CURLOPT_URL, "https://api.openai.com/v1/audio/transcriptions");
    curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($oCurl, CURLOPT_POST, true);
    curl_setopt($oCurl, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $sApiKeyOpenAI",
        "Content-Type: multipart/form-data"
    ]);
    curl_setopt($oCurl, CURLOPT_POSTFIELDS, [
        "file" => new CURLFile($psArquivoMP3),
        "model" => "whisper-1"
    ]);

    // Executa a requisio
    $sResposta = curl_exec($oCurl);
    fpc_append($sEcoTxt, "sResposta=$sResposta");
    curl_close($oCurl);

    // Converte a resposta para array
    $aResposta = json_decode($sResposta, true);
    fpc_append($sEcoTxt, "Fim fsTranscreverAudio");

    // Retorna a transcrio ou erro
    return $aResposta["text"] ?? "Erro na transcrio.";
}

// .. **4.. Enviar mensagem transcrita pelo WhatsApp**
function fEnviarMensagemWhatsApp($psFrom, $psTexto) {
    global $sTokenWAPP, $sEcoTxt;

    $sUrl = "https://graph.facebook.com/v17.0/{$sPhoneNumberId}/messages";

    $aDados = [
        "messaging_product" => "whatsapp",
        "to" => $psFrom,
        "text" => ["body" => $psTexto]
    ];

    $oCurl = curl_init($sUrl);
    curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($oCurl, CURLOPT_POST, true);
    curl_setopt($oCurl, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $sTokenWAPP",
        "Content-Type: application/json"
    ]);
    curl_setopt($oCurl, CURLOPT_POSTFIELDS, json_encode($aDados));

    $sResposta = curl_exec($oCurl);
    fpc_append($sEcoTxt, "Resposta envio WhatsApp: $sResposta");
    curl_close($oCurl);
}

?>
