<?php

// Incio do script
fpc_append($sEcoTxt, "Inicio - WOSa_Audio.php -> sStatus=$sStatus, sMessageBody=$sMessageBody");
$sNovoStatus = '';

// (1) - Sem status - primeira resposta depois de um 'ol' do usurio
if ($sStatus == 'sem status') {
    $sIdAudio = $aMessages["audio"]["id"];
    fpc_append($sEcoTxt, "sIdAudio=$sIdAudio");

    // URL para obter JSON do udio
    $sUrlJsonAudio = "https://graph.facebook.com/v22.0/{$sIdAudio}?access_token=$sTokenWAPP";
    fpc_append($sEcoTxt, "sUrlJsonAudio=$sUrlJsonAudio");

    // Baixa o udio do WhatsApp
    $sArquivoOgg = fsBaixarAudioWhatsApp($sUrlJsonAudio, $sTokenWAPP, $sFrom);

    if ($sArquivoOgg) {
        // Converte para MP3
        $sArquivoMp3 = fsConverterParaMP3($sArquivoOgg, $sFrom);

        if ($sArquivoMp3) {
            // Transcreve o udio usando OpenAI
            $sTextoTranscrito = fsTranscreverAudio($sArquivoMp3);
            fpc_append($sEcoTxt, "sTextoTranscrito=$sTextoTranscrito");

            // Envia a transcrio via WhatsApp
            enviarMensagemWhatsApp($sFrom, $sTextoTranscrito);
        }
    }
}

// Rollback se necessrio
if ($lOk == true) {
    if ($sNovoStatus == "sem status") {
        $sSql = "DELETE FROM WAPP_Mensagens WHERE sTelOrig = '$sFrom' AND sTelDest = '$sTelTQ'";
        fpc_append($sEcoTxt, "sSql=$sSql");
        $lOk = flDbDelete($hDb, $sSql);
        fpc_append($sEcoTxt, "lOk=$lOk");
    }
}

// Limpeza dos arquivos temporrios
unlink("audios/{$sFrom}.mp3");
unlink("audios/{$sFrom}.ogg");

fpc_append($sEcoTxt, "Final - WOSa_Audio.php");

//
// Funo para baixar o udio do WhatsApp
function fsBaixarAudioWhatsApp($psUrlJson, $psToken, $psFrom) {
///////////////////////////////////////////////////////////////
    global $sEcoTxt;

    fpc_append($sEcoTxt, "Inicio fsBaixarAudioWhatsApp");

    // Obtm o JSON do udio
    $oResposta = json_decode(file_get_contents($psUrlJson), true);
    if (!$oResposta || !isset($oResposta["url"])) {
        fpc_append($sEcoTxt, "Erro ao obter URL do udio.");
        return false;
    }
    $sUrlAudio = $oResposta["url"];
    
    // Define nome do arquivo OGG
    $sArquivoOgg = "audios/{$psFrom}.ogg";

    // Baixa o arquivo
    $oCurl = curl_init();
    curl_setopt($oCurl, CURLOPT_URL, $sUrlAudio);
    curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($oCurl, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $psToken"
    ]);
    $xAudio = curl_exec($oCurl);
    curl_close($oCurl);
    fpc_append($sEcoTxt, "sArquivoOgg=$sArquivoOgg");
    // Salva o udio
    if (!file_put_contents($sArquivoOgg, $xAudio)) {
        fpc_append($sEcoTxt, "Erro ao baixar o udio.");
        return false;
    }

    fpc_append($sEcoTxt, "Arquivo baixado: $sArquivoOgg");
    return $sArquivoOgg;
}

//
// Funo para converter udio OGG para MP3
function fsConverterParaMP3($psArquivoOgg, $psFrom) {
/////////////////////////////////////////////////////
    global $sEcoTxt;

    fpc_append($sEcoTxt, "Inicio fsConverterParaMP3");

    $sArquivoMp3 = "audios/{$psFrom}.mp3";

    // Comando FFmpeg para converso
    $sComando = "/usr/bin/ffmpeg -i $psArquivoOgg -ac 1 -ar 16000 -b:a 128k -f mp3 $sArquivoMp3";
    exec($sComando, $aOutput, $iReturnCode);

    if ($iReturnCode !== 0) {
        fpc_append($sEcoTxt, "Erro na converso do udio: return_code=$iReturnCode");
        return false;
    }

    fpc_append($sEcoTxt, "Arquivo convertido: $sArquivoMp3");
    return $sArquivoMp3;
}

//
// Funo para transcrever udio usando a API OpenAI (Whisper-1)
function fsTranscreverAudio($psArquivoMp3) {
////////////////////////////////////////////
    global $sEcoTxt;
    global $sApiKeyOpenAI;

    fpc_append($sEcoTxt, "Inicio fsTranscreverAudio");

    // Configura a requisio para a API OpenAI (Whisper-1)
    $oCurl = curl_init();
    curl_setopt($oCurl, CURLOPT_URL, "https://api.openai.com/v1/audio/transcriptions");
    curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($oCurl, CURLOPT_POST, true);
    curl_setopt($oCurl, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $sApiKeyOpenAI",
        "Content-Type: multipart/form-data"
    ]);
    curl_setopt($oCurl, CURLOPT_POSTFIELDS, [
        "file" => new CURLFile($psArquivoMp3),
        "model" => "whisper-1"
    ]);

    // Executa a requisio
    $sResposta = curl_exec($oCurl);
    curl_close($oCurl);

    // Converte a resposta para array
    $aResposta = json_decode($sResposta, true);

    // Retorna o texto transcrito ou erro
    $sTextoTranscrito = $aResposta["text"] ?? "Erro na transcrio.";
    fpc_append($sEcoTxt, "sTextoTranscrito=$sTextoTranscrito");

    fpc_append($sEcoTxt, "Fim fsTranscreverAudio");
    return $sTextoTranscrito;
}
