<?php

/*
use NFePHP\DA\NFe\Danfe;

$xml = file_get_contents('caminho/para/sua/nfe.xml');
$danfe = new Danfe($xml);
$id = $danfe->montaDANFE();
$pdf = $danfe->render();
file_put_contents('danfe.pdf', $pdf);
*/


error_reporting(E_ALL);
ini_set('display_errors', 'On');
require_once '../lib/nfephp-org/sped-da/bootstrap.php';
require_once '../lib/autoload.php';

use NFePHP\DA\NFe\Danfe;

//$xml = file_get_contents('35240915269433000114550010003468401968689432-nfe.xml');
$xml = file_get_contents('35240968418433000103550010003698011396585548-nfe.xml');

//$xml = file_get_contents(__DIR__ . '/fixtures/mod55-nfe_4.xml');

//$logo = 'data://text/plain;base64,'. base64_encode(file_get_contents(realpath(__DIR__ . '/../images/tulipas.png')));
//$logo = realpath(__DIR__ . '/../images/tulipas.png');

try {

    $danfe = new Danfe($xml);
    $danfe->exibirTextoFatura       = false;
    $danfe->exibirPIS               = false;
    $danfe->exibirIcmsInterestadual = false;
    $danfe->exibirValorTributos     = false;
    $danfe->descProdInfoComplemento = false;
    $danfe->exibirNumeroItemPedido  = false;
    $danfe->exibirValorICMSST       = true;  // Exibe a coluna Base de Clculo ICMS-ST
    $danfe->exibirValorProduto      = true;
    $danfe->setOcultarUnidadeTributavel(false);

$danfe->setCamposProdutos = array(
    'cProd',        // Cdigo do Produto
    'xProd',        // Descrio do Produto
    'qCom',         // Quantidade
    'vUnCom',       // Valor Unitrio
    'vProd',        // Valor Total do Produto
    'vBCST',        // Base de Clculo do ICMS-ST
    'vICMSST'       // Valor do ICMS-ST
);

    $danfe->obsContShow(false);
    $danfe->printParameters(
        $orientacao = 'P',
        $papel = 'A4',
        $margSup = 2,
        $margEsq = 2
    );
//    $danfe->logoParameters($logo, $logoAlign = 'C', $mode_bw = false);
    $danfe->setDefaultFont($font = 'times');
    $danfe->setDefaultDecimalPlaces(4);
    $danfe->debugMode(false);
    $danfe->creditsIntegratorFooter(utf8_encode('QTUX Tecnlogia da informao - https://www.plataformaqtux.com'));
    $pdf = $danfe->render($logo);
    header('Content-Type: application/pdf');
    echo $pdf;
} catch (InvalidArgumentException $e) {
    echo "Ocorreu um erro durante o processamento :" . $e->getMessage();
}
