<?php
set_time_limit(300);
ini_set("memory_limit","2400M");
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$sHOST = exec('hostname');
if ($sHOST == 'qtuxap.sanol.com.br') {
   $psCliPasta = 'total';
} else if ($sHOST=='homologqtuxweb.sanol.com.br') {
   $psCliPasta = 'total';
} else {
   $psCliPasta = 'desenvolvimento';
}

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoTxt = "/qtux/www/FullPlat/processos/logs/".str_replace('.','_',$sProc)."-".time().".log";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);
fpc($sEcoTxt,'Incio em ' . date('d/m/Y h:i:s',$tJobStart));
$aUserLog  = array();

$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";
fpc_append($sEcoTxt,$sFileConfig);

if (file_exists($sFileConfig)) {

   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLen = strlen($sLin);
      if ($iLen>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iCountaLin = count($aLin);
         if ($iCountaLin>1) $s2 = trim($aLin[1]);
         else               $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);
         $sVarsTxt .= $s . chr(10);
      }
   } // foreach ($aArr as $sLin)

   $sDSN = "$sHost:$sPathDB/$sDB";
   $hDb  = fhDbConnect($sDSN);

   $sSql = "
select a.sCodigo     CODIGO,
       a.sDescricao  ITEM,
       b.sCodigo     NCM,
       b.sDescricao  DESNCM
from Itens a join NCM b on a.pNCM = b.pPId and b.iVer=b.iVAt
where a.iVer=a.iVAt and a.lExc=0 and a.pUNEg = 3158
order by a.sCodigo
";

   fpc_append($sEcoTxt,"sSql=$sSql");

   $query = ibase_query($hDb, $sSql);

   // .. **Extrair os dados e os nomes das colunas**
   $aDb     = [];
   $colunas = [];

   while ($row = ibase_fetch_assoc($query)) {
       if (empty($colunas)) {
           $colunas = array_keys($row); // Pega os nomes das colunas uma nica vez
       }
       $aDb[] = $row;
   }

   ibase_free_result($query);
   ibase_close($hDb);

   require('/qtux/library/PHPExcel-1.8/Classes/PHPExcel.php');

   $oPHPExcel = new PHPExcel();
   $oSheet = $oPHPExcel->setActiveSheetIndex(0);
   
   // .. **Criar cabealho automaticamente**
   $colIndex = 0;
   foreach ($colunas as $coluna) {
       $colLetra = PHPExcel_Cell::stringFromColumnIndex($colIndex); // Converte ndice numrico em letra (A, B, C...)
       $oSheet->setCellValue($colLetra . '1', strtoupper($coluna)); // Define o cabealho na primeira linha
       $oSheet->getColumnDimension($colLetra)->setAutoSize(true); // Ajusta o tamanho da coluna
       $colIndex++;
   }

   // .. **Aplicar estilo em negrito no cabealho**
   $oSheet->getStyle('A1:' . PHPExcel_Cell::stringFromColumnIndex($colIndex - 1) . '1')->getFont()->setBold(true);

   // .. **Preencher os valores dinamicamente**
   $i = 2; // Comea na linha 2
   foreach ($aDb as $aLin) {
       $colIndex = 0;
       foreach ($colunas as $coluna) {
           $colLetra = PHPExcel_Cell::stringFromColumnIndex($colIndex);
           $valor = strtoupper(fsTiraAcento(trim($aLin[$coluna]))); // Remove acentos e formata
           $oSheet->setCellValue($colLetra . $i, utf8_decode($valor));
           $colIndex++;
       }
       $i++;
   }

   $sNomeArquivo = 'RELACAO_'.time().'.xls';

   $oPHPExcel->getActiveSheet()->setTitle(utf8_decode('RELACAO'));

   header('Content-Type: application/vnd.ms-excel');
   header("Content-Disposition: attachment; filename=\"{$sNomeArquivo}\"");
   header('Cache-Control: max-age=0');
   header('Cache-Control: max-age=1');

   $oWriter = PHPExcel_IOFactory::createWriter($oPHPExcel,'Excel5');
   $oWriter->save('php://output');

   echo $sNomeArquivo;

} // if (file_exists($sFileConfig))